/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.scm;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import org.apache.commons.lang.StringUtils;
import org.picocontainer.Startable;
import org.sonar.api.Properties;
import org.sonar.api.Property;
import org.sonar.api.PropertyType;
import org.sonar.api.batch.AnalysisMode;
import org.sonar.api.batch.scm.ScmProvider;
import org.sonar.api.config.Configuration;
import org.sonar.api.notifications.AnalysisWarnings;
import org.sonar.api.utils.MessageException;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.scanner.fs.InputModuleHierarchy;

@Properties(value={@Property(key="sonar.scm.forceReloadAll", defaultValue="false", name="Force reloading of SCM information for all files", description="By default only files modified since previous analysis are inspected. Set this parameter to true to force the reloading.", category="scm", project=false, module=false, global=false, type=PropertyType.BOOLEAN)})
public class ScmConfiguration
implements Startable {
    private static final Logger LOG = Loggers.get(ScmConfiguration.class);
    public static final String FORCE_RELOAD_KEY = "sonar.scm.forceReloadAll";
    static final String MESSAGE_SCM_STEP_IS_DISABLED_BY_CONFIGURATION = "SCM Step is disabled by configuration";
    static final String MESSAGE_SCM_EXCLUSIONS_IS_DISABLED_BY_CONFIGURATION = "Exclusions based on SCM info is disabled by configuration";
    private final Configuration settings;
    private final AnalysisWarnings analysisWarnings;
    private final Map<String, ScmProvider> providerPerKey = new LinkedHashMap<String, ScmProvider>();
    private final AnalysisMode analysisMode;
    private final InputModuleHierarchy moduleHierarchy;
    private ScmProvider provider;

    public ScmConfiguration(InputModuleHierarchy moduleHierarchy, AnalysisMode analysisMode, Configuration settings, AnalysisWarnings analysisWarnings, ScmProvider ... providers) {
        this.moduleHierarchy = moduleHierarchy;
        this.analysisMode = analysisMode;
        this.settings = settings;
        this.analysisWarnings = analysisWarnings;
        for (ScmProvider scmProvider : providers) {
            this.providerPerKey.put(scmProvider.key(), scmProvider);
        }
    }

    public ScmConfiguration(InputModuleHierarchy moduleHierarchy, AnalysisMode analysisMode, Configuration settings, AnalysisWarnings analysisWarnings) {
        this(moduleHierarchy, analysisMode, settings, analysisWarnings, new ScmProvider[0]);
    }

    @Override
    public void start() {
        if (this.analysisMode.isIssues()) {
            return;
        }
        if (this.isDisabled()) {
            LOG.debug(MESSAGE_SCM_STEP_IS_DISABLED_BY_CONFIGURATION);
            return;
        }
        if (this.settings.hasKey("sonar.scm.provider")) {
            this.settings.get("sonar.scm.provider").ifPresent(this::setProviderIfSupported);
        } else {
            this.autodetection();
            if (this.provider == null) {
                this.considerOldScmUrl();
            }
            if (this.provider == null) {
                String message = "SCM provider autodetection failed. Please use \"sonar.scm.provider\" to define SCM of your project, or disable the SCM Sensor in the project settings.";
                LOG.warn(message);
                this.analysisWarnings.addUnique(message);
            }
        }
        if (this.isExclusionDisabled()) {
            LOG.info(MESSAGE_SCM_EXCLUSIONS_IS_DISABLED_BY_CONFIGURATION);
        }
    }

    private void setProviderIfSupported(String forcedProviderKey) {
        if (!this.providerPerKey.containsKey(forcedProviderKey)) {
            String supportedProviders = this.providerPerKey.isEmpty() ? "No SCM provider installed" : "Supported SCM providers are " + this.providerPerKey.keySet().stream().collect(Collectors.joining(","));
            throw new IllegalArgumentException("SCM provider was set to \"" + forcedProviderKey + "\" but no SCM provider found for this key. " + supportedProviders);
        }
        this.provider = this.providerPerKey.get(forcedProviderKey);
    }

    private void considerOldScmUrl() {
        this.settings.get("sonar.links.scm_dev").ifPresent(url -> {
            String[] split;
            if (StringUtils.startsWith(url, "scm:") && (split = url.split(":")).length > 1) {
                this.setProviderIfSupported(split[1]);
            }
        });
    }

    private void autodetection() {
        for (ScmProvider installedProvider : this.providerPerKey.values()) {
            if (!installedProvider.supports(this.moduleHierarchy.root().getBaseDir().toFile())) continue;
            if (this.provider == null) {
                this.provider = installedProvider;
                continue;
            }
            throw MessageException.of("SCM provider autodetection failed. Both " + this.provider.key() + " and " + installedProvider.key() + " claim to support this project. Please use \"" + "sonar.scm.provider" + "\" to define SCM of your project.");
        }
    }

    @CheckForNull
    public ScmProvider provider() {
        return this.provider;
    }

    public boolean isDisabled() {
        return this.settings.getBoolean("sonar.scm.disabled").orElse(false);
    }

    public boolean isExclusionDisabled() {
        return this.isDisabled() || this.settings.getBoolean("sonar.scm.exclusions.disabled").orElse(false) != false;
    }

    public boolean forceReloadAll() {
        return this.settings.getBoolean(FORCE_RELOAD_KEY).orElse(false);
    }

    @Override
    public void stop() {
    }
}

