/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.go.externalreport;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.sonar.api.notifications.AnalysisWarnings;
import org.sonar.api.rules.RuleType;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.go.externalreport.AbstractReportSensor;
import org.sonar.go.externalreport.ExternalIssue;

public class GoMetaLinterReportSensor
extends AbstractReportSensor {
    private static final Logger LOG = Loggers.get(GoMetaLinterReportSensor.class);
    public static final String PROPERTY_KEY = "sonar.go.gometalinter.reportPaths";
    private static final Pattern GO_META_LINTER_REGEX = Pattern.compile("(?<file>[^:]+):(?<line>\\d+):\\d*:(?<severity>(error|warning)):(?<message>.*)\\((?<linter>[^\\(]*)\\)");
    private static final Pattern RULE_KEY_REGEX = Pattern.compile("\\((?<ruleKey>[A-Za-z0-9_-]{1,20})\\)$");

    public GoMetaLinterReportSensor(AnalysisWarnings analysisWarnings) {
        super(analysisWarnings, "gometalinter", "GoMetaLinter", PROPERTY_KEY);
    }

    @Override
    @Nullable
    ExternalIssue parse(String line) {
        Matcher matcher = GO_META_LINTER_REGEX.matcher(line);
        if (matcher.matches()) {
            String linter = GoMetaLinterReportSensor.mapLinterName(matcher.group("linter").trim());
            RuleType type = "error".equals(matcher.group("severity")) ? RuleType.BUG : RuleType.CODE_SMELL;
            String filename = matcher.group("file").trim();
            int lineNumber = Integer.parseInt(matcher.group("line").trim());
            String message = matcher.group("message").trim();
            Matcher ruleKeyMatcher = RULE_KEY_REGEX.matcher(message);
            String ruleKey = null;
            if (ruleKeyMatcher.find()) {
                ruleKey = ruleKeyMatcher.group("ruleKey");
                message = message.substring(0, ruleKeyMatcher.start()).trim();
            }
            return new ExternalIssue(linter, type, ruleKey, filename, lineNumber, message);
        }
        LOG.debug(this.logPrefix() + "Unexpected line: " + line);
        return null;
    }

    private static String mapLinterName(String linter) {
        if ("vet".equals(linter)) {
            return "govet";
        }
        return linter;
    }
}

