/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.updatecenter.common;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.sonar.updatecenter.common.Artifact;
import org.sonar.updatecenter.common.Version;

public class Release
implements Comparable<Release> {
    private Artifact artifact;
    private Version version;
    private String displayVersion;
    private String description;
    private URL changelogUrl;
    private boolean isPublic;
    private boolean isArchived;
    private String groupId;
    private String artifactId;
    private EnumMap<Edition, URL> downloadUrl;
    private HashMap<String, Integer> scannerDownloadUrlOrder;
    private HashMap<String, URL> scannerDownloadUrl;
    private HashMap<String, String> scannerDownloadFlavor;
    private Set<Release> outgoingDependencies;
    private Set<Release> incomingDependencies;
    private SortedSet<Version> compatibleSqVersions;
    private Date date;

    public Release(Artifact artifact, Version version) {
        this.artifact = artifact;
        this.version = version;
        this.isPublic = true;
        this.isArchived = false;
        this.downloadUrl = new EnumMap(Edition.class);
        this.compatibleSqVersions = new TreeSet<Version>();
        this.outgoingDependencies = new HashSet<Release>();
        this.incomingDependencies = new HashSet<Release>();
        this.scannerDownloadFlavor = new HashMap();
        this.scannerDownloadUrl = new HashMap();
        this.scannerDownloadUrlOrder = new HashMap();
    }

    public Release(Artifact artifact, String version) {
        this(artifact, Version.create(version));
    }

    private static URL toUrl(@Nullable String downloadUrlString) {
        URL transformedDownloadUrl = null;
        if (downloadUrlString != null) {
            try {
                transformedDownloadUrl = new URI(downloadUrlString).toURL();
            }
            catch (MalformedURLException | URISyntaxException ex) {
                throw new IllegalArgumentException("downloadUrl invalid", ex);
            }
        }
        return transformedDownloadUrl;
    }

    public Artifact getArtifact() {
        return this.artifact;
    }

    public Version getVersion() {
        return this.version;
    }

    public Release setVersion(Version version) {
        this.version = version;
        return this;
    }

    public String getDisplayVersion() {
        return this.displayVersion;
    }

    public Release setDisplayVersion(String displayVersion) {
        this.displayVersion = displayVersion;
        return this;
    }

    public boolean hasDownloadUrl() {
        return this.downloadUrl.size() > 0 || this.scannerDownloadUrl.size() > 0;
    }

    @CheckForNull
    public String getDownloadUrl() {
        return this.getDownloadUrl(Edition.COMMUNITY);
    }

    public Release setDownloadUrl(@Nullable String downloadUrlString) {
        return this.setDownloadUrl(downloadUrlString, Edition.COMMUNITY);
    }

    @CheckForNull
    public String getDownloadUrl(Edition edition) {
        URL value = this.downloadUrl.get((Object)edition);
        return value == null ? null : value.toString();
    }

    public Release setDownloadUrl(@Nullable String downloadUrlString, Edition edition) {
        URL transformedDownloadUrl = Release.toUrl(downloadUrlString);
        this.downloadUrl.put(edition, transformedDownloadUrl);
        return this;
    }

    public List<Map.Entry<String, URL>> getScannerDownloadUrl() {
        ArrayList<Map.Entry<String, URL>> list = new ArrayList<Map.Entry<String, URL>>();
        list.addAll(this.scannerDownloadUrl.entrySet());
        list.sort(Comparator.comparingInt(entry -> this.scannerDownloadUrlOrder.get(entry.getKey())));
        return list;
    }

    public Release addScannerDownloadUrlAndLabel(String flavor, String label, @Nullable String downloadUrl, int order) {
        URL transformedDownloadUrl = Release.toUrl(downloadUrl);
        this.scannerDownloadUrl.put(flavor, transformedDownloadUrl);
        this.scannerDownloadFlavor.put(flavor, label);
        this.scannerDownloadUrlOrder.put(flavor, order);
        return this;
    }

    @CheckForNull
    public String getFlavorLabel(String flavor) {
        return this.scannerDownloadFlavor.get(flavor);
    }

    @CheckForNull
    public String getFilename() {
        return this.getFilename(Edition.COMMUNITY);
    }

    @CheckForNull
    public String getFilename(Edition edition) {
        URL value = this.downloadUrl.get((Object)edition);
        return value == null ? null : StringUtils.substringAfterLast(value.getPath(), "/");
    }

    public SortedSet<Version> getRequiredSonarVersions() {
        return this.compatibleSqVersions;
    }

    public boolean supportSonarVersion(Version providedSqVersion) {
        for (Version sqVersion : this.compatibleSqVersions) {
            if (!sqVersion.isCompatibleWith(providedSqVersion)) continue;
            return true;
        }
        return false;
    }

    public Release addRequiredSonarVersions(Version ... versions) {
        if (versions != null) {
            this.compatibleSqVersions.addAll(Arrays.asList(versions));
        }
        return this;
    }

    public Release addRequiredSonarVersions(String ... versions) {
        if (versions != null) {
            for (String v : versions) {
                this.compatibleSqVersions.add(Version.create(v));
            }
        }
        return this;
    }

    public Version getLastRequiredSonarVersion() {
        if (!this.compatibleSqVersions.isEmpty()) {
            return this.compatibleSqVersions.last();
        }
        return null;
    }

    public Version getMinimumRequiredSonarVersion() {
        if (!this.compatibleSqVersions.isEmpty()) {
            return this.compatibleSqVersions.first();
        }
        return null;
    }

    public Version[] getSonarVersionFromString(String fromString) {
        Collection versionsWGivenFromString = this.compatibleSqVersions.stream().filter(Objects::nonNull).filter(sqVersion -> fromString.equals(sqVersion.getFromString())).collect(Collectors.toSet());
        return versionsWGivenFromString.toArray(new Version[versionsWGivenFromString.size()]);
    }

    @CheckForNull
    public Date getDate() {
        return this.date != null ? new Date(this.date.getTime()) : null;
    }

    public Release setDate(@Nullable Date date) {
        this.date = date != null ? new Date(date.getTime()) : null;
        return this;
    }

    @CheckForNull
    public String getDescription() {
        return this.description;
    }

    public Release setDescription(@Nullable String description) {
        this.description = description;
        return this;
    }

    @CheckForNull
    public String getChangelogUrl() {
        return this.changelogUrl == null ? null : this.changelogUrl.toString();
    }

    public Release setChangelogUrl(@Nullable String changelogUrlString) {
        if (changelogUrlString == null) {
            this.changelogUrl = null;
        } else {
            try {
                this.changelogUrl = new URI(changelogUrlString).toURL();
            }
            catch (MalformedURLException | URISyntaxException ex) {
                throw new IllegalArgumentException("changelogUrl invalid", ex);
            }
        }
        return this;
    }

    public Set<Release> getOutgoingDependencies() {
        return Collections.unmodifiableSet(new HashSet<Release>(this.outgoingDependencies));
    }

    public Release addOutgoingDependency(Release required) {
        this.outgoingDependencies.add(required);
        return this;
    }

    public Set<Release> getIncomingDependencies() {
        return Collections.unmodifiableSet(new HashSet<Release>(this.incomingDependencies));
    }

    public Release addIncomingDependency(Release required) {
        this.incomingDependencies.add(required);
        return this;
    }

    public String getKey() {
        return this.getArtifact().getKey();
    }

    public Version getAdjustedVersion() {
        return this.version.removeQualifier();
    }

    public boolean isPublic() {
        return this.isPublic;
    }

    public void setPublic(boolean isPublic) {
        this.isPublic = isPublic;
    }

    public boolean isArchived() {
        return this.isArchived;
    }

    public void setArchived(boolean isArchived) {
        this.isArchived = isArchived;
    }

    @CheckForNull
    public String groupId() {
        return this.groupId;
    }

    public void setGroupId(@Nullable String groupId) {
        this.groupId = groupId;
    }

    @CheckForNull
    public String artifactId() {
        return this.artifactId;
    }

    public void setArtifactId(@Nullable String artifactId) {
        this.artifactId = artifactId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Release release = (Release)o;
        return this.artifact.equals(release.artifact) && this.version.equals(release.version);
    }

    public int hashCode() {
        int result = this.artifact.hashCode();
        result = 31 * result + this.version.hashCode();
        return result;
    }

    public String toString() {
        return new ToStringBuilder(this).append("version", this.version).append("downloadUrl", this.downloadUrl).append("changelogUrl", this.changelogUrl).append("description", this.description).toString();
    }

    @Override
    public int compareTo(Release o) {
        return this.getVersion().compareTo(o.getVersion());
    }

    public static enum Edition {
        COMMUNITY,
        DEVELOPER,
        ENTERPRISE,
        DATACENTER;

    }
}

