/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.cloudformation.checks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.iac.cloudformation.checks.AbstractResourceCheck;
import org.sonar.iac.cloudformation.checks.utils.XPathUtils;
import org.sonar.iac.cloudformation.tree.FunctionCallTree;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.checks.IacCheck;
import org.sonar.iac.common.api.checks.InitContext;
import org.sonar.iac.common.api.checks.SecondaryLocation;
import org.sonar.iac.common.api.tree.HasTextRange;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.common.checks.PropertyUtils;
import org.sonar.iac.common.checks.TextUtils;
import org.sonar.iac.common.yaml.YamlTreeUtils;
import org.sonar.iac.common.yaml.tree.FileTree;
import org.sonar.iac.common.yaml.tree.MappingTree;
import org.sonar.iac.common.yaml.tree.ScalarTree;
import org.sonar.iac.common.yaml.tree.SequenceTree;
import org.sonar.iac.common.yaml.tree.YamlTree;

@Rule(key="S6249")
public class BucketsInsecureHttpCheck
implements IacCheck {
    private static final String MESSAGE = "Make sure authorizing HTTP requests is safe here.";
    private static final String MESSAGE_SECONDARY_EFFECT = "Non-conforming requests should be denied.";
    private static final String MESSAGE_SECONDARY_CONDITION = "HTTPS requests are denied.";
    private static final String MESSAGE_SECONDARY_PRINCIPAL = "All principals should be restricted.";
    private static final String MESSAGE_SECONDARY_ACTION = "All S3 actions should be restricted.";
    private static final String MESSAGE_SECONDARY_RESOURCE = "All resources should be restricted.";

    @Override
    public void initialize(InitContext init) {
        init.register(FileTree.class, (ctx, tree) -> {
            ArrayList<AbstractResourceCheck.Resource> buckets = new ArrayList<AbstractResourceCheck.Resource>();
            ArrayList<AbstractResourceCheck.Resource> policies = new ArrayList<AbstractResourceCheck.Resource>();
            AbstractResourceCheck.getFileResources(tree).forEach(r -> {
                if (AbstractResourceCheck.isS3Bucket(r)) {
                    buckets.add((AbstractResourceCheck.Resource)r);
                } else if (r.isType("AWS::S3::BucketPolicy")) {
                    policies.add((AbstractResourceCheck.Resource)r);
                }
            });
            BucketsInsecureHttpCheck.checkBucketsAndPolicies(ctx, BucketsInsecureHttpCheck.bucketsToPolicies(buckets, policies));
        });
    }

    private static void checkBucketsAndPolicies(CheckContext ctx, Map<AbstractResourceCheck.Resource, AbstractResourceCheck.Resource> bucketsToPolicies) {
        for (Map.Entry<AbstractResourceCheck.Resource, AbstractResourceCheck.Resource> bucketToPolicy : bucketsToPolicies.entrySet()) {
            if (bucketToPolicy.getValue() == null) {
                ctx.reportIssue(bucketToPolicy.getKey().type(), MESSAGE);
                continue;
            }
            BucketsInsecureHttpCheck.checkBucketPolicy(ctx, bucketToPolicy.getKey(), bucketToPolicy.getValue());
        }
    }

    private static void checkBucketPolicy(CheckContext ctx, AbstractResourceCheck.Resource bucket, AbstractResourceCheck.Resource policy) {
        Map<YamlTree, String> insecureValues = PolicyValidator.getInsecureValues(policy);
        if (!insecureValues.isEmpty()) {
            List<SecondaryLocation> secondaryLocations = insecureValues.entrySet().stream().map(e -> new SecondaryLocation((HasTextRange)e.getKey(), (String)e.getValue())).collect(Collectors.toList());
            ctx.reportIssue((HasTextRange)bucket.type(), MESSAGE, secondaryLocations);
        }
    }

    private static Map<AbstractResourceCheck.Resource, AbstractResourceCheck.Resource> bucketsToPolicies(List<AbstractResourceCheck.Resource> buckets, List<AbstractResourceCheck.Resource> policies) {
        HashMap bucketIdToPolicies = new HashMap();
        for (AbstractResourceCheck.Resource policy : policies) {
            PropertyUtils.value(policy.properties(), "Bucket", YamlTree.class).ifPresent(b -> bucketIdToPolicies.put(b, policy));
        }
        HashMap<AbstractResourceCheck.Resource, AbstractResourceCheck.Resource> result = new HashMap<AbstractResourceCheck.Resource, AbstractResourceCheck.Resource>();
        for (AbstractResourceCheck.Resource bucket : buckets) {
            AbstractResourceCheck.Resource policy = bucketIdToPolicies.entrySet().stream().filter(e -> BucketsInsecureHttpCheck.correspondsToBucket((YamlTree)e.getKey(), bucket)).map(Map.Entry::getValue).findFirst().orElse(null);
            result.put(bucket, policy);
        }
        return result;
    }

    private static boolean correspondsToBucket(@Nullable YamlTree policyBucketId, AbstractResourceCheck.Resource bucket) {
        if (policyBucketId instanceof FunctionCallTree && BucketsInsecureHttpCheck.isReferringFunction((FunctionCallTree)policyBucketId)) {
            return ((FunctionCallTree)policyBucketId).arguments().stream().map(TextUtils::getValue).flatMap(Optional::stream).anyMatch(argument -> TextUtils.isValue(bucket.name(), argument).isTrue());
        }
        if (policyBucketId instanceof FunctionCallTree && BucketsInsecureHttpCheck.isJoin((FunctionCallTree)policyBucketId)) {
            return ((FunctionCallTree)policyBucketId).arguments().stream().map(YamlTreeUtils::getListValueElements).flatMap(Collection::stream).filter(elem -> !"".equals(elem)).anyMatch(elementValue -> BucketsInsecureHttpCheck.getNameOfBucket(bucket).equals(elementValue));
        }
        if (policyBucketId instanceof ScalarTree) {
            return PropertyUtils.value(bucket.properties(), "BucketName", YamlTree.class).filter(bucketName -> TextUtils.isValue(bucketName, ((ScalarTree)policyBucketId).value()).isTrue()).isPresent();
        }
        return false;
    }

    private static boolean isReferringFunction(FunctionCallTree functionCall) {
        Set<String> referringFunctions = Set.of("Ref", "Sub");
        return referringFunctions.contains(functionCall.name());
    }

    private static boolean isJoin(FunctionCallTree functionCall) {
        return functionCall.name().contains("Join");
    }

    private static String getNameOfBucket(AbstractResourceCheck.Resource bucket) {
        return PropertyUtils.value((Tree)bucket.properties(), "BucketName").flatMap(TextUtils::getValue).orElse("");
    }

    private static class PolicyValidator {
        private PolicyValidator() {
        }

        private static Map<YamlTree, String> getInsecureValues(AbstractResourceCheck.Resource policy) {
            Optional<YamlTree> statement;
            HashMap<YamlTree, String> result = new HashMap<YamlTree, String>();
            YamlTree properties = policy.properties();
            if (properties != null && (statement = XPathUtils.getSingleTree(properties, "/PolicyDocument/Statement[]")).isPresent()) {
                XPathUtils.getSingleTree(statement.get(), "/Effect").filter(PolicyValidator::isInsecureEffect).ifPresent(t -> result.put((YamlTree)t, BucketsInsecureHttpCheck.MESSAGE_SECONDARY_EFFECT));
                XPathUtils.getSingleTree(statement.get(), "/Condition/Bool/aws:SecureTransport").filter(PolicyValidator::isInsecureCondition).ifPresent(t -> result.put((YamlTree)t, BucketsInsecureHttpCheck.MESSAGE_SECONDARY_CONDITION));
                XPathUtils.getSingleTree(statement.get(), "/Action").filter(PolicyValidator::isInsecureAction).ifPresent(t -> result.put((YamlTree)t, BucketsInsecureHttpCheck.MESSAGE_SECONDARY_ACTION));
                XPathUtils.getSingleTree(statement.get(), "/Principal").filter(PolicyValidator::isInsecurePrincipal).ifPresent(t -> result.put((YamlTree)t, BucketsInsecureHttpCheck.MESSAGE_SECONDARY_PRINCIPAL));
                XPathUtils.getSingleTree(statement.get(), "/Resource").filter(PolicyValidator::isInsecureResource).ifPresent(t -> result.put((YamlTree)t, BucketsInsecureHttpCheck.MESSAGE_SECONDARY_RESOURCE));
            }
            return result;
        }

        private static boolean isInsecureResource(YamlTree resource) {
            FunctionCallTree joinCall;
            YamlTree listOfValues;
            if (resource instanceof FunctionCallTree && "Join".equals(((FunctionCallTree)resource).name()) && ((FunctionCallTree)resource).arguments().size() == 2 && (listOfValues = (joinCall = (FunctionCallTree)resource).arguments().get(1)) instanceof SequenceTree) {
                SequenceTree sequence = (SequenceTree)listOfValues;
                return sequence.elements().isEmpty() || PolicyValidator.isInsecureResource(sequence.elements().get(sequence.elements().size() - 1));
            }
            return !(resource instanceof ScalarTree) || !((ScalarTree)resource).value().endsWith("*");
        }

        private static boolean isInsecurePrincipal(YamlTree principal) {
            Tree valueToCheck = principal;
            if (principal instanceof MappingTree) {
                valueToCheck = PropertyUtils.valueOrNull(principal, "AWS");
            }
            return !TextUtils.isValue(valueToCheck, "*").isTrue();
        }

        private static boolean isInsecureAction(YamlTree action) {
            return !TextUtils.isValue(action, "*").isTrue() && !TextUtils.isValue(action, "s3:*").isTrue();
        }

        private static boolean isInsecureCondition(YamlTree condition) {
            return TextUtils.isValue(condition, "true").isTrue();
        }

        private static boolean isInsecureEffect(YamlTree effect) {
            return TextUtils.isValue(effect, "Allow").isTrue();
        }
    }
}

