/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import org.jetbrains.annotations.NotNull;
import org.sonarsource.kotlin.api.FunMatcherImpl;
import org.sonarsource.kotlin.api.FunMatcherKt;
import org.sonarsource.kotlin.checks.ClearTextProtocolCheckKt;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\u001a\u0018\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0003H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00030\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"ANDROID_SET_MIXED_CONTENT_MODE", "Lorg/sonarsource/kotlin/api/FunMatcherImpl;", "CLEARTEXT_FQN", "", "MESSAGE_ANDROID_MIXED_CONTENT", "MIXED_CONTENT_ALWAYS_ALLOW", "", "UNSAFE_CALLS_GENERAL", "", "UNSAFE_CALLS_OK_HTTP", "", "msg", "insecure", "replaceWith", "sonar-kotlin-plugin"})
public final class ClearTextProtocolCheckKt {
    @NotNull
    private static final String CLEARTEXT_FQN = "okhttp3.ConnectionSpec.Companion.CLEARTEXT";
    @NotNull
    private static final String MESSAGE_ANDROID_MIXED_CONTENT = "Using a relaxed mixed content policy is security-sensitive.";
    private static final int MIXED_CONTENT_ALWAYS_ALLOW = 0;
    @NotNull
    private static final Map<FunMatcherImpl, String> UNSAFE_CALLS_GENERAL;
    @NotNull
    private static final List<FunMatcherImpl> UNSAFE_CALLS_OK_HTTP;
    @NotNull
    private static final FunMatcherImpl ANDROID_SET_MIXED_CONTENT_MODE;

    private static final String msg(String insecure, String replaceWith) {
        return "Using " + insecure + " is insecure. Use " + replaceWith + " instead.";
    }

    public static final /* synthetic */ Map access$getUNSAFE_CALLS_GENERAL$p() {
        return UNSAFE_CALLS_GENERAL;
    }

    public static final /* synthetic */ List access$getUNSAFE_CALLS_OK_HTTP$p() {
        return UNSAFE_CALLS_OK_HTTP;
    }

    public static final /* synthetic */ FunMatcherImpl access$getANDROID_SET_MIXED_CONTENT_MODE$p() {
        return ANDROID_SET_MIXED_CONTENT_MODE;
    }

    public static final /* synthetic */ String access$msg(String insecure, String replaceWith) {
        return ClearTextProtocolCheckKt.msg(insecure, replaceWith);
    }

    static {
        Object[] objectArray = new Pair[]{TuplesKt.to(FunMatcherKt.ConstructorMatcher$default("org.apache.commons.net.ftp.FTPClient", null, null, 6, null), ClearTextProtocolCheckKt.msg("FTP", "SFTP, SCP or FTPS")), TuplesKt.to(FunMatcherKt.ConstructorMatcher$default("org.apache.commons.net.smtp.SMTPClient", null, null, 6, null), ClearTextProtocolCheckKt.msg("clear-text SMTP", "SMTP over SSL/TLS or SMTP with STARTTLS")), TuplesKt.to(FunMatcherKt.ConstructorMatcher$default("org.apache.commons.net.telnet.TelnetClient", null, null, 6, null), ClearTextProtocolCheckKt.msg("Telnet", "SSH"))};
        UNSAFE_CALLS_GENERAL = MapsKt.mapOf(objectArray);
        objectArray = new FunMatcherImpl[]{FunMatcherKt.ConstructorMatcher$default("okhttp3.ConnectionSpec.Builder", null, null, 6, null), FunMatcherKt.FunMatcher$default("okhttp3.OkHttpClient.Builder", "connectionSpecs", null, null, null, null, false, null, null, null, null, null, 4092, null)};
        UNSAFE_CALLS_OK_HTTP = CollectionsKt.listOf(objectArray);
        ANDROID_SET_MIXED_CONTENT_MODE = FunMatcherKt.FunMatcher$default(null, "setMixedContentMode", null, null, null, "android.webkit.WebSettings", false, null, null, null, null, ANDROID_SET_MIXED_CONTENT_MODE.1.INSTANCE, 2013, null);
    }
}

