/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.snapshots;

import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.StepListener;
import org.elasticsearch.action.admin.cluster.snapshots.clone.CloneSnapshotRequest;
import org.elasticsearch.action.admin.cluster.snapshots.create.CreateSnapshotRequest;
import org.elasticsearch.action.admin.cluster.snapshots.delete.DeleteSnapshotRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.ContextPreservingActionListener;
import org.elasticsearch.action.support.GroupedActionListener;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateApplier;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.ClusterStateTaskListener;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.NotMasterException;
import org.elasticsearch.cluster.RepositoryCleanupInProgress;
import org.elasticsearch.cluster.RestoreInProgress;
import org.elasticsearch.cluster.SnapshotDeletionsInProgress;
import org.elasticsearch.cluster.SnapshotsInProgress;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.coordination.FailedToCommitClusterStateException;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.cluster.metadata.DataStreamAlias;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.RepositoriesMetadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.core.CheckedConsumer;
import org.elasticsearch.core.List;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.SystemDataStreamDescriptor;
import org.elasticsearch.indices.SystemIndices;
import org.elasticsearch.repositories.FinalizeSnapshotContext;
import org.elasticsearch.repositories.IndexId;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.repositories.Repository;
import org.elasticsearch.repositories.RepositoryData;
import org.elasticsearch.repositories.RepositoryException;
import org.elasticsearch.repositories.RepositoryMissingException;
import org.elasticsearch.repositories.RepositoryShardId;
import org.elasticsearch.repositories.ShardGeneration;
import org.elasticsearch.repositories.ShardGenerations;
import org.elasticsearch.repositories.ShardSnapshotResult;
import org.elasticsearch.snapshots.ConcurrentSnapshotExecutionException;
import org.elasticsearch.snapshots.InFlightShardSnapshotStates;
import org.elasticsearch.snapshots.InvalidSnapshotNameException;
import org.elasticsearch.snapshots.RestoreService;
import org.elasticsearch.snapshots.Snapshot;
import org.elasticsearch.snapshots.SnapshotException;
import org.elasticsearch.snapshots.SnapshotFeatureInfo;
import org.elasticsearch.snapshots.SnapshotId;
import org.elasticsearch.snapshots.SnapshotInfo;
import org.elasticsearch.snapshots.SnapshotMissingException;
import org.elasticsearch.snapshots.SnapshotShardFailure;
import org.elasticsearch.snapshots.SnapshotUtils;
import org.elasticsearch.snapshots.UpdateIndexShardSnapshotStatusRequest;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xcontent.ToXContent;

public class SnapshotsService
extends AbstractLifecycleComponent
implements ClusterStateApplier {
    public static final Version NO_REPO_INITIALIZE_VERSION = Version.V_7_5_0;
    public static final Version FULL_CONCURRENCY_VERSION = Version.V_7_9_0;
    public static final Version CLONE_SNAPSHOT_VERSION = Version.V_7_10_0;
    public static final Version SHARD_GEN_IN_REPO_DATA_VERSION = Version.V_7_6_0;
    public static final Version INDEX_GEN_IN_REPO_DATA_VERSION = Version.V_7_9_0;
    public static final Version UUIDS_IN_REPO_DATA_VERSION = Version.V_7_12_0;
    public static final Version FILE_INFO_WRITER_UUIDS_IN_SHARD_DATA_VERSION = Version.CURRENT;
    public static final Version OLD_SNAPSHOT_FORMAT = Version.V_7_5_0;
    public static final Version MULTI_DELETE_VERSION = Version.V_7_8_0;
    public static final Version FEATURE_STATES_VERSION = Version.V_7_12_0;
    public static final Version INDEX_DETAILS_INTRODUCED = Version.V_7_13_0;
    public static final String POLICY_ID_METADATA_FIELD = "policy";
    private static final Logger logger = LogManager.getLogger(SnapshotsService.class);
    public static final String UPDATE_SNAPSHOT_STATUS_ACTION_NAME = "internal:cluster/snapshot/update_snapshot_status";
    public static final String NO_FEATURE_STATES_VALUE = "none";
    private final ClusterService clusterService;
    private final IndexNameExpressionResolver indexNameExpressionResolver;
    private final RepositoriesService repositoriesService;
    private final ThreadPool threadPool;
    private final Map<Snapshot, java.util.List<ActionListener<Tuple<RepositoryData, SnapshotInfo>>>> snapshotCompletionListeners = new ConcurrentHashMap<Snapshot, java.util.List<ActionListener<Tuple<RepositoryData, SnapshotInfo>>>>();
    private final Set<Snapshot> initializingSnapshots = Collections.synchronizedSet(new HashSet());
    private final Map<String, java.util.List<ActionListener<Void>>> snapshotDeletionListeners = new HashMap<String, java.util.List<ActionListener<Void>>>();
    private final Set<String> currentlyFinalizing = Collections.synchronizedSet(new HashSet());
    private final Set<Snapshot> endingSnapshots = Collections.synchronizedSet(new HashSet());
    private final Set<Snapshot> initializingClones = Collections.synchronizedSet(new HashSet());
    private final UpdateSnapshotStatusAction updateSnapshotStatusHandler;
    private final TransportService transportService;
    private final OngoingRepositoryOperations repositoryOperations = new OngoingRepositoryOperations();
    private final Map<String, SystemIndices.Feature> systemIndexDescriptorMap;
    public static final Setting<Integer> MAX_CONCURRENT_SNAPSHOT_OPERATIONS_SETTING = Setting.intSetting("snapshot.max_concurrent_operations", 1000, 1, Setting.Property.NodeScope, Setting.Property.Dynamic);
    private volatile int maxConcurrentOperations;
    private final Set<RepositoryShardId> currentlyCloning = Collections.synchronizedSet(new HashSet());
    static final ClusterStateTaskExecutor<ShardSnapshotUpdate> SHARD_STATE_EXECUTOR = (currentState, tasks) -> ClusterStateTaskExecutor.ClusterTasksResult.builder().successes(tasks).build(new SnapshotShardsUpdateContext(currentState, tasks).computeUpdatedState());

    public SnapshotsService(Settings settings, ClusterService clusterService, IndexNameExpressionResolver indexNameExpressionResolver, RepositoriesService repositoriesService, TransportService transportService, ActionFilters actionFilters, Map<String, SystemIndices.Feature> systemIndexDescriptorMap) {
        this.clusterService = clusterService;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
        this.repositoriesService = repositoriesService;
        this.threadPool = transportService.getThreadPool();
        this.transportService = transportService;
        this.updateSnapshotStatusHandler = new UpdateSnapshotStatusAction(transportService, clusterService, this.threadPool, actionFilters, indexNameExpressionResolver);
        if (DiscoveryNode.isMasterNode(settings)) {
            clusterService.addLowPriorityApplier(this);
            this.maxConcurrentOperations = MAX_CONCURRENT_SNAPSHOT_OPERATIONS_SETTING.get(settings);
            clusterService.getClusterSettings().addSettingsUpdateConsumer(MAX_CONCURRENT_SNAPSHOT_OPERATIONS_SETTING, i -> {
                this.maxConcurrentOperations = i;
            });
        }
        this.systemIndexDescriptorMap = systemIndexDescriptorMap;
    }

    public void executeSnapshotLegacy(CreateSnapshotRequest request, ActionListener<SnapshotInfo> listener) {
        this.createSnapshotLegacy(request, ActionListener.wrap(snapshot -> this.addListener((Snapshot)snapshot, listener.map(Tuple::v2)), listener::onFailure));
    }

    public void createSnapshotLegacy(final CreateSnapshotRequest request, final ActionListener<Snapshot> listener) {
        final String repositoryName = request.repository();
        final String snapshotName = this.indexNameExpressionResolver.resolveDateMathExpression(request.snapshot());
        SnapshotsService.validate(repositoryName, snapshotName);
        final SnapshotId snapshotId = new SnapshotId(snapshotName, UUIDs.randomBase64UUID());
        final Repository repository = this.repositoriesService.repository(request.repository());
        final Map<String, Object> userMeta = repository.adaptUserMetadata(request.userMetadata());
        this.clusterService.submitStateUpdateTask("create_snapshot [" + snapshotName + ']', new ClusterStateUpdateTask(request.masterNodeTimeout()){
            private java.util.List<String> indices;
            private SnapshotsInProgress.Entry newEntry;

            @Override
            public ClusterState execute(ClusterState currentState) {
                SnapshotsService.ensureRepositoryExists(repositoryName, currentState);
                SnapshotsService.validate(repositoryName, snapshotName, currentState);
                SnapshotDeletionsInProgress deletionsInProgress = (SnapshotDeletionsInProgress)currentState.custom("snapshot_deletions");
                if (deletionsInProgress != null && deletionsInProgress.hasDeletionsInProgress()) {
                    throw new ConcurrentSnapshotExecutionException(repositoryName, snapshotName, "cannot snapshot while a snapshot deletion is in-progress in [" + deletionsInProgress + "]");
                }
                SnapshotsService.ensureNoCleanupInProgress(currentState, repositoryName, snapshotName, "create snapshot");
                SnapshotsInProgress snapshots = (SnapshotsInProgress)currentState.custom("snapshots");
                if (snapshots != null && snapshots.asStream().anyMatch(entry -> !(entry.state() == SnapshotsInProgress.State.INIT && !SnapshotsService.this.initializingSnapshots.contains(entry.snapshot())))) {
                    throw new ConcurrentSnapshotExecutionException(repositoryName, snapshotName, " a snapshot is already running");
                }
                this.indices = Arrays.asList(SnapshotsService.this.indexNameExpressionResolver.concreteIndexNames(currentState, request));
                java.util.List<String> dataStreams = SnapshotsService.this.indexNameExpressionResolver.dataStreamNames(currentState, request.indicesOptions(), request.indices());
                logger.trace("[{}][{}] creating snapshot for indices [{}]", (Object)repositoryName, (Object)snapshotName, this.indices);
                this.newEntry = new SnapshotsInProgress.Entry(new Snapshot(repositoryName, snapshotId), request.includeGlobalState(), request.partial(), SnapshotsInProgress.State.INIT, Collections.emptyMap(), dataStreams, SnapshotsService.this.threadPool.absoluteTimeInMillis(), -2L, ImmutableOpenMap.of(), userMeta, Version.CURRENT);
                SnapshotsService.this.initializingSnapshots.add(this.newEntry.snapshot());
                snapshots = SnapshotsInProgress.EMPTY.withAddedEntry(this.newEntry);
                return ClusterState.builder(currentState).putCustom("snapshots", snapshots).build();
            }

            @Override
            public void onFailure(String source, Exception e) {
                logger.warn(() -> new ParameterizedMessage("[{}][{}] failed to create snapshot", (Object)repositoryName, (Object)snapshotName), (Throwable)e);
                if (this.newEntry != null) {
                    SnapshotsService.this.initializingSnapshots.remove(this.newEntry.snapshot());
                }
                this.newEntry = null;
                listener.onFailure(e);
            }

            @Override
            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                if (this.newEntry != null) {
                    final Snapshot current = this.newEntry.snapshot();
                    assert (SnapshotsService.this.initializingSnapshots.contains(current));
                    assert (this.indices != null);
                    SnapshotsService.this.beginSnapshot(newState, this.newEntry, request.partial(), this.indices, repository, new ActionListener<Snapshot>(){

                        @Override
                        public void onResponse(Snapshot snapshot) {
                            SnapshotsService.this.initializingSnapshots.remove(snapshot);
                            listener.onResponse(snapshot);
                        }

                        @Override
                        public void onFailure(Exception e) {
                            SnapshotsService.this.initializingSnapshots.remove(current);
                            listener.onFailure(e);
                        }
                    });
                }
            }
        });
    }

    public void executeSnapshot(CreateSnapshotRequest request, ActionListener<SnapshotInfo> listener) {
        this.createSnapshot(request, ActionListener.wrap(snapshot -> this.addListener((Snapshot)snapshot, listener.map(Tuple::v2)), listener::onFailure));
    }

    public void createSnapshot(CreateSnapshotRequest request, ActionListener<Snapshot> listener) {
        Set<Object> featureStatesSet;
        final String repositoryName = request.repository();
        String snapshotName = this.indexNameExpressionResolver.resolveDateMathExpression(request.snapshot());
        SnapshotsService.validate(repositoryName, snapshotName);
        SnapshotId snapshotId = new SnapshotId(snapshotName, UUIDs.randomBase64UUID());
        Repository repository = this.repositoriesService.repository(request.repository());
        if (repository.isReadOnly()) {
            listener.onFailure(new RepositoryException(repository.getMetadata().name(), "cannot create snapshot in a readonly repository"));
            return;
        }
        Snapshot snapshot = new Snapshot(repositoryName, snapshotId);
        java.util.List<String> requestedStates = Arrays.asList(request.featureStates());
        Version initialMinNodeVersion = this.clusterService.state().nodes().getMinNodeVersion();
        if (initialMinNodeVersion.onOrAfter(FEATURE_STATES_VERSION)) {
            if (request.includeGlobalState() || !requestedStates.isEmpty()) {
                if (request.includeGlobalState() && requestedStates.isEmpty()) {
                    featureStatesSet = this.systemIndexDescriptorMap.keySet();
                } else if (requestedStates.size() == 1 && NO_FEATURE_STATES_VALUE.equalsIgnoreCase(requestedStates.get(0))) {
                    featureStatesSet = Collections.emptySet();
                } else {
                    if (requestedStates.contains(NO_FEATURE_STATES_VALUE)) {
                        listener.onFailure(new IllegalArgumentException("the feature_states value [none] indicates that no feature states should be snapshotted, but other feature states were requested: " + requestedStates));
                        return;
                    }
                    featureStatesSet = new HashSet<String>(requestedStates);
                    featureStatesSet.retainAll(this.systemIndexDescriptorMap.keySet());
                }
            } else {
                featureStatesSet = Collections.emptySet();
            }
        } else {
            if (!requestedStates.isEmpty()) {
                listener.onFailure(new SnapshotException(snapshot, "feature_states can only be used when all nodes in cluster are version [" + FEATURE_STATES_VERSION + "] or higher, but at least one node in this cluster is on version [" + initialMinNodeVersion + "]"));
                return;
            }
            featureStatesSet = Collections.emptySet();
        }
        Map<String, Object> userMeta = repository.adaptUserMetadata(request.userMetadata());
        repository.executeConsistentStateUpdate(repositoryData -> new ClusterStateUpdateTask(request.masterNodeTimeout(), (RepositoryData)repositoryData, snapshotName, repository, request, featureStatesSet, snapshotId, userMeta, listener, snapshot){
            private SnapshotsInProgress.Entry newEntry;
            final /* synthetic */ RepositoryData val$repositoryData;
            final /* synthetic */ String val$snapshotName;
            final /* synthetic */ Repository val$repository;
            final /* synthetic */ CreateSnapshotRequest val$request;
            final /* synthetic */ Set val$featureStatesSet;
            final /* synthetic */ SnapshotId val$snapshotId;
            final /* synthetic */ Map val$userMeta;
            final /* synthetic */ ActionListener val$listener;
            final /* synthetic */ Snapshot val$snapshot;
            {
                this.val$repositoryData = repositoryData;
                this.val$snapshotName = string2;
                this.val$repository = repository;
                this.val$request = createSnapshotRequest;
                this.val$featureStatesSet = set;
                this.val$snapshotId = snapshotId;
                this.val$userMeta = map;
                this.val$listener = actionListener;
                this.val$snapshot = snapshot;
                super(timeout);
            }

            @Override
            public ClusterState execute(ClusterState currentState) {
                SnapshotsService.ensureRepositoryExists(repositoryName, currentState);
                SnapshotsService.ensureSnapshotNameAvailableInRepo(this.val$repositoryData, this.val$snapshotName, this.val$repository);
                SnapshotsInProgress snapshots = currentState.custom("snapshots", SnapshotsInProgress.EMPTY);
                SnapshotsService.ensureSnapshotNameNotRunning(snapshots, repositoryName, this.val$snapshotName);
                SnapshotsService.validate(repositoryName, this.val$snapshotName, currentState);
                boolean concurrentOperationsAllowed = currentState.nodes().getMinNodeVersion().onOrAfter(FULL_CONCURRENCY_VERSION);
                SnapshotDeletionsInProgress deletionsInProgress = currentState.custom("snapshot_deletions", SnapshotDeletionsInProgress.EMPTY);
                if (deletionsInProgress.hasDeletionsInProgress() && !concurrentOperationsAllowed) {
                    throw new ConcurrentSnapshotExecutionException(repositoryName, this.val$snapshotName, "cannot snapshot while a snapshot deletion is in-progress in [" + deletionsInProgress + "]");
                }
                RepositoryCleanupInProgress repositoryCleanupInProgress = currentState.custom("repository_cleanup", RepositoryCleanupInProgress.EMPTY);
                if (repositoryCleanupInProgress.hasCleanupInProgress()) {
                    throw new ConcurrentSnapshotExecutionException(repositoryName, this.val$snapshotName, "cannot snapshot while a repository cleanup is in-progress in [" + repositoryCleanupInProgress + "]");
                }
                if (!concurrentOperationsAllowed && snapshots.forRepo(repositoryName).stream().anyMatch(entry -> entry.state() != SnapshotsInProgress.State.INIT)) {
                    throw new ConcurrentSnapshotExecutionException(repositoryName, this.val$snapshotName, " a snapshot is already running");
                }
                SnapshotsService.ensureNoCleanupInProgress(currentState, repositoryName, this.val$snapshotName, "create snapshot");
                SnapshotsService.this.ensureBelowConcurrencyLimit(repositoryName, this.val$snapshotName, snapshots, deletionsInProgress);
                java.util.List<String> indices = Arrays.asList(SnapshotsService.this.indexNameExpressionResolver.concreteIndexNames(currentState, this.val$request));
                HashSet<SnapshotFeatureInfo> featureStates = new HashSet<SnapshotFeatureInfo>();
                HashSet systemDataStreamNames = new HashSet();
                HashSet<String> indexNames = new HashSet<String>(indices);
                for (String featureName : this.val$featureStatesSet) {
                    SystemIndices.Feature feature = (SystemIndices.Feature)SnapshotsService.this.systemIndexDescriptorMap.get(featureName);
                    Set featureSystemIndices = feature.getIndexDescriptors().stream().flatMap(descriptor -> descriptor.getMatchingIndices(currentState.metadata()).stream()).collect(Collectors.toSet());
                    Set featureAssociatedIndices = feature.getAssociatedIndexDescriptors().stream().flatMap(descriptor -> descriptor.getMatchingIndices(currentState.metadata()).stream()).collect(Collectors.toSet());
                    HashSet<String> featureSystemDataStreams = new HashSet<String>();
                    HashSet<String> featureDataStreamBackingIndices = new HashSet<String>();
                    for (SystemDataStreamDescriptor sdd : feature.getDataStreamDescriptors()) {
                        java.util.List<String> backingIndexNames = sdd.getBackingIndexNames(currentState.metadata());
                        if (backingIndexNames.size() <= 0) continue;
                        featureDataStreamBackingIndices.addAll(backingIndexNames);
                        featureSystemDataStreams.add(sdd.getDataStreamName());
                    }
                    if (featureSystemIndices.size() > 0 || featureAssociatedIndices.size() > 0 || featureDataStreamBackingIndices.size() > 0) {
                        featureStates.add(new SnapshotFeatureInfo(featureName, Collections.unmodifiableList(new ArrayList(featureSystemIndices))));
                        indexNames.addAll(featureSystemIndices);
                        indexNames.addAll(featureAssociatedIndices);
                        indexNames.addAll(featureDataStreamBackingIndices);
                        systemDataStreamNames.addAll(featureSystemDataStreams);
                    }
                    indices = Collections.unmodifiableList(new ArrayList<String>(indexNames));
                }
                java.util.List<String> dataStreams = SnapshotsService.this.indexNameExpressionResolver.dataStreamNames(currentState, this.val$request.indicesOptions(), this.val$request.indices());
                dataStreams.addAll(systemDataStreamNames);
                logger.trace("[{}][{}] creating snapshot for indices [{}]", (Object)repositoryName, (Object)this.val$snapshotName, indices);
                HashMap<String, IndexId> allIndices = new HashMap<String, IndexId>();
                for (SnapshotsInProgress.Entry runningSnapshot : snapshots.forRepo(repositoryName)) {
                    allIndices.putAll(runningSnapshot.indices());
                }
                Map<String, IndexId> indexIds = this.val$repositoryData.resolveNewIndices(indices, allIndices);
                Version version = SnapshotsService.this.minCompatibleVersion(currentState.nodes().getMinNodeVersion(), this.val$repositoryData, null);
                ImmutableOpenMap shards = SnapshotsService.shards(snapshots, deletionsInProgress, currentState, indexIds.values(), SnapshotsService.useShardGenerations(version), this.val$repositoryData, repositoryName);
                if (!this.val$request.partial()) {
                    HashSet<String> missing = new HashSet<String>();
                    for (ObjectObjectCursor entry2 : shards) {
                        if (((SnapshotsInProgress.ShardSnapshotStatus)entry2.value).state() != SnapshotsInProgress.ShardState.MISSING) continue;
                        missing.add(((ShardId)entry2.key).getIndex().getName());
                    }
                    if (!missing.isEmpty()) {
                        throw new SnapshotException(new Snapshot(repositoryName, this.val$snapshotId), "Indices don't have primary shards " + missing);
                    }
                }
                this.newEntry = SnapshotsInProgress.startedEntry(new Snapshot(repositoryName, this.val$snapshotId), this.val$request.includeGlobalState(), this.val$request.partial(), indexIds, dataStreams, SnapshotsService.this.threadPool.absoluteTimeInMillis(), this.val$repositoryData.getGenId(), shards, this.val$userMeta, version, Collections.unmodifiableList(new ArrayList(featureStates)));
                return ClusterState.builder(currentState).putCustom("snapshots", snapshots.withAddedEntry(this.newEntry)).build();
            }

            @Override
            public void onFailure(String source, Exception e) {
                logger.warn(() -> new ParameterizedMessage("[{}][{}] failed to create snapshot", (Object)repositoryName, (Object)this.val$snapshotName), (Throwable)e);
                this.val$listener.onFailure(e);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                try {
                    logger.info("snapshot [{}] started", (Object)this.val$snapshot);
                    this.val$listener.onResponse(this.val$snapshot);
                }
                finally {
                    if (this.newEntry.state().completed()) {
                        SnapshotsService.this.endSnapshot(this.newEntry, newState.metadata(), this.val$repositoryData);
                    }
                }
            }
        }, "create_snapshot [" + snapshotName + ']', listener::onFailure);
    }

    private static void ensureSnapshotNameNotRunning(SnapshotsInProgress runningSnapshots, String repositoryName, String snapshotName) {
        if (runningSnapshots.forRepo(repositoryName).stream().anyMatch(s -> s.snapshot().getSnapshotId().getName().equals(snapshotName))) {
            throw new InvalidSnapshotNameException(repositoryName, snapshotName, "snapshot with the same name is already in-progress");
        }
    }

    public void cloneSnapshot(CloneSnapshotRequest request, ActionListener<Void> listener) {
        final String repositoryName = request.repository();
        Repository repository = this.repositoriesService.repository(repositoryName);
        if (repository.isReadOnly()) {
            listener.onFailure(new RepositoryException(repositoryName, "cannot create snapshot in a readonly repository"));
            return;
        }
        String snapshotName = this.indexNameExpressionResolver.resolveDateMathExpression(request.target());
        SnapshotsService.validate(repositoryName, snapshotName);
        SnapshotId snapshotId = new SnapshotId(snapshotName, UUIDs.randomBase64UUID());
        Snapshot snapshot = new Snapshot(repositoryName, snapshotId);
        this.initializingClones.add(snapshot);
        repository.executeConsistentStateUpdate(repositoryData -> new ClusterStateUpdateTask(request.masterNodeTimeout(), (RepositoryData)repositoryData, snapshotName, repository, request, snapshot, listener){
            private SnapshotsInProgress.Entry newEntry;
            final /* synthetic */ RepositoryData val$repositoryData;
            final /* synthetic */ String val$snapshotName;
            final /* synthetic */ Repository val$repository;
            final /* synthetic */ CloneSnapshotRequest val$request;
            final /* synthetic */ Snapshot val$snapshot;
            final /* synthetic */ ActionListener val$listener;
            {
                this.val$repositoryData = repositoryData;
                this.val$snapshotName = string2;
                this.val$repository = repository;
                this.val$request = cloneSnapshotRequest;
                this.val$snapshot = snapshot;
                this.val$listener = actionListener;
                super(timeout);
            }

            @Override
            public ClusterState execute(ClusterState currentState) {
                SnapshotsService.ensureRepositoryExists(repositoryName, currentState);
                SnapshotsService.ensureSnapshotNameAvailableInRepo(this.val$repositoryData, this.val$snapshotName, this.val$repository);
                SnapshotsService.ensureNoCleanupInProgress(currentState, repositoryName, this.val$snapshotName, "clone snapshot");
                SnapshotsInProgress snapshots = currentState.custom("snapshots", SnapshotsInProgress.EMPTY);
                SnapshotsService.ensureSnapshotNameNotRunning(snapshots, repositoryName, this.val$snapshotName);
                SnapshotsService.validate(repositoryName, this.val$snapshotName, currentState);
                SnapshotId sourceSnapshotId = this.val$repositoryData.getSnapshotIds().stream().filter(src -> src.getName().equals(this.val$request.source())).findAny().orElseThrow(() -> new SnapshotMissingException(repositoryName, this.val$request.source()));
                SnapshotDeletionsInProgress deletionsInProgress = currentState.custom("snapshot_deletions", SnapshotDeletionsInProgress.EMPTY);
                if (deletionsInProgress.getEntries().stream().anyMatch(entry -> entry.getSnapshots().contains(sourceSnapshotId))) {
                    throw new ConcurrentSnapshotExecutionException(repositoryName, sourceSnapshotId.getName(), "cannot clone from snapshot that is being deleted");
                }
                SnapshotsService.this.ensureBelowConcurrencyLimit(repositoryName, this.val$snapshotName, snapshots, deletionsInProgress);
                ArrayList<String> indicesForSnapshot = new ArrayList<String>();
                for (IndexId indexId : this.val$repositoryData.getIndices().values()) {
                    if (!this.val$repositoryData.getSnapshots(indexId).contains(sourceSnapshotId)) continue;
                    indicesForSnapshot.add(indexId.getName());
                }
                java.util.List<String> matchingIndices = SnapshotUtils.filterIndices(indicesForSnapshot, this.val$request.indices(), this.val$request.indicesOptions());
                if (matchingIndices.isEmpty()) {
                    throw new SnapshotException(new Snapshot(repositoryName, sourceSnapshotId), "No indices in the source snapshot [" + sourceSnapshotId + "] matched requested pattern [" + Strings.arrayToCommaDelimitedString(this.val$request.indices()) + "]");
                }
                this.newEntry = SnapshotsInProgress.startClone(this.val$snapshot, sourceSnapshotId, this.val$repositoryData.resolveIndices(matchingIndices), SnapshotsService.this.threadPool.absoluteTimeInMillis(), this.val$repositoryData.getGenId(), SnapshotsService.this.minCompatibleVersion(currentState.nodes().getMinNodeVersion(), this.val$repositoryData, null));
                return ClusterState.builder(currentState).putCustom("snapshots", snapshots.withAddedEntry(this.newEntry)).build();
            }

            @Override
            public void onFailure(String source, Exception e) {
                SnapshotsService.this.initializingClones.remove(this.val$snapshot);
                logger.warn(() -> new ParameterizedMessage("[{}][{}] failed to clone snapshot", (Object)repositoryName, (Object)this.val$snapshotName), (Throwable)e);
                this.val$listener.onFailure(e);
            }

            @Override
            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                logger.info("snapshot clone [{}] started", (Object)this.val$snapshot);
                SnapshotsService.this.addListener(this.val$snapshot, ActionListener.wrap(r -> this.val$listener.onResponse(null), this.val$listener::onFailure));
                SnapshotsService.this.startCloning(this.val$repository, this.newEntry);
            }
        }, "clone_snapshot [" + request.source() + "][" + snapshotName + ']', listener::onFailure);
    }

    private static void ensureNoCleanupInProgress(ClusterState currentState, String repositoryName, String snapshotName, String reason) {
        RepositoryCleanupInProgress repositoryCleanupInProgress = currentState.custom("repository_cleanup", RepositoryCleanupInProgress.EMPTY);
        if (repositoryCleanupInProgress.hasCleanupInProgress()) {
            throw new ConcurrentSnapshotExecutionException(repositoryName, snapshotName, "cannot " + reason + " while a repository cleanup is in-progress in " + repositoryCleanupInProgress.entries().stream().map(RepositoryCleanupInProgress.Entry::repository).collect(Collectors.toSet()));
        }
    }

    private static void ensureSnapshotNameAvailableInRepo(RepositoryData repositoryData, String snapshotName, Repository repository) {
        if (repositoryData.getSnapshotIds().stream().anyMatch(s -> s.getName().equals(snapshotName))) {
            throw new InvalidSnapshotNameException(repository.getMetadata().name(), snapshotName, "snapshot with the same name already exists");
        }
    }

    private void startCloning(Repository repository, final SnapshotsInProgress.Entry cloneEntry) {
        Collection<IndexId> indices = cloneEntry.indices().values();
        SnapshotId sourceSnapshot = cloneEntry.source();
        Snapshot targetSnapshot = cloneEntry.snapshot();
        ExecutorService executor = this.threadPool.executor("snapshot");
        Consumer<Exception> onFailure = e -> {
            this.endingSnapshots.add(targetSnapshot);
            this.initializingClones.remove(targetSnapshot);
            logger.info(() -> new ParameterizedMessage("Failed to start snapshot clone [{}]", (Object)cloneEntry), (Throwable)e);
            this.removeFailedSnapshotFromClusterState(targetSnapshot, (Exception)e, null, null);
        };
        StepListener<SnapshotInfo> snapshotInfoListener = new StepListener<SnapshotInfo>();
        repository.getSnapshotInfo(sourceSnapshot, snapshotInfoListener);
        StepListener allShardCountsListener = new StepListener();
        GroupedActionListener shardCountListener = new GroupedActionListener(allShardCountsListener, indices.size());
        snapshotInfoListener.whenComplete((CheckedConsumer<SnapshotInfo, Exception>)((CheckedConsumer)snapshotInfo -> {
            for (IndexId indexId : indices) {
                if (!RestoreService.failed(snapshotInfo, indexId.getName())) continue;
                throw new SnapshotException(targetSnapshot, "Can't clone index [" + indexId + "] because its snapshot was not successful.");
            }
            repository.getRepositoryData(ActionListener.wrap(repositoryData -> {
                for (IndexId index : indices) {
                    executor.execute(ActionRunnable.supply(shardCountListener, () -> {
                        IndexMetadata metadata = repository.getSnapshotIndexMetaData((RepositoryData)repositoryData, sourceSnapshot, index);
                        return Tuple.tuple((Object)index, (Object)metadata.getNumberOfShards());
                    }));
                }
            }, onFailure));
        }), onFailure);
        allShardCountsListener.whenComplete(counts -> repository.executeConsistentStateUpdate(repoData -> new ClusterStateUpdateTask((RepositoryData)repoData, (Collection)counts, targetSnapshot, repository){
            private SnapshotsInProgress.Entry updatedEntry;
            final /* synthetic */ RepositoryData val$repoData;
            final /* synthetic */ Collection val$counts;
            final /* synthetic */ Snapshot val$targetSnapshot;
            final /* synthetic */ Repository val$repository;
            {
                this.val$repoData = repositoryData;
                this.val$counts = collection;
                this.val$targetSnapshot = snapshot;
                this.val$repository = repository;
            }

            @Override
            public ClusterState execute(ClusterState currentState) {
                SnapshotsInProgress snapshotsInProgress = currentState.custom("snapshots", SnapshotsInProgress.EMPTY);
                String repoName = cloneEntry.repository();
                java.util.List<SnapshotsInProgress.Entry> existingEntries = snapshotsInProgress.forRepo(repoName);
                ArrayList<SnapshotsInProgress.Entry> updatedEntries = new ArrayList<SnapshotsInProgress.Entry>(existingEntries.size());
                String localNodeId = currentState.nodes().getLocalNodeId();
                ShardGenerations shardGenerations = this.val$repoData.shardGenerations();
                for (SnapshotsInProgress.Entry existing : existingEntries) {
                    if (cloneEntry.snapshot().getSnapshotId().equals(existing.snapshot().getSnapshotId())) {
                        ImmutableOpenMap.Builder<RepositoryShardId, SnapshotsInProgress.ShardSnapshotStatus> clonesBuilder = ImmutableOpenMap.builder();
                        boolean readyToExecute = !currentState.custom("snapshot_deletions", SnapshotDeletionsInProgress.EMPTY).hasExecutingDeletion(repoName);
                        InFlightShardSnapshotStates inFlightShardStates = readyToExecute ? InFlightShardSnapshotStates.forEntries(snapshotsInProgress.forRepo(repoName)) : null;
                        for (Tuple count : this.val$counts) {
                            for (int shardId = 0; shardId < (Integer)count.v2(); ++shardId) {
                                RepositoryShardId repoShardId = new RepositoryShardId((IndexId)count.v1(), shardId);
                                String indexName = repoShardId.indexName();
                                if (!readyToExecute || inFlightShardStates.isActive(indexName, shardId)) {
                                    clonesBuilder.put(repoShardId, SnapshotsInProgress.ShardSnapshotStatus.UNASSIGNED_QUEUED);
                                    continue;
                                }
                                clonesBuilder.put(repoShardId, new SnapshotsInProgress.ShardSnapshotStatus(localNodeId, inFlightShardStates.generationForShard(repoShardId.index(), shardId, shardGenerations)));
                            }
                        }
                        this.updatedEntry = cloneEntry.withClones(clonesBuilder.build());
                        continue;
                    }
                    updatedEntries.add(existing);
                }
                if (this.updatedEntry != null) {
                    updatedEntries.add(this.updatedEntry);
                    return SnapshotsService.updateWithSnapshots(currentState, snapshotsInProgress.withUpdatedEntriesForRepo(repoName, updatedEntries), null);
                }
                return currentState;
            }

            @Override
            public void onFailure(String source, Exception e) {
                SnapshotsService.this.initializingClones.remove(this.val$targetSnapshot);
                logger.info(() -> new ParameterizedMessage("Failed to start snapshot clone [{}]", (Object)cloneEntry), (Throwable)e);
                SnapshotsService.this.failAllListenersOnMasterFailOver(e);
            }

            @Override
            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                SnapshotsService.this.initializingClones.remove(this.val$targetSnapshot);
                if (this.updatedEntry != null) {
                    Snapshot target = this.updatedEntry.snapshot();
                    SnapshotId sourceSnapshot = this.updatedEntry.source();
                    for (ObjectObjectCursor<RepositoryShardId, SnapshotsInProgress.ShardSnapshotStatus> objectObjectCursor : this.updatedEntry.shardsByRepoShardId()) {
                        SnapshotsInProgress.ShardSnapshotStatus shardStatusBefore = (SnapshotsInProgress.ShardSnapshotStatus)objectObjectCursor.value;
                        if (shardStatusBefore.state() != SnapshotsInProgress.ShardState.INIT) continue;
                        RepositoryShardId repoShardId = (RepositoryShardId)objectObjectCursor.key;
                        SnapshotsService.this.runReadyClone(target, sourceSnapshot, shardStatusBefore, repoShardId, this.val$repository);
                    }
                } else {
                    logger.warn("Did not find expected entry [{}] in the cluster state", (Object)cloneEntry);
                }
            }
        }, "start snapshot clone", onFailure), onFailure);
    }

    private void runReadyClone(Snapshot target, SnapshotId sourceSnapshot, SnapshotsInProgress.ShardSnapshotStatus shardStatusBefore, RepositoryShardId repoShardId, Repository repository) {
        SnapshotId targetSnapshot = target.getSnapshotId();
        String localNodeId = this.clusterService.localNode().getId();
        if (this.currentlyCloning.add(repoShardId)) {
            repository.cloneShardSnapshot(sourceSnapshot, targetSnapshot, repoShardId, shardStatusBefore.generation(), ActionListener.wrap(shardSnapshotResult -> this.innerUpdateSnapshotState(new ShardSnapshotUpdate(target, repoShardId, SnapshotsInProgress.ShardSnapshotStatus.success(localNodeId, shardSnapshotResult)), ActionListener.runBefore(ActionListener.wrap(v -> logger.trace("Marked [{}] as successfully cloned from [{}] to [{}]", (Object)repoShardId, (Object)sourceSnapshot, (Object)targetSnapshot), e -> {
                logger.warn("Cluster state update after successful shard clone [{}] failed", (Object)repoShardId);
                this.failAllListenersOnMasterFailOver((Exception)e);
            }), () -> this.currentlyCloning.remove(repoShardId))), e -> this.innerUpdateSnapshotState(new ShardSnapshotUpdate(target, repoShardId, new SnapshotsInProgress.ShardSnapshotStatus(localNodeId, SnapshotsInProgress.ShardState.FAILED, "failed to clone shard snapshot", shardStatusBefore.generation())), ActionListener.runBefore(ActionListener.wrap(v -> logger.trace("Marked [{}] as failed clone from [{}] to [{}]", (Object)repoShardId, (Object)sourceSnapshot, (Object)targetSnapshot), ex -> {
                logger.warn("Cluster state update after failed shard clone [{}] failed", (Object)repoShardId);
                this.failAllListenersOnMasterFailOver((Exception)ex);
            }), () -> this.currentlyCloning.remove(repoShardId)))));
        }
    }

    private void ensureBelowConcurrencyLimit(String repository, String name, SnapshotsInProgress snapshotsInProgress, SnapshotDeletionsInProgress deletionsInProgress) {
        int maxOps;
        int inProgressOperations = snapshotsInProgress.count() + deletionsInProgress.getEntries().size();
        if (inProgressOperations >= (maxOps = this.maxConcurrentOperations)) {
            throw new ConcurrentSnapshotExecutionException(repository, name, "Cannot start another operation, already running [" + inProgressOperations + "] operations and the current limit for concurrent snapshot operations is set to [" + maxOps + "]");
        }
    }

    public static void ensureRepositoryExists(String repoName, ClusterState state) {
        if (state.metadata().custom("repositories", RepositoriesMetadata.EMPTY).repository(repoName) == null) {
            throw new RepositoryMissingException(repoName);
        }
    }

    private static void validate(String repositoryName, String snapshotName, ClusterState state) {
        RepositoriesMetadata repositoriesMetadata = state.getMetadata().custom("repositories", RepositoriesMetadata.EMPTY);
        if (repositoriesMetadata.repository(repositoryName) == null) {
            throw new RepositoryMissingException(repositoryName);
        }
        SnapshotsService.validate(repositoryName, snapshotName);
    }

    private static void validate(String repositoryName, String snapshotName) {
        if (!Strings.hasLength(snapshotName)) {
            throw new InvalidSnapshotNameException(repositoryName, snapshotName, "cannot be empty");
        }
        if (snapshotName.contains(" ")) {
            throw new InvalidSnapshotNameException(repositoryName, snapshotName, "must not contain whitespace");
        }
        if (snapshotName.contains(",")) {
            throw new InvalidSnapshotNameException(repositoryName, snapshotName, "must not contain ','");
        }
        if (snapshotName.contains("#")) {
            throw new InvalidSnapshotNameException(repositoryName, snapshotName, "must not contain '#'");
        }
        if (snapshotName.charAt(0) == '_') {
            throw new InvalidSnapshotNameException(repositoryName, snapshotName, "must not start with '_'");
        }
        if (!snapshotName.toLowerCase(Locale.ROOT).equals(snapshotName)) {
            throw new InvalidSnapshotNameException(repositoryName, snapshotName, "must be lowercase");
        }
        if (!Strings.validFileName(snapshotName)) {
            throw new InvalidSnapshotNameException(repositoryName, snapshotName, "must not contain the following characters " + Strings.INVALID_FILENAME_CHARS);
        }
    }

    private void beginSnapshot(final ClusterState clusterState, final SnapshotsInProgress.Entry snapshot, final boolean partial, final java.util.List<String> indices, final Repository repository, final ActionListener<Snapshot> userCreateSnapshotListener) {
        this.threadPool.executor("snapshot").execute(new AbstractRunnable(){
            boolean hadAbortedInitializations;

            @Override
            protected void doRun() {
                assert (SnapshotsService.this.initializingSnapshots.contains(snapshot.snapshot()));
                if (repository.isReadOnly()) {
                    throw new RepositoryException(repository.getMetadata().name(), "cannot create snapshot in a readonly repository");
                }
                String snapshotName = snapshot.snapshot().getSnapshotId().getName();
                StepListener<RepositoryData> repositoryDataListener = new StepListener<RepositoryData>();
                repository.getRepositoryData(repositoryDataListener);
                repositoryDataListener.whenComplete((CheckedConsumer<RepositoryData, Exception>)((CheckedConsumer)repositoryData -> {
                    if (repositoryData.getSnapshotIds().stream().anyMatch(s -> s.getName().equals(snapshotName))) {
                        throw new InvalidSnapshotNameException(repository.getMetadata().name(), snapshotName, "snapshot with the same name already exists");
                    }
                    if (!clusterState.nodes().getMinNodeVersion().onOrAfter(NO_REPO_INITIALIZE_VERSION)) {
                        repository.initializeSnapshot(snapshot.snapshot().getSnapshotId(), Collections.unmodifiableList(new ArrayList<IndexId>(snapshot.indices().values())), SnapshotsService.metadataForSnapshot(snapshot, clusterState.metadata()));
                    }
                    logger.info("snapshot [{}] started", (Object)snapshot.snapshot());
                    Version version = SnapshotsService.this.minCompatibleVersion(clusterState.nodes().getMinNodeVersion(), (RepositoryData)repositoryData, null);
                    if (indices.isEmpty()) {
                        userCreateSnapshotListener.onResponse(snapshot.snapshot());
                        SnapshotsService.this.endSnapshot(SnapshotsInProgress.startedEntry(snapshot.snapshot(), snapshot.includeGlobalState(), snapshot.partial(), Collections.emptyMap(), Collections.emptyList(), SnapshotsService.this.threadPool.absoluteTimeInMillis(), repositoryData.getGenId(), ImmutableOpenMap.of(), snapshot.userMetadata(), version, Collections.emptyList()), clusterState.metadata(), repositoryData);
                        return;
                    }
                    SnapshotsService.this.clusterService.submitStateUpdateTask("update_snapshot [" + snapshot.snapshot() + "]", new ClusterStateUpdateTask((RepositoryData)repositoryData, indices, version, partial, userCreateSnapshotListener){
                        final /* synthetic */ RepositoryData val$repositoryData;
                        final /* synthetic */ java.util.List val$indices;
                        final /* synthetic */ Version val$version;
                        final /* synthetic */ boolean val$partial;
                        final /* synthetic */ ActionListener val$userCreateSnapshotListener;
                        {
                            this.val$repositoryData = repositoryData;
                            this.val$indices = list;
                            this.val$version = version;
                            this.val$partial = bl;
                            this.val$userCreateSnapshotListener = actionListener;
                        }

                        @Override
                        public ClusterState execute(ClusterState currentState) {
                            SnapshotsInProgress snapshots = currentState.custom("snapshots", SnapshotsInProgress.EMPTY);
                            ArrayList<SnapshotsInProgress.Entry> entries = new ArrayList<SnapshotsInProgress.Entry>();
                            for (SnapshotsInProgress.Entry entry : snapshots.forRepo(snapshot.repository())) {
                                if (!entry.snapshot().equals(snapshot.snapshot())) {
                                    entries.add(entry);
                                    continue;
                                }
                                if (entry.state() == SnapshotsInProgress.State.ABORTED) {
                                    entries.add(entry);
                                    assert (entry.shards().isEmpty());
                                    hadAbortedInitializations = true;
                                    continue;
                                }
                                Map<String, IndexId> indexIds = this.val$repositoryData.resolveNewIndices(this.val$indices, Collections.emptyMap());
                                ImmutableOpenMap shards = SnapshotsService.shards(snapshots, currentState.custom("snapshot_deletions", SnapshotDeletionsInProgress.EMPTY), currentState, indexIds.values(), SnapshotsService.useShardGenerations(this.val$version), this.val$repositoryData, entry.repository());
                                if (!this.val$partial) {
                                    Tuple indicesWithMissingShards = SnapshotsService.indicesWithMissingShards(shards, currentState.metadata());
                                    Set missing = (Set)indicesWithMissingShards.v1();
                                    Set closed = (Set)indicesWithMissingShards.v2();
                                    if (!missing.isEmpty() || !closed.isEmpty()) {
                                        StringBuilder failureMessage = new StringBuilder();
                                        if (!missing.isEmpty()) {
                                            failureMessage.append("Indices don't have primary shards ");
                                            failureMessage.append(missing);
                                        }
                                        if (!closed.isEmpty()) {
                                            if (failureMessage.length() > 0) {
                                                failureMessage.append("; ");
                                            }
                                            failureMessage.append("Indices are closed ");
                                            failureMessage.append(closed);
                                        }
                                        entries.add(new SnapshotsInProgress.Entry(entry, SnapshotsInProgress.State.FAILED, indexIds, this.val$repositoryData.getGenId(), shards, this.val$version, failureMessage.toString()));
                                        continue;
                                    }
                                }
                                entries.add(new SnapshotsInProgress.Entry(entry, SnapshotsInProgress.State.STARTED, indexIds, this.val$repositoryData.getGenId(), shards, this.val$version, null));
                            }
                            return ClusterState.builder(currentState).putCustom("snapshots", snapshots.withUpdatedEntriesForRepo(snapshot.repository(), entries)).build();
                        }

                        @Override
                        public void onFailure(String source, Exception e) {
                            logger.warn(() -> new ParameterizedMessage("[{}] failed to create snapshot", (Object)snapshot.snapshot().getSnapshotId()), (Throwable)e);
                            SnapshotsService.this.removeFailedSnapshotFromClusterState(snapshot.snapshot(), e, null, new CleanupAfterErrorListener(this.val$userCreateSnapshotListener, e));
                        }

                        @Override
                        public void onNoLongerMaster(String source) {
                            logger.warn("[{}] failed to create snapshot - no longer a master", (Object)snapshot.snapshot().getSnapshotId());
                            this.val$userCreateSnapshotListener.onFailure(new SnapshotException(snapshot.snapshot(), "master changed during snapshot initialization"));
                        }

                        @Override
                        public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                            this.val$userCreateSnapshotListener.onResponse(snapshot.snapshot());
                            if (hadAbortedInitializations) {
                                SnapshotsInProgress snapshotsInProgress = (SnapshotsInProgress)newState.custom("snapshots");
                                assert (snapshotsInProgress != null);
                                SnapshotsInProgress.Entry entry = snapshotsInProgress.snapshot(snapshot.snapshot());
                                assert (entry != null);
                                SnapshotsService.this.endSnapshot(entry, newState.metadata(), this.val$repositoryData);
                            } else {
                                SnapshotsService.this.endCompletedSnapshots(newState);
                            }
                        }
                    });
                }), this::onFailure);
            }

            @Override
            public void onFailure(Exception e) {
                logger.warn(() -> new ParameterizedMessage("failed to create snapshot [{}]", (Object)snapshot.snapshot().getSnapshotId()), (Throwable)e);
                SnapshotsService.this.endingSnapshots.add(snapshot.snapshot());
                SnapshotsService.this.removeFailedSnapshotFromClusterState(snapshot.snapshot(), e, null, new CleanupAfterErrorListener(userCreateSnapshotListener, e));
            }
        });
    }

    private static ShardGenerations buildGenerations(SnapshotsInProgress.Entry snapshot, Metadata metadata) {
        ShardGenerations.Builder builder = ShardGenerations.builder();
        if (snapshot.isClone()) {
            snapshot.shardsByRepoShardId().forEach(c -> builder.put(((RepositoryShardId)c.key).index(), ((RepositoryShardId)c.key).shardId(), (SnapshotsInProgress.ShardSnapshotStatus)c.value));
        } else {
            snapshot.shardsByRepoShardId().forEach(c -> {
                Index index = snapshot.indexByName(((RepositoryShardId)c.key).indexName());
                if (metadata.index(index) == null) {
                    assert (snapshot.partial()) : "Index [" + index + "] was deleted during a snapshot but snapshot was not partial.";
                    return;
                }
                builder.put(((RepositoryShardId)c.key).index(), ((RepositoryShardId)c.key).shardId(), (SnapshotsInProgress.ShardSnapshotStatus)c.value);
            });
        }
        return builder.build();
    }

    private static Metadata metadataForSnapshot(SnapshotsInProgress.Entry snapshot, Metadata metadata) {
        Metadata.Builder builder;
        if (!snapshot.includeGlobalState()) {
            builder = Metadata.builder();
            for (IndexId index : snapshot.indices().values()) {
                IndexMetadata indexMetadata = metadata.index(index.getName());
                if (indexMetadata == null) {
                    assert (snapshot.partial()) : "Index [" + index + "] was deleted during a snapshot but snapshot was not partial.";
                    continue;
                }
                builder.put(indexMetadata, false);
            }
        } else {
            builder = Metadata.builder(metadata);
        }
        HashMap<String, DataStream> dataStreams = new HashMap<String, DataStream>();
        Set<String> indicesInSnapshot = snapshot.indices().keySet();
        for (String dataStreamName : snapshot.dataStreams()) {
            DataStream reconciled;
            DataStream dataStream = metadata.dataStreams().get(dataStreamName);
            if (dataStream == null) {
                assert (snapshot.partial()) : "Data stream [" + dataStreamName + "] was deleted during a snapshot but snapshot was not partial.";
                continue;
            }
            boolean missingIndex = false;
            for (Index index : dataStream.getIndices()) {
                String indexName = index.getName();
                if (builder.get(indexName) != null && indicesInSnapshot.contains(indexName)) continue;
                missingIndex = true;
                break;
            }
            if ((reconciled = missingIndex ? dataStream.snapshot(indicesInSnapshot) : dataStream) == null) continue;
            dataStreams.put(dataStreamName, reconciled);
        }
        return builder.dataStreams(dataStreams, SnapshotsService.filterDataStreamAliases(dataStreams, metadata.dataStreamAliases())).build();
    }

    public static java.util.List<SnapshotsInProgress.Entry> currentSnapshots(@Nullable SnapshotsInProgress snapshotsInProgress, String repository, java.util.List<String> snapshots) {
        if (snapshotsInProgress == null || snapshotsInProgress.isEmpty()) {
            return Collections.emptyList();
        }
        if ("_all".equals(repository)) {
            return Collections.unmodifiableList(snapshotsInProgress.asStream().collect(Collectors.toList()));
        }
        if (snapshots.isEmpty()) {
            return snapshotsInProgress.forRepo(repository);
        }
        ArrayList<SnapshotsInProgress.Entry> builder = new ArrayList<SnapshotsInProgress.Entry>();
        block0: for (SnapshotsInProgress.Entry entry : snapshotsInProgress.forRepo(repository)) {
            for (String snapshot : snapshots) {
                if (!entry.snapshot().getSnapshotId().getName().equals(snapshot)) continue;
                builder.add(entry);
                continue block0;
            }
        }
        return Collections.unmodifiableList(builder);
    }

    @Override
    public void applyClusterState(ClusterChangedEvent event) {
        try {
            if (event.localNodeMaster()) {
                SnapshotsInProgress snapshotsInProgress = event.state().custom("snapshots", SnapshotsInProgress.EMPTY);
                boolean newMaster = !event.previousState().nodes().isLocalNodeElectedMaster();
                this.processExternalChanges(newMaster || SnapshotsService.removedNodesCleanupNeeded(snapshotsInProgress, event.nodesDelta().removedNodes()), event.routingTableChanged() && SnapshotsService.waitingShardsStartedOrUnassigned(snapshotsInProgress, event));
            } else {
                if (!this.snapshotCompletionListeners.isEmpty()) {
                    for (Snapshot snapshot : new HashSet<Snapshot>(this.snapshotCompletionListeners.keySet())) {
                        if (!this.endingSnapshots.add(snapshot)) continue;
                        this.failSnapshotCompletionListeners(snapshot, new SnapshotException(snapshot, "no longer master"));
                    }
                }
                if (!this.snapshotDeletionListeners.isEmpty()) {
                    NotMasterException e = new NotMasterException("no longer master");
                    for (String delete : new HashSet<String>(this.snapshotDeletionListeners.keySet())) {
                        SnapshotsService.failListenersIgnoringException(this.snapshotDeletionListeners.remove(delete), e);
                    }
                }
            }
        }
        catch (Exception e) {
            assert (false) : new AssertionError((Object)e);
            logger.warn("Failed to update snapshot state ", (Throwable)e);
        }
        assert (this.assertConsistentWithClusterState(event.state()));
        assert (SnapshotsService.assertNoDanglingSnapshots(event.state()));
    }

    private void endCompletedSnapshots(ClusterState state) {
        SnapshotsInProgress snapshotsInProgress = (SnapshotsInProgress)state.custom("snapshots");
        assert (snapshotsInProgress != null);
        snapshotsInProgress.asStream().filter(entry -> entry.state().completed() || entry.state() == SnapshotsInProgress.State.INIT || SnapshotsInProgress.completed(entry.shards().values())).forEach(entry -> this.endSnapshot((SnapshotsInProgress.Entry)entry, state.metadata(), null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean assertConsistentWithClusterState(ClusterState state) {
        SnapshotDeletionsInProgress snapshotDeletionsInProgress;
        SnapshotsInProgress snapshotsInProgress = state.custom("snapshots", SnapshotsInProgress.EMPTY);
        if (!snapshotsInProgress.isEmpty()) {
            Set<Snapshot> set = this.endingSnapshots;
            synchronized (set) {
                Set runningSnapshots = Stream.concat(snapshotsInProgress.asStream().map(SnapshotsInProgress.Entry::snapshot), this.endingSnapshots.stream()).collect(Collectors.toSet());
                Set<Snapshot> snapshotListenerKeys = this.snapshotCompletionListeners.keySet();
                assert (runningSnapshots.containsAll(snapshotListenerKeys)) : "Saw completion listeners for unknown snapshots in " + snapshotListenerKeys + " but running snapshots are " + runningSnapshots;
            }
        }
        if ((snapshotDeletionsInProgress = state.custom("snapshot_deletions", SnapshotDeletionsInProgress.EMPTY)).hasDeletionsInProgress()) {
            Set set = this.repositoryOperations.runningDeletions;
            synchronized (set) {
                Set runningDeletes = Stream.concat(snapshotDeletionsInProgress.getEntries().stream().map(SnapshotDeletionsInProgress.Entry::uuid), this.repositoryOperations.runningDeletions.stream()).collect(Collectors.toSet());
                Set<String> deleteListenerKeys = this.snapshotDeletionListeners.keySet();
                assert (runningDeletes.containsAll(deleteListenerKeys)) : "Saw deletions listeners for unknown uuids in " + deleteListenerKeys + " but running deletes are " + runningDeletes;
            }
        }
        return true;
    }

    private static boolean assertNoDanglingSnapshots(ClusterState state) {
        SnapshotsInProgress snapshotsInProgress = state.custom("snapshots", SnapshotsInProgress.EMPTY);
        SnapshotDeletionsInProgress snapshotDeletionsInProgress = state.custom("snapshot_deletions", SnapshotDeletionsInProgress.EMPTY);
        Set reposWithRunningDelete = snapshotDeletionsInProgress.getEntries().stream().filter(entry -> entry.state() == SnapshotDeletionsInProgress.State.STARTED).map(SnapshotDeletionsInProgress.Entry::repository).collect(Collectors.toSet());
        for (java.util.List<SnapshotsInProgress.Entry> repoEntry : snapshotsInProgress.entriesByRepo()) {
            SnapshotsInProgress.Entry entry2 = repoEntry.get(0);
            for (SnapshotsInProgress.ShardSnapshotStatus value : entry2.shardsByRepoShardId().values()) {
                if (value.equals(SnapshotsInProgress.ShardSnapshotStatus.UNASSIGNED_QUEUED)) {
                    assert (reposWithRunningDelete.contains(entry2.repository())) : "Found shard snapshot waiting to be assigned in [" + entry2 + "] but it is not blocked by any running delete";
                    continue;
                }
                if (value.isActive()) assert (!reposWithRunningDelete.contains(entry2.repository())) : "Found shard snapshot actively executing in [" + entry2 + "] when it should be blocked by a running delete [" + Strings.toString((ToXContent)snapshotDeletionsInProgress) + "]";
            }
        }
        return true;
    }

    private void processExternalChanges(final boolean changedNodes, boolean startShards) {
        if (!changedNodes && !startShards) {
            return;
        }
        this.clusterService.submitStateUpdateTask("update snapshot after shards started [" + startShards + "] or node configuration changed [" + changedNodes + "]", new ClusterStateUpdateTask(){
            private final Collection<SnapshotsInProgress.Entry> finishedSnapshots = new ArrayList<SnapshotsInProgress.Entry>();
            private final Collection<SnapshotDeletionsInProgress.Entry> deletionsToExecute = new ArrayList<SnapshotDeletionsInProgress.Entry>();

            @Override
            public ClusterState execute(ClusterState currentState) {
                RoutingTable routingTable = currentState.routingTable();
                SnapshotsInProgress snapshots = currentState.custom("snapshots", SnapshotsInProgress.EMPTY);
                SnapshotDeletionsInProgress deletes = currentState.custom("snapshot_deletions", SnapshotDeletionsInProgress.EMPTY);
                DiscoveryNodes nodes = currentState.nodes();
                EnumSet<SnapshotsInProgress.State> statesToUpdate = changedNodes ? EnumSet.of(SnapshotsInProgress.State.STARTED, SnapshotsInProgress.State.ABORTED) : EnumSet.of(SnapshotsInProgress.State.STARTED);
                SnapshotsInProgress updated = snapshots;
                for (java.util.List<SnapshotsInProgress.Entry> snapshotsInRepo : snapshots.entriesByRepo()) {
                    boolean changed = false;
                    ArrayList<SnapshotsInProgress.Entry> updatedEntriesForRepo = new ArrayList<SnapshotsInProgress.Entry>();
                    HashMap knownFailures = new HashMap();
                    String repository = snapshotsInRepo.get(0).repository();
                    for (SnapshotsInProgress.Entry snapshot : snapshotsInRepo) {
                        if (statesToUpdate.contains((Object)snapshot.state())) {
                            if (snapshot.isClone()) {
                                if (snapshot.shardsByRepoShardId().isEmpty()) {
                                    if (SnapshotsService.this.initializingClones.contains(snapshot.snapshot())) {
                                        updatedEntriesForRepo.add(snapshot);
                                        continue;
                                    }
                                    logger.debug("removing not yet start clone operation [{}]", (Object)snapshot);
                                    changed = true;
                                    continue;
                                }
                                if (deletes.hasExecutingDeletion(repository)) {
                                    updatedEntriesForRepo.add(snapshot);
                                    continue;
                                }
                                ImmutableOpenMap.Builder<RepositoryShardId, SnapshotsInProgress.ShardSnapshotStatus> clones = null;
                                InFlightShardSnapshotStates inFlightShardSnapshotStates = null;
                                for (Map.Entry failureEntry : knownFailures.entrySet()) {
                                    RepositoryShardId repositoryShardId = (RepositoryShardId)failureEntry.getKey();
                                    SnapshotsInProgress.ShardSnapshotStatus existingStatus = snapshot.shardsByRepoShardId().get(repositoryShardId);
                                    if (!SnapshotsInProgress.ShardSnapshotStatus.UNASSIGNED_QUEUED.equals(existingStatus)) continue;
                                    if (inFlightShardSnapshotStates == null) {
                                        inFlightShardSnapshotStates = InFlightShardSnapshotStates.forEntries(updatedEntriesForRepo);
                                    }
                                    if (inFlightShardSnapshotStates.isActive(repositoryShardId.indexName(), repositoryShardId.shardId())) continue;
                                    if (clones == null) {
                                        clones = ImmutableOpenMap.builder(snapshot.shardsByRepoShardId());
                                    }
                                    clones.put(repositoryShardId, new SnapshotsInProgress.ShardSnapshotStatus(nodes.getLocalNodeId(), ((SnapshotsInProgress.ShardSnapshotStatus)failureEntry.getValue()).generation()));
                                }
                                if (clones != null) {
                                    changed = true;
                                    updatedEntriesForRepo.add(snapshot.withClones(clones.build()));
                                    continue;
                                }
                                updatedEntriesForRepo.add(snapshot);
                                continue;
                            }
                            ImmutableOpenMap shards = SnapshotsService.processWaitingShardsAndRemovedNodes(snapshot, routingTable, nodes, knownFailures);
                            if (shards != null) {
                                SnapshotsInProgress.Entry updatedSnapshot = snapshot.withShardStates(shards);
                                changed = true;
                                if (updatedSnapshot.state().completed()) {
                                    this.finishedSnapshots.add(updatedSnapshot);
                                }
                                updatedEntriesForRepo.add(updatedSnapshot);
                                continue;
                            }
                            updatedEntriesForRepo.add(snapshot);
                            continue;
                        }
                        if (snapshot.repositoryStateId() == -2L) {
                            changed = true;
                            logger.debug("[{}] was found in dangling INIT or ABORTED state", (Object)snapshot);
                            continue;
                        }
                        if (snapshot.state().completed() || SnapshotsInProgress.completed(snapshot.shardsByRepoShardId().values())) {
                            this.finishedSnapshots.add(snapshot);
                        }
                        updatedEntriesForRepo.add(snapshot);
                    }
                    if (!changed) continue;
                    updated = updated.withUpdatedEntriesForRepo(repository, updatedEntriesForRepo);
                }
                ClusterState res = (ClusterState)SnapshotsService.readyDeletions(updated != snapshots ? ClusterState.builder(currentState).putCustom("snapshots", updated).build() : currentState).v1();
                for (SnapshotDeletionsInProgress.Entry delete : res.custom("snapshot_deletions", SnapshotDeletionsInProgress.EMPTY).getEntries()) {
                    if (delete.state() != SnapshotDeletionsInProgress.State.STARTED) continue;
                    this.deletionsToExecute.add(delete);
                }
                return res;
            }

            @Override
            public void onFailure(String source, Exception e) {
                logger.warn(() -> new ParameterizedMessage("failed to update snapshot state after shards started or nodes removed from [{}] ", (Object)source), (Throwable)e);
            }

            @Override
            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                SnapshotDeletionsInProgress snapshotDeletionsInProgress = newState.custom("snapshot_deletions", SnapshotDeletionsInProgress.EMPTY);
                if (!this.finishedSnapshots.isEmpty()) {
                    Set reposWithRunningDeletes = snapshotDeletionsInProgress.getEntries().stream().filter(entry -> entry.state() == SnapshotDeletionsInProgress.State.STARTED).map(SnapshotDeletionsInProgress.Entry::repository).collect(Collectors.toSet());
                    for (SnapshotsInProgress.Entry entry2 : this.finishedSnapshots) {
                        if (reposWithRunningDeletes.contains(entry2.repository())) continue;
                        SnapshotsService.this.endSnapshot(entry2, newState.metadata(), null);
                    }
                }
                SnapshotsService.this.startExecutableClones(newState.custom("snapshots", SnapshotsInProgress.EMPTY), null);
                for (SnapshotDeletionsInProgress.Entry entry3 : this.deletionsToExecute) {
                    if (!SnapshotsService.this.tryEnterRepoLoop(entry3.repository())) continue;
                    SnapshotsService.this.deleteSnapshotsFromRepository(entry3, newState.nodes().getMinNodeVersion());
                }
            }
        });
    }

    private static ImmutableOpenMap<ShardId, SnapshotsInProgress.ShardSnapshotStatus> processWaitingShardsAndRemovedNodes(SnapshotsInProgress.Entry entry, RoutingTable routingTable, DiscoveryNodes nodes, Map<RepositoryShardId, SnapshotsInProgress.ShardSnapshotStatus> knownFailures) {
        assert (!entry.isClone()) : "clones take a different path";
        boolean snapshotChanged = false;
        ImmutableOpenMap.Builder<ShardId, SnapshotsInProgress.ShardSnapshotStatus> shards = ImmutableOpenMap.builder();
        for (ObjectObjectCursor<RepositoryShardId, SnapshotsInProgress.ShardSnapshotStatus> objectObjectCursor : entry.shardsByRepoShardId()) {
            SnapshotsInProgress.ShardSnapshotStatus shardStatus = (SnapshotsInProgress.ShardSnapshotStatus)objectObjectCursor.value;
            ShardId shardId = entry.shardId((RepositoryShardId)objectObjectCursor.key);
            if (shardStatus.equals(SnapshotsInProgress.ShardSnapshotStatus.UNASSIGNED_QUEUED)) {
                SnapshotsInProgress.ShardSnapshotStatus knownFailure = knownFailures.get(objectObjectCursor.key);
                if (knownFailure == null) {
                    IndexRoutingTable indexShardRoutingTable = routingTable.index(shardId.getIndex());
                    if (indexShardRoutingTable == null) {
                        assert (entry.partial());
                        snapshotChanged = true;
                        logger.debug("failing snapshot of shard [{}] because index got deleted", (Object)shardId);
                        shards.put(shardId, SnapshotsInProgress.ShardSnapshotStatus.MISSING);
                        knownFailures.put((RepositoryShardId)objectObjectCursor.key, SnapshotsInProgress.ShardSnapshotStatus.MISSING);
                        continue;
                    }
                    shards.put(shardId, shardStatus);
                    continue;
                }
                snapshotChanged = true;
                shards.put(shardId, knownFailure);
                continue;
            }
            if (shardStatus.state() == SnapshotsInProgress.ShardState.WAITING) {
                IndexShardRoutingTable shardRouting;
                IndexRoutingTable indexShardRoutingTable = routingTable.index(shardId.getIndex());
                if (indexShardRoutingTable != null && (shardRouting = indexShardRoutingTable.shard(shardId.id())) != null && shardRouting.primaryShard() != null) {
                    if (shardRouting.primaryShard().started()) {
                        snapshotChanged = true;
                        logger.trace("starting shard that we were waiting for [{}] on node [{}]", (Object)shardId, (Object)shardStatus.nodeId());
                        shards.put(shardId, new SnapshotsInProgress.ShardSnapshotStatus(shardRouting.primaryShard().currentNodeId(), shardStatus.generation()));
                        continue;
                    }
                    if (shardRouting.primaryShard().initializing() || shardRouting.primaryShard().relocating()) {
                        shards.put(shardId, shardStatus);
                        continue;
                    }
                }
                snapshotChanged = true;
                logger.warn("failing snapshot of shard [{}] on unassigned shard [{}]", (Object)shardId, (Object)shardStatus.nodeId());
                SnapshotsInProgress.ShardSnapshotStatus failedState = new SnapshotsInProgress.ShardSnapshotStatus(shardStatus.nodeId(), SnapshotsInProgress.ShardState.FAILED, "shard is unassigned", shardStatus.generation());
                shards.put(shardId, failedState);
                knownFailures.put((RepositoryShardId)objectObjectCursor.key, failedState);
                continue;
            }
            if (!shardStatus.state().completed() && shardStatus.nodeId() != null) {
                if (nodes.nodeExists(shardStatus.nodeId())) {
                    shards.put(shardId, shardStatus);
                    continue;
                }
                snapshotChanged = true;
                logger.warn("failing snapshot of shard [{}] on closed node [{}]", (Object)shardId, (Object)shardStatus.nodeId());
                SnapshotsInProgress.ShardSnapshotStatus failedState = new SnapshotsInProgress.ShardSnapshotStatus(shardStatus.nodeId(), SnapshotsInProgress.ShardState.FAILED, "node shutdown", shardStatus.generation());
                shards.put(shardId, failedState);
                knownFailures.put((RepositoryShardId)objectObjectCursor.key, failedState);
                continue;
            }
            shards.put(shardId, shardStatus);
        }
        if (snapshotChanged) {
            return shards.build();
        }
        return null;
    }

    private static boolean waitingShardsStartedOrUnassigned(SnapshotsInProgress snapshotsInProgress, ClusterChangedEvent event) {
        for (java.util.List<SnapshotsInProgress.Entry> entries : snapshotsInProgress.entriesByRepo()) {
            for (SnapshotsInProgress.Entry entry : entries) {
                if (entry.state() != SnapshotsInProgress.State.STARTED || entry.isClone()) continue;
                for (ObjectObjectCursor<RepositoryShardId, SnapshotsInProgress.ShardSnapshotStatus> objectObjectCursor : entry.shardsByRepoShardId()) {
                    RepositoryShardId shardId;
                    SnapshotsInProgress.ShardState state = ((SnapshotsInProgress.ShardSnapshotStatus)objectObjectCursor.value).state();
                    if (state != SnapshotsInProgress.ShardState.WAITING && state != SnapshotsInProgress.ShardState.QUEUED || !event.indexRoutingTableChanged((shardId = (RepositoryShardId)objectObjectCursor.key).indexName())) continue;
                    IndexRoutingTable indexShardRoutingTable = event.state().getRoutingTable().index(entry.indexByName(shardId.indexName()));
                    if (indexShardRoutingTable == null) {
                        return true;
                    }
                    ShardRouting shardRouting = indexShardRoutingTable.shard(shardId.shardId()).primaryShard();
                    if (shardRouting == null || !shardRouting.started() && !shardRouting.unassigned()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean removedNodesCleanupNeeded(SnapshotsInProgress snapshotsInProgress, java.util.List<DiscoveryNode> removedNodes) {
        if (removedNodes.isEmpty()) {
            return false;
        }
        Set removedNodeIds = removedNodes.stream().map(DiscoveryNode::getId).collect(Collectors.toSet());
        return snapshotsInProgress.asStream().anyMatch(snapshot -> {
            if (snapshot.state().completed() || snapshot.isClone()) {
                return false;
            }
            for (SnapshotsInProgress.ShardSnapshotStatus shardSnapshotStatus : snapshot.shardsByRepoShardId().values()) {
                if (shardSnapshotStatus.state().completed() || !removedNodeIds.contains(shardSnapshotStatus.nodeId())) continue;
                return true;
            }
            return false;
        });
    }

    private static Tuple<Set<String>, Set<String>> indicesWithMissingShards(ImmutableOpenMap<ShardId, SnapshotsInProgress.ShardSnapshotStatus> shards, Metadata metadata) {
        HashSet<String> missing = new HashSet<String>();
        HashSet<String> closed = new HashSet<String>();
        for (ObjectObjectCursor<ShardId, SnapshotsInProgress.ShardSnapshotStatus> objectObjectCursor : shards) {
            if (((SnapshotsInProgress.ShardSnapshotStatus)objectObjectCursor.value).state() != SnapshotsInProgress.ShardState.MISSING) continue;
            if (metadata.hasIndex(((ShardId)objectObjectCursor.key).getIndex().getName()) && metadata.getIndexSafe(((ShardId)objectObjectCursor.key).getIndex()).getState() == IndexMetadata.State.CLOSE) {
                closed.add(((ShardId)objectObjectCursor.key).getIndex().getName());
                continue;
            }
            missing.add(((ShardId)objectObjectCursor.key).getIndex().getName());
        }
        return new Tuple(missing, closed);
    }

    private void endSnapshot(SnapshotsInProgress.Entry entry, final Metadata metadata, @Nullable RepositoryData repositoryData) {
        final Snapshot snapshot = entry.snapshot();
        boolean newFinalization = this.endingSnapshots.add(snapshot);
        if (entry.repositoryStateId() == -2L) {
            logger.debug("[{}] was aborted before starting", (Object)snapshot);
            this.removeFailedSnapshotFromClusterState(entry.snapshot(), new SnapshotException(snapshot, "Aborted on initialization"), repositoryData, null);
            return;
        }
        if (entry.isClone() && entry.state() == SnapshotsInProgress.State.FAILED) {
            logger.debug("Removing failed snapshot clone [{}] from cluster state", (Object)entry);
            if (newFinalization) {
                this.removeFailedSnapshotFromClusterState(snapshot, new SnapshotException(snapshot, entry.failure()), null, null);
            }
            return;
        }
        final String repoName = snapshot.getRepository();
        if (this.tryEnterRepoLoop(repoName)) {
            if (repositoryData == null) {
                this.repositoriesService.repository(repoName).getRepositoryData(new ActionListener<RepositoryData>(){

                    @Override
                    public void onResponse(RepositoryData repositoryData) {
                        SnapshotsService.this.finalizeSnapshotEntry(snapshot, metadata, repositoryData);
                    }

                    @Override
                    public void onFailure(Exception e) {
                        SnapshotsService.this.clusterService.submitStateUpdateTask("fail repo tasks for [" + repoName + "]", new FailPendingRepoTasksTask(repoName, e));
                    }
                });
            } else {
                this.finalizeSnapshotEntry(snapshot, metadata, repositoryData);
            }
        } else if (newFinalization) {
            this.repositoryOperations.addFinalization(snapshot, metadata);
        }
    }

    private boolean tryEnterRepoLoop(String repository) {
        return this.currentlyFinalizing.add(repository);
    }

    private void leaveRepoLoop(String repository) {
        boolean removed = this.currentlyFinalizing.remove(repository);
        assert (removed);
    }

    private void finalizeSnapshotEntry(Snapshot snapshot, Metadata metadata, RepositoryData repositoryData) {
        assert (this.currentlyFinalizing.contains(snapshot.getRepository()));
        try {
            SnapshotsInProgress.Entry entry = this.clusterService.state().custom("snapshots", SnapshotsInProgress.EMPTY).snapshot(snapshot);
            String failure = entry.failure();
            logger.trace("[{}] finalizing snapshot in repository, state: [{}], failure[{}]", (Object)snapshot, (Object)entry.state(), (Object)failure);
            ShardGenerations shardGenerations = SnapshotsService.buildGenerations(entry, metadata);
            java.util.List finalIndices = shardGenerations.indices().stream().map(IndexId::getName).collect(Collectors.toList());
            HashSet indexNames = new HashSet(finalIndices);
            ArrayList<SnapshotShardFailure> shardFailures = new ArrayList<SnapshotShardFailure>();
            for (ObjectObjectCursor<RepositoryShardId, SnapshotsInProgress.ShardSnapshotStatus> objectObjectCursor : entry.shardsByRepoShardId()) {
                RepositoryShardId shardId = (RepositoryShardId)objectObjectCursor.key;
                if (!indexNames.contains(shardId.indexName())) {
                    assert (entry.partial()) : "only ignoring shard failures for concurrently deleted indices for partial snapshots";
                    continue;
                }
                SnapshotsInProgress.ShardSnapshotStatus status = (SnapshotsInProgress.ShardSnapshotStatus)objectObjectCursor.value;
                SnapshotsInProgress.ShardState state = status.state();
                if (state.failed()) {
                    shardFailures.add(new SnapshotShardFailure(status.nodeId(), entry.shardId(shardId), status.reason()));
                    continue;
                }
                if (!state.completed()) {
                    shardFailures.add(new SnapshotShardFailure(status.nodeId(), entry.shardId(shardId), "skipped"));
                    continue;
                }
                assert (state == SnapshotsInProgress.ShardState.SUCCESS);
            }
            String repository = snapshot.getRepository();
            StepListener<Metadata> stepListener = new StepListener<Metadata>();
            Repository repo = this.repositoriesService.repository(snapshot.getRepository());
            if (entry.isClone()) {
                this.threadPool.executor("snapshot").execute(ActionRunnable.supply(stepListener, () -> {
                    Metadata existing = repo.getSnapshotGlobalMetadata(entry.source());
                    Metadata.Builder metaBuilder = Metadata.builder(existing);
                    HashSet<Index> existingIndices = new HashSet<Index>();
                    for (IndexId indexId : entry.indices().values()) {
                        IndexMetadata indexMetadata = repo.getSnapshotIndexMetaData(repositoryData, entry.source(), indexId);
                        existingIndices.add(indexMetadata.getIndex());
                        metaBuilder.put(indexMetadata, false);
                    }
                    HashMap<String, DataStream> dataStreamsToCopy = new HashMap<String, DataStream>();
                    for (Map.Entry<String, DataStream> entry2 : existing.dataStreams().entrySet()) {
                        if (!existingIndices.containsAll(entry2.getValue().getIndices())) continue;
                        dataStreamsToCopy.put(entry2.getKey(), entry2.getValue());
                    }
                    Map<String, DataStreamAlias> map = SnapshotsService.filterDataStreamAliases(dataStreamsToCopy, existing.dataStreamAliases());
                    metaBuilder.dataStreams(dataStreamsToCopy, map);
                    return metaBuilder.build();
                }));
            } else {
                stepListener.onResponse(metadata);
            }
            stepListener.whenComplete(meta -> {
                Metadata metaForSnapshot = SnapshotsService.metadataForSnapshot(entry, meta);
                HashMap<String, SnapshotInfo.IndexSnapshotDetails> indexSnapshotDetails = new HashMap<String, SnapshotInfo.IndexSnapshotDetails>(finalIndices.size());
                for (ObjectObjectCursor<RepositoryShardId, SnapshotsInProgress.ShardSnapshotStatus> objectObjectCursor : entry.shardsByRepoShardId()) {
                    indexSnapshotDetails.compute(((RepositoryShardId)objectObjectCursor.key).indexName(), (indexName, current) -> {
                        if (current == SnapshotInfo.IndexSnapshotDetails.SKIPPED) {
                            return current;
                        }
                        SnapshotsInProgress.ShardSnapshotStatus shardSnapshotStatus = (SnapshotsInProgress.ShardSnapshotStatus)shardEntry.value;
                        if (shardSnapshotStatus.state() != SnapshotsInProgress.ShardState.SUCCESS) {
                            return SnapshotInfo.IndexSnapshotDetails.SKIPPED;
                        }
                        ShardSnapshotResult result = shardSnapshotStatus.shardSnapshotResult();
                        if (result == null) {
                            return SnapshotInfo.IndexSnapshotDetails.SKIPPED;
                        }
                        if (current == null) {
                            return new SnapshotInfo.IndexSnapshotDetails(1, result.getSize(), result.getSegmentCount());
                        }
                        return new SnapshotInfo.IndexSnapshotDetails(current.getShardCount() + 1, new ByteSizeValue(current.getSize().getBytes() + result.getSize().getBytes()), Math.max(current.getMaxSegmentsPerShard(), result.getSegmentCount()));
                    });
                }
                indexSnapshotDetails.entrySet().removeIf(e -> ((SnapshotInfo.IndexSnapshotDetails)e.getValue()).getShardCount() == 0);
                SnapshotInfo snapshotInfo = new SnapshotInfo(snapshot, finalIndices, entry.dataStreams().stream().filter(metaForSnapshot.dataStreams()::containsKey).collect(Collectors.toList()), entry.partial() ? this.onlySuccessfulFeatureStates(entry, finalIndices) : entry.featureStates(), failure, this.threadPool.absoluteTimeInMillis(), entry.partial() ? shardGenerations.totalShards() : entry.shardsByRepoShardId().size(), shardFailures, entry.includeGlobalState(), entry.userMetadata(), entry.startTime(), indexSnapshotDetails);
                repo.finalizeSnapshot(new FinalizeSnapshotContext(shardGenerations, repositoryData.getGenId(), metaForSnapshot, snapshotInfo, entry.version(), ActionListener.wrap(result -> {
                    SnapshotInfo writtenSnapshotInfo = (SnapshotInfo)result.v2();
                    SnapshotsService.completeListenersIgnoringException(this.endAndGetListenersToResolve(writtenSnapshotInfo.snapshot()), result);
                    logger.info("snapshot [{}] completed with state [{}]", (Object)snapshot, (Object)writtenSnapshotInfo.state());
                    this.runNextQueuedOperation((RepositoryData)result.v1(), repository, true);
                }, e -> this.handleFinalizationFailure((Exception)e, snapshot, repositoryData))));
            }, e -> this.handleFinalizationFailure((Exception)e, snapshot, repositoryData));
        }
        catch (Exception e2) {
            assert (false) : new AssertionError((Object)e2);
            this.handleFinalizationFailure(e2, snapshot, repositoryData);
        }
    }

    private java.util.List<SnapshotFeatureInfo> onlySuccessfulFeatureStates(SnapshotsInProgress.Entry entry, java.util.List<String> finalIndices) {
        assert (entry.partial()) : "should not try to filter feature states from a non-partial entry";
        HashSet indicesWithUnsuccessfulShards = new HashSet();
        entry.shardsByRepoShardId().iterator().forEachRemaining(shard -> {
            SnapshotsInProgress.ShardState shardState = ((SnapshotsInProgress.ShardSnapshotStatus)shard.value).state();
            if (shardState.failed() || !shardState.completed()) {
                indicesWithUnsuccessfulShards.add(((RepositoryShardId)shard.key).indexName());
            }
        });
        return entry.featureStates().stream().filter(stateInfo -> finalIndices.containsAll(stateInfo.getIndices())).filter(stateInfo -> !stateInfo.getIndices().stream().anyMatch(indicesWithUnsuccessfulShards::contains)).collect(Collectors.toList());
    }

    private java.util.List<ActionListener<Tuple<RepositoryData, SnapshotInfo>>> endAndGetListenersToResolve(Snapshot snapshot) {
        java.util.List<ActionListener<Tuple<RepositoryData, SnapshotInfo>>> listenersToComplete = this.snapshotCompletionListeners.remove(snapshot);
        this.endingSnapshots.remove(snapshot);
        return listenersToComplete;
    }

    private void handleFinalizationFailure(Exception e, Snapshot snapshot, RepositoryData repositoryData) {
        if (ExceptionsHelper.unwrap(e, NotMasterException.class, FailedToCommitClusterStateException.class) != null) {
            logger.debug(() -> new ParameterizedMessage("[{}] failed to update cluster state during snapshot finalization", (Object)snapshot), (Throwable)e);
            this.failSnapshotCompletionListeners(snapshot, new SnapshotException(snapshot, "Failed to update cluster state during snapshot finalization", e));
            this.failAllListenersOnMasterFailOver(e);
        } else {
            logger.warn(() -> new ParameterizedMessage("[{}] failed to finalize snapshot", (Object)snapshot), (Throwable)e);
            this.removeFailedSnapshotFromClusterState(snapshot, e, repositoryData, null);
        }
    }

    private void runNextQueuedOperation(RepositoryData repositoryData, String repository, boolean attemptDelete) {
        assert (this.currentlyFinalizing.contains(repository));
        Tuple<Snapshot, Metadata> nextFinalization = this.repositoryOperations.pollFinalization(repository);
        if (nextFinalization == null) {
            if (attemptDelete) {
                this.runReadyDeletions(repositoryData, repository);
            } else {
                this.leaveRepoLoop(repository);
            }
        } else {
            logger.trace("Moving on to finalizing next snapshot [{}]", nextFinalization);
            this.finalizeSnapshotEntry((Snapshot)nextFinalization.v1(), (Metadata)nextFinalization.v2(), repositoryData);
        }
    }

    private void runReadyDeletions(final RepositoryData repositoryData, final String repository) {
        this.clusterService.submitStateUpdateTask("Run ready deletions", new ClusterStateUpdateTask(){
            private SnapshotDeletionsInProgress.Entry deletionToRun;

            @Override
            public ClusterState execute(ClusterState currentState) {
                assert (SnapshotsService.readyDeletions(currentState).v1() == currentState) : "Deletes should have been set to ready by finished snapshot deletes and finalizations";
                for (SnapshotDeletionsInProgress.Entry entry : currentState.custom("snapshot_deletions", SnapshotDeletionsInProgress.EMPTY).getEntries()) {
                    if (!entry.repository().equals(repository) || entry.state() != SnapshotDeletionsInProgress.State.STARTED) continue;
                    this.deletionToRun = entry;
                    break;
                }
                return currentState;
            }

            @Override
            public void onFailure(String source, Exception e) {
                logger.warn("Failed to run ready delete operations", (Throwable)e);
                SnapshotsService.this.failAllListenersOnMasterFailOver(e);
            }

            @Override
            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                if (this.deletionToRun == null) {
                    SnapshotsService.this.runNextQueuedOperation(repositoryData, repository, false);
                } else {
                    SnapshotsService.this.deleteSnapshotsFromRepository(this.deletionToRun, repositoryData, newState.nodes().getMinNodeVersion());
                }
            }
        });
    }

    private static Tuple<ClusterState, java.util.List<SnapshotDeletionsInProgress.Entry>> readyDeletions(ClusterState currentState) {
        SnapshotDeletionsInProgress deletions = currentState.custom("snapshot_deletions", SnapshotDeletionsInProgress.EMPTY);
        if (!deletions.hasDeletionsInProgress()) {
            return Tuple.tuple((Object)currentState, Collections.emptyList());
        }
        SnapshotsInProgress snapshotsInProgress = (SnapshotsInProgress)currentState.custom("snapshots");
        assert (snapshotsInProgress != null);
        HashSet<String> repositoriesSeen = new HashSet<String>();
        boolean changed = false;
        ArrayList<SnapshotDeletionsInProgress.Entry> readyDeletions = new ArrayList<SnapshotDeletionsInProgress.Entry>();
        ArrayList<SnapshotDeletionsInProgress.Entry> newDeletes = new ArrayList<SnapshotDeletionsInProgress.Entry>();
        for (SnapshotDeletionsInProgress.Entry entry : deletions.getEntries()) {
            String repo = entry.repository();
            if (repositoriesSeen.add(entry.repository()) && entry.state() == SnapshotDeletionsInProgress.State.WAITING && snapshotsInProgress.forRepo(repo).stream().noneMatch(SnapshotsService::isWritingToRepository)) {
                changed = true;
                SnapshotDeletionsInProgress.Entry newEntry = entry.started();
                readyDeletions.add(newEntry);
                newDeletes.add(newEntry);
                continue;
            }
            newDeletes.add(entry);
        }
        return Tuple.tuple((Object)(changed ? ClusterState.builder(currentState).putCustom("snapshot_deletions", SnapshotDeletionsInProgress.of(newDeletes)).build() : currentState), readyDeletions);
    }

    public static ClusterState stateWithoutSnapshot(ClusterState state, Snapshot snapshot) {
        SnapshotsInProgress snapshots = state.custom("snapshots", SnapshotsInProgress.EMPTY);
        ClusterState result = state;
        int indexOfEntry = -1;
        java.util.List<SnapshotsInProgress.Entry> entryList = snapshots.forRepo(snapshot.getRepository());
        for (int i = 0; i < entryList.size(); ++i) {
            SnapshotsInProgress.Entry entry = entryList.get(i);
            if (!entry.snapshot().equals(snapshot)) continue;
            indexOfEntry = i;
            break;
        }
        if (indexOfEntry >= 0) {
            int i;
            ArrayList<SnapshotsInProgress.Entry> entries = new ArrayList<SnapshotsInProgress.Entry>(entryList.size() - 1);
            SnapshotsInProgress.Entry removedEntry = entryList.get(indexOfEntry);
            for (i = 0; i < indexOfEntry; ++i) {
                RepositoryShardId repositoryShardId;
                SnapshotsInProgress.ShardSnapshotStatus shardState;
                ImmutableOpenMap.Builder<Writeable, SnapshotsInProgress.ShardSnapshotStatus> updatedShardAssignments;
                SnapshotsInProgress.Entry previousEntry = entryList.get(i);
                if (removedEntry.isClone()) {
                    if (previousEntry.isClone()) {
                        updatedShardAssignments = null;
                        for (ObjectObjectCursor<RepositoryShardId, SnapshotsInProgress.ShardSnapshotStatus> objectObjectCursor : removedEntry.shardsByRepoShardId()) {
                            shardState = (SnapshotsInProgress.ShardSnapshotStatus)objectObjectCursor.value;
                            if (shardState.state() != SnapshotsInProgress.ShardState.SUCCESS) continue;
                            updatedShardAssignments = SnapshotsService.maybeAddUpdatedAssignment(updatedShardAssignments, shardState, (RepositoryShardId)objectObjectCursor.key, previousEntry.shardsByRepoShardId());
                        }
                        SnapshotsService.addCloneEntry(entries, previousEntry, updatedShardAssignments);
                        continue;
                    }
                    updatedShardAssignments = null;
                    for (ObjectObjectCursor<RepositoryShardId, SnapshotsInProgress.ShardSnapshotStatus> objectObjectCursor : removedEntry.shardsByRepoShardId()) {
                        shardState = (SnapshotsInProgress.ShardSnapshotStatus)objectObjectCursor.value;
                        repositoryShardId = (RepositoryShardId)objectObjectCursor.key;
                        if (shardState.state() != SnapshotsInProgress.ShardState.SUCCESS || !previousEntry.shardsByRepoShardId().containsKey(repositoryShardId)) continue;
                        updatedShardAssignments = SnapshotsService.maybeAddUpdatedAssignment(updatedShardAssignments, shardState, previousEntry.shardId(repositoryShardId), previousEntry.shards());
                    }
                    SnapshotsService.addSnapshotEntry(entries, previousEntry, updatedShardAssignments);
                    continue;
                }
                if (previousEntry.isClone()) {
                    updatedShardAssignments = null;
                    for (ObjectObjectCursor<RepositoryShardId, SnapshotsInProgress.ShardSnapshotStatus> objectObjectCursor : removedEntry.shardsByRepoShardId()) {
                        shardState = (SnapshotsInProgress.ShardSnapshotStatus)objectObjectCursor.value;
                        repositoryShardId = (RepositoryShardId)objectObjectCursor.key;
                        if (shardState.state() != SnapshotsInProgress.ShardState.SUCCESS || !previousEntry.shardsByRepoShardId().containsKey(repositoryShardId)) continue;
                        updatedShardAssignments = SnapshotsService.maybeAddUpdatedAssignment(updatedShardAssignments, shardState, repositoryShardId, previousEntry.shardsByRepoShardId());
                    }
                    SnapshotsService.addCloneEntry(entries, previousEntry, updatedShardAssignments);
                    continue;
                }
                updatedShardAssignments = null;
                for (ObjectObjectCursor<RepositoryShardId, SnapshotsInProgress.ShardSnapshotStatus> objectObjectCursor : removedEntry.shardsByRepoShardId()) {
                    shardState = (SnapshotsInProgress.ShardSnapshotStatus)objectObjectCursor.value;
                    if (shardState.state() != SnapshotsInProgress.ShardState.SUCCESS || !previousEntry.shardsByRepoShardId().containsKey((RepositoryShardId)objectObjectCursor.key)) continue;
                    updatedShardAssignments = SnapshotsService.maybeAddUpdatedAssignment(updatedShardAssignments, shardState, previousEntry.shardId((RepositoryShardId)objectObjectCursor.key), previousEntry.shards());
                }
                SnapshotsService.addSnapshotEntry(entries, previousEntry, updatedShardAssignments);
            }
            for (i = indexOfEntry + 1; i < entryList.size(); ++i) {
                entries.add(entryList.get(i));
            }
            result = ClusterState.builder(state).putCustom("snapshots", snapshots.withUpdatedEntriesForRepo(snapshot.getRepository(), entries)).build();
        }
        return (ClusterState)SnapshotsService.readyDeletions(result).v1();
    }

    private static void addSnapshotEntry(java.util.List<SnapshotsInProgress.Entry> entries, SnapshotsInProgress.Entry entryToUpdate, @Nullable ImmutableOpenMap.Builder<ShardId, SnapshotsInProgress.ShardSnapshotStatus> updatedShardAssignments) {
        if (updatedShardAssignments == null) {
            entries.add(entryToUpdate);
        } else {
            ImmutableOpenMap.Builder<ShardId, SnapshotsInProgress.ShardSnapshotStatus> updatedStatus = ImmutableOpenMap.builder(entryToUpdate.shards());
            updatedStatus.putAll(updatedShardAssignments.build());
            entries.add(entryToUpdate.withShardStates(updatedStatus.build()));
        }
    }

    private static void addCloneEntry(java.util.List<SnapshotsInProgress.Entry> entries, SnapshotsInProgress.Entry entryToUpdate, @Nullable ImmutableOpenMap.Builder<RepositoryShardId, SnapshotsInProgress.ShardSnapshotStatus> updatedShardAssignments) {
        if (updatedShardAssignments == null) {
            entries.add(entryToUpdate);
        } else {
            ImmutableOpenMap.Builder<RepositoryShardId, SnapshotsInProgress.ShardSnapshotStatus> updatedStatus = ImmutableOpenMap.builder(entryToUpdate.shardsByRepoShardId());
            updatedStatus.putAll(updatedShardAssignments.build());
            entries.add(entryToUpdate.withClones(updatedStatus.build()));
        }
    }

    @Nullable
    private static <T> ImmutableOpenMap.Builder<T, SnapshotsInProgress.ShardSnapshotStatus> maybeAddUpdatedAssignment(@Nullable ImmutableOpenMap.Builder<T, SnapshotsInProgress.ShardSnapshotStatus> updatedShardAssignments, SnapshotsInProgress.ShardSnapshotStatus finishedShardState, T shardId, ImmutableOpenMap<T, SnapshotsInProgress.ShardSnapshotStatus> statesToUpdate) {
        ShardGeneration newGeneration = finishedShardState.generation();
        SnapshotsInProgress.ShardSnapshotStatus stateToUpdate = statesToUpdate.get(shardId);
        if (stateToUpdate != null && stateToUpdate.state() == SnapshotsInProgress.ShardState.SUCCESS && !Objects.equals(newGeneration, stateToUpdate.generation())) {
            if (updatedShardAssignments == null) {
                updatedShardAssignments = ImmutableOpenMap.builder();
            }
            updatedShardAssignments.put(shardId, stateToUpdate.withUpdatedGeneration(newGeneration));
        }
        return updatedShardAssignments;
    }

    private void removeFailedSnapshotFromClusterState(final Snapshot snapshot, final Exception failure, final @Nullable RepositoryData repositoryData, final @Nullable CleanupAfterErrorListener listener) {
        assert (failure != null) : "Failure must be supplied";
        this.clusterService.submitStateUpdateTask("remove snapshot metadata", new ClusterStateUpdateTask(){

            @Override
            public ClusterState execute(ClusterState currentState) {
                ClusterState updatedState = SnapshotsService.stateWithoutSnapshot(currentState, snapshot);
                assert (updatedState == currentState || SnapshotsService.this.endingSnapshots.contains(snapshot)) : "did not track [" + snapshot + "] in ending snapshots while removing it from the cluster state";
                return SnapshotsService.updateWithSnapshots(updatedState, null, SnapshotsService.deletionsWithoutSnapshots(updatedState.custom("snapshot_deletions", SnapshotDeletionsInProgress.EMPTY), Collections.singletonList(snapshot.getSnapshotId()), snapshot.getRepository()));
            }

            @Override
            public void onFailure(String source, Exception e) {
                logger.warn(() -> new ParameterizedMessage("[{}] failed to remove snapshot metadata", (Object)snapshot), (Throwable)e);
                SnapshotsService.this.failSnapshotCompletionListeners(snapshot, new SnapshotException(snapshot, "Failed to remove snapshot from cluster state", e));
                SnapshotsService.this.failAllListenersOnMasterFailOver(e);
                if (listener != null) {
                    listener.onFailure(e);
                }
            }

            @Override
            public void onNoLongerMaster(String source) {
                failure.addSuppressed(new SnapshotException(snapshot, "no longer master"));
                SnapshotsService.this.failSnapshotCompletionListeners(snapshot, failure);
                SnapshotsService.this.failAllListenersOnMasterFailOver(new NotMasterException(source));
                if (listener != null) {
                    listener.onNoLongerMaster();
                }
            }

            @Override
            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                SnapshotsService.this.failSnapshotCompletionListeners(snapshot, failure);
                if (listener == null) {
                    if (repositoryData != null) {
                        SnapshotsService.this.runNextQueuedOperation(repositoryData, snapshot.getRepository(), true);
                    }
                } else {
                    listener.onFailure(null);
                }
            }
        });
    }

    @Nullable
    private static SnapshotDeletionsInProgress deletionsWithoutSnapshots(SnapshotDeletionsInProgress deletions, Collection<SnapshotId> snapshotIds, String repository) {
        boolean changed = false;
        ArrayList<SnapshotDeletionsInProgress.Entry> updatedEntries = new ArrayList<SnapshotDeletionsInProgress.Entry>(deletions.getEntries().size());
        for (SnapshotDeletionsInProgress.Entry entry : deletions.getEntries()) {
            if (entry.repository().equals(repository)) {
                ArrayList<SnapshotId> updatedSnapshotIds = new ArrayList<SnapshotId>(entry.getSnapshots());
                if (updatedSnapshotIds.removeAll(snapshotIds)) {
                    changed = true;
                    updatedEntries.add(entry.withSnapshots(updatedSnapshotIds));
                    continue;
                }
                updatedEntries.add(entry);
                continue;
            }
            updatedEntries.add(entry);
        }
        return changed ? SnapshotDeletionsInProgress.of(updatedEntries) : null;
    }

    private void failSnapshotCompletionListeners(Snapshot snapshot, Exception e) {
        SnapshotsService.failListenersIgnoringException(this.endAndGetListenersToResolve(snapshot), e);
        assert (this.repositoryOperations.assertNotQueued(snapshot));
    }

    public void deleteSnapshots(DeleteSnapshotRequest request, ActionListener<Void> listener) {
        String repositoryName = request.repository();
        Object[] snapshotNames = request.snapshots();
        logger.info(() -> SnapshotsService.lambda$deleteSnapshots$40((String[])snapshotNames, repositoryName));
        Repository repository = this.repositoriesService.repository(repositoryName);
        String taskDescription = "delete snapshot [" + repository + "]" + Arrays.toString(snapshotNames);
        repository.executeConsistentStateUpdate(arg_0 -> this.lambda$deleteSnapshots$41(request, (String[])snapshotNames, repositoryName, listener, taskDescription, arg_0), taskDescription, listener::onFailure);
    }

    private ClusterStateUpdateTask createDeleteStateUpdate(final java.util.List<SnapshotId> snapshotIds, final String repoName, final RepositoryData repositoryData, Priority priority, final ActionListener<Void> listener) {
        if (snapshotIds.isEmpty()) {
            return new ClusterStateUpdateTask(){

                @Override
                public ClusterState execute(ClusterState currentState) {
                    return currentState;
                }

                @Override
                public void onFailure(String source, Exception e) {
                    listener.onFailure(e);
                }

                @Override
                public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                    listener.onResponse(null);
                }
            };
        }
        return new ClusterStateUpdateTask(priority){
            private SnapshotDeletionsInProgress.Entry newDelete;
            private boolean reusedExistingDelete;
            private final Collection<Snapshot> completedNoCleanup;
            private final Collection<SnapshotsInProgress.Entry> completedWithCleanup;
            {
                super(priority);
                this.reusedExistingDelete = false;
                this.completedNoCleanup = new ArrayList<Snapshot>();
                this.completedWithCleanup = new ArrayList<SnapshotsInProgress.Entry>();
            }

            @Override
            public ClusterState execute(ClusterState currentState) {
                SnapshotDeletionsInProgress.Entry replacedEntry;
                SnapshotsInProgress updatedSnapshots;
                SnapshotDeletionsInProgress deletionsInProgress = currentState.custom("snapshot_deletions", SnapshotDeletionsInProgress.EMPTY);
                Version minNodeVersion = currentState.nodes().getMinNodeVersion();
                if (minNodeVersion.before(FULL_CONCURRENCY_VERSION) && deletionsInProgress.hasDeletionsInProgress()) {
                    throw new ConcurrentSnapshotExecutionException(new Snapshot(repoName, (SnapshotId)snapshotIds.get(0)), "cannot delete - another snapshot is currently being deleted in [" + deletionsInProgress + "]");
                }
                SnapshotsService.ensureNoCleanupInProgress(currentState, repoName, ((SnapshotId)snapshotIds.get(0)).getName(), "delete snapshot");
                RestoreInProgress restoreInProgress = currentState.custom("restore", RestoreInProgress.EMPTY);
                for (RestoreInProgress.Entry entry2 : restoreInProgress) {
                    if (!repoName.equals(entry2.snapshot().getRepository()) || !snapshotIds.contains(entry2.snapshot().getSnapshotId())) continue;
                    throw new ConcurrentSnapshotExecutionException(new Snapshot(repoName, (SnapshotId)snapshotIds.get(0)), "cannot delete snapshot during a restore in progress in [" + restoreInProgress + "]");
                }
                SnapshotsInProgress snapshots = currentState.custom("snapshots", SnapshotsInProgress.EMPTY);
                Set activeCloneSources = snapshots.asStream().filter(SnapshotsInProgress.Entry::isClone).map(SnapshotsInProgress.Entry::source).collect(Collectors.toSet());
                for (SnapshotId snapshotId : snapshotIds) {
                    if (!activeCloneSources.contains(snapshotId)) continue;
                    throw new ConcurrentSnapshotExecutionException(new Snapshot(repoName, snapshotId), "cannot delete snapshot while it is being cloned");
                }
                HashSet<SnapshotId> snapshotIdsRequiringCleanup = new HashSet<SnapshotId>(snapshotIds);
                if (minNodeVersion.onOrAfter(FULL_CONCURRENCY_VERSION)) {
                    updatedSnapshots = snapshots.withUpdatedEntriesForRepo(repoName, snapshots.forRepo(repoName).stream().map(existing -> {
                        if (existing.state() == SnapshotsInProgress.State.STARTED && snapshotIdsRequiringCleanup.contains(existing.snapshot().getSnapshotId())) {
                            SnapshotsInProgress.Entry abortedEntry = existing.abort();
                            if (abortedEntry == null) {
                                Snapshot existingNotYetStartedSnapshot = existing.snapshot();
                                if (SnapshotsService.this.endingSnapshots.add(existingNotYetStartedSnapshot)) {
                                    this.completedNoCleanup.add(existingNotYetStartedSnapshot);
                                }
                                snapshotIdsRequiringCleanup.remove(existingNotYetStartedSnapshot.getSnapshotId());
                            } else if (abortedEntry.state().completed()) {
                                this.completedWithCleanup.add(abortedEntry);
                            }
                            return abortedEntry;
                        }
                        return existing;
                    }).filter(Objects::nonNull).collect(Collectors.toList()));
                    if (snapshotIdsRequiringCleanup.isEmpty()) {
                        return SnapshotsService.updateWithSnapshots(currentState, updatedSnapshots, null);
                    }
                } else {
                    if (!snapshots.isEmpty()) {
                        throw new ConcurrentSnapshotExecutionException(repoName, snapshotIds.toString(), "another snapshot is currently running cannot delete");
                    }
                    updatedSnapshots = snapshots;
                }
                if ((replacedEntry = (SnapshotDeletionsInProgress.Entry)deletionsInProgress.getEntries().stream().filter(entry -> entry.repository().equals(repoName) && entry.state() == SnapshotDeletionsInProgress.State.WAITING).findFirst().orElse(null)) == null) {
                    Optional<SnapshotDeletionsInProgress.Entry> foundDuplicate = deletionsInProgress.getEntries().stream().filter(entry -> entry.repository().equals(repoName) && entry.state() == SnapshotDeletionsInProgress.State.STARTED && entry.getSnapshots().containsAll(snapshotIds)).findFirst();
                    if (foundDuplicate.isPresent()) {
                        this.newDelete = foundDuplicate.get();
                        this.reusedExistingDelete = true;
                        return currentState;
                    }
                    this.newDelete = new SnapshotDeletionsInProgress.Entry(Collections.unmodifiableList(new ArrayList<SnapshotId>(snapshotIdsRequiringCleanup)), repoName, SnapshotsService.this.threadPool.absoluteTimeInMillis(), repositoryData.getGenId(), updatedSnapshots.forRepo(repoName).stream().noneMatch(x$0 -> SnapshotsService.isWritingToRepository(x$0)) && !deletionsInProgress.hasExecutingDeletion(repoName) ? SnapshotDeletionsInProgress.State.STARTED : SnapshotDeletionsInProgress.State.WAITING);
                } else {
                    this.newDelete = replacedEntry.withAddedSnapshots(snapshotIdsRequiringCleanup);
                }
                return SnapshotsService.updateWithSnapshots(currentState, updatedSnapshots, (replacedEntry == null ? deletionsInProgress : deletionsInProgress.withRemovedEntry(replacedEntry.uuid())).withAddedEntry(this.newDelete));
            }

            @Override
            public void onFailure(String source, Exception e) {
                SnapshotsService.this.endingSnapshots.removeAll(this.completedNoCleanup);
                listener.onFailure(e);
            }

            @Override
            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                if (!this.completedNoCleanup.isEmpty()) {
                    logger.info("snapshots {} aborted", this.completedNoCleanup);
                }
                for (Snapshot snapshot : this.completedNoCleanup) {
                    SnapshotsService.this.failSnapshotCompletionListeners(snapshot, new SnapshotException(snapshot, "Snapshot was aborted by deletion"));
                }
                if (this.newDelete == null) {
                    listener.onResponse(null);
                } else {
                    SnapshotsService.this.addDeleteListener(this.newDelete.uuid(), listener);
                    if (this.reusedExistingDelete) {
                        return;
                    }
                    if (this.newDelete.state() == SnapshotDeletionsInProgress.State.STARTED) {
                        if (SnapshotsService.this.tryEnterRepoLoop(repoName)) {
                            SnapshotsService.this.deleteSnapshotsFromRepository(this.newDelete, repositoryData, newState.nodes().getMinNodeVersion());
                        } else {
                            logger.trace("Delete [{}] could not execute directly and was queued", (Object)this.newDelete);
                        }
                    } else {
                        for (SnapshotsInProgress.Entry completedSnapshot : this.completedWithCleanup) {
                            SnapshotsService.this.endSnapshot(completedSnapshot, newState.metadata(), repositoryData);
                        }
                    }
                }
            }
        };
    }

    private static boolean isWritingToRepository(SnapshotsInProgress.Entry entry) {
        if (entry.state().completed()) {
            return true;
        }
        for (SnapshotsInProgress.ShardSnapshotStatus value : entry.shardsByRepoShardId().values()) {
            if (!value.isActive()) continue;
            return true;
        }
        return false;
    }

    private void addDeleteListener(String deleteUUID, ActionListener<Void> listener) {
        this.snapshotDeletionListeners.computeIfAbsent(deleteUUID, k -> new CopyOnWriteArrayList()).add(listener);
    }

    public Version minCompatibleVersion(Version minNodeVersion, RepositoryData repositoryData, @Nullable Collection<SnapshotId> excluded) {
        Version minCompatVersion = minNodeVersion;
        Collection<SnapshotId> snapshotIds = repositoryData.getSnapshotIds();
        for (SnapshotId snapshotId : snapshotIds.stream().filter(excluded == null ? sn -> true : sn -> !excluded.contains(sn)).collect(Collectors.toList())) {
            Version known = repositoryData.getVersion(snapshotId);
            if (known == null) {
                assert (repositoryData.shardGenerations().totalShards() == 0) : "Saw shard generations [" + repositoryData.shardGenerations() + "] but did not have versions tracked for snapshot [" + snapshotId + "]";
                return OLD_SNAPSHOT_FORMAT;
            }
            minCompatVersion = minCompatVersion.before(known) ? minCompatVersion : known;
        }
        return minCompatVersion;
    }

    public static boolean useShardGenerations(Version repositoryMetaVersion) {
        return repositoryMetaVersion.onOrAfter(SHARD_GEN_IN_REPO_DATA_VERSION);
    }

    public static boolean useIndexGenerations(Version repositoryMetaVersion) {
        return repositoryMetaVersion.onOrAfter(INDEX_GEN_IN_REPO_DATA_VERSION);
    }

    public static boolean includesUUIDs(Version repositoryMetaVersion) {
        return repositoryMetaVersion.onOrAfter(UUIDS_IN_REPO_DATA_VERSION);
    }

    public static boolean includeFileInfoWriterUUID(Version repositoryMetaVersion) {
        return repositoryMetaVersion.onOrAfter(FILE_INFO_WRITER_UUIDS_IN_SHARD_DATA_VERSION);
    }

    private void deleteSnapshotsFromRepository(final SnapshotDeletionsInProgress.Entry deleteEntry, final Version minNodeVersion) {
        final long expectedRepoGen = deleteEntry.repositoryStateId();
        this.repositoriesService.getRepositoryData(deleteEntry.repository(), new ActionListener<RepositoryData>(){

            @Override
            public void onResponse(RepositoryData repositoryData) {
                assert (repositoryData.getGenId() == expectedRepoGen) : "Repository generation should not change as long as a ready delete is found in the cluster state but found [" + expectedRepoGen + "] in cluster state and [" + repositoryData.getGenId() + "] in the repository";
                SnapshotsService.this.deleteSnapshotsFromRepository(deleteEntry, repositoryData, minNodeVersion);
            }

            @Override
            public void onFailure(Exception e) {
                SnapshotsService.this.clusterService.submitStateUpdateTask("fail repo tasks for [" + deleteEntry.repository() + "]", new FailPendingRepoTasksTask(deleteEntry.repository(), e));
            }
        });
    }

    private void deleteSnapshotsFromRepository(SnapshotDeletionsInProgress.Entry deleteEntry, RepositoryData repositoryData, Version minNodeVersion) {
        if (this.repositoryOperations.startDeletion(deleteEntry.uuid())) {
            assert (this.currentlyFinalizing.contains(deleteEntry.repository()));
            java.util.List<SnapshotId> snapshotIds = deleteEntry.getSnapshots();
            assert (deleteEntry.state() == SnapshotDeletionsInProgress.State.STARTED) : "incorrect state for entry [" + deleteEntry + "]";
            this.repositoriesService.repository(deleteEntry.repository()).deleteSnapshots(snapshotIds, repositoryData.getGenId(), this.minCompatibleVersion(minNodeVersion, repositoryData, snapshotIds), ActionListener.wrap(updatedRepoData -> {
                logger.info("snapshots {} deleted", (Object)snapshotIds);
                this.removeSnapshotDeletionFromClusterState(deleteEntry, null, (RepositoryData)updatedRepoData);
            }, ex -> this.removeSnapshotDeletionFromClusterState(deleteEntry, (Exception)ex, repositoryData)));
        }
    }

    private void removeSnapshotDeletionFromClusterState(SnapshotDeletionsInProgress.Entry deleteEntry, final @Nullable Exception failure, final RepositoryData repositoryData) {
        RemoveSnapshotDeletionAndContinueTask clusterStateUpdateTask = failure == null ? new RemoveSnapshotDeletionAndContinueTask(deleteEntry, repositoryData){

            @Override
            protected SnapshotDeletionsInProgress filterDeletions(SnapshotDeletionsInProgress deletions) {
                SnapshotDeletionsInProgress updatedDeletions = SnapshotsService.deletionsWithoutSnapshots(deletions, this.deleteEntry.getSnapshots(), this.deleteEntry.repository());
                return updatedDeletions == null ? deletions : updatedDeletions;
            }

            @Override
            protected void handleListeners(java.util.List<ActionListener<Void>> deleteListeners) {
                assert (repositoryData.getSnapshotIds().stream().noneMatch(this.deleteEntry.getSnapshots()::contains)) : "Repository data contained snapshot ids " + repositoryData.getSnapshotIds() + " that should should been deleted by [" + this.deleteEntry + "]";
                SnapshotsService.completeListenersIgnoringException(deleteListeners, null);
            }
        } : new RemoveSnapshotDeletionAndContinueTask(deleteEntry, repositoryData){

            @Override
            protected void handleListeners(java.util.List<ActionListener<Void>> deleteListeners) {
                SnapshotsService.failListenersIgnoringException(deleteListeners, failure);
            }
        };
        this.clusterService.submitStateUpdateTask("remove snapshot deletion metadata", clusterStateUpdateTask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void failAllListenersOnMasterFailOver(Exception e) {
        logger.debug("Failing all snapshot operation listeners because this node is not master any longer", (Throwable)e);
        Set<String> set = this.currentlyFinalizing;
        synchronized (set) {
            if (ExceptionsHelper.unwrap(e, NotMasterException.class, FailedToCommitClusterStateException.class) != null) {
                this.repositoryOperations.clear();
                for (Snapshot snapshot : new HashSet<Snapshot>(this.snapshotCompletionListeners.keySet())) {
                    this.failSnapshotCompletionListeners(snapshot, new SnapshotException(snapshot, "no longer master"));
                }
                RepositoryException wrapped = new RepositoryException("_all", "Failed to update cluster state during repository operation", e);
                Iterator<java.util.List<ActionListener<Void>>> iterator = this.snapshotDeletionListeners.values().iterator();
                while (iterator.hasNext()) {
                    java.util.List listeners = iterator.next();
                    iterator.remove();
                    SnapshotsService.failListenersIgnoringException(listeners, wrapped);
                }
                assert (this.snapshotDeletionListeners.isEmpty()) : "No new listeners should have been added but saw " + this.snapshotDeletionListeners;
            } else {
                assert (false) : new AssertionError("Modifying snapshot state should only ever fail because we failed to publish new state", e);
                logger.error("Unexpected failure during cluster state update", (Throwable)e);
            }
            this.currentlyFinalizing.clear();
        }
    }

    public static ClusterState updateWithSnapshots(ClusterState state, @Nullable SnapshotsInProgress snapshotsInProgress, @Nullable SnapshotDeletionsInProgress snapshotDeletionsInProgress) {
        if (snapshotsInProgress == null && snapshotDeletionsInProgress == null) {
            return state;
        }
        ClusterState.Builder builder = ClusterState.builder(state);
        if (snapshotsInProgress != null) {
            builder.putCustom("snapshots", snapshotsInProgress);
        }
        if (snapshotDeletionsInProgress != null) {
            builder.putCustom("snapshot_deletions", snapshotDeletionsInProgress);
        }
        return builder.build();
    }

    private static <T> void failListenersIgnoringException(@Nullable java.util.List<ActionListener<T>> listeners, Exception failure) {
        if (listeners != null) {
            try {
                ActionListener.onFailure(listeners, failure);
            }
            catch (Exception ex) {
                assert (false) : new AssertionError((Object)ex);
                logger.warn("Failed to notify listeners", (Throwable)ex);
            }
        }
    }

    private static <T> void completeListenersIgnoringException(@Nullable java.util.List<ActionListener<T>> listeners, T result) {
        if (listeners != null) {
            try {
                ActionListener.onResponse(listeners, result);
            }
            catch (Exception ex) {
                assert (false) : new AssertionError((Object)ex);
                logger.warn("Failed to notify listeners", (Throwable)ex);
            }
        }
    }

    private static ImmutableOpenMap<ShardId, SnapshotsInProgress.ShardSnapshotStatus> shards(SnapshotsInProgress snapshotsInProgress, SnapshotDeletionsInProgress deletionsInProgress, ClusterState currentState, Collection<IndexId> indices, boolean useShardGenerations, RepositoryData repositoryData, String repoName) {
        ImmutableOpenMap.Builder<ShardId, SnapshotsInProgress.ShardSnapshotStatus> builder = ImmutableOpenMap.builder();
        ShardGenerations shardGenerations = repositoryData.shardGenerations();
        InFlightShardSnapshotStates inFlightShardStates = InFlightShardSnapshotStates.forEntries(snapshotsInProgress.forRepo(repoName));
        boolean readyToExecute = !deletionsInProgress.hasExecutingDeletion(repoName);
        for (IndexId index : indices) {
            String indexName = index.getName();
            boolean isNewIndex = !repositoryData.getIndices().containsKey(indexName);
            IndexMetadata indexMetadata = currentState.metadata().index(indexName);
            if (indexMetadata == null) {
                builder.put(new ShardId(indexName, "_na_", 0), SnapshotsInProgress.ShardSnapshotStatus.MISSING);
                continue;
            }
            IndexRoutingTable indexRoutingTable = currentState.routingTable().index(indexName);
            assert (indexRoutingTable != null);
            for (int i = 0; i < indexMetadata.getNumberOfShards(); ++i) {
                ShardGeneration shardRepoGeneration;
                ShardId shardId = indexRoutingTable.shard(i).shardId();
                if (useShardGenerations) {
                    ShardGeneration inFlightGeneration = inFlightShardStates.generationForShard(index, shardId.id(), shardGenerations);
                    if (inFlightGeneration == null && isNewIndex) {
                        assert (shardGenerations.getShardGen(index, shardId.getId()) == null) : "Found shard generation for new index [" + index + "]";
                        shardRepoGeneration = ShardGenerations.NEW_SHARD_GEN;
                    } else {
                        shardRepoGeneration = inFlightGeneration;
                    }
                } else {
                    shardRepoGeneration = null;
                }
                SnapshotsInProgress.ShardSnapshotStatus shardSnapshotStatus = !readyToExecute || inFlightShardStates.isActive(shardId.getIndexName(), shardId.id()) ? SnapshotsInProgress.ShardSnapshotStatus.UNASSIGNED_QUEUED : SnapshotsService.initShardSnapshotStatus(shardRepoGeneration, indexRoutingTable.shard(i).primaryShard());
                builder.put(shardId, shardSnapshotStatus);
            }
        }
        return builder.build();
    }

    private static SnapshotsInProgress.ShardSnapshotStatus initShardSnapshotStatus(ShardGeneration shardRepoGeneration, ShardRouting primary) {
        SnapshotsInProgress.ShardSnapshotStatus shardSnapshotStatus = primary == null || !primary.assignedToNode() ? new SnapshotsInProgress.ShardSnapshotStatus(null, SnapshotsInProgress.ShardState.MISSING, "primary shard is not allocated", shardRepoGeneration) : (primary.relocating() || primary.initializing() ? new SnapshotsInProgress.ShardSnapshotStatus(primary.currentNodeId(), SnapshotsInProgress.ShardState.WAITING, shardRepoGeneration) : (!primary.started() ? new SnapshotsInProgress.ShardSnapshotStatus(primary.currentNodeId(), SnapshotsInProgress.ShardState.MISSING, "primary shard hasn't been started yet", shardRepoGeneration) : new SnapshotsInProgress.ShardSnapshotStatus(primary.currentNodeId(), shardRepoGeneration)));
        return shardSnapshotStatus;
    }

    public static Set<String> snapshottingDataStreams(ClusterState currentState, Set<String> dataStreamsToCheck) {
        Map<String, DataStream> dataStreams = currentState.metadata().dataStreams();
        return currentState.custom("snapshots", SnapshotsInProgress.EMPTY).asStream().filter(e -> !e.partial()).flatMap(e -> e.dataStreams().stream()).filter(ds -> dataStreams.containsKey(ds) && dataStreamsToCheck.contains(ds)).collect(Collectors.toSet());
    }

    public static Set<Index> snapshottingIndices(ClusterState currentState, Set<Index> indicesToCheck) {
        HashSet<Index> indices = new HashSet<Index>();
        for (java.util.List<SnapshotsInProgress.Entry> snapshotsInRepo : currentState.custom("snapshots", SnapshotsInProgress.EMPTY).entriesByRepo()) {
            for (SnapshotsInProgress.Entry entry : snapshotsInRepo) {
                if (entry.partial() || entry.isClone()) continue;
                for (String indexName : entry.indices().keySet()) {
                    IndexMetadata indexMetadata = currentState.metadata().index(indexName);
                    if (indexMetadata == null || !indicesToCheck.contains(indexMetadata.getIndex())) continue;
                    indices.add(indexMetadata.getIndex());
                }
            }
        }
        return indices;
    }

    static Map<String, DataStreamAlias> filterDataStreamAliases(Map<String, DataStream> dataStreams, Map<String, DataStreamAlias> dataStreamAliases) {
        return dataStreamAliases.values().stream().filter(alias -> alias.getDataStreams().stream().anyMatch(dataStreams::containsKey)).map(alias -> alias.intersect(dataStreams::containsKey)).collect(Collectors.toMap(DataStreamAlias::getName, Function.identity()));
    }

    private void addListener(Snapshot snapshot, ActionListener<Tuple<RepositoryData, SnapshotInfo>> listener) {
        this.snapshotCompletionListeners.computeIfAbsent(snapshot, k -> new CopyOnWriteArrayList()).add(ContextPreservingActionListener.wrapPreservingContext(listener, this.threadPool.getThreadContext()));
    }

    @Override
    protected void doStart() {
        assert (this.updateSnapshotStatusHandler != null);
        assert (this.transportService.getRequestHandler(UPDATE_SNAPSHOT_STATUS_ACTION_NAME) != null);
    }

    @Override
    protected void doStop() {
    }

    @Override
    protected void doClose() {
        this.clusterService.removeApplier(this);
    }

    public boolean assertAllListenersResolved() {
        DiscoveryNode localNode = this.clusterService.localNode();
        assert (this.endingSnapshots.isEmpty()) : "Found leaked ending snapshots " + this.endingSnapshots + " on [" + localNode + "]";
        assert (this.snapshotCompletionListeners.isEmpty()) : "Found leaked snapshot completion listeners " + this.snapshotCompletionListeners + " on [" + localNode + "]";
        assert (this.currentlyFinalizing.isEmpty()) : "Found leaked finalizations " + this.currentlyFinalizing + " on [" + localNode + "]";
        assert (this.snapshotDeletionListeners.isEmpty()) : "Found leaked snapshot delete listeners " + this.snapshotDeletionListeners + " on [" + localNode + "]";
        assert (this.repositoryOperations.isEmpty()) : "Found leaked snapshots to finalize " + this.repositoryOperations + " on [" + localNode + "]";
        return true;
    }

    private static boolean isQueued(@Nullable SnapshotsInProgress.ShardSnapshotStatus status) {
        return status != null && status.state() == SnapshotsInProgress.ShardState.QUEUED;
    }

    private void innerUpdateSnapshotState(final ShardSnapshotUpdate update, final ActionListener<Void> listener) {
        logger.trace("received updated snapshot restore state [{}]", (Object)update);
        this.clusterService.submitStateUpdateTask("update snapshot state", update, ClusterStateTaskConfig.build(Priority.NORMAL), SHARD_STATE_EXECUTOR, new ClusterStateTaskListener(){

            @Override
            public void onFailure(String source, Exception e) {
                listener.onFailure(e);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                try {
                    listener.onResponse(null);
                }
                finally {
                    SnapshotsInProgress.Entry updatedEntry;
                    SnapshotsInProgress snapshotsInProgress = newState.custom("snapshots", SnapshotsInProgress.EMPTY);
                    if (!SnapshotsService.this.endingSnapshots.contains(update.snapshot) && (updatedEntry = snapshotsInProgress.snapshot(update.snapshot)) != null && updatedEntry.state().completed()) {
                        SnapshotsService.this.endSnapshot(updatedEntry, newState.metadata(), null);
                    }
                    SnapshotsService.this.startExecutableClones(snapshotsInProgress, update.snapshot.getRepository());
                }
            }
        });
    }

    private void startExecutableClones(SnapshotsInProgress snapshotsInProgress, @Nullable String repoName) {
        if (repoName == null) {
            for (java.util.List<SnapshotsInProgress.Entry> entries : snapshotsInProgress.entriesByRepo()) {
                this.startExecutableClones(entries);
            }
        } else {
            this.startExecutableClones(snapshotsInProgress.forRepo(repoName));
        }
    }

    private void startExecutableClones(java.util.List<SnapshotsInProgress.Entry> entries) {
        for (SnapshotsInProgress.Entry entry : entries) {
            if (!entry.isClone() || entry.state() != SnapshotsInProgress.State.STARTED) continue;
            for (ObjectObjectCursor<RepositoryShardId, SnapshotsInProgress.ShardSnapshotStatus> objectObjectCursor : entry.shardsByRepoShardId()) {
                if (((SnapshotsInProgress.ShardSnapshotStatus)objectObjectCursor.value).state() != SnapshotsInProgress.ShardState.INIT) continue;
                this.runReadyClone(entry.snapshot(), entry.source(), (SnapshotsInProgress.ShardSnapshotStatus)objectObjectCursor.value, (RepositoryShardId)objectObjectCursor.key, this.repositoriesService.repository(entry.repository()));
            }
        }
    }

    private /* synthetic */ ClusterStateUpdateTask lambda$deleteSnapshots$41(DeleteSnapshotRequest request, final String[] snapshotNames, final String repositoryName, final ActionListener listener, final String taskDescription, final RepositoryData repositoryData) {
        return new ClusterStateUpdateTask(request.masterNodeTimeout()){
            private Snapshot runningSnapshot;
            private ClusterStateUpdateTask deleteFromRepoTask;
            private boolean abortedDuringInit;
            private java.util.List<SnapshotId> outstandingDeletes;
            {
                super(timeout);
                this.abortedDuringInit = false;
            }

            @Override
            public ClusterState execute(ClusterState currentState) throws Exception {
                String failure;
                ImmutableOpenMap<ShardId, SnapshotsInProgress.ShardSnapshotStatus> shards;
                Version minNodeVersion = currentState.nodes().getMinNodeVersion();
                if (snapshotNames.length > 1 && minNodeVersion.before(MULTI_DELETE_VERSION)) {
                    throw new IllegalArgumentException("Deleting multiple snapshots in a single request is only supported in version [ " + MULTI_DELETE_VERSION + "] but cluster contained node of version [" + currentState.nodes().getMinNodeVersion() + "]");
                }
                SnapshotsService.ensureRepositoryExists(repositoryName, currentState);
                ArrayList<SnapshotId> snapshotIds = new ArrayList<SnapshotId>();
                ArrayList<SnapshotsInProgress.Entry> snapshotEntries = new ArrayList<SnapshotsInProgress.Entry>();
                SnapshotsInProgress snapshotsInProgress = currentState.custom("snapshots", SnapshotsInProgress.EMPTY);
                for (SnapshotsInProgress.Entry entry2 : snapshotsInProgress.forRepo(repositoryName)) {
                    SnapshotId snapshotId = entry2.snapshot().getSnapshotId();
                    if (!Regex.simpleMatch(snapshotNames, snapshotId.getName())) continue;
                    snapshotIds.add(snapshotId);
                    snapshotEntries.add(entry2);
                }
                Map snapshotsIdsInRepository = repositoryData.getSnapshotIds().stream().collect(Collectors.toMap(SnapshotId::getName, Function.identity()));
                for (String snapshotOrPattern : snapshotNames) {
                    if (Regex.isSimpleMatchPattern(snapshotOrPattern)) {
                        for (Map.Entry entry3 : snapshotsIdsInRepository.entrySet()) {
                            if (!Regex.simpleMatch(snapshotOrPattern, entry3.getKey())) continue;
                            snapshotIds.add((SnapshotId)entry3.getValue());
                        }
                        continue;
                    }
                    SnapshotId foundId = (SnapshotId)snapshotsIdsInRepository.get(snapshotOrPattern);
                    if (foundId == null) {
                        if (!snapshotEntries.stream().noneMatch(entry -> entry.snapshot().getSnapshotId().getName().equals(snapshotOrPattern))) continue;
                        throw new SnapshotMissingException(repositoryName, snapshotOrPattern);
                    }
                    snapshotIds.add(foundId);
                }
                if (snapshotEntries.isEmpty() || minNodeVersion.onOrAfter(FULL_CONCURRENCY_VERSION)) {
                    this.deleteFromRepoTask = SnapshotsService.this.createDeleteStateUpdate(snapshotIds, repositoryName, repositoryData, Priority.NORMAL, listener);
                    return this.deleteFromRepoTask.execute(currentState);
                }
                assert (snapshotEntries.size() == 1) : "Expected just a single running snapshot but saw " + snapshotEntries;
                SnapshotsInProgress.Entry entry3 = (SnapshotsInProgress.Entry)snapshotEntries.get(0);
                this.runningSnapshot = entry3.snapshot();
                SnapshotsInProgress.State state = entry3.state();
                this.outstandingDeletes = new ArrayList<SnapshotId>(snapshotIds);
                if (state != SnapshotsInProgress.State.INIT) {
                    this.outstandingDeletes.add(this.runningSnapshot.getSnapshotId());
                }
                if (state == SnapshotsInProgress.State.INIT) {
                    shards = entry3.shards();
                    assert (shards.isEmpty());
                    failure = "Snapshot was aborted during initialization";
                    this.abortedDuringInit = true;
                } else if (state == SnapshotsInProgress.State.STARTED) {
                    SnapshotsInProgress.Entry abortedEntry = entry3.abort();
                    shards = abortedEntry.shards();
                    failure = abortedEntry.failure();
                } else {
                    boolean hasUncompletedShards = false;
                    for (SnapshotsInProgress.ShardSnapshotStatus shardStatus : entry3.shards().values()) {
                        if (shardStatus.state().completed() || shardStatus.nodeId() == null || currentState.nodes().get(shardStatus.nodeId()) == null) continue;
                        hasUncompletedShards = true;
                        break;
                    }
                    if (hasUncompletedShards) {
                        logger.debug("trying to delete completed snapshot - should wait for shards to finalize on all nodes");
                        return currentState;
                    }
                    logger.debug("trying to delete completed snapshot with no finalizing shards - can delete immediately");
                    shards = entry3.shards();
                    failure = entry3.failure();
                }
                return ClusterState.builder(currentState).putCustom("snapshots", snapshotsInProgress.withUpdatedEntriesForRepo(repositoryName, snapshotsInProgress.forRepo(repositoryName).stream().filter(existing -> !this.abortedDuringInit || !existing.equals(snapshotEntry)).map(existing -> {
                    if (existing.equals(snapshotEntry)) {
                        return snapshotEntry.fail(shards, SnapshotsInProgress.State.ABORTED, failure);
                    }
                    return existing;
                }).collect(Collectors.toList()))).build();
            }

            @Override
            public void onFailure(String source, Exception e) {
                if (this.deleteFromRepoTask == null) {
                    listener.onFailure(e);
                } else {
                    this.deleteFromRepoTask.onFailure(source, e);
                }
            }

            @Override
            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                if (this.deleteFromRepoTask != null) {
                    assert (this.outstandingDeletes == null) : "Shouldn't have outstanding deletes after already starting delete task";
                    this.deleteFromRepoTask.clusterStateProcessed(source, oldState, newState);
                    return;
                }
                if (this.abortedDuringInit) {
                    logger.info("Successfully aborted snapshot [{}]", (Object)this.runningSnapshot);
                    if (this.outstandingDeletes.isEmpty()) {
                        listener.onResponse(null);
                    } else {
                        SnapshotsService.this.clusterService.submitStateUpdateTask(taskDescription, SnapshotsService.this.createDeleteStateUpdate(this.outstandingDeletes, repositoryName, repositoryData, Priority.IMMEDIATE, listener));
                    }
                    return;
                }
                logger.trace("adding snapshot completion listener to wait for deleted snapshot to finish");
                SnapshotsService.this.addListener(this.runningSnapshot, ActionListener.wrap(result -> {
                    logger.debug("deleted snapshot completed - deleting files");
                    SnapshotsService.this.clusterService.submitStateUpdateTask(taskDescription, SnapshotsService.this.createDeleteStateUpdate(this.outstandingDeletes, repositoryName, (RepositoryData)result.v1(), Priority.IMMEDIATE, listener));
                }, e -> {
                    if (ExceptionsHelper.unwrap(e, NotMasterException.class, FailedToCommitClusterStateException.class) != null) {
                        logger.warn("master failover before deleted snapshot could complete", (Throwable)e);
                        listener.onFailure((Exception)e);
                    } else {
                        logger.warn("deleted snapshot failed", (Throwable)e);
                        listener.onFailure(new SnapshotMissingException(this.runningSnapshot.getRepository(), this.runningSnapshot.getSnapshotId(), (Throwable)e));
                    }
                }));
            }
        };
    }

    private static /* synthetic */ Message lambda$deleteSnapshots$40(String[] snapshotNames, String repositoryName) {
        return new ParameterizedMessage("deleting snapshots [{}] from repository [{}]", (Object)Strings.arrayToCommaDelimitedString(snapshotNames), (Object)repositoryName);
    }

    static final class ShardSnapshotUpdate {
        private final Snapshot snapshot;
        private final ShardId shardId;
        private final RepositoryShardId repoShardId;
        private final SnapshotsInProgress.ShardSnapshotStatus updatedState;

        ShardSnapshotUpdate(Snapshot snapshot, RepositoryShardId repositoryShardId, SnapshotsInProgress.ShardSnapshotStatus updatedState) {
            this.snapshot = snapshot;
            this.shardId = null;
            this.updatedState = updatedState;
            this.repoShardId = repositoryShardId;
        }

        ShardSnapshotUpdate(Snapshot snapshot, ShardId shardId, SnapshotsInProgress.ShardSnapshotStatus updatedState) {
            this.snapshot = snapshot;
            this.shardId = shardId;
            this.updatedState = updatedState;
            this.repoShardId = null;
        }

        public boolean isClone() {
            return this.repoShardId != null;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ShardSnapshotUpdate)) {
                return false;
            }
            ShardSnapshotUpdate that = (ShardSnapshotUpdate)other;
            return this.snapshot.equals(that.snapshot) && Objects.equals(this.shardId, that.shardId) && Objects.equals(this.repoShardId, that.repoShardId) && this.updatedState == that.updatedState;
        }

        public int hashCode() {
            return Objects.hash(this.snapshot, this.shardId, this.updatedState, this.repoShardId);
        }

        public String toString() {
            return "ShardSnapshotUpdate{snapshot=" + this.snapshot + ", shardId=" + this.shardId + ", repoShardId=" + this.repoShardId + ", updatedState=" + this.updatedState + '}';
        }
    }

    private static final class OngoingRepositoryOperations {
        private final Map<String, Deque<Snapshot>> snapshotsToFinalize = new HashMap<String, Deque<Snapshot>>();
        private final Set<String> runningDeletions = Collections.synchronizedSet(new HashSet());
        @Nullable
        private Metadata latestKnownMetaData;

        private OngoingRepositoryOperations() {
        }

        @Nullable
        synchronized Tuple<Snapshot, Metadata> pollFinalization(String repository) {
            this.assertConsistent();
            Deque<Snapshot> queued = this.snapshotsToFinalize.get(repository);
            if (queued == null) {
                return null;
            }
            Snapshot nextEntry = queued.pollFirst();
            assert (nextEntry != null);
            Tuple res = Tuple.tuple((Object)nextEntry, (Object)this.latestKnownMetaData);
            if (queued.isEmpty()) {
                this.snapshotsToFinalize.remove(repository);
            }
            if (this.snapshotsToFinalize.isEmpty()) {
                this.latestKnownMetaData = null;
            }
            assert (this.assertConsistent());
            return res;
        }

        boolean startDeletion(String deleteUUID) {
            return this.runningDeletions.add(deleteUUID);
        }

        void finishDeletion(String deleteUUID) {
            this.runningDeletions.remove(deleteUUID);
        }

        synchronized void addFinalization(Snapshot snapshot, Metadata metadata) {
            this.snapshotsToFinalize.computeIfAbsent(snapshot.getRepository(), k -> new LinkedList()).add(snapshot);
            this.latestKnownMetaData = metadata;
            this.assertConsistent();
        }

        synchronized void clear() {
            this.snapshotsToFinalize.clear();
            this.runningDeletions.clear();
            this.latestKnownMetaData = null;
        }

        synchronized boolean isEmpty() {
            return this.snapshotsToFinalize.isEmpty();
        }

        synchronized boolean assertNotQueued(Snapshot snapshot) {
            assert (((Deque)this.snapshotsToFinalize.getOrDefault(snapshot.getRepository(), new LinkedList())).stream().noneMatch(entry -> entry.equals(snapshot))) : "Snapshot [" + snapshot + "] is still in finalization queue";
            return true;
        }

        synchronized boolean assertConsistent() {
            assert (this.latestKnownMetaData == null && this.snapshotsToFinalize.isEmpty() || this.latestKnownMetaData != null && !this.snapshotsToFinalize.isEmpty()) : "Should not hold on to metadata if there are no more queued snapshots";
            assert (this.snapshotsToFinalize.values().stream().noneMatch(Collection::isEmpty)) : "Found empty queue in " + this.snapshotsToFinalize;
            return true;
        }
    }

    private static class CleanupAfterErrorListener {
        private final ActionListener<Snapshot> userCreateSnapshotListener;
        private final Exception e;

        CleanupAfterErrorListener(ActionListener<Snapshot> userCreateSnapshotListener, Exception e) {
            this.userCreateSnapshotListener = userCreateSnapshotListener;
            this.e = e;
        }

        public void onFailure(@Nullable Exception e) {
            this.userCreateSnapshotListener.onFailure(ExceptionsHelper.useOrSuppress(e, this.e));
        }

        public void onNoLongerMaster() {
            this.userCreateSnapshotListener.onFailure(this.e);
        }
    }

    private class UpdateSnapshotStatusAction
    extends TransportMasterNodeAction<UpdateIndexShardSnapshotStatusRequest, ActionResponse.Empty> {
        UpdateSnapshotStatusAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
            super(SnapshotsService.UPDATE_SNAPSHOT_STATUS_ACTION_NAME, false, transportService, clusterService, threadPool, actionFilters, UpdateIndexShardSnapshotStatusRequest::new, indexNameExpressionResolver, in -> ActionResponse.Empty.INSTANCE, "same");
        }

        @Override
        protected void masterOperation(UpdateIndexShardSnapshotStatusRequest request, ClusterState state, ActionListener<ActionResponse.Empty> listener) throws Exception {
            SnapshotsService.this.innerUpdateSnapshotState(new ShardSnapshotUpdate(request.snapshot(), request.shardId(), request.status()), listener.map(v -> ActionResponse.Empty.INSTANCE));
        }

        @Override
        protected ClusterBlockException checkBlock(UpdateIndexShardSnapshotStatusRequest request, ClusterState state) {
            return null;
        }
    }

    private static final class SnapshotShardsUpdateContext {
        private int changedCount = 0;
        private int startedCount = 0;
        private final ClusterState currentState;
        private final Map<String, java.util.List<ShardSnapshotUpdate>> updatesByRepo;
        private final Set<ShardSnapshotUpdate> executedUpdates = new HashSet<ShardSnapshotUpdate>();

        SnapshotShardsUpdateContext(ClusterState currentState, java.util.List<ShardSnapshotUpdate> updates) {
            this.currentState = currentState;
            this.updatesByRepo = new HashMap<String, java.util.List<ShardSnapshotUpdate>>();
            for (ShardSnapshotUpdate update : updates) {
                this.updatesByRepo.computeIfAbsent(update.snapshot.getRepository(), r -> new ArrayList()).add(update);
            }
        }

        ClusterState computeUpdatedState() {
            SnapshotsInProgress existing;
            SnapshotsInProgress updated = existing = this.currentState.custom("snapshots", SnapshotsInProgress.EMPTY);
            for (Map.Entry<String, java.util.List<ShardSnapshotUpdate>> updates : this.updatesByRepo.entrySet()) {
                String repoName = updates.getKey();
                java.util.List<SnapshotsInProgress.Entry> oldEntries = existing.forRepo(repoName);
                if (oldEntries.isEmpty()) continue;
                ArrayList<SnapshotsInProgress.Entry> newEntries = new ArrayList<SnapshotsInProgress.Entry>(oldEntries.size());
                for (SnapshotsInProgress.Entry entry : oldEntries) {
                    newEntries.add(this.applyToEntry(entry, updates.getValue()));
                }
                updated = updated.withUpdatedEntriesForRepo(repoName, newEntries);
            }
            if (this.changedCount > 0) {
                logger.trace("changed cluster state triggered by [{}] snapshot state updates and resulted in starting [{}] shard snapshots", (Object)this.changedCount, (Object)this.startedCount);
                return ClusterState.builder(this.currentState).putCustom("snapshots", updated).build();
            }
            return this.currentState;
        }

        private SnapshotsInProgress.Entry applyToEntry(SnapshotsInProgress.Entry entry, java.util.List<ShardSnapshotUpdate> updates) {
            if (entry.state().completed() || updates.isEmpty()) {
                return entry;
            }
            return new EntryContext(entry, updates).computeUpdatedEntry();
        }

        private final class EntryContext {
            private final SnapshotsInProgress.Entry entry;
            private final Iterator<ShardSnapshotUpdate> iterator;
            private ImmutableOpenMap.Builder<ShardId, SnapshotsInProgress.ShardSnapshotStatus> shardsBuilder = null;
            private ImmutableOpenMap.Builder<RepositoryShardId, SnapshotsInProgress.ShardSnapshotStatus> clonesBuilder = null;

            EntryContext(SnapshotsInProgress.Entry entry, java.util.List<ShardSnapshotUpdate> updates) {
                this.entry = entry;
                this.iterator = updates.iterator();
            }

            SnapshotsInProgress.Entry computeUpdatedEntry() {
                assert (this.shardsBuilder == null && this.clonesBuilder == null) : "update context was already used";
                while (this.iterator.hasNext()) {
                    ShardSnapshotUpdate update = this.iterator.next();
                    if (this.entry.snapshot().getSnapshotId().equals(update.snapshot.getSnapshotId())) {
                        if (update.isClone()) {
                            this.executeShardSnapshotUpdate(this.entry.shardsByRepoShardId(), this::clonesBuilder, update, update.repoShardId);
                            continue;
                        }
                        this.executeShardSnapshotUpdate(this.entry.shards(), this::shardsBuilder, update, update.shardId);
                        continue;
                    }
                    if (!SnapshotShardsUpdateContext.this.executedUpdates.contains(update)) continue;
                    if (update.isClone()) {
                        this.tryStartNextTaskAfterCloneUpdated(update.repoShardId, update.updatedState);
                        continue;
                    }
                    this.tryStartNextTaskAfterSnapshotUpdated(update.shardId, update.updatedState);
                }
                if (this.shardsBuilder != null) {
                    assert (this.clonesBuilder == null) : "Should not have updated clones when updating shard snapshots but saw " + this.clonesBuilder + " as well as " + this.shardsBuilder;
                    return this.entry.withShardStates(this.shardsBuilder.build());
                }
                if (this.clonesBuilder != null) {
                    return this.entry.withClones(this.clonesBuilder.build());
                }
                return this.entry;
            }

            private <T> void startShardOperation(ImmutableOpenMap.Builder<T, SnapshotsInProgress.ShardSnapshotStatus> newStates, String nodeId, ShardGeneration generation, T shardId) {
                this.startShardOperation(newStates, shardId, new SnapshotsInProgress.ShardSnapshotStatus(nodeId, generation));
            }

            private <T> void startShardOperation(ImmutableOpenMap.Builder<T, SnapshotsInProgress.ShardSnapshotStatus> newStates, T shardId, SnapshotsInProgress.ShardSnapshotStatus newState) {
                logger.trace("[{}] Starting [{}] on [{}] with generation [{}]", (Object)this.entry.snapshot(), shardId, (Object)newState.nodeId(), (Object)newState.generation());
                newStates.put(shardId, newState);
                this.iterator.remove();
                SnapshotShardsUpdateContext.this.startedCount++;
            }

            private <T> void executeShardSnapshotUpdate(ImmutableOpenMap<T, SnapshotsInProgress.ShardSnapshotStatus> existingStates, Supplier<ImmutableOpenMap.Builder<T, SnapshotsInProgress.ShardSnapshotStatus>> newStates, ShardSnapshotUpdate updateSnapshotState, T updatedShard) {
                assert (updateSnapshotState.snapshot.equals(this.entry.snapshot()));
                SnapshotsInProgress.ShardSnapshotStatus existing = existingStates.get(updatedShard);
                if (existing == null) {
                    logger.warn("Received shard snapshot status update [{}] but this shard is not tracked in [{}]", updatedShard, (Object)this.entry);
                    assert (false) : "This should never happen, should only receive updates for expected shards";
                    return;
                }
                if (existing.state().completed()) {
                    this.iterator.remove();
                    return;
                }
                logger.trace("[{}] Updating shard [{}] with status [{}]", (Object)updateSnapshotState.snapshot, updatedShard, (Object)updateSnapshotState.updatedState.state());
                SnapshotShardsUpdateContext.this.changedCount++;
                newStates.get().put(updatedShard, updateSnapshotState.updatedState);
                SnapshotShardsUpdateContext.this.executedUpdates.add(updateSnapshotState);
            }

            private void tryStartNextTaskAfterCloneUpdated(RepositoryShardId repoShardId, SnapshotsInProgress.ShardSnapshotStatus updatedState) {
                if (!this.entry.isClone()) {
                    this.tryStartSnapshotAfterCloneFinish(repoShardId, updatedState.generation());
                } else if (SnapshotsService.isQueued(this.entry.shardsByRepoShardId().get(repoShardId))) {
                    String localNodeId = SnapshotShardsUpdateContext.this.currentState.nodes().getLocalNodeId();
                    assert (updatedState.nodeId().equals(localNodeId)) : "Clone updated with node id [" + updatedState.nodeId() + "] but local node id is [" + localNodeId + "]";
                    this.startShardOperation(this.clonesBuilder(), localNodeId, updatedState.generation(), repoShardId);
                }
            }

            private void tryStartNextTaskAfterSnapshotUpdated(ShardId shardId, SnapshotsInProgress.ShardSnapshotStatus updatedState) {
                IndexId indexId = this.entry.indices().get(shardId.getIndexName());
                if (indexId != null) {
                    RepositoryShardId repoShardId = new RepositoryShardId(indexId, shardId.id());
                    if (SnapshotsService.isQueued(this.entry.shardsByRepoShardId().get(repoShardId))) {
                        if (this.entry.isClone()) {
                            this.startShardOperation(this.clonesBuilder(), SnapshotShardsUpdateContext.this.currentState.nodes().getLocalNodeId(), updatedState.generation(), repoShardId);
                        } else {
                            this.startShardOperation(this.shardsBuilder(), updatedState.nodeId(), updatedState.generation(), this.entry.shardId(repoShardId));
                        }
                    }
                }
            }

            private void tryStartSnapshotAfterCloneFinish(RepositoryShardId repoShardId, ShardGeneration generation) {
                assert (this.entry.source() == null);
                if (SnapshotsService.isQueued(this.entry.shardsByRepoShardId().get(repoShardId))) {
                    ShardId routingShardId;
                    Index index = this.entry.indexByName(repoShardId.indexName());
                    assert (index != null) : "index [" + repoShardId.index() + "] must exist in snapshot entry [" + this.entry + "] because it's a normal snapshot but did not";
                    IndexRoutingTable indexRouting = SnapshotShardsUpdateContext.this.currentState.routingTable().index(index);
                    ShardRouting shardRouting = indexRouting == null ? null : indexRouting.shard(repoShardId.shardId()).primaryShard();
                    SnapshotsInProgress.ShardSnapshotStatus shardSnapshotStatus = SnapshotsService.initShardSnapshotStatus(generation, shardRouting);
                    ShardId shardId = routingShardId = shardRouting != null ? shardRouting.shardId() : new ShardId(index, repoShardId.shardId());
                    if (shardSnapshotStatus.isActive()) {
                        this.startShardOperation(this.shardsBuilder(), routingShardId, shardSnapshotStatus);
                    } else {
                        this.shardsBuilder().put(routingShardId, shardSnapshotStatus);
                    }
                }
            }

            private ImmutableOpenMap.Builder<RepositoryShardId, SnapshotsInProgress.ShardSnapshotStatus> clonesBuilder() {
                assert (this.shardsBuilder == null);
                if (this.clonesBuilder == null) {
                    this.clonesBuilder = ImmutableOpenMap.builder(this.entry.shardsByRepoShardId());
                }
                return this.clonesBuilder;
            }

            private ImmutableOpenMap.Builder<ShardId, SnapshotsInProgress.ShardSnapshotStatus> shardsBuilder() {
                assert (this.clonesBuilder == null);
                if (this.shardsBuilder == null) {
                    this.shardsBuilder = ImmutableOpenMap.builder(this.entry.shards());
                }
                return this.shardsBuilder;
            }
        }
    }

    private final class FailPendingRepoTasksTask
    extends ClusterStateUpdateTask {
        private final java.util.List<Snapshot> snapshotsToFail = new ArrayList<Snapshot>();
        private final java.util.List<String> deletionsToFail = new ArrayList<String>();
        private final Exception failure;
        private final String repository;

        FailPendingRepoTasksTask(String repository, Exception failure) {
            this.repository = repository;
            this.failure = failure;
        }

        @Override
        public ClusterState execute(ClusterState currentState) {
            SnapshotDeletionsInProgress deletionsInProgress = currentState.custom("snapshot_deletions", SnapshotDeletionsInProgress.EMPTY);
            boolean changed = false;
            java.util.List<SnapshotDeletionsInProgress.Entry> remainingEntries = deletionsInProgress.getEntries();
            ArrayList<SnapshotDeletionsInProgress.Entry> updatedEntries = new ArrayList<SnapshotDeletionsInProgress.Entry>(remainingEntries.size());
            for (SnapshotDeletionsInProgress.Entry entry : remainingEntries) {
                if (entry.repository().equals(this.repository)) {
                    changed = true;
                    this.deletionsToFail.add(entry.uuid());
                    continue;
                }
                updatedEntries.add(entry);
            }
            SnapshotDeletionsInProgress updatedDeletions = changed ? SnapshotDeletionsInProgress.of(updatedEntries) : null;
            SnapshotsInProgress snapshotsInProgress = currentState.custom("snapshots", SnapshotsInProgress.EMPTY);
            boolean changedSnapshots = false;
            for (SnapshotsInProgress.Entry entry : snapshotsInProgress.forRepo(this.repository)) {
                this.snapshotsToFail.add(entry.snapshot());
                changedSnapshots = true;
            }
            SnapshotsInProgress updatedSnapshotsInProgress = changedSnapshots ? snapshotsInProgress.withUpdatedEntriesForRepo(this.repository, List.of()) : null;
            return SnapshotsService.updateWithSnapshots(currentState, updatedSnapshotsInProgress, updatedDeletions);
        }

        @Override
        public void onFailure(String source, Exception e) {
            logger.info(() -> new ParameterizedMessage("Failed to remove all snapshot tasks for repo [{}] from cluster state", (Object)this.repository), (Throwable)e);
            SnapshotsService.this.failAllListenersOnMasterFailOver(e);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
            logger.warn(() -> new ParameterizedMessage("Removed all snapshot tasks for repository [{}] from cluster state, now failing listeners", (Object)this.repository), (Throwable)this.failure);
            Set set = SnapshotsService.this.currentlyFinalizing;
            synchronized (set) {
                Tuple<Snapshot, Metadata> finalization;
                while ((finalization = SnapshotsService.this.repositoryOperations.pollFinalization(this.repository)) != null) {
                    assert (this.snapshotsToFail.contains(finalization.v1())) : "[" + finalization.v1() + "] not found in snapshots to fail " + this.snapshotsToFail;
                }
                SnapshotsService.this.leaveRepoLoop(this.repository);
                for (Snapshot snapshot : this.snapshotsToFail) {
                    SnapshotsService.this.failSnapshotCompletionListeners(snapshot, this.failure);
                }
                for (String delete : this.deletionsToFail) {
                    SnapshotsService.failListenersIgnoringException((java.util.List)SnapshotsService.this.snapshotDeletionListeners.remove(delete), this.failure);
                    SnapshotsService.this.repositoryOperations.finishDeletion(delete);
                }
            }
        }
    }

    private abstract class RemoveSnapshotDeletionAndContinueTask
    extends ClusterStateUpdateTask {
        protected final java.util.List<SnapshotsInProgress.Entry> newFinalizations = new ArrayList<SnapshotsInProgress.Entry>();
        private java.util.List<SnapshotDeletionsInProgress.Entry> readyDeletions = Collections.emptyList();
        protected final SnapshotDeletionsInProgress.Entry deleteEntry;
        private final RepositoryData repositoryData;

        RemoveSnapshotDeletionAndContinueTask(SnapshotDeletionsInProgress.Entry deleteEntry, RepositoryData repositoryData) {
            this.deleteEntry = deleteEntry;
            this.repositoryData = repositoryData;
        }

        @Override
        public ClusterState execute(ClusterState currentState) {
            SnapshotDeletionsInProgress deletions = (SnapshotDeletionsInProgress)currentState.custom("snapshot_deletions");
            assert (deletions != null) : "We only run this if there were deletions in the cluster state before";
            SnapshotDeletionsInProgress updatedDeletions = deletions.withRemovedEntry(this.deleteEntry.uuid());
            if (updatedDeletions == deletions) {
                return currentState;
            }
            SnapshotDeletionsInProgress newDeletions = this.filterDeletions(updatedDeletions);
            Tuple res = SnapshotsService.readyDeletions(SnapshotsService.updateWithSnapshots(currentState, this.updatedSnapshotsInProgress(currentState, newDeletions), newDeletions));
            this.readyDeletions = (java.util.List)res.v2();
            return (ClusterState)res.v1();
        }

        @Override
        public void onFailure(String source, Exception e) {
            logger.warn(() -> new ParameterizedMessage("{} failed to remove snapshot deletion metadata", (Object)this.deleteEntry), (Throwable)e);
            SnapshotsService.this.repositoryOperations.finishDeletion(this.deleteEntry.uuid());
            SnapshotsService.this.failAllListenersOnMasterFailOver(e);
        }

        protected SnapshotDeletionsInProgress filterDeletions(SnapshotDeletionsInProgress deletions) {
            return deletions;
        }

        @Override
        public final void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
            SnapshotsService.this.repositoryOperations.finishDeletion(this.deleteEntry.uuid());
            java.util.List deleteListeners = (java.util.List)SnapshotsService.this.snapshotDeletionListeners.remove(this.deleteEntry.uuid());
            this.handleListeners(deleteListeners);
            if (this.newFinalizations.isEmpty()) {
                if (this.readyDeletions.isEmpty()) {
                    SnapshotsService.this.leaveRepoLoop(this.deleteEntry.repository());
                } else {
                    for (SnapshotDeletionsInProgress.Entry readyDeletion : this.readyDeletions) {
                        SnapshotsService.this.deleteSnapshotsFromRepository(readyDeletion, this.repositoryData, newState.nodes().getMinNodeVersion());
                    }
                }
            } else {
                SnapshotsService.this.leaveRepoLoop(this.deleteEntry.repository());
                assert (this.readyDeletions.stream().noneMatch(entry -> entry.repository().equals(this.deleteEntry.repository()))) : "New finalizations " + this.newFinalizations + " added even though deletes " + this.readyDeletions + " are ready";
                for (SnapshotsInProgress.Entry entry2 : this.newFinalizations) {
                    SnapshotsService.this.endSnapshot(entry2, newState.metadata(), this.repositoryData);
                }
            }
            SnapshotsService.this.startExecutableClones(newState.custom("snapshots", SnapshotsInProgress.EMPTY), null);
        }

        protected abstract void handleListeners(@Nullable java.util.List<ActionListener<Void>> var1);

        /*
         * WARNING - void declaration
         */
        @Nullable
        private SnapshotsInProgress updatedSnapshotsInProgress(ClusterState currentState, SnapshotDeletionsInProgress updatedDeletions) {
            SnapshotsInProgress snapshotsInProgress = currentState.custom("snapshots", SnapshotsInProgress.EMPTY);
            ArrayList<SnapshotsInProgress.Entry> snapshotEntries = new ArrayList<SnapshotsInProgress.Entry>();
            HashSet<RepositoryShardId> reassignedShardIds = new HashSet<RepositoryShardId>();
            boolean changed = false;
            String localNodeId = currentState.nodes().getLocalNodeId();
            String repoName = this.deleteEntry.repository();
            InFlightShardSnapshotStates inFlightShardStates = null;
            HashSet<IndexId> newIndexIdsToRefresh = new HashSet<IndexId>();
            for (SnapshotsInProgress.Entry entry : snapshotsInProgress.forRepo(repoName)) {
                if (!entry.state().completed()) {
                    ArrayList<RepositoryShardId> canBeUpdated;
                    if (entry.isClone()) {
                        canBeUpdated = new ArrayList<RepositoryShardId>();
                        for (ObjectObjectCursor<RepositoryShardId, SnapshotsInProgress.ShardSnapshotStatus> objectObjectCursor : entry.shardsByRepoShardId()) {
                            if (!((SnapshotsInProgress.ShardSnapshotStatus)objectObjectCursor.value).equals(SnapshotsInProgress.ShardSnapshotStatus.UNASSIGNED_QUEUED) || reassignedShardIds.contains(objectObjectCursor.key)) continue;
                            canBeUpdated.add((RepositoryShardId)objectObjectCursor.key);
                        }
                        if (canBeUpdated.isEmpty() || updatedDeletions.hasExecutingDeletion(repoName)) {
                            snapshotEntries.add(entry);
                            continue;
                        }
                        if (inFlightShardStates == null) {
                            inFlightShardStates = InFlightShardSnapshotStates.forEntries(snapshotsInProgress.forRepo(repoName));
                        }
                        ImmutableOpenMap.Builder<RepositoryShardId, SnapshotsInProgress.ShardSnapshotStatus> updatedAssignmentsBuilder = ImmutableOpenMap.builder(entry.shardsByRepoShardId());
                        for (RepositoryShardId shardId : canBeUpdated) {
                            if (inFlightShardStates.isActive(shardId.indexName(), shardId.shardId())) continue;
                            this.markShardReassigned(shardId, reassignedShardIds);
                            updatedAssignmentsBuilder.put(shardId, new SnapshotsInProgress.ShardSnapshotStatus(localNodeId, inFlightShardStates.generationForShard(shardId.index(), shardId.shardId(), this.repositoryData.shardGenerations())));
                        }
                        snapshotEntries.add(entry.withClones(updatedAssignmentsBuilder.build()));
                        changed = true;
                        continue;
                    }
                    canBeUpdated = new ArrayList();
                    for (ObjectObjectCursor<RepositoryShardId, SnapshotsInProgress.ShardSnapshotStatus> objectObjectCursor : entry.shardsByRepoShardId()) {
                        RepositoryShardId repositoryShardId = (RepositoryShardId)objectObjectCursor.key;
                        if (!((SnapshotsInProgress.ShardSnapshotStatus)objectObjectCursor.value).equals(SnapshotsInProgress.ShardSnapshotStatus.UNASSIGNED_QUEUED) || reassignedShardIds.contains(repositoryShardId)) continue;
                        canBeUpdated.add(repositoryShardId);
                        if (this.repositoryData.hasIndex(repositoryShardId.indexName())) continue;
                        newIndexIdsToRefresh.add(repositoryShardId.index());
                    }
                    if (canBeUpdated.isEmpty()) {
                        snapshotEntries.add(entry);
                        continue;
                    }
                    ImmutableOpenMap shardAssignments = SnapshotsService.shards(snapshotsInProgress, updatedDeletions, currentState, entry.indices().values(), entry.version().onOrAfter(SHARD_GEN_IN_REPO_DATA_VERSION), this.repositoryData, repoName);
                    ImmutableOpenMap.Builder<ShardId, SnapshotsInProgress.ShardSnapshotStatus> builder = ImmutableOpenMap.builder(entry.shards());
                    for (RepositoryShardId shardId : canBeUpdated) {
                        ShardId sid = entry.shardId(shardId);
                        SnapshotsInProgress.ShardSnapshotStatus updated = (SnapshotsInProgress.ShardSnapshotStatus)shardAssignments.get(sid);
                        if (updated == null) {
                            assert (!currentState.routingTable().hasIndex(sid.getIndex())) : "Missing assignment for [" + sid + "]";
                            builder.put(sid, SnapshotsInProgress.ShardSnapshotStatus.MISSING);
                            continue;
                        }
                        if (updated.isActive()) {
                            this.markShardReassigned(shardId, reassignedShardIds);
                        }
                        builder.put(sid, updated);
                    }
                    SnapshotsInProgress.Entry updatedEntry = entry.withShardStates(builder.build());
                    snapshotEntries.add(updatedEntry);
                    changed = true;
                    if (!updatedEntry.state().completed()) continue;
                    this.newFinalizations.add(entry);
                    continue;
                }
                this.newFinalizations.add(entry);
                snapshotEntries.add(entry);
            }
            if (changed && !newIndexIdsToRefresh.isEmpty()) {
                void var12_15;
                HashMap<IndexId, IndexId> updatedIndexIds = new HashMap<IndexId, IndexId>(newIndexIdsToRefresh.size());
                for (IndexId indexIdToRefresh : newIndexIdsToRefresh) {
                    updatedIndexIds.put(indexIdToRefresh, new IndexId(indexIdToRefresh.getName(), UUIDs.randomBase64UUID()));
                }
                boolean bl = false;
                while (var12_15 < snapshotEntries.size()) {
                    snapshotEntries.set((int)var12_15, ((SnapshotsInProgress.Entry)snapshotEntries.get((int)var12_15)).withUpdatedIndexIds(updatedIndexIds));
                    ++var12_15;
                }
            }
            return changed ? snapshotsInProgress.withUpdatedEntriesForRepo(repoName, snapshotEntries) : null;
        }

        private void markShardReassigned(RepositoryShardId shardId, Set<RepositoryShardId> reassignments) {
            boolean added = reassignments.add(shardId);
            assert (added) : "should only ever reassign each shard once but assigned [" + shardId + "] multiple times";
        }
    }
}

