/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.ParenthesizedExpression;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.UnaryExpression;
import org.sonar.python.types.InferredTypes;

@Rule(key="S2761")
public class DoublePrefixOperatorCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Use the \"%s\" operator just once or not at all.";
    private static final String MESSAGE_NOT = "Use the \"bool()\" builtin function instead of calling \"not\" twice.";

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.BITWISE_COMPLEMENT, ctx -> DoublePrefixOperatorCheck.doubleInversionCheck(ctx, (UnaryExpression)ctx.syntaxNode()));
        context.registerSyntaxNodeConsumer(Tree.Kind.NOT, ctx -> DoublePrefixOperatorCheck.doubleInversionCheck(ctx, (UnaryExpression)ctx.syntaxNode()));
    }

    private static void doubleInversionCheck(SubscriptionContext ctx, UnaryExpression original) {
        Expression invertedExpr = original.expression();
        boolean doubleInversionFollowed = true;
        while (invertedExpr.is(Tree.Kind.PARENTHESIZED)) {
            doubleInversionFollowed = false;
            invertedExpr = ((ParenthesizedExpression)invertedExpr).expression();
        }
        if (invertedExpr.is(Tree.Kind.NOT, Tree.Kind.BITWISE_COMPLEMENT) && original.is(invertedExpr.getKind())) {
            if (doubleInversionFollowed) {
                if (invertedExpr.is(Tree.Kind.NOT)) {
                    ctx.addIssue(original, MESSAGE_NOT);
                } else if (((UnaryExpression)invertedExpr).expression().type() == InferredTypes.INT) {
                    ctx.addIssue(original, String.format(MESSAGE, original.operator().value()));
                }
            } else {
                ctx.addIssue(original, String.format(MESSAGE, original.operator().value()));
            }
        }
    }
}

