/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.AnnotatedAssignment;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TypeAnnotation;
import org.sonar.plugins.python.api.types.InferredType;
import org.sonar.python.tree.TreeUtils;
import org.sonar.python.types.InferredTypes;
import org.sonar.python.types.TypeShed;

@Rule(key="S5890")
public class InconsistentTypeHintCheck
extends PythonSubscriptionCheck {
    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.ANNOTATED_ASSIGNMENT, ctx -> {
            AnnotatedAssignment annotatedAssignment = (AnnotatedAssignment)ctx.syntaxNode();
            Expression assignedExpression = annotatedAssignment.assignedValue();
            if (assignedExpression == null) {
                return;
            }
            InconsistentTypeHintCheck.checkAnnotatedAssignment(ctx, annotatedAssignment, assignedExpression);
        });
    }

    private static void checkAnnotatedAssignment(SubscriptionContext ctx, AnnotatedAssignment annotatedAssignment, Expression assignedExpression) {
        InferredType inferredType = assignedExpression.type();
        TypeAnnotation annotation = annotatedAssignment.annotation();
        InferredType expectedType = InferredTypes.fromTypeAnnotation(annotation);
        if (expectedType.mustBeOrExtend("typing.TypedDict")) {
            return;
        }
        if (!inferredType.isCompatibleWith(expectedType) || InconsistentTypeHintCheck.isTypeUsedInsteadOfInstance(assignedExpression, expectedType)) {
            String inferredTypeName = InferredTypes.typeName(inferredType);
            String inferredTypeNameMessage = inferredTypeName != null ? String.format(" instead of \"%s\"", inferredTypeName) : "";
            String nameFromExpression = TreeUtils.nameFromExpression(annotatedAssignment.variable());
            String variableMessage = nameFromExpression != null ? String.format("\"%s\"", nameFromExpression) : "this expression";
            ctx.addIssue(assignedExpression, String.format("Assign to %s a value of type \"%s\"%s or update its type hint.", variableMessage, InferredTypes.typeName(expectedType), inferredTypeNameMessage)).secondary(annotation.expression(), null);
        }
    }

    private static boolean isTypeUsedInsteadOfInstance(Expression assignedExpression, InferredType expectedType) {
        if (assignedExpression.is(Tree.Kind.NAME)) {
            Name name = (Name)assignedExpression;
            Symbol symbol = name.symbol();
            return symbol != null && symbol.is(Symbol.Kind.CLASS) && !expectedType.isCompatibleWith(InferredTypes.runtimeType(TypeShed.typeShedClass("type")));
        }
        return false;
    }
}

