# -*- encoding:utf-8; warn-indent:false; frozen_string_literal: true  -*-

# line 1 "lib/parser/lexer.rl"

# line 3 "lib/parser/lexer.rl"
#
# === BEFORE YOU START ===
#
# Read the Ruby Hacking Guide chapter 11, available in English at
# http://whitequark.org/blog/2013/04/01/ruby-hacking-guide-ch-11-finite-state-lexer/
#
# Remember two things about Ragel scanners:
#
#   1) Longest match wins.
#
#   2) If two matches have the same length, the first
#      in source code wins.
#
# General rules of making Ragel and Bison happy:
#
#  * `p` (position) and `@te` contain the index of the character
#    they're pointing to ("current"), plus one. `@ts` contains the index
#    of the corresponding character. The code for extracting matched token is:
#
#       @source_buffer.slice(@ts...@te)
#
#  * If your input is `foooooooobar` and the rule is:
#
#       'f' 'o'+
#
#    the result will be:
#
#       foooooooobar
#       ^ ts=0   ^ p=te=9
#
#  * A Ragel lexer action should not emit more than one token, unless
#    you know what you are doing.
#
#  * All Ragel commands (fnext, fgoto, ...) end with a semicolon.
#
#  * If an action emits the token and transitions to another state, use
#    these Ragel commands:
#
#       emit($whatever)
#       fnext $next_state; fbreak;
#
#    If you perform `fgoto` in an action which does not emit a token nor
#    rewinds the stream pointer, the parser's side-effectful,
#    context-sensitive lookahead actions will break in a hard to detect
#    and debug way.
#
#  * If an action does not emit a token:
#
#       fgoto $next_state;
#
#  * If an action features lookbehind, i.e. matches characters with the
#    intent of passing them to another action:
#
#       p = @ts - 1
#       fgoto $next_state;
#
#    or, if the lookbehind consists of a single character:
#
#       fhold; fgoto $next_state;
#
#  * Ragel merges actions. So, if you have `e_lparen = '(' %act` and
#    `c_lparen = '('` and a lexer action `e_lparen | c_lparen`, the result
#    _will_ invoke the action `act`.
#
#    e_something stands for "something with **e**mbedded action".
#
#  * EOF is explicit and is matched by `c_eof`. If you want to introspect
#    the state of the lexer, add this rule to the state:
#
#       c_eof => do_eof;
#
#  * If you proceed past EOF, the lexer will complain:
#
#       NoMethodError: undefined method `ord' for nil:NilClass
#

class Parser::Lexer

  
# line 85 "lib/parser/lexer.rb"
class << self
	attr_accessor :_lex_trans_keys
	private :_lex_trans_keys, :_lex_trans_keys=
end
self._lex_trans_keys = [
	0, 0, 101, 101, 103, 103, 
	105, 105, 110, 110, 69, 
	69, 78, 78, 68, 68, 
	95, 95, 95, 95, 0, 26, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 45, 
	0, 120, 0, 120, 0, 92, 
	0, 120, 0, 120, 0, 
	45, 0, 120, 0, 120, 
	67, 99, 45, 45, 0, 92, 
	0, 120, 0, 102, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 45, 0, 120, 
	0, 120, 0, 92, 0, 
	120, 0, 120, 0, 45, 
	0, 120, 0, 120, 67, 99, 
	45, 45, 0, 92, 0, 
	120, 0, 102, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 58, 58, 58, 58, 
	46, 46, 0, 127, 58, 58, 
	60, 60, 62, 62, 10, 
	10, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	115, 115, 99, 99, 117, 117, 
	101, 101, 108, 116, 101, 
	101, 115, 115, 115, 115, 
	105, 105, 108, 108, 105, 105, 
	108, 108, 58, 58, 0, 
	127, 10, 10, 0, 127, 
	9, 92, 10, 10, 9, 92, 
	58, 58, 98, 98, 101, 
	101, 103, 103, 105, 105, 
	110, 110, 0, 127, 61, 61, 
	9, 92, 9, 92, 9, 
	92, 9, 92, 9, 92, 
	10, 10, 0, 127, 0, 127, 
	61, 126, 93, 93, 0, 
	127, 0, 127, 10, 10, 
	34, 34, 10, 10, 39, 39, 
	0, 127, 10, 96, 96, 
	96, 0, 45, 0, 120, 
	0, 120, 0, 92, 0, 120, 
	0, 120, 0, 45, 0, 
	120, 0, 120, 67, 99, 
	45, 45, 0, 92, 0, 120, 
	0, 102, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 58, 58, 
	58, 58, 0, 127, 43, 
	57, 48, 57, 48, 57, 
	48, 57, 48, 57, 115, 115, 
	99, 99, 117, 117, 101, 
	101, 99, 99, 117, 117, 
	101, 101, 0, 127, 58, 58, 
	9, 92, 9, 92, 9, 
	92, 9, 92, 9, 92, 
	9, 92, 60, 60, 10, 10, 
	9, 92, 9, 92, 10, 
	10, 10, 10, 10, 10, 
	10, 10, 46, 46, 0, 95, 
	9, 32, 0, 0, 10, 
	10, 10, 10, 98, 98, 
	9, 32, 10, 10, 95, 95, 
	0, 92, 9, 32, 36, 
	123, 0, 127, 48, 57, 
	0, 127, 0, 120, 0, 0, 
	0, 0, 48, 55, 48, 
	55, 0, 0, 0, 0, 
	0, 92, 0, 0, 0, 0, 
	0, 0, 0, 92, 45, 
	45, 0, 0, 0, 0, 
	0, 0, 0, 92, 48, 102, 
	48, 102, 0, 0, 48, 
	102, 48, 102, 0, 0, 
	0, 45, 0, 92, 0, 92, 
	0, 0, 0, 0, 0, 
	92, 48, 102, 48, 102, 
	0, 0, 0, 45, 10, 10, 
	0, 92, 48, 123, 48, 
	102, 48, 102, 48, 102, 
	0, 0, 0, 125, 0, 125, 
	0, 0, 0, 125, 0, 
	0, 0, 125, 0, 125, 
	0, 125, 0, 125, 0, 0, 
	0, 125, 0, 125, 0, 
	125, 0, 125, 0, 125, 
	0, 125, 0, 0, 0, 0, 
	48, 102, 0, 0, 0, 
	92, 36, 123, 0, 127, 
	48, 57, 0, 127, 0, 120, 
	0, 0, 0, 0, 48, 
	55, 48, 55, 0, 0, 
	0, 0, 0, 92, 0, 0, 
	0, 0, 0, 0, 0, 
	92, 45, 45, 0, 0, 
	0, 0, 0, 0, 0, 92, 
	48, 102, 48, 102, 0, 
	0, 48, 102, 48, 102, 
	0, 0, 0, 45, 0, 92, 
	0, 92, 0, 0, 0, 
	0, 0, 92, 48, 102, 
	48, 102, 0, 0, 0, 45, 
	10, 10, 0, 92, 48, 
	123, 48, 102, 48, 102, 
	48, 102, 0, 0, 0, 125, 
	0, 125, 0, 0, 0, 
	125, 0, 0, 0, 125, 
	0, 125, 0, 125, 0, 125, 
	0, 0, 0, 125, 0, 
	125, 0, 125, 0, 125, 
	0, 125, 0, 125, 0, 0, 
	0, 0, 48, 102, 0, 
	0, 0, 92, 9, 32, 
	0, 26, 0, 92, 0, 26, 
	0, 35, 36, 123, 0, 
	127, 48, 57, 0, 127, 
	0, 26, 0, 35, 9, 32, 
	36, 123, 0, 127, 48, 
	57, 0, 127, 0, 32, 
	9, 32, 65, 122, 65, 122, 
	36, 64, 0, 127, 48, 
	57, 0, 127, 0, 127, 
	0, 127, 0, 127, 9, 32, 
	0, 0, 61, 126, 10, 
	10, 10, 10, 0, 127, 
	0, 127, 48, 57, 115, 115, 
	38, 38, 42, 42, 64, 
	64, 58, 58, 60, 61, 
	62, 62, 61, 126, 61, 61, 
	61, 62, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	93, 93, 10, 10, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	124, 124, 0, 127, 0, 127, 
	9, 32, 10, 10, 10, 
	10, 46, 46, 10, 10, 
	0, 0, 0, 127, 0, 127, 
	61, 61, 0, 0, 9, 
	32, 0, 0, 61, 126, 
	10, 10, 10, 10, 38, 38, 
	42, 42, 64, 64, 60, 
	61, 62, 62, 61, 126, 
	61, 61, 61, 62, 0, 127, 
	93, 93, 10, 10, 124, 
	124, 0, 126, 0, 127, 
	0, 61, 9, 61, 9, 61, 
	0, 0, 9, 61, 9, 
	62, 46, 46, 46, 46, 
	58, 58, 9, 32, 0, 0, 
	0, 127, 0, 0, 9, 
	124, 0, 0, 10, 10, 
	10, 10, 0, 0, 9, 61, 
	58, 58, 60, 60, 62, 
	62, 9, 32, 10, 10, 
	0, 127, 102, 102, 101, 101, 
	110, 110, 104, 104, 0, 
	127, 0, 127, 0, 127, 
	0, 0, 0, 127, 10, 10, 
	0, 123, 9, 32, 10, 
	10, 10, 10, 10, 10, 
	0, 0, 111, 111, 0, 0, 
	0, 127, 0, 127, 9, 
	32, 0, 0, 10, 10, 
	10, 10, 10, 10, 0, 0, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 58, 
	61, 0, 0, 61, 126, 
	61, 61, 0, 0, 0, 0, 
	0, 0, 9, 32, 61, 
	61, 9, 32, 61, 126, 
	10, 10, 10, 10, 0, 127, 
	38, 61, 0, 0, 42, 
	61, 61, 61, 9, 92, 
	9, 92, 9, 92, 46, 46, 
	46, 46, 10, 10, 0, 
	26, 0, 127, 0, 127, 
	61, 61, 0, 0, 61, 126, 
	61, 62, 0, 0, 0, 
	0, 0, 0, 0, 0, 
	61, 126, 0, 127, 48, 57, 
	38, 38, 42, 42, 64, 
	64, 60, 61, 62, 62, 
	61, 61, 61, 62, 0, 127, 
	48, 57, 0, 127, 124, 
	124, 64, 64, 60, 61, 
	0, 0, 10, 34, 10, 39, 
	96, 96, 62, 62, 61, 
	126, 61, 62, 0, 122, 
	0, 0, 0, 127, 0, 127, 
	0, 120, 0, 0, 0, 
	0, 48, 55, 48, 55, 
	0, 0, 0, 0, 0, 92, 
	0, 0, 0, 0, 0, 
	0, 0, 92, 45, 45, 
	0, 0, 0, 0, 0, 0, 
	0, 92, 48, 102, 48, 
	102, 0, 0, 48, 102, 
	48, 102, 0, 0, 0, 45, 
	0, 92, 0, 92, 0, 
	0, 0, 0, 0, 92, 
	48, 102, 48, 102, 0, 0, 
	0, 45, 10, 10, 0, 
	92, 48, 123, 48, 102, 
	48, 102, 48, 102, 0, 0, 
	0, 125, 0, 125, 0, 
	0, 0, 125, 0, 0, 
	0, 125, 0, 125, 0, 125, 
	0, 125, 0, 0, 0, 
	125, 0, 125, 0, 125, 
	0, 125, 0, 125, 0, 125, 
	0, 125, 0, 125, 0, 
	125, 0, 125, 0, 125, 
	0, 125, 0, 125, 0, 125, 
	0, 125, 0, 125, 0, 
	125, 0, 125, 0, 125, 
	0, 0, 0, 0, 48, 102, 
	0, 0, 0, 127, 0, 
	127, 0, 127, 0, 0, 
	10, 10, 0, 0, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 61, 126, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 0, 61, 124, 
	0, 92, 9, 32, 0, 
	0, 10, 10, 10, 10, 
	10, 10, 0, 0, 0, 127, 
	0, 127, 9, 32, 0, 
	0, 10, 10, 10, 10, 
	10, 10, 0, 0, 0, 127, 
	0, 127, 61, 61, 0, 
	0, 9, 32, 0, 0, 
	61, 126, 10, 10, 10, 10, 
	0, 127, 0, 127, 48, 
	57, 61, 61, 38, 61, 
	0, 0, 0, 0, 42, 61, 
	61, 62, 46, 57, 46, 
	46, 10, 10, 48, 101, 
	48, 95, 46, 120, 48, 114, 
	43, 57, 48, 105, 102, 
	102, 0, 0, 101, 105, 
	0, 0, 0, 0, 48, 114, 
	48, 114, 48, 114, 48, 
	114, 105, 114, 102, 102, 
	0, 0, 101, 105, 115, 115, 
	0, 0, 0, 0, 48, 
	114, 48, 114, 48, 114, 
	48, 114, 48, 114, 48, 114, 
	48, 114, 48, 114, 46, 
	114, 48, 114, 46, 114, 
	48, 114, 58, 58, 60, 61, 
	62, 62, 61, 126, 61, 
	61, 61, 62, 0, 127, 
	0, 127, 0, 0, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 0, 10, 10, 0, 0, 
	0, 0, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 9, 92, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 0, 61, 124, 0, 
	0, 9, 92, 9, 92, 
	9, 92, 46, 46, 46, 46, 
	10, 10, 46, 46, 10, 
	10, 10, 61, 10, 10, 
	10, 101, 10, 110, 10, 100, 
	10, 10, 0
]

class << self
	attr_accessor :_lex_key_spans
	private :_lex_key_spans, :_lex_key_spans=
end
self._lex_key_spans = [
	0, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 27, 128, 128, 128, 128, 46, 
	121, 121, 93, 121, 121, 46, 121, 121, 
	33, 1, 93, 121, 103, 128, 128, 128, 
	128, 46, 121, 121, 93, 121, 121, 46, 
	121, 121, 33, 1, 93, 121, 103, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 1, 1, 
	1, 128, 1, 1, 1, 1, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	1, 1, 1, 1, 9, 1, 1, 1, 
	1, 1, 1, 1, 1, 128, 1, 128, 
	84, 1, 84, 1, 1, 1, 1, 1, 
	1, 128, 1, 84, 84, 84, 84, 84, 
	1, 128, 128, 66, 1, 128, 128, 1, 
	1, 1, 1, 128, 87, 1, 46, 121, 
	121, 93, 121, 121, 46, 121, 121, 33, 
	1, 93, 121, 103, 128, 128, 128, 128, 
	128, 128, 1, 1, 128, 15, 10, 10, 
	10, 10, 1, 1, 1, 1, 1, 1, 
	1, 128, 1, 84, 84, 84, 84, 84, 
	84, 1, 1, 84, 84, 1, 1, 1, 
	1, 1, 96, 24, 0, 1, 1, 1, 
	24, 1, 1, 93, 24, 88, 128, 10, 
	128, 121, 0, 0, 8, 8, 0, 0, 
	93, 0, 0, 0, 93, 1, 0, 0, 
	0, 93, 55, 55, 0, 55, 55, 0, 
	46, 93, 93, 0, 0, 93, 55, 55, 
	0, 46, 1, 93, 76, 55, 55, 55, 
	0, 126, 126, 0, 126, 0, 126, 126, 
	126, 126, 0, 126, 126, 126, 126, 126, 
	126, 0, 0, 55, 0, 93, 88, 128, 
	10, 128, 121, 0, 0, 8, 8, 0, 
	0, 93, 0, 0, 0, 93, 1, 0, 
	0, 0, 93, 55, 55, 0, 55, 55, 
	0, 46, 93, 93, 0, 0, 93, 55, 
	55, 0, 46, 1, 93, 76, 55, 55, 
	55, 0, 126, 126, 0, 126, 0, 126, 
	126, 126, 126, 0, 126, 126, 126, 126, 
	126, 126, 0, 0, 55, 0, 93, 24, 
	27, 93, 27, 36, 88, 128, 10, 128, 
	27, 36, 24, 88, 128, 10, 128, 33, 
	24, 58, 58, 29, 128, 10, 128, 128, 
	128, 128, 24, 0, 66, 1, 1, 128, 
	128, 10, 1, 1, 1, 1, 1, 2, 
	1, 66, 1, 2, 128, 128, 128, 128, 
	128, 128, 128, 1, 1, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	1, 128, 128, 24, 1, 1, 1, 1, 
	0, 128, 128, 1, 0, 24, 0, 66, 
	1, 1, 1, 1, 1, 2, 1, 66, 
	1, 2, 128, 1, 1, 1, 127, 128, 
	62, 53, 53, 0, 53, 54, 1, 1, 
	1, 24, 0, 128, 0, 116, 0, 1, 
	1, 0, 53, 1, 1, 1, 24, 1, 
	128, 1, 1, 1, 1, 128, 128, 128, 
	0, 128, 1, 124, 24, 1, 1, 1, 
	0, 1, 0, 128, 128, 24, 0, 1, 
	1, 1, 0, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 4, 0, 66, 
	1, 0, 0, 0, 24, 1, 24, 66, 
	1, 1, 128, 24, 0, 20, 1, 84, 
	84, 84, 1, 1, 1, 27, 128, 128, 
	1, 0, 66, 2, 0, 0, 0, 0, 
	66, 128, 10, 1, 1, 1, 2, 1, 
	1, 2, 128, 10, 128, 1, 1, 2, 
	0, 25, 30, 1, 1, 66, 2, 123, 
	0, 128, 128, 121, 0, 0, 8, 8, 
	0, 0, 93, 0, 0, 0, 93, 1, 
	0, 0, 0, 93, 55, 55, 0, 55, 
	55, 0, 46, 93, 93, 0, 0, 93, 
	55, 55, 0, 46, 1, 93, 76, 55, 
	55, 55, 0, 126, 126, 0, 126, 0, 
	126, 126, 126, 126, 0, 126, 126, 126, 
	126, 126, 126, 126, 126, 126, 126, 126, 
	126, 126, 126, 126, 126, 126, 126, 126, 
	0, 0, 55, 0, 128, 128, 128, 0, 
	1, 0, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 66, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 0, 64, 93, 24, 0, 1, 1, 
	1, 0, 128, 128, 24, 0, 1, 1, 
	1, 0, 128, 128, 1, 0, 24, 0, 
	66, 1, 1, 128, 128, 10, 1, 24, 
	0, 0, 20, 2, 12, 1, 1, 54, 
	48, 75, 67, 15, 58, 1, 0, 5, 
	0, 0, 67, 67, 67, 67, 10, 1, 
	0, 5, 1, 0, 0, 67, 67, 67, 
	67, 67, 67, 67, 67, 69, 67, 69, 
	67, 1, 2, 1, 66, 1, 2, 128, 
	128, 0, 128, 128, 128, 128, 128, 128, 
	0, 1, 0, 0, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 84, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 0, 64, 0, 84, 84, 
	84, 1, 1, 1, 1, 1, 52, 1, 
	92, 101, 91, 1
]

class << self
	attr_accessor :_lex_index_offsets
	private :_lex_index_offsets, :_lex_index_offsets=
end
self._lex_index_offsets = [
	0, 0, 2, 4, 6, 8, 10, 12, 
	14, 16, 18, 46, 175, 304, 433, 562, 
	609, 731, 853, 947, 1069, 1191, 1238, 1360, 
	1482, 1516, 1518, 1612, 1734, 1838, 1967, 2096, 
	2225, 2354, 2401, 2523, 2645, 2739, 2861, 2983, 
	3030, 3152, 3274, 3308, 3310, 3404, 3526, 3630, 
	3759, 3888, 4017, 4146, 4275, 4404, 4533, 4662, 
	4791, 4920, 5049, 5178, 5307, 5436, 5565, 5567, 
	5569, 5571, 5700, 5702, 5704, 5706, 5708, 5837, 
	5966, 6095, 6224, 6353, 6482, 6611, 6740, 6869, 
	6998, 7127, 7256, 7385, 7514, 7643, 7772, 7901, 
	8030, 8032, 8034, 8036, 8038, 8048, 8050, 8052, 
	8054, 8056, 8058, 8060, 8062, 8064, 8193, 8195, 
	8324, 8409, 8411, 8496, 8498, 8500, 8502, 8504, 
	8506, 8508, 8637, 8639, 8724, 8809, 8894, 8979, 
	9064, 9066, 9195, 9324, 9391, 9393, 9522, 9651, 
	9653, 9655, 9657, 9659, 9788, 9876, 9878, 9925, 
	10047, 10169, 10263, 10385, 10507, 10554, 10676, 10798, 
	10832, 10834, 10928, 11050, 11154, 11283, 11412, 11541, 
	11670, 11799, 11928, 11930, 11932, 12061, 12077, 12088, 
	12099, 12110, 12121, 12123, 12125, 12127, 12129, 12131, 
	12133, 12135, 12264, 12266, 12351, 12436, 12521, 12606, 
	12691, 12776, 12778, 12780, 12865, 12950, 12952, 12954, 
	12956, 12958, 12960, 13057, 13082, 13083, 13085, 13087, 
	13089, 13114, 13116, 13118, 13212, 13237, 13326, 13455, 
	13466, 13595, 13717, 13718, 13719, 13728, 13737, 13738, 
	13739, 13833, 13834, 13835, 13836, 13930, 13932, 13933, 
	13934, 13935, 14029, 14085, 14141, 14142, 14198, 14254, 
	14255, 14302, 14396, 14490, 14491, 14492, 14586, 14642, 
	14698, 14699, 14746, 14748, 14842, 14919, 14975, 15031, 
	15087, 15088, 15215, 15342, 15343, 15470, 15471, 15598, 
	15725, 15852, 15979, 15980, 16107, 16234, 16361, 16488, 
	16615, 16742, 16743, 16744, 16800, 16801, 16895, 16984, 
	17113, 17124, 17253, 17375, 17376, 17377, 17386, 17395, 
	17396, 17397, 17491, 17492, 17493, 17494, 17588, 17590, 
	17591, 17592, 17593, 17687, 17743, 17799, 17800, 17856, 
	17912, 17913, 17960, 18054, 18148, 18149, 18150, 18244, 
	18300, 18356, 18357, 18404, 18406, 18500, 18577, 18633, 
	18689, 18745, 18746, 18873, 19000, 19001, 19128, 19129, 
	19256, 19383, 19510, 19637, 19638, 19765, 19892, 20019, 
	20146, 20273, 20400, 20401, 20402, 20458, 20459, 20553, 
	20578, 20606, 20700, 20728, 20765, 20854, 20983, 20994, 
	21123, 21151, 21188, 21213, 21302, 21431, 21442, 21571, 
	21605, 21630, 21689, 21748, 21778, 21907, 21918, 22047, 
	22176, 22305, 22434, 22459, 22460, 22527, 22529, 22531, 
	22660, 22789, 22800, 22802, 22804, 22806, 22808, 22810, 
	22813, 22815, 22882, 22884, 22887, 23016, 23145, 23274, 
	23403, 23532, 23661, 23790, 23792, 23794, 23923, 24052, 
	24181, 24310, 24439, 24568, 24697, 24826, 24955, 25084, 
	25213, 25342, 25471, 25600, 25729, 25858, 25987, 26116, 
	26245, 26374, 26503, 26632, 26761, 26890, 27019, 27148, 
	27277, 27406, 27535, 27664, 27793, 27922, 28051, 28180, 
	28309, 28438, 28567, 28696, 28825, 28954, 29083, 29212, 
	29341, 29470, 29599, 29728, 29857, 29986, 30115, 30244, 
	30373, 30502, 30631, 30760, 30889, 31018, 31147, 31276, 
	31405, 31534, 31663, 31792, 31921, 32050, 32179, 32308, 
	32437, 32566, 32695, 32824, 32953, 33082, 33211, 33340, 
	33469, 33598, 33727, 33856, 33985, 34114, 34243, 34372, 
	34501, 34503, 34632, 34761, 34786, 34788, 34790, 34792, 
	34794, 34795, 34924, 35053, 35055, 35056, 35081, 35082, 
	35149, 35151, 35153, 35155, 35157, 35159, 35162, 35164, 
	35231, 35233, 35236, 35365, 35367, 35369, 35371, 35499, 
	35628, 35691, 35745, 35799, 35800, 35854, 35909, 35911, 
	35913, 35915, 35940, 35941, 36070, 36071, 36188, 36189, 
	36191, 36193, 36194, 36248, 36250, 36252, 36254, 36279, 
	36281, 36410, 36412, 36414, 36416, 36418, 36547, 36676, 
	36805, 36806, 36935, 36937, 37062, 37087, 37089, 37091, 
	37093, 37094, 37096, 37097, 37226, 37355, 37380, 37381, 
	37383, 37385, 37387, 37388, 37517, 37646, 37775, 37904, 
	38033, 38162, 38291, 38420, 38549, 38678, 38807, 38936, 
	39065, 39194, 39323, 39452, 39581, 39710, 39715, 39716, 
	39783, 39785, 39786, 39787, 39788, 39813, 39815, 39840, 
	39907, 39909, 39911, 40040, 40065, 40066, 40087, 40089, 
	40174, 40259, 40344, 40346, 40348, 40350, 40378, 40507, 
	40636, 40638, 40639, 40706, 40709, 40710, 40711, 40712, 
	40713, 40780, 40909, 40920, 40922, 40924, 40926, 40929, 
	40931, 40933, 40936, 41065, 41076, 41205, 41207, 41209, 
	41212, 41213, 41239, 41270, 41272, 41274, 41341, 41344, 
	41468, 41469, 41598, 41727, 41849, 41850, 41851, 41860, 
	41869, 41870, 41871, 41965, 41966, 41967, 41968, 42062, 
	42064, 42065, 42066, 42067, 42161, 42217, 42273, 42274, 
	42330, 42386, 42387, 42434, 42528, 42622, 42623, 42624, 
	42718, 42774, 42830, 42831, 42878, 42880, 42974, 43051, 
	43107, 43163, 43219, 43220, 43347, 43474, 43475, 43602, 
	43603, 43730, 43857, 43984, 44111, 44112, 44239, 44366, 
	44493, 44620, 44747, 44874, 45001, 45128, 45255, 45382, 
	45509, 45636, 45763, 45890, 46017, 46144, 46271, 46398, 
	46525, 46526, 46527, 46583, 46584, 46713, 46842, 46971, 
	46972, 46974, 46975, 47104, 47233, 47362, 47491, 47620, 
	47749, 47878, 48007, 48136, 48265, 48394, 48523, 48652, 
	48781, 48910, 49039, 49168, 49297, 49426, 49555, 49684, 
	49813, 49942, 50071, 50200, 50329, 50458, 50587, 50716, 
	50845, 50974, 51103, 51232, 51361, 51490, 51619, 51748, 
	51877, 52006, 52135, 52264, 52393, 52522, 52651, 52780, 
	52909, 53038, 53167, 53296, 53425, 53554, 53683, 53812, 
	53941, 54070, 54199, 54328, 54457, 54586, 54715, 54844, 
	54911, 55040, 55169, 55298, 55427, 55556, 55685, 55814, 
	55943, 56072, 56201, 56330, 56459, 56588, 56717, 56846, 
	56975, 57104, 57233, 57362, 57491, 57620, 57749, 57878, 
	58007, 58136, 58137, 58202, 58296, 58321, 58322, 58324, 
	58326, 58328, 58329, 58458, 58587, 58612, 58613, 58615, 
	58617, 58619, 58620, 58749, 58878, 58880, 58881, 58906, 
	58907, 58974, 58976, 58978, 59107, 59236, 59247, 59249, 
	59274, 59275, 59276, 59297, 59300, 59313, 59315, 59317, 
	59372, 59421, 59497, 59565, 59581, 59640, 59642, 59643, 
	59649, 59650, 59651, 59719, 59787, 59855, 59923, 59934, 
	59936, 59937, 59943, 59945, 59946, 59947, 60015, 60083, 
	60151, 60219, 60287, 60355, 60423, 60491, 60561, 60629, 
	60699, 60767, 60769, 60772, 60774, 60841, 60843, 60846, 
	60975, 61104, 61105, 61234, 61363, 61492, 61621, 61750, 
	61879, 61880, 61882, 61883, 61884, 62013, 62142, 62271, 
	62400, 62529, 62658, 62787, 62916, 63045, 63174, 63303, 
	63432, 63561, 63690, 63819, 63948, 64077, 64206, 64335, 
	64464, 64593, 64722, 64851, 64980, 65109, 65238, 65367, 
	65496, 65625, 65754, 65883, 66012, 66141, 66270, 66399, 
	66528, 66657, 66742, 66871, 67000, 67129, 67258, 67387, 
	67516, 67645, 67774, 67903, 68032, 68161, 68290, 68419, 
	68548, 68677, 68806, 68935, 69064, 69193, 69322, 69451, 
	69580, 69709, 69838, 69967, 70096, 70225, 70354, 70483, 
	70612, 70741, 70870, 70999, 71128, 71257, 71386, 71515, 
	71644, 71773, 71902, 72031, 72160, 72289, 72418, 72547, 
	72676, 72805, 72934, 73063, 73192, 73321, 73450, 73579, 
	73708, 73837, 73966, 74095, 74224, 74353, 74482, 74611, 
	74740, 74869, 74998, 75127, 75128, 75193, 75194, 75279, 
	75364, 75449, 75451, 75453, 75455, 75457, 75459, 75512, 
	75514, 75607, 75709, 75801
]

class << self
	attr_accessor :_lex_indicies
	private :_lex_indicies, :_lex_indicies=
end
self._lex_indicies = [
	1, 0, 2, 0, 3, 0, 4, 0, 
	5, 0, 6, 0, 7, 0, 8, 0, 
	9, 0, 10, 0, 0, 0, 10, 0, 
	0, 0, 0, 0, 11, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 10, 0, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 14, 
	14, 12, 14, 12, 14, 14, 12, 12, 
	14, 14, 14, 15, 14, 14, 16, 16, 
	16, 16, 16, 16, 16, 16, 16, 16, 
	14, 14, 14, 14, 14, 14, 14, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 12, 14, 12, 12, 13, 14, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 12, 12, 12, 14, 12, 13, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 14, 
	14, 14, 14, 14, 14, 14, 14, 14, 
	14, 12, 12, 12, 12, 12, 12, 12, 
	14, 14, 14, 14, 14, 14, 14, 14, 
	14, 14, 14, 14, 14, 14, 14, 14, 
	14, 14, 14, 14, 14, 14, 14, 14, 
	14, 14, 12, 12, 12, 12, 14, 12, 
	14, 14, 14, 14, 14, 14, 14, 14, 
	14, 14, 14, 14, 14, 14, 14, 14, 
	14, 14, 14, 14, 14, 14, 14, 14, 
	14, 14, 12, 12, 12, 12, 12, 14, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	17, 17, 17, 17, 17, 17, 17, 17, 
	17, 17, 12, 12, 12, 12, 12, 12, 
	18, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 12, 12, 12, 12, 13, 
	12, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 12, 12, 12, 12, 12, 
	13, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 17, 17, 17, 17, 17, 17, 17, 
	17, 17, 17, 12, 12, 12, 12, 12, 
	12, 12, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 12, 12, 12, 12, 
	13, 12, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 12, 12, 12, 12, 
	12, 13, 19, 20, 20, 20, 19, 20, 
	20, 20, 20, 20, 20, 20, 20, 20, 
	20, 20, 20, 20, 20, 20, 20, 20, 
	20, 20, 20, 20, 19, 20, 20, 20, 
	20, 20, 20, 20, 20, 20, 20, 20, 
	20, 20, 20, 20, 20, 20, 20, 21, 
	20, 19, 22, 22, 22, 19, 22, 22, 
	22, 22, 22, 23, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 19, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 24, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 25, 22, 19, 22, 22, 22, 19, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 19, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	26, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 25, 22, 19, 27, 27, 
	27, 19, 27, 27, 27, 27, 27, 27, 
	27, 27, 27, 27, 27, 27, 27, 27, 
	27, 27, 27, 27, 27, 27, 27, 19, 
	27, 27, 27, 27, 27, 27, 27, 27, 
	27, 27, 27, 27, 27, 27, 27, 27, 
	27, 27, 27, 27, 27, 27, 27, 27, 
	27, 27, 27, 27, 27, 27, 27, 27, 
	27, 27, 27, 27, 28, 27, 27, 27, 
	27, 27, 27, 27, 27, 27, 27, 27, 
	27, 27, 27, 27, 27, 27, 27, 27, 
	27, 27, 27, 27, 27, 27, 27, 27, 
	27, 29, 27, 19, 30, 30, 30, 19, 
	30, 30, 30, 30, 30, 31, 30, 30, 
	30, 30, 30, 30, 30, 30, 30, 30, 
	30, 30, 30, 30, 30, 19, 30, 30, 
	30, 30, 30, 30, 30, 30, 30, 30, 
	30, 30, 30, 30, 30, 30, 30, 30, 
	30, 30, 30, 30, 30, 30, 30, 30, 
	30, 30, 30, 30, 30, 30, 30, 30, 
	30, 30, 30, 30, 30, 30, 30, 30, 
	30, 30, 30, 30, 30, 30, 30, 30, 
	30, 30, 30, 30, 30, 30, 30, 30, 
	30, 30, 30, 30, 30, 30, 30, 30, 
	30, 30, 30, 30, 30, 30, 30, 30, 
	30, 30, 30, 30, 30, 30, 30, 30, 
	30, 30, 30, 30, 30, 30, 30, 30, 
	30, 30, 30, 32, 30, 19, 30, 30, 
	30, 19, 30, 30, 30, 30, 30, 30, 
	30, 30, 30, 30, 30, 30, 30, 30, 
	30, 30, 30, 30, 30, 30, 30, 19, 
	30, 30, 30, 30, 30, 30, 30, 30, 
	30, 30, 30, 30, 30, 30, 30, 30, 
	30, 30, 30, 30, 30, 30, 30, 30, 
	30, 30, 30, 30, 30, 30, 30, 30, 
	30, 30, 30, 30, 30, 30, 30, 30, 
	30, 30, 30, 30, 30, 30, 30, 30, 
	30, 30, 30, 30, 30, 30, 30, 30, 
	30, 30, 30, 30, 30, 30, 30, 30, 
	30, 30, 30, 30, 30, 30, 30, 30, 
	30, 30, 30, 30, 30, 30, 30, 30, 
	30, 30, 30, 30, 30, 30, 30, 30, 
	30, 30, 30, 30, 30, 32, 30, 19, 
	20, 20, 20, 19, 20, 20, 20, 20, 
	20, 20, 20, 20, 20, 20, 20, 20, 
	20, 20, 20, 20, 20, 20, 20, 20, 
	20, 19, 20, 20, 20, 20, 20, 20, 
	20, 20, 20, 20, 20, 20, 20, 20, 
	20, 20, 20, 20, 33, 20, 19, 34, 
	34, 34, 19, 34, 34, 34, 34, 34, 
	35, 34, 34, 34, 34, 34, 34, 34, 
	34, 34, 34, 34, 34, 34, 34, 34, 
	19, 34, 34, 34, 34, 34, 34, 34, 
	34, 34, 34, 34, 34, 34, 34, 34, 
	34, 34, 34, 34, 34, 34, 34, 34, 
	34, 34, 34, 34, 34, 34, 34, 34, 
	34, 34, 34, 34, 34, 34, 34, 34, 
	34, 36, 34, 34, 34, 34, 34, 34, 
	34, 34, 34, 34, 34, 34, 34, 34, 
	34, 34, 34, 34, 34, 34, 34, 34, 
	34, 34, 37, 34, 34, 34, 34, 34, 
	34, 38, 34, 34, 34, 34, 34, 34, 
	34, 34, 34, 34, 34, 34, 34, 34, 
	34, 34, 34, 34, 34, 34, 39, 34, 
	19, 34, 34, 34, 19, 34, 34, 34, 
	34, 34, 34, 34, 34, 34, 34, 34, 
	34, 34, 34, 34, 34, 34, 34, 34, 
	34, 34, 19, 34, 34, 34, 34, 34, 
	34, 34, 34, 34, 34, 34, 34, 34, 
	34, 34, 34, 34, 34, 34, 34, 34, 
	34, 34, 34, 34, 34, 34, 34, 34, 
	34, 34, 34, 34, 34, 34, 34, 34, 
	34, 34, 34, 34, 34, 34, 34, 34, 
	34, 34, 34, 34, 34, 34, 34, 34, 
	34, 34, 34, 34, 34, 34, 34, 34, 
	34, 34, 34, 34, 34, 34, 34, 34, 
	34, 34, 34, 34, 34, 34, 34, 34, 
	34, 34, 34, 34, 34, 34, 34, 34, 
	34, 34, 34, 34, 34, 34, 34, 34, 
	39, 34, 40, 19, 19, 19, 19, 19, 
	19, 19, 19, 19, 19, 19, 19, 19, 
	19, 19, 19, 19, 19, 19, 19, 19, 
	19, 19, 19, 19, 19, 19, 19, 19, 
	19, 19, 41, 19, 41, 19, 19, 42, 
	42, 42, 19, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	19, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 43, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 44, 42, 19, 22, 22, 22, 
	19, 22, 22, 22, 22, 22, 23, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 19, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 26, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 25, 22, 19, 45, 
	45, 45, 19, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	19, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 46, 46, 
	46, 46, 46, 46, 46, 46, 46, 46, 
	45, 45, 45, 45, 45, 45, 45, 46, 
	46, 46, 46, 46, 46, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 46, 
	46, 46, 46, 46, 46, 45, 47, 47, 
	47, 47, 47, 47, 47, 47, 47, 47, 
	47, 47, 47, 47, 47, 47, 47, 47, 
	47, 47, 47, 47, 47, 47, 47, 47, 
	47, 47, 47, 47, 47, 47, 47, 49, 
	49, 47, 49, 47, 49, 49, 47, 47, 
	49, 49, 49, 50, 49, 49, 51, 51, 
	51, 51, 51, 51, 51, 51, 51, 51, 
	49, 49, 49, 49, 49, 49, 49, 48, 
	48, 48, 48, 48, 48, 48, 48, 48, 
	48, 48, 48, 48, 48, 48, 48, 48, 
	48, 48, 48, 48, 48, 48, 48, 48, 
	48, 47, 49, 47, 47, 48, 49, 48, 
	48, 48, 48, 48, 48, 48, 48, 48, 
	48, 48, 48, 48, 48, 48, 48, 48, 
	48, 48, 48, 48, 48, 48, 48, 48, 
	48, 47, 47, 47, 49, 47, 48, 47, 
	47, 47, 47, 47, 47, 47, 47, 47, 
	47, 47, 47, 47, 47, 47, 47, 47, 
	47, 47, 47, 47, 47, 47, 47, 47, 
	47, 47, 47, 47, 47, 47, 47, 47, 
	47, 47, 47, 47, 47, 47, 47, 47, 
	47, 47, 47, 47, 47, 47, 47, 49, 
	49, 49, 49, 49, 49, 49, 49, 49, 
	49, 47, 47, 47, 47, 47, 47, 47, 
	49, 49, 49, 49, 49, 49, 49, 49, 
	49, 49, 49, 49, 49, 49, 49, 49, 
	49, 49, 49, 49, 49, 49, 49, 49, 
	49, 49, 47, 47, 47, 47, 49, 47, 
	49, 49, 49, 49, 49, 49, 49, 49, 
	49, 49, 49, 49, 49, 49, 49, 49, 
	49, 49, 49, 49, 49, 49, 49, 49, 
	49, 49, 47, 47, 47, 47, 47, 49, 
	47, 47, 47, 47, 47, 47, 47, 47, 
	47, 47, 47, 47, 47, 47, 47, 47, 
	47, 47, 47, 47, 47, 47, 47, 47, 
	47, 47, 47, 47, 47, 47, 47, 47, 
	47, 47, 47, 47, 47, 47, 47, 47, 
	47, 47, 47, 47, 47, 47, 47, 47, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 47, 47, 47, 47, 47, 47, 
	53, 48, 48, 48, 48, 48, 48, 48, 
	48, 48, 48, 48, 48, 48, 48, 48, 
	48, 48, 48, 48, 48, 48, 48, 48, 
	48, 48, 48, 47, 47, 47, 47, 48, 
	47, 48, 48, 48, 48, 48, 48, 48, 
	48, 48, 48, 48, 48, 48, 48, 48, 
	48, 48, 48, 48, 48, 48, 48, 48, 
	48, 48, 48, 47, 47, 47, 47, 47, 
	48, 47, 47, 47, 47, 47, 47, 47, 
	47, 47, 47, 47, 47, 47, 47, 47, 
	47, 47, 47, 47, 47, 47, 47, 47, 
	47, 47, 47, 47, 47, 47, 47, 47, 
	47, 47, 47, 47, 47, 47, 47, 47, 
	47, 47, 47, 47, 47, 47, 47, 47, 
	47, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 47, 47, 47, 47, 47, 
	47, 47, 48, 48, 48, 48, 48, 48, 
	48, 48, 48, 48, 48, 48, 48, 48, 
	48, 48, 48, 48, 48, 48, 48, 48, 
	48, 48, 48, 48, 47, 47, 47, 47, 
	48, 47, 48, 48, 48, 48, 48, 48, 
	48, 48, 48, 48, 48, 48, 48, 48, 
	48, 48, 48, 48, 48, 48, 48, 48, 
	48, 48, 48, 48, 47, 47, 47, 47, 
	47, 48, 54, 55, 55, 55, 54, 55, 
	55, 55, 55, 55, 55, 55, 55, 55, 
	55, 55, 55, 55, 55, 55, 55, 55, 
	55, 55, 55, 55, 54, 55, 55, 55, 
	55, 55, 55, 55, 55, 55, 55, 55, 
	55, 55, 55, 55, 55, 55, 55, 56, 
	55, 54, 57, 57, 57, 54, 57, 57, 
	57, 57, 57, 58, 57, 57, 57, 57, 
	57, 57, 57, 57, 57, 57, 57, 57, 
	57, 57, 57, 54, 57, 57, 57, 57, 
	57, 57, 57, 57, 57, 57, 57, 57, 
	57, 57, 57, 57, 57, 57, 57, 57, 
	57, 57, 57, 57, 57, 57, 57, 57, 
	57, 57, 57, 57, 57, 57, 57, 57, 
	57, 57, 57, 57, 57, 57, 57, 57, 
	57, 57, 57, 57, 57, 57, 59, 57, 
	57, 57, 57, 57, 57, 57, 57, 57, 
	57, 57, 57, 57, 57, 57, 57, 57, 
	57, 57, 57, 57, 57, 57, 57, 57, 
	57, 57, 57, 57, 57, 57, 57, 57, 
	57, 57, 57, 57, 57, 57, 57, 57, 
	57, 60, 57, 54, 57, 57, 57, 54, 
	57, 57, 57, 57, 57, 57, 57, 57, 
	57, 57, 57, 57, 57, 57, 57, 57, 
	57, 57, 57, 57, 57, 54, 57, 57, 
	57, 57, 57, 57, 57, 57, 57, 57, 
	57, 57, 57, 57, 57, 57, 57, 57, 
	57, 57, 57, 57, 57, 57, 57, 57, 
	57, 57, 57, 57, 57, 57, 57, 57, 
	57, 57, 57, 57, 57, 57, 57, 57, 
	57, 57, 57, 57, 57, 57, 57, 57, 
	61, 57, 57, 57, 57, 57, 57, 57, 
	57, 57, 57, 57, 57, 57, 57, 57, 
	57, 57, 57, 57, 57, 57, 57, 57, 
	57, 57, 57, 57, 57, 57, 57, 57, 
	57, 57, 57, 57, 57, 57, 57, 57, 
	57, 57, 57, 60, 57, 54, 62, 62, 
	62, 54, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 54, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 63, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 64, 62, 54, 65, 65, 65, 54, 
	65, 65, 65, 65, 65, 66, 65, 65, 
	65, 65, 65, 65, 65, 65, 65, 65, 
	65, 65, 65, 65, 65, 54, 65, 65, 
	65, 65, 65, 65, 65, 65, 65, 65, 
	65, 65, 65, 65, 65, 65, 65, 65, 
	65, 65, 65, 65, 65, 65, 65, 65, 
	65, 65, 65, 65, 65, 65, 65, 65, 
	65, 65, 65, 65, 65, 65, 65, 65, 
	65, 65, 65, 65, 65, 65, 65, 65, 
	65, 65, 65, 65, 65, 65, 65, 65, 
	65, 65, 65, 65, 65, 65, 65, 65, 
	65, 65, 65, 65, 65, 65, 65, 65, 
	65, 65, 65, 65, 65, 65, 65, 65, 
	65, 65, 65, 65, 65, 65, 65, 65, 
	65, 65, 65, 67, 65, 54, 65, 65, 
	65, 54, 65, 65, 65, 65, 65, 65, 
	65, 65, 65, 65, 65, 65, 65, 65, 
	65, 65, 65, 65, 65, 65, 65, 54, 
	65, 65, 65, 65, 65, 65, 65, 65, 
	65, 65, 65, 65, 65, 65, 65, 65, 
	65, 65, 65, 65, 65, 65, 65, 65, 
	65, 65, 65, 65, 65, 65, 65, 65, 
	65, 65, 65, 65, 65, 65, 65, 65, 
	65, 65, 65, 65, 65, 65, 65, 65, 
	65, 65, 65, 65, 65, 65, 65, 65, 
	65, 65, 65, 65, 65, 65, 65, 65, 
	65, 65, 65, 65, 65, 65, 65, 65, 
	65, 65, 65, 65, 65, 65, 65, 65, 
	65, 65, 65, 65, 65, 65, 65, 65, 
	65, 65, 65, 65, 65, 67, 65, 54, 
	55, 55, 55, 54, 55, 55, 55, 55, 
	55, 55, 55, 55, 55, 55, 55, 55, 
	55, 55, 55, 55, 55, 55, 55, 55, 
	55, 54, 55, 55, 55, 55, 55, 55, 
	55, 55, 55, 55, 55, 55, 55, 55, 
	55, 55, 55, 55, 68, 55, 54, 69, 
	69, 69, 54, 69, 69, 69, 69, 69, 
	70, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	54, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 71, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 72, 69, 69, 69, 69, 69, 
	69, 73, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 74, 69, 
	54, 69, 69, 69, 54, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 54, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	74, 69, 75, 54, 54, 54, 54, 54, 
	54, 54, 54, 54, 54, 54, 54, 54, 
	54, 54, 54, 54, 54, 54, 54, 54, 
	54, 54, 54, 54, 54, 54, 54, 54, 
	54, 54, 76, 54, 76, 54, 54, 77, 
	77, 77, 54, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	54, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 78, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 79, 77, 54, 57, 57, 57, 
	54, 57, 57, 57, 57, 57, 58, 57, 
	57, 57, 57, 57, 57, 57, 57, 57, 
	57, 57, 57, 57, 57, 57, 54, 57, 
	57, 57, 57, 57, 57, 57, 57, 57, 
	57, 57, 57, 57, 57, 57, 57, 57, 
	57, 57, 57, 57, 57, 57, 57, 57, 
	57, 57, 57, 57, 57, 57, 57, 57, 
	57, 57, 57, 57, 57, 57, 57, 57, 
	57, 57, 57, 57, 57, 57, 57, 57, 
	57, 61, 57, 57, 57, 57, 57, 57, 
	57, 57, 57, 57, 57, 57, 57, 57, 
	57, 57, 57, 57, 57, 57, 57, 57, 
	57, 57, 57, 57, 57, 57, 57, 57, 
	57, 57, 57, 57, 57, 57, 57, 57, 
	57, 57, 57, 57, 60, 57, 54, 80, 
	80, 80, 54, 80, 80, 80, 80, 80, 
	80, 80, 80, 80, 80, 80, 80, 80, 
	80, 80, 80, 80, 80, 80, 80, 80, 
	54, 80, 80, 80, 80, 80, 80, 80, 
	80, 80, 80, 80, 80, 80, 80, 80, 
	80, 80, 80, 80, 80, 80, 81, 81, 
	81, 81, 81, 81, 81, 81, 81, 81, 
	80, 80, 80, 80, 80, 80, 80, 81, 
	81, 81, 81, 81, 81, 80, 80, 80, 
	80, 80, 80, 80, 80, 80, 80, 80, 
	80, 80, 80, 80, 80, 80, 80, 80, 
	80, 80, 80, 80, 80, 80, 80, 81, 
	81, 81, 81, 81, 81, 80, 82, 82, 
	82, 82, 82, 82, 82, 82, 82, 82, 
	82, 82, 82, 82, 82, 82, 82, 82, 
	82, 82, 82, 82, 82, 82, 82, 82, 
	82, 82, 82, 82, 82, 82, 82, 84, 
	84, 82, 84, 82, 84, 84, 82, 82, 
	84, 84, 84, 85, 84, 84, 86, 86, 
	86, 86, 86, 86, 86, 86, 86, 86, 
	84, 84, 84, 84, 84, 84, 84, 83, 
	83, 83, 83, 83, 83, 83, 83, 83, 
	83, 83, 83, 83, 83, 83, 83, 83, 
	83, 83, 83, 83, 83, 83, 83, 83, 
	83, 82, 84, 82, 82, 83, 84, 83, 
	83, 83, 83, 83, 83, 83, 83, 83, 
	83, 83, 83, 83, 83, 83, 83, 83, 
	83, 83, 83, 83, 83, 83, 83, 83, 
	83, 82, 82, 82, 84, 82, 83, 82, 
	82, 82, 82, 82, 82, 82, 82, 82, 
	82, 82, 82, 82, 82, 82, 82, 82, 
	82, 82, 82, 82, 82, 82, 82, 82, 
	82, 82, 82, 82, 82, 82, 82, 82, 
	82, 82, 82, 82, 82, 82, 82, 82, 
	82, 82, 82, 82, 82, 82, 82, 84, 
	84, 84, 84, 84, 84, 84, 84, 84, 
	84, 82, 82, 82, 82, 82, 82, 82, 
	84, 84, 84, 84, 84, 84, 84, 84, 
	84, 84, 84, 84, 84, 84, 84, 84, 
	84, 84, 84, 84, 84, 84, 84, 84, 
	84, 84, 82, 82, 82, 82, 84, 82, 
	84, 84, 84, 84, 84, 84, 84, 84, 
	84, 84, 84, 84, 84, 84, 84, 84, 
	84, 84, 84, 84, 84, 84, 84, 84, 
	84, 84, 82, 82, 82, 82, 82, 84, 
	82, 82, 82, 82, 82, 82, 82, 82, 
	82, 82, 82, 82, 82, 82, 82, 82, 
	82, 82, 82, 82, 82, 82, 82, 82, 
	82, 82, 82, 82, 82, 82, 82, 82, 
	82, 82, 82, 82, 82, 82, 82, 82, 
	82, 82, 82, 82, 82, 82, 82, 82, 
	87, 87, 87, 87, 87, 87, 87, 87, 
	87, 87, 82, 82, 82, 82, 82, 82, 
	88, 83, 83, 83, 83, 83, 83, 83, 
	83, 83, 83, 83, 83, 83, 83, 83, 
	83, 83, 83, 83, 83, 83, 83, 83, 
	83, 83, 83, 82, 82, 82, 82, 83, 
	82, 83, 83, 83, 83, 83, 83, 83, 
	83, 83, 83, 83, 83, 83, 83, 83, 
	83, 83, 83, 83, 83, 83, 83, 83, 
	83, 83, 83, 82, 82, 82, 82, 82, 
	83, 82, 82, 82, 82, 82, 82, 82, 
	82, 82, 82, 82, 82, 82, 82, 82, 
	82, 82, 82, 82, 82, 82, 82, 82, 
	82, 82, 82, 82, 82, 82, 82, 82, 
	82, 82, 82, 82, 82, 82, 82, 82, 
	82, 82, 82, 82, 82, 82, 82, 82, 
	82, 87, 87, 87, 87, 87, 87, 87, 
	87, 87, 87, 82, 82, 82, 82, 82, 
	82, 82, 83, 83, 83, 83, 83, 83, 
	83, 83, 83, 83, 83, 83, 83, 83, 
	83, 83, 83, 83, 83, 83, 83, 83, 
	83, 83, 83, 83, 82, 82, 82, 82, 
	83, 82, 83, 83, 83, 83, 83, 83, 
	83, 83, 83, 83, 83, 83, 83, 83, 
	83, 83, 83, 83, 83, 83, 83, 83, 
	83, 83, 83, 83, 82, 82, 82, 82, 
	82, 83, 89, 89, 89, 89, 89, 89, 
	89, 89, 89, 89, 89, 89, 89, 89, 
	89, 89, 89, 89, 89, 89, 89, 89, 
	89, 89, 89, 89, 89, 89, 89, 89, 
	89, 89, 89, 91, 91, 89, 91, 89, 
	91, 91, 89, 89, 91, 91, 91, 92, 
	91, 91, 93, 93, 93, 93, 93, 93, 
	93, 93, 93, 93, 91, 91, 91, 91, 
	91, 91, 91, 90, 90, 90, 90, 90, 
	90, 90, 90, 90, 90, 90, 90, 90, 
	90, 90, 90, 90, 90, 90, 90, 90, 
	90, 90, 90, 90, 90, 89, 91, 89, 
	89, 90, 91, 90, 90, 90, 90, 90, 
	90, 90, 90, 90, 90, 90, 90, 90, 
	90, 90, 90, 90, 90, 90, 90, 90, 
	90, 90, 90, 90, 90, 89, 89, 89, 
	91, 89, 90, 89, 89, 89, 89, 89, 
	89, 89, 89, 89, 89, 89, 89, 89, 
	89, 89, 89, 89, 89, 89, 89, 89, 
	89, 89, 89, 89, 89, 89, 89, 89, 
	89, 89, 89, 89, 89, 89, 89, 89, 
	89, 89, 89, 89, 89, 89, 89, 89, 
	89, 89, 89, 91, 91, 91, 91, 91, 
	91, 91, 91, 91, 91, 89, 89, 89, 
	89, 89, 89, 89, 91, 91, 91, 91, 
	91, 91, 91, 91, 91, 91, 91, 91, 
	91, 91, 91, 91, 91, 91, 91, 91, 
	91, 91, 91, 91, 91, 91, 89, 89, 
	89, 89, 91, 89, 91, 91, 91, 91, 
	91, 91, 91, 91, 91, 91, 91, 91, 
	91, 91, 91, 91, 91, 91, 91, 91, 
	91, 91, 91, 91, 91, 91, 89, 89, 
	89, 89, 89, 91, 89, 89, 89, 89, 
	89, 89, 89, 89, 89, 89, 89, 89, 
	89, 89, 89, 89, 89, 89, 89, 89, 
	89, 89, 89, 89, 89, 89, 89, 89, 
	89, 89, 89, 89, 89, 89, 89, 89, 
	89, 89, 89, 89, 89, 89, 89, 89, 
	89, 89, 89, 89, 94, 94, 94, 94, 
	94, 94, 94, 94, 94, 94, 89, 89, 
	89, 89, 89, 89, 95, 90, 90, 90, 
	90, 90, 90, 90, 90, 90, 90, 90, 
	90, 90, 90, 90, 90, 90, 90, 90, 
	90, 90, 90, 90, 90, 90, 90, 89, 
	89, 89, 89, 90, 89, 90, 90, 90, 
	90, 90, 90, 90, 90, 90, 90, 90, 
	90, 90, 90, 90, 90, 90, 90, 90, 
	90, 90, 90, 90, 90, 90, 90, 89, 
	89, 89, 89, 89, 90, 89, 89, 89, 
	89, 89, 89, 89, 89, 89, 89, 89, 
	89, 89, 89, 89, 89, 89, 89, 89, 
	89, 89, 89, 89, 89, 89, 89, 89, 
	89, 89, 89, 89, 89, 89, 89, 89, 
	89, 89, 89, 89, 89, 89, 89, 89, 
	89, 89, 89, 89, 89, 94, 94, 94, 
	94, 94, 94, 94, 94, 94, 94, 89, 
	89, 89, 89, 89, 89, 89, 90, 90, 
	90, 90, 90, 90, 90, 90, 90, 90, 
	90, 90, 90, 90, 90, 90, 90, 90, 
	90, 90, 90, 90, 90, 90, 90, 90, 
	89, 89, 89, 89, 90, 89, 90, 90, 
	90, 90, 90, 90, 90, 90, 90, 90, 
	90, 90, 90, 90, 90, 90, 90, 90, 
	90, 90, 90, 90, 90, 90, 90, 90, 
	89, 89, 89, 89, 89, 90, 98, 98, 
	98, 98, 98, 98, 98, 98, 98, 98, 
	98, 98, 98, 98, 98, 98, 98, 98, 
	98, 98, 98, 98, 98, 98, 98, 98, 
	98, 98, 98, 98, 98, 98, 98, 97, 
	97, 98, 97, 98, 97, 97, 98, 98, 
	97, 97, 97, 99, 97, 97, 100, 100, 
	100, 100, 100, 100, 100, 100, 100, 100, 
	97, 97, 97, 97, 97, 97, 97, 96, 
	96, 96, 96, 96, 96, 96, 96, 96, 
	96, 96, 96, 96, 96, 96, 96, 96, 
	96, 96, 96, 96, 96, 96, 96, 96, 
	96, 98, 97, 98, 98, 96, 97, 96, 
	96, 96, 96, 96, 96, 96, 96, 96, 
	96, 96, 96, 96, 96, 96, 96, 96, 
	96, 96, 96, 96, 96, 96, 96, 96, 
	96, 98, 98, 98, 97, 98, 96, 98, 
	98, 98, 98, 98, 98, 98, 98, 98, 
	98, 98, 98, 98, 98, 98, 98, 98, 
	98, 98, 98, 98, 98, 98, 98, 98, 
	98, 98, 98, 98, 98, 98, 98, 98, 
	98, 98, 98, 98, 98, 98, 98, 98, 
	98, 98, 98, 98, 98, 98, 98, 97, 
	97, 97, 97, 97, 97, 97, 97, 97, 
	97, 98, 98, 98, 98, 98, 98, 98, 
	97, 97, 97, 97, 97, 97, 97, 97, 
	97, 97, 97, 97, 97, 97, 97, 97, 
	97, 97, 97, 97, 97, 97, 97, 97, 
	97, 97, 98, 98, 98, 98, 97, 98, 
	97, 97, 97, 97, 97, 97, 97, 97, 
	97, 97, 97, 97, 97, 97, 97, 97, 
	97, 97, 97, 97, 97, 97, 97, 97, 
	97, 97, 98, 98, 98, 98, 98, 97, 
	98, 98, 98, 98, 98, 98, 98, 98, 
	98, 98, 98, 98, 98, 98, 98, 98, 
	98, 98, 98, 98, 98, 98, 98, 98, 
	98, 98, 98, 98, 98, 98, 98, 98, 
	98, 98, 98, 98, 98, 98, 98, 98, 
	98, 98, 98, 98, 98, 98, 98, 98, 
	101, 101, 101, 101, 101, 101, 101, 101, 
	101, 101, 98, 98, 98, 98, 98, 98, 
	102, 101, 101, 101, 101, 101, 101, 101, 
	101, 101, 101, 101, 101, 101, 101, 101, 
	101, 101, 101, 101, 101, 101, 101, 101, 
	101, 101, 101, 98, 98, 98, 98, 101, 
	98, 101, 101, 101, 101, 101, 101, 101, 
	101, 101, 101, 101, 101, 101, 101, 101, 
	101, 101, 101, 101, 101, 101, 101, 101, 
	101, 101, 101, 98, 98, 98, 98, 98, 
	101, 98, 98, 98, 98, 98, 98, 98, 
	98, 98, 98, 98, 98, 98, 98, 98, 
	98, 98, 98, 98, 98, 98, 98, 98, 
	98, 98, 98, 98, 98, 98, 98, 98, 
	98, 98, 98, 98, 98, 98, 98, 98, 
	98, 98, 98, 98, 98, 98, 98, 98, 
	98, 103, 103, 103, 103, 103, 103, 103, 
	103, 103, 103, 98, 98, 98, 98, 98, 
	98, 98, 103, 103, 103, 103, 103, 103, 
	103, 103, 103, 103, 103, 103, 103, 103, 
	103, 103, 103, 103, 103, 103, 103, 103, 
	103, 103, 103, 103, 98, 98, 98, 98, 
	103, 98, 103, 103, 103, 103, 103, 103, 
	103, 103, 103, 103, 103, 103, 103, 103, 
	103, 103, 103, 103, 103, 103, 103, 103, 
	103, 103, 103, 103, 98, 98, 98, 98, 
	98, 103, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 105, 105, 105, 105, 105, 105, 
	105, 105, 105, 105, 104, 104, 104, 104, 
	104, 104, 104, 105, 105, 105, 105, 105, 
	105, 105, 105, 105, 105, 105, 105, 105, 
	105, 105, 105, 105, 105, 105, 105, 105, 
	105, 105, 105, 105, 105, 104, 104, 104, 
	104, 105, 104, 105, 105, 105, 105, 105, 
	105, 105, 105, 105, 105, 105, 105, 105, 
	105, 105, 105, 105, 105, 105, 105, 105, 
	105, 105, 105, 105, 105, 104, 104, 104, 
	104, 104, 105, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 106, 106, 106, 106, 106, 
	106, 106, 106, 106, 106, 107, 107, 107, 
	107, 107, 107, 107, 106, 106, 106, 106, 
	106, 106, 106, 106, 106, 106, 106, 106, 
	106, 106, 106, 106, 106, 106, 106, 106, 
	106, 106, 106, 106, 106, 106, 107, 107, 
	107, 107, 107, 107, 106, 106, 106, 106, 
	106, 106, 106, 106, 106, 106, 106, 106, 
	106, 106, 106, 106, 106, 106, 106, 106, 
	106, 106, 106, 106, 106, 106, 107, 107, 
	107, 107, 107, 106, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 110, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 109, 109, 109, 109, 
	109, 109, 109, 109, 109, 109, 111, 108, 
	108, 108, 108, 110, 108, 109, 109, 109, 
	109, 109, 109, 109, 109, 109, 109, 109, 
	109, 109, 109, 109, 109, 109, 109, 109, 
	109, 109, 109, 109, 109, 109, 109, 108, 
	108, 108, 108, 109, 108, 109, 109, 109, 
	109, 109, 109, 109, 109, 109, 109, 109, 
	109, 109, 109, 109, 109, 109, 109, 109, 
	109, 109, 109, 109, 109, 109, 109, 108, 
	108, 108, 108, 108, 109, 111, 108, 108, 
	112, 113, 108, 114, 114, 114, 114, 114, 
	114, 114, 114, 114, 114, 114, 114, 114, 
	114, 114, 114, 114, 114, 114, 114, 114, 
	114, 114, 114, 114, 114, 114, 114, 114, 
	114, 114, 114, 114, 116, 114, 114, 114, 
	114, 114, 114, 114, 114, 114, 114, 114, 
	114, 114, 114, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 117, 114, 114, 
	114, 114, 116, 114, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 114, 114, 
	114, 114, 115, 114, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 114, 114, 
	114, 114, 114, 115, 117, 114, 119, 118, 
	120, 118, 121, 118, 118, 118, 118, 118, 
	118, 118, 118, 118, 118, 123, 118, 123, 
	123, 123, 118, 118, 118, 118, 118, 118, 
	118, 118, 118, 118, 118, 118, 118, 118, 
	118, 118, 118, 118, 123, 118, 118, 118, 
	118, 124, 125, 118, 126, 118, 127, 128, 
	129, 130, 131, 124, 118, 118, 118, 118, 
	118, 118, 118, 118, 118, 118, 132, 118, 
	133, 129, 134, 135, 118, 122, 122, 122, 
	122, 122, 122, 122, 122, 122, 122, 122, 
	122, 122, 122, 122, 122, 122, 122, 122, 
	122, 122, 122, 122, 122, 122, 122, 136, 
	137, 129, 138, 122, 118, 122, 122, 122, 
	122, 122, 122, 122, 122, 139, 122, 122, 
	122, 122, 122, 122, 122, 122, 140, 122, 
	122, 141, 122, 142, 122, 122, 122, 143, 
	144, 118, 138, 118, 122, 118, 118, 118, 
	118, 118, 118, 118, 118, 118, 145, 118, 
	145, 145, 145, 118, 118, 118, 118, 118, 
	118, 118, 118, 118, 118, 118, 118, 118, 
	118, 118, 118, 118, 118, 145, 118, 118, 
	118, 118, 146, 147, 118, 148, 118, 149, 
	150, 151, 152, 153, 146, 118, 118, 118, 
	118, 118, 118, 118, 118, 118, 118, 154, 
	118, 155, 151, 156, 157, 118, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	158, 159, 151, 120, 115, 118, 115, 115, 
	115, 115, 115, 115, 115, 115, 160, 115, 
	115, 115, 115, 115, 115, 115, 115, 161, 
	115, 115, 162, 115, 163, 115, 115, 115, 
	164, 165, 118, 120, 118, 115, 118, 118, 
	118, 118, 118, 118, 118, 118, 118, 118, 
	118, 118, 118, 118, 118, 118, 118, 118, 
	118, 118, 118, 118, 118, 118, 118, 118, 
	118, 118, 118, 118, 118, 118, 118, 116, 
	118, 118, 118, 118, 118, 118, 118, 118, 
	118, 118, 118, 118, 118, 118, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	117, 118, 118, 118, 118, 116, 118, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 118, 118, 118, 118, 115, 118, 115, 
	115, 115, 115, 115, 166, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 118, 118, 118, 118, 118, 115, 118, 
	118, 118, 118, 118, 118, 118, 118, 118, 
	118, 118, 118, 118, 118, 118, 118, 118, 
	118, 118, 118, 118, 118, 118, 118, 118, 
	118, 118, 118, 118, 118, 118, 118, 118, 
	116, 118, 118, 118, 118, 118, 118, 118, 
	118, 118, 118, 118, 118, 118, 118, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 117, 118, 118, 118, 118, 116, 118, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 118, 118, 118, 118, 115, 118, 
	115, 115, 115, 115, 167, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 118, 118, 118, 118, 118, 115, 
	118, 118, 118, 118, 118, 118, 118, 118, 
	118, 118, 118, 118, 118, 118, 118, 118, 
	118, 118, 118, 118, 118, 118, 118, 118, 
	118, 118, 118, 118, 118, 118, 118, 118, 
	118, 116, 118, 118, 118, 118, 118, 118, 
	118, 118, 118, 118, 118, 118, 118, 118, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 117, 118, 118, 118, 118, 116, 
	118, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 118, 118, 118, 118, 115, 
	118, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 168, 115, 115, 115, 115, 
	115, 115, 115, 118, 118, 118, 118, 118, 
	115, 118, 118, 118, 118, 118, 118, 118, 
	118, 118, 118, 118, 118, 118, 118, 118, 
	118, 118, 118, 118, 118, 118, 118, 118, 
	118, 118, 118, 118, 118, 118, 118, 118, 
	118, 118, 116, 118, 118, 118, 118, 118, 
	118, 118, 118, 118, 118, 118, 118, 118, 
	118, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 117, 118, 118, 118, 118, 
	116, 118, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 118, 118, 118, 118, 
	115, 118, 115, 115, 169, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 118, 118, 118, 118, 
	118, 115, 118, 118, 118, 118, 118, 118, 
	118, 118, 118, 118, 118, 118, 118, 118, 
	118, 118, 118, 118, 118, 118, 118, 118, 
	118, 118, 118, 118, 118, 118, 118, 118, 
	118, 118, 118, 116, 118, 118, 118, 118, 
	118, 118, 118, 118, 118, 118, 118, 118, 
	118, 118, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 117, 118, 118, 118, 
	118, 116, 118, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 118, 118, 118, 
	118, 115, 118, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 170, 
	115, 115, 115, 115, 115, 118, 118, 118, 
	118, 118, 115, 118, 118, 118, 118, 118, 
	118, 118, 118, 118, 118, 118, 118, 118, 
	118, 118, 118, 118, 118, 118, 118, 118, 
	118, 118, 118, 118, 118, 118, 118, 118, 
	118, 118, 118, 118, 116, 118, 118, 118, 
	118, 118, 118, 118, 118, 118, 118, 118, 
	118, 118, 118, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 117, 118, 118, 
	118, 118, 116, 118, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 118, 118, 
	118, 118, 115, 118, 115, 115, 115, 115, 
	166, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 118, 118, 
	118, 118, 118, 115, 118, 118, 118, 118, 
	118, 118, 118, 118, 118, 118, 118, 118, 
	118, 118, 118, 118, 118, 118, 118, 118, 
	118, 118, 118, 118, 118, 118, 118, 118, 
	118, 118, 118, 118, 118, 116, 118, 118, 
	118, 118, 118, 118, 118, 118, 118, 118, 
	118, 118, 118, 118, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 117, 118, 
	118, 118, 118, 116, 118, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 118, 
	118, 118, 118, 115, 118, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 171, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 118, 
	118, 118, 118, 118, 115, 118, 118, 118, 
	118, 118, 118, 118, 118, 118, 118, 118, 
	118, 118, 118, 118, 118, 118, 118, 118, 
	118, 118, 118, 118, 118, 118, 118, 118, 
	118, 118, 118, 118, 118, 118, 116, 118, 
	118, 118, 118, 118, 118, 118, 118, 118, 
	118, 118, 118, 118, 118, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 117, 
	118, 118, 118, 118, 116, 118, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	118, 118, 118, 118, 115, 118, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 172, 115, 115, 115, 115, 115, 115, 
	115, 173, 115, 115, 115, 115, 115, 115, 
	118, 118, 118, 118, 118, 115, 118, 118, 
	118, 118, 118, 118, 118, 118, 118, 118, 
	118, 118, 118, 118, 118, 118, 118, 118, 
	118, 118, 118, 118, 118, 118, 118, 118, 
	118, 118, 118, 118, 118, 118, 118, 116, 
	118, 118, 118, 118, 118, 118, 118, 118, 
	118, 118, 118, 118, 118, 118, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	117, 118, 118, 118, 118, 116, 118, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 118, 118, 118, 118, 115, 118, 115, 
	115, 115, 115, 174, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 118, 118, 118, 118, 118, 115, 118, 
	118, 118, 118, 118, 118, 118, 118, 118, 
	118, 118, 118, 118, 118, 118, 118, 118, 
	118, 118, 118, 118, 118, 118, 118, 118, 
	118, 118, 118, 118, 118, 118, 118, 118, 
	116, 118, 118, 118, 118, 118, 118, 118, 
	118, 118, 118, 118, 118, 118, 118, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 117, 118, 118, 118, 118, 116, 118, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 118, 118, 118, 118, 115, 118, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 175, 115, 115, 115, 115, 115, 
	115, 115, 118, 118, 118, 118, 118, 115, 
	118, 118, 118, 118, 118, 118, 118, 118, 
	118, 118, 118, 118, 118, 118, 118, 118, 
	118, 118, 118, 118, 118, 118, 118, 118, 
	118, 118, 118, 118, 118, 118, 118, 118, 
	118, 116, 118, 118, 118, 118, 118, 118, 
	118, 118, 118, 118, 118, 118, 118, 118, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 117, 118, 118, 118, 118, 116, 
	118, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 118, 118, 118, 118, 115, 
	118, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 166, 115, 115, 115, 115, 
	115, 115, 115, 118, 118, 118, 118, 118, 
	115, 118, 118, 118, 118, 118, 118, 118, 
	118, 118, 118, 118, 118, 118, 118, 118, 
	118, 118, 118, 118, 118, 118, 118, 118, 
	118, 118, 118, 118, 118, 118, 118, 118, 
	118, 118, 116, 118, 118, 118, 118, 118, 
	118, 118, 118, 118, 118, 118, 118, 118, 
	118, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 117, 118, 118, 118, 118, 
	116, 118, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 118, 118, 118, 118, 
	115, 118, 115, 115, 115, 115, 115, 115, 
	115, 115, 176, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 118, 118, 118, 118, 
	118, 115, 118, 118, 118, 118, 118, 118, 
	118, 118, 118, 118, 118, 118, 118, 118, 
	118, 118, 118, 118, 118, 118, 118, 118, 
	118, 118, 118, 118, 118, 118, 118, 118, 
	118, 118, 118, 116, 118, 118, 118, 118, 
	118, 118, 118, 118, 118, 118, 118, 118, 
	118, 118, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 117, 118, 118, 118, 
	118, 116, 118, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 118, 118, 118, 
	118, 115, 118, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 166, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 118, 118, 118, 
	118, 118, 115, 118, 118, 118, 118, 118, 
	118, 118, 118, 118, 118, 118, 118, 118, 
	118, 118, 118, 118, 118, 118, 118, 118, 
	118, 118, 118, 118, 118, 118, 118, 118, 
	118, 118, 118, 118, 116, 118, 118, 118, 
	118, 118, 118, 118, 118, 118, 118, 118, 
	118, 118, 118, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 117, 118, 118, 
	118, 118, 116, 118, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 118, 118, 
	118, 118, 115, 118, 115, 115, 115, 115, 
	115, 115, 115, 177, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 118, 118, 
	118, 118, 118, 115, 118, 118, 118, 118, 
	118, 118, 118, 118, 118, 118, 118, 118, 
	118, 118, 118, 118, 118, 118, 118, 118, 
	118, 118, 118, 118, 118, 118, 118, 118, 
	118, 118, 118, 118, 118, 116, 118, 118, 
	118, 118, 118, 118, 118, 118, 118, 118, 
	118, 118, 118, 118, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 117, 118, 
	118, 118, 118, 116, 118, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 118, 
	118, 118, 118, 115, 118, 115, 115, 115, 
	115, 115, 115, 115, 115, 178, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 118, 
	118, 118, 118, 118, 115, 118, 118, 118, 
	118, 118, 118, 118, 118, 118, 118, 118, 
	118, 118, 118, 118, 118, 118, 118, 118, 
	118, 118, 118, 118, 118, 118, 118, 118, 
	118, 118, 118, 118, 118, 118, 116, 118, 
	118, 118, 118, 118, 118, 118, 118, 118, 
	118, 118, 118, 118, 118, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 117, 
	118, 118, 118, 118, 116, 118, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	118, 118, 118, 118, 115, 118, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 170, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	118, 118, 118, 118, 118, 115, 180, 179, 
	181, 179, 182, 179, 151, 179, 183, 179, 
	179, 179, 179, 179, 179, 179, 184, 179, 
	185, 179, 186, 179, 151, 179, 187, 179, 
	151, 179, 188, 179, 182, 179, 190, 189, 
	191, 191, 191, 191, 191, 191, 191, 191, 
	191, 193, 191, 193, 193, 193, 191, 191, 
	191, 191, 191, 191, 191, 191, 191, 191, 
	191, 191, 191, 191, 191, 191, 191, 191, 
	193, 191, 191, 191, 191, 191, 191, 191, 
	194, 191, 191, 191, 191, 191, 191, 191, 
	191, 191, 191, 191, 191, 191, 191, 191, 
	191, 191, 191, 191, 191, 191, 191, 191, 
	191, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 191, 195, 191, 191, 192, 
	191, 192, 192, 192, 196, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 191, 191, 191, 191, 191, 
	192, 197, 191, 191, 191, 191, 191, 191, 
	191, 191, 191, 191, 199, 191, 199, 199, 
	199, 191, 191, 191, 191, 191, 191, 191, 
	191, 191, 191, 191, 191, 191, 191, 191, 
	191, 191, 191, 199, 191, 191, 191, 191, 
	191, 191, 191, 200, 191, 191, 191, 191, 
	191, 191, 191, 191, 191, 191, 191, 191, 
	191, 191, 191, 191, 191, 191, 191, 191, 
	191, 191, 191, 191, 198, 198, 198, 198, 
	198, 198, 198, 198, 198, 198, 198, 198, 
	198, 198, 198, 198, 198, 198, 198, 198, 
	198, 198, 198, 198, 198, 198, 191, 201, 
	191, 191, 198, 191, 198, 198, 198, 202, 
	198, 198, 198, 198, 198, 198, 198, 198, 
	198, 198, 198, 198, 198, 198, 198, 198, 
	198, 198, 198, 198, 198, 198, 191, 191, 
	191, 191, 191, 198, 204, 203, 204, 204, 
	204, 203, 203, 203, 203, 203, 203, 203, 
	203, 203, 203, 203, 203, 203, 203, 203, 
	203, 203, 203, 204, 203, 203, 203, 203, 
	203, 203, 203, 205, 203, 203, 203, 203, 
	203, 203, 203, 203, 203, 203, 203, 203, 
	203, 203, 203, 203, 203, 203, 203, 203, 
	203, 203, 203, 203, 203, 203, 203, 203, 
	203, 203, 203, 203, 203, 203, 203, 203, 
	203, 203, 203, 203, 203, 203, 203, 203, 
	203, 203, 203, 203, 203, 203, 203, 206, 
	203, 207, 203, 208, 203, 208, 208, 208, 
	203, 203, 203, 203, 203, 203, 203, 203, 
	203, 203, 203, 203, 203, 203, 203, 203, 
	203, 203, 208, 203, 203, 203, 203, 203, 
	203, 203, 209, 203, 203, 203, 203, 203, 
	203, 203, 203, 203, 203, 203, 203, 203, 
	203, 203, 203, 203, 203, 203, 203, 203, 
	203, 203, 203, 203, 203, 203, 203, 203, 
	203, 203, 203, 203, 203, 203, 203, 203, 
	203, 203, 203, 203, 203, 203, 203, 203, 
	203, 203, 203, 203, 203, 203, 210, 203, 
	211, 212, 214, 213, 215, 213, 216, 213, 
	217, 213, 218, 213, 220, 220, 220, 220, 
	220, 220, 220, 220, 220, 220, 220, 220, 
	220, 220, 220, 220, 220, 220, 220, 220, 
	220, 220, 220, 220, 220, 220, 220, 220, 
	220, 220, 220, 220, 220, 220, 220, 220, 
	220, 220, 220, 220, 220, 220, 220, 220, 
	220, 220, 220, 220, 219, 219, 219, 219, 
	219, 219, 219, 219, 219, 219, 220, 220, 
	220, 220, 220, 220, 220, 219, 219, 219, 
	219, 219, 219, 219, 219, 219, 219, 219, 
	219, 219, 219, 219, 219, 219, 219, 219, 
	219, 219, 219, 219, 219, 219, 219, 220, 
	220, 220, 220, 220, 220, 219, 219, 219, 
	219, 219, 219, 219, 219, 219, 219, 219, 
	219, 219, 219, 219, 219, 219, 219, 219, 
	219, 219, 219, 219, 219, 219, 219, 220, 
	220, 220, 220, 220, 219, 221, 211, 222, 
	223, 222, 222, 222, 211, 211, 211, 211, 
	211, 211, 211, 211, 211, 211, 211, 211, 
	211, 211, 211, 211, 211, 211, 222, 211, 
	211, 224, 211, 211, 211, 211, 211, 211, 
	211, 211, 211, 211, 211, 211, 225, 225, 
	225, 225, 225, 225, 225, 225, 225, 225, 
	211, 211, 211, 211, 211, 211, 211, 211, 
	211, 211, 211, 211, 211, 211, 211, 211, 
	211, 211, 211, 211, 211, 211, 211, 211, 
	211, 211, 211, 211, 211, 211, 211, 211, 
	211, 211, 226, 211, 227, 228, 227, 227, 
	227, 211, 211, 211, 211, 211, 211, 211, 
	211, 211, 211, 211, 211, 211, 211, 211, 
	211, 211, 211, 227, 211, 211, 229, 211, 
	211, 211, 211, 211, 211, 211, 211, 211, 
	211, 211, 211, 230, 230, 230, 230, 230, 
	230, 230, 230, 230, 230, 211, 211, 211, 
	211, 211, 211, 211, 211, 211, 211, 211, 
	211, 211, 211, 211, 211, 211, 211, 211, 
	211, 211, 211, 211, 211, 211, 211, 211, 
	211, 211, 211, 211, 211, 211, 211, 231, 
	211, 233, 234, 233, 233, 233, 232, 232, 
	232, 232, 232, 232, 232, 232, 232, 232, 
	232, 232, 232, 232, 232, 232, 232, 232, 
	233, 232, 232, 235, 232, 232, 232, 232, 
	232, 232, 232, 232, 232, 232, 232, 232, 
	236, 236, 236, 236, 236, 236, 236, 236, 
	236, 236, 232, 232, 232, 232, 232, 232, 
	232, 232, 232, 232, 232, 232, 232, 232, 
	232, 232, 232, 232, 232, 232, 232, 232, 
	232, 232, 232, 232, 232, 232, 232, 232, 
	232, 232, 232, 232, 237, 232, 239, 240, 
	239, 239, 239, 238, 238, 238, 238, 238, 
	238, 238, 238, 238, 238, 238, 238, 238, 
	238, 238, 238, 238, 238, 239, 238, 238, 
	241, 238, 238, 238, 238, 238, 238, 238, 
	238, 238, 238, 238, 238, 242, 242, 242, 
	242, 242, 242, 242, 242, 242, 242, 238, 
	238, 238, 238, 238, 238, 238, 238, 238, 
	238, 238, 238, 238, 238, 238, 238, 238, 
	238, 238, 238, 238, 238, 238, 238, 238, 
	238, 238, 238, 238, 238, 238, 238, 238, 
	238, 243, 238, 239, 244, 239, 239, 239, 
	238, 238, 238, 238, 238, 238, 238, 238, 
	238, 238, 238, 238, 238, 238, 238, 238, 
	238, 238, 239, 238, 238, 241, 238, 238, 
	238, 238, 238, 238, 238, 238, 238, 238, 
	238, 238, 242, 242, 242, 242, 242, 242, 
	242, 242, 242, 242, 238, 238, 238, 238, 
	238, 238, 238, 238, 238, 238, 238, 238, 
	238, 238, 238, 238, 238, 238, 238, 238, 
	238, 238, 238, 238, 238, 238, 238, 238, 
	238, 238, 238, 238, 238, 238, 243, 238, 
	223, 211, 245, 245, 245, 245, 245, 245, 
	245, 245, 245, 245, 245, 245, 245, 245, 
	245, 245, 245, 245, 245, 245, 245, 245, 
	245, 245, 245, 245, 245, 245, 245, 245, 
	245, 245, 245, 247, 247, 245, 247, 245, 
	247, 247, 245, 245, 247, 247, 247, 248, 
	247, 247, 249, 249, 249, 249, 249, 249, 
	249, 249, 249, 249, 247, 247, 247, 247, 
	247, 247, 247, 246, 246, 246, 246, 246, 
	246, 246, 246, 246, 246, 246, 246, 246, 
	246, 246, 246, 246, 246, 246, 246, 246, 
	246, 246, 246, 246, 246, 245, 247, 245, 
	245, 246, 247, 246, 246, 246, 246, 246, 
	246, 246, 246, 246, 246, 246, 246, 246, 
	246, 246, 246, 246, 246, 246, 246, 246, 
	246, 246, 246, 246, 246, 245, 245, 245, 
	247, 245, 246, 245, 245, 245, 245, 245, 
	245, 245, 245, 245, 245, 245, 245, 245, 
	245, 245, 245, 245, 245, 245, 245, 245, 
	245, 245, 245, 245, 245, 245, 245, 245, 
	245, 245, 245, 245, 245, 245, 245, 245, 
	245, 245, 245, 245, 245, 245, 245, 245, 
	245, 245, 245, 247, 247, 247, 247, 247, 
	247, 247, 247, 247, 247, 245, 245, 245, 
	245, 245, 245, 245, 247, 247, 247, 247, 
	247, 247, 247, 247, 247, 247, 247, 247, 
	247, 247, 247, 247, 247, 247, 247, 247, 
	247, 247, 247, 247, 247, 247, 245, 245, 
	245, 245, 247, 245, 247, 247, 247, 247, 
	247, 247, 247, 247, 247, 247, 247, 247, 
	247, 247, 247, 247, 247, 247, 247, 247, 
	247, 247, 247, 247, 247, 247, 245, 245, 
	245, 245, 245, 247, 250, 247, 245, 245, 
	245, 245, 245, 245, 245, 245, 245, 245, 
	245, 245, 245, 245, 245, 245, 245, 245, 
	245, 245, 245, 245, 245, 245, 245, 245, 
	245, 245, 245, 245, 245, 245, 245, 245, 
	245, 245, 245, 245, 245, 245, 245, 245, 
	245, 245, 245, 245, 245, 245, 245, 245, 
	245, 245, 245, 245, 245, 245, 245, 245, 
	245, 245, 245, 245, 245, 247, 245, 250, 
	245, 245, 245, 245, 245, 245, 245, 245, 
	245, 245, 245, 245, 245, 245, 245, 245, 
	245, 245, 245, 245, 245, 245, 245, 245, 
	245, 245, 245, 245, 245, 245, 245, 245, 
	245, 245, 245, 252, 245, 245, 245, 245, 
	253, 245, 245, 245, 245, 245, 254, 245, 
	245, 245, 245, 245, 245, 245, 245, 245, 
	245, 245, 245, 245, 245, 245, 221, 245, 
	245, 245, 251, 251, 251, 251, 251, 251, 
	251, 251, 251, 251, 251, 251, 251, 251, 
	251, 251, 251, 251, 251, 251, 251, 251, 
	251, 251, 251, 251, 245, 245, 245, 245, 
	251, 255, 251, 251, 251, 251, 251, 251, 
	251, 251, 251, 251, 251, 251, 251, 251, 
	251, 251, 251, 251, 251, 251, 251, 251, 
	251, 251, 251, 251, 245, 245, 245, 254, 
	245, 251, 257, 257, 257, 257, 257, 257, 
	257, 257, 257, 257, 258, 257, 257, 257, 
	257, 257, 257, 257, 257, 257, 257, 257, 
	257, 257, 257, 257, 257, 257, 257, 257, 
	257, 257, 257, 257, 257, 257, 257, 257, 
	257, 257, 257, 257, 257, 257, 257, 257, 
	257, 257, 256, 256, 256, 256, 256, 256, 
	256, 256, 256, 256, 257, 257, 257, 257, 
	257, 257, 257, 256, 256, 256, 256, 256, 
	256, 256, 256, 256, 256, 256, 256, 256, 
	256, 256, 256, 256, 256, 256, 256, 256, 
	256, 256, 256, 256, 256, 257, 257, 257, 
	257, 256, 257, 256, 256, 256, 256, 256, 
	256, 256, 256, 256, 256, 256, 256, 256, 
	256, 256, 256, 256, 256, 256, 256, 256, 
	256, 256, 256, 256, 256, 257, 257, 257, 
	257, 257, 256, 260, 259, 263, 262, 258, 
	257, 263, 264, 245, 245, 245, 245, 245, 
	245, 245, 245, 245, 245, 245, 245, 245, 
	245, 245, 245, 245, 245, 245, 245, 245, 
	245, 245, 245, 245, 245, 245, 245, 245, 
	245, 245, 245, 245, 245, 252, 245, 245, 
	245, 245, 253, 245, 245, 245, 245, 245, 
	245, 245, 245, 245, 245, 245, 245, 245, 
	245, 245, 245, 245, 245, 245, 245, 245, 
	245, 245, 245, 245, 251, 251, 251, 251, 
	251, 251, 251, 251, 251, 251, 251, 251, 
	251, 251, 251, 251, 251, 251, 251, 251, 
	251, 251, 251, 251, 251, 251, 245, 245, 
	245, 245, 251, 255, 251, 251, 251, 251, 
	251, 251, 251, 251, 251, 251, 251, 251, 
	251, 251, 251, 251, 251, 251, 251, 251, 
	251, 251, 251, 251, 251, 251, 245, 245, 
	245, 245, 245, 251, 266, 265, 265, 265, 
	265, 265, 265, 265, 265, 265, 265, 265, 
	265, 265, 265, 265, 265, 265, 265, 265, 
	265, 265, 265, 265, 265, 265, 265, 265, 
	265, 265, 265, 265, 265, 265, 265, 265, 
	265, 265, 265, 265, 265, 265, 265, 265, 
	265, 265, 265, 265, 265, 265, 265, 265, 
	265, 265, 265, 265, 265, 265, 265, 265, 
	265, 265, 265, 265, 265, 265, 265, 265, 
	265, 265, 265, 265, 265, 265, 265, 265, 
	265, 265, 265, 265, 265, 265, 265, 265, 
	265, 265, 263, 265, 263, 266, 267, 268, 
	268, 268, 267, 268, 268, 268, 268, 268, 
	268, 268, 268, 268, 268, 268, 268, 268, 
	268, 268, 268, 268, 268, 268, 268, 268, 
	267, 268, 268, 268, 268, 268, 268, 268, 
	268, 268, 268, 268, 268, 268, 268, 268, 
	268, 268, 268, 269, 268, 267, 270, 270, 
	270, 267, 270, 270, 270, 270, 270, 271, 
	270, 270, 270, 270, 270, 270, 270, 270, 
	270, 270, 270, 270, 270, 270, 270, 267, 
	270, 270, 270, 270, 270, 270, 270, 270, 
	270, 270, 270, 270, 270, 270, 270, 270, 
	270, 270, 270, 270, 270, 270, 270, 270, 
	270, 270, 270, 270, 270, 270, 270, 270, 
	270, 270, 270, 270, 270, 270, 270, 270, 
	270, 270, 270, 270, 270, 270, 270, 270, 
	270, 270, 272, 270, 270, 270, 270, 270, 
	270, 270, 270, 270, 270, 270, 270, 270, 
	270, 270, 270, 270, 270, 270, 270, 270, 
	270, 270, 270, 270, 270, 270, 270, 270, 
	270, 270, 270, 270, 270, 270, 270, 270, 
	270, 270, 270, 270, 270, 273, 270, 267, 
	270, 270, 270, 267, 270, 270, 270, 270, 
	270, 270, 270, 270, 270, 270, 270, 270, 
	270, 270, 270, 270, 270, 270, 270, 270, 
	270, 267, 270, 270, 270, 270, 270, 270, 
	270, 270, 270, 270, 270, 270, 270, 270, 
	270, 270, 270, 270, 270, 270, 270, 270, 
	270, 270, 270, 270, 270, 270, 270, 270, 
	270, 270, 270, 270, 270, 270, 270, 270, 
	270, 270, 270, 270, 270, 270, 270, 270, 
	270, 270, 270, 270, 274, 270, 270, 270, 
	270, 270, 270, 270, 270, 270, 270, 270, 
	270, 270, 270, 270, 270, 270, 270, 270, 
	270, 270, 270, 270, 270, 270, 270, 270, 
	270, 270, 270, 270, 270, 270, 270, 270, 
	270, 270, 270, 270, 270, 270, 270, 273, 
	270, 267, 275, 275, 275, 267, 275, 275, 
	275, 275, 275, 275, 275, 275, 275, 275, 
	275, 275, 275, 275, 275, 275, 275, 275, 
	275, 275, 275, 267, 275, 275, 275, 275, 
	275, 275, 275, 275, 275, 275, 275, 275, 
	275, 275, 275, 275, 275, 275, 275, 275, 
	275, 275, 275, 275, 275, 275, 275, 275, 
	275, 275, 275, 275, 275, 275, 275, 275, 
	276, 275, 275, 275, 275, 275, 275, 275, 
	275, 275, 275, 275, 275, 275, 275, 275, 
	275, 275, 275, 275, 275, 275, 275, 275, 
	275, 275, 275, 275, 275, 277, 275, 267, 
	278, 278, 278, 267, 278, 278, 278, 278, 
	278, 279, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 278, 278, 
	278, 267, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 278, 280, 
	278, 267, 278, 278, 278, 267, 278, 278, 
	278, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 267, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 278, 278, 
	278, 280, 278, 267, 268, 268, 268, 267, 
	268, 268, 268, 268, 268, 268, 268, 268, 
	268, 268, 268, 268, 268, 268, 268, 268, 
	268, 268, 268, 268, 268, 267, 268, 268, 
	268, 268, 268, 268, 268, 268, 268, 268, 
	268, 268, 268, 268, 268, 268, 268, 268, 
	281, 268, 267, 282, 282, 282, 267, 282, 
	282, 282, 282, 282, 283, 282, 282, 282, 
	282, 282, 282, 282, 282, 282, 282, 282, 
	282, 282, 282, 282, 267, 282, 282, 282, 
	282, 282, 282, 282, 282, 282, 282, 282, 
	282, 282, 282, 282, 282, 282, 282, 282, 
	282, 282, 282, 282, 282, 282, 282, 282, 
	282, 282, 282, 282, 282, 282, 282, 282, 
	282, 282, 282, 282, 282, 284, 282, 282, 
	282, 282, 282, 282, 282, 282, 282, 282, 
	282, 282, 282, 282, 282, 282, 282, 282, 
	282, 282, 282, 282, 282, 282, 285, 282, 
	282, 282, 282, 282, 282, 286, 282, 282, 
	282, 282, 282, 282, 282, 282, 282, 282, 
	282, 282, 282, 282, 282, 282, 282, 282, 
	282, 282, 287, 282, 267, 282, 282, 282, 
	267, 282, 282, 282, 282, 282, 282, 282, 
	282, 282, 282, 282, 282, 282, 282, 282, 
	282, 282, 282, 282, 282, 282, 267, 282, 
	282, 282, 282, 282, 282, 282, 282, 282, 
	282, 282, 282, 282, 282, 282, 282, 282, 
	282, 282, 282, 282, 282, 282, 282, 282, 
	282, 282, 282, 282, 282, 282, 282, 282, 
	282, 282, 282, 282, 282, 282, 282, 282, 
	282, 282, 282, 282, 282, 282, 282, 282, 
	282, 282, 282, 282, 282, 282, 282, 282, 
	282, 282, 282, 282, 282, 282, 282, 282, 
	282, 282, 282, 282, 282, 282, 282, 282, 
	282, 282, 282, 282, 282, 282, 282, 282, 
	282, 282, 282, 282, 282, 282, 282, 282, 
	282, 282, 282, 282, 287, 282, 288, 267, 
	267, 267, 267, 267, 267, 267, 267, 267, 
	267, 267, 267, 267, 267, 267, 267, 267, 
	267, 267, 267, 267, 267, 267, 267, 267, 
	267, 267, 267, 267, 267, 267, 289, 267, 
	289, 267, 267, 290, 290, 290, 267, 290, 
	290, 290, 290, 290, 290, 290, 290, 290, 
	290, 290, 290, 290, 290, 290, 290, 290, 
	290, 290, 290, 290, 267, 290, 290, 290, 
	290, 290, 290, 290, 290, 290, 290, 290, 
	290, 290, 290, 290, 290, 290, 290, 290, 
	290, 290, 290, 290, 290, 290, 290, 290, 
	290, 290, 290, 290, 290, 290, 290, 290, 
	290, 291, 290, 290, 290, 290, 290, 290, 
	290, 290, 290, 290, 290, 290, 290, 290, 
	290, 290, 290, 290, 290, 290, 290, 290, 
	290, 290, 290, 290, 290, 290, 292, 290, 
	267, 270, 270, 270, 267, 270, 270, 270, 
	270, 270, 271, 270, 270, 270, 270, 270, 
	270, 270, 270, 270, 270, 270, 270, 270, 
	270, 270, 267, 270, 270, 270, 270, 270, 
	270, 270, 270, 270, 270, 270, 270, 270, 
	270, 270, 270, 270, 270, 270, 270, 270, 
	270, 270, 270, 270, 270, 270, 270, 270, 
	270, 270, 270, 270, 270, 270, 270, 270, 
	270, 270, 270, 270, 270, 270, 270, 270, 
	270, 270, 270, 270, 270, 274, 270, 270, 
	270, 270, 270, 270, 270, 270, 270, 270, 
	270, 270, 270, 270, 270, 270, 270, 270, 
	270, 270, 270, 270, 270, 270, 270, 270, 
	270, 270, 270, 270, 270, 270, 270, 270, 
	270, 270, 270, 270, 270, 270, 270, 270, 
	273, 270, 267, 293, 293, 293, 267, 293, 
	293, 293, 293, 293, 293, 293, 293, 293, 
	293, 293, 293, 293, 293, 293, 293, 293, 
	293, 293, 293, 293, 267, 293, 293, 293, 
	293, 293, 293, 293, 293, 293, 293, 293, 
	293, 293, 293, 293, 293, 293, 293, 293, 
	293, 293, 294, 294, 294, 294, 294, 294, 
	294, 294, 294, 294, 293, 293, 293, 293, 
	293, 293, 293, 294, 294, 294, 294, 294, 
	294, 293, 293, 293, 293, 293, 293, 293, 
	293, 293, 293, 293, 293, 293, 293, 293, 
	293, 293, 293, 293, 293, 293, 293, 293, 
	293, 293, 293, 294, 294, 294, 294, 294, 
	294, 293, 211, 211, 211, 211, 211, 211, 
	211, 211, 211, 211, 211, 211, 211, 211, 
	211, 211, 211, 211, 211, 211, 211, 211, 
	211, 211, 211, 211, 211, 211, 211, 211, 
	211, 211, 211, 296, 211, 211, 211, 211, 
	211, 211, 211, 211, 211, 211, 211, 211, 
	211, 211, 295, 295, 295, 295, 295, 295, 
	295, 295, 295, 295, 297, 211, 211, 298, 
	211, 296, 211, 295, 295, 295, 295, 295, 
	295, 295, 295, 295, 295, 295, 295, 295, 
	295, 295, 295, 295, 295, 295, 295, 295, 
	295, 295, 295, 295, 295, 211, 211, 211, 
	211, 295, 211, 295, 295, 295, 295, 295, 
	295, 295, 295, 295, 295, 295, 295, 295, 
	295, 295, 295, 295, 295, 295, 295, 295, 
	295, 295, 295, 295, 295, 211, 211, 211, 
	211, 211, 295, 245, 245, 245, 245, 245, 
	245, 245, 245, 245, 245, 245, 245, 245, 
	245, 245, 245, 245, 245, 245, 245, 245, 
	245, 245, 245, 245, 245, 245, 245, 245, 
	245, 245, 245, 245, 296, 245, 245, 245, 
	245, 245, 245, 245, 245, 245, 245, 245, 
	245, 245, 245, 295, 295, 295, 295, 295, 
	295, 295, 295, 295, 295, 297, 245, 245, 
	298, 245, 296, 245, 295, 295, 295, 295, 
	295, 295, 299, 295, 295, 295, 295, 295, 
	295, 295, 295, 295, 295, 295, 295, 295, 
	295, 295, 295, 295, 295, 295, 245, 245, 
	245, 245, 295, 245, 295, 295, 295, 295, 
	295, 295, 295, 295, 295, 295, 295, 295, 
	295, 295, 295, 295, 295, 295, 295, 295, 
	295, 295, 295, 295, 295, 295, 245, 245, 
	245, 245, 245, 295, 245, 245, 245, 245, 
	245, 245, 245, 245, 245, 245, 245, 245, 
	245, 245, 245, 245, 245, 245, 245, 245, 
	245, 245, 245, 245, 245, 245, 245, 245, 
	245, 245, 245, 245, 245, 296, 245, 245, 
	245, 245, 245, 245, 245, 245, 245, 245, 
	245, 245, 245, 245, 295, 295, 295, 295, 
	295, 295, 295, 295, 295, 295, 297, 245, 
	245, 298, 245, 296, 245, 295, 295, 295, 
	295, 295, 295, 295, 295, 300, 295, 295, 
	295, 295, 295, 295, 295, 295, 295, 295, 
	295, 295, 295, 295, 295, 295, 295, 245, 
	245, 245, 245, 295, 245, 295, 295, 295, 
	295, 295, 295, 295, 295, 295, 295, 295, 
	295, 295, 295, 295, 295, 295, 295, 295, 
	295, 295, 295, 295, 295, 295, 295, 245, 
	245, 245, 245, 245, 295, 245, 245, 245, 
	245, 245, 245, 245, 245, 245, 245, 245, 
	245, 245, 245, 245, 245, 245, 245, 245, 
	245, 245, 245, 245, 245, 245, 245, 245, 
	245, 245, 245, 245, 245, 245, 296, 245, 
	245, 245, 245, 245, 245, 245, 245, 245, 
	245, 245, 245, 245, 245, 295, 295, 295, 
	295, 295, 295, 295, 295, 295, 295, 297, 
	245, 245, 298, 245, 296, 245, 295, 295, 
	295, 295, 295, 295, 295, 295, 295, 295, 
	295, 295, 295, 301, 295, 295, 295, 295, 
	295, 295, 295, 295, 295, 295, 295, 295, 
	245, 245, 245, 245, 295, 245, 295, 295, 
	295, 295, 295, 295, 295, 295, 295, 295, 
	295, 295, 295, 295, 295, 295, 295, 295, 
	295, 295, 295, 295, 295, 295, 295, 295, 
	245, 245, 245, 245, 245, 295, 245, 245, 
	245, 245, 245, 245, 245, 245, 245, 245, 
	245, 245, 245, 245, 245, 245, 245, 245, 
	245, 245, 245, 245, 245, 245, 245, 245, 
	245, 245, 245, 245, 245, 245, 245, 296, 
	245, 245, 245, 245, 245, 245, 245, 245, 
	245, 245, 245, 245, 245, 245, 295, 295, 
	295, 295, 295, 295, 295, 295, 295, 295, 
	297, 245, 245, 298, 245, 296, 245, 295, 
	295, 295, 301, 295, 295, 295, 295, 295, 
	295, 295, 295, 295, 295, 295, 295, 295, 
	295, 295, 295, 295, 295, 295, 295, 295, 
	295, 245, 245, 245, 245, 295, 245, 295, 
	295, 295, 295, 295, 295, 295, 295, 295, 
	295, 295, 295, 295, 295, 295, 295, 295, 
	295, 295, 295, 295, 295, 295, 295, 295, 
	295, 245, 245, 245, 245, 245, 295, 302, 
	302, 302, 302, 302, 302, 302, 302, 302, 
	302, 302, 302, 302, 302, 302, 302, 302, 
	302, 302, 302, 302, 302, 302, 302, 302, 
	302, 302, 302, 302, 302, 302, 302, 302, 
	304, 302, 302, 302, 302, 302, 302, 302, 
	302, 302, 302, 302, 302, 302, 302, 303, 
	303, 303, 303, 303, 303, 303, 303, 303, 
	303, 305, 302, 302, 302, 302, 304, 302, 
	303, 303, 303, 303, 303, 303, 303, 303, 
	303, 303, 303, 303, 303, 303, 303, 303, 
	303, 303, 303, 303, 303, 303, 303, 303, 
	303, 303, 302, 302, 302, 302, 303, 302, 
	303, 303, 303, 303, 303, 303, 303, 303, 
	303, 303, 303, 303, 303, 303, 303, 303, 
	303, 303, 303, 303, 303, 303, 303, 303, 
	303, 303, 302, 302, 302, 302, 302, 303, 
	305, 302, 302, 306, 307, 307, 307, 307, 
	307, 307, 307, 307, 307, 307, 307, 307, 
	307, 307, 307, 307, 307, 307, 307, 307, 
	307, 307, 307, 307, 307, 307, 307, 307, 
	307, 307, 307, 307, 307, 307, 307, 307, 
	307, 307, 307, 307, 307, 307, 307, 307, 
	307, 307, 307, 307, 308, 308, 308, 308, 
	308, 308, 308, 308, 308, 308, 307, 307, 
	307, 307, 307, 307, 307, 308, 308, 308, 
	308, 308, 308, 308, 308, 308, 308, 308, 
	308, 308, 308, 308, 308, 308, 308, 308, 
	308, 308, 308, 308, 308, 308, 308, 307, 
	307, 307, 307, 308, 307, 308, 308, 308, 
	308, 308, 308, 308, 308, 308, 308, 308, 
	308, 308, 308, 308, 308, 308, 308, 308, 
	308, 308, 308, 308, 308, 308, 308, 307, 
	307, 307, 307, 307, 308, 310, 309, 310, 
	309, 309, 311, 311, 311, 311, 311, 311, 
	311, 311, 311, 311, 309, 311, 311, 311, 
	311, 311, 311, 311, 311, 311, 311, 309, 
	312, 312, 312, 312, 312, 312, 312, 312, 
	312, 312, 309, 314, 314, 314, 314, 314, 
	314, 314, 314, 314, 314, 313, 315, 315, 
	315, 315, 315, 315, 315, 315, 315, 315, 
	313, 317, 316, 318, 316, 319, 316, 320, 
	316, 322, 321, 323, 321, 324, 321, 307, 
	307, 307, 307, 307, 307, 307, 307, 307, 
	307, 307, 307, 307, 307, 307, 307, 307, 
	307, 307, 307, 307, 307, 307, 307, 307, 
	307, 307, 307, 307, 307, 307, 307, 307, 
	307, 307, 307, 307, 307, 307, 307, 307, 
	307, 307, 307, 307, 307, 307, 307, 325, 
	325, 325, 325, 325, 325, 325, 325, 325, 
	325, 307, 307, 307, 307, 307, 307, 307, 
	325, 325, 325, 325, 325, 325, 325, 325, 
	325, 325, 325, 325, 325, 325, 325, 325, 
	325, 325, 325, 325, 325, 325, 325, 325, 
	325, 325, 307, 307, 307, 307, 325, 307, 
	325, 325, 325, 325, 325, 325, 325, 325, 
	325, 325, 325, 325, 325, 325, 325, 325, 
	325, 325, 325, 325, 325, 325, 325, 325, 
	325, 325, 307, 307, 307, 307, 307, 325, 
	326, 313, 327, 328, 327, 327, 327, 313, 
	313, 313, 313, 313, 313, 313, 313, 313, 
	313, 313, 313, 313, 313, 313, 313, 313, 
	313, 327, 313, 313, 329, 313, 313, 313, 
	313, 313, 313, 313, 313, 313, 313, 313, 
	313, 313, 313, 313, 313, 313, 313, 313, 
	313, 313, 313, 313, 313, 330, 313, 313, 
	313, 313, 313, 313, 313, 313, 313, 313, 
	313, 313, 313, 313, 313, 313, 313, 313, 
	313, 313, 313, 313, 313, 313, 313, 313, 
	313, 313, 313, 313, 313, 331, 313, 332, 
	333, 332, 332, 332, 313, 313, 313, 313, 
	313, 313, 313, 313, 313, 313, 313, 313, 
	313, 313, 313, 313, 313, 313, 332, 313, 
	313, 334, 313, 313, 313, 313, 313, 313, 
	313, 313, 313, 313, 313, 313, 313, 313, 
	313, 313, 313, 313, 313, 313, 313, 313, 
	313, 313, 335, 313, 313, 313, 313, 313, 
	313, 313, 313, 313, 313, 313, 313, 313, 
	313, 313, 313, 313, 313, 313, 313, 313, 
	313, 313, 313, 313, 313, 313, 313, 313, 
	313, 313, 336, 313, 338, 339, 338, 338, 
	338, 337, 337, 337, 337, 337, 337, 337, 
	337, 337, 337, 337, 337, 337, 337, 337, 
	337, 337, 337, 338, 337, 337, 340, 337, 
	337, 337, 337, 337, 337, 337, 337, 337, 
	337, 337, 337, 337, 337, 337, 337, 337, 
	337, 337, 337, 337, 337, 337, 337, 341, 
	337, 337, 337, 337, 337, 337, 337, 337, 
	337, 337, 337, 337, 337, 337, 337, 337, 
	337, 337, 337, 337, 337, 337, 337, 337, 
	337, 337, 337, 337, 337, 337, 337, 342, 
	337, 344, 345, 344, 344, 344, 343, 343, 
	343, 343, 343, 343, 343, 343, 343, 343, 
	343, 343, 343, 343, 343, 343, 343, 343, 
	344, 343, 343, 346, 343, 343, 343, 343, 
	343, 343, 343, 343, 343, 343, 343, 343, 
	343, 343, 343, 343, 343, 343, 343, 343, 
	343, 343, 343, 343, 347, 343, 343, 343, 
	343, 343, 343, 343, 343, 343, 343, 343, 
	343, 343, 343, 343, 343, 343, 343, 343, 
	343, 343, 343, 343, 343, 343, 343, 343, 
	343, 343, 343, 343, 348, 343, 344, 345, 
	344, 344, 344, 343, 343, 343, 343, 343, 
	343, 343, 343, 343, 343, 343, 343, 343, 
	343, 343, 343, 343, 343, 344, 343, 343, 
	346, 343, 343, 343, 343, 343, 343, 343, 
	343, 343, 343, 343, 343, 343, 343, 343, 
	343, 343, 343, 343, 343, 343, 343, 343, 
	343, 349, 343, 343, 343, 343, 343, 343, 
	343, 343, 343, 343, 343, 343, 343, 343, 
	343, 343, 343, 343, 343, 343, 343, 343, 
	343, 343, 343, 343, 343, 343, 343, 343, 
	343, 348, 343, 344, 350, 344, 344, 344, 
	343, 343, 343, 343, 343, 343, 343, 343, 
	343, 343, 343, 343, 343, 343, 343, 343, 
	343, 343, 344, 343, 343, 346, 343, 343, 
	343, 343, 343, 343, 343, 343, 343, 343, 
	343, 343, 343, 343, 343, 343, 343, 343, 
	343, 343, 343, 343, 343, 343, 347, 343, 
	343, 343, 343, 343, 343, 343, 343, 343, 
	343, 343, 343, 343, 343, 343, 343, 343, 
	343, 343, 343, 343, 343, 343, 343, 343, 
	343, 343, 343, 343, 343, 343, 348, 343, 
	351, 313, 328, 313, 353, 354, 353, 353, 
	353, 352, 352, 352, 352, 352, 352, 352, 
	352, 352, 352, 352, 352, 352, 352, 352, 
	352, 352, 352, 353, 352, 352, 355, 352, 
	352, 356, 352, 352, 352, 352, 352, 352, 
	352, 357, 352, 352, 352, 352, 352, 352, 
	352, 352, 352, 352, 352, 352, 352, 352, 
	352, 352, 352, 352, 352, 352, 352, 352, 
	352, 352, 352, 352, 352, 352, 352, 352, 
	352, 352, 352, 352, 352, 352, 352, 352, 
	352, 352, 352, 352, 352, 352, 352, 358, 
	352, 360, 354, 360, 360, 360, 359, 359, 
	359, 359, 359, 359, 359, 359, 359, 359, 
	359, 359, 359, 359, 359, 359, 359, 359, 
	360, 359, 359, 355, 359, 359, 359, 359, 
	359, 359, 359, 359, 359, 359, 359, 359, 
	359, 359, 359, 359, 359, 359, 359, 359, 
	359, 359, 359, 359, 359, 359, 359, 359, 
	359, 359, 359, 359, 359, 359, 359, 359, 
	359, 359, 359, 359, 359, 359, 359, 359, 
	359, 359, 359, 359, 359, 359, 359, 359, 
	359, 359, 359, 359, 358, 359, 363, 362, 
	365, 364, 366, 361, 367, 361, 368, 352, 
	370, 369, 369, 369, 370, 369, 369, 369, 
	369, 371, 372, 371, 371, 371, 369, 369, 
	369, 369, 369, 369, 369, 369, 369, 369, 
	369, 369, 370, 369, 369, 369, 369, 369, 
	371, 369, 369, 373, 369, 369, 369, 369, 
	369, 369, 369, 369, 369, 369, 369, 369, 
	369, 369, 369, 369, 369, 369, 369, 369, 
	369, 369, 369, 369, 369, 374, 369, 369, 
	369, 369, 369, 369, 369, 369, 369, 369, 
	369, 369, 369, 369, 369, 369, 369, 369, 
	369, 369, 369, 369, 369, 369, 369, 369, 
	369, 369, 369, 369, 375, 369, 369, 376, 
	369, 371, 377, 371, 371, 371, 377, 377, 
	377, 377, 377, 377, 377, 377, 377, 377, 
	377, 377, 377, 377, 377, 377, 377, 377, 
	371, 377, 378, 379, 380, 381, 382, 384, 
	383, 386, 387, 386, 386, 386, 385, 385, 
	385, 385, 385, 385, 385, 385, 385, 385, 
	385, 385, 385, 385, 385, 385, 385, 385, 
	386, 385, 372, 383, 388, 383, 390, 389, 
	389, 389, 390, 389, 389, 389, 389, 391, 
	392, 391, 391, 391, 389, 389, 389, 389, 
	389, 389, 389, 389, 389, 389, 389, 389, 
	390, 389, 389, 389, 389, 389, 391, 389, 
	389, 393, 389, 389, 389, 389, 389, 389, 
	389, 389, 389, 389, 389, 389, 389, 389, 
	389, 389, 389, 389, 389, 389, 389, 389, 
	389, 389, 389, 389, 389, 389, 389, 389, 
	389, 389, 389, 389, 389, 389, 389, 389, 
	389, 389, 389, 389, 389, 389, 389, 389, 
	389, 389, 389, 389, 389, 389, 389, 389, 
	389, 389, 394, 389, 391, 395, 391, 391, 
	391, 395, 395, 395, 395, 395, 395, 395, 
	395, 395, 395, 395, 395, 395, 395, 395, 
	395, 395, 395, 391, 395, 397, 396, 396, 
	396, 396, 396, 396, 396, 396, 396, 396, 
	396, 396, 396, 396, 396, 396, 396, 396, 
	396, 396, 396, 396, 396, 396, 396, 396, 
	396, 398, 396, 396, 396, 396, 396, 396, 
	396, 396, 396, 396, 396, 396, 396, 396, 
	396, 396, 396, 396, 396, 396, 396, 396, 
	396, 396, 396, 396, 396, 396, 396, 396, 
	396, 396, 396, 396, 396, 396, 396, 396, 
	396, 396, 396, 396, 396, 396, 396, 396, 
	396, 396, 396, 396, 396, 396, 396, 396, 
	396, 396, 396, 396, 399, 396, 400, 400, 
	400, 400, 400, 400, 400, 400, 400, 400, 
	400, 400, 400, 400, 400, 400, 400, 400, 
	400, 400, 400, 400, 400, 400, 400, 400, 
	400, 400, 400, 400, 400, 400, 400, 400, 
	400, 400, 400, 400, 400, 400, 400, 400, 
	400, 400, 400, 400, 400, 400, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	400, 400, 400, 400, 400, 400, 400, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 400, 400, 400, 400, 13, 400, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 400, 400, 400, 400, 400, 13, 16, 
	16, 16, 16, 16, 16, 16, 16, 16, 
	16, 400, 401, 401, 401, 401, 401, 401, 
	401, 401, 401, 401, 401, 401, 401, 401, 
	401, 401, 401, 401, 401, 401, 401, 401, 
	401, 401, 401, 401, 401, 401, 401, 401, 
	401, 401, 401, 401, 401, 401, 401, 401, 
	401, 401, 401, 401, 401, 401, 401, 401, 
	401, 401, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 401, 401, 401, 401, 
	401, 401, 401, 17, 17, 17, 17, 17, 
	17, 17, 17, 17, 17, 17, 17, 17, 
	17, 17, 17, 17, 17, 17, 17, 17, 
	17, 17, 17, 17, 17, 401, 401, 401, 
	401, 17, 401, 17, 17, 17, 17, 17, 
	17, 17, 17, 17, 17, 17, 17, 17, 
	17, 17, 17, 17, 17, 17, 17, 17, 
	17, 17, 17, 17, 17, 401, 401, 401, 
	401, 401, 17, 404, 403, 403, 403, 404, 
	403, 403, 403, 403, 403, 403, 403, 403, 
	403, 403, 403, 403, 403, 403, 403, 403, 
	403, 403, 403, 403, 403, 404, 403, 403, 
	403, 403, 403, 403, 403, 403, 403, 403, 
	403, 403, 403, 403, 403, 403, 403, 403, 
	403, 403, 403, 405, 405, 405, 405, 405, 
	405, 405, 405, 403, 403, 403, 403, 403, 
	403, 403, 403, 403, 403, 403, 406, 403, 
	403, 403, 403, 403, 403, 403, 403, 403, 
	407, 403, 403, 403, 403, 403, 403, 403, 
	403, 403, 403, 403, 403, 403, 403, 403, 
	403, 403, 403, 403, 403, 403, 408, 403, 
	403, 403, 403, 403, 403, 403, 403, 403, 
	403, 403, 403, 403, 403, 403, 403, 403, 
	409, 403, 403, 410, 403, 411, 412, 414, 
	414, 414, 414, 414, 414, 414, 414, 413, 
	415, 415, 415, 415, 415, 415, 415, 415, 
	413, 413, 416, 416, 42, 42, 42, 416, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 416, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 43, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 417, 
	42, 418, 419, 420, 420, 42, 42, 42, 
	420, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 42, 420, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 42, 43, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	421, 42, 41, 420, 422, 423, 424, 424, 
	27, 27, 27, 424, 27, 27, 27, 27, 
	27, 27, 27, 27, 27, 27, 27, 27, 
	27, 27, 27, 27, 27, 27, 27, 27, 
	27, 424, 27, 27, 27, 27, 27, 27, 
	27, 27, 27, 27, 27, 27, 27, 27, 
	27, 27, 27, 27, 27, 27, 27, 27, 
	27, 27, 27, 27, 27, 27, 27, 27, 
	27, 27, 27, 27, 27, 27, 28, 27, 
	27, 27, 27, 27, 27, 27, 27, 27, 
	27, 27, 27, 27, 27, 27, 27, 27, 
	27, 27, 27, 27, 27, 27, 27, 27, 
	27, 27, 27, 425, 27, 426, 426, 426, 
	426, 426, 426, 426, 426, 426, 426, 424, 
	424, 424, 424, 424, 424, 424, 426, 426, 
	426, 426, 426, 426, 424, 424, 424, 424, 
	424, 424, 424, 424, 424, 424, 424, 424, 
	424, 424, 424, 424, 424, 424, 424, 424, 
	424, 424, 424, 424, 424, 424, 426, 426, 
	426, 426, 426, 426, 424, 428, 428, 428, 
	428, 428, 428, 428, 428, 428, 428, 427, 
	427, 427, 427, 427, 427, 427, 428, 428, 
	428, 428, 428, 428, 427, 427, 427, 427, 
	427, 427, 427, 427, 427, 427, 427, 427, 
	427, 427, 427, 427, 427, 427, 427, 427, 
	427, 427, 427, 427, 427, 427, 428, 428, 
	428, 428, 428, 428, 427, 427, 429, 429, 
	429, 429, 429, 429, 429, 429, 429, 429, 
	420, 420, 420, 420, 420, 420, 420, 429, 
	429, 429, 429, 429, 429, 420, 420, 420, 
	420, 420, 420, 420, 420, 420, 420, 420, 
	420, 420, 420, 420, 420, 420, 420, 420, 
	420, 420, 420, 420, 420, 420, 420, 429, 
	429, 429, 429, 429, 429, 420, 431, 431, 
	431, 431, 431, 431, 431, 431, 431, 431, 
	430, 430, 430, 430, 430, 430, 430, 431, 
	431, 431, 431, 431, 431, 430, 430, 430, 
	430, 430, 430, 430, 430, 430, 430, 430, 
	430, 430, 430, 430, 430, 430, 430, 430, 
	430, 430, 430, 430, 430, 430, 430, 431, 
	431, 431, 431, 431, 431, 430, 430, 420, 
	20, 20, 20, 420, 20, 20, 20, 20, 
	20, 20, 20, 20, 20, 20, 20, 20, 
	20, 20, 20, 20, 20, 20, 20, 20, 
	20, 420, 20, 20, 20, 20, 20, 20, 
	20, 20, 20, 20, 20, 20, 20, 20, 
	20, 20, 20, 20, 432, 20, 416, 27, 
	27, 27, 416, 27, 27, 27, 27, 27, 
	27, 27, 27, 27, 27, 27, 27, 27, 
	27, 27, 27, 27, 27, 27, 27, 27, 
	416, 27, 27, 27, 27, 27, 27, 27, 
	27, 27, 27, 27, 27, 27, 27, 27, 
	27, 27, 27, 27, 27, 27, 27, 27, 
	27, 27, 27, 27, 27, 27, 27, 27, 
	27, 27, 27, 27, 27, 28, 27, 27, 
	27, 27, 27, 27, 27, 27, 27, 27, 
	27, 27, 27, 27, 27, 27, 27, 27, 
	27, 27, 27, 27, 27, 27, 27, 27, 
	27, 27, 29, 27, 416, 433, 433, 433, 
	416, 433, 433, 433, 433, 433, 433, 433, 
	433, 433, 433, 433, 433, 433, 433, 433, 
	433, 433, 433, 433, 433, 433, 416, 433, 
	433, 433, 433, 433, 433, 433, 433, 433, 
	433, 433, 433, 433, 433, 433, 433, 433, 
	433, 433, 433, 433, 433, 433, 433, 433, 
	433, 433, 433, 433, 433, 433, 433, 433, 
	433, 433, 433, 433, 433, 433, 433, 433, 
	433, 433, 433, 433, 433, 433, 433, 433, 
	433, 433, 433, 433, 433, 433, 433, 433, 
	433, 433, 433, 433, 433, 433, 433, 433, 
	434, 433, 435, 436, 436, 433, 433, 433, 
	436, 433, 433, 433, 433, 433, 433, 433, 
	433, 433, 433, 433, 433, 433, 433, 433, 
	433, 433, 433, 433, 433, 433, 436, 433, 
	433, 433, 433, 433, 433, 433, 433, 433, 
	433, 433, 433, 433, 433, 433, 433, 433, 
	433, 433, 433, 433, 433, 433, 433, 433, 
	433, 433, 433, 433, 433, 433, 433, 433, 
	433, 433, 433, 433, 433, 433, 433, 433, 
	433, 433, 433, 433, 433, 433, 433, 433, 
	433, 433, 433, 433, 433, 433, 433, 433, 
	433, 433, 433, 433, 433, 433, 433, 433, 
	437, 433, 438, 438, 438, 438, 438, 438, 
	438, 438, 438, 438, 436, 436, 436, 436, 
	436, 436, 436, 438, 438, 438, 438, 438, 
	438, 436, 436, 436, 436, 436, 436, 436, 
	436, 436, 436, 436, 436, 436, 436, 436, 
	436, 436, 436, 436, 436, 436, 436, 436, 
	436, 436, 436, 438, 438, 438, 438, 438, 
	438, 436, 440, 440, 440, 440, 440, 440, 
	440, 440, 440, 440, 439, 439, 439, 439, 
	439, 439, 439, 440, 440, 440, 440, 440, 
	440, 439, 439, 439, 439, 439, 439, 439, 
	439, 439, 439, 439, 439, 439, 439, 439, 
	439, 439, 439, 439, 439, 439, 439, 439, 
	439, 439, 439, 440, 440, 440, 440, 440, 
	440, 439, 439, 436, 20, 20, 20, 436, 
	20, 20, 20, 20, 20, 20, 20, 20, 
	20, 20, 20, 20, 20, 20, 20, 20, 
	20, 20, 20, 20, 20, 436, 20, 20, 
	20, 20, 20, 20, 20, 20, 20, 20, 
	20, 20, 20, 20, 20, 20, 20, 20, 
	432, 20, 441, 436, 436, 27, 27, 27, 
	436, 27, 27, 27, 27, 27, 27, 27, 
	27, 27, 27, 27, 27, 27, 27, 27, 
	27, 27, 27, 27, 27, 27, 436, 27, 
	27, 27, 27, 27, 27, 27, 27, 27, 
	27, 27, 27, 27, 27, 27, 27, 27, 
	27, 27, 27, 27, 27, 27, 27, 27, 
	27, 27, 27, 27, 27, 27, 27, 27, 
	27, 27, 27, 28, 27, 27, 27, 27, 
	27, 27, 27, 27, 27, 27, 27, 27, 
	27, 27, 27, 27, 27, 27, 27, 27, 
	27, 27, 27, 27, 27, 27, 27, 27, 
	29, 27, 443, 443, 443, 443, 443, 443, 
	443, 443, 443, 443, 442, 442, 442, 442, 
	442, 442, 442, 443, 443, 443, 443, 443, 
	443, 442, 442, 442, 442, 442, 442, 442, 
	442, 442, 442, 442, 442, 442, 442, 442, 
	442, 442, 442, 442, 442, 442, 442, 442, 
	442, 442, 442, 443, 443, 443, 443, 443, 
	443, 442, 442, 442, 442, 442, 442, 442, 
	442, 442, 442, 442, 442, 442, 442, 442, 
	442, 442, 442, 442, 442, 444, 442, 445, 
	445, 445, 445, 445, 445, 445, 445, 445, 
	445, 442, 442, 442, 442, 442, 442, 442, 
	445, 445, 445, 445, 445, 445, 442, 442, 
	442, 442, 442, 442, 442, 442, 442, 442, 
	442, 442, 442, 442, 442, 442, 442, 442, 
	442, 442, 442, 442, 442, 442, 442, 442, 
	445, 445, 445, 445, 445, 445, 442, 446, 
	446, 446, 446, 446, 446, 446, 446, 446, 
	446, 442, 442, 442, 442, 442, 442, 442, 
	446, 446, 446, 446, 446, 446, 442, 442, 
	442, 442, 442, 442, 442, 442, 442, 442, 
	442, 442, 442, 442, 442, 442, 442, 442, 
	442, 442, 442, 442, 442, 442, 442, 442, 
	446, 446, 446, 446, 446, 446, 442, 447, 
	447, 447, 447, 447, 447, 447, 447, 447, 
	447, 442, 442, 442, 442, 442, 442, 442, 
	447, 447, 447, 447, 447, 447, 442, 442, 
	442, 442, 442, 442, 442, 442, 442, 442, 
	442, 442, 442, 442, 442, 442, 442, 442, 
	442, 442, 442, 442, 442, 442, 442, 442, 
	447, 447, 447, 447, 447, 447, 442, 448, 
	451, 450, 450, 450, 451, 450, 450, 450, 
	450, 452, 450, 450, 450, 450, 450, 450, 
	450, 450, 450, 450, 450, 450, 450, 450, 
	450, 450, 451, 450, 450, 450, 450, 450, 
	452, 450, 450, 450, 450, 450, 450, 450, 
	450, 450, 450, 450, 450, 450, 450, 450, 
	453, 453, 453, 453, 453, 453, 453, 453, 
	453, 453, 450, 450, 450, 450, 450, 450, 
	450, 453, 453, 453, 453, 453, 453, 450, 
	450, 450, 450, 450, 450, 450, 450, 450, 
	450, 450, 450, 450, 450, 450, 450, 450, 
	450, 450, 450, 450, 450, 450, 450, 450, 
	450, 453, 453, 453, 453, 453, 453, 450, 
	450, 450, 450, 450, 450, 450, 450, 450, 
	450, 450, 450, 450, 450, 450, 450, 450, 
	450, 450, 450, 450, 450, 454, 450, 451, 
	450, 450, 450, 451, 450, 450, 450, 450, 
	449, 450, 450, 450, 450, 450, 450, 450, 
	450, 450, 450, 450, 450, 450, 450, 450, 
	450, 451, 450, 450, 450, 450, 450, 449, 
	450, 450, 450, 450, 450, 450, 450, 450, 
	450, 450, 450, 450, 450, 450, 450, 455, 
	455, 455, 455, 455, 455, 455, 455, 455, 
	455, 450, 450, 450, 450, 450, 450, 450, 
	455, 455, 455, 455, 455, 455, 450, 450, 
	450, 450, 450, 450, 450, 450, 450, 450, 
	450, 450, 450, 450, 450, 450, 450, 450, 
	450, 450, 450, 450, 450, 450, 450, 450, 
	455, 455, 455, 455, 455, 455, 450, 450, 
	450, 450, 450, 450, 450, 450, 450, 450, 
	450, 450, 450, 450, 450, 450, 450, 450, 
	450, 450, 450, 450, 456, 450, 449, 451, 
	455, 455, 455, 451, 455, 455, 455, 455, 
	449, 455, 455, 455, 455, 455, 455, 455, 
	455, 455, 455, 455, 455, 455, 455, 455, 
	455, 451, 455, 455, 455, 455, 455, 449, 
	455, 455, 455, 455, 455, 455, 455, 455, 
	455, 455, 455, 455, 455, 455, 455, 455, 
	455, 455, 455, 455, 455, 455, 455, 455, 
	455, 455, 455, 455, 455, 455, 455, 455, 
	455, 455, 455, 455, 455, 455, 455, 455, 
	455, 455, 455, 455, 455, 455, 455, 455, 
	455, 455, 455, 455, 455, 455, 455, 455, 
	455, 455, 455, 455, 455, 455, 455, 455, 
	455, 455, 455, 455, 455, 455, 455, 455, 
	455, 455, 455, 455, 455, 455, 455, 455, 
	455, 455, 455, 455, 455, 455, 455, 455, 
	455, 455, 455, 455, 449, 455, 457, 451, 
	458, 458, 458, 451, 458, 458, 458, 458, 
	452, 458, 458, 458, 458, 458, 458, 458, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	458, 451, 458, 458, 458, 458, 458, 452, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	458, 458, 458, 458, 458, 458, 458, 453, 
	453, 453, 453, 453, 453, 453, 453, 453, 
	453, 458, 458, 458, 458, 458, 458, 458, 
	453, 453, 453, 453, 453, 453, 458, 458, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	453, 453, 453, 453, 453, 453, 458, 458, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	458, 458, 458, 458, 449, 458, 451, 458, 
	458, 458, 451, 458, 458, 458, 458, 449, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	451, 458, 458, 458, 458, 458, 449, 458, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	458, 458, 458, 458, 458, 458, 455, 455, 
	455, 455, 455, 455, 455, 455, 455, 455, 
	458, 458, 458, 458, 458, 458, 458, 455, 
	455, 455, 455, 455, 455, 458, 458, 458, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	458, 458, 458, 458, 458, 458, 458, 455, 
	455, 455, 455, 455, 455, 458, 458, 458, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	458, 458, 458, 451, 458, 451, 458, 458, 
	458, 451, 458, 458, 458, 458, 459, 458, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	458, 458, 458, 458, 458, 458, 458, 451, 
	458, 458, 458, 458, 458, 459, 458, 458, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	458, 458, 458, 458, 458, 460, 460, 460, 
	460, 460, 460, 460, 460, 460, 460, 458, 
	458, 458, 458, 458, 458, 458, 460, 460, 
	460, 460, 460, 460, 458, 458, 458, 458, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	458, 458, 458, 458, 458, 458, 460, 460, 
	460, 460, 460, 460, 458, 458, 458, 458, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	458, 458, 461, 458, 451, 458, 458, 458, 
	451, 458, 458, 458, 458, 459, 458, 458, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	458, 458, 458, 458, 458, 458, 451, 458, 
	458, 458, 458, 458, 459, 458, 458, 458, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	458, 458, 458, 458, 453, 453, 453, 453, 
	453, 453, 453, 453, 453, 453, 458, 458, 
	458, 458, 458, 458, 458, 453, 453, 453, 
	453, 453, 453, 458, 458, 458, 458, 458, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	458, 458, 458, 458, 458, 453, 453, 453, 
	453, 453, 453, 458, 458, 458, 458, 458, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	458, 461, 458, 462, 451, 458, 458, 458, 
	451, 458, 458, 458, 458, 459, 458, 458, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	458, 458, 458, 458, 458, 458, 451, 458, 
	458, 458, 458, 458, 459, 458, 458, 458, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	458, 458, 458, 458, 463, 463, 463, 463, 
	463, 463, 463, 463, 463, 463, 458, 458, 
	458, 458, 458, 458, 458, 463, 463, 463, 
	463, 463, 463, 458, 458, 458, 458, 458, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	458, 458, 458, 458, 458, 463, 463, 463, 
	463, 463, 463, 458, 458, 458, 458, 458, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	458, 461, 458, 451, 458, 458, 458, 451, 
	458, 458, 458, 458, 459, 458, 458, 458, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	458, 458, 458, 458, 458, 451, 458, 458, 
	458, 458, 458, 459, 458, 458, 458, 458, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	458, 458, 458, 464, 464, 464, 464, 464, 
	464, 464, 464, 464, 464, 458, 458, 458, 
	458, 458, 458, 458, 464, 464, 464, 464, 
	464, 464, 458, 458, 458, 458, 458, 458, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	458, 458, 458, 458, 464, 464, 464, 464, 
	464, 464, 458, 458, 458, 458, 458, 458, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	461, 458, 451, 458, 458, 458, 451, 458, 
	458, 458, 458, 459, 458, 458, 458, 458, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	458, 458, 458, 458, 451, 458, 458, 458, 
	458, 458, 459, 458, 458, 458, 458, 458, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	458, 458, 465, 465, 465, 465, 465, 465, 
	465, 465, 465, 465, 458, 458, 458, 458, 
	458, 458, 458, 465, 465, 465, 465, 465, 
	465, 458, 458, 458, 458, 458, 458, 458, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	458, 458, 458, 465, 465, 465, 465, 465, 
	465, 458, 458, 458, 458, 458, 458, 458, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	458, 458, 458, 458, 458, 458, 458, 461, 
	458, 451, 458, 458, 458, 451, 458, 458, 
	458, 458, 459, 458, 458, 458, 458, 458, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	458, 458, 458, 451, 458, 458, 458, 458, 
	458, 459, 458, 458, 458, 458, 458, 458, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	458, 466, 466, 466, 466, 466, 466, 466, 
	466, 466, 466, 458, 458, 458, 458, 458, 
	458, 458, 466, 466, 466, 466, 466, 466, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	458, 458, 466, 466, 466, 466, 466, 466, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	458, 458, 458, 458, 458, 458, 461, 458, 
	451, 458, 458, 458, 451, 458, 458, 458, 
	458, 459, 458, 458, 458, 458, 458, 458, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	458, 458, 451, 458, 458, 458, 458, 458, 
	459, 458, 458, 458, 458, 458, 458, 458, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	467, 467, 467, 467, 467, 467, 467, 467, 
	467, 467, 458, 458, 458, 458, 458, 458, 
	458, 467, 467, 467, 467, 467, 467, 458, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	458, 467, 467, 467, 467, 467, 467, 458, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	458, 458, 458, 458, 458, 461, 458, 451, 
	458, 458, 458, 451, 458, 458, 458, 458, 
	449, 458, 458, 458, 458, 458, 458, 458, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	458, 451, 458, 458, 458, 458, 458, 449, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	458, 458, 458, 458, 458, 458, 458, 467, 
	467, 467, 467, 467, 467, 467, 467, 467, 
	467, 458, 458, 458, 458, 458, 458, 458, 
	467, 467, 467, 467, 467, 467, 458, 458, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	467, 467, 467, 467, 467, 467, 458, 458, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	458, 458, 458, 458, 458, 458, 458, 458, 
	458, 458, 458, 458, 449, 458, 468, 469, 
	471, 471, 471, 471, 471, 471, 471, 471, 
	471, 471, 470, 470, 470, 470, 470, 470, 
	470, 471, 471, 471, 471, 471, 471, 470, 
	470, 470, 470, 470, 470, 470, 470, 470, 
	470, 470, 470, 470, 470, 470, 470, 470, 
	470, 470, 470, 470, 470, 470, 470, 470, 
	470, 471, 471, 471, 471, 471, 471, 470, 
	470, 473, 472, 472, 472, 473, 472, 472, 
	472, 472, 472, 474, 472, 472, 472, 472, 
	472, 472, 472, 472, 472, 472, 472, 472, 
	472, 472, 472, 473, 472, 472, 472, 472, 
	472, 472, 472, 472, 475, 472, 472, 472, 
	472, 472, 472, 472, 472, 472, 472, 472, 
	472, 472, 472, 472, 472, 472, 472, 472, 
	472, 472, 472, 472, 472, 472, 472, 472, 
	472, 472, 472, 472, 472, 472, 472, 472, 
	472, 472, 472, 472, 472, 472, 472, 472, 
	472, 472, 472, 472, 472, 472, 472, 472, 
	472, 472, 472, 472, 472, 476, 472, 478, 
	477, 477, 477, 477, 477, 477, 477, 477, 
	477, 477, 477, 477, 477, 477, 477, 477, 
	477, 477, 477, 477, 477, 477, 477, 477, 
	477, 477, 477, 479, 477, 477, 477, 477, 
	477, 477, 477, 477, 477, 477, 477, 477, 
	477, 477, 477, 477, 477, 477, 477, 477, 
	477, 477, 477, 477, 477, 477, 477, 477, 
	477, 477, 477, 477, 477, 477, 477, 477, 
	477, 477, 477, 477, 477, 477, 477, 477, 
	477, 477, 477, 477, 477, 477, 477, 477, 
	477, 477, 477, 477, 477, 477, 480, 477, 
	481, 481, 481, 481, 481, 481, 481, 481, 
	481, 481, 481, 481, 481, 481, 481, 481, 
	481, 481, 481, 481, 481, 481, 481, 481, 
	481, 481, 481, 481, 481, 481, 481, 481, 
	481, 481, 481, 481, 481, 481, 481, 481, 
	481, 481, 481, 481, 481, 481, 481, 481, 
	48, 48, 48, 48, 48, 48, 48, 48, 
	48, 48, 481, 481, 481, 481, 481, 481, 
	481, 48, 48, 48, 48, 48, 48, 48, 
	48, 48, 48, 48, 48, 48, 48, 48, 
	48, 48, 48, 48, 48, 48, 48, 48, 
	48, 48, 48, 481, 481, 481, 481, 48, 
	481, 48, 48, 48, 48, 48, 48, 48, 
	48, 48, 48, 48, 48, 48, 48, 48, 
	48, 48, 48, 48, 48, 48, 48, 48, 
	48, 48, 48, 481, 481, 481, 481, 481, 
	48, 51, 51, 51, 51, 51, 51, 51, 
	51, 51, 51, 481, 482, 482, 482, 482, 
	482, 482, 482, 482, 482, 482, 482, 482, 
	482, 482, 482, 482, 482, 482, 482, 482, 
	482, 482, 482, 482, 482, 482, 482, 482, 
	482, 482, 482, 482, 482, 482, 482, 482, 
	482, 482, 482, 482, 482, 482, 482, 482, 
	482, 482, 482, 482, 48, 48, 48, 48, 
	48, 48, 48, 48, 48, 48, 482, 482, 
	482, 482, 482, 482, 482, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 482, 
	482, 482, 482, 52, 482, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 482, 
	482, 482, 482, 482, 52, 485, 484, 484, 
	484, 485, 484, 484, 484, 484, 484, 484, 
	484, 484, 484, 484, 484, 484, 484, 484, 
	484, 484, 484, 484, 484, 484, 484, 485, 
	484, 484, 484, 484, 484, 484, 484, 484, 
	484, 484, 484, 484, 484, 484, 484, 484, 
	484, 484, 484, 484, 484, 486, 486, 486, 
	486, 486, 486, 486, 486, 484, 484, 484, 
	484, 484, 484, 484, 484, 484, 484, 484, 
	487, 484, 484, 484, 484, 484, 484, 484, 
	484, 484, 488, 484, 484, 484, 484, 484, 
	484, 484, 484, 484, 484, 484, 484, 484, 
	484, 484, 484, 484, 484, 484, 484, 484, 
	489, 484, 484, 484, 484, 484, 484, 484, 
	484, 484, 484, 484, 484, 484, 484, 484, 
	484, 484, 490, 484, 484, 491, 484, 492, 
	493, 495, 495, 495, 495, 495, 495, 495, 
	495, 494, 496, 496, 496, 496, 496, 496, 
	496, 496, 494, 494, 497, 497, 77, 77, 
	77, 497, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 497, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 78, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 498, 77, 499, 500, 501, 501, 77, 
	77, 77, 501, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	501, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 78, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 502, 77, 76, 501, 503, 504, 
	505, 505, 62, 62, 62, 505, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 505, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	63, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 506, 62, 507, 
	507, 507, 507, 507, 507, 507, 507, 507, 
	507, 505, 505, 505, 505, 505, 505, 505, 
	507, 507, 507, 507, 507, 507, 505, 505, 
	505, 505, 505, 505, 505, 505, 505, 505, 
	505, 505, 505, 505, 505, 505, 505, 505, 
	505, 505, 505, 505, 505, 505, 505, 505, 
	507, 507, 507, 507, 507, 507, 505, 509, 
	509, 509, 509, 509, 509, 509, 509, 509, 
	509, 508, 508, 508, 508, 508, 508, 508, 
	509, 509, 509, 509, 509, 509, 508, 508, 
	508, 508, 508, 508, 508, 508, 508, 508, 
	508, 508, 508, 508, 508, 508, 508, 508, 
	508, 508, 508, 508, 508, 508, 508, 508, 
	509, 509, 509, 509, 509, 509, 508, 508, 
	510, 510, 510, 510, 510, 510, 510, 510, 
	510, 510, 501, 501, 501, 501, 501, 501, 
	501, 510, 510, 510, 510, 510, 510, 501, 
	501, 501, 501, 501, 501, 501, 501, 501, 
	501, 501, 501, 501, 501, 501, 501, 501, 
	501, 501, 501, 501, 501, 501, 501, 501, 
	501, 510, 510, 510, 510, 510, 510, 501, 
	512, 512, 512, 512, 512, 512, 512, 512, 
	512, 512, 511, 511, 511, 511, 511, 511, 
	511, 512, 512, 512, 512, 512, 512, 511, 
	511, 511, 511, 511, 511, 511, 511, 511, 
	511, 511, 511, 511, 511, 511, 511, 511, 
	511, 511, 511, 511, 511, 511, 511, 511, 
	511, 512, 512, 512, 512, 512, 512, 511, 
	511, 501, 55, 55, 55, 501, 55, 55, 
	55, 55, 55, 55, 55, 55, 55, 55, 
	55, 55, 55, 55, 55, 55, 55, 55, 
	55, 55, 55, 501, 55, 55, 55, 55, 
	55, 55, 55, 55, 55, 55, 55, 55, 
	55, 55, 55, 55, 55, 55, 513, 55, 
	497, 62, 62, 62, 497, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 497, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 63, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 64, 62, 497, 514, 
	514, 514, 497, 514, 514, 514, 514, 514, 
	514, 514, 514, 514, 514, 514, 514, 514, 
	514, 514, 514, 514, 514, 514, 514, 514, 
	497, 514, 514, 514, 514, 514, 514, 514, 
	514, 514, 514, 514, 514, 514, 514, 514, 
	514, 514, 514, 514, 514, 514, 514, 514, 
	514, 514, 514, 514, 514, 514, 514, 514, 
	514, 514, 514, 514, 514, 514, 514, 514, 
	514, 514, 514, 514, 514, 514, 514, 514, 
	514, 514, 514, 514, 514, 514, 514, 514, 
	514, 514, 514, 514, 514, 514, 514, 514, 
	514, 514, 515, 514, 516, 517, 517, 514, 
	514, 514, 517, 514, 514, 514, 514, 514, 
	514, 514, 514, 514, 514, 514, 514, 514, 
	514, 514, 514, 514, 514, 514, 514, 514, 
	517, 514, 514, 514, 514, 514, 514, 514, 
	514, 514, 514, 514, 514, 514, 514, 514, 
	514, 514, 514, 514, 514, 514, 514, 514, 
	514, 514, 514, 514, 514, 514, 514, 514, 
	514, 514, 514, 514, 514, 514, 514, 514, 
	514, 514, 514, 514, 514, 514, 514, 514, 
	514, 514, 514, 514, 514, 514, 514, 514, 
	514, 514, 514, 514, 514, 514, 514, 514, 
	514, 514, 518, 514, 519, 519, 519, 519, 
	519, 519, 519, 519, 519, 519, 517, 517, 
	517, 517, 517, 517, 517, 519, 519, 519, 
	519, 519, 519, 517, 517, 517, 517, 517, 
	517, 517, 517, 517, 517, 517, 517, 517, 
	517, 517, 517, 517, 517, 517, 517, 517, 
	517, 517, 517, 517, 517, 519, 519, 519, 
	519, 519, 519, 517, 521, 521, 521, 521, 
	521, 521, 521, 521, 521, 521, 520, 520, 
	520, 520, 520, 520, 520, 521, 521, 521, 
	521, 521, 521, 520, 520, 520, 520, 520, 
	520, 520, 520, 520, 520, 520, 520, 520, 
	520, 520, 520, 520, 520, 520, 520, 520, 
	520, 520, 520, 520, 520, 521, 521, 521, 
	521, 521, 521, 520, 520, 517, 55, 55, 
	55, 517, 55, 55, 55, 55, 55, 55, 
	55, 55, 55, 55, 55, 55, 55, 55, 
	55, 55, 55, 55, 55, 55, 55, 517, 
	55, 55, 55, 55, 55, 55, 55, 55, 
	55, 55, 55, 55, 55, 55, 55, 55, 
	55, 55, 513, 55, 522, 517, 517, 62, 
	62, 62, 517, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	517, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 63, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 64, 62, 524, 524, 524, 524, 
	524, 524, 524, 524, 524, 524, 523, 523, 
	523, 523, 523, 523, 523, 524, 524, 524, 
	524, 524, 524, 523, 523, 523, 523, 523, 
	523, 523, 523, 523, 523, 523, 523, 523, 
	523, 523, 523, 523, 523, 523, 523, 523, 
	523, 523, 523, 523, 523, 524, 524, 524, 
	524, 524, 524, 523, 523, 523, 523, 523, 
	523, 523, 523, 523, 523, 523, 523, 523, 
	523, 523, 523, 523, 523, 523, 523, 525, 
	523, 526, 526, 526, 526, 526, 526, 526, 
	526, 526, 526, 523, 523, 523, 523, 523, 
	523, 523, 526, 526, 526, 526, 526, 526, 
	523, 523, 523, 523, 523, 523, 523, 523, 
	523, 523, 523, 523, 523, 523, 523, 523, 
	523, 523, 523, 523, 523, 523, 523, 523, 
	523, 523, 526, 526, 526, 526, 526, 526, 
	523, 527, 527, 527, 527, 527, 527, 527, 
	527, 527, 527, 523, 523, 523, 523, 523, 
	523, 523, 527, 527, 527, 527, 527, 527, 
	523, 523, 523, 523, 523, 523, 523, 523, 
	523, 523, 523, 523, 523, 523, 523, 523, 
	523, 523, 523, 523, 523, 523, 523, 523, 
	523, 523, 527, 527, 527, 527, 527, 527, 
	523, 528, 528, 528, 528, 528, 528, 528, 
	528, 528, 528, 523, 523, 523, 523, 523, 
	523, 523, 528, 528, 528, 528, 528, 528, 
	523, 523, 523, 523, 523, 523, 523, 523, 
	523, 523, 523, 523, 523, 523, 523, 523, 
	523, 523, 523, 523, 523, 523, 523, 523, 
	523, 523, 528, 528, 528, 528, 528, 528, 
	523, 529, 532, 531, 531, 531, 532, 531, 
	531, 531, 531, 533, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 532, 531, 531, 531, 
	531, 531, 533, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 534, 534, 534, 534, 534, 534, 
	534, 534, 534, 534, 531, 531, 531, 531, 
	531, 531, 531, 534, 534, 534, 534, 534, 
	534, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 534, 534, 534, 534, 534, 
	534, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 535, 
	531, 532, 531, 531, 531, 532, 531, 531, 
	531, 531, 530, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 532, 531, 531, 531, 531, 
	531, 530, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 536, 536, 536, 536, 536, 536, 536, 
	536, 536, 536, 531, 531, 531, 531, 531, 
	531, 531, 536, 536, 536, 536, 536, 536, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 536, 536, 536, 536, 536, 536, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 531, 531, 
	531, 531, 531, 531, 531, 531, 537, 531, 
	530, 532, 536, 536, 536, 532, 536, 536, 
	536, 536, 530, 536, 536, 536, 536, 536, 
	536, 536, 536, 536, 536, 536, 536, 536, 
	536, 536, 536, 532, 536, 536, 536, 536, 
	536, 530, 536, 536, 536, 536, 536, 536, 
	536, 536, 536, 536, 536, 536, 536, 536, 
	536, 536, 536, 536, 536, 536, 536, 536, 
	536, 536, 536, 536, 536, 536, 536, 536, 
	536, 536, 536, 536, 536, 536, 536, 536, 
	536, 536, 536, 536, 536, 536, 536, 536, 
	536, 536, 536, 536, 536, 536, 536, 536, 
	536, 536, 536, 536, 536, 536, 536, 536, 
	536, 536, 536, 536, 536, 536, 536, 536, 
	536, 536, 536, 536, 536, 536, 536, 536, 
	536, 536, 536, 536, 536, 536, 536, 536, 
	536, 536, 536, 536, 536, 536, 530, 536, 
	538, 532, 539, 539, 539, 532, 539, 539, 
	539, 539, 533, 539, 539, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 539, 539, 532, 539, 539, 539, 539, 
	539, 533, 539, 539, 539, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 534, 534, 534, 534, 534, 534, 534, 
	534, 534, 534, 539, 539, 539, 539, 539, 
	539, 539, 534, 534, 534, 534, 534, 534, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 539, 534, 534, 534, 534, 534, 534, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 530, 539, 
	532, 539, 539, 539, 532, 539, 539, 539, 
	539, 530, 539, 539, 539, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 539, 532, 539, 539, 539, 539, 539, 
	530, 539, 539, 539, 539, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	536, 536, 536, 536, 536, 536, 536, 536, 
	536, 536, 539, 539, 539, 539, 539, 539, 
	539, 536, 536, 536, 536, 536, 536, 539, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 536, 536, 536, 536, 536, 536, 539, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 539, 539, 539, 539, 532, 539, 532, 
	539, 539, 539, 532, 539, 539, 539, 539, 
	540, 539, 539, 539, 539, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 532, 539, 539, 539, 539, 539, 540, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 539, 541, 
	541, 541, 541, 541, 541, 541, 541, 541, 
	541, 539, 539, 539, 539, 539, 539, 539, 
	541, 541, 541, 541, 541, 541, 539, 539, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	541, 541, 541, 541, 541, 541, 539, 539, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 539, 539, 539, 542, 539, 532, 539, 
	539, 539, 532, 539, 539, 539, 539, 540, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	532, 539, 539, 539, 539, 539, 540, 539, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 534, 534, 
	534, 534, 534, 534, 534, 534, 534, 534, 
	539, 539, 539, 539, 539, 539, 539, 534, 
	534, 534, 534, 534, 534, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 539, 534, 
	534, 534, 534, 534, 534, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 539, 539, 542, 539, 543, 532, 539, 
	539, 539, 532, 539, 539, 539, 539, 540, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	532, 539, 539, 539, 539, 539, 540, 539, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 544, 544, 
	544, 544, 544, 544, 544, 544, 544, 544, 
	539, 539, 539, 539, 539, 539, 539, 544, 
	544, 544, 544, 544, 544, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 539, 544, 
	544, 544, 544, 544, 544, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 539, 539, 542, 539, 532, 539, 539, 
	539, 532, 539, 539, 539, 539, 540, 539, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 539, 532, 
	539, 539, 539, 539, 539, 540, 539, 539, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 539, 539, 539, 539, 545, 545, 545, 
	545, 545, 545, 545, 545, 545, 545, 539, 
	539, 539, 539, 539, 539, 539, 545, 545, 
	545, 545, 545, 545, 539, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 545, 545, 
	545, 545, 545, 545, 539, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 539, 542, 539, 532, 539, 539, 539, 
	532, 539, 539, 539, 539, 540, 539, 539, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 532, 539, 
	539, 539, 539, 539, 540, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 539, 539, 539, 546, 546, 546, 546, 
	546, 546, 546, 546, 546, 546, 539, 539, 
	539, 539, 539, 539, 539, 546, 546, 546, 
	546, 546, 546, 539, 539, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 539, 539, 539, 539, 546, 546, 546, 
	546, 546, 546, 539, 539, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 542, 539, 532, 539, 539, 539, 532, 
	539, 539, 539, 539, 540, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 539, 539, 539, 539, 532, 539, 539, 
	539, 539, 539, 540, 539, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 539, 539, 547, 547, 547, 547, 547, 
	547, 547, 547, 547, 547, 539, 539, 539, 
	539, 539, 539, 539, 547, 547, 547, 547, 
	547, 547, 539, 539, 539, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 539, 539, 539, 547, 547, 547, 547, 
	547, 547, 539, 539, 539, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	542, 539, 532, 539, 539, 539, 532, 539, 
	539, 539, 539, 540, 539, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 539, 539, 539, 532, 539, 539, 539, 
	539, 539, 540, 539, 539, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 539, 548, 548, 548, 548, 548, 548, 
	548, 548, 548, 548, 539, 539, 539, 539, 
	539, 539, 539, 548, 548, 548, 548, 548, 
	548, 539, 539, 539, 539, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 539, 539, 548, 548, 548, 548, 548, 
	548, 539, 539, 539, 539, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 539, 542, 
	539, 532, 539, 539, 539, 532, 539, 539, 
	539, 539, 530, 539, 539, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 539, 539, 532, 539, 539, 539, 539, 
	539, 530, 539, 539, 539, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 548, 548, 548, 548, 548, 548, 548, 
	548, 548, 548, 539, 539, 539, 539, 539, 
	539, 539, 548, 548, 548, 548, 548, 548, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 539, 548, 548, 548, 548, 548, 548, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 539, 539, 
	539, 539, 539, 539, 539, 539, 530, 539, 
	549, 550, 552, 552, 552, 552, 552, 552, 
	552, 552, 552, 552, 551, 551, 551, 551, 
	551, 551, 551, 552, 552, 552, 552, 552, 
	552, 551, 551, 551, 551, 551, 551, 551, 
	551, 551, 551, 551, 551, 551, 551, 551, 
	551, 551, 551, 551, 551, 551, 551, 551, 
	551, 551, 551, 552, 552, 552, 552, 552, 
	552, 551, 551, 554, 553, 553, 553, 554, 
	553, 553, 553, 553, 555, 556, 555, 555, 
	555, 553, 553, 553, 553, 553, 553, 553, 
	553, 553, 553, 553, 553, 554, 553, 553, 
	553, 553, 553, 555, 553, 553, 553, 553, 
	553, 553, 553, 553, 553, 553, 553, 553, 
	553, 553, 553, 553, 553, 553, 553, 553, 
	553, 553, 553, 553, 553, 553, 553, 553, 
	553, 553, 553, 553, 553, 553, 553, 553, 
	553, 553, 553, 553, 553, 553, 553, 553, 
	553, 553, 553, 553, 553, 553, 553, 553, 
	553, 553, 553, 553, 553, 553, 553, 557, 
	553, 555, 558, 555, 555, 555, 558, 558, 
	558, 558, 558, 558, 558, 558, 558, 558, 
	558, 558, 558, 558, 558, 558, 558, 558, 
	555, 558, 559, 560, 560, 560, 559, 560, 
	560, 560, 560, 560, 560, 560, 560, 560, 
	560, 560, 560, 560, 560, 560, 560, 560, 
	560, 560, 560, 560, 559, 560, 562, 561, 
	561, 561, 562, 561, 561, 561, 561, 561, 
	563, 561, 561, 561, 561, 561, 561, 561, 
	561, 561, 561, 561, 561, 561, 561, 561, 
	562, 561, 561, 561, 561, 561, 561, 561, 
	561, 561, 561, 561, 561, 561, 561, 561, 
	561, 561, 561, 561, 561, 561, 561, 561, 
	561, 561, 561, 561, 561, 561, 561, 561, 
	561, 561, 561, 561, 561, 561, 561, 561, 
	561, 561, 561, 561, 561, 561, 561, 561, 
	561, 561, 561, 561, 561, 561, 561, 561, 
	561, 561, 561, 561, 561, 561, 561, 561, 
	561, 561, 564, 561, 565, 566, 566, 566, 
	565, 566, 566, 566, 566, 566, 567, 566, 
	566, 566, 566, 566, 566, 566, 566, 566, 
	566, 566, 566, 566, 566, 566, 565, 566, 
	569, 568, 568, 568, 569, 568, 568, 568, 
	568, 568, 570, 568, 568, 568, 568, 568, 
	568, 568, 568, 568, 568, 568, 568, 568, 
	568, 568, 569, 568, 568, 568, 568, 568, 
	568, 568, 568, 571, 568, 573, 572, 572, 
	572, 572, 572, 572, 572, 572, 572, 572, 
	572, 572, 572, 572, 572, 572, 572, 572, 
	572, 572, 572, 572, 572, 572, 572, 572, 
	572, 574, 572, 572, 572, 572, 572, 572, 
	572, 572, 572, 572, 572, 572, 572, 572, 
	572, 572, 572, 572, 572, 572, 572, 572, 
	572, 572, 572, 572, 572, 572, 572, 572, 
	572, 572, 572, 572, 572, 572, 572, 572, 
	572, 572, 572, 572, 572, 572, 572, 572, 
	572, 572, 572, 572, 572, 572, 572, 572, 
	572, 572, 572, 572, 575, 572, 576, 576, 
	576, 576, 576, 576, 576, 576, 576, 576, 
	576, 576, 576, 576, 576, 576, 576, 576, 
	576, 576, 576, 576, 576, 576, 576, 576, 
	576, 576, 576, 576, 576, 576, 576, 576, 
	576, 576, 576, 576, 576, 576, 576, 576, 
	576, 576, 576, 576, 576, 576, 83, 83, 
	83, 83, 83, 83, 83, 83, 83, 83, 
	576, 576, 576, 576, 576, 576, 576, 83, 
	83, 83, 83, 83, 83, 83, 83, 83, 
	83, 83, 83, 83, 83, 83, 83, 83, 
	83, 83, 83, 83, 83, 83, 83, 83, 
	83, 576, 576, 576, 576, 83, 576, 83, 
	83, 83, 83, 83, 83, 83, 83, 83, 
	83, 83, 83, 83, 83, 83, 83, 83, 
	83, 83, 83, 83, 83, 83, 83, 83, 
	83, 576, 576, 576, 576, 576, 83, 86, 
	86, 86, 86, 86, 86, 86, 86, 86, 
	86, 576, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 577, 577, 577, 577, 577, 577, 
	577, 577, 83, 83, 83, 83, 83, 83, 
	83, 83, 83, 83, 577, 577, 577, 577, 
	577, 577, 577, 87, 87, 87, 87, 87, 
	87, 87, 87, 87, 87, 87, 87, 87, 
	87, 87, 87, 87, 87, 87, 87, 87, 
	87, 87, 87, 87, 87, 577, 577, 577, 
	577, 87, 577, 87, 87, 87, 87, 87, 
	87, 87, 87, 87, 87, 87, 87, 87, 
	87, 87, 87, 87, 87, 87, 87, 87, 
	87, 87, 87, 87, 87, 577, 577, 577, 
	577, 577, 87, 579, 578, 578, 578, 579, 
	578, 578, 578, 578, 578, 580, 578, 578, 
	578, 578, 578, 578, 578, 578, 578, 578, 
	578, 578, 578, 578, 578, 579, 578, 582, 
	581, 581, 581, 582, 581, 581, 581, 581, 
	583, 584, 583, 583, 583, 581, 581, 581, 
	581, 581, 581, 581, 581, 581, 581, 581, 
	581, 582, 581, 581, 581, 581, 581, 583, 
	581, 581, 585, 581, 583, 586, 583, 583, 
	583, 586, 586, 586, 586, 586, 586, 586, 
	586, 586, 586, 586, 586, 586, 586, 586, 
	586, 586, 586, 583, 586, 588, 587, 587, 
	587, 587, 587, 587, 587, 587, 587, 587, 
	587, 587, 587, 587, 587, 587, 587, 587, 
	587, 587, 587, 587, 587, 587, 587, 587, 
	587, 589, 587, 587, 587, 587, 587, 587, 
	587, 587, 587, 587, 587, 587, 587, 587, 
	587, 587, 587, 587, 587, 587, 587, 587, 
	587, 587, 587, 587, 587, 587, 587, 587, 
	587, 587, 587, 587, 587, 587, 587, 587, 
	587, 587, 587, 587, 587, 587, 587, 587, 
	587, 587, 587, 587, 587, 587, 587, 587, 
	587, 587, 587, 587, 590, 587, 591, 591, 
	591, 591, 591, 591, 591, 591, 591, 591, 
	591, 591, 591, 591, 591, 591, 591, 591, 
	591, 591, 591, 591, 591, 591, 591, 591, 
	591, 591, 591, 591, 591, 591, 591, 591, 
	591, 591, 591, 591, 591, 591, 591, 591, 
	591, 591, 591, 591, 591, 591, 90, 90, 
	90, 90, 90, 90, 90, 90, 90, 90, 
	591, 591, 591, 591, 591, 591, 591, 90, 
	90, 90, 90, 90, 90, 90, 90, 90, 
	90, 90, 90, 90, 90, 90, 90, 90, 
	90, 90, 90, 90, 90, 90, 90, 90, 
	90, 591, 591, 591, 591, 90, 591, 90, 
	90, 90, 90, 90, 90, 90, 90, 90, 
	90, 90, 90, 90, 90, 90, 90, 90, 
	90, 90, 90, 90, 90, 90, 90, 90, 
	90, 591, 591, 591, 591, 591, 90, 93, 
	93, 93, 93, 93, 93, 93, 93, 93, 
	93, 591, 592, 592, 592, 592, 592, 592, 
	592, 592, 592, 592, 592, 592, 592, 592, 
	592, 592, 592, 592, 592, 592, 592, 592, 
	592, 592, 592, 592, 592, 592, 592, 592, 
	592, 592, 592, 592, 592, 592, 592, 592, 
	592, 592, 592, 592, 592, 592, 592, 592, 
	592, 592, 90, 90, 90, 90, 90, 90, 
	90, 90, 90, 90, 592, 592, 592, 592, 
	592, 592, 592, 94, 94, 94, 94, 94, 
	94, 94, 94, 94, 94, 94, 94, 94, 
	94, 94, 94, 94, 94, 94, 94, 94, 
	94, 94, 94, 94, 94, 592, 592, 592, 
	592, 94, 592, 94, 94, 94, 94, 94, 
	94, 94, 94, 94, 94, 94, 94, 94, 
	94, 94, 94, 94, 94, 94, 94, 94, 
	94, 94, 94, 94, 94, 592, 592, 592, 
	592, 592, 94, 594, 593, 593, 593, 594, 
	593, 593, 593, 593, 595, 596, 595, 595, 
	595, 593, 593, 593, 593, 593, 593, 593, 
	593, 593, 593, 593, 593, 594, 593, 593, 
	593, 593, 593, 595, 593, 595, 597, 595, 
	595, 595, 597, 597, 597, 597, 597, 597, 
	597, 597, 597, 597, 597, 597, 597, 597, 
	597, 597, 597, 597, 595, 597, 599, 599, 
	599, 599, 599, 599, 599, 599, 599, 599, 
	599, 599, 599, 599, 599, 599, 599, 599, 
	599, 599, 599, 599, 599, 599, 599, 599, 
	598, 598, 598, 598, 598, 598, 599, 599, 
	599, 599, 599, 599, 599, 599, 599, 599, 
	599, 599, 599, 599, 599, 599, 599, 599, 
	599, 599, 599, 599, 599, 599, 599, 599, 
	598, 599, 599, 599, 599, 599, 599, 599, 
	599, 599, 599, 599, 599, 599, 599, 599, 
	599, 599, 599, 599, 599, 599, 599, 599, 
	599, 599, 599, 600, 600, 600, 600, 600, 
	600, 599, 599, 599, 599, 599, 599, 599, 
	599, 599, 599, 599, 599, 599, 599, 599, 
	599, 599, 599, 599, 599, 599, 599, 599, 
	599, 599, 599, 600, 601, 98, 98, 98, 
	98, 98, 98, 98, 98, 98, 98, 98, 
	98, 98, 98, 98, 98, 98, 98, 98, 
	98, 98, 98, 98, 98, 98, 98, 98, 
	602, 98, 603, 603, 603, 603, 603, 603, 
	603, 603, 603, 603, 603, 603, 603, 603, 
	603, 603, 603, 603, 603, 603, 603, 603, 
	603, 603, 603, 603, 603, 603, 603, 603, 
	603, 603, 603, 603, 603, 603, 603, 603, 
	603, 603, 603, 603, 603, 603, 603, 603, 
	603, 603, 96, 96, 96, 96, 96, 96, 
	96, 96, 96, 96, 603, 603, 603, 603, 
	603, 603, 603, 96, 96, 96, 96, 96, 
	96, 96, 96, 96, 96, 96, 96, 96, 
	96, 96, 96, 96, 96, 96, 96, 96, 
	96, 96, 96, 96, 96, 603, 603, 603, 
	603, 96, 603, 96, 96, 96, 96, 96, 
	96, 96, 96, 96, 96, 96, 96, 96, 
	96, 96, 96, 96, 96, 96, 96, 96, 
	96, 96, 96, 96, 96, 603, 603, 603, 
	603, 603, 96, 100, 100, 100, 100, 100, 
	100, 100, 100, 100, 100, 603, 604, 604, 
	604, 604, 604, 604, 604, 604, 604, 604, 
	604, 604, 604, 604, 604, 604, 604, 604, 
	604, 604, 604, 604, 604, 604, 604, 604, 
	604, 604, 604, 604, 604, 604, 604, 604, 
	604, 604, 604, 604, 604, 604, 604, 604, 
	604, 604, 604, 604, 604, 604, 101, 101, 
	101, 101, 101, 101, 101, 101, 101, 101, 
	604, 604, 604, 604, 604, 604, 604, 101, 
	101, 101, 101, 101, 101, 101, 101, 101, 
	101, 101, 101, 101, 101, 101, 101, 101, 
	101, 101, 101, 101, 101, 101, 101, 101, 
	101, 604, 604, 604, 604, 101, 604, 101, 
	101, 101, 101, 101, 101, 101, 101, 101, 
	101, 101, 101, 101, 101, 101, 101, 101, 
	101, 101, 101, 101, 101, 101, 101, 101, 
	101, 604, 604, 604, 604, 604, 101, 605, 
	605, 605, 605, 605, 605, 605, 605, 605, 
	605, 605, 605, 605, 605, 605, 605, 605, 
	605, 605, 605, 605, 605, 605, 605, 605, 
	605, 605, 605, 605, 605, 605, 605, 605, 
	605, 605, 605, 605, 605, 605, 605, 605, 
	605, 605, 605, 605, 605, 605, 605, 103, 
	103, 103, 103, 103, 103, 103, 103, 103, 
	103, 605, 605, 605, 605, 605, 605, 605, 
	103, 103, 103, 103, 103, 103, 103, 103, 
	103, 103, 103, 103, 103, 103, 103, 103, 
	103, 103, 103, 103, 103, 103, 103, 103, 
	103, 103, 605, 605, 605, 605, 103, 605, 
	103, 103, 103, 103, 103, 103, 103, 103, 
	103, 103, 103, 103, 103, 103, 103, 103, 
	103, 103, 103, 103, 103, 103, 103, 103, 
	103, 103, 605, 605, 605, 605, 605, 103, 
	607, 608, 608, 608, 607, 608, 608, 608, 
	608, 609, 610, 609, 609, 609, 608, 608, 
	608, 608, 608, 608, 608, 608, 608, 608, 
	608, 608, 607, 608, 608, 608, 608, 608, 
	609, 611, 608, 612, 613, 614, 615, 608, 
	608, 608, 616, 617, 608, 617, 608, 618, 
	608, 608, 608, 608, 608, 608, 608, 608, 
	608, 608, 619, 608, 620, 621, 622, 608, 
	608, 623, 624, 623, 623, 625, 623, 623, 
	623, 623, 623, 623, 623, 623, 623, 623, 
	623, 623, 623, 623, 623, 623, 623, 623, 
	623, 623, 623, 626, 627, 608, 618, 628, 
	618, 629, 630, 631, 632, 633, 634, 606, 
	606, 635, 606, 606, 606, 636, 637, 638, 
	606, 606, 639, 640, 641, 642, 606, 643, 
	606, 644, 606, 608, 645, 608, 617, 608, 
	606, 646, 646, 646, 646, 646, 646, 646, 
	646, 646, 646, 646, 646, 646, 646, 646, 
	646, 646, 646, 646, 646, 646, 646, 646, 
	646, 646, 646, 646, 646, 646, 646, 646, 
	646, 646, 647, 646, 646, 646, 646, 646, 
	646, 646, 646, 646, 646, 646, 646, 646, 
	646, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 646, 646, 646, 647, 646, 
	647, 646, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 646, 646, 646, 646, 
	606, 646, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 646, 646, 646, 646, 
	646, 606, 609, 648, 609, 609, 609, 648, 
	648, 648, 648, 648, 648, 648, 648, 648, 
	648, 648, 648, 648, 648, 648, 648, 648, 
	648, 609, 648, 649, 618, 650, 650, 618, 
	650, 650, 650, 650, 650, 650, 650, 650, 
	650, 650, 650, 650, 650, 650, 650, 650, 
	650, 650, 650, 650, 650, 650, 650, 650, 
	650, 650, 650, 650, 650, 650, 650, 650, 
	650, 650, 650, 650, 650, 650, 650, 650, 
	650, 650, 650, 650, 650, 650, 650, 650, 
	650, 650, 650, 650, 650, 650, 650, 650, 
	650, 650, 650, 650, 650, 618, 650, 651, 
	652, 653, 654, 655, 655, 655, 655, 655, 
	655, 655, 655, 655, 655, 655, 655, 655, 
	655, 655, 655, 655, 655, 655, 655, 655, 
	655, 655, 655, 655, 655, 655, 655, 655, 
	655, 655, 655, 655, 105, 105, 655, 105, 
	655, 105, 105, 655, 655, 105, 105, 105, 
	657, 105, 105, 658, 658, 658, 658, 658, 
	658, 658, 658, 658, 658, 105, 105, 105, 
	105, 105, 105, 105, 656, 656, 656, 656, 
	656, 656, 656, 656, 656, 656, 656, 656, 
	656, 656, 656, 656, 656, 656, 656, 656, 
	656, 656, 656, 656, 656, 656, 655, 105, 
	655, 655, 656, 105, 656, 656, 656, 656, 
	656, 656, 656, 656, 656, 656, 656, 656, 
	656, 656, 656, 656, 656, 656, 656, 656, 
	656, 656, 656, 656, 656, 656, 655, 655, 
	655, 105, 655, 656, 659, 659, 659, 659, 
	659, 659, 659, 659, 659, 659, 659, 659, 
	659, 659, 659, 659, 659, 659, 659, 659, 
	659, 659, 659, 659, 659, 659, 659, 659, 
	659, 659, 659, 659, 659, 659, 659, 659, 
	659, 659, 659, 659, 659, 659, 659, 659, 
	659, 659, 659, 659, 656, 656, 656, 656, 
	656, 656, 656, 656, 656, 656, 659, 659, 
	659, 659, 659, 659, 659, 656, 656, 656, 
	656, 656, 656, 656, 656, 656, 656, 656, 
	656, 656, 656, 656, 656, 656, 656, 656, 
	656, 656, 656, 656, 656, 656, 656, 659, 
	659, 659, 659, 656, 659, 656, 656, 656, 
	656, 656, 656, 656, 656, 656, 656, 656, 
	656, 656, 656, 656, 656, 656, 656, 656, 
	656, 656, 656, 656, 656, 656, 656, 659, 
	659, 659, 659, 659, 656, 658, 658, 658, 
	658, 658, 658, 658, 658, 658, 658, 659, 
	660, 650, 618, 650, 618, 650, 618, 650, 
	662, 661, 618, 663, 650, 618, 650, 664, 
	618, 655, 655, 655, 655, 655, 655, 655, 
	655, 655, 655, 655, 655, 655, 655, 655, 
	655, 655, 655, 655, 655, 655, 655, 655, 
	655, 655, 655, 655, 655, 655, 655, 655, 
	655, 655, 655, 655, 655, 655, 655, 655, 
	655, 655, 655, 655, 655, 655, 655, 655, 
	655, 655, 655, 655, 655, 655, 655, 655, 
	655, 655, 655, 655, 655, 655, 655, 655, 
	618, 655, 618, 650, 618, 618, 650, 646, 
	646, 646, 646, 646, 646, 646, 646, 646, 
	646, 646, 646, 646, 646, 646, 646, 646, 
	646, 646, 646, 646, 646, 646, 646, 646, 
	646, 646, 646, 646, 646, 646, 646, 646, 
	647, 646, 646, 646, 646, 646, 646, 646, 
	646, 646, 646, 646, 646, 646, 646, 623, 
	623, 623, 623, 623, 623, 623, 623, 623, 
	623, 646, 646, 646, 647, 646, 647, 646, 
	623, 623, 623, 623, 623, 623, 623, 623, 
	623, 623, 623, 623, 623, 623, 623, 623, 
	623, 623, 623, 623, 623, 623, 623, 623, 
	623, 623, 646, 646, 646, 646, 623, 646, 
	623, 623, 623, 623, 623, 623, 623, 623, 
	623, 623, 623, 623, 623, 623, 623, 623, 
	623, 623, 623, 623, 623, 623, 623, 623, 
	623, 623, 646, 646, 646, 646, 646, 623, 
	665, 665, 665, 665, 665, 665, 665, 665, 
	665, 665, 665, 665, 665, 665, 665, 665, 
	665, 665, 665, 665, 665, 665, 665, 665, 
	665, 665, 665, 665, 665, 665, 665, 665, 
	665, 647, 665, 665, 665, 665, 665, 665, 
	665, 665, 665, 665, 665, 665, 665, 665, 
	623, 623, 623, 623, 623, 623, 623, 623, 
	623, 623, 665, 665, 665, 647, 665, 647, 
	665, 623, 623, 623, 623, 666, 623, 623, 
	623, 623, 623, 623, 623, 623, 623, 623, 
	623, 623, 623, 623, 623, 623, 623, 623, 
	623, 623, 623, 665, 665, 665, 665, 623, 
	665, 623, 623, 623, 623, 623, 623, 623, 
	623, 623, 623, 623, 623, 623, 623, 623, 
	623, 623, 623, 623, 623, 623, 623, 623, 
	623, 623, 623, 665, 665, 665, 665, 665, 
	623, 665, 665, 665, 665, 665, 665, 665, 
	665, 665, 665, 665, 665, 665, 665, 665, 
	665, 665, 665, 665, 665, 665, 665, 665, 
	665, 665, 665, 665, 665, 665, 665, 665, 
	665, 665, 647, 665, 665, 665, 665, 665, 
	665, 665, 665, 665, 665, 665, 665, 665, 
	665, 623, 623, 623, 623, 623, 623, 623, 
	623, 623, 623, 665, 665, 665, 647, 665, 
	647, 665, 623, 623, 623, 623, 623, 623, 
	667, 623, 623, 623, 623, 623, 623, 623, 
	623, 623, 623, 623, 623, 623, 623, 623, 
	623, 623, 623, 623, 665, 665, 665, 665, 
	623, 665, 623, 623, 623, 623, 623, 623, 
	623, 623, 623, 623, 623, 623, 623, 623, 
	623, 623, 623, 623, 623, 623, 623, 623, 
	623, 623, 623, 623, 665, 665, 665, 665, 
	665, 623, 665, 665, 665, 665, 665, 665, 
	665, 665, 665, 665, 665, 665, 665, 665, 
	665, 665, 665, 665, 665, 665, 665, 665, 
	665, 665, 665, 665, 665, 665, 665, 665, 
	665, 665, 665, 647, 665, 665, 665, 665, 
	665, 665, 665, 665, 665, 665, 665, 665, 
	665, 665, 623, 623, 623, 623, 623, 623, 
	623, 623, 623, 623, 665, 665, 665, 647, 
	665, 647, 665, 623, 623, 623, 623, 623, 
	623, 623, 623, 668, 623, 623, 623, 623, 
	623, 623, 623, 623, 623, 623, 623, 623, 
	623, 623, 623, 623, 623, 665, 665, 665, 
	665, 623, 665, 623, 623, 623, 623, 623, 
	623, 623, 623, 623, 623, 623, 623, 623, 
	623, 623, 623, 623, 623, 623, 623, 623, 
	623, 623, 623, 623, 623, 665, 665, 665, 
	665, 665, 623, 665, 665, 665, 665, 665, 
	665, 665, 665, 665, 665, 665, 665, 665, 
	665, 665, 665, 665, 665, 665, 665, 665, 
	665, 665, 665, 665, 665, 665, 665, 665, 
	665, 665, 665, 665, 647, 665, 665, 665, 
	665, 665, 665, 665, 665, 665, 665, 665, 
	665, 665, 665, 623, 623, 623, 623, 623, 
	623, 623, 623, 623, 623, 665, 665, 665, 
	647, 665, 647, 665, 623, 623, 623, 623, 
	623, 623, 623, 623, 623, 623, 623, 623, 
	623, 669, 623, 623, 623, 623, 623, 623, 
	623, 623, 623, 623, 623, 623, 665, 665, 
	665, 665, 623, 665, 623, 623, 623, 623, 
	623, 623, 623, 623, 623, 623, 623, 623, 
	623, 623, 623, 623, 623, 623, 623, 623, 
	623, 623, 623, 623, 623, 623, 665, 665, 
	665, 665, 665, 623, 665, 665, 665, 665, 
	665, 665, 665, 665, 665, 665, 665, 665, 
	665, 665, 665, 665, 665, 665, 665, 665, 
	665, 665, 665, 665, 665, 665, 665, 665, 
	665, 665, 665, 665, 665, 647, 665, 665, 
	665, 665, 665, 665, 665, 665, 665, 665, 
	665, 665, 665, 665, 623, 623, 623, 623, 
	623, 623, 623, 623, 623, 623, 665, 665, 
	665, 647, 665, 647, 665, 623, 623, 623, 
	623, 623, 623, 623, 623, 623, 623, 623, 
	623, 623, 670, 623, 623, 623, 623, 623, 
	623, 623, 623, 623, 623, 623, 623, 665, 
	665, 665, 665, 623, 665, 623, 623, 623, 
	623, 623, 623, 623, 623, 623, 623, 623, 
	623, 623, 623, 623, 623, 623, 623, 623, 
	623, 623, 623, 623, 623, 623, 623, 665, 
	665, 665, 665, 665, 623, 665, 665, 665, 
	665, 665, 665, 665, 665, 665, 665, 665, 
	665, 665, 665, 665, 665, 665, 665, 665, 
	665, 665, 665, 665, 665, 665, 665, 665, 
	665, 665, 665, 665, 665, 665, 647, 665, 
	665, 665, 665, 665, 665, 665, 665, 665, 
	665, 665, 665, 665, 665, 623, 623, 623, 
	623, 623, 623, 623, 623, 623, 623, 665, 
	665, 665, 647, 665, 647, 665, 623, 623, 
	623, 669, 623, 623, 623, 623, 623, 623, 
	623, 623, 623, 623, 623, 623, 623, 623, 
	623, 623, 623, 623, 623, 623, 623, 623, 
	665, 665, 665, 665, 623, 665, 623, 623, 
	623, 623, 623, 623, 623, 623, 623, 623, 
	623, 623, 623, 623, 623, 623, 623, 623, 
	623, 623, 623, 623, 623, 623, 623, 623, 
	665, 665, 665, 665, 665, 623, 664, 655, 
	610, 655, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 647, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 671, 671, 671, 647, 
	671, 647, 671, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 671, 671, 671, 
	671, 672, 671, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 671, 671, 671, 
	671, 671, 606, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 647, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 671, 671, 671, 
	647, 671, 647, 671, 606, 606, 606, 606, 
	673, 674, 606, 606, 606, 606, 606, 675, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 671, 671, 
	671, 671, 606, 671, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 671, 671, 
	671, 671, 671, 606, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 647, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 671, 671, 
	671, 647, 671, 647, 671, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 676, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 671, 
	671, 671, 671, 606, 671, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 671, 
	671, 671, 671, 671, 606, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 647, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 671, 
	671, 671, 647, 671, 647, 671, 606, 606, 
	677, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	671, 671, 671, 671, 606, 671, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	671, 671, 671, 671, 671, 606, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 647, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	671, 671, 671, 647, 671, 647, 671, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 678, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 671, 671, 671, 671, 606, 671, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 671, 671, 671, 671, 671, 606, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	647, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 671, 671, 671, 647, 671, 647, 671, 
	606, 606, 606, 679, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 671, 671, 671, 671, 606, 671, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 671, 671, 671, 671, 671, 606, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 647, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 671, 671, 671, 647, 671, 647, 
	671, 606, 606, 606, 606, 606, 606, 606, 
	606, 680, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 671, 671, 671, 671, 606, 
	671, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 671, 671, 671, 671, 671, 
	606, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 647, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 671, 671, 671, 647, 671, 
	647, 671, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 681, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 671, 671, 671, 671, 
	606, 671, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 671, 671, 671, 671, 
	671, 606, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 647, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 671, 671, 671, 647, 
	671, 647, 671, 606, 606, 606, 606, 606, 
	606, 682, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 671, 671, 671, 
	671, 606, 671, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 671, 671, 671, 
	671, 671, 606, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 647, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 671, 671, 671, 
	647, 671, 647, 671, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 671, 671, 
	671, 671, 683, 671, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 671, 671, 
	671, 671, 671, 606, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 647, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 671, 671, 
	671, 647, 671, 647, 671, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 671, 
	671, 671, 671, 684, 671, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 671, 
	671, 671, 671, 671, 606, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 647, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 671, 
	671, 671, 647, 671, 647, 671, 606, 606, 
	606, 606, 606, 606, 606, 606, 685, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	671, 671, 671, 671, 606, 671, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	671, 671, 671, 671, 671, 606, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 647, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	671, 671, 671, 647, 671, 647, 671, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 686, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 671, 671, 671, 671, 606, 671, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 671, 671, 671, 671, 671, 606, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	647, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 671, 671, 671, 647, 671, 647, 671, 
	606, 606, 606, 606, 682, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 671, 671, 671, 671, 606, 671, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 671, 671, 671, 671, 671, 606, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 647, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 671, 671, 671, 647, 671, 647, 
	671, 606, 606, 606, 606, 606, 606, 606, 
	606, 687, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 671, 671, 671, 671, 606, 
	671, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 671, 671, 671, 671, 671, 
	606, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 647, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 671, 671, 671, 647, 671, 
	647, 671, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 686, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 671, 671, 671, 671, 
	606, 671, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 671, 671, 671, 671, 
	671, 606, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 647, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 671, 671, 671, 647, 
	671, 647, 671, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 671, 671, 671, 
	671, 606, 671, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 688, 606, 
	689, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 671, 671, 671, 
	671, 671, 606, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 647, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 671, 671, 671, 
	647, 671, 647, 671, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 671, 671, 
	671, 671, 606, 671, 606, 606, 606, 606, 
	606, 606, 606, 606, 690, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 671, 671, 
	671, 671, 671, 606, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 647, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 671, 671, 
	671, 647, 671, 647, 671, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 671, 
	671, 671, 671, 606, 671, 691, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 671, 
	671, 671, 671, 671, 606, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 647, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 671, 
	671, 671, 647, 671, 647, 671, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	671, 671, 671, 671, 606, 671, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	684, 606, 606, 606, 606, 606, 606, 606, 
	671, 671, 671, 671, 671, 606, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 647, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	671, 671, 671, 647, 671, 647, 671, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 671, 671, 671, 671, 606, 671, 606, 
	606, 606, 684, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 671, 671, 671, 671, 671, 606, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	647, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 671, 671, 671, 647, 671, 647, 671, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 671, 671, 671, 671, 606, 671, 
	606, 606, 606, 606, 692, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 693, 606, 606, 606, 606, 606, 606, 
	606, 606, 671, 671, 671, 671, 671, 606, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 647, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 671, 671, 671, 647, 671, 647, 
	671, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 671, 671, 671, 671, 606, 
	671, 606, 606, 606, 606, 606, 606, 694, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 671, 671, 671, 671, 671, 
	606, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 647, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 671, 671, 671, 647, 671, 
	647, 671, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 671, 671, 671, 671, 
	606, 671, 606, 606, 606, 606, 606, 606, 
	606, 606, 695, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 671, 671, 671, 671, 
	671, 606, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 647, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 671, 671, 671, 647, 
	671, 647, 671, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 671, 671, 671, 
	671, 606, 671, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	684, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 671, 671, 671, 
	671, 671, 606, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 647, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 671, 671, 671, 
	647, 671, 647, 671, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 671, 671, 
	671, 671, 606, 671, 606, 606, 606, 606, 
	696, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 671, 671, 
	671, 671, 671, 606, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 647, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 671, 671, 
	671, 647, 671, 647, 671, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 671, 
	671, 671, 671, 606, 671, 697, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 671, 
	671, 671, 671, 671, 606, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 647, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 671, 
	671, 671, 647, 671, 647, 671, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	671, 671, 671, 671, 606, 671, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	684, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	671, 671, 671, 671, 671, 606, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 647, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	671, 671, 671, 647, 671, 647, 671, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 671, 671, 671, 671, 606, 671, 698, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 699, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 671, 671, 671, 671, 671, 606, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	647, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 671, 671, 671, 647, 671, 647, 671, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 671, 671, 671, 671, 606, 671, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 700, 606, 606, 606, 606, 606, 
	606, 606, 671, 671, 671, 671, 671, 606, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 647, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 671, 671, 671, 647, 671, 647, 
	671, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 671, 671, 671, 671, 606, 
	671, 606, 606, 606, 606, 684, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 671, 671, 671, 671, 671, 
	606, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 647, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 671, 671, 671, 647, 671, 
	647, 671, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 671, 671, 671, 671, 
	606, 671, 701, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 671, 671, 671, 671, 
	671, 606, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 647, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 671, 671, 671, 647, 
	671, 647, 671, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 671, 671, 671, 
	671, 606, 671, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 691, 606, 606, 
	606, 606, 606, 606, 606, 671, 671, 671, 
	671, 671, 606, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 647, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 671, 671, 671, 
	647, 671, 647, 671, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 671, 671, 
	671, 671, 606, 671, 606, 606, 606, 606, 
	702, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 684, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 671, 671, 
	671, 671, 671, 606, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 647, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 671, 671, 
	671, 647, 671, 647, 671, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 671, 
	671, 671, 671, 606, 671, 606, 606, 606, 
	606, 606, 703, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 671, 
	671, 671, 671, 671, 606, 704, 704, 704, 
	704, 704, 704, 704, 704, 704, 704, 704, 
	704, 704, 704, 704, 704, 704, 704, 704, 
	704, 704, 704, 704, 704, 704, 704, 704, 
	704, 704, 704, 704, 704, 704, 647, 704, 
	704, 704, 704, 704, 704, 704, 704, 704, 
	704, 704, 704, 704, 704, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 704, 
	704, 704, 647, 704, 647, 704, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	704, 704, 704, 704, 606, 704, 606, 606, 
	606, 606, 606, 606, 606, 606, 705, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	704, 704, 704, 704, 704, 606, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 647, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	671, 671, 671, 647, 671, 647, 671, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 671, 671, 671, 671, 606, 671, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 706, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 671, 671, 671, 671, 671, 606, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	647, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 671, 671, 671, 647, 671, 647, 671, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 671, 671, 671, 671, 606, 671, 
	606, 606, 606, 606, 707, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 671, 671, 671, 671, 671, 606, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 647, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 671, 671, 671, 647, 671, 647, 
	671, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 671, 671, 671, 671, 606, 
	671, 606, 606, 606, 708, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 671, 671, 671, 671, 671, 
	606, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 647, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 671, 671, 671, 647, 671, 
	709, 671, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 671, 671, 671, 671, 
	606, 671, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 671, 671, 671, 671, 
	671, 606, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 647, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 671, 671, 671, 647, 
	671, 647, 671, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 671, 671, 671, 
	671, 606, 671, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 710, 606, 
	711, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 671, 671, 671, 
	671, 671, 606, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 647, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 671, 671, 671, 
	647, 671, 647, 671, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 671, 671, 
	671, 671, 606, 671, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 712, 606, 
	606, 606, 606, 606, 606, 606, 671, 671, 
	671, 671, 671, 606, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 647, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 671, 671, 
	671, 647, 671, 647, 671, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 671, 
	671, 671, 671, 606, 671, 606, 606, 606, 
	606, 684, 606, 606, 606, 713, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 671, 
	671, 671, 671, 671, 606, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 647, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 671, 
	671, 671, 647, 671, 647, 671, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	671, 671, 671, 671, 606, 671, 606, 606, 
	606, 606, 606, 684, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	671, 671, 671, 671, 671, 606, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 647, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	671, 671, 671, 647, 671, 647, 671, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 671, 671, 671, 671, 606, 671, 606, 
	606, 606, 684, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 714, 606, 606, 606, 606, 606, 606, 
	606, 671, 671, 671, 671, 671, 606, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	647, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 671, 671, 671, 647, 671, 647, 671, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 671, 671, 671, 671, 606, 671, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 715, 606, 606, 606, 
	606, 606, 671, 671, 671, 671, 671, 606, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 647, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 671, 671, 671, 647, 671, 647, 
	671, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 671, 671, 671, 671, 606, 
	671, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 700, 606, 606, 606, 606, 606, 
	606, 606, 606, 671, 671, 671, 671, 671, 
	606, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 647, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 671, 671, 671, 647, 671, 
	647, 671, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 671, 671, 671, 671, 
	606, 671, 716, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	638, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 671, 671, 671, 671, 
	671, 606, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 647, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 671, 671, 671, 647, 
	671, 647, 671, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 671, 671, 671, 
	671, 606, 671, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 698, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 671, 671, 671, 
	671, 671, 606, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 647, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 671, 671, 671, 
	647, 671, 647, 671, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 671, 671, 
	671, 671, 606, 671, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 684, 606, 606, 
	606, 606, 606, 606, 606, 606, 671, 671, 
	671, 671, 671, 606, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 647, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 671, 671, 
	671, 647, 671, 647, 671, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 671, 
	671, 671, 671, 606, 671, 606, 606, 606, 
	606, 606, 684, 606, 606, 606, 606, 606, 
	606, 606, 684, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 671, 
	671, 671, 671, 671, 606, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 647, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 671, 
	671, 671, 647, 671, 647, 671, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	671, 671, 671, 671, 606, 671, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 717, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	671, 671, 671, 671, 671, 606, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 647, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	671, 671, 671, 647, 671, 647, 671, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 671, 671, 671, 671, 606, 671, 606, 
	606, 606, 718, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 671, 671, 671, 671, 671, 606, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	647, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 671, 671, 671, 647, 671, 647, 671, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 671, 671, 671, 671, 606, 671, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 719, 606, 606, 606, 
	606, 606, 671, 671, 671, 671, 671, 606, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 647, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 671, 671, 671, 647, 671, 647, 
	671, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 671, 671, 671, 671, 606, 
	671, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 700, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 671, 671, 671, 671, 671, 
	606, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 647, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 671, 671, 671, 647, 671, 
	647, 671, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 671, 671, 671, 671, 
	606, 671, 606, 606, 606, 606, 720, 606, 
	606, 606, 721, 606, 606, 606, 606, 606, 
	722, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 671, 671, 671, 671, 
	671, 606, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 647, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 671, 671, 671, 647, 
	671, 647, 671, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 671, 671, 671, 
	671, 606, 671, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 722, 606, 606, 671, 671, 671, 
	671, 671, 606, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 647, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 671, 671, 671, 
	647, 671, 647, 671, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 671, 671, 
	671, 671, 606, 671, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 684, 
	606, 606, 606, 606, 606, 606, 671, 671, 
	671, 671, 671, 606, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 647, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 671, 671, 
	671, 647, 671, 647, 671, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 671, 
	671, 671, 671, 606, 671, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	684, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 671, 
	671, 671, 671, 671, 606, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 647, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 671, 
	671, 671, 647, 671, 647, 671, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	671, 671, 671, 671, 606, 671, 606, 606, 
	606, 606, 723, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	671, 671, 671, 671, 671, 606, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 647, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	671, 671, 671, 647, 671, 647, 671, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 671, 671, 671, 671, 606, 671, 606, 
	606, 606, 724, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 725, 726, 606, 606, 606, 606, 606, 
	606, 671, 671, 671, 671, 671, 606, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	647, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 671, 671, 671, 647, 671, 647, 671, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 671, 671, 671, 671, 606, 671, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 684, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 671, 671, 671, 671, 671, 606, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 647, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 671, 671, 671, 647, 671, 647, 
	671, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 671, 671, 671, 671, 606, 
	671, 606, 606, 727, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 671, 671, 671, 671, 671, 
	606, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 647, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 671, 671, 671, 647, 671, 
	647, 671, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 671, 671, 671, 671, 
	606, 671, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 700, 606, 
	606, 606, 606, 606, 671, 671, 671, 671, 
	671, 606, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 647, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 671, 671, 671, 647, 
	671, 647, 671, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 671, 671, 671, 
	671, 606, 671, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 728, 606, 606, 729, 
	606, 606, 606, 606, 606, 671, 671, 671, 
	671, 671, 606, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 647, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 671, 671, 671, 
	647, 671, 647, 671, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 671, 671, 
	671, 671, 606, 671, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 684, 606, 671, 671, 
	671, 671, 671, 606, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 647, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 671, 671, 
	671, 647, 671, 647, 671, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 671, 
	671, 671, 671, 606, 671, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 695, 606, 
	606, 606, 606, 606, 606, 606, 606, 671, 
	671, 671, 671, 671, 606, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 647, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 671, 
	671, 671, 647, 671, 647, 671, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	671, 671, 671, 671, 606, 671, 606, 606, 
	606, 606, 730, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 731, 606, 606, 606, 606, 606, 
	671, 671, 671, 671, 671, 606, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 647, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	671, 671, 671, 647, 671, 647, 671, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 671, 671, 671, 671, 606, 671, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 713, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 671, 671, 671, 671, 671, 606, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	647, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 671, 671, 671, 647, 671, 647, 671, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 671, 671, 671, 671, 606, 671, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 732, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 671, 671, 671, 671, 671, 606, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 647, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 671, 671, 671, 647, 671, 647, 
	671, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 671, 671, 671, 671, 606, 
	671, 606, 606, 606, 606, 638, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 671, 671, 671, 671, 671, 
	606, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 647, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 671, 671, 671, 647, 671, 
	647, 671, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 671, 671, 671, 671, 
	606, 671, 606, 606, 606, 606, 606, 606, 
	606, 733, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 727, 606, 606, 606, 606, 
	606, 606, 606, 606, 671, 671, 671, 671, 
	671, 606, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 647, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 671, 671, 671, 647, 
	671, 647, 671, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 671, 671, 671, 
	671, 606, 671, 606, 606, 606, 606, 695, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 671, 671, 671, 
	671, 671, 606, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 647, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 671, 671, 671, 
	647, 671, 647, 671, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 671, 671, 
	671, 671, 606, 671, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 734, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 671, 671, 
	671, 671, 671, 606, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 647, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 671, 671, 
	671, 647, 671, 647, 671, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 671, 
	671, 671, 671, 606, 671, 606, 606, 606, 
	735, 606, 606, 606, 606, 606, 606, 606, 
	736, 606, 606, 606, 606, 606, 606, 606, 
	737, 606, 606, 606, 606, 606, 606, 671, 
	671, 671, 671, 671, 606, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 647, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 671, 
	671, 671, 647, 671, 647, 671, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	671, 671, 671, 671, 606, 671, 606, 606, 
	606, 606, 713, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	671, 671, 671, 671, 671, 606, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 647, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	671, 671, 671, 647, 671, 647, 671, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 671, 671, 671, 671, 606, 671, 606, 
	606, 606, 606, 701, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 671, 671, 671, 671, 671, 606, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	647, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 671, 671, 671, 647, 671, 647, 671, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 671, 671, 671, 671, 606, 671, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	721, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 671, 671, 671, 671, 671, 606, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 647, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 671, 671, 671, 647, 671, 647, 
	671, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 671, 671, 671, 671, 606, 
	671, 606, 606, 606, 606, 606, 606, 606, 
	738, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 671, 671, 671, 671, 671, 
	606, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 647, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 671, 671, 671, 647, 671, 
	647, 671, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 671, 671, 671, 671, 
	606, 671, 606, 606, 606, 606, 695, 606, 
	606, 606, 719, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 671, 671, 671, 671, 
	671, 606, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 647, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 671, 671, 671, 647, 
	671, 647, 671, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 671, 671, 671, 
	671, 606, 671, 606, 606, 606, 606, 606, 
	606, 606, 606, 739, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 671, 671, 671, 
	671, 671, 606, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 647, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 671, 671, 671, 
	647, 671, 647, 671, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 671, 671, 
	671, 671, 606, 671, 606, 606, 606, 606, 
	740, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 671, 671, 
	671, 671, 671, 606, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 671, 647, 671, 671, 
	671, 671, 671, 671, 671, 671, 671, 671, 
	671, 671, 671, 671, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 671, 671, 
	671, 647, 671, 647, 671, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 671, 
	671, 671, 671, 606, 671, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 606, 
	689, 606, 606, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 671, 
	671, 671, 671, 671, 606, 618, 650, 742, 
	743, 743, 743, 742, 743, 743, 743, 743, 
	744, 743, 744, 744, 744, 743, 743, 743, 
	743, 743, 743, 743, 743, 743, 743, 743, 
	743, 742, 743, 743, 743, 743, 743, 744, 
	743, 743, 745, 743, 743, 743, 743, 743, 
	743, 743, 743, 743, 743, 746, 743, 743, 
	743, 743, 743, 743, 743, 743, 743, 743, 
	743, 743, 743, 743, 743, 743, 743, 743, 
	741, 741, 741, 741, 741, 741, 741, 741, 
	741, 741, 741, 741, 741, 741, 741, 741, 
	741, 741, 741, 741, 741, 741, 741, 741, 
	741, 741, 743, 747, 743, 743, 741, 743, 
	741, 741, 741, 741, 741, 741, 741, 741, 
	741, 741, 741, 741, 741, 741, 741, 741, 
	741, 741, 741, 741, 741, 741, 741, 741, 
	741, 741, 743, 743, 743, 743, 743, 741, 
	748, 748, 748, 748, 748, 748, 748, 748, 
	748, 748, 748, 748, 748, 748, 748, 748, 
	748, 748, 748, 748, 748, 748, 748, 748, 
	748, 748, 748, 748, 748, 748, 748, 748, 
	748, 110, 748, 748, 748, 748, 748, 748, 
	748, 748, 748, 748, 748, 748, 748, 748, 
	109, 109, 109, 109, 109, 109, 109, 109, 
	109, 109, 111, 748, 748, 748, 748, 110, 
	748, 109, 109, 109, 109, 109, 109, 109, 
	109, 109, 109, 109, 109, 109, 109, 109, 
	109, 109, 109, 109, 109, 109, 109, 109, 
	109, 109, 109, 748, 748, 748, 748, 109, 
	748, 109, 109, 109, 109, 109, 109, 109, 
	109, 109, 109, 109, 109, 109, 109, 109, 
	109, 109, 109, 109, 109, 109, 109, 109, 
	109, 109, 109, 748, 748, 748, 748, 748, 
	109, 744, 749, 744, 744, 744, 749, 749, 
	749, 749, 749, 749, 749, 749, 749, 749, 
	749, 749, 749, 749, 749, 749, 749, 749, 
	744, 749, 750, 751, 752, 753, 754, 748, 
	755, 748, 756, 758, 759, 759, 759, 758, 
	759, 759, 759, 759, 760, 761, 760, 760, 
	760, 759, 759, 759, 759, 759, 759, 759, 
	759, 759, 759, 759, 759, 758, 759, 759, 
	759, 759, 759, 760, 762, 759, 763, 759, 
	764, 765, 759, 759, 759, 766, 767, 759, 
	767, 759, 764, 759, 759, 759, 759, 759, 
	759, 759, 759, 759, 759, 759, 759, 768, 
	769, 770, 759, 759, 771, 771, 771, 771, 
	771, 771, 771, 771, 771, 771, 771, 771, 
	771, 771, 771, 771, 771, 771, 771, 771, 
	771, 771, 771, 771, 771, 771, 772, 773, 
	759, 764, 757, 764, 757, 757, 757, 757, 
	757, 757, 757, 757, 757, 757, 757, 757, 
	757, 757, 757, 757, 757, 757, 757, 757, 
	757, 757, 757, 757, 757, 757, 759, 774, 
	759, 767, 759, 757, 775, 775, 775, 775, 
	775, 775, 775, 775, 775, 775, 775, 775, 
	775, 775, 775, 775, 775, 775, 775, 775, 
	775, 775, 775, 775, 775, 775, 775, 775, 
	775, 775, 775, 775, 775, 776, 775, 775, 
	775, 775, 775, 775, 775, 775, 775, 775, 
	775, 775, 775, 775, 757, 757, 757, 757, 
	757, 757, 757, 757, 757, 757, 775, 775, 
	775, 775, 775, 776, 775, 757, 757, 757, 
	757, 757, 757, 757, 757, 757, 757, 757, 
	757, 757, 757, 757, 757, 757, 757, 757, 
	757, 757, 757, 757, 757, 757, 757, 775, 
	775, 775, 775, 757, 775, 757, 757, 757, 
	757, 757, 757, 757, 757, 757, 757, 757, 
	757, 757, 757, 757, 757, 757, 757, 757, 
	757, 757, 757, 757, 757, 757, 757, 775, 
	775, 775, 775, 775, 757, 778, 777, 779, 
	760, 780, 760, 760, 760, 780, 780, 780, 
	780, 780, 780, 780, 780, 780, 780, 780, 
	780, 780, 780, 780, 780, 780, 780, 760, 
	780, 781, 764, 782, 782, 764, 782, 782, 
	782, 782, 782, 782, 782, 782, 782, 782, 
	782, 782, 782, 782, 782, 782, 782, 782, 
	782, 782, 782, 782, 782, 782, 782, 782, 
	782, 782, 782, 782, 782, 782, 782, 782, 
	782, 782, 782, 782, 782, 782, 782, 782, 
	782, 782, 782, 782, 782, 782, 782, 782, 
	782, 782, 782, 782, 782, 782, 782, 782, 
	782, 782, 782, 764, 782, 783, 784, 785, 
	786, 764, 782, 764, 782, 764, 782, 764, 
	787, 782, 764, 782, 789, 764, 788, 788, 
	788, 788, 788, 788, 788, 788, 788, 788, 
	788, 788, 788, 788, 788, 788, 788, 788, 
	788, 788, 788, 788, 788, 788, 788, 788, 
	788, 788, 788, 788, 788, 788, 788, 788, 
	788, 788, 788, 788, 788, 788, 788, 788, 
	788, 788, 788, 788, 788, 788, 788, 788, 
	788, 788, 788, 788, 788, 788, 788, 788, 
	788, 788, 788, 788, 788, 764, 788, 764, 
	782, 764, 764, 782, 790, 790, 790, 790, 
	790, 790, 790, 790, 790, 790, 790, 790, 
	790, 790, 790, 790, 790, 790, 790, 790, 
	790, 790, 790, 790, 790, 790, 790, 790, 
	790, 790, 790, 790, 790, 776, 790, 790, 
	790, 790, 790, 790, 790, 790, 790, 790, 
	790, 790, 790, 790, 771, 771, 771, 771, 
	771, 771, 771, 771, 771, 771, 790, 790, 
	790, 790, 790, 776, 790, 771, 771, 771, 
	771, 771, 771, 771, 771, 771, 771, 771, 
	771, 771, 771, 771, 771, 771, 771, 771, 
	771, 771, 771, 771, 771, 771, 771, 790, 
	790, 790, 790, 771, 790, 771, 771, 771, 
	771, 771, 771, 771, 771, 771, 771, 771, 
	771, 771, 771, 771, 771, 771, 771, 771, 
	771, 771, 771, 771, 771, 771, 771, 790, 
	790, 790, 790, 790, 771, 789, 788, 761, 
	788, 764, 782, 792, 791, 791, 791, 792, 
	791, 791, 791, 791, 793, 794, 793, 793, 
	793, 791, 791, 791, 791, 791, 791, 791, 
	791, 791, 791, 791, 791, 792, 791, 791, 
	791, 791, 791, 793, 791, 791, 795, 791, 
	120, 796, 791, 797, 791, 798, 120, 151, 
	799, 153, 120, 791, 791, 791, 791, 791, 
	791, 791, 791, 791, 791, 800, 791, 801, 
	151, 802, 803, 791, 791, 791, 791, 791, 
	791, 791, 791, 791, 791, 791, 791, 791, 
	791, 791, 791, 791, 791, 791, 791, 791, 
	791, 791, 791, 791, 791, 791, 151, 804, 
	151, 120, 791, 791, 791, 791, 791, 791, 
	791, 791, 791, 791, 805, 791, 791, 791, 
	791, 791, 791, 791, 791, 806, 791, 791, 
	807, 791, 808, 791, 791, 791, 164, 165, 
	791, 120, 791, 809, 809, 809, 809, 809, 
	809, 809, 809, 809, 793, 809, 793, 793, 
	793, 809, 809, 809, 809, 809, 809, 809, 
	809, 809, 809, 809, 809, 809, 809, 809, 
	809, 809, 809, 793, 809, 809, 809, 809, 
	146, 147, 809, 148, 809, 149, 150, 151, 
	152, 153, 146, 809, 809, 809, 809, 809, 
	809, 809, 809, 809, 809, 154, 809, 155, 
	151, 156, 157, 809, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 158, 159, 
	151, 120, 115, 809, 115, 115, 115, 115, 
	115, 115, 115, 115, 160, 115, 115, 115, 
	115, 115, 115, 115, 115, 161, 115, 115, 
	162, 115, 163, 115, 115, 115, 164, 165, 
	809, 120, 809, 115, 810, 811, 811, 811, 
	810, 811, 811, 811, 811, 151, 812, 151, 
	151, 151, 811, 811, 811, 811, 811, 811, 
	811, 811, 811, 811, 811, 811, 810, 811, 
	811, 811, 811, 811, 151, 811, 811, 811, 
	811, 811, 811, 811, 811, 811, 811, 811, 
	811, 811, 811, 811, 811, 811, 811, 811, 
	811, 811, 811, 811, 811, 811, 811, 811, 
	811, 151, 811, 151, 812, 151, 151, 151, 
	114, 114, 114, 114, 114, 114, 114, 114, 
	114, 114, 114, 114, 114, 114, 114, 114, 
	114, 114, 151, 114, 114, 114, 114, 114, 
	120, 114, 114, 114, 114, 114, 114, 114, 
	151, 114, 114, 114, 114, 114, 114, 114, 
	114, 114, 114, 114, 114, 114, 114, 151, 
	114, 151, 812, 151, 151, 151, 114, 114, 
	114, 114, 114, 114, 114, 114, 114, 114, 
	114, 114, 114, 114, 114, 114, 114, 114, 
	151, 114, 114, 114, 114, 114, 114, 114, 
	114, 114, 114, 114, 114, 114, 114, 114, 
	114, 114, 114, 114, 114, 114, 114, 114, 
	114, 114, 114, 114, 114, 151, 114, 813, 
	151, 812, 151, 151, 151, 814, 814, 814, 
	814, 814, 814, 814, 814, 814, 814, 814, 
	814, 814, 814, 814, 814, 814, 814, 151, 
	814, 814, 814, 814, 814, 814, 814, 814, 
	814, 815, 814, 814, 814, 814, 814, 814, 
	814, 814, 814, 814, 814, 814, 814, 814, 
	814, 814, 814, 814, 151, 814, 151, 812, 
	151, 151, 151, 114, 114, 114, 114, 114, 
	114, 114, 114, 114, 114, 114, 114, 114, 
	114, 114, 114, 114, 114, 151, 114, 114, 
	114, 114, 114, 114, 114, 114, 114, 114, 
	114, 114, 114, 114, 114, 114, 114, 114, 
	114, 114, 114, 114, 114, 114, 114, 114, 
	114, 114, 151, 151, 114, 816, 810, 151, 
	810, 818, 817, 820, 821, 820, 820, 820, 
	819, 819, 819, 819, 819, 819, 819, 819, 
	819, 819, 819, 819, 819, 819, 819, 819, 
	819, 819, 820, 819, 822, 810, 810, 810, 
	810, 810, 810, 810, 810, 810, 810, 810, 
	810, 810, 810, 810, 810, 810, 810, 810, 
	810, 810, 810, 810, 810, 810, 810, 810, 
	810, 810, 810, 810, 810, 810, 116, 810, 
	810, 810, 810, 810, 810, 810, 810, 810, 
	810, 810, 810, 810, 810, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 117, 
	810, 810, 810, 810, 116, 810, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	810, 810, 810, 810, 115, 810, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	810, 810, 810, 810, 810, 115, 823, 151, 
	812, 151, 151, 151, 810, 810, 810, 810, 
	810, 810, 810, 810, 810, 810, 810, 810, 
	810, 810, 810, 810, 810, 810, 151, 810, 
	810, 810, 810, 810, 810, 810, 810, 810, 
	810, 810, 810, 810, 810, 810, 810, 810, 
	810, 810, 810, 810, 810, 810, 810, 810, 
	810, 810, 810, 151, 810, 810, 810, 810, 
	810, 810, 810, 810, 810, 810, 810, 810, 
	810, 810, 810, 810, 810, 810, 810, 810, 
	810, 810, 810, 810, 810, 810, 810, 810, 
	810, 810, 810, 810, 810, 810, 810, 810, 
	810, 810, 810, 810, 810, 810, 810, 810, 
	810, 810, 810, 810, 810, 810, 810, 810, 
	810, 810, 810, 810, 810, 810, 810, 810, 
	810, 810, 120, 810, 824, 825, 826, 827, 
	828, 829, 151, 812, 151, 151, 151, 810, 
	810, 810, 810, 810, 810, 810, 810, 810, 
	810, 810, 810, 810, 810, 810, 810, 810, 
	810, 151, 810, 810, 810, 810, 810, 810, 
	810, 810, 810, 120, 810, 810, 810, 810, 
	810, 810, 810, 810, 810, 810, 810, 810, 
	810, 810, 810, 810, 810, 810, 151, 810, 
	151, 817, 120, 830, 120, 830, 831, 832, 
	831, 831, 831, 819, 819, 819, 819, 819, 
	819, 819, 819, 819, 819, 819, 819, 819, 
	819, 819, 819, 819, 819, 831, 819, 833, 
	830, 834, 834, 834, 834, 834, 834, 834, 
	834, 834, 123, 834, 123, 123, 123, 834, 
	834, 834, 834, 834, 834, 834, 834, 834, 
	834, 834, 834, 834, 834, 834, 834, 834, 
	834, 123, 834, 834, 834, 834, 124, 125, 
	834, 126, 834, 127, 128, 129, 130, 131, 
	124, 834, 834, 834, 834, 834, 834, 834, 
	834, 834, 834, 132, 834, 133, 129, 134, 
	135, 834, 122, 122, 122, 122, 122, 122, 
	122, 122, 122, 122, 122, 122, 122, 122, 
	122, 122, 122, 122, 122, 122, 122, 122, 
	122, 122, 122, 122, 136, 137, 129, 138, 
	122, 834, 122, 122, 122, 122, 122, 122, 
	122, 122, 139, 122, 122, 122, 122, 122, 
	122, 122, 122, 140, 122, 122, 141, 122, 
	142, 122, 122, 122, 143, 144, 834, 138, 
	834, 122, 151, 830, 835, 830, 836, 830, 
	837, 830, 838, 190, 190, 190, 838, 190, 
	190, 190, 190, 839, 190, 839, 839, 839, 
	190, 190, 190, 190, 190, 190, 190, 190, 
	190, 190, 190, 190, 838, 190, 190, 190, 
	190, 190, 839, 190, 190, 190, 190, 190, 
	190, 190, 190, 190, 190, 190, 190, 190, 
	190, 190, 190, 190, 190, 190, 190, 190, 
	190, 190, 190, 190, 190, 190, 190, 190, 
	190, 190, 190, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 190, 840, 190, 
	190, 192, 190, 192, 192, 192, 196, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 190, 190, 190, 
	190, 190, 192, 189, 189, 189, 189, 189, 
	189, 189, 189, 189, 189, 189, 189, 189, 
	189, 189, 189, 189, 189, 189, 189, 189, 
	189, 189, 189, 189, 189, 189, 189, 189, 
	189, 189, 189, 189, 841, 189, 189, 189, 
	189, 189, 189, 189, 189, 189, 189, 189, 
	189, 189, 189, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 190, 189, 189, 
	189, 189, 841, 189, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 189, 189, 
	189, 189, 192, 189, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 189, 189, 
	189, 189, 189, 192, 842, 842, 842, 842, 
	842, 842, 842, 842, 842, 193, 842, 193, 
	193, 193, 842, 842, 842, 842, 842, 842, 
	842, 842, 842, 842, 842, 842, 842, 842, 
	842, 842, 842, 842, 193, 842, 842, 842, 
	842, 842, 842, 842, 194, 842, 842, 842, 
	842, 842, 842, 842, 842, 842, 842, 842, 
	842, 842, 842, 842, 842, 842, 842, 842, 
	842, 842, 842, 842, 842, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 842, 
	195, 842, 842, 192, 842, 192, 192, 192, 
	196, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 842, 
	842, 842, 842, 842, 192, 843, 842, 842, 
	842, 842, 842, 842, 842, 842, 842, 842, 
	842, 842, 842, 842, 842, 842, 842, 842, 
	842, 842, 842, 842, 842, 842, 842, 842, 
	842, 842, 842, 842, 842, 842, 842, 841, 
	842, 842, 842, 842, 842, 842, 842, 842, 
	842, 842, 842, 842, 842, 842, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	190, 842, 842, 842, 842, 841, 842, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 842, 842, 842, 842, 192, 842, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 844, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 842, 842, 842, 842, 842, 192, 197, 
	842, 846, 845, 845, 845, 846, 845, 845, 
	845, 845, 847, 845, 847, 847, 847, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 846, 845, 845, 845, 845, 
	845, 847, 845, 845, 848, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 849, 845, 845, 
	845, 845, 845, 845, 845, 850, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 845, 845, 845, 845, 
	845, 845, 845, 845, 851, 845, 847, 852, 
	847, 847, 847, 852, 852, 852, 852, 852, 
	852, 852, 852, 852, 852, 852, 852, 852, 
	852, 852, 852, 852, 852, 847, 852, 853, 
	854, 855, 856, 858, 857, 859, 860, 857, 
	861, 863, 864, 864, 864, 863, 864, 864, 
	864, 864, 865, 866, 865, 865, 865, 864, 
	864, 864, 864, 864, 864, 864, 864, 864, 
	864, 864, 864, 863, 864, 864, 864, 864, 
	864, 865, 864, 864, 867, 864, 864, 864, 
	864, 864, 864, 864, 864, 864, 864, 864, 
	864, 864, 864, 864, 864, 864, 864, 864, 
	864, 864, 864, 864, 864, 864, 864, 864, 
	864, 864, 862, 862, 862, 862, 862, 862, 
	862, 862, 862, 862, 862, 862, 862, 862, 
	862, 862, 862, 862, 862, 862, 862, 862, 
	862, 862, 862, 862, 864, 868, 864, 864, 
	862, 864, 862, 862, 862, 862, 862, 862, 
	862, 862, 869, 862, 862, 862, 862, 862, 
	862, 862, 862, 870, 862, 862, 871, 862, 
	872, 862, 862, 862, 864, 864, 864, 864, 
	864, 862, 873, 873, 873, 873, 873, 873, 
	873, 873, 873, 873, 873, 873, 873, 873, 
	873, 873, 873, 873, 873, 873, 873, 873, 
	873, 873, 873, 873, 873, 873, 873, 873, 
	873, 873, 873, 873, 873, 873, 873, 873, 
	873, 873, 873, 873, 873, 873, 873, 873, 
	873, 873, 862, 862, 862, 862, 862, 862, 
	862, 862, 862, 862, 873, 873, 873, 873, 
	873, 873, 873, 862, 862, 862, 862, 862, 
	862, 862, 862, 862, 862, 862, 862, 862, 
	862, 862, 862, 862, 862, 862, 862, 862, 
	862, 862, 862, 862, 862, 873, 873, 873, 
	873, 862, 873, 862, 862, 862, 862, 862, 
	862, 862, 862, 862, 862, 862, 862, 862, 
	862, 862, 862, 862, 862, 862, 862, 862, 
	862, 862, 862, 862, 862, 873, 873, 873, 
	873, 873, 862, 865, 874, 865, 865, 865, 
	874, 874, 874, 874, 874, 874, 874, 874, 
	874, 874, 874, 874, 874, 874, 874, 874, 
	874, 874, 865, 874, 875, 876, 877, 878, 
	879, 881, 880, 882, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 862, 862, 862, 862, 
	862, 862, 862, 862, 862, 862, 883, 883, 
	883, 883, 883, 883, 883, 862, 862, 862, 
	862, 862, 862, 862, 862, 862, 862, 862, 
	862, 862, 862, 862, 862, 862, 862, 862, 
	862, 862, 862, 862, 862, 862, 862, 883, 
	883, 883, 883, 862, 883, 862, 862, 862, 
	862, 862, 884, 862, 862, 862, 862, 862, 
	862, 862, 862, 862, 862, 862, 862, 862, 
	862, 862, 862, 862, 862, 862, 862, 883, 
	883, 883, 883, 883, 862, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 862, 862, 862, 
	862, 862, 862, 862, 862, 862, 862, 883, 
	883, 883, 883, 883, 883, 883, 862, 862, 
	862, 862, 862, 862, 862, 862, 862, 862, 
	862, 862, 862, 862, 862, 862, 862, 862, 
	862, 862, 862, 862, 862, 862, 862, 862, 
	883, 883, 883, 883, 862, 883, 862, 862, 
	862, 862, 885, 862, 862, 862, 862, 862, 
	862, 862, 862, 862, 862, 862, 862, 862, 
	862, 862, 862, 862, 862, 862, 862, 862, 
	883, 883, 883, 883, 883, 862, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 862, 862, 
	862, 862, 862, 862, 862, 862, 862, 862, 
	883, 883, 883, 883, 883, 883, 883, 862, 
	862, 862, 862, 862, 862, 862, 862, 862, 
	862, 862, 862, 862, 862, 862, 862, 862, 
	862, 862, 862, 862, 862, 862, 862, 862, 
	862, 883, 883, 883, 883, 862, 883, 862, 
	862, 862, 862, 862, 862, 862, 862, 862, 
	862, 862, 862, 862, 862, 862, 862, 862, 
	862, 886, 862, 862, 862, 862, 862, 862, 
	862, 883, 883, 883, 883, 883, 862, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 862, 
	862, 862, 862, 862, 862, 862, 862, 862, 
	862, 883, 883, 883, 883, 883, 883, 883, 
	862, 862, 862, 862, 862, 862, 862, 862, 
	862, 862, 862, 862, 862, 862, 862, 862, 
	862, 862, 862, 862, 862, 862, 862, 862, 
	862, 862, 883, 883, 883, 883, 862, 883, 
	862, 862, 887, 862, 862, 862, 862, 862, 
	862, 862, 862, 862, 862, 862, 862, 862, 
	862, 862, 862, 862, 862, 862, 862, 862, 
	862, 862, 883, 883, 883, 883, 883, 862, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	862, 862, 862, 862, 862, 862, 862, 862, 
	862, 862, 883, 883, 883, 883, 883, 883, 
	883, 862, 862, 862, 862, 862, 862, 862, 
	862, 862, 862, 862, 862, 862, 862, 862, 
	862, 862, 862, 862, 862, 862, 862, 862, 
	862, 862, 862, 883, 883, 883, 883, 862, 
	883, 862, 862, 862, 862, 862, 862, 862, 
	862, 862, 862, 862, 862, 862, 862, 862, 
	862, 862, 862, 862, 862, 888, 862, 862, 
	862, 862, 862, 883, 883, 883, 883, 883, 
	862, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 862, 862, 862, 862, 862, 862, 862, 
	862, 862, 862, 883, 883, 883, 883, 883, 
	883, 883, 862, 862, 862, 862, 862, 862, 
	862, 862, 862, 862, 862, 862, 862, 862, 
	862, 862, 862, 862, 862, 862, 862, 862, 
	862, 862, 862, 862, 883, 883, 883, 883, 
	862, 883, 862, 862, 862, 862, 884, 862, 
	862, 862, 862, 862, 862, 862, 862, 862, 
	862, 862, 862, 862, 862, 862, 862, 862, 
	862, 862, 862, 862, 883, 883, 883, 883, 
	883, 862, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 862, 862, 862, 862, 862, 862, 
	862, 862, 862, 862, 883, 883, 883, 883, 
	883, 883, 883, 862, 862, 862, 862, 862, 
	862, 862, 862, 862, 862, 862, 862, 862, 
	862, 862, 862, 862, 862, 862, 862, 862, 
	862, 862, 862, 862, 862, 883, 883, 883, 
	883, 862, 883, 862, 862, 862, 862, 862, 
	862, 862, 862, 862, 862, 862, 862, 862, 
	889, 862, 862, 862, 862, 862, 862, 862, 
	862, 862, 862, 862, 862, 883, 883, 883, 
	883, 883, 862, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 862, 862, 862, 862, 862, 
	862, 862, 862, 862, 862, 883, 883, 883, 
	883, 883, 883, 883, 862, 862, 862, 862, 
	862, 862, 862, 862, 862, 862, 862, 862, 
	862, 862, 862, 862, 862, 862, 862, 862, 
	862, 862, 862, 862, 862, 862, 883, 883, 
	883, 883, 862, 883, 862, 862, 862, 862, 
	862, 862, 862, 862, 862, 862, 862, 890, 
	862, 862, 862, 862, 862, 862, 862, 891, 
	862, 862, 862, 862, 862, 862, 883, 883, 
	883, 883, 883, 862, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 862, 862, 862, 862, 
	862, 862, 862, 862, 862, 862, 883, 883, 
	883, 883, 883, 883, 883, 862, 862, 862, 
	862, 862, 862, 862, 862, 862, 862, 862, 
	862, 862, 862, 862, 862, 862, 862, 862, 
	862, 862, 862, 862, 862, 862, 862, 883, 
	883, 883, 883, 862, 883, 862, 862, 862, 
	862, 892, 862, 862, 862, 862, 862, 862, 
	862, 862, 862, 862, 862, 862, 862, 862, 
	862, 862, 862, 862, 862, 862, 862, 883, 
	883, 883, 883, 883, 862, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 862, 862, 862, 
	862, 862, 862, 862, 862, 862, 862, 883, 
	883, 883, 883, 883, 883, 883, 862, 862, 
	862, 862, 862, 862, 862, 862, 862, 862, 
	862, 862, 862, 862, 862, 862, 862, 862, 
	862, 862, 862, 862, 862, 862, 862, 862, 
	883, 883, 883, 883, 862, 883, 862, 862, 
	862, 862, 862, 862, 862, 862, 862, 862, 
	862, 862, 862, 862, 862, 862, 862, 862, 
	893, 862, 862, 862, 862, 862, 862, 862, 
	883, 883, 883, 883, 883, 862, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 862, 862, 
	862, 862, 862, 862, 862, 862, 862, 862, 
	883, 883, 883, 883, 883, 883, 883, 862, 
	862, 862, 862, 862, 862, 862, 862, 862, 
	862, 862, 862, 862, 862, 862, 862, 862, 
	862, 862, 862, 862, 862, 862, 862, 862, 
	862, 883, 883, 883, 883, 862, 883, 862, 
	862, 862, 862, 862, 862, 862, 862, 862, 
	862, 862, 862, 862, 862, 862, 862, 862, 
	862, 884, 862, 862, 862, 862, 862, 862, 
	862, 883, 883, 883, 883, 883, 862, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 862, 
	862, 862, 862, 862, 862, 862, 862, 862, 
	862, 883, 883, 883, 883, 883, 883, 883, 
	862, 862, 862, 862, 862, 862, 862, 862, 
	862, 862, 862, 862, 862, 862, 862, 862, 
	862, 862, 862, 862, 862, 862, 862, 862, 
	862, 862, 883, 883, 883, 883, 862, 883, 
	862, 862, 862, 862, 862, 862, 862, 862, 
	894, 862, 862, 862, 862, 862, 862, 862, 
	862, 862, 862, 862, 862, 862, 862, 862, 
	862, 862, 883, 883, 883, 883, 883, 862, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	862, 862, 862, 862, 862, 862, 862, 862, 
	862, 862, 883, 883, 883, 883, 883, 883, 
	883, 862, 862, 862, 862, 862, 862, 862, 
	862, 862, 862, 862, 862, 862, 862, 862, 
	862, 862, 862, 862, 862, 862, 862, 862, 
	862, 862, 862, 883, 883, 883, 883, 862, 
	883, 862, 862, 862, 862, 862, 862, 862, 
	862, 862, 862, 862, 884, 862, 862, 862, 
	862, 862, 862, 862, 862, 862, 862, 862, 
	862, 862, 862, 883, 883, 883, 883, 883, 
	862, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 862, 862, 862, 862, 862, 862, 862, 
	862, 862, 862, 883, 883, 883, 883, 883, 
	883, 883, 862, 862, 862, 862, 862, 862, 
	862, 862, 862, 862, 862, 862, 862, 862, 
	862, 862, 862, 862, 862, 862, 862, 862, 
	862, 862, 862, 862, 883, 883, 883, 883, 
	862, 883, 862, 862, 862, 862, 862, 862, 
	862, 895, 862, 862, 862, 862, 862, 862, 
	862, 862, 862, 862, 862, 862, 862, 862, 
	862, 862, 862, 862, 883, 883, 883, 883, 
	883, 862, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 862, 862, 862, 862, 862, 862, 
	862, 862, 862, 862, 883, 883, 883, 883, 
	883, 883, 883, 862, 862, 862, 862, 862, 
	862, 862, 862, 862, 862, 862, 862, 862, 
	862, 862, 862, 862, 862, 862, 862, 862, 
	862, 862, 862, 862, 862, 883, 883, 883, 
	883, 862, 883, 862, 862, 862, 862, 862, 
	862, 862, 862, 896, 862, 862, 862, 862, 
	862, 862, 862, 862, 862, 862, 862, 862, 
	862, 862, 862, 862, 862, 883, 883, 883, 
	883, 883, 862, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 883, 883, 883, 883, 883, 
	883, 883, 883, 862, 862, 862, 862, 862, 
	862, 862, 862, 862, 862, 883, 883, 883, 
	883, 883, 883, 883, 862, 862, 862, 862, 
	862, 862, 862, 862, 862, 862, 862, 862, 
	862, 862, 862, 862, 862, 862, 862, 862, 
	862, 862, 862, 862, 862, 862, 883, 883, 
	883, 883, 862, 883, 862, 862, 862, 862, 
	862, 862, 862, 862, 862, 862, 862, 888, 
	862, 862, 862, 862, 862, 862, 862, 862, 
	862, 862, 862, 862, 862, 862, 883, 883, 
	883, 883, 883, 862, 898, 221, 221, 221, 
	898, 221, 221, 221, 221, 899, 900, 899, 
	899, 899, 221, 221, 221, 221, 221, 221, 
	221, 221, 221, 221, 221, 221, 898, 221, 
	221, 221, 221, 221, 899, 901, 221, 902, 
	221, 903, 904, 221, 905, 221, 906, 907, 
	221, 908, 909, 910, 221, 221, 221, 221, 
	221, 221, 221, 221, 221, 221, 911, 221, 
	912, 913, 914, 915, 221, 916, 917, 916, 
	916, 918, 916, 916, 916, 916, 916, 916, 
	916, 916, 916, 916, 916, 916, 916, 916, 
	916, 916, 916, 916, 916, 916, 916, 919, 
	920, 221, 921, 922, 221, 923, 924, 925, 
	926, 927, 928, 897, 897, 929, 897, 897, 
	897, 930, 931, 932, 897, 897, 933, 934, 
	935, 936, 897, 937, 897, 938, 897, 939, 
	940, 221, 921, 221, 897, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 942, 941, 
	942, 942, 942, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 942, 296, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 297, 
	941, 941, 298, 941, 296, 941, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	941, 943, 941, 941, 897, 941, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	941, 941, 941, 941, 941, 897, 945, 944, 
	944, 946, 944, 947, 949, 950, 948, 948, 
	948, 948, 948, 948, 948, 948, 948, 948, 
	948, 948, 948, 948, 948, 948, 948, 948, 
	948, 948, 948, 948, 948, 948, 948, 948, 
	948, 948, 948, 948, 948, 948, 948, 948, 
	948, 948, 948, 948, 948, 948, 948, 948, 
	948, 948, 948, 948, 948, 948, 948, 948, 
	948, 948, 948, 948, 948, 948, 948, 948, 
	948, 948, 948, 948, 948, 951, 948, 953, 
	952, 954, 955, 956, 899, 957, 899, 899, 
	899, 957, 957, 957, 957, 957, 957, 957, 
	957, 957, 957, 957, 957, 957, 957, 957, 
	957, 957, 957, 899, 957, 959, 958, 961, 
	962, 961, 961, 961, 960, 960, 960, 960, 
	960, 960, 960, 960, 960, 960, 960, 960, 
	960, 960, 960, 960, 960, 960, 961, 960, 
	221, 963, 963, 963, 963, 963, 963, 963, 
	963, 963, 963, 963, 963, 963, 963, 963, 
	963, 963, 963, 963, 963, 963, 963, 963, 
	963, 963, 963, 963, 963, 963, 963, 963, 
	963, 963, 963, 963, 963, 963, 963, 963, 
	963, 963, 963, 963, 963, 963, 963, 963, 
	963, 963, 963, 963, 963, 963, 963, 963, 
	963, 963, 963, 963, 963, 963, 963, 963, 
	963, 221, 963, 964, 965, 966, 967, 969, 
	969, 969, 969, 969, 969, 969, 969, 969, 
	969, 969, 969, 969, 969, 969, 969, 969, 
	969, 969, 969, 969, 969, 969, 969, 969, 
	969, 969, 969, 969, 969, 969, 969, 969, 
	969, 969, 969, 969, 969, 969, 969, 969, 
	969, 969, 969, 969, 969, 969, 969, 968, 
	968, 968, 968, 968, 968, 968, 968, 968, 
	968, 969, 969, 969, 969, 969, 969, 969, 
	970, 970, 970, 970, 970, 970, 970, 970, 
	970, 970, 970, 970, 970, 970, 970, 970, 
	970, 970, 970, 970, 970, 970, 970, 970, 
	970, 970, 969, 969, 969, 969, 969, 969, 
	970, 970, 970, 970, 970, 970, 970, 970, 
	970, 970, 970, 970, 970, 970, 970, 970, 
	970, 970, 970, 970, 970, 970, 970, 970, 
	970, 970, 969, 969, 969, 969, 969, 968, 
	972, 971, 971, 971, 971, 971, 971, 971, 
	971, 971, 971, 971, 971, 971, 971, 971, 
	971, 971, 971, 971, 971, 971, 971, 221, 
	971, 973, 975, 974, 974, 974, 974, 974, 
	974, 974, 974, 974, 974, 974, 974, 974, 
	974, 974, 974, 974, 974, 221, 974, 221, 
	211, 222, 223, 222, 222, 222, 971, 971, 
	971, 971, 971, 971, 971, 971, 971, 971, 
	971, 971, 971, 971, 971, 971, 971, 971, 
	222, 971, 971, 224, 971, 971, 971, 971, 
	971, 971, 971, 971, 971, 971, 971, 971, 
	225, 225, 225, 225, 225, 225, 225, 225, 
	225, 225, 971, 971, 971, 221, 971, 971, 
	971, 971, 971, 971, 971, 971, 971, 971, 
	971, 971, 971, 971, 971, 971, 971, 971, 
	971, 971, 971, 971, 971, 971, 971, 971, 
	971, 971, 971, 971, 226, 971, 239, 240, 
	239, 239, 239, 238, 238, 238, 238, 238, 
	238, 238, 238, 238, 238, 238, 238, 238, 
	238, 238, 238, 238, 238, 239, 238, 238, 
	241, 238, 238, 238, 238, 238, 238, 238, 
	238, 238, 238, 238, 238, 242, 242, 242, 
	242, 242, 242, 242, 242, 242, 242, 238, 
	238, 238, 238, 238, 238, 238, 238, 238, 
	238, 238, 238, 238, 238, 238, 238, 238, 
	238, 238, 238, 238, 238, 238, 238, 238, 
	238, 238, 238, 238, 238, 238, 238, 238, 
	238, 243, 238, 222, 223, 222, 222, 222, 
	971, 971, 971, 971, 971, 971, 971, 971, 
	971, 971, 971, 971, 971, 971, 971, 971, 
	971, 971, 222, 971, 971, 224, 971, 971, 
	971, 971, 971, 971, 971, 971, 971, 971, 
	971, 971, 225, 225, 225, 225, 225, 225, 
	225, 225, 225, 225, 971, 971, 971, 221, 
	221, 971, 971, 971, 971, 971, 971, 971, 
	971, 971, 971, 971, 971, 971, 971, 971, 
	971, 971, 971, 971, 971, 971, 971, 971, 
	971, 971, 971, 971, 971, 971, 226, 971, 
	977, 963, 979, 978, 981, 980, 963, 982, 
	982, 982, 963, 982, 982, 982, 982, 982, 
	982, 982, 982, 982, 982, 982, 982, 982, 
	982, 982, 982, 982, 982, 982, 982, 982, 
	963, 982, 963, 963, 963, 963, 963, 963, 
	963, 963, 963, 963, 963, 963, 963, 963, 
	963, 963, 963, 963, 963, 963, 963, 963, 
	963, 963, 963, 963, 963, 963, 963, 963, 
	963, 963, 963, 984, 985, 963, 986, 247, 
	987, 985, 963, 963, 988, 989, 963, 989, 
	963, 247, 963, 963, 963, 963, 963, 963, 
	963, 963, 963, 963, 990, 963, 991, 992, 
	993, 963, 994, 983, 983, 983, 983, 983, 
	983, 983, 983, 983, 983, 983, 983, 983, 
	983, 983, 983, 983, 983, 983, 983, 983, 
	983, 983, 983, 983, 983, 995, 963, 963, 
	247, 983, 247, 983, 983, 983, 983, 983, 
	983, 983, 983, 983, 983, 983, 983, 983, 
	983, 983, 983, 983, 983, 983, 983, 983, 
	983, 983, 983, 983, 983, 963, 996, 963, 
	997, 963, 983, 998, 998, 998, 998, 998, 
	998, 998, 998, 998, 998, 998, 998, 998, 
	998, 998, 998, 998, 998, 998, 998, 998, 
	998, 998, 998, 998, 998, 998, 998, 998, 
	998, 998, 998, 998, 999, 998, 998, 998, 
	998, 998, 998, 998, 998, 998, 998, 998, 
	998, 998, 998, 983, 983, 983, 983, 983, 
	983, 983, 983, 983, 983, 998, 998, 998, 
	1000, 998, 999, 998, 983, 983, 983, 983, 
	983, 983, 983, 983, 983, 983, 983, 983, 
	983, 983, 983, 983, 983, 983, 983, 983, 
	983, 983, 983, 983, 983, 983, 998, 998, 
	998, 998, 983, 998, 983, 983, 983, 983, 
	983, 983, 983, 983, 983, 983, 983, 983, 
	983, 983, 983, 983, 983, 983, 983, 983, 
	983, 983, 983, 983, 983, 983, 998, 998, 
	998, 998, 998, 983, 1002, 1001, 1003, 1005, 
	1006, 1004, 1004, 1004, 1004, 1004, 1004, 1004, 
	1004, 1004, 1004, 1004, 1004, 1004, 1004, 1004, 
	1004, 1004, 1004, 1004, 1004, 1004, 1004, 1004, 
	1004, 1004, 1004, 1004, 1004, 1004, 1004, 1004, 
	1004, 1004, 1004, 1004, 1004, 1004, 1004, 1004, 
	1004, 1004, 1004, 1004, 1004, 1004, 1004, 1004, 
	1004, 1004, 1004, 1004, 1004, 1004, 1004, 1004, 
	1004, 1004, 1004, 1004, 1004, 1004, 1004, 1004, 
	1007, 1004, 1009, 1010, 1008, 1011, 1012, 1013, 
	1014, 247, 998, 998, 1015, 998, 998, 998, 
	998, 998, 998, 998, 998, 998, 998, 998, 
	998, 998, 998, 998, 998, 998, 998, 998, 
	998, 998, 998, 998, 998, 998, 998, 998, 
	998, 998, 998, 998, 998, 998, 998, 998, 
	998, 998, 998, 998, 998, 998, 998, 998, 
	998, 998, 998, 998, 998, 998, 998, 998, 
	998, 998, 998, 998, 998, 998, 998, 998, 
	998, 998, 247, 998, 998, 998, 998, 998, 
	998, 998, 998, 998, 998, 998, 998, 998, 
	998, 998, 998, 998, 998, 998, 998, 998, 
	998, 998, 998, 998, 998, 998, 998, 998, 
	998, 998, 998, 998, 998, 998, 998, 998, 
	998, 998, 998, 998, 998, 998, 998, 998, 
	998, 998, 998, 998, 246, 246, 246, 246, 
	246, 246, 246, 246, 246, 246, 998, 998, 
	998, 998, 998, 998, 998, 246, 246, 246, 
	246, 246, 246, 246, 246, 246, 246, 246, 
	246, 246, 246, 246, 246, 246, 246, 246, 
	246, 246, 246, 246, 246, 246, 246, 998, 
	998, 998, 998, 246, 998, 246, 246, 246, 
	246, 246, 246, 246, 246, 246, 246, 246, 
	246, 246, 246, 246, 246, 246, 246, 246, 
	246, 246, 246, 246, 246, 246, 246, 998, 
	998, 998, 998, 998, 246, 249, 249, 249, 
	249, 249, 249, 249, 249, 249, 249, 998, 
	1016, 998, 247, 998, 247, 998, 247, 1017, 
	998, 247, 998, 247, 998, 247, 247, 998, 
	1018, 1018, 1018, 1018, 1018, 1018, 1018, 1018, 
	1018, 1018, 1018, 1018, 1018, 1018, 1018, 1018, 
	1018, 1018, 1018, 1018, 1018, 1018, 1018, 1018, 
	1018, 1018, 1018, 1018, 1018, 1018, 1018, 1018, 
	1018, 1018, 1018, 1018, 1018, 1018, 1018, 1018, 
	1018, 1018, 1018, 1018, 1018, 1018, 1018, 1018, 
	1020, 1020, 1020, 1020, 1020, 1020, 1020, 1020, 
	1020, 1020, 1018, 1018, 1018, 1018, 1018, 1018, 
	1021, 1019, 1019, 1019, 1019, 1019, 1019, 1019, 
	1019, 1019, 1019, 1019, 1019, 1019, 1019, 1019, 
	1019, 1019, 1019, 1019, 1019, 1019, 1019, 1019, 
	1019, 1019, 1019, 1018, 1018, 1018, 1018, 1019, 
	1018, 1019, 1019, 1019, 1019, 1019, 1019, 1019, 
	1019, 1019, 1019, 1019, 1019, 1019, 1019, 1019, 
	1019, 1019, 1019, 1019, 1019, 1019, 1019, 1019, 
	1019, 1019, 1019, 1018, 1018, 1018, 1018, 1018, 
	1019, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 
	1023, 1023, 1023, 1022, 1024, 1024, 1024, 1024, 
	1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 
	1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 
	1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 
	1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 
	1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 
	1024, 1024, 1024, 1024, 1026, 1026, 1026, 1026, 
	1026, 1026, 1026, 1026, 1026, 1026, 1024, 1024, 
	1024, 1024, 1024, 1024, 1024, 1025, 1025, 1025, 
	1025, 1025, 1025, 1025, 1025, 1025, 1025, 1025, 
	1025, 1025, 1025, 1025, 1025, 1025, 1025, 1025, 
	1025, 1025, 1025, 1025, 1025, 1025, 1025, 1024, 
	1024, 1024, 1024, 1025, 1024, 1025, 1025, 1025, 
	1025, 1025, 1025, 1025, 1025, 1025, 1025, 1025, 
	1025, 1025, 1025, 1025, 1025, 1025, 1025, 1025, 
	1025, 1025, 1025, 1025, 1025, 1025, 1025, 1024, 
	1024, 1024, 1024, 1024, 1025, 1016, 998, 1015, 
	998, 1027, 1028, 963, 1029, 262, 252, 252, 
	252, 252, 252, 252, 252, 252, 252, 252, 
	252, 252, 252, 252, 252, 252, 252, 252, 
	252, 252, 252, 252, 252, 263, 252, 264, 
	253, 253, 253, 253, 253, 253, 253, 253, 
	253, 253, 253, 253, 253, 253, 253, 253, 
	253, 253, 253, 253, 253, 253, 253, 253, 
	253, 253, 253, 253, 263, 253, 263, 266, 
	221, 963, 921, 221, 963, 963, 963, 963, 
	963, 963, 963, 963, 963, 963, 963, 963, 
	963, 963, 963, 963, 963, 963, 963, 963, 
	963, 963, 963, 963, 963, 963, 963, 963, 
	963, 963, 963, 963, 963, 963, 963, 963, 
	963, 963, 963, 963, 963, 963, 963, 963, 
	963, 963, 963, 963, 963, 963, 963, 963, 
	963, 963, 963, 963, 963, 963, 963, 963, 
	963, 963, 963, 221, 963, 221, 972, 963, 
	1033, 1032, 1032, 1032, 1033, 1032, 1032, 1032, 
	1032, 1034, 1035, 1034, 1034, 1034, 1032, 1032, 
	1032, 1032, 1032, 1032, 1032, 1032, 1032, 1032, 
	1032, 1032, 1033, 1032, 1032, 1032, 1032, 1032, 
	1034, 1032, 1032, 1032, 1032, 1032, 1032, 1032, 
	1032, 1032, 1032, 1032, 1032, 1032, 1032, 1032, 
	1032, 1032, 1032, 1032, 1032, 1032, 1032, 1032, 
	1032, 1032, 1032, 1032, 1032, 1032, 1032, 1032, 
	1032, 1036, 1036, 1036, 1036, 1036, 1036, 1036, 
	1036, 1036, 1036, 1036, 1036, 1036, 1036, 1036, 
	1036, 1036, 1036, 1036, 1036, 1036, 1036, 1036, 
	1036, 1036, 1036, 1032, 1037, 1032, 1032, 1036, 
	1032, 1036, 1036, 1036, 1036, 1036, 1036, 1036, 
	1036, 1036, 1036, 1036, 1036, 1036, 1036, 1036, 
	1036, 1036, 1036, 1036, 1036, 1036, 1036, 1036, 
	1036, 1036, 1036, 1032, 1038, 1038, 1038, 1038, 
	1038, 1038, 1038, 1038, 1038, 1038, 1038, 1038, 
	1038, 1038, 1038, 1038, 1038, 1038, 1038, 1038, 
	1038, 1038, 1038, 1038, 1038, 1038, 1038, 1038, 
	1038, 1038, 1038, 1038, 1038, 1038, 1038, 1038, 
	1038, 1038, 1038, 1038, 1038, 1038, 1038, 1038, 
	1038, 1038, 1038, 1038, 1038, 1038, 1038, 1038, 
	1038, 1038, 1038, 1038, 1038, 1038, 1038, 1038, 
	1038, 1038, 1038, 1038, 1038, 1038, 1039, 1039, 
	1039, 1039, 1039, 1039, 1039, 1039, 1039, 1039, 
	1039, 1039, 1039, 1039, 1039, 1039, 1039, 1039, 
	1039, 1039, 1039, 1039, 1039, 1039, 1039, 1039, 
	1038, 1038, 1038, 1038, 1039, 1038, 1039, 1039, 
	1039, 1039, 1039, 1039, 1039, 1039, 1039, 1039, 
	1039, 1039, 1039, 1039, 1039, 1039, 1039, 1039, 
	1039, 1039, 1039, 1039, 1039, 1039, 1039, 1039, 
	1038, 1038, 1038, 1038, 1038, 1039, 1040, 1040, 
	1040, 1040, 1040, 1040, 1040, 1040, 1040, 1040, 
	1040, 1040, 1040, 1040, 1040, 1040, 1040, 1040, 
	1040, 1040, 1040, 1040, 1040, 1040, 1040, 1040, 
	1040, 1040, 1040, 1040, 1040, 1040, 1040, 1040, 
	1040, 1040, 1040, 1040, 1040, 1040, 1040, 1040, 
	1040, 1040, 1040, 1040, 1040, 1040, 1041, 1041, 
	1041, 1041, 1041, 1041, 1041, 1041, 1041, 1041, 
	1040, 1040, 1040, 1040, 1040, 1040, 1040, 1041, 
	1041, 1041, 1041, 1041, 1041, 1041, 1041, 1041, 
	1041, 1041, 1041, 1041, 1041, 1041, 1041, 1041, 
	1041, 1041, 1041, 1041, 1041, 1041, 1041, 1041, 
	1041, 1040, 1040, 1040, 1040, 1041, 1040, 1041, 
	1041, 1041, 1041, 1041, 1041, 1041, 1041, 1041, 
	1041, 1041, 1041, 1041, 1041, 1041, 1041, 1041, 
	1041, 1041, 1041, 1041, 1041, 1041, 1041, 1041, 
	1041, 1040, 1040, 1040, 1040, 1040, 1041, 1044, 
	1043, 1043, 1043, 1044, 1043, 1043, 1043, 1043, 
	1043, 1043, 1043, 1043, 1043, 1043, 1043, 1043, 
	1043, 1043, 1043, 1043, 1043, 1043, 1043, 1043, 
	1043, 1044, 1043, 1043, 1043, 1043, 1043, 1043, 
	1043, 1043, 1043, 1043, 1043, 1043, 1043, 1043, 
	1043, 1043, 1043, 1043, 1043, 1043, 1043, 1045, 
	1045, 1045, 1045, 1045, 1045, 1045, 1045, 1043, 
	1043, 1043, 1043, 1043, 1043, 1043, 1043, 1043, 
	1043, 1043, 1046, 1043, 1043, 1043, 1043, 1043, 
	1043, 1043, 1043, 1043, 1047, 1043, 1043, 1043, 
	1043, 1043, 1043, 1043, 1043, 1043, 1043, 1043, 
	1043, 1043, 1043, 1043, 1043, 1043, 1043, 1043, 
	1043, 1043, 1048, 1043, 1043, 1043, 1043, 1043, 
	1043, 1043, 1043, 1043, 1043, 1043, 1043, 1043, 
	1043, 1043, 1043, 1043, 1049, 1043, 1043, 1050, 
	1043, 1051, 1052, 1054, 1054, 1054, 1054, 1054, 
	1054, 1054, 1054, 1053, 1055, 1055, 1055, 1055, 
	1055, 1055, 1055, 1055, 1053, 1053, 1056, 1056, 
	290, 290, 290, 1056, 290, 290, 290, 290, 
	290, 290, 290, 290, 290, 290, 290, 290, 
	290, 290, 290, 290, 290, 290, 290, 290, 
	290, 1056, 290, 290, 290, 290, 290, 290, 
	290, 290, 290, 290, 290, 290, 290, 290, 
	290, 290, 290, 290, 290, 290, 290, 290, 
	290, 290, 290, 290, 290, 290, 290, 290, 
	290, 290, 290, 290, 290, 290, 291, 290, 
	290, 290, 290, 290, 290, 290, 290, 290, 
	290, 290, 290, 290, 290, 290, 290, 290, 
	290, 290, 290, 290, 290, 290, 290, 290, 
	290, 290, 290, 1057, 290, 1058, 1059, 1060, 
	1060, 290, 290, 290, 1060, 290, 290, 290, 
	290, 290, 290, 290, 290, 290, 290, 290, 
	290, 290, 290, 290, 290, 290, 290, 290, 
	290, 290, 1060, 290, 290, 290, 290, 290, 
	290, 290, 290, 290, 290, 290, 290, 290, 
	290, 290, 290, 290, 290, 290, 290, 290, 
	290, 290, 290, 290, 290, 290, 290, 290, 
	290, 290, 290, 290, 290, 290, 290, 291, 
	290, 290, 290, 290, 290, 290, 290, 290, 
	290, 290, 290, 290, 290, 290, 290, 290, 
	290, 290, 290, 290, 290, 290, 290, 290, 
	290, 290, 290, 290, 1061, 290, 289, 1060, 
	1062, 1063, 1064, 1064, 275, 275, 275, 1064, 
	275, 275, 275, 275, 275, 275, 275, 275, 
	275, 275, 275, 275, 275, 275, 275, 275, 
	275, 275, 275, 275, 275, 1064, 275, 275, 
	275, 275, 275, 275, 275, 275, 275, 275, 
	275, 275, 275, 275, 275, 275, 275, 275, 
	275, 275, 275, 275, 275, 275, 275, 275, 
	275, 275, 275, 275, 275, 275, 275, 275, 
	275, 275, 276, 275, 275, 275, 275, 275, 
	275, 275, 275, 275, 275, 275, 275, 275, 
	275, 275, 275, 275, 275, 275, 275, 275, 
	275, 275, 275, 275, 275, 275, 275, 1065, 
	275, 1066, 1066, 1066, 1066, 1066, 1066, 1066, 
	1066, 1066, 1066, 1064, 1064, 1064, 1064, 1064, 
	1064, 1064, 1066, 1066, 1066, 1066, 1066, 1066, 
	1064, 1064, 1064, 1064, 1064, 1064, 1064, 1064, 
	1064, 1064, 1064, 1064, 1064, 1064, 1064, 1064, 
	1064, 1064, 1064, 1064, 1064, 1064, 1064, 1064, 
	1064, 1064, 1066, 1066, 1066, 1066, 1066, 1066, 
	1064, 1068, 1068, 1068, 1068, 1068, 1068, 1068, 
	1068, 1068, 1068, 1067, 1067, 1067, 1067, 1067, 
	1067, 1067, 1068, 1068, 1068, 1068, 1068, 1068, 
	1067, 1067, 1067, 1067, 1067, 1067, 1067, 1067, 
	1067, 1067, 1067, 1067, 1067, 1067, 1067, 1067, 
	1067, 1067, 1067, 1067, 1067, 1067, 1067, 1067, 
	1067, 1067, 1068, 1068, 1068, 1068, 1068, 1068, 
	1067, 1067, 1069, 1069, 1069, 1069, 1069, 1069, 
	1069, 1069, 1069, 1069, 1060, 1060, 1060, 1060, 
	1060, 1060, 1060, 1069, 1069, 1069, 1069, 1069, 
	1069, 1060, 1060, 1060, 1060, 1060, 1060, 1060, 
	1060, 1060, 1060, 1060, 1060, 1060, 1060, 1060, 
	1060, 1060, 1060, 1060, 1060, 1060, 1060, 1060, 
	1060, 1060, 1060, 1069, 1069, 1069, 1069, 1069, 
	1069, 1060, 1071, 1071, 1071, 1071, 1071, 1071, 
	1071, 1071, 1071, 1071, 1070, 1070, 1070, 1070, 
	1070, 1070, 1070, 1071, 1071, 1071, 1071, 1071, 
	1071, 1070, 1070, 1070, 1070, 1070, 1070, 1070, 
	1070, 1070, 1070, 1070, 1070, 1070, 1070, 1070, 
	1070, 1070, 1070, 1070, 1070, 1070, 1070, 1070, 
	1070, 1070, 1070, 1071, 1071, 1071, 1071, 1071, 
	1071, 1070, 1070, 1060, 268, 268, 268, 1060, 
	268, 268, 268, 268, 268, 268, 268, 268, 
	268, 268, 268, 268, 268, 268, 268, 268, 
	268, 268, 268, 268, 268, 1060, 268, 268, 
	268, 268, 268, 268, 268, 268, 268, 268, 
	268, 268, 268, 268, 268, 268, 268, 268, 
	1072, 268, 1056, 275, 275, 275, 1056, 275, 
	275, 275, 275, 275, 275, 275, 275, 275, 
	275, 275, 275, 275, 275, 275, 275, 275, 
	275, 275, 275, 275, 1056, 275, 275, 275, 
	275, 275, 275, 275, 275, 275, 275, 275, 
	275, 275, 275, 275, 275, 275, 275, 275, 
	275, 275, 275, 275, 275, 275, 275, 275, 
	275, 275, 275, 275, 275, 275, 275, 275, 
	275, 276, 275, 275, 275, 275, 275, 275, 
	275, 275, 275, 275, 275, 275, 275, 275, 
	275, 275, 275, 275, 275, 275, 275, 275, 
	275, 275, 275, 275, 275, 275, 277, 275, 
	1056, 1073, 1073, 1073, 1056, 1073, 1073, 1073, 
	1073, 1073, 1073, 1073, 1073, 1073, 1073, 1073, 
	1073, 1073, 1073, 1073, 1073, 1073, 1073, 1073, 
	1073, 1073, 1056, 1073, 1073, 1073, 1073, 1073, 
	1073, 1073, 1073, 1073, 1073, 1073, 1073, 1073, 
	1073, 1073, 1073, 1073, 1073, 1073, 1073, 1073, 
	1073, 1073, 1073, 1073, 1073, 1073, 1073, 1073, 
	1073, 1073, 1073, 1073, 1073, 1073, 1073, 1073, 
	1073, 1073, 1073, 1073, 1073, 1073, 1073, 1073, 
	1073, 1073, 1073, 1073, 1073, 1073, 1073, 1073, 
	1073, 1073, 1073, 1073, 1073, 1073, 1073, 1073, 
	1073, 1073, 1073, 1073, 1074, 1073, 1075, 1076, 
	1076, 1073, 1073, 1073, 1076, 1073, 1073, 1073, 
	1073, 1073, 1073, 1073, 1073, 1073, 1073, 1073, 
	1073, 1073, 1073, 1073, 1073, 1073, 1073, 1073, 
	1073, 1073, 1076, 1073, 1073, 1073, 1073, 1073, 
	1073, 1073, 1073, 1073, 1073, 1073, 1073, 1073, 
	1073, 1073, 1073, 1073, 1073, 1073, 1073, 1073, 
	1073, 1073, 1073, 1073, 1073, 1073, 1073, 1073, 
	1073, 1073, 1073, 1073, 1073, 1073, 1073, 1073, 
	1073, 1073, 1073, 1073, 1073, 1073, 1073, 1073, 
	1073, 1073, 1073, 1073, 1073, 1073, 1073, 1073, 
	1073, 1073, 1073, 1073, 1073, 1073, 1073, 1073, 
	1073, 1073, 1073, 1073, 1077, 1073, 1078, 1078, 
	1078, 1078, 1078, 1078, 1078, 1078, 1078, 1078, 
	1076, 1076, 1076, 1076, 1076, 1076, 1076, 1078, 
	1078, 1078, 1078, 1078, 1078, 1076, 1076, 1076, 
	1076, 1076, 1076, 1076, 1076, 1076, 1076, 1076, 
	1076, 1076, 1076, 1076, 1076, 1076, 1076, 1076, 
	1076, 1076, 1076, 1076, 1076, 1076, 1076, 1078, 
	1078, 1078, 1078, 1078, 1078, 1076, 1080, 1080, 
	1080, 1080, 1080, 1080, 1080, 1080, 1080, 1080, 
	1079, 1079, 1079, 1079, 1079, 1079, 1079, 1080, 
	1080, 1080, 1080, 1080, 1080, 1079, 1079, 1079, 
	1079, 1079, 1079, 1079, 1079, 1079, 1079, 1079, 
	1079, 1079, 1079, 1079, 1079, 1079, 1079, 1079, 
	1079, 1079, 1079, 1079, 1079, 1079, 1079, 1080, 
	1080, 1080, 1080, 1080, 1080, 1079, 1079, 1076, 
	268, 268, 268, 1076, 268, 268, 268, 268, 
	268, 268, 268, 268, 268, 268, 268, 268, 
	268, 268, 268, 268, 268, 268, 268, 268, 
	268, 1076, 268, 268, 268, 268, 268, 268, 
	268, 268, 268, 268, 268, 268, 268, 268, 
	268, 268, 268, 268, 1072, 268, 1081, 1076, 
	1076, 275, 275, 275, 1076, 275, 275, 275, 
	275, 275, 275, 275, 275, 275, 275, 275, 
	275, 275, 275, 275, 275, 275, 275, 275, 
	275, 275, 1076, 275, 275, 275, 275, 275, 
	275, 275, 275, 275, 275, 275, 275, 275, 
	275, 275, 275, 275, 275, 275, 275, 275, 
	275, 275, 275, 275, 275, 275, 275, 275, 
	275, 275, 275, 275, 275, 275, 275, 276, 
	275, 275, 275, 275, 275, 275, 275, 275, 
	275, 275, 275, 275, 275, 275, 275, 275, 
	275, 275, 275, 275, 275, 275, 275, 275, 
	275, 275, 275, 275, 277, 275, 1083, 1083, 
	1083, 1083, 1083, 1083, 1083, 1083, 1083, 1083, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1083, 
	1083, 1083, 1083, 1083, 1083, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1083, 
	1083, 1083, 1083, 1083, 1083, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1084, 1082, 1085, 1085, 1085, 1085, 1085, 
	1085, 1085, 1085, 1085, 1085, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1085, 1085, 1085, 1085, 
	1085, 1085, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1085, 1085, 1085, 1085, 
	1085, 1085, 1082, 1086, 1086, 1086, 1086, 1086, 
	1086, 1086, 1086, 1086, 1086, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1086, 1086, 1086, 1086, 
	1086, 1086, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1086, 1086, 1086, 1086, 
	1086, 1086, 1082, 1087, 1087, 1087, 1087, 1087, 
	1087, 1087, 1087, 1087, 1087, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1087, 1087, 1087, 1087, 
	1087, 1087, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 
	1082, 1082, 1082, 1082, 1087, 1087, 1087, 1087, 
	1087, 1087, 1082, 1088, 1091, 1090, 1090, 1090, 
	1091, 1090, 1090, 1090, 1090, 1092, 1090, 1090, 
	1090, 1090, 1090, 1090, 1090, 1090, 1090, 1090, 
	1090, 1090, 1090, 1090, 1090, 1090, 1091, 1090, 
	1090, 1090, 1090, 1090, 1092, 1090, 1090, 1090, 
	1090, 1090, 1090, 1090, 1090, 1090, 1090, 1090, 
	1090, 1090, 1090, 1090, 1093, 1093, 1093, 1093, 
	1093, 1093, 1093, 1093, 1093, 1093, 1090, 1090, 
	1090, 1090, 1090, 1090, 1090, 1093, 1093, 1093, 
	1093, 1093, 1093, 1090, 1090, 1090, 1090, 1090, 
	1090, 1090, 1090, 1090, 1090, 1090, 1090, 1090, 
	1090, 1090, 1090, 1090, 1090, 1090, 1090, 1090, 
	1090, 1090, 1090, 1090, 1090, 1093, 1093, 1093, 
	1093, 1093, 1093, 1090, 1090, 1090, 1090, 1090, 
	1090, 1090, 1090, 1090, 1090, 1090, 1090, 1090, 
	1090, 1090, 1090, 1090, 1090, 1090, 1090, 1090, 
	1090, 1094, 1090, 1091, 1090, 1090, 1090, 1091, 
	1090, 1090, 1090, 1090, 1089, 1090, 1090, 1090, 
	1090, 1090, 1090, 1090, 1090, 1090, 1090, 1090, 
	1090, 1090, 1090, 1090, 1090, 1091, 1090, 1090, 
	1090, 1090, 1090, 1089, 1090, 1090, 1090, 1090, 
	1090, 1090, 1090, 1090, 1090, 1090, 1090, 1090, 
	1090, 1090, 1090, 1095, 1095, 1095, 1095, 1095, 
	1095, 1095, 1095, 1095, 1095, 1090, 1090, 1090, 
	1090, 1090, 1090, 1090, 1095, 1095, 1095, 1095, 
	1095, 1095, 1090, 1090, 1090, 1090, 1090, 1090, 
	1090, 1090, 1090, 1090, 1090, 1090, 1090, 1090, 
	1090, 1090, 1090, 1090, 1090, 1090, 1090, 1090, 
	1090, 1090, 1090, 1090, 1095, 1095, 1095, 1095, 
	1095, 1095, 1090, 1090, 1090, 1090, 1090, 1090, 
	1090, 1090, 1090, 1090, 1090, 1090, 1090, 1090, 
	1090, 1090, 1090, 1090, 1090, 1090, 1090, 1090, 
	1096, 1090, 1089, 1091, 1095, 1095, 1095, 1091, 
	1095, 1095, 1095, 1095, 1089, 1095, 1095, 1095, 
	1095, 1095, 1095, 1095, 1095, 1095, 1095, 1095, 
	1095, 1095, 1095, 1095, 1095, 1091, 1095, 1095, 
	1095, 1095, 1095, 1089, 1095, 1095, 1095, 1095, 
	1095, 1095, 1095, 1095, 1095, 1095, 1095, 1095, 
	1095, 1095, 1095, 1095, 1095, 1095, 1095, 1095, 
	1095, 1095, 1095, 1095, 1095, 1095, 1095, 1095, 
	1095, 1095, 1095, 1095, 1095, 1095, 1095, 1095, 
	1095, 1095, 1095, 1095, 1095, 1095, 1095, 1095, 
	1095, 1095, 1095, 1095, 1095, 1095, 1095, 1095, 
	1095, 1095, 1095, 1095, 1095, 1095, 1095, 1095, 
	1095, 1095, 1095, 1095, 1095, 1095, 1095, 1095, 
	1095, 1095, 1095, 1095, 1095, 1095, 1095, 1095, 
	1095, 1095, 1095, 1095, 1095, 1095, 1095, 1095, 
	1095, 1095, 1095, 1095, 1095, 1095, 1095, 1095, 
	1089, 1095, 1097, 1091, 1098, 1098, 1098, 1091, 
	1098, 1098, 1098, 1098, 1092, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1091, 1098, 1098, 
	1098, 1098, 1098, 1092, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1099, 1099, 1099, 1099, 
	1099, 1099, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1099, 1099, 1099, 1099, 
	1099, 1099, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1089, 1098, 1091, 1098, 1098, 1098, 1091, 1098, 
	1098, 1098, 1098, 1089, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1091, 1098, 1098, 1098, 
	1098, 1098, 1089, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1095, 1095, 1095, 1095, 1095, 1095, 
	1095, 1095, 1095, 1095, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1095, 1095, 1095, 1095, 1095, 
	1095, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1095, 1095, 1095, 1095, 1095, 
	1095, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1091, 
	1098, 1091, 1098, 1098, 1098, 1091, 1098, 1098, 
	1098, 1098, 1100, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1091, 1098, 1098, 1098, 1098, 
	1098, 1100, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1101, 1101, 1101, 1101, 1101, 1101, 1101, 
	1101, 1101, 1101, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1101, 1101, 1101, 1101, 1101, 1101, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1101, 1101, 1101, 1101, 1101, 1101, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1102, 1098, 
	1091, 1098, 1098, 1098, 1091, 1098, 1098, 1098, 
	1098, 1100, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1091, 1098, 1098, 1098, 1098, 1098, 
	1100, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1099, 1099, 1099, 1099, 1099, 1099, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1099, 1099, 1099, 1099, 1099, 1099, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1102, 1098, 1103, 
	1091, 1098, 1098, 1098, 1091, 1098, 1098, 1098, 
	1098, 1100, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1091, 1098, 1098, 1098, 1098, 1098, 
	1100, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1104, 1104, 1104, 1104, 1104, 1104, 1104, 1104, 
	1104, 1104, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1104, 1104, 1104, 1104, 1104, 1104, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1104, 1104, 1104, 1104, 1104, 1104, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1102, 1098, 1091, 
	1098, 1098, 1098, 1091, 1098, 1098, 1098, 1098, 
	1100, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1091, 1098, 1098, 1098, 1098, 1098, 1100, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1105, 
	1105, 1105, 1105, 1105, 1105, 1105, 1105, 1105, 
	1105, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1105, 1105, 1105, 1105, 1105, 1105, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1105, 1105, 1105, 1105, 1105, 1105, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1102, 1098, 1091, 1098, 
	1098, 1098, 1091, 1098, 1098, 1098, 1098, 1100, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1091, 1098, 1098, 1098, 1098, 1098, 1100, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1106, 1106, 
	1106, 1106, 1106, 1106, 1106, 1106, 1106, 1106, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1106, 
	1106, 1106, 1106, 1106, 1106, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1106, 
	1106, 1106, 1106, 1106, 1106, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1102, 1098, 1091, 1098, 1098, 
	1098, 1091, 1098, 1098, 1098, 1098, 1100, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1091, 
	1098, 1098, 1098, 1098, 1098, 1100, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1107, 1107, 1107, 
	1107, 1107, 1107, 1107, 1107, 1107, 1107, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1107, 1107, 
	1107, 1107, 1107, 1107, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1107, 1107, 
	1107, 1107, 1107, 1107, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1102, 1098, 1091, 1098, 1098, 1098, 
	1091, 1098, 1098, 1098, 1098, 1100, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1091, 1098, 
	1098, 1098, 1098, 1098, 1100, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1108, 1108, 1108, 1108, 
	1108, 1108, 1108, 1108, 1108, 1108, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1108, 1108, 1108, 
	1108, 1108, 1108, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1108, 1108, 1108, 
	1108, 1108, 1108, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1102, 1098, 1091, 1098, 1098, 1098, 1091, 
	1098, 1098, 1098, 1098, 1089, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1091, 1098, 1098, 
	1098, 1098, 1098, 1089, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1108, 1108, 1108, 1108, 1108, 
	1108, 1108, 1108, 1108, 1108, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1108, 1108, 1108, 1108, 
	1108, 1108, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1108, 1108, 1108, 1108, 
	1108, 1108, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1089, 1098, 1091, 1098, 1098, 1098, 1091, 1098, 
	1098, 1098, 1098, 1109, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1091, 1098, 1098, 1098, 
	1098, 1098, 1109, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1110, 1110, 1110, 1110, 1110, 1110, 
	1110, 1110, 1110, 1110, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1110, 1110, 1110, 1110, 1110, 
	1110, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1110, 1110, 1110, 1110, 1110, 
	1110, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1102, 
	1098, 1091, 1098, 1098, 1098, 1091, 1098, 1098, 
	1098, 1098, 1109, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1091, 1098, 1098, 1098, 1098, 
	1098, 1109, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1111, 1111, 1111, 1111, 1111, 1111, 1111, 
	1111, 1111, 1111, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1111, 1111, 1111, 1111, 1111, 1111, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1111, 1111, 1111, 1111, 1111, 1111, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1102, 1098, 
	1091, 1098, 1098, 1098, 1091, 1098, 1098, 1098, 
	1098, 1109, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1091, 1098, 1098, 1098, 1098, 1098, 
	1109, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1112, 1112, 1112, 1112, 1112, 1112, 1112, 1112, 
	1112, 1112, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1112, 1112, 1112, 1112, 1112, 1112, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1112, 1112, 1112, 1112, 1112, 1112, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1089, 1098, 1091, 
	1098, 1098, 1098, 1091, 1098, 1098, 1098, 1098, 
	1109, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1091, 1098, 1098, 1098, 1098, 1098, 1109, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1113, 
	1113, 1113, 1113, 1113, 1113, 1113, 1113, 1113, 
	1113, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1113, 1113, 1113, 1113, 1113, 1113, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1113, 1113, 1113, 1113, 1113, 1113, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1089, 1098, 1091, 1098, 
	1098, 1098, 1091, 1098, 1098, 1098, 1098, 1109, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1091, 1098, 1098, 1098, 1098, 1098, 1109, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1114, 1114, 
	1114, 1114, 1114, 1114, 1114, 1114, 1114, 1114, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1114, 
	1114, 1114, 1114, 1114, 1114, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1114, 
	1114, 1114, 1114, 1114, 1114, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1089, 1098, 1091, 1098, 1098, 
	1098, 1091, 1098, 1098, 1098, 1098, 1109, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1091, 
	1098, 1098, 1098, 1098, 1098, 1109, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1115, 1115, 1115, 
	1115, 1115, 1115, 1115, 1115, 1115, 1115, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1115, 1115, 
	1115, 1115, 1115, 1115, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1115, 1115, 
	1115, 1115, 1115, 1115, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1089, 1098, 1091, 1098, 1098, 1098, 
	1091, 1098, 1098, 1098, 1098, 1109, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1091, 1098, 
	1098, 1098, 1098, 1098, 1109, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1116, 1116, 1116, 1116, 
	1116, 1116, 1116, 1116, 1116, 1116, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1116, 1116, 1116, 
	1116, 1116, 1116, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1116, 1116, 1116, 
	1116, 1116, 1116, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1089, 1098, 1091, 1098, 1098, 1098, 1091, 
	1098, 1098, 1098, 1098, 1109, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1091, 1098, 1098, 
	1098, 1098, 1098, 1109, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1108, 1108, 1108, 1108, 1108, 
	1108, 1108, 1108, 1108, 1108, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1108, 1108, 1108, 1108, 
	1108, 1108, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1108, 1108, 1108, 1108, 
	1108, 1108, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1089, 1098, 1091, 1098, 1098, 1098, 1091, 1098, 
	1098, 1098, 1098, 1109, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1091, 1098, 1098, 1098, 
	1098, 1098, 1109, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1117, 1117, 1117, 1117, 1117, 1117, 
	1117, 1117, 1117, 1117, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1117, 1117, 1117, 1117, 1117, 
	1117, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1117, 1117, 1117, 1117, 1117, 
	1117, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1102, 
	1098, 1091, 1098, 1098, 1098, 1091, 1098, 1098, 
	1098, 1098, 1109, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1091, 1098, 1098, 1098, 1098, 
	1098, 1109, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1118, 1118, 1118, 1118, 1118, 1118, 1118, 
	1118, 1118, 1118, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1118, 1118, 1118, 1118, 1118, 1118, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1118, 1118, 1118, 1118, 1118, 1118, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1102, 1098, 
	1091, 1098, 1098, 1098, 1091, 1098, 1098, 1098, 
	1098, 1109, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1091, 1098, 1098, 1098, 1098, 1098, 
	1109, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1119, 1119, 1119, 1119, 1119, 1119, 1119, 1119, 
	1119, 1119, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1119, 1119, 1119, 1119, 1119, 1119, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1119, 1119, 1119, 1119, 1119, 1119, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1102, 1098, 1091, 
	1098, 1098, 1098, 1091, 1098, 1098, 1098, 1098, 
	1109, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1091, 1098, 1098, 1098, 1098, 1098, 1109, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1120, 
	1120, 1120, 1120, 1120, 1120, 1120, 1120, 1120, 
	1120, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1120, 1120, 1120, 1120, 1120, 1120, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1120, 1120, 1120, 1120, 1120, 1120, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1102, 1098, 1091, 1098, 
	1098, 1098, 1091, 1098, 1098, 1098, 1098, 1109, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1091, 1098, 1098, 1098, 1098, 1098, 1109, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1108, 1108, 
	1108, 1108, 1108, 1108, 1108, 1108, 1108, 1108, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1108, 
	1108, 1108, 1108, 1108, 1108, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1108, 
	1108, 1108, 1108, 1108, 1108, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1102, 1098, 1121, 1122, 1124, 
	1124, 1124, 1124, 1124, 1124, 1124, 1124, 1124, 
	1124, 1123, 1123, 1123, 1123, 1123, 1123, 1123, 
	1124, 1124, 1124, 1124, 1124, 1124, 1123, 1123, 
	1123, 1123, 1123, 1123, 1123, 1123, 1123, 1123, 
	1123, 1123, 1123, 1123, 1123, 1123, 1123, 1123, 
	1123, 1123, 1123, 1123, 1123, 1123, 1123, 1123, 
	1124, 1124, 1124, 1124, 1124, 1124, 1123, 1123, 
	211, 211, 211, 211, 211, 211, 211, 211, 
	211, 211, 211, 211, 211, 211, 211, 211, 
	211, 211, 211, 211, 211, 211, 211, 211, 
	211, 211, 211, 211, 211, 211, 211, 211, 
	211, 296, 211, 211, 211, 211, 211, 211, 
	211, 211, 211, 211, 211, 211, 211, 211, 
	295, 295, 295, 295, 295, 295, 295, 295, 
	295, 295, 297, 211, 211, 298, 211, 296, 
	211, 295, 295, 295, 295, 295, 295, 295, 
	295, 295, 295, 295, 295, 295, 295, 295, 
	295, 295, 295, 295, 295, 295, 295, 295, 
	295, 295, 295, 211, 211, 211, 211, 295, 
	211, 295, 295, 295, 295, 295, 295, 295, 
	295, 295, 295, 295, 295, 295, 295, 295, 
	295, 295, 295, 295, 295, 295, 295, 295, 
	295, 295, 295, 211, 211, 211, 211, 211, 
	295, 963, 963, 963, 963, 963, 963, 963, 
	963, 963, 963, 963, 963, 963, 963, 963, 
	963, 963, 963, 963, 963, 963, 963, 963, 
	963, 963, 963, 963, 963, 963, 963, 963, 
	963, 963, 296, 963, 963, 963, 963, 963, 
	963, 963, 963, 963, 963, 963, 963, 963, 
	963, 295, 295, 295, 295, 295, 295, 295, 
	295, 295, 295, 297, 963, 963, 298, 963, 
	296, 963, 295, 295, 295, 295, 1125, 295, 
	295, 295, 295, 295, 295, 295, 295, 295, 
	295, 295, 295, 295, 295, 295, 295, 295, 
	295, 295, 295, 295, 963, 963, 963, 963, 
	295, 963, 295, 295, 295, 295, 295, 295, 
	295, 295, 295, 295, 295, 295, 295, 295, 
	295, 295, 295, 295, 295, 295, 295, 295, 
	295, 295, 295, 295, 963, 963, 963, 963, 
	963, 295, 963, 963, 963, 963, 963, 963, 
	963, 963, 963, 963, 963, 963, 963, 963, 
	963, 963, 963, 963, 963, 963, 963, 963, 
	963, 963, 963, 963, 963, 963, 963, 963, 
	963, 963, 963, 296, 963, 963, 963, 963, 
	963, 963, 963, 963, 963, 963, 963, 963, 
	963, 963, 295, 295, 295, 295, 295, 295, 
	295, 295, 295, 295, 297, 963, 963, 298, 
	963, 296, 963, 295, 295, 295, 295, 295, 
	295, 295, 295, 295, 295, 295, 295, 295, 
	1126, 295, 295, 295, 295, 295, 295, 295, 
	295, 295, 295, 295, 295, 963, 963, 963, 
	963, 295, 963, 295, 295, 295, 295, 295, 
	295, 295, 295, 295, 295, 295, 295, 295, 
	295, 295, 295, 295, 295, 295, 295, 295, 
	295, 295, 295, 295, 295, 963, 963, 963, 
	963, 963, 295, 1127, 1128, 963, 958, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	942, 941, 942, 942, 942, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 942, 
	296, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 297, 941, 941, 298, 941, 296, 941, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 941, 943, 941, 941, 1129, 941, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 941, 941, 941, 941, 941, 897, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 942, 941, 942, 942, 942, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	942, 296, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 297, 941, 941, 298, 941, 296, 
	941, 897, 897, 897, 897, 1130, 1131, 897, 
	897, 897, 897, 897, 1132, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 941, 943, 941, 941, 897, 
	941, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 941, 941, 941, 941, 941, 
	897, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 942, 941, 942, 942, 942, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 942, 296, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 297, 941, 941, 298, 941, 
	296, 941, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 1133, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 941, 943, 941, 941, 
	897, 941, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 941, 941, 941, 941, 
	941, 897, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 942, 941, 942, 942, 942, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 942, 296, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 297, 941, 941, 298, 
	941, 296, 941, 897, 897, 1134, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 941, 943, 941, 
	941, 897, 941, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 941, 941, 941, 
	941, 941, 897, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 942, 941, 942, 942, 
	942, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 942, 296, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 297, 941, 941, 
	298, 941, 296, 941, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 1135, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 941, 943, 
	941, 941, 897, 941, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 941, 941, 
	941, 941, 941, 897, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 942, 941, 942, 
	942, 942, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 942, 296, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 297, 941, 
	941, 298, 941, 296, 941, 897, 897, 897, 
	1136, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 941, 
	943, 941, 941, 897, 941, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 941, 
	941, 941, 941, 941, 897, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 942, 941, 
	942, 942, 942, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 942, 296, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 297, 
	941, 941, 298, 941, 296, 941, 897, 897, 
	897, 897, 897, 897, 897, 897, 1137, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	941, 943, 941, 941, 897, 941, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	941, 941, 941, 941, 941, 897, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 942, 
	941, 942, 942, 942, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 942, 296, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	297, 941, 941, 298, 941, 296, 941, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 1138, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 941, 943, 941, 941, 897, 941, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 941, 941, 941, 941, 941, 897, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	942, 941, 942, 942, 942, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 942, 
	296, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 297, 941, 941, 298, 941, 296, 941, 
	897, 897, 897, 897, 897, 897, 1139, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 941, 943, 941, 941, 897, 941, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 941, 941, 941, 941, 941, 897, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 942, 941, 942, 942, 942, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	942, 296, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 297, 941, 941, 298, 941, 296, 
	941, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 941, 943, 941, 941, 1140, 
	941, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 941, 941, 941, 941, 941, 
	897, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 942, 941, 942, 942, 942, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 942, 296, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 297, 941, 941, 298, 941, 
	296, 941, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 941, 943, 941, 941, 
	1141, 941, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 941, 941, 941, 941, 
	941, 897, 211, 211, 211, 211, 211, 211, 
	211, 211, 211, 211, 211, 211, 211, 211, 
	211, 211, 211, 211, 211, 211, 211, 211, 
	211, 211, 211, 211, 211, 211, 211, 211, 
	211, 211, 211, 296, 211, 211, 211, 211, 
	211, 211, 211, 211, 211, 211, 211, 211, 
	211, 211, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 297, 211, 211, 298, 
	211, 296, 211, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 211, 211, 211, 
	211, 897, 211, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 211, 211, 211, 
	211, 211, 897, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 942, 941, 942, 942, 
	942, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 942, 296, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 297, 941, 941, 
	298, 941, 296, 941, 897, 897, 897, 897, 
	897, 897, 897, 897, 1142, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 941, 943, 
	941, 941, 897, 941, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 941, 941, 
	941, 941, 941, 897, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 942, 941, 942, 
	942, 942, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 942, 296, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 297, 941, 
	941, 298, 941, 296, 941, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	1143, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 941, 
	943, 941, 941, 897, 941, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 941, 
	941, 941, 941, 941, 897, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 942, 941, 
	942, 942, 942, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 942, 296, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 297, 
	941, 941, 298, 941, 296, 941, 897, 897, 
	897, 897, 1139, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	941, 943, 941, 941, 897, 941, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	941, 941, 941, 941, 941, 897, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 942, 
	941, 942, 942, 942, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 942, 296, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	297, 941, 941, 298, 941, 296, 941, 897, 
	897, 897, 897, 897, 897, 897, 897, 1144, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 941, 943, 941, 941, 897, 941, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 941, 941, 941, 941, 941, 897, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	942, 941, 942, 942, 942, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 942, 
	296, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 297, 941, 941, 298, 941, 296, 941, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 1143, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 941, 943, 941, 941, 897, 941, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 941, 941, 941, 941, 941, 897, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 942, 941, 942, 942, 942, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	942, 296, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 297, 941, 941, 298, 941, 296, 
	941, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 941, 943, 941, 941, 897, 
	941, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 1145, 897, 1146, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 941, 941, 941, 941, 941, 
	897, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 942, 941, 942, 942, 942, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 942, 296, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 297, 941, 941, 298, 941, 
	296, 941, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 941, 943, 941, 941, 
	897, 941, 897, 897, 897, 897, 897, 897, 
	897, 897, 1147, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 941, 941, 941, 941, 
	941, 897, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 942, 941, 942, 942, 942, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 942, 296, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 297, 941, 941, 298, 
	941, 296, 941, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 941, 943, 941, 
	941, 897, 941, 1148, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 941, 941, 941, 
	941, 941, 897, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 942, 941, 942, 942, 
	942, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 942, 296, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 297, 941, 941, 
	298, 941, 296, 941, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 941, 943, 
	941, 941, 897, 941, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 1141, 897, 
	897, 897, 897, 897, 897, 897, 941, 941, 
	941, 941, 941, 897, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 942, 941, 942, 
	942, 942, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 942, 296, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 297, 941, 
	941, 298, 941, 296, 941, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 941, 
	943, 941, 941, 897, 941, 897, 897, 897, 
	1141, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 941, 
	941, 941, 941, 941, 897, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 942, 941, 
	942, 942, 942, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 942, 296, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 297, 
	941, 941, 298, 941, 296, 941, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	941, 943, 941, 941, 897, 941, 897, 897, 
	897, 897, 1149, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 1150, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	941, 941, 941, 941, 941, 897, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 942, 
	941, 942, 942, 942, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 942, 296, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	297, 941, 941, 298, 941, 296, 941, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 941, 943, 941, 941, 897, 941, 897, 
	897, 897, 897, 897, 897, 1151, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 941, 941, 941, 941, 941, 897, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	942, 941, 942, 942, 942, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 942, 
	296, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 297, 941, 941, 298, 941, 296, 941, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 941, 943, 941, 941, 897, 941, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	1152, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 941, 941, 941, 941, 941, 897, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 942, 941, 942, 942, 942, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	942, 296, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 297, 941, 941, 298, 941, 296, 
	941, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 941, 943, 941, 941, 897, 
	941, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 1141, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 941, 941, 941, 941, 941, 
	897, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 942, 941, 942, 942, 942, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 942, 296, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 297, 941, 941, 298, 941, 
	296, 941, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 941, 943, 941, 941, 
	897, 941, 897, 897, 897, 897, 1153, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 941, 941, 941, 941, 
	941, 897, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 942, 941, 942, 942, 942, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 942, 296, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 297, 941, 941, 298, 
	941, 296, 941, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 941, 943, 941, 
	941, 897, 941, 1154, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 941, 941, 941, 
	941, 941, 897, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 942, 941, 942, 942, 
	942, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 942, 296, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 297, 941, 941, 
	298, 941, 296, 941, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 941, 943, 
	941, 941, 897, 941, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 1141, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 941, 941, 
	941, 941, 941, 897, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 942, 941, 942, 
	942, 942, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 942, 296, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 297, 941, 
	941, 298, 941, 296, 941, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 941, 
	943, 941, 941, 897, 941, 1155, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	1156, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 941, 
	941, 941, 941, 941, 897, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 942, 941, 
	942, 942, 942, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 942, 296, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 297, 
	941, 941, 298, 941, 296, 941, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	941, 943, 941, 941, 897, 941, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	1157, 897, 897, 897, 897, 897, 897, 897, 
	941, 941, 941, 941, 941, 897, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 942, 
	941, 942, 942, 942, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 942, 296, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	297, 941, 941, 298, 941, 296, 941, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 941, 943, 941, 941, 897, 941, 897, 
	897, 897, 897, 1141, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 941, 941, 941, 941, 941, 897, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	942, 941, 942, 942, 942, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 942, 
	296, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 297, 941, 941, 298, 941, 296, 941, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 941, 943, 941, 941, 897, 941, 
	1158, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 941, 941, 941, 941, 941, 897, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 942, 941, 942, 942, 942, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	942, 296, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 297, 941, 941, 298, 941, 296, 
	941, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 941, 943, 941, 941, 897, 
	941, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 1148, 897, 897, 897, 897, 
	897, 897, 897, 941, 941, 941, 941, 941, 
	897, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 942, 941, 942, 942, 942, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 942, 296, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 297, 941, 941, 298, 941, 
	296, 941, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 941, 943, 941, 941, 
	897, 941, 897, 897, 897, 897, 1159, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	1141, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 941, 941, 941, 941, 
	941, 897, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 942, 941, 942, 942, 942, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 942, 296, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 297, 941, 941, 298, 
	941, 296, 941, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 941, 943, 941, 
	941, 897, 941, 897, 897, 897, 897, 897, 
	1141, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 941, 941, 941, 
	941, 941, 897, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 942, 941, 942, 942, 
	942, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 942, 296, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 297, 941, 941, 
	298, 941, 296, 941, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 941, 943, 
	941, 941, 897, 941, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 1160, 
	897, 1161, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 941, 941, 
	941, 941, 941, 897, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 942, 941, 942, 
	942, 942, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 942, 296, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 297, 941, 
	941, 298, 941, 296, 941, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 941, 
	943, 941, 941, 897, 941, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 1162, 
	897, 897, 897, 897, 897, 897, 897, 941, 
	941, 941, 941, 941, 897, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 942, 941, 
	942, 942, 942, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 942, 296, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 297, 
	941, 941, 298, 941, 296, 941, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	941, 943, 941, 941, 897, 941, 897, 897, 
	897, 897, 1141, 897, 897, 897, 1159, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	941, 941, 941, 941, 941, 897, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 942, 
	941, 942, 942, 942, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 942, 296, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	297, 941, 941, 298, 941, 296, 941, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 941, 943, 941, 941, 897, 941, 897, 
	897, 897, 1141, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 1163, 897, 897, 897, 897, 897, 897, 
	897, 941, 941, 941, 941, 941, 897, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	942, 941, 942, 942, 942, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 942, 
	296, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 297, 941, 941, 298, 941, 296, 941, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 941, 943, 941, 941, 897, 941, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 1164, 897, 897, 897, 
	897, 897, 941, 941, 941, 941, 941, 897, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 942, 941, 942, 942, 942, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	942, 296, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 297, 941, 941, 298, 941, 296, 
	941, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 941, 943, 941, 941, 897, 
	941, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 1157, 897, 897, 897, 897, 897, 
	897, 897, 897, 941, 941, 941, 941, 941, 
	897, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 942, 941, 942, 942, 942, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 942, 296, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 297, 941, 941, 298, 941, 
	296, 941, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 941, 943, 941, 941, 
	897, 941, 1165, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	932, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 941, 941, 941, 941, 
	941, 897, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 942, 941, 942, 942, 942, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 942, 296, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 297, 941, 941, 298, 
	941, 296, 941, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 941, 943, 941, 
	941, 897, 941, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 1155, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 941, 941, 941, 
	941, 941, 897, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 942, 941, 942, 942, 
	942, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 942, 296, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 297, 941, 941, 
	298, 941, 296, 941, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 941, 943, 
	941, 941, 897, 941, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 1141, 897, 897, 
	897, 897, 897, 897, 897, 897, 941, 941, 
	941, 941, 941, 897, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 942, 941, 942, 
	942, 942, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 942, 296, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 297, 941, 
	941, 298, 941, 296, 941, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 941, 
	943, 941, 941, 897, 941, 897, 897, 897, 
	897, 897, 1166, 897, 897, 897, 897, 897, 
	897, 897, 1141, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 941, 
	941, 941, 941, 941, 897, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 942, 941, 
	942, 942, 942, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 942, 296, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 297, 
	941, 941, 298, 941, 296, 941, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	941, 943, 941, 941, 897, 941, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 1167, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	941, 941, 941, 941, 941, 897, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 942, 
	941, 942, 942, 942, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 942, 296, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	297, 941, 941, 298, 941, 296, 941, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 941, 943, 941, 941, 897, 941, 897, 
	897, 897, 1168, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 941, 941, 941, 941, 941, 897, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	942, 941, 942, 942, 942, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 942, 
	296, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 297, 941, 941, 298, 941, 296, 941, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 941, 943, 941, 941, 897, 941, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 1169, 897, 897, 897, 
	897, 897, 941, 941, 941, 941, 941, 897, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 942, 941, 942, 942, 942, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	942, 296, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 297, 941, 941, 298, 941, 296, 
	941, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 941, 943, 941, 941, 897, 
	941, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 1157, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 941, 941, 941, 941, 941, 
	897, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 942, 941, 942, 942, 942, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 942, 296, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 297, 941, 941, 298, 941, 
	296, 941, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 941, 943, 941, 941, 
	897, 941, 897, 897, 897, 897, 1170, 897, 
	897, 897, 1171, 897, 897, 897, 897, 897, 
	1172, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 941, 941, 941, 941, 
	941, 897, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 942, 941, 942, 942, 942, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 942, 296, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 297, 941, 941, 298, 
	941, 296, 941, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 941, 943, 941, 
	941, 897, 941, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 1172, 897, 897, 941, 941, 941, 
	941, 941, 897, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 942, 941, 942, 942, 
	942, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 942, 296, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 297, 941, 941, 
	298, 941, 296, 941, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 941, 943, 
	941, 941, 897, 941, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 1141, 
	897, 897, 897, 897, 897, 897, 941, 941, 
	941, 941, 941, 897, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 942, 941, 942, 
	942, 942, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 942, 296, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 297, 941, 
	941, 298, 941, 296, 941, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 941, 
	943, 941, 941, 897, 941, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	1141, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 941, 
	941, 941, 941, 941, 897, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 942, 941, 
	942, 942, 942, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 942, 296, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 297, 
	941, 941, 298, 941, 296, 941, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	941, 943, 941, 941, 897, 941, 897, 897, 
	897, 897, 1173, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	941, 941, 941, 941, 941, 897, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 942, 
	941, 942, 942, 942, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 942, 296, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	297, 941, 941, 298, 941, 296, 941, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 941, 943, 941, 941, 897, 941, 897, 
	897, 897, 1174, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 1175, 1176, 897, 897, 897, 897, 897, 
	897, 941, 941, 941, 941, 941, 897, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	942, 941, 942, 942, 942, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 942, 
	296, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 297, 941, 941, 298, 941, 296, 941, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 941, 943, 941, 941, 897, 941, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 1141, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 941, 941, 941, 941, 941, 897, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 942, 941, 942, 942, 942, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	942, 296, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 297, 941, 941, 298, 941, 296, 
	941, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 941, 943, 941, 941, 897, 
	941, 897, 897, 1177, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 941, 941, 941, 941, 941, 
	897, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 942, 941, 942, 942, 942, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 942, 296, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 297, 941, 941, 298, 941, 
	296, 941, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 941, 943, 941, 941, 
	897, 941, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 1178, 897, 
	897, 897, 897, 897, 941, 941, 941, 941, 
	941, 897, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 942, 941, 942, 942, 942, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 942, 296, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 297, 941, 941, 298, 
	941, 296, 941, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 941, 943, 941, 
	941, 897, 941, 897, 897, 897, 897, 1179, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 941, 941, 941, 
	941, 941, 897, 1180, 1180, 1180, 1180, 1180, 
	1180, 1180, 1180, 1180, 1180, 1180, 1180, 1180, 
	1180, 1180, 1180, 1180, 1180, 1180, 1180, 1180, 
	1180, 1180, 1180, 1180, 1180, 1180, 1180, 1180, 
	1180, 1180, 1180, 1180, 1182, 1180, 1180, 1180, 
	1180, 1180, 1180, 1180, 1180, 1180, 1180, 1180, 
	1180, 1180, 1180, 1181, 1181, 1181, 1181, 1181, 
	1181, 1181, 1181, 1181, 1181, 1183, 1180, 1180, 
	1184, 1180, 1182, 1180, 1181, 1181, 1181, 1181, 
	1181, 1181, 1181, 1181, 1181, 1181, 1181, 1181, 
	1181, 1181, 1181, 1181, 1181, 1181, 1181, 1181, 
	1181, 1181, 1181, 1181, 1181, 1181, 1180, 1180, 
	1180, 1180, 1181, 1180, 1181, 1181, 1181, 1181, 
	1181, 1181, 1181, 1181, 1181, 1181, 1181, 1181, 
	1181, 1181, 1181, 1181, 1181, 1181, 1181, 1181, 
	1181, 1181, 1181, 1181, 1181, 1181, 1180, 1180, 
	1180, 1180, 1180, 1181, 949, 1185, 948, 948, 
	948, 948, 948, 948, 948, 948, 948, 948, 
	948, 948, 948, 948, 948, 948, 948, 948, 
	948, 948, 948, 948, 948, 948, 948, 948, 
	948, 948, 948, 948, 948, 948, 948, 948, 
	948, 948, 948, 948, 948, 948, 948, 948, 
	948, 948, 948, 948, 948, 948, 948, 948, 
	948, 948, 948, 948, 948, 948, 948, 948, 
	948, 948, 948, 948, 948, 951, 948, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	942, 941, 942, 942, 942, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 942, 
	296, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 297, 941, 941, 298, 941, 296, 941, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 941, 943, 941, 941, 897, 941, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 1186, 897, 897, 1187, 897, 897, 897, 
	897, 897, 941, 941, 941, 941, 941, 897, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 942, 941, 942, 942, 942, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	942, 296, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 297, 941, 941, 298, 941, 296, 
	941, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 941, 943, 941, 941, 897, 
	941, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 1141, 897, 941, 941, 941, 941, 941, 
	897, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 942, 941, 942, 942, 942, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 942, 296, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 297, 941, 941, 298, 941, 
	296, 941, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 941, 943, 941, 941, 
	897, 941, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 1152, 897, 897, 897, 897, 
	897, 897, 897, 897, 941, 941, 941, 941, 
	941, 897, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 942, 941, 942, 942, 942, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 942, 296, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 297, 941, 941, 298, 
	941, 296, 941, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 941, 943, 941, 
	941, 897, 941, 897, 897, 897, 897, 1188, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 1189, 
	897, 897, 897, 897, 897, 941, 941, 941, 
	941, 941, 897, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 942, 941, 942, 942, 
	942, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 942, 296, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 297, 941, 941, 
	298, 941, 296, 941, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 941, 943, 
	941, 941, 897, 941, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 1159, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 941, 941, 
	941, 941, 941, 897, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 942, 941, 942, 
	942, 942, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 942, 296, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 297, 941, 
	941, 298, 941, 296, 941, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 941, 
	943, 941, 941, 897, 941, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 1190, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 941, 
	941, 941, 941, 941, 897, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 942, 941, 
	942, 942, 942, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 942, 296, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 297, 
	941, 941, 298, 941, 296, 941, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	941, 943, 941, 941, 897, 941, 897, 897, 
	897, 897, 932, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	941, 941, 941, 941, 941, 897, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 942, 
	941, 942, 942, 942, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 942, 296, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	297, 941, 941, 298, 941, 296, 941, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 941, 943, 941, 941, 897, 941, 897, 
	897, 897, 897, 897, 897, 897, 1191, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	1192, 897, 897, 897, 897, 897, 897, 897, 
	897, 941, 941, 941, 941, 941, 897, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	942, 941, 942, 942, 942, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 942, 
	296, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 297, 941, 941, 298, 941, 296, 941, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 941, 943, 941, 941, 897, 941, 
	897, 897, 897, 897, 1152, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 941, 941, 941, 941, 941, 897, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 942, 941, 942, 942, 942, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	942, 296, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 297, 941, 941, 298, 941, 296, 
	941, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 941, 943, 941, 941, 897, 
	941, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 1157, 897, 897, 
	897, 897, 897, 941, 941, 941, 941, 941, 
	897, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 942, 941, 942, 942, 942, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 942, 296, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 297, 941, 941, 298, 941, 
	296, 941, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 941, 943, 941, 941, 
	897, 941, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 1193, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 941, 941, 941, 941, 
	941, 897, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 942, 941, 942, 942, 942, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 942, 296, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 297, 941, 941, 298, 
	941, 296, 941, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 941, 943, 941, 
	941, 897, 941, 897, 897, 897, 1194, 897, 
	897, 897, 897, 897, 897, 897, 1195, 897, 
	897, 897, 897, 897, 897, 897, 1196, 897, 
	897, 897, 897, 897, 897, 941, 941, 941, 
	941, 941, 897, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 942, 941, 942, 942, 
	942, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 942, 296, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 297, 941, 941, 
	298, 941, 296, 941, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 941, 943, 
	941, 941, 897, 941, 897, 897, 897, 897, 
	1159, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 941, 941, 
	941, 941, 941, 897, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 942, 941, 942, 
	942, 942, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 942, 296, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 297, 941, 
	941, 298, 941, 296, 941, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 941, 
	943, 941, 941, 897, 941, 897, 897, 897, 
	897, 1197, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 941, 
	941, 941, 941, 941, 897, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 942, 941, 
	942, 942, 942, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 942, 296, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 297, 
	941, 941, 298, 941, 296, 941, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	941, 943, 941, 941, 897, 941, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	1198, 897, 897, 897, 897, 897, 897, 897, 
	941, 941, 941, 941, 941, 897, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 942, 
	941, 942, 942, 942, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 942, 296, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	297, 941, 941, 298, 941, 296, 941, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 941, 943, 941, 941, 897, 941, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 1166, 897, 897, 897, 897, 897, 897, 
	897, 941, 941, 941, 941, 941, 897, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	942, 941, 942, 942, 942, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 942, 
	296, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 297, 941, 941, 298, 941, 296, 941, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 941, 943, 941, 941, 897, 941, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	1199, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 941, 941, 941, 941, 941, 897, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 942, 941, 942, 942, 942, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	942, 296, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 297, 941, 941, 298, 941, 296, 
	941, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 941, 943, 941, 941, 897, 
	941, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 1166, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 941, 941, 941, 941, 941, 
	897, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 942, 941, 942, 942, 942, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 942, 296, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 297, 941, 941, 298, 941, 
	296, 941, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 941, 943, 941, 941, 
	897, 941, 897, 897, 897, 897, 897, 897, 
	897, 1200, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 941, 941, 941, 941, 
	941, 897, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 942, 941, 942, 942, 942, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 942, 296, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 297, 941, 941, 298, 
	941, 296, 941, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 941, 943, 941, 
	941, 897, 941, 897, 897, 897, 897, 1152, 
	897, 897, 897, 1201, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 941, 941, 941, 
	941, 941, 897, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 942, 941, 942, 942, 
	942, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 942, 296, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 297, 941, 941, 
	298, 941, 296, 941, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 941, 943, 
	941, 941, 897, 941, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 1202, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 941, 941, 
	941, 941, 941, 897, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 942, 941, 942, 
	942, 942, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 942, 296, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 297, 941, 
	941, 298, 941, 296, 941, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 941, 
	943, 941, 941, 897, 941, 897, 897, 897, 
	897, 1166, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 941, 
	941, 941, 941, 941, 897, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 942, 941, 
	942, 942, 942, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 942, 296, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 297, 
	941, 941, 298, 941, 296, 941, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	941, 943, 941, 941, 897, 941, 897, 897, 
	897, 897, 897, 897, 897, 897, 1203, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	941, 941, 941, 941, 941, 897, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 942, 
	941, 942, 942, 942, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 942, 296, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	297, 941, 941, 298, 941, 296, 941, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 941, 943, 941, 941, 897, 941, 897, 
	897, 897, 897, 1204, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 941, 941, 941, 941, 941, 897, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	942, 941, 942, 942, 942, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 942, 
	296, 941, 941, 941, 941, 941, 941, 941, 
	941, 941, 941, 941, 941, 941, 941, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 297, 941, 941, 298, 941, 296, 941, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 941, 943, 941, 941, 897, 941, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 897, 1146, 897, 897, 897, 897, 
	897, 897, 897, 897, 897, 897, 897, 897, 
	897, 897, 941, 941, 941, 941, 941, 897, 
	1205, 221, 963, 963, 963, 963, 963, 963, 
	963, 963, 963, 963, 963, 963, 963, 963, 
	963, 963, 963, 963, 963, 963, 963, 963, 
	963, 963, 963, 963, 963, 963, 963, 963, 
	963, 963, 963, 963, 963, 963, 963, 963, 
	963, 963, 963, 963, 963, 963, 963, 963, 
	963, 963, 963, 963, 963, 963, 963, 963, 
	963, 963, 963, 963, 963, 963, 963, 963, 
	1206, 963, 1208, 1207, 1207, 1207, 1208, 1207, 
	1207, 1207, 1207, 1209, 1210, 1209, 1209, 1209, 
	1207, 1207, 1207, 1207, 1207, 1207, 1207, 1207, 
	1207, 1207, 1207, 1207, 1208, 1207, 1207, 1207, 
	1207, 1207, 1209, 1207, 1207, 1211, 1207, 1207, 
	1207, 1207, 1207, 1207, 1207, 1207, 1207, 1207, 
	1207, 1207, 1207, 1207, 1207, 1207, 1207, 1207, 
	1207, 1207, 1207, 1207, 1207, 1207, 1207, 1207, 
	1207, 1207, 1207, 1207, 1207, 1207, 1207, 1207, 
	1207, 1207, 1207, 1207, 1207, 1207, 1207, 1207, 
	1207, 1207, 1207, 1207, 1207, 1207, 1207, 1207, 
	1207, 1207, 1207, 1207, 1207, 1207, 1212, 1207, 
	1209, 1213, 1209, 1209, 1209, 1213, 1213, 1213, 
	1213, 1213, 1213, 1213, 1213, 1213, 1213, 1213, 
	1213, 1213, 1213, 1213, 1213, 1213, 1213, 1209, 
	1213, 1214, 1215, 1216, 1217, 1218, 1220, 1219, 
	1221, 1223, 1224, 1224, 1224, 1223, 1224, 1224, 
	1224, 1224, 1225, 1226, 1225, 1225, 1225, 1224, 
	1224, 1224, 1224, 1224, 1224, 1224, 1224, 1224, 
	1224, 1224, 1224, 1223, 1224, 1224, 1224, 1224, 
	1224, 1225, 1224, 1227, 1228, 1224, 1224, 1224, 
	1227, 1224, 1224, 1224, 1224, 1224, 1224, 1224, 
	1224, 1224, 1224, 1224, 1224, 1224, 1224, 1224, 
	1224, 1224, 1224, 1224, 1224, 1224, 1224, 1224, 
	1224, 1224, 1222, 1222, 1222, 1222, 1222, 1222, 
	1222, 1222, 1222, 1222, 1222, 1222, 1222, 1222, 
	1222, 1222, 1222, 1222, 1222, 1222, 1222, 1222, 
	1222, 1222, 1222, 1222, 1224, 1229, 1224, 1224, 
	1222, 1224, 1222, 1222, 1222, 1222, 1222, 1222, 
	1222, 1222, 1222, 1222, 1222, 1222, 1222, 1222, 
	1222, 1222, 1222, 1222, 1222, 1222, 1222, 1222, 
	1222, 1222, 1222, 1222, 1224, 1224, 1224, 1224, 
	1224, 1222, 1230, 1230, 1230, 1230, 1230, 1230, 
	1230, 1230, 1230, 1230, 1230, 1230, 1230, 1230, 
	1230, 1230, 1230, 1230, 1230, 1230, 1230, 1230, 
	1230, 1230, 1230, 1230, 1230, 1230, 1230, 1230, 
	1230, 1230, 1230, 304, 1230, 1230, 1230, 1230, 
	1230, 1230, 1230, 1230, 1230, 1230, 1230, 1230, 
	1230, 1230, 303, 303, 303, 303, 303, 303, 
	303, 303, 303, 303, 305, 1230, 1230, 1230, 
	1230, 304, 1230, 303, 303, 303, 303, 303, 
	303, 303, 303, 303, 303, 303, 303, 303, 
	303, 303, 303, 303, 303, 303, 303, 303, 
	303, 303, 303, 303, 303, 1230, 1230, 1230, 
	1230, 303, 1230, 303, 303, 303, 303, 303, 
	303, 303, 303, 303, 303, 303, 303, 303, 
	303, 303, 303, 303, 303, 303, 303, 303, 
	303, 303, 303, 303, 303, 1230, 1230, 1230, 
	1230, 1230, 303, 1225, 1231, 1225, 1225, 1225, 
	1231, 1231, 1231, 1231, 1231, 1231, 1231, 1231, 
	1231, 1231, 1231, 1231, 1231, 1231, 1231, 1231, 
	1231, 1231, 1225, 1231, 1232, 1233, 1234, 1235, 
	1236, 1237, 1230, 1238, 1240, 1241, 1241, 1241, 
	1240, 1241, 1241, 1241, 1241, 1242, 1243, 1242, 
	1242, 1242, 1241, 1241, 1241, 1241, 1241, 1241, 
	1241, 1241, 1241, 1241, 1241, 1241, 1240, 1241, 
	1241, 1241, 1241, 1241, 1242, 1244, 1245, 1246, 
	1247, 1248, 1249, 1245, 1250, 1251, 1252, 1248, 
	1253, 1254, 1255, 1248, 1256, 1257, 1257, 1257, 
	1257, 1257, 1257, 1257, 1257, 1257, 1258, 1259, 
	1260, 1261, 1262, 1263, 1264, 1265, 1266, 1265, 
	1265, 1267, 1265, 1265, 1265, 1265, 1265, 1265, 
	1265, 1265, 1265, 1265, 1265, 1265, 1265, 1265, 
	1265, 1265, 1265, 1265, 1265, 1265, 1265, 1268, 
	1269, 1270, 1248, 1271, 1245, 1272, 1273, 1274, 
	1275, 1276, 1277, 1239, 1239, 1278, 1239, 1239, 
	1239, 1279, 1280, 1281, 1239, 1239, 1282, 1283, 
	1284, 1285, 1239, 1286, 1239, 1287, 1239, 1288, 
	1289, 1290, 1291, 1241, 1239, 313, 313, 313, 
	313, 313, 313, 313, 313, 313, 313, 313, 
	313, 313, 313, 313, 313, 313, 313, 313, 
	313, 313, 313, 313, 313, 313, 313, 313, 
	313, 313, 313, 313, 313, 313, 1292, 313, 
	313, 313, 313, 313, 313, 313, 313, 313, 
	313, 313, 313, 313, 313, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 313, 
	313, 313, 313, 313, 1292, 313, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	313, 313, 313, 313, 1239, 313, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	313, 313, 313, 313, 313, 1239, 1294, 1293, 
	1295, 1242, 1296, 1242, 1242, 1242, 1296, 1296, 
	1296, 1296, 1296, 1296, 1296, 1296, 1296, 1296, 
	1296, 1296, 1296, 1296, 1296, 1296, 1296, 1296, 
	1242, 1296, 1297, 1299, 1298, 1298, 1298, 1298, 
	1298, 1298, 1298, 1298, 1298, 1298, 1298, 1298, 
	1298, 1298, 1298, 1298, 1298, 1298, 1298, 1298, 
	1298, 1298, 1298, 1298, 1298, 1298, 1298, 1298, 
	1298, 1298, 1298, 1298, 1298, 1298, 1298, 1298, 
	1298, 1298, 1298, 1298, 1298, 1298, 1298, 1298, 
	1298, 1298, 1298, 1298, 1298, 1298, 1298, 1298, 
	1298, 1298, 1298, 1298, 1298, 1298, 1298, 1298, 
	1298, 1298, 1298, 1298, 1299, 1298, 1300, 1301, 
	1302, 1303, 1304, 1304, 1304, 1304, 1304, 1304, 
	1304, 1304, 1304, 1304, 1304, 1304, 1304, 1304, 
	1304, 1304, 1304, 1304, 1304, 1304, 1304, 1304, 
	1304, 1304, 1304, 1304, 1304, 1304, 1304, 1304, 
	1304, 1304, 1304, 308, 308, 1304, 308, 1304, 
	308, 308, 1304, 1304, 308, 308, 308, 1305, 
	308, 308, 1306, 1306, 1306, 1306, 1306, 1306, 
	1306, 1306, 1306, 1306, 308, 308, 308, 308, 
	308, 308, 308, 325, 325, 325, 325, 325, 
	325, 325, 325, 325, 325, 325, 325, 325, 
	325, 325, 325, 325, 325, 325, 325, 325, 
	325, 325, 325, 325, 325, 1304, 308, 1304, 
	1304, 325, 308, 325, 325, 325, 325, 325, 
	325, 325, 325, 325, 325, 325, 325, 325, 
	325, 325, 325, 325, 325, 325, 325, 325, 
	325, 325, 325, 325, 325, 1304, 1304, 1304, 
	308, 1304, 325, 1307, 1307, 1307, 1307, 1307, 
	1307, 1307, 1307, 1307, 1307, 1307, 1307, 1307, 
	1307, 1307, 1307, 1307, 1307, 1307, 1307, 1307, 
	1307, 1307, 1307, 1307, 1307, 1307, 1307, 1307, 
	1307, 1307, 1307, 1307, 1307, 1307, 1307, 1307, 
	1307, 1307, 1307, 1307, 1307, 1307, 1307, 1307, 
	1307, 1307, 1307, 325, 325, 325, 325, 325, 
	325, 325, 325, 325, 325, 1307, 1307, 1307, 
	1307, 1307, 1307, 1307, 325, 325, 325, 325, 
	325, 325, 325, 325, 325, 325, 325, 325, 
	325, 325, 325, 325, 325, 325, 325, 325, 
	325, 325, 325, 325, 325, 325, 1307, 1307, 
	1307, 1307, 325, 1307, 325, 325, 325, 325, 
	325, 325, 325, 325, 325, 325, 325, 325, 
	325, 325, 325, 325, 325, 325, 325, 325, 
	325, 325, 325, 325, 325, 325, 1307, 1307, 
	1307, 1307, 1307, 325, 1306, 1306, 1306, 1306, 
	1306, 1306, 1306, 1306, 1306, 1306, 1307, 1308, 
	313, 1248, 1309, 1309, 1309, 1309, 1309, 1309, 
	1309, 1310, 1309, 1309, 1309, 1309, 1309, 1309, 
	1309, 1309, 1309, 1309, 1309, 1309, 1309, 1309, 
	1308, 1309, 1311, 1312, 1248, 1313, 1313, 1313, 
	1313, 1313, 1313, 1313, 1313, 1313, 1313, 1313, 
	1313, 1313, 1313, 1313, 1313, 1313, 1313, 1308, 
	1313, 1308, 1314, 1309, 1316, 1315, 312, 312, 
	312, 312, 312, 312, 312, 312, 312, 312, 
	1315, 1318, 1317, 1319, 1317, 312, 312, 312, 
	312, 312, 312, 312, 312, 312, 312, 1320, 
	1320, 1320, 1320, 1320, 1320, 1320, 1320, 1320, 
	1320, 1320, 1321, 1320, 1320, 1320, 1320, 1320, 
	1320, 1320, 1320, 1320, 1320, 1320, 1320, 1320, 
	1320, 1320, 1320, 1320, 1320, 1320, 1320, 1320, 
	1320, 1320, 1320, 1320, 1322, 1320, 1320, 1320, 
	1320, 1320, 1321, 1320, 311, 311, 311, 311, 
	311, 311, 311, 311, 311, 311, 1320, 1320, 
	1320, 1320, 1320, 1320, 1320, 1320, 1320, 1320, 
	1320, 1320, 1320, 1320, 1320, 1320, 1320, 1320, 
	1320, 1320, 1320, 1320, 1320, 1320, 1320, 1320, 
	1320, 1320, 1320, 1320, 1320, 1320, 1320, 1320, 
	1320, 1320, 1320, 310, 1320, 1324, 1323, 1325, 
	1325, 1325, 1325, 1325, 1325, 1325, 1325, 1325, 
	1325, 1323, 1323, 1323, 1323, 1323, 1323, 1323, 
	1323, 1326, 1323, 1327, 1328, 1323, 1323, 1323, 
	1323, 1323, 1323, 1323, 1323, 1323, 1329, 1323, 
	1323, 1323, 1323, 1323, 1323, 1323, 1323, 1330, 
	1323, 1323, 1323, 1323, 1323, 1323, 1331, 1323, 
	1323, 1326, 1323, 1327, 1328, 1323, 1323, 1323, 
	1332, 1323, 1323, 1323, 1323, 1323, 1329, 1323, 
	1323, 1333, 1323, 1323, 1323, 1323, 1323, 1330, 
	1323, 314, 314, 314, 314, 314, 314, 314, 
	314, 314, 314, 1334, 1334, 1334, 1334, 1334, 
	1334, 1334, 1334, 1334, 1334, 1334, 1335, 1334, 
	1334, 1334, 1334, 1334, 1334, 1334, 1334, 1334, 
	1334, 1334, 1334, 1334, 1334, 1334, 1334, 1334, 
	1334, 1334, 1334, 1334, 1334, 1334, 1334, 1334, 
	1336, 1334, 1334, 1334, 1334, 1334, 1335, 1334, 
	1334, 1334, 1337, 1334, 1334, 1334, 1334, 1334, 
	1334, 1334, 1334, 1338, 1334, 1339, 313, 1339, 
	313, 313, 315, 315, 315, 315, 315, 315, 
	315, 315, 315, 315, 313, 315, 315, 315, 
	315, 315, 315, 315, 315, 315, 315, 1340, 
	1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 
	1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 
	1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 
	1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 
	1340, 1340, 1340, 1340, 1339, 1340, 1340, 1340, 
	1340, 1340, 1340, 1340, 1340, 1340, 1341, 1340, 
	1343, 1342, 1344, 1346, 1345, 1345, 1345, 1347, 
	1345, 1348, 1349, 1325, 1325, 1325, 1325, 1325, 
	1325, 1325, 1325, 1325, 1325, 1323, 1323, 1323, 
	1323, 1323, 1323, 1323, 1323, 1323, 1323, 1323, 
	1323, 1323, 1323, 1323, 1323, 1323, 1323, 1323, 
	1323, 1323, 1323, 1323, 1323, 1323, 1323, 1323, 
	1323, 1323, 1323, 1323, 1323, 1323, 1323, 1323, 
	1323, 1323, 1331, 1323, 1323, 1323, 1323, 1323, 
	1323, 1323, 1323, 1323, 1332, 1323, 1323, 1323, 
	1323, 1323, 1323, 1323, 1323, 1333, 1323, 1350, 
	1350, 1350, 1350, 1350, 1350, 1350, 1350, 1350, 
	1350, 1323, 1323, 1323, 1323, 1323, 1323, 1323, 
	1323, 1323, 1323, 1323, 1323, 1323, 1323, 1323, 
	1323, 1323, 1323, 1323, 1323, 1323, 1323, 1323, 
	1323, 1323, 1323, 1323, 1323, 1323, 1323, 1323, 
	1323, 1323, 1323, 1323, 1323, 1323, 1351, 1323, 
	1323, 1323, 1323, 1323, 1323, 1323, 1323, 1323, 
	1332, 1323, 1323, 1323, 1323, 1323, 1323, 1323, 
	1323, 1333, 1323, 1353, 1353, 1353, 1353, 1353, 
	1353, 1353, 1353, 1353, 1353, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1354, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1355, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1356, 1352, 1353, 
	1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 
	1353, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1357, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1355, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1356, 1352, 1355, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1356, 1352, 1359, 1358, 
	1360, 1362, 1361, 1361, 1361, 1363, 1361, 1365, 
	1364, 1366, 1367, 1369, 1369, 1368, 1368, 1368, 
	1368, 1368, 1368, 1368, 1368, 1368, 1368, 1368, 
	1368, 1368, 1368, 1368, 1368, 1368, 1368, 1368, 
	1368, 1368, 1368, 1368, 1368, 1368, 1368, 1368, 
	1368, 1368, 1368, 1368, 1368, 1368, 1368, 1368, 
	1368, 1368, 1368, 1368, 1368, 1368, 1368, 1368, 
	1368, 1368, 1370, 1368, 1368, 1368, 1368, 1368, 
	1368, 1368, 1368, 1368, 1371, 1368, 1368, 1368, 
	1368, 1368, 1368, 1368, 1368, 1372, 1368, 1373, 
	1373, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1374, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1355, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1356, 1352, 1373, 1373, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1357, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1355, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1356, 1352, 1376, 
	1376, 1376, 1376, 1376, 1376, 1376, 1376, 1376, 
	1376, 1375, 1375, 1375, 1375, 1375, 1375, 1375, 
	1375, 1375, 1375, 1375, 1375, 1375, 1375, 1375, 
	1375, 1375, 1375, 1375, 1375, 1375, 1375, 1375, 
	1375, 1375, 1375, 1375, 1375, 1375, 1375, 1375, 
	1375, 1375, 1375, 1375, 1375, 1375, 1377, 1375, 
	1375, 1375, 1375, 1375, 1375, 1375, 1375, 1375, 
	1378, 1375, 1375, 1375, 1375, 1375, 1375, 1375, 
	1375, 1379, 1375, 1381, 1381, 1381, 1381, 1381, 
	1381, 1381, 1381, 1381, 1381, 1380, 1380, 1380, 
	1380, 1380, 1380, 1380, 1380, 1380, 1380, 1380, 
	1380, 1380, 1380, 1380, 1380, 1380, 1380, 1380, 
	1380, 1380, 1380, 1380, 1380, 1380, 1380, 1380, 
	1380, 1380, 1380, 1380, 1380, 1380, 1380, 1380, 
	1380, 1380, 1382, 1380, 1380, 1380, 1380, 1380, 
	1380, 1380, 1380, 1380, 1383, 1380, 1380, 1380, 
	1380, 1380, 1380, 1380, 1380, 1384, 1380, 1386, 
	1386, 1386, 1386, 1386, 1386, 1386, 1386, 1386, 
	1386, 1385, 1385, 1385, 1385, 1385, 1385, 1385, 
	1386, 1386, 1386, 1386, 1386, 1386, 1385, 1385, 
	1385, 1385, 1385, 1385, 1385, 1385, 1385, 1385, 
	1385, 1385, 1385, 1385, 1385, 1385, 1385, 1385, 
	1385, 1385, 1385, 1385, 1385, 1385, 1387, 1385, 
	1386, 1386, 1386, 1386, 1386, 1386, 1385, 1385, 
	1388, 1385, 1385, 1385, 1385, 1385, 1385, 1385, 
	1385, 1389, 1385, 1390, 1390, 1390, 1390, 1390, 
	1390, 1390, 1390, 1390, 1390, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1390, 1390, 1390, 1390, 
	1390, 1390, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1391, 1352, 1390, 1390, 1390, 1390, 
	1390, 1390, 1352, 1352, 1355, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1356, 1352, 1390, 
	1390, 1390, 1390, 1390, 1390, 1390, 1390, 1390, 
	1390, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1390, 1390, 1390, 1390, 1390, 1390, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1357, 1352, 
	1390, 1390, 1390, 1390, 1390, 1390, 1352, 1352, 
	1355, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1356, 1352, 1393, 1392, 1394, 1394, 1394, 
	1394, 1394, 1394, 1394, 1394, 1394, 1394, 1392, 
	1392, 1392, 1392, 1392, 1392, 1392, 1392, 1392, 
	1392, 1392, 1395, 1392, 1392, 1392, 1392, 1392, 
	1392, 1392, 1392, 1392, 1392, 1392, 1392, 1392, 
	1392, 1392, 1392, 1392, 1392, 1392, 1392, 1392, 
	1392, 1392, 1392, 1392, 1396, 1392, 1392, 1392, 
	1392, 1392, 1395, 1392, 1392, 1392, 1397, 1392, 
	1392, 1392, 1392, 1392, 1392, 1392, 1392, 1398, 
	1392, 1399, 1399, 1399, 1399, 1399, 1399, 1399, 
	1399, 1399, 1399, 1392, 1392, 1392, 1392, 1392, 
	1392, 1392, 1392, 1392, 1392, 1392, 1392, 1392, 
	1392, 1392, 1392, 1392, 1392, 1392, 1392, 1392, 
	1392, 1392, 1392, 1392, 1392, 1392, 1392, 1392, 
	1392, 1392, 1392, 1392, 1392, 1392, 1392, 1392, 
	1400, 1392, 1392, 1392, 1392, 1392, 1392, 1392, 
	1392, 1392, 1397, 1392, 1392, 1392, 1392, 1392, 
	1392, 1392, 1392, 1398, 1392, 1401, 1352, 1402, 
	1402, 1402, 1402, 1402, 1402, 1402, 1402, 1402, 
	1402, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1403, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1404, 1352, 
	1352, 1352, 1352, 1352, 1403, 1352, 1352, 1352, 
	1355, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1356, 1352, 1402, 1402, 1402, 1402, 1402, 
	1402, 1402, 1402, 1402, 1402, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1357, 1352, 1352, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1355, 1352, 1352, 1352, 
	1352, 1352, 1352, 1352, 1352, 1356, 1352, 1310, 
	1317, 1248, 1405, 1309, 1299, 1309, 1406, 1407, 
	1317, 1317, 1317, 1317, 1317, 1317, 1317, 1317, 
	1317, 1317, 1317, 1317, 1317, 1317, 1317, 1317, 
	1317, 1317, 1317, 1317, 1317, 1317, 1317, 1317, 
	1317, 1317, 1317, 1317, 1317, 1317, 1317, 1317, 
	1317, 1317, 1317, 1317, 1317, 1317, 1317, 1317, 
	1317, 1317, 1317, 1317, 1317, 1317, 1317, 1317, 
	1317, 1317, 1317, 1317, 1317, 1317, 1317, 1317, 
	1317, 1317, 1317, 1317, 1317, 1317, 1317, 1299, 
	1317, 1299, 1309, 1299, 1248, 1309, 1304, 1304, 
	1304, 1304, 1304, 1304, 1304, 1304, 1304, 1304, 
	1304, 1304, 1304, 1304, 1304, 1304, 1304, 1304, 
	1304, 1304, 1304, 1304, 1304, 1304, 1304, 1304, 
	1304, 1304, 1304, 1304, 1304, 1304, 1304, 1304, 
	1304, 1304, 1304, 1304, 1304, 1304, 1304, 1304, 
	1304, 1304, 1304, 1304, 1304, 1304, 325, 325, 
	325, 325, 325, 325, 325, 325, 325, 325, 
	1304, 1304, 1304, 1304, 1304, 1304, 1408, 325, 
	325, 325, 325, 325, 325, 325, 325, 325, 
	325, 325, 325, 325, 325, 325, 325, 325, 
	325, 325, 325, 325, 325, 325, 325, 325, 
	325, 1304, 1304, 1304, 1304, 325, 1304, 325, 
	325, 325, 325, 325, 325, 325, 325, 325, 
	325, 325, 325, 325, 325, 325, 325, 325, 
	325, 325, 325, 325, 325, 325, 325, 325, 
	325, 1304, 1304, 1304, 1304, 1304, 325, 313, 
	313, 313, 313, 313, 313, 313, 313, 313, 
	313, 313, 313, 313, 313, 313, 313, 313, 
	313, 313, 313, 313, 313, 313, 313, 313, 
	313, 313, 313, 313, 313, 313, 313, 313, 
	1292, 313, 313, 313, 313, 313, 313, 313, 
	313, 313, 313, 313, 313, 313, 313, 1265, 
	1265, 1265, 1265, 1265, 1265, 1265, 1265, 1265, 
	1265, 1409, 313, 313, 313, 313, 1292, 313, 
	1265, 1265, 1265, 1265, 1265, 1265, 1265, 1265, 
	1265, 1265, 1265, 1265, 1265, 1265, 1265, 1265, 
	1265, 1265, 1265, 1265, 1265, 1265, 1265, 1265, 
	1265, 1265, 313, 313, 313, 313, 1265, 313, 
	1265, 1265, 1265, 1265, 1265, 1265, 1265, 1265, 
	1265, 1265, 1265, 1265, 1265, 1265, 1265, 1265, 
	1265, 1265, 1265, 1265, 1265, 1265, 1265, 1265, 
	1265, 1265, 313, 313, 313, 313, 313, 1265, 
	1410, 1411, 1411, 1411, 1411, 1411, 1411, 1411, 
	1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411, 
	1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411, 
	1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411, 
	1411, 1411, 1292, 1411, 1411, 1411, 1411, 1411, 
	1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411, 
	1411, 1265, 1265, 1265, 1265, 1265, 1265, 1265, 
	1265, 1265, 1265, 1409, 1411, 1411, 1411, 1411, 
	1292, 1411, 1265, 1265, 1265, 1265, 1412, 1265, 
	1265, 1265, 1265, 1265, 1265, 1265, 1265, 1265, 
	1265, 1265, 1265, 1265, 1265, 1265, 1265, 1265, 
	1265, 1265, 1265, 1265, 1411, 1411, 1411, 1411, 
	1265, 1411, 1265, 1265, 1265, 1265, 1265, 1265, 
	1265, 1265, 1265, 1265, 1265, 1265, 1265, 1265, 
	1265, 1265, 1265, 1265, 1265, 1265, 1265, 1265, 
	1265, 1265, 1265, 1265, 1411, 1411, 1411, 1411, 
	1411, 1265, 1411, 1411, 1411, 1411, 1411, 1411, 
	1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411, 
	1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411, 
	1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411, 
	1411, 1411, 1411, 1292, 1411, 1411, 1411, 1411, 
	1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411, 
	1411, 1411, 1265, 1265, 1265, 1265, 1265, 1265, 
	1265, 1265, 1265, 1265, 1409, 1411, 1411, 1411, 
	1411, 1292, 1411, 1265, 1265, 1265, 1265, 1265, 
	1265, 1413, 1265, 1265, 1265, 1265, 1265, 1265, 
	1265, 1265, 1265, 1265, 1265, 1265, 1265, 1265, 
	1265, 1265, 1265, 1265, 1265, 1411, 1411, 1411, 
	1411, 1265, 1411, 1265, 1265, 1265, 1265, 1265, 
	1265, 1265, 1265, 1265, 1265, 1265, 1265, 1265, 
	1265, 1265, 1265, 1265, 1265, 1265, 1265, 1265, 
	1265, 1265, 1265, 1265, 1265, 1411, 1411, 1411, 
	1411, 1411, 1265, 1411, 1411, 1411, 1411, 1411, 
	1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411, 
	1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411, 
	1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411, 
	1411, 1411, 1411, 1411, 1292, 1411, 1411, 1411, 
	1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411, 
	1411, 1411, 1411, 1265, 1265, 1265, 1265, 1265, 
	1265, 1265, 1265, 1265, 1265, 1409, 1411, 1411, 
	1411, 1411, 1292, 1411, 1265, 1265, 1265, 1265, 
	1265, 1265, 1265, 1265, 1414, 1265, 1265, 1265, 
	1265, 1265, 1265, 1265, 1265, 1265, 1265, 1265, 
	1265, 1265, 1265, 1265, 1265, 1265, 1411, 1411, 
	1411, 1411, 1265, 1411, 1265, 1265, 1265, 1265, 
	1265, 1265, 1265, 1265, 1265, 1265, 1265, 1265, 
	1265, 1265, 1265, 1265, 1265, 1265, 1265, 1265, 
	1265, 1265, 1265, 1265, 1265, 1265, 1411, 1411, 
	1411, 1411, 1411, 1265, 1411, 1411, 1411, 1411, 
	1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411, 
	1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411, 
	1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411, 
	1411, 1411, 1411, 1411, 1411, 1292, 1411, 1411, 
	1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411, 
	1411, 1411, 1411, 1411, 1265, 1265, 1265, 1265, 
	1265, 1265, 1265, 1265, 1265, 1265, 1409, 1411, 
	1411, 1411, 1411, 1292, 1411, 1265, 1265, 1265, 
	1265, 1265, 1265, 1265, 1265, 1265, 1265, 1265, 
	1265, 1265, 1415, 1265, 1265, 1265, 1265, 1265, 
	1265, 1265, 1265, 1265, 1265, 1265, 1265, 1411, 
	1411, 1411, 1411, 1265, 1411, 1265, 1265, 1265, 
	1265, 1265, 1265, 1265, 1265, 1265, 1265, 1265, 
	1265, 1265, 1265, 1265, 1265, 1265, 1265, 1265, 
	1265, 1265, 1265, 1265, 1265, 1265, 1265, 1411, 
	1411, 1411, 1411, 1411, 1265, 1411, 1411, 1411, 
	1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411, 
	1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411, 
	1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411, 
	1411, 1411, 1411, 1411, 1411, 1411, 1292, 1411, 
	1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411, 
	1411, 1411, 1411, 1411, 1411, 1265, 1265, 1265, 
	1265, 1265, 1265, 1265, 1265, 1265, 1265, 1409, 
	1411, 1411, 1411, 1411, 1292, 1411, 1265, 1265, 
	1265, 1265, 1265, 1265, 1265, 1265, 1265, 1265, 
	1265, 1265, 1265, 1416, 1265, 1265, 1265, 1265, 
	1265, 1265, 1265, 1265, 1265, 1265, 1265, 1265, 
	1411, 1411, 1411, 1411, 1265, 1411, 1265, 1265, 
	1265, 1265, 1265, 1265, 1265, 1265, 1265, 1265, 
	1265, 1265, 1265, 1265, 1265, 1265, 1265, 1265, 
	1265, 1265, 1265, 1265, 1265, 1265, 1265, 1265, 
	1411, 1411, 1411, 1411, 1411, 1265, 1411, 1411, 
	1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411, 
	1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411, 
	1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411, 
	1411, 1411, 1411, 1411, 1411, 1411, 1411, 1292, 
	1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411, 
	1411, 1411, 1411, 1411, 1411, 1411, 1265, 1265, 
	1265, 1265, 1265, 1265, 1265, 1265, 1265, 1265, 
	1409, 1411, 1411, 1411, 1411, 1292, 1411, 1265, 
	1265, 1265, 1415, 1265, 1265, 1265, 1265, 1265, 
	1265, 1265, 1265, 1265, 1265, 1265, 1265, 1265, 
	1265, 1265, 1265, 1265, 1265, 1265, 1265, 1265, 
	1265, 1411, 1411, 1411, 1411, 1265, 1411, 1265, 
	1265, 1265, 1265, 1265, 1265, 1265, 1265, 1265, 
	1265, 1265, 1265, 1265, 1265, 1265, 1265, 1265, 
	1265, 1265, 1265, 1265, 1265, 1265, 1265, 1265, 
	1265, 1411, 1411, 1411, 1411, 1411, 1265, 1417, 
	1419, 1418, 1420, 1421, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1292, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1422, 1422, 
	1422, 1422, 1422, 1292, 1422, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1422, 
	1422, 1422, 1422, 1423, 1422, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1422, 
	1422, 1422, 1422, 1422, 1239, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1292, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1422, 
	1422, 1422, 1422, 1422, 1292, 1422, 1239, 1239, 
	1239, 1239, 1424, 1425, 1239, 1239, 1239, 1239, 
	1239, 1426, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1422, 1422, 1422, 1422, 1239, 1422, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1422, 1422, 1422, 1422, 1422, 1239, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1292, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1422, 1422, 1422, 1422, 1422, 1292, 1422, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1427, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1422, 1422, 1422, 1422, 1239, 1422, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1422, 1422, 1422, 1422, 1422, 1239, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1292, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1422, 1422, 1422, 1422, 1422, 1292, 1422, 
	1239, 1239, 1428, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1422, 1422, 1422, 1422, 1239, 1422, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1422, 1422, 1422, 1422, 1422, 1239, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1292, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1422, 1422, 1422, 1422, 1422, 1292, 
	1422, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1429, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1422, 1422, 1422, 1422, 1239, 
	1422, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1422, 1422, 1422, 1422, 1422, 
	1239, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1292, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1422, 1422, 1422, 1422, 1422, 
	1292, 1422, 1239, 1239, 1239, 1430, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1422, 1422, 1422, 1422, 
	1239, 1422, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1422, 1422, 1422, 1422, 
	1422, 1239, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1292, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1422, 1422, 1422, 1422, 
	1422, 1292, 1422, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1431, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1422, 1422, 1422, 
	1422, 1239, 1422, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1422, 1422, 1422, 
	1422, 1422, 1239, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1292, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1422, 1422, 1422, 
	1422, 1422, 1292, 1422, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1432, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1422, 1422, 
	1422, 1422, 1239, 1422, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1422, 1422, 
	1422, 1422, 1422, 1239, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1292, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1422, 1422, 
	1422, 1422, 1422, 1292, 1422, 1239, 1239, 1239, 
	1239, 1239, 1239, 1433, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1422, 
	1422, 1422, 1422, 1239, 1422, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1422, 
	1422, 1422, 1422, 1422, 1239, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1292, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1422, 
	1422, 1422, 1422, 1422, 1292, 1422, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1422, 1422, 1422, 1422, 1434, 1422, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1422, 1422, 1422, 1422, 1422, 1239, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1292, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1422, 1422, 1422, 1422, 1422, 1292, 1422, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1422, 1422, 1422, 1422, 1435, 1422, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1422, 1422, 1422, 1422, 1422, 1239, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1292, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1422, 1422, 1422, 1422, 1422, 1292, 1422, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1436, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1422, 1422, 1422, 1422, 1239, 1422, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1422, 1422, 1422, 1422, 1422, 1239, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1292, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1422, 1422, 1422, 1422, 1422, 1292, 
	1422, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1437, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1422, 1422, 1422, 1422, 1239, 
	1422, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1422, 1422, 1422, 1422, 1422, 
	1239, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1292, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1422, 1422, 1422, 1422, 1422, 
	1292, 1422, 1239, 1239, 1239, 1239, 1438, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1422, 1422, 1422, 1422, 
	1239, 1422, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1422, 1422, 1422, 1422, 
	1422, 1239, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1292, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1422, 1422, 1422, 1422, 
	1422, 1292, 1422, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1422, 1422, 1422, 
	1422, 1439, 1422, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1422, 1422, 1422, 
	1422, 1422, 1239, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1292, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1422, 1422, 1422, 
	1422, 1422, 1292, 1422, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1422, 1422, 
	1422, 1422, 1440, 1422, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1422, 1422, 
	1422, 1422, 1422, 1239, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1292, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1422, 1422, 
	1422, 1422, 1422, 1292, 1422, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1441, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1422, 
	1422, 1422, 1422, 1239, 1422, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1422, 
	1422, 1422, 1422, 1422, 1239, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1292, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1422, 
	1422, 1422, 1422, 1422, 1292, 1422, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1437, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1422, 1422, 1422, 1422, 1239, 1422, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1422, 1422, 1422, 1422, 1422, 1239, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1292, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1422, 1422, 1422, 1422, 1422, 1292, 1422, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1422, 1422, 1422, 1422, 1239, 1422, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1442, 1239, 1443, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1422, 1422, 1422, 1422, 1422, 1239, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1292, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1422, 1422, 1422, 1422, 1422, 1292, 1422, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1422, 1422, 1422, 1422, 1239, 1422, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1444, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1422, 1422, 1422, 1422, 1422, 1239, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1292, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1422, 1422, 1422, 1422, 1422, 1292, 
	1422, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1422, 1422, 1422, 1422, 1239, 
	1422, 1445, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1422, 1422, 1422, 1422, 1422, 
	1239, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1292, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1422, 1422, 1422, 1422, 1422, 
	1292, 1422, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1422, 1422, 1422, 1422, 
	1239, 1422, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1446, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1422, 1422, 1422, 1422, 
	1422, 1239, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1292, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1422, 1422, 1422, 1422, 
	1422, 1292, 1422, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1422, 1422, 1422, 
	1422, 1239, 1422, 1239, 1239, 1239, 1447, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1422, 1422, 1422, 
	1422, 1422, 1239, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1292, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1422, 1422, 1422, 
	1422, 1422, 1292, 1422, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1422, 1422, 
	1422, 1422, 1239, 1422, 1239, 1239, 1239, 1239, 
	1448, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1449, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1422, 1422, 
	1422, 1422, 1422, 1239, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1292, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1422, 1422, 
	1422, 1422, 1422, 1292, 1422, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1422, 
	1422, 1422, 1422, 1239, 1422, 1239, 1239, 1239, 
	1239, 1239, 1239, 1450, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1422, 
	1422, 1422, 1422, 1422, 1239, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1292, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1422, 
	1422, 1422, 1422, 1422, 1292, 1422, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1422, 1422, 1422, 1422, 1239, 1422, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1451, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1422, 1422, 1422, 1422, 1422, 1239, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1292, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1422, 1422, 1422, 1422, 1422, 1292, 1422, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1422, 1422, 1422, 1422, 1239, 1422, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1447, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1422, 1422, 1422, 1422, 1422, 1239, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1292, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1422, 1422, 1422, 1422, 1422, 1292, 1422, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1422, 1422, 1422, 1422, 1239, 1422, 
	1239, 1239, 1239, 1239, 1452, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1422, 1422, 1422, 1422, 1422, 1239, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1292, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1422, 1422, 1422, 1422, 1422, 1292, 
	1422, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1422, 1422, 1422, 1422, 1239, 
	1422, 1453, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1422, 1422, 1422, 1422, 1422, 
	1239, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1292, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1422, 1422, 1422, 1422, 1422, 
	1292, 1422, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1422, 1422, 1422, 1422, 
	1239, 1422, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1454, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1422, 1422, 1422, 1422, 
	1422, 1239, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1292, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1422, 1422, 1422, 1422, 
	1422, 1292, 1422, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1422, 1422, 1422, 
	1422, 1239, 1422, 1455, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1456, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1422, 1422, 1422, 
	1422, 1422, 1239, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1292, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1422, 1422, 1422, 
	1422, 1422, 1292, 1422, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1422, 1422, 
	1422, 1422, 1239, 1422, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1457, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1422, 1422, 
	1422, 1422, 1422, 1239, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1292, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1422, 1422, 
	1422, 1422, 1422, 1292, 1422, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1422, 
	1422, 1422, 1422, 1239, 1422, 1239, 1239, 1239, 
	1239, 1447, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1422, 
	1422, 1422, 1422, 1422, 1239, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1292, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1422, 
	1422, 1422, 1422, 1422, 1292, 1422, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1422, 1422, 1422, 1422, 1239, 1422, 1458, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1422, 1422, 1422, 1422, 1422, 1239, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1292, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1422, 1422, 1422, 1422, 1422, 1292, 1422, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1422, 1422, 1422, 1422, 1239, 1422, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1459, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1422, 1422, 1422, 1422, 1422, 1239, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1292, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1422, 1422, 1422, 1422, 1422, 1292, 1422, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1422, 1422, 1422, 1422, 1239, 1422, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1460, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1422, 1422, 1422, 1422, 1422, 1239, 
	1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461, 
	1461, 327, 328, 327, 327, 327, 1461, 1461, 
	1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461, 
	1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461, 
	327, 1292, 1461, 329, 1461, 1461, 1461, 1461, 
	1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1461, 1461, 330, 1461, 1461, 1292, 
	1461, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1461, 331, 1461, 1461, 1239, 
	1461, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1461, 1461, 1461, 1461, 1461, 
	1239, 344, 345, 344, 344, 344, 343, 343, 
	343, 343, 343, 343, 343, 343, 343, 343, 
	343, 343, 343, 343, 343, 343, 343, 343, 
	344, 343, 343, 346, 343, 343, 343, 343, 
	343, 343, 343, 343, 343, 343, 343, 343, 
	343, 343, 343, 343, 343, 343, 343, 343, 
	343, 343, 343, 343, 349, 343, 343, 343, 
	343, 343, 343, 343, 343, 343, 343, 343, 
	343, 343, 343, 343, 343, 343, 343, 343, 
	343, 343, 343, 343, 343, 343, 343, 343, 
	343, 343, 343, 343, 348, 343, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1292, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1422, 1422, 1422, 1422, 1422, 1292, 1422, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1422, 1422, 1422, 1422, 1239, 1422, 1239, 
	1239, 1239, 1239, 1463, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1464, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1422, 1422, 1422, 1422, 1422, 1239, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1292, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1422, 1422, 1422, 1422, 1422, 1292, 1422, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1422, 1422, 1422, 1422, 1239, 1422, 
	1239, 1239, 1239, 1239, 1239, 1465, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1422, 1422, 1422, 1422, 1422, 1239, 
	1466, 1466, 1466, 1466, 1466, 1466, 1466, 1466, 
	1466, 1466, 1466, 1466, 1466, 1466, 1466, 1466, 
	1466, 1466, 1466, 1466, 1466, 1466, 1466, 1466, 
	1466, 1466, 1466, 1466, 1466, 1466, 1466, 1466, 
	1466, 1292, 1466, 1466, 1466, 1466, 1466, 1466, 
	1466, 1466, 1466, 1466, 1466, 1466, 1466, 1466, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1466, 1466, 1466, 1466, 1466, 1292, 
	1466, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1466, 1466, 1466, 1466, 1239, 
	1466, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1467, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1466, 1466, 1466, 1466, 1466, 
	1239, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1292, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1422, 1422, 1422, 1422, 1422, 
	1292, 1422, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1422, 1422, 1422, 1422, 
	1239, 1422, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1468, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1422, 1422, 1422, 1422, 
	1422, 1239, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1292, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1422, 1422, 1422, 1422, 
	1422, 1292, 1422, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1422, 1422, 1422, 
	1422, 1239, 1422, 1239, 1239, 1239, 1239, 1469, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1422, 1422, 1422, 
	1422, 1422, 1239, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1292, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1422, 1422, 1422, 
	1422, 1422, 1292, 1422, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1422, 1422, 
	1422, 1422, 1239, 1422, 1239, 1239, 1239, 1470, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1422, 1422, 
	1422, 1422, 1422, 1239, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1292, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1422, 1422, 
	1422, 1422, 1422, 1471, 1422, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1422, 
	1422, 1422, 1422, 1239, 1422, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1422, 
	1422, 1422, 1422, 1422, 1239, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1292, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1422, 
	1422, 1422, 1422, 1422, 1292, 1422, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1422, 1422, 1422, 1422, 1239, 1422, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1472, 1239, 1473, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1422, 1422, 1422, 1422, 1422, 1239, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1292, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1422, 1422, 1422, 1422, 1422, 1292, 1422, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1422, 1422, 1422, 1422, 1239, 1422, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1474, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1422, 1422, 1422, 1422, 1422, 1239, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1292, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1422, 1422, 1422, 1422, 1422, 1292, 1422, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1422, 1422, 1422, 1422, 1239, 1422, 
	1239, 1239, 1239, 1239, 1447, 1239, 1239, 1239, 
	1475, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1422, 1422, 1422, 1422, 1422, 1239, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1292, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1422, 1422, 1422, 1422, 1422, 1292, 
	1422, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1422, 1422, 1422, 1422, 1239, 
	1422, 1239, 1239, 1239, 1239, 1239, 1447, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1422, 1422, 1422, 1422, 1422, 
	1239, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1292, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1422, 1422, 1422, 1422, 1422, 
	1292, 1422, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1422, 1422, 1422, 1422, 
	1239, 1422, 1239, 1239, 1239, 1440, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1476, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1422, 1422, 1422, 1422, 
	1422, 1239, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1292, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1422, 1422, 1422, 1422, 
	1422, 1292, 1422, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1422, 1422, 1422, 
	1422, 1239, 1422, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1477, 
	1239, 1239, 1239, 1239, 1239, 1422, 1422, 1422, 
	1422, 1422, 1239, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1292, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1422, 1422, 1422, 
	1422, 1422, 1292, 1422, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1422, 1422, 
	1422, 1422, 1239, 1422, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1457, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1422, 1422, 
	1422, 1422, 1422, 1239, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1292, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1422, 1422, 
	1422, 1422, 1422, 1292, 1422, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1422, 
	1422, 1422, 1422, 1239, 1422, 1478, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1281, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1422, 
	1422, 1422, 1422, 1422, 1239, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1292, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1422, 
	1422, 1422, 1422, 1422, 1292, 1422, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1422, 1422, 1422, 1422, 1239, 1422, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1479, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1422, 1422, 1422, 1422, 1422, 1239, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1292, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1422, 1422, 1422, 1422, 1422, 1292, 1422, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1422, 1422, 1422, 1422, 1239, 1422, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1480, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1422, 1422, 1422, 1422, 1422, 1239, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1292, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1422, 1422, 1422, 1422, 1422, 1292, 1422, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1422, 1422, 1422, 1422, 1239, 1422, 
	1239, 1239, 1239, 1239, 1440, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1422, 1422, 1422, 1422, 1422, 1239, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1292, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1422, 1422, 1422, 1422, 1422, 1292, 
	1422, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1422, 1422, 1422, 1422, 1239, 
	1422, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1447, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1422, 1422, 1422, 1422, 1422, 
	1239, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1292, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1422, 1422, 1422, 1422, 1422, 
	1292, 1422, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1422, 1422, 1422, 1422, 
	1239, 1422, 1239, 1239, 1239, 1239, 1239, 1481, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1447, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1422, 1422, 1422, 1422, 
	1422, 1239, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1292, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1422, 1422, 1422, 1422, 
	1422, 1292, 1422, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1422, 1422, 1422, 
	1422, 1239, 1422, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1482, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1422, 1422, 1422, 
	1422, 1422, 1239, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1292, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1422, 1422, 1422, 
	1422, 1422, 1292, 1422, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1422, 1422, 
	1422, 1422, 1239, 1422, 1239, 1239, 1239, 1483, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1422, 1422, 
	1422, 1422, 1422, 1239, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1292, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1422, 1422, 
	1422, 1422, 1422, 1292, 1422, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1422, 
	1422, 1422, 1422, 1239, 1422, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1484, 1239, 1239, 1239, 1239, 1239, 1422, 
	1422, 1422, 1422, 1422, 1239, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1292, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1422, 
	1422, 1422, 1422, 1422, 1292, 1422, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1422, 1422, 1422, 1422, 1239, 1422, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1457, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1422, 1422, 1422, 1422, 1422, 1239, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1292, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1422, 1422, 1422, 1422, 1422, 1292, 1422, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1422, 1422, 1422, 1422, 1239, 1422, 1239, 
	1239, 1239, 1239, 1485, 1239, 1239, 1239, 1486, 
	1239, 1239, 1239, 1239, 1239, 1487, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1422, 1422, 1422, 1422, 1422, 1239, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1292, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1422, 1422, 1422, 1422, 1422, 1292, 1422, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1422, 1422, 1422, 1422, 1239, 1422, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1488, 
	1239, 1239, 1422, 1422, 1422, 1422, 1422, 1239, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1292, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1422, 1422, 1422, 1422, 1422, 1292, 
	1422, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1422, 1422, 1422, 1422, 1239, 
	1422, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1454, 1239, 1239, 1239, 
	1239, 1239, 1239, 1422, 1422, 1422, 1422, 1422, 
	1239, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1292, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1422, 1422, 1422, 1422, 1422, 
	1292, 1422, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1422, 1422, 1422, 1422, 
	1239, 1422, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1440, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1422, 1422, 1422, 1422, 
	1422, 1239, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1292, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1422, 1422, 1422, 1422, 
	1422, 1292, 1422, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1422, 1422, 1422, 
	1422, 1239, 1422, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1489, 1239, 
	1239, 1239, 1239, 1239, 1239, 1422, 1422, 1422, 
	1422, 1422, 1239, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1292, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1422, 1422, 1422, 
	1422, 1422, 1292, 1422, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1422, 1422, 
	1422, 1422, 1239, 1422, 1239, 1239, 1239, 1239, 
	1490, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1422, 1422, 
	1422, 1422, 1422, 1239, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1292, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1422, 1422, 
	1422, 1422, 1422, 1292, 1422, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1422, 
	1422, 1422, 1422, 1239, 1422, 1239, 1239, 1239, 
	1491, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1492, 
	1493, 1239, 1239, 1239, 1239, 1239, 1239, 1422, 
	1422, 1422, 1422, 1422, 1239, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1292, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1422, 
	1422, 1422, 1422, 1422, 1292, 1422, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1422, 1422, 1422, 1422, 1239, 1422, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1440, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1422, 1422, 1422, 1422, 1422, 1239, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1292, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1422, 1422, 1422, 1422, 1422, 1292, 1422, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1422, 1422, 1422, 1422, 1239, 1422, 1239, 
	1239, 1494, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1422, 1422, 1422, 1422, 1422, 1239, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1292, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1422, 1422, 1422, 1422, 1422, 1292, 1422, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1422, 1422, 1422, 1422, 1239, 1422, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1495, 1239, 1239, 1239, 
	1239, 1239, 1422, 1422, 1422, 1422, 1422, 1239, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1292, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1422, 1422, 1422, 1422, 1422, 1292, 
	1422, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1422, 1422, 1422, 1422, 1239, 
	1422, 1239, 1239, 1239, 1239, 1481, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1422, 1422, 1422, 1422, 1422, 
	1239, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1292, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1422, 1422, 1422, 1422, 1422, 
	1292, 1422, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1422, 1422, 1422, 1422, 
	1239, 1422, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1496, 1239, 1239, 1497, 1239, 
	1239, 1239, 1239, 1239, 1422, 1422, 1422, 1422, 
	1422, 1239, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1292, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1422, 1422, 1422, 1422, 
	1422, 1292, 1422, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1422, 1422, 1422, 
	1422, 1239, 1422, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1440, 1239, 1422, 1422, 1422, 
	1422, 1422, 1239, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1292, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1422, 1422, 1422, 
	1422, 1422, 1292, 1422, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1422, 1422, 
	1422, 1422, 1239, 1422, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1498, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1422, 1422, 
	1422, 1422, 1422, 1239, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1292, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1422, 1422, 
	1422, 1422, 1422, 1292, 1422, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1422, 
	1422, 1422, 1422, 1239, 1422, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1454, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1422, 
	1422, 1422, 1422, 1422, 1239, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1292, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1422, 
	1422, 1422, 1422, 1422, 1292, 1422, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1422, 1422, 1422, 1422, 1239, 1422, 1239, 1239, 
	1239, 1239, 1499, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1500, 1239, 1239, 1239, 1239, 1239, 
	1422, 1422, 1422, 1422, 1422, 1239, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1292, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1422, 1422, 1422, 1422, 1422, 1292, 1422, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1422, 1422, 1422, 1422, 1239, 1422, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1501, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1422, 1422, 1422, 1422, 1422, 1239, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1292, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1422, 1422, 1422, 1422, 1422, 1292, 1422, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1422, 1422, 1422, 1422, 1239, 1422, 
	1239, 1239, 1239, 1239, 1239, 1440, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1422, 1422, 1422, 1422, 1422, 1239, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1292, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1422, 1422, 1422, 1422, 1422, 1292, 
	1422, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1422, 1422, 1422, 1422, 1239, 
	1422, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1502, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1422, 1422, 1422, 1422, 1422, 
	1239, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1292, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1422, 1422, 1422, 1422, 1422, 
	1292, 1422, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1422, 1422, 1422, 1422, 
	1239, 1422, 1239, 1239, 1239, 1239, 1503, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1422, 1422, 1422, 1422, 
	1422, 1239, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1292, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1422, 1422, 1422, 1422, 
	1422, 1292, 1422, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1422, 1422, 1422, 
	1422, 1239, 1422, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1489, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1422, 1422, 1422, 
	1422, 1422, 1239, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1292, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1422, 1422, 1422, 
	1422, 1422, 1292, 1422, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1422, 1422, 
	1422, 1422, 1239, 1422, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1504, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1505, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1422, 1422, 
	1422, 1422, 1422, 1239, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1292, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1422, 1422, 
	1422, 1422, 1422, 1292, 1422, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1422, 
	1422, 1422, 1422, 1239, 1422, 1239, 1239, 1239, 
	1239, 1451, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1422, 
	1422, 1422, 1422, 1422, 1239, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1292, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1422, 
	1422, 1422, 1422, 1422, 1292, 1422, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1422, 1422, 1422, 1422, 1239, 1422, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1480, 1239, 1239, 1239, 1239, 1239, 
	1422, 1422, 1422, 1422, 1422, 1239, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1292, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1422, 1422, 1422, 1422, 1422, 1292, 1422, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1422, 1422, 1422, 1422, 1239, 1422, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1506, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1422, 1422, 1422, 1422, 1422, 1239, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1292, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1422, 1422, 1422, 1422, 1422, 1292, 1422, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1422, 1422, 1422, 1422, 1239, 1422, 
	1239, 1239, 1239, 1507, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1508, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1509, 1239, 1239, 1239, 1239, 
	1239, 1239, 1422, 1422, 1422, 1422, 1422, 1239, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1292, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1422, 1422, 1422, 1422, 1422, 1292, 
	1422, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1422, 1422, 1422, 1422, 1239, 
	1422, 1239, 1239, 1239, 1239, 1510, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1422, 1422, 1422, 1422, 1422, 
	1239, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1292, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1422, 1422, 1422, 1422, 1422, 
	1292, 1422, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1422, 1422, 1422, 1422, 
	1239, 1422, 1239, 1239, 1239, 1239, 1239, 1446, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1422, 1422, 1422, 1422, 
	1422, 1239, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1292, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1422, 1422, 1422, 1422, 
	1422, 1292, 1422, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1422, 1422, 1422, 
	1422, 1239, 1422, 1239, 1239, 1239, 1239, 1511, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1422, 1422, 1422, 
	1422, 1422, 1239, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1292, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1422, 1422, 1422, 
	1422, 1422, 1292, 1422, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1422, 1422, 
	1422, 1422, 1239, 1422, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1512, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1422, 1422, 
	1422, 1422, 1422, 1239, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1292, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1422, 1422, 
	1422, 1422, 1422, 1292, 1422, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1422, 
	1422, 1422, 1422, 1239, 1422, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1481, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1422, 
	1422, 1422, 1422, 1422, 1239, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1292, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1422, 
	1422, 1422, 1422, 1422, 1292, 1422, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1422, 1422, 1422, 1422, 1239, 1422, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1513, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1422, 1422, 1422, 1422, 1422, 1239, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1292, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1422, 1422, 1422, 1422, 1422, 1292, 1422, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1422, 1422, 1422, 1422, 1239, 1422, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1481, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1422, 1422, 1422, 1422, 1422, 1239, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1292, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1422, 1422, 1422, 1422, 1422, 1292, 1422, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1422, 1422, 1422, 1422, 1239, 1422, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1514, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1422, 1422, 1422, 1422, 1422, 1239, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1292, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1422, 1422, 1422, 1422, 1422, 1292, 
	1422, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1422, 1422, 1422, 1422, 1239, 
	1422, 1239, 1239, 1239, 1239, 1451, 1239, 1239, 
	1239, 1515, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1422, 1422, 1422, 1422, 1422, 
	1239, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1292, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1422, 1422, 1422, 1422, 1422, 
	1292, 1422, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1422, 1422, 1422, 1422, 
	1239, 1422, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1516, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1422, 1422, 1422, 1422, 
	1422, 1239, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1292, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1422, 1422, 1422, 1422, 
	1422, 1292, 1422, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1422, 1422, 1422, 
	1422, 1239, 1422, 1239, 1239, 1239, 1239, 1481, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1422, 1422, 1422, 
	1422, 1422, 1239, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1292, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1422, 1422, 1422, 
	1422, 1422, 1292, 1422, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1422, 1422, 
	1422, 1422, 1239, 1422, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1517, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1422, 1422, 
	1422, 1422, 1422, 1239, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1292, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1422, 1422, 
	1422, 1422, 1422, 1292, 1422, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1422, 
	1422, 1422, 1422, 1239, 1422, 1239, 1239, 1239, 
	1239, 1518, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1422, 
	1422, 1422, 1422, 1422, 1239, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1292, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1422, 
	1422, 1422, 1422, 1422, 1292, 1422, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1422, 1422, 1422, 1422, 1239, 1422, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1519, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1422, 1422, 1422, 1422, 1422, 1239, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1292, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1422, 1422, 1422, 1422, 1422, 1292, 1422, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1422, 1422, 1422, 1422, 1239, 1422, 1239, 
	1239, 1239, 1489, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1239, 1239, 1239, 1239, 1239, 1239, 1239, 
	1239, 1422, 1422, 1422, 1422, 1422, 1239, 1520, 
	1308, 1298, 1298, 1298, 1298, 1298, 1298, 1298, 
	1298, 1298, 1298, 1298, 1298, 1298, 1298, 1298, 
	1298, 1298, 1298, 1298, 1298, 1298, 1298, 1298, 
	1298, 1298, 1298, 1298, 1298, 1298, 1298, 1298, 
	1298, 1298, 1298, 1298, 1298, 1298, 1298, 1298, 
	1298, 1298, 1298, 1298, 1298, 1298, 1298, 1298, 
	1298, 1298, 1298, 1298, 1298, 1298, 1298, 1298, 
	1298, 1298, 1298, 1298, 1298, 1298, 1298, 1248, 
	1298, 1521, 1523, 1522, 1523, 1523, 1523, 1522, 
	1522, 1522, 1522, 1522, 1522, 1522, 1522, 1522, 
	1522, 1522, 1522, 1522, 1522, 1522, 1522, 1522, 
	1522, 1523, 1522, 1522, 1524, 1522, 1522, 1525, 
	1522, 1522, 1522, 1522, 1522, 1522, 1522, 357, 
	1522, 1522, 1522, 1522, 1522, 1522, 1522, 1522, 
	1522, 1522, 1522, 1522, 1522, 1522, 1522, 1522, 
	1522, 1522, 1522, 1522, 1522, 1522, 1522, 1522, 
	1522, 1522, 1522, 1522, 1522, 1522, 1522, 1522, 
	1522, 1522, 1522, 1522, 1522, 1522, 1522, 1522, 
	1522, 1522, 1522, 1522, 1522, 1526, 1522, 353, 
	354, 353, 353, 353, 1527, 1527, 1527, 1527, 
	1527, 1527, 1527, 1527, 1527, 1527, 1527, 1527, 
	1527, 1527, 1527, 1527, 1527, 1527, 353, 1527, 
	1527, 355, 1527, 1527, 356, 1527, 1527, 1527, 
	1527, 1527, 1527, 1527, 357, 1527, 1527, 1527, 
	1527, 1527, 1527, 1527, 1527, 1527, 1527, 1527, 
	1527, 1527, 1527, 1527, 1527, 1527, 1527, 1527, 
	1527, 1527, 1527, 1527, 1527, 1527, 1527, 1527, 
	1527, 1527, 1527, 1527, 1527, 1527, 1527, 1527, 
	1527, 1527, 1527, 1527, 1527, 1527, 1527, 1527, 
	1527, 1527, 358, 1527, 360, 1528, 360, 360, 
	360, 1528, 1528, 1528, 1528, 1528, 1528, 1528, 
	1528, 1528, 1528, 1528, 1528, 1528, 1528, 1528, 
	1528, 1528, 1528, 360, 1528, 1528, 355, 1528, 
	1528, 1528, 1528, 1528, 1528, 1528, 1528, 1528, 
	1528, 1528, 1528, 1528, 1528, 1528, 1528, 1528, 
	1528, 1528, 1528, 1528, 1528, 1528, 1528, 1528, 
	1528, 1528, 1528, 1528, 1528, 1528, 1528, 1528, 
	1528, 1528, 1528, 1528, 1528, 1528, 1528, 1528, 
	1528, 1528, 1528, 1528, 1528, 1528, 1528, 1528, 
	1528, 1528, 1528, 1528, 1528, 1528, 1528, 358, 
	1528, 1530, 1529, 1532, 1531, 363, 362, 368, 
	1527, 366, 1527, 1534, 1533, 1533, 1533, 1533, 
	1533, 1533, 1533, 1533, 1533, 1533, 1533, 1533, 
	1533, 1533, 1533, 1533, 1533, 1533, 1533, 1533, 
	1533, 1533, 1533, 1533, 1533, 1533, 1533, 1533, 
	1533, 1533, 1533, 1533, 1533, 1533, 1533, 1533, 
	1533, 1533, 1533, 1533, 1533, 1533, 1533, 1533, 
	1533, 1533, 1533, 1533, 1533, 1533, 1535, 1533, 
	1534, 1533, 1534, 1533, 1533, 1533, 1533, 1533, 
	1533, 1533, 1533, 1533, 1533, 1533, 1533, 1533, 
	1533, 1533, 1533, 1533, 1533, 1533, 1533, 1533, 
	1533, 1533, 1533, 1533, 1533, 1533, 1533, 1533, 
	1533, 1533, 1533, 1533, 1533, 1533, 1533, 1533, 
	1533, 1533, 1533, 1533, 1533, 1533, 1533, 1533, 
	1533, 1533, 1533, 1533, 1533, 1533, 1533, 1533, 
	1533, 1533, 1533, 1533, 1533, 1533, 1533, 1533, 
	1533, 1533, 1533, 1533, 1533, 1533, 1533, 1533, 
	1533, 1533, 1533, 1533, 1533, 1533, 1533, 1533, 
	1533, 1533, 1533, 1533, 1533, 1533, 1533, 1533, 
	1533, 1533, 1533, 1533, 1533, 1537, 1533, 1534, 
	1533, 1533, 1533, 1533, 1533, 1533, 1533, 1533, 
	1533, 1533, 1533, 1533, 1533, 1533, 1533, 1533, 
	1533, 1533, 1533, 1533, 1533, 1533, 1533, 1533, 
	1533, 1533, 1533, 1533, 1533, 1533, 1533, 1533, 
	1533, 1533, 1533, 1533, 1533, 1533, 1533, 1533, 
	1533, 1533, 1533, 1533, 1533, 1533, 1533, 1533, 
	1533, 1533, 1533, 1533, 1533, 1533, 1533, 1533, 
	1533, 1533, 1533, 1533, 1533, 1533, 1533, 1533, 
	1533, 1533, 1533, 1533, 1533, 1533, 1533, 1533, 
	1533, 1533, 1533, 1533, 1533, 1533, 1533, 1533, 
	1533, 1533, 1533, 1533, 1533, 1533, 1533, 1533, 
	1533, 1533, 1533, 1533, 1533, 1533, 1533, 1533, 
	1533, 1533, 1533, 1538, 1533, 1534, 1533, 1533, 
	1533, 1533, 1533, 1533, 1533, 1533, 1533, 1533, 
	1533, 1533, 1533, 1533, 1533, 1533, 1533, 1533, 
	1533, 1533, 1533, 1533, 1533, 1533, 1533, 1533, 
	1533, 1533, 1533, 1533, 1533, 1533, 1533, 1533, 
	1533, 1533, 1533, 1533, 1533, 1533, 1533, 1533, 
	1533, 1533, 1533, 1533, 1533, 1533, 1533, 1533, 
	1533, 1533, 1533, 1533, 1533, 1533, 1533, 1533, 
	1533, 1533, 1533, 1533, 1533, 1533, 1533, 1533, 
	1533, 1533, 1533, 1533, 1533, 1533, 1533, 1533, 
	1533, 1533, 1533, 1533, 1533, 1533, 1533, 1533, 
	1533, 1533, 1533, 1533, 1533, 1533, 1533, 1539, 
	1533, 1541, 1539, 0
]

class << self
	attr_accessor :_lex_trans_targs
	private :_lex_trans_targs, :_lex_trans_targs=
end
self._lex_trans_targs = [
	186, 2, 3, 4, 192, 6, 7, 8, 
	9, 10, 186, 186, 195, 198, 195, 12, 
	199, 200, 14, 195, 207, 208, 211, 212, 
	224, 221, 213, 214, 215, 19, 216, 217, 
	218, 226, 228, 229, 233, 234, 235, 230, 
	25, 18, 209, 210, 27, 258, 259, 261, 
	263, 261, 30, 264, 265, 32, 261, 272, 
	273, 276, 277, 289, 286, 278, 279, 280, 
	37, 281, 282, 283, 291, 293, 294, 298, 
	299, 300, 295, 43, 36, 274, 275, 45, 
	323, 324, 331, 333, 331, 48, 334, 335, 
	50, 337, 340, 337, 52, 341, 342, 54, 
	348, 347, 0, 56, 349, 350, 58, 351, 
	352, 352, 352, 352, 465, 61, 62, 63, 
	465, 465, 494, 65, 66, 494, 494, 498, 
	498, 70, 65, 71, 496, 497, 499, 500, 
	498, 494, 501, 502, 504, 67, 68, 505, 
	506, 69, 498, 72, 73, 78, 85, 508, 
	509, 71, 496, 497, 499, 500, 498, 494, 
	501, 502, 504, 67, 68, 505, 506, 69, 
	72, 73, 78, 85, 508, 509, 507, 74, 
	75, 76, 77, 79, 80, 83, 81, 82, 
	84, 86, 87, 494, 89, 90, 91, 93, 
	96, 94, 95, 97, 99, 525, 525, 525, 
	526, 101, 528, 102, 529, 103, 526, 101, 
	528, 102, 529, 563, 104, 563, 105, 106, 
	104, 563, 105, 563, 563, 563, 109, 110, 
	111, 112, 574, 563, 563, 563, 115, 116, 
	117, 563, 120, 115, 116, 117, 563, 120, 
	118, 118, 116, 117, 584, 119, 118, 118, 
	116, 117, 584, 119, 116, 563, 601, 563, 
	122, 602, 608, 126, 617, 618, 131, 132, 
	126, 127, 616, 127, 616, 563, 128, 129, 
	130, 619, 133, 563, 633, 634, 637, 638, 
	650, 647, 639, 640, 641, 138, 642, 643, 
	644, 652, 654, 655, 659, 660, 661, 656, 
	144, 137, 635, 636, 146, 697, 698, 148, 
	565, 107, 567, 150, 151, 700, 802, 153, 
	154, 155, 802, 810, 810, 810, 158, 832, 
	831, 810, 834, 836, 810, 163, 164, 165, 
	840, 810, 167, 168, 851, 820, 873, 171, 
	172, 173, 177, 178, 171, 172, 173, 177, 
	178, 174, 174, 172, 173, 175, 176, 174, 
	174, 172, 173, 175, 176, 921, 172, 810, 
	990, 179, 992, 181, 185, 993, 183, 990, 
	180, 990, 182, 992, 182, 992, 184, 992, 
	990, 186, 186, 187, 188, 189, 191, 193, 
	194, 186, 186, 186, 190, 186, 190, 186, 
	1, 186, 186, 186, 5, 195, 195, 196, 
	195, 197, 201, 195, 195, 11, 13, 195, 
	195, 195, 195, 202, 203, 204, 15, 21, 
	26, 236, 28, 195, 195, 195, 205, 206, 
	195, 16, 195, 195, 195, 17, 195, 195, 
	195, 20, 219, 195, 220, 222, 195, 223, 
	225, 227, 22, 195, 195, 23, 231, 195, 
	232, 24, 195, 237, 241, 238, 239, 240, 
	195, 195, 242, 243, 246, 248, 257, 244, 
	245, 195, 247, 249, 251, 250, 195, 252, 
	253, 254, 255, 256, 195, 195, 195, 260, 
	261, 261, 261, 262, 266, 261, 29, 31, 
	261, 261, 261, 261, 267, 268, 269, 33, 
	39, 44, 301, 46, 261, 261, 261, 270, 
	271, 261, 34, 261, 261, 261, 35, 261, 
	261, 261, 38, 284, 261, 285, 287, 261, 
	288, 290, 292, 40, 261, 261, 41, 296, 
	261, 297, 42, 261, 302, 306, 303, 304, 
	305, 261, 261, 307, 308, 311, 313, 322, 
	309, 310, 261, 312, 314, 316, 315, 261, 
	317, 318, 319, 320, 321, 261, 261, 261, 
	325, 326, 326, 327, 326, 328, 326, 326, 
	326, 329, 329, 329, 330, 329, 329, 329, 
	331, 331, 331, 332, 331, 47, 49, 331, 
	331, 331, 336, 336, 336, 337, 337, 338, 
	337, 339, 337, 337, 51, 53, 337, 337, 
	337, 343, 343, 344, 343, 343, 345, 346, 
	345, 55, 57, 347, 347, 347, 353, 352, 
	352, 354, 355, 356, 357, 359, 362, 363, 
	364, 365, 352, 366, 367, 369, 371, 372, 
	373, 377, 379, 380, 381, 397, 402, 409, 
	414, 421, 428, 431, 432, 436, 430, 440, 
	448, 452, 454, 459, 461, 464, 352, 352, 
	352, 352, 352, 352, 358, 352, 358, 352, 
	360, 59, 361, 352, 60, 352, 352, 368, 
	370, 352, 374, 375, 376, 372, 378, 352, 
	382, 383, 392, 395, 384, 385, 386, 387, 
	388, 389, 390, 391, 353, 393, 394, 396, 
	398, 401, 399, 400, 403, 406, 404, 405, 
	407, 408, 410, 412, 411, 413, 415, 416, 
	352, 417, 418, 419, 420, 352, 422, 425, 
	423, 424, 426, 427, 429, 433, 434, 435, 
	437, 439, 438, 441, 442, 443, 445, 444, 
	446, 447, 449, 450, 451, 453, 455, 456, 
	457, 458, 460, 462, 463, 466, 465, 465, 
	467, 468, 470, 471, 465, 465, 465, 469, 
	465, 469, 64, 472, 465, 474, 473, 473, 
	477, 478, 479, 480, 473, 482, 483, 484, 
	485, 487, 489, 490, 491, 492, 493, 473, 
	475, 473, 476, 473, 473, 473, 473, 473, 
	481, 473, 481, 486, 473, 488, 473, 494, 
	494, 495, 510, 511, 497, 513, 514, 501, 
	515, 516, 517, 518, 519, 521, 522, 523, 
	524, 494, 494, 494, 494, 494, 494, 498, 
	503, 494, 494, 494, 494, 494, 494, 494, 
	494, 494, 512, 494, 512, 494, 494, 494, 
	494, 520, 494, 88, 92, 98, 525, 527, 
	530, 100, 525, 525, 526, 531, 531, 532, 
	533, 535, 537, 538, 531, 531, 534, 531, 
	534, 531, 536, 531, 531, 531, 540, 539, 
	539, 541, 542, 543, 545, 547, 548, 553, 
	560, 539, 539, 539, 539, 544, 539, 544, 
	539, 546, 539, 539, 540, 549, 550, 551, 
	552, 554, 555, 558, 556, 557, 559, 561, 
	562, 564, 563, 572, 573, 575, 576, 578, 
	579, 580, 581, 583, 585, 586, 589, 590, 
	615, 621, 622, 623, 700, 701, 702, 703, 
	704, 582, 706, 723, 728, 735, 740, 742, 
	748, 751, 752, 756, 750, 760, 771, 775, 
	778, 786, 790, 793, 794, 563, 104, 105, 
	563, 107, 566, 563, 563, 568, 570, 571, 
	563, 569, 563, 563, 563, 563, 563, 108, 
	563, 563, 563, 563, 563, 577, 563, 577, 
	563, 563, 113, 563, 114, 563, 563, 582, 
	563, 587, 563, 588, 563, 563, 563, 591, 
	600, 563, 121, 603, 604, 605, 563, 606, 
	123, 609, 610, 124, 613, 614, 563, 592, 
	594, 563, 593, 563, 563, 595, 598, 599, 
	563, 596, 597, 563, 563, 563, 563, 563, 
	563, 607, 563, 601, 611, 612, 563, 611, 
	563, 601, 611, 125, 620, 563, 563, 563, 
	624, 563, 563, 563, 625, 627, 563, 626, 
	563, 626, 563, 628, 629, 630, 134, 140, 
	145, 662, 147, 563, 563, 563, 631, 632, 
	563, 135, 563, 563, 563, 136, 563, 563, 
	563, 139, 645, 563, 646, 648, 563, 649, 
	651, 653, 141, 563, 563, 142, 657, 563, 
	658, 143, 563, 663, 667, 664, 665, 666, 
	563, 563, 668, 669, 672, 683, 696, 670, 
	671, 563, 673, 674, 675, 677, 676, 563, 
	678, 679, 680, 681, 682, 684, 691, 685, 
	686, 687, 688, 689, 690, 692, 693, 694, 
	695, 563, 563, 563, 699, 149, 152, 563, 
	705, 707, 708, 718, 721, 709, 710, 711, 
	712, 713, 714, 715, 716, 717, 719, 720, 
	722, 724, 727, 725, 726, 729, 732, 730, 
	731, 733, 734, 736, 738, 737, 739, 741, 
	743, 745, 744, 746, 747, 749, 717, 753, 
	754, 755, 757, 759, 758, 761, 762, 763, 
	768, 764, 765, 766, 563, 564, 565, 107, 
	767, 570, 769, 770, 772, 773, 774, 776, 
	777, 779, 780, 781, 784, 782, 783, 785, 
	787, 788, 789, 791, 792, 563, 582, 795, 
	795, 796, 797, 798, 800, 795, 795, 795, 
	799, 795, 799, 795, 801, 795, 803, 802, 
	802, 804, 805, 802, 806, 808, 802, 802, 
	802, 802, 807, 802, 807, 809, 802, 811, 
	810, 810, 814, 815, 816, 810, 817, 819, 
	822, 823, 824, 825, 826, 810, 827, 828, 
	833, 861, 865, 810, 866, 868, 870, 810, 
	871, 872, 874, 878, 880, 881, 883, 884, 
	902, 907, 914, 922, 929, 936, 941, 942, 
	946, 940, 951, 961, 967, 970, 979, 983, 
	987, 988, 989, 822, 812, 810, 813, 810, 
	810, 810, 810, 810, 810, 818, 810, 818, 
	810, 156, 821, 810, 810, 810, 810, 810, 
	810, 810, 810, 810, 829, 810, 830, 810, 
	810, 157, 159, 810, 160, 842, 853, 856, 
	835, 857, 858, 843, 847, 849, 810, 835, 
	160, 837, 839, 161, 810, 837, 810, 838, 
	810, 810, 162, 841, 810, 810, 844, 846, 
	810, 844, 845, 847, 849, 846, 810, 848, 
	810, 810, 850, 852, 810, 166, 810, 810, 
	810, 854, 846, 847, 849, 854, 855, 810, 
	844, 846, 847, 849, 810, 844, 846, 847, 
	849, 810, 859, 846, 847, 849, 859, 860, 
	810, 160, 861, 835, 862, 847, 849, 863, 
	846, 160, 863, 835, 864, 867, 869, 810, 
	169, 170, 810, 810, 875, 876, 877, 872, 
	879, 810, 810, 882, 810, 810, 810, 885, 
	886, 895, 900, 887, 888, 889, 890, 891, 
	892, 893, 894, 811, 896, 897, 898, 899, 
	811, 901, 903, 906, 904, 905, 811, 811, 
	908, 911, 909, 910, 912, 913, 811, 915, 
	917, 916, 918, 919, 920, 810, 810, 923, 
	811, 924, 810, 925, 926, 927, 928, 812, 
	930, 933, 931, 932, 934, 935, 937, 938, 
	939, 811, 943, 944, 945, 947, 949, 950, 
	948, 811, 952, 953, 954, 957, 955, 956, 
	958, 959, 960, 962, 964, 963, 965, 966, 
	968, 969, 971, 972, 974, 977, 973, 975, 
	976, 978, 980, 981, 982, 984, 985, 986, 
	810, 810, 990, 991, 995, 996, 997, 990, 
	990, 990, 994, 990, 990, 999, 998, 1000, 
	998, 1001, 1002, 1003, 998, 998
]

class << self
	attr_accessor :_lex_trans_actions
	private :_lex_trans_actions, :_lex_trans_actions=
end
self._lex_trans_actions = [
	1, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 2, 3, 4, 0, 5, 0, 
	0, 0, 0, 6, 0, 7, 0, 8, 
	0, 0, 7, 0, 0, 0, 0, 8, 
	0, 7, 0, 8, 0, 7, 7, 0, 
	0, 0, 0, 0, 0, 0, 0, 9, 
	0, 10, 0, 0, 0, 0, 11, 0, 
	7, 0, 8, 0, 0, 7, 0, 0, 
	0, 0, 8, 0, 7, 0, 8, 0, 
	7, 7, 0, 0, 0, 0, 0, 0, 
	0, 0, 12, 0, 13, 0, 0, 0, 
	0, 14, 0, 15, 0, 0, 0, 0, 
	0, 16, 0, 0, 0, 0, 0, 0, 
	17, 18, 19, 20, 21, 0, 0, 0, 
	22, 23, 24, 0, 0, 25, 26, 27, 
	28, 29, 30, 30, 31, 32, 30, 33, 
	32, 34, 32, 30, 30, 31, 30, 35, 
	30, 30, 36, 30, 30, 30, 30, 30, 
	30, 0, 37, 38, 0, 39, 38, 40, 
	38, 0, 0, 37, 0, 41, 0, 0, 
	0, 0, 0, 0, 0, 0, 28, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 42, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 43, 44, 45, 
	46, 0, 0, 0, 46, 29, 47, 30, 
	30, 30, 47, 48, 0, 49, 0, 29, 
	30, 50, 30, 51, 52, 53, 0, 0, 
	0, 0, 0, 54, 55, 56, 0, 29, 
	0, 57, 0, 30, 58, 30, 59, 30, 
	60, 61, 62, 61, 63, 61, 0, 64, 
	65, 64, 66, 64, 67, 68, 0, 69, 
	0, 0, 0, 0, 70, 70, 0, 0, 
	71, 71, 72, 0, 29, 73, 0, 0, 
	0, 70, 0, 74, 0, 7, 0, 8, 
	0, 0, 7, 0, 0, 0, 0, 8, 
	0, 7, 0, 8, 0, 7, 7, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	75, 0, 0, 0, 0, 75, 76, 0, 
	0, 0, 77, 78, 79, 80, 0, 7, 
	7, 81, 82, 82, 83, 0, 0, 0, 
	0, 84, 0, 0, 0, 0, 0, 0, 
	29, 0, 0, 0, 30, 58, 30, 30, 
	30, 60, 61, 62, 61, 61, 61, 0, 
	64, 65, 64, 64, 64, 85, 67, 86, 
	87, 0, 88, 0, 89, 89, 0, 90, 
	0, 91, 60, 92, 0, 93, 29, 94, 
	95, 98, 99, 0, 29, 0, 7, 0, 
	7, 100, 101, 102, 60, 103, 0, 104, 
	0, 105, 106, 107, 0, 108, 109, 0, 
	110, 7, 7, 111, 112, 0, 0, 113, 
	114, 115, 116, 117, 117, 117, 117, 117, 
	117, 117, 117, 118, 119, 120, 0, 0, 
	121, 0, 122, 123, 124, 0, 125, 126, 
	127, 0, 0, 128, 0, 0, 129, 0, 
	7, 0, 0, 130, 131, 0, 0, 132, 
	0, 29, 133, 0, 0, 0, 0, 0, 
	134, 135, 0, 0, 0, 0, 0, 0, 
	0, 136, 0, 0, 0, 0, 137, 0, 
	0, 0, 0, 0, 138, 139, 140, 0, 
	141, 142, 143, 7, 7, 144, 0, 0, 
	145, 146, 147, 148, 117, 117, 117, 117, 
	117, 117, 117, 117, 149, 150, 151, 0, 
	0, 152, 0, 153, 154, 155, 0, 156, 
	157, 158, 0, 0, 159, 0, 0, 160, 
	0, 7, 0, 0, 161, 162, 0, 0, 
	163, 0, 29, 164, 0, 0, 0, 0, 
	0, 165, 166, 0, 0, 0, 0, 0, 
	0, 0, 167, 0, 0, 0, 0, 168, 
	0, 0, 0, 0, 0, 169, 170, 171, 
	0, 172, 173, 0, 174, 0, 175, 176, 
	177, 178, 179, 180, 0, 181, 182, 183, 
	184, 185, 186, 7, 187, 0, 0, 188, 
	189, 190, 191, 192, 193, 194, 195, 0, 
	196, 7, 197, 198, 0, 0, 199, 200, 
	201, 202, 203, 0, 204, 205, 206, 0, 
	207, 0, 0, 208, 209, 210, 211, 212, 
	213, 0, 29, 0, 0, 7, 7, 0, 
	0, 0, 214, 0, 0, 0, 0, 215, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 216, 217, 
	218, 219, 220, 221, 60, 222, 0, 223, 
	0, 0, 0, 224, 0, 225, 226, 0, 
	0, 227, 0, 0, 0, 228, 0, 229, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 228, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	230, 0, 0, 0, 0, 231, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 7, 232, 233, 
	0, 0, 7, 0, 234, 235, 236, 60, 
	237, 0, 0, 29, 238, 0, 239, 240, 
	0, 29, 0, 0, 241, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 242, 
	0, 243, 0, 244, 245, 246, 247, 248, 
	60, 249, 0, 0, 250, 0, 251, 252, 
	253, 254, 29, 0, 28, 0, 0, 28, 
	0, 0, 0, 0, 0, 0, 7, 7, 
	7, 255, 256, 257, 258, 259, 260, 261, 
	0, 262, 263, 264, 265, 266, 267, 268, 
	269, 270, 60, 271, 0, 272, 273, 274, 
	275, 276, 277, 0, 0, 0, 278, 7, 
	7, 0, 279, 280, 281, 282, 283, 0, 
	0, 0, 0, 0, 284, 285, 60, 286, 
	0, 287, 29, 288, 289, 290, 291, 292, 
	293, 0, 29, 0, 0, 0, 0, 0, 
	0, 294, 295, 296, 297, 60, 298, 0, 
	299, 29, 300, 301, 302, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 303, 304, 0, 8, 0, 0, 7, 
	305, 0, 0, 305, 305, 0, 0, 7, 
	306, 0, 306, 0, 306, 306, 306, 0, 
	0, 306, 303, 303, 303, 303, 303, 303, 
	303, 303, 303, 303, 303, 303, 303, 303, 
	303, 303, 303, 0, 0, 307, 308, 308, 
	309, 310, 0, 311, 312, 0, 75, 0, 
	313, 0, 314, 315, 316, 317, 318, 30, 
	319, 320, 321, 322, 323, 60, 324, 0, 
	325, 326, 0, 327, 0, 328, 329, 305, 
	330, 0, 331, 0, 332, 333, 334, 0, 
	0, 335, 0, 0, 0, 0, 336, 0, 
	0, 0, 0, 0, 0, 0, 337, 0, 
	0, 338, 0, 339, 340, 0, 0, 0, 
	341, 0, 0, 342, 343, 344, 345, 346, 
	347, 0, 348, 349, 349, 0, 350, 0, 
	351, 352, 352, 0, 0, 353, 354, 355, 
	0, 356, 357, 358, 0, 7, 359, 360, 
	361, 0, 362, 117, 117, 117, 117, 117, 
	117, 117, 117, 363, 364, 365, 0, 0, 
	366, 0, 367, 368, 369, 0, 370, 371, 
	372, 0, 0, 373, 0, 0, 374, 0, 
	7, 0, 0, 375, 376, 0, 0, 377, 
	0, 29, 378, 0, 0, 0, 0, 0, 
	379, 380, 0, 0, 0, 0, 0, 0, 
	0, 381, 0, 0, 0, 0, 0, 382, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 383, 384, 385, 0, 0, 0, 386, 
	29, 303, 303, 303, 303, 303, 303, 303, 
	303, 303, 303, 303, 303, 75, 303, 303, 
	303, 303, 303, 303, 303, 303, 303, 303, 
	303, 303, 303, 303, 303, 303, 303, 303, 
	303, 303, 303, 303, 303, 303, 387, 303, 
	303, 303, 303, 303, 303, 303, 303, 303, 
	303, 303, 303, 388, 389, 390, 391, 392, 
	392, 388, 303, 303, 303, 303, 303, 303, 
	303, 303, 303, 303, 303, 303, 303, 303, 
	303, 303, 303, 303, 303, 393, 394, 395, 
	396, 0, 29, 0, 0, 397, 398, 399, 
	60, 400, 0, 401, 29, 402, 7, 403, 
	404, 0, 29, 405, 0, 0, 406, 407, 
	408, 409, 60, 410, 0, 29, 411, 412, 
	413, 414, 0, 29, 0, 415, 0, 7, 
	416, 0, 0, 0, 0, 417, 0, 0, 
	418, 418, 0, 419, 0, 0, 0, 420, 
	7, 421, 421, 421, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 422, 423, 424, 0, 425, 
	426, 427, 428, 429, 430, 60, 431, 0, 
	432, 0, 0, 433, 434, 435, 436, 437, 
	438, 439, 440, 441, 0, 442, 0, 443, 
	444, 0, 0, 445, 446, 447, 0, 0, 
	448, 0, 0, 447, 449, 449, 450, 451, 
	0, 452, 453, 0, 454, 455, 456, 0, 
	457, 458, 0, 0, 459, 460, 447, 447, 
	461, 0, 0, 462, 462, 0, 463, 0, 
	464, 465, 7, 0, 466, 0, 467, 468, 
	469, 470, 470, 471, 471, 0, 0, 472, 
	473, 473, 474, 474, 475, 476, 476, 477, 
	477, 478, 479, 479, 480, 480, 0, 0, 
	481, 482, 483, 484, 485, 486, 486, 483, 
	485, 487, 418, 488, 0, 0, 0, 489, 
	0, 0, 490, 491, 421, 421, 421, 492, 
	421, 493, 494, 29, 495, 496, 497, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 498, 0, 0, 0, 0, 
	492, 0, 0, 0, 0, 0, 499, 500, 
	0, 0, 0, 0, 0, 0, 501, 0, 
	0, 0, 0, 0, 500, 502, 503, 0, 
	504, 0, 505, 0, 0, 0, 0, 506, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 507, 0, 0, 0, 0, 0, 0, 
	0, 506, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	508, 509, 510, 511, 511, 89, 511, 512, 
	513, 514, 0, 515, 516, 0, 517, 0, 
	518, 0, 0, 0, 519, 520
]

class << self
	attr_accessor :_lex_to_state_actions
	private :_lex_to_state_actions, :_lex_to_state_actions=
end
self._lex_to_state_actions = [
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 96, 0, 0, 0, 0, 0, 
	0, 0, 0, 96, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 96, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 96, 0, 
	0, 96, 0, 96, 0, 0, 0, 0, 
	96, 96, 0, 0, 0, 0, 0, 96, 
	0, 96, 0, 96, 0, 0, 0, 0, 
	96, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 96, 0, 0, 0, 0, 0, 0, 
	0, 96, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 96, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 96, 0, 0, 
	0, 0, 0, 96, 0, 0, 0, 0, 
	0, 0, 0, 96, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 96, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 96, 0, 0, 0, 0, 
	0, 0, 96, 0, 0, 0, 0, 0, 
	0, 0, 96, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 96, 0, 
	0, 0, 0, 0, 0, 0, 96, 0, 
	0, 0, 0, 0
]

class << self
	attr_accessor :_lex_from_state_actions
	private :_lex_from_state_actions, :_lex_from_state_actions=
end
self._lex_from_state_actions = [
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 97, 0, 0, 0, 0, 0, 
	0, 0, 0, 97, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 97, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 97, 0, 
	0, 97, 0, 97, 0, 0, 0, 0, 
	97, 97, 0, 0, 0, 0, 0, 97, 
	0, 97, 0, 97, 0, 0, 0, 0, 
	97, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 97, 0, 0, 0, 0, 0, 0, 
	0, 97, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 97, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 97, 0, 0, 
	0, 0, 0, 97, 0, 0, 0, 0, 
	0, 0, 0, 97, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 97, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 97, 0, 0, 0, 0, 
	0, 0, 97, 0, 0, 0, 0, 0, 
	0, 0, 97, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 97, 0, 
	0, 0, 0, 0, 0, 0, 97, 0, 
	0, 0, 0, 0
]

class << self
	attr_accessor :_lex_eof_trans
	private :_lex_eof_trans, :_lex_eof_trans=
end
self._lex_eof_trans = [
	0, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 13, 13, 13, 13, 20, 
	20, 20, 20, 20, 20, 20, 20, 20, 
	20, 20, 20, 20, 20, 48, 48, 48, 
	48, 55, 55, 55, 55, 55, 55, 55, 
	55, 55, 55, 55, 55, 55, 55, 83, 
	83, 83, 83, 90, 90, 90, 90, 0, 
	0, 0, 0, 105, 107, 109, 109, 109, 
	109, 115, 115, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	119, 119, 119, 119, 119, 119, 119, 119, 
	180, 180, 180, 180, 180, 180, 180, 180, 
	180, 180, 180, 180, 190, 192, 192, 192, 
	204, 204, 204, 212, 214, 214, 214, 214, 
	214, 220, 212, 212, 212, 212, 212, 212, 
	212, 246, 246, 246, 246, 246, 246, 212, 
	262, 212, 262, 246, 246, 212, 268, 268, 
	268, 268, 268, 268, 268, 268, 268, 268, 
	268, 268, 268, 268, 212, 246, 246, 246, 
	246, 303, 303, 303, 308, 310, 310, 310, 
	314, 314, 317, 317, 317, 317, 322, 322, 
	322, 308, 314, 314, 314, 314, 314, 314, 
	314, 314, 314, 353, 360, 362, 362, 362, 
	362, 353, 0, 378, 379, 380, 382, 384, 
	386, 384, 384, 0, 396, 397, 401, 401, 
	402, 403, 412, 413, 414, 414, 414, 417, 
	417, 419, 420, 421, 421, 421, 423, 424, 
	425, 425, 425, 428, 428, 421, 431, 431, 
	421, 417, 417, 436, 437, 437, 437, 440, 
	440, 437, 437, 437, 443, 443, 443, 443, 
	449, 450, 450, 450, 450, 458, 450, 450, 
	450, 450, 463, 450, 450, 450, 450, 450, 
	450, 469, 470, 471, 471, 0, 478, 482, 
	482, 483, 484, 493, 494, 495, 495, 495, 
	498, 498, 500, 501, 502, 502, 502, 504, 
	505, 506, 506, 506, 509, 509, 502, 512, 
	512, 502, 498, 498, 517, 518, 518, 518, 
	521, 521, 518, 518, 518, 524, 524, 524, 
	524, 530, 531, 531, 531, 531, 539, 531, 
	531, 531, 531, 544, 531, 531, 531, 531, 
	531, 531, 550, 551, 552, 552, 0, 559, 
	560, 0, 566, 0, 573, 577, 577, 578, 
	0, 0, 587, 588, 592, 592, 593, 0, 
	598, 0, 601, 0, 604, 604, 605, 606, 
	0, 647, 649, 650, 651, 652, 654, 656, 
	660, 660, 651, 651, 651, 651, 662, 651, 
	651, 656, 651, 651, 647, 666, 666, 666, 
	666, 666, 666, 656, 656, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	705, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	672, 672, 672, 672, 672, 672, 672, 672, 
	651, 0, 749, 750, 751, 753, 749, 749, 
	757, 0, 776, 778, 780, 781, 782, 783, 
	784, 786, 783, 783, 783, 783, 783, 789, 
	783, 783, 791, 789, 789, 783, 0, 810, 
	811, 115, 115, 814, 815, 115, 811, 811, 
	818, 820, 823, 811, 824, 811, 825, 826, 
	828, 830, 811, 818, 831, 831, 820, 831, 
	835, 831, 831, 831, 831, 0, 190, 843, 
	844, 843, 843, 0, 853, 854, 856, 858, 
	860, 858, 862, 0, 874, 875, 876, 877, 
	879, 881, 883, 884, 884, 884, 884, 884, 
	884, 884, 884, 884, 884, 884, 884, 884, 
	884, 884, 884, 0, 942, 945, 948, 949, 
	953, 955, 956, 957, 958, 959, 961, 964, 
	965, 967, 969, 972, 974, 975, 212, 972, 
	977, 972, 964, 979, 981, 964, 964, 999, 
	1002, 1004, 1005, 1009, 1012, 1013, 1014, 1015, 
	999, 999, 999, 999, 999, 999, 999, 999, 
	999, 999, 1019, 1023, 1025, 999, 999, 964, 
	1030, 1031, 1031, 1031, 964, 964, 964, 1032, 
	1039, 1039, 1041, 1043, 1052, 1053, 1054, 1054, 
	1054, 1057, 1057, 1059, 1060, 1061, 1061, 1061, 
	1063, 1064, 1065, 1065, 1065, 1068, 1068, 1061, 
	1071, 1071, 1061, 1057, 1057, 1076, 1077, 1077, 
	1077, 1080, 1080, 1077, 1077, 1077, 1083, 1083, 
	1083, 1083, 1089, 1090, 1090, 1090, 1090, 1098, 
	1090, 1090, 1090, 1090, 1104, 1090, 1090, 1090, 
	1090, 1090, 1090, 1090, 1090, 1090, 1090, 1090, 
	1090, 1090, 1090, 1090, 1090, 1090, 1090, 1090, 
	1122, 1123, 1124, 1124, 212, 964, 964, 1128, 
	964, 959, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 212, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 1181, 949, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 942, 942, 942, 942, 942, 942, 942, 
	942, 1206, 964, 0, 1214, 1215, 1216, 1218, 
	1220, 1222, 0, 1231, 1232, 1233, 1234, 1236, 
	1231, 1239, 0, 314, 1294, 1296, 1297, 1298, 
	1299, 1301, 1303, 1305, 1308, 1308, 314, 1310, 
	1312, 1313, 1314, 1310, 1316, 1318, 1318, 1321, 
	1321, 1324, 1335, 314, 1341, 1343, 1345, 1346, 
	1349, 1350, 1324, 1324, 1353, 1353, 1353, 1359, 
	1361, 1362, 1365, 1367, 1368, 1369, 1353, 1353, 
	1376, 1381, 1386, 1353, 1353, 1393, 1393, 1353, 
	1353, 1318, 1310, 1310, 1318, 1310, 1310, 1305, 
	314, 1411, 1412, 1412, 1412, 1412, 1412, 1412, 
	1418, 1305, 1421, 1422, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1462, 1463, 1423, 1423, 1467, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1423, 1423, 1423, 1423, 1423, 
	1423, 1423, 1423, 1521, 1299, 1522, 0, 1528, 
	1529, 1530, 1532, 1528, 1528, 1528, 0, 1537, 
	1537, 1537, 1537, 1541
]

class << self
	attr_accessor :lex_start
end
self.lex_start = 186;
class << self
	attr_accessor :lex_error
end
self.lex_error = 0;

class << self
	attr_accessor :lex_en_interp_words
end
self.lex_en_interp_words = 195;
class << self
	attr_accessor :lex_en_interp_string
end
self.lex_en_interp_string = 261;
class << self
	attr_accessor :lex_en_plain_words
end
self.lex_en_plain_words = 326;
class << self
	attr_accessor :lex_en_plain_string
end
self.lex_en_plain_string = 329;
class << self
	attr_accessor :lex_en_interp_backslash_delimited
end
self.lex_en_interp_backslash_delimited = 331;
class << self
	attr_accessor :lex_en_plain_backslash_delimited
end
self.lex_en_plain_backslash_delimited = 336;
class << self
	attr_accessor :lex_en_interp_backslash_delimited_words
end
self.lex_en_interp_backslash_delimited_words = 337;
class << self
	attr_accessor :lex_en_plain_backslash_delimited_words
end
self.lex_en_plain_backslash_delimited_words = 343;
class << self
	attr_accessor :lex_en_regexp_modifiers
end
self.lex_en_regexp_modifiers = 345;
class << self
	attr_accessor :lex_en_expr_variable
end
self.lex_en_expr_variable = 347;
class << self
	attr_accessor :lex_en_expr_fname
end
self.lex_en_expr_fname = 352;
class << self
	attr_accessor :lex_en_expr_endfn
end
self.lex_en_expr_endfn = 465;
class << self
	attr_accessor :lex_en_expr_dot
end
self.lex_en_expr_dot = 473;
class << self
	attr_accessor :lex_en_expr_arg
end
self.lex_en_expr_arg = 494;
class << self
	attr_accessor :lex_en_expr_cmdarg
end
self.lex_en_expr_cmdarg = 525;
class << self
	attr_accessor :lex_en_expr_endarg
end
self.lex_en_expr_endarg = 531;
class << self
	attr_accessor :lex_en_expr_mid
end
self.lex_en_expr_mid = 539;
class << self
	attr_accessor :lex_en_expr_beg
end
self.lex_en_expr_beg = 563;
class << self
	attr_accessor :lex_en_expr_labelarg
end
self.lex_en_expr_labelarg = 795;
class << self
	attr_accessor :lex_en_expr_value
end
self.lex_en_expr_value = 802;
class << self
	attr_accessor :lex_en_expr_end
end
self.lex_en_expr_end = 810;
class << self
	attr_accessor :lex_en_leading_dot
end
self.lex_en_leading_dot = 990;
class << self
	attr_accessor :lex_en_line_comment
end
self.lex_en_line_comment = 998;
class << self
	attr_accessor :lex_en_line_begin
end
self.lex_en_line_begin = 186;


# line 82 "lib/parser/lexer.rl"
  # %

  ESCAPES = {
    ?a.ord => "\a", ?b.ord  => "\b", ?e.ord => "\e", ?f.ord => "\f",
    ?n.ord => "\n", ?r.ord  => "\r", ?s.ord => "\s", ?t.ord => "\t",
    ?v.ord => "\v", ?\\.ord => "\\"
  }.freeze

  REGEXP_META_CHARACTERS = Regexp.union(*"\\$()*+.<>?[]^{|}".chars).freeze

  attr_reader   :source_buffer

  attr_accessor :diagnostics
  attr_accessor :static_env
  attr_accessor :force_utf32

  attr_accessor :cond, :cmdarg, :context, :command_start

  attr_accessor :tokens, :comments

  attr_reader :paren_nest, :cmdarg_stack, :cond_stack, :lambda_stack

  def initialize(version)
    @version    = version
    @static_env = nil
    @context    = nil

    @tokens     = nil
    @comments   = nil

    reset
  end

  def reset(reset_state=true)
    # Ragel state:
    if reset_state
      # Unit tests set state prior to resetting lexer.
      @cs     = self.class.lex_en_line_begin

      @cond   = StackState.new('cond')
      @cmdarg = StackState.new('cmdarg')
      @cond_stack   = []
      @cmdarg_stack = []
    end

    @force_utf32   = false # Set to true by some tests

    @source_pts    = nil # @source as a codepoint array

    @p             = 0   # stream position (saved manually in #advance)
    @ts            = nil # token start
    @te            = nil # token end
    @act           = 0   # next action

    @stack         = []  # state stack
    @top           = 0   # state stack top pointer

    # Lexer state:
    @token_queue   = []
    @literal_stack = []

    @eq_begin_s    = nil # location of last encountered =begin
    @sharp_s       = nil # location of last encountered #

    @newline_s     = nil # location of last encountered newline

    @num_base      = nil # last numeric base
    @num_digits_s  = nil # starting position of numeric digits
    @num_suffix_s  = nil # starting position of numeric suffix
    @num_xfrm      = nil # numeric suffix-induced transformation

    @escape_s      = nil # starting position of current sequence
    @escape        = nil # last escaped sequence, as string

    @herebody_s    = nil # starting position of current heredoc line

    # Ruby 1.9 ->() lambdas emit a distinct token if do/{ is
    # encountered after a matching closing parenthesis.
    @paren_nest    = 0
    @lambda_stack  = []

    # After encountering the closing line of <<~SQUIGGLY_HEREDOC,
    # we store the indentation level and give it out to the parser
    # on request. It is not possible to infer indentation level just
    # from the AST because escape sequences such as `\ ` or `\t` are
    # expanded inside the lexer, but count as non-whitespace for
    # indentation purposes.
    @dedent_level  = nil

    # If the lexer is in `command state' (aka expr_value)
    # at the entry to #advance, it will transition to expr_cmdarg
    # instead of expr_arg at certain points.
    @command_start = true

    # State before =begin / =end block comment
    @cs_before_block_comment = self.class.lex_en_line_begin
  end

  def source_buffer=(source_buffer)
    @source_buffer = source_buffer

    if @source_buffer
      source = @source_buffer.source

      if source.encoding == Encoding::UTF_8
        @source_pts = source.unpack('U*')
      else
        @source_pts = source.unpack('C*')
      end

      if @source_pts[0] == 0xfeff
        # Skip byte order mark.
        @p = 1
      end
    else
      @source_pts = nil
    end
  end

  def encoding
    @source_buffer.source.encoding
  end

  LEX_STATES = {
    :line_begin    => lex_en_line_begin,
    :expr_dot      => lex_en_expr_dot,
    :expr_fname    => lex_en_expr_fname,
    :expr_value    => lex_en_expr_value,
    :expr_beg      => lex_en_expr_beg,
    :expr_mid      => lex_en_expr_mid,
    :expr_arg      => lex_en_expr_arg,
    :expr_cmdarg   => lex_en_expr_cmdarg,
    :expr_end      => lex_en_expr_end,
    :expr_endarg   => lex_en_expr_endarg,
    :expr_endfn    => lex_en_expr_endfn,
    :expr_labelarg => lex_en_expr_labelarg,

    :interp_string => lex_en_interp_string,
    :interp_words  => lex_en_interp_words,
    :plain_string  => lex_en_plain_string,
    :plain_words   => lex_en_plain_string,
  }

  def state
    LEX_STATES.invert.fetch(@cs, @cs)
  end

  def state=(state)
    @cs = LEX_STATES.fetch(state)
  end

  def push_cmdarg
    @cmdarg_stack.push(@cmdarg)
    @cmdarg = StackState.new("cmdarg.#{@cmdarg_stack.count}")
  end

  def pop_cmdarg
    @cmdarg = @cmdarg_stack.pop
  end

  def push_cond
    @cond_stack.push(@cond)
    @cond = StackState.new("cond.#{@cond_stack.count}")
  end

  def pop_cond
    @cond = @cond_stack.pop
  end

  def dedent_level
    # We erase @dedent_level as a precaution to avoid accidentally
    # using a stale value.
    dedent_level, @dedent_level = @dedent_level, nil
    dedent_level
  end

  # Return next token: [type, value].
  def advance
    if @token_queue.any?
      return @token_queue.shift
    end

    # Ugly, but dependent on Ragel output. Consider refactoring it somehow.
    klass = self.class
    _lex_trans_keys         = klass.send :_lex_trans_keys
    _lex_key_spans          = klass.send :_lex_key_spans
    _lex_index_offsets      = klass.send :_lex_index_offsets
    _lex_indicies           = klass.send :_lex_indicies
    _lex_trans_targs        = klass.send :_lex_trans_targs
    _lex_trans_actions      = klass.send :_lex_trans_actions
    _lex_to_state_actions   = klass.send :_lex_to_state_actions
    _lex_from_state_actions = klass.send :_lex_from_state_actions
    _lex_eof_trans          = klass.send :_lex_eof_trans

    pe = @source_pts.size + 2
    p, eof = @p, pe

    cmd_state = @command_start
    @command_start = false

    
# line 11327 "lib/parser/lexer.rb"
begin
	testEof = false
	_slen, _trans, _keys, _inds, _acts, _nacts = nil
	_goto_level = 0
	_resume = 10
	_eof_trans = 15
	_again = 20
	_test_eof = 30
	_out = 40
	while true
	if _goto_level <= 0
	if p == pe
		_goto_level = _test_eof
		next
	end
	if  @cs == 0
		_goto_level = _out
		next
	end
	end
	if _goto_level <= _resume
	case _lex_from_state_actions[ @cs] 
	when 97 then
# line 1 "NONE"
		begin
 @ts = p
		end
# line 11355 "lib/parser/lexer.rb"
	end
	_keys =  @cs << 1
	_inds = _lex_index_offsets[ @cs]
	_slen = _lex_key_spans[ @cs]
	_wide = ( (@source_pts[p] || 0))
	_trans = if (   _slen > 0 && 
			_lex_trans_keys[_keys] <= _wide && 
			_wide <= _lex_trans_keys[_keys + 1] 
		    ) then
			_lex_indicies[ _inds + _wide - _lex_trans_keys[_keys] ] 
		 else 
			_lex_indicies[ _inds + _slen ]
		 end
	end
	if _goto_level <= _eof_trans
	 @cs = _lex_trans_targs[_trans]
	if _lex_trans_actions[_trans] != 0
	case _lex_trans_actions[_trans]
	when 29 then
# line 498 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
	when 117 then
# line 822 "lib/parser/lexer.rl"
		begin

    @escape_s = p
    @escape   = nil
  		end
	when 30 then
# line 862 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
	when 60 then
# line 1226 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
	when 64 then
# line 1229 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
	when 310 then
# line 1270 "lib/parser/lexer.rl"
		begin
 tm = p 		end
	when 37 then
# line 1563 "lib/parser/lexer.rl"
		begin
 tm = p 		end
	when 39 then
# line 1583 "lib/parser/lexer.rl"
		begin
 tm = p 		end
	when 41 then
# line 1611 "lib/parser/lexer.rl"
		begin
 tm = p 		end
	when 71 then
# line 1803 "lib/parser/lexer.rl"
		begin
 heredoc_e      = p 		end
	when 349 then
# line 1895 "lib/parser/lexer.rl"
		begin
 tm = p - 1; diag_msg = :ivar_name 		end
	when 352 then
# line 1896 "lib/parser/lexer.rl"
		begin
 tm = p - 2; diag_msg = :cvar_name 		end
	when 360 then
# line 1916 "lib/parser/lexer.rl"
		begin
 @escape = nil 		end
	when 392 then
# line 2005 "lib/parser/lexer.rl"
		begin
 tm = p 		end
	when 308 then
# line 2112 "lib/parser/lexer.rl"
		begin
 ident_tok = tok; ident_ts = @ts; ident_te = @te; 		end
	when 479 then
# line 2298 "lib/parser/lexer.rl"
		begin
 @num_base = 16; @num_digits_s = p 		end
	when 473 then
# line 2299 "lib/parser/lexer.rl"
		begin
 @num_base = 10; @num_digits_s = p 		end
	when 476 then
# line 2300 "lib/parser/lexer.rl"
		begin
 @num_base = 8;  @num_digits_s = p 		end
	when 470 then
# line 2301 "lib/parser/lexer.rl"
		begin
 @num_base = 2;  @num_digits_s = p 		end
	when 485 then
# line 2302 "lib/parser/lexer.rl"
		begin
 @num_base = 10; @num_digits_s = @ts 		end
	when 447 then
# line 2303 "lib/parser/lexer.rl"
		begin
 @num_base = 8;  @num_digits_s = @ts 		end
	when 462 then
# line 2304 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
	when 455 then
# line 2361 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
	when 452 then
# line 2362 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
	when 89 then
# line 2572 "lib/parser/lexer.rl"
		begin
 tm = p 		end
	when 7 then
# line 1 "NONE"
		begin
 @te = p+1
		end
	when 113 then
# line 1103 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    current_literal.flush_string
    current_literal.extend_content

    emit(:tSTRING_DBEG, '#{'.freeze)

    if current_literal.heredoc?
      current_literal.saved_herebody_s = @herebody_s
      @herebody_s = nil
    end

    current_literal.start_interp_brace
    @command_start = true
     @cs = 802;
    	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 5 then
# line 1029 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    current_literal.flush_string
    current_literal.extend_content

    emit(:tSTRING_DVAR, nil, @ts, @ts + 1)

    p = @ts
    	begin
		 @stack[ @top] =  @cs
		 @top+= 1
		 @cs = 347
		_goto_level = _again
		next
	end

   end
		end
	when 109 then
# line 954 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 108 then
# line 871 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 795;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 115 then
# line 1045 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    if @version >= 27
      literal.extend_string(tok, @ts, @te)
    else
      message = tok.start_with?('#@@') ? :cvar_name : :ivar_name
      diagnostic :error, message, { :name => tok(@ts + 1, @te) }, range(@ts + 1, @te)
    end
   end
		end
	when 114 then
# line 1029 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    current_literal.flush_string
    current_literal.extend_content

    emit(:tSTRING_DVAR, nil, @ts, @ts + 1)

    p = @ts
    	begin
		 @stack[ @top] =  @cs
		 @top+= 1
		 @cs = 347
		_goto_level = _again
		next
	end

   end
		end
	when 111 then
# line 1016 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    literal.extend_space @ts, @te
   end
		end
	when 112 then
# line 871 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 795;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 6 then
# line 895 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 4 then
# line 871 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 795;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 145 then
# line 1103 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    current_literal.flush_string
    current_literal.extend_content

    emit(:tSTRING_DBEG, '#{'.freeze)

    if current_literal.heredoc?
      current_literal.saved_herebody_s = @herebody_s
      @herebody_s = nil
    end

    current_literal.start_interp_brace
    @command_start = true
     @cs = 802;
    	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 10 then
# line 1029 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    current_literal.flush_string
    current_literal.extend_content

    emit(:tSTRING_DVAR, nil, @ts, @ts + 1)

    p = @ts
    	begin
		 @stack[ @top] =  @cs
		 @top+= 1
		 @cs = 347
		_goto_level = _again
		next
	end

   end
		end
	when 142 then
# line 954 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 141 then
# line 871 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 795;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 147 then
# line 1045 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    if @version >= 27
      literal.extend_string(tok, @ts, @te)
    else
      message = tok.start_with?('#@@') ? :cvar_name : :ivar_name
      diagnostic :error, message, { :name => tok(@ts + 1, @te) }, range(@ts + 1, @te)
    end
   end
		end
	when 146 then
# line 1029 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    current_literal.flush_string
    current_literal.extend_content

    emit(:tSTRING_DVAR, nil, @ts, @ts + 1)

    p = @ts
    	begin
		 @stack[ @top] =  @cs
		 @top+= 1
		 @cs = 347
		_goto_level = _again
		next
	end

   end
		end
	when 144 then
# line 871 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 795;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 11 then
# line 895 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 9 then
# line 871 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 795;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 173 then
# line 954 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 172 then
# line 871 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 795;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 175 then
# line 1016 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    literal.extend_space @ts, @te
   end
		end
	when 176 then
# line 871 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 795;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 179 then
# line 954 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 178 then
# line 871 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 795;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 181 then
# line 871 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 795;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 188 then
# line 1103 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    current_literal.flush_string
    current_literal.extend_content

    emit(:tSTRING_DBEG, '#{'.freeze)

    if current_literal.heredoc?
      current_literal.saved_herebody_s = @herebody_s
      @herebody_s = nil
    end

    current_literal.start_interp_brace
    @command_start = true
     @cs = 802;
    	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 13 then
# line 1029 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    current_literal.flush_string
    current_literal.extend_content

    emit(:tSTRING_DVAR, nil, @ts, @ts + 1)

    p = @ts
    	begin
		 @stack[ @top] =  @cs
		 @top+= 1
		 @cs = 347
		_goto_level = _again
		next
	end

   end
		end
	when 185 then
# line 954 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 184 then
# line 871 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 795;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 190 then
# line 1045 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    if @version >= 27
      literal.extend_string(tok, @ts, @te)
    else
      message = tok.start_with?('#@@') ? :cvar_name : :ivar_name
      diagnostic :error, message, { :name => tok(@ts + 1, @te) }, range(@ts + 1, @te)
    end
   end
		end
	when 189 then
# line 1029 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    current_literal.flush_string
    current_literal.extend_content

    emit(:tSTRING_DVAR, nil, @ts, @ts + 1)

    p = @ts
    	begin
		 @stack[ @top] =  @cs
		 @top+= 1
		 @cs = 347
		_goto_level = _again
		next
	end

   end
		end
	when 187 then
# line 871 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 795;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 12 then
# line 871 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 795;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 192 then
# line 954 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 191 then
# line 871 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 795;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 199 then
# line 1103 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    current_literal.flush_string
    current_literal.extend_content

    emit(:tSTRING_DBEG, '#{'.freeze)

    if current_literal.heredoc?
      current_literal.saved_herebody_s = @herebody_s
      @herebody_s = nil
    end

    current_literal.start_interp_brace
    @command_start = true
     @cs = 802;
    	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 15 then
# line 1029 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    current_literal.flush_string
    current_literal.extend_content

    emit(:tSTRING_DVAR, nil, @ts, @ts + 1)

    p = @ts
    	begin
		 @stack[ @top] =  @cs
		 @top+= 1
		 @cs = 347
		_goto_level = _again
		next
	end

   end
		end
	when 195 then
# line 954 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 194 then
# line 871 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 795;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 201 then
# line 1045 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    if @version >= 27
      literal.extend_string(tok, @ts, @te)
    else
      message = tok.start_with?('#@@') ? :cvar_name : :ivar_name
      diagnostic :error, message, { :name => tok(@ts + 1, @te) }, range(@ts + 1, @te)
    end
   end
		end
	when 200 then
# line 1029 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    current_literal.flush_string
    current_literal.extend_content

    emit(:tSTRING_DVAR, nil, @ts, @ts + 1)

    p = @ts
    	begin
		 @stack[ @top] =  @cs
		 @top+= 1
		 @cs = 347
		_goto_level = _again
		next
	end

   end
		end
	when 197 then
# line 1016 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    literal.extend_space @ts, @te
   end
		end
	when 198 then
# line 871 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 795;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 14 then
# line 871 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 795;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 203 then
# line 954 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 202 then
# line 871 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 795;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 205 then
# line 1016 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    literal.extend_space @ts, @te
   end
		end
	when 206 then
# line 1200 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        emit(:tREGEXP_OPT, tok(@ts, @te - 1), @ts, @te - 1)
        p = p - 1;
        	begin
		 @cs = 810
		_goto_level = _again
		next
	end

       end
		end
	when 207 then
# line 1187 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        unknown_options = tok.scan(/[^imxouesn]/)
        if unknown_options.any?
          diagnostic :error, :regexp_options,
                     { :options => unknown_options.join }
        end

        emit(:tREGEXP_OPT)
         @cs = 810;
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 16 then
# line 1339 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        if    tok =~ /^\$([1-9][0-9]*)$/
          emit(:tNTH_REF, tok(@ts + 1).to_i)
        elsif tok =~ /^\$([&`'+])$/
          emit(:tBACK_REF)
        else
          emit(:tGVAR)
        end

         @cs = (stack_pop); 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 208 then
# line 1339 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        if    tok =~ /^\$([1-9][0-9]*)$/
          emit(:tNTH_REF, tok(@ts + 1).to_i)
        elsif tok =~ /^\$([&`'+])$/
          emit(:tBACK_REF)
        else
          emit(:tGVAR)
        end

         @cs = (stack_pop); 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 210 then
# line 1352 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        if tok =~ /^@@[0-9]/
          diagnostic :error, :cvar_name, { :name => tok }
        end

        emit(:tCVAR)
         @cs = (stack_pop); 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 209 then
# line 1362 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        if tok =~ /^@[0-9]/
          diagnostic :error, :ivar_name, { :name => tok }
        end

        emit(:tIVAR)
         @cs = (stack_pop); 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 231 then
# line 1383 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit_table(KEYWORDS_BEGIN);
            @cs = 465; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 217 then
# line 1391 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit(:tIDENTIFIER)
            @cs = 465; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 18 then
# line 1395 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = @ts - 1
            @cs = 810; 	begin
		 @stack[ @top] =  @cs
		 @top+= 1
		 @cs = 347
		_goto_level = _again
		next
	end
  end
		end
	when 214 then
# line 1404 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit_table(PUNCTUATION)
            @cs = 465; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 226 then
# line 1408 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = p - 1; p = p - 1; 	begin
		 @cs = 810
		_goto_level = _again
		next
	end
  end
		end
	when 20 then
# line 1414 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        if version?(23)
          type, delimiter = tok[0..-2], tok[-1].chr
          	begin
		 @cs = (push_literal(type, delimiter, @ts))
		_goto_level = _again
		next
	end

        else
          p = @ts - 1
          	begin
		 @cs = 810
		_goto_level = _again
		next
	end

        end
       end
		end
	when 213 then
# line 1427 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = p - 1; 	begin
		 @cs = 810
		_goto_level = _again
		next
	end
  end
		end
	when 212 then
# line 525 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    # Sit at EOF indefinitely. #advance would return $eof each time.
    # This allows to feed the lexer more data if needed; this is only used
    # in tests.
    #
    # Note that this action is not embedded into e_eof like e_heredoc_nl and e_bs
    # below. This is due to the fact that scanner state at EOF is observed
    # by tests, and encapsulating it in a rule would break the introspection.
    p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 230 then
# line 1383 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit_table(KEYWORDS_BEGIN);
            @cs = 465; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 227 then
# line 1387 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tCONSTANT)
            @cs = 465; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 229 then
# line 1391 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tIDENTIFIER)
            @cs = 465; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 224 then
# line 1395 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = @ts - 1
            @cs = 810; 	begin
		 @stack[ @top] =  @cs
		 @top+= 1
		 @cs = 347
		_goto_level = _again
		next
	end
  end
		end
	when 220 then
# line 1404 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit_table(PUNCTUATION)
            @cs = 465; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 225 then
# line 1411 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 563
		_goto_level = _again
		next
	end
  end
		end
	when 218 then
# line 1424 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 223 then
# line 1427 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 810
		_goto_level = _again
		next
	end
  end
		end
	when 19 then
# line 1404 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin  emit_table(PUNCTUATION)
            @cs = 465; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 17 then
# line 1427 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin  p = p - 1; 	begin
		 @cs = 810
		_goto_level = _again
		next
	end
  end
		end
	when 216 then
# line 1 "NONE"
		begin
	case  @act
	when 43 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS_BEGIN);
            @cs = 465; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 44 then
	begin begin p = (( @te))-1; end
 emit(:tCONSTANT)
            @cs = 465; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 45 then
	begin begin p = (( @te))-1; end
 emit(:tIDENTIFIER)
            @cs = 465; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
end 
			end
	when 22 then
# line 1439 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit(:tLABEL, tok(@ts, @te - 2), @ts, @te - 1)
           p = p - 1;  @cs = 795; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 23 then
# line 1443 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        if @version >= 31 && @context.in_argdef
          emit(:tBDOT3, '...'.freeze)
          # emit(:tNL, "\n".freeze, @te - 1, @te)
           @cs = 810; 	begin
		p += 1
		_goto_level = _out
		next
	end

        else
          p -= 3;
          	begin
		 @cs = 810
		_goto_level = _again
		next
	end

        end
       end
		end
	when 233 then
# line 1457 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = p - 1; 	begin
		 @cs = 810
		_goto_level = _again
		next
	end
  end
		end
	when 232 then
# line 525 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    # Sit at EOF indefinitely. #advance would return $eof each time.
    # This allows to feed the lexer more data if needed; this is only used
    # in tests.
    #
    # Note that this action is not embedded into e_eof like e_heredoc_nl and e_bs
    # below. This is due to the fact that scanner state at EOF is observed
    # by tests, and encapsulating it in a rule would break the introspection.
    p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 235 then
# line 1454 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 234 then
# line 1457 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 810
		_goto_level = _again
		next
	end
  end
		end
	when 21 then
# line 1457 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin  p = p - 1; 	begin
		 @cs = 810
		_goto_level = _again
		next
	end
  end
		end
	when 241 then
# line 1483 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit_table(PUNCTUATION)
            @cs = 494; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 240 then
# line 1489 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = p - 1; 	begin
		 @cs = 810
		_goto_level = _again
		next
	end
  end
		end
	when 239 then
# line 525 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    # Sit at EOF indefinitely. #advance would return $eof each time.
    # This allows to feed the lexer more data if needed; this is only used
    # in tests.
    #
    # Note that this action is not embedded into e_eof like e_heredoc_nl and e_bs
    # below. This is due to the fact that scanner state at EOF is observed
    # by tests, and encapsulating it in a rule would break the introspection.
    p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 251 then
# line 1468 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tCONSTANT)
            @cs = (arg_or_cmdarg(cmd_state)); 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 242 then
# line 1472 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tIDENTIFIER)
            @cs = (arg_or_cmdarg(cmd_state)); 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 247 then
# line 1483 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit_table(PUNCTUATION)
            @cs = 494; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 245 then
# line 1486 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 250 then
# line 1489 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 810
		_goto_level = _again
		next
	end
  end
		end
	when 274 then
# line 1549 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        # Unlike expr_beg as invoked in the next rule, do not warn
        p = @ts - 1
        	begin
		 @cs = 810
		_goto_level = _again
		next
	end

       end
		end
	when 257 then
# line 1567 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        if tok(tm, tm + 1) == '/'.freeze
          # Ambiguous regexp literal.
          if @version < 30
            diagnostic :warning, :ambiguous_literal, nil, range(tm, tm + 1)
          else
            diagnostic :warning, :ambiguous_regexp, nil, range(tm, tm + 1)
          end
        end

        p = tm - 1
        	begin
		 @cs = 563
		_goto_level = _again
		next
	end

       end
		end
	when 263 then
# line 1595 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = p - 1; p = p - 1; 	begin
		 @cs = 563
		_goto_level = _again
		next
	end
  end
		end
	when 25 then
# line 1603 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = @ts - 1; 	begin
		 @cs = 563
		_goto_level = _again
		next
	end
  end
		end
	when 265 then
# line 1612 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = tm - 1; 	begin
		 @cs = 810
		_goto_level = _again
		next
	end
  end
		end
	when 40 then
# line 1623 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        p = @ts - 1
        	begin
		 @cs = 810
		_goto_level = _again
		next
	end

       end
		end
	when 252 then
# line 1637 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = p - 1; 	begin
		 @cs = 563
		_goto_level = _again
		next
	end
  end
		end
	when 253 then
# line 525 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    # Sit at EOF indefinitely. #advance would return $eof each time.
    # This allows to feed the lexer more data if needed; this is only used
    # in tests.
    #
    # Note that this action is not embedded into e_eof like e_heredoc_nl and e_bs
    # below. This is due to the fact that scanner state at EOF is observed
    # by tests, and encapsulating it in a rule would break the introspection.
    p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 264 then
# line 1558 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 563
		_goto_level = _again
		next
	end
  end
		end
	when 260 then
# line 1584 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        diagnostic :warning, :ambiguous_prefix, { :prefix => tok(tm, @te) },
                   range(tm, @te)

        p = tm - 1
        	begin
		 @cs = 563
		_goto_level = _again
		next
	end

       end
		end
	when 262 then
# line 1600 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 563
		_goto_level = _again
		next
	end
  end
		end
	when 256 then
# line 1623 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        p = @ts - 1
        	begin
		 @cs = 810
		_goto_level = _again
		next
	end

       end
		end
	when 255 then
# line 1628 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 273 then
# line 1637 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 563
		_goto_level = _again
		next
	end
  end
		end
	when 26 then
# line 1628 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
		end
	when 42 then
# line 1637 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin  p = p - 1; 	begin
		 @cs = 563
		_goto_level = _again
		next
	end
  end
		end
	when 24 then
# line 1 "NONE"
		begin
	case  @act
	when 72 then
	begin begin p = (( @te))-1; end

        if tok(tm, tm + 1) == '/'.freeze
          # Ambiguous regexp literal.
          if @version < 30
            diagnostic :warning, :ambiguous_literal, nil, range(tm, tm + 1)
          else
            diagnostic :warning, :ambiguous_regexp, nil, range(tm, tm + 1)
          end
        end

        p = tm - 1
        	begin
		 @cs = 563
		_goto_level = _again
		next
	end

      end
	when 73 then
	begin begin p = (( @te))-1; end

        diagnostic :warning, :ambiguous_prefix, { :prefix => tok(tm, @te) },
                   range(tm, @te)

        p = tm - 1
        	begin
		 @cs = 563
		_goto_level = _again
		next
	end

      end
	when 78 then
	begin begin p = (( @te))-1; end

        p = @ts - 1
        	begin
		 @cs = 810
		_goto_level = _again
		next
	end

      end
	else
	begin begin p = (( @te))-1; end
end
end 
			end
	when 44 then
# line 1673 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = @ts - 1
           	begin
		 @cs = 494
		_goto_level = _again
		next
	end
  end
		end
	when 278 then
# line 525 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    # Sit at EOF indefinitely. #advance would return $eof each time.
    # This allows to feed the lexer more data if needed; this is only used
    # in tests.
    #
    # Note that this action is not embedded into e_eof like e_heredoc_nl and e_bs
    # below. This is due to the fact that scanner state at EOF is observed
    # by tests, and encapsulating it in a rule would break the introspection.
    p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 279 then
# line 1673 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = @ts - 1
           	begin
		 @cs = 494
		_goto_level = _again
		next
	end
  end
		end
	when 45 then
# line 1673 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin  p = @ts - 1
           	begin
		 @cs = 494
		_goto_level = _again
		next
	end
  end
		end
	when 43 then
# line 1 "NONE"
		begin
	case  @act
	when 85 then
	begin begin p = (( @te))-1; end

        if @cond.active?
          emit(:kDO_COND, 'do'.freeze, @te - 2, @te)
        else
          emit(:kDO, 'do'.freeze, @te - 2, @te)
        end
         @cs = 802; 	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 86 then
	begin begin p = (( @te))-1; end
 p = @ts - 1
           	begin
		 @cs = 494
		_goto_level = _again
		next
	end
 end
end 
			end
	when 289 then
# line 1709 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit_do(true)
            @cs = 802; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 282 then
# line 1715 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = p - 1; 	begin
		 @cs = 810
		_goto_level = _again
		next
	end
  end
		end
	when 283 then
# line 525 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    # Sit at EOF indefinitely. #advance would return $eof each time.
    # This allows to feed the lexer more data if needed; this is only used
    # in tests.
    #
    # Note that this action is not embedded into e_eof like e_heredoc_nl and e_bs
    # below. This is due to the fact that scanner state at EOF is observed
    # by tests, and encapsulating it in a rule would break the introspection.
    p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 284 then
# line 1712 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 287 then
# line 1715 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 810
		_goto_level = _again
		next
	end
  end
		end
	when 293 then
# line 1739 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = p - 1; 	begin
		 @cs = 563
		_goto_level = _again
		next
	end
  end
		end
	when 292 then
# line 525 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    # Sit at EOF indefinitely. #advance would return $eof each time.
    # This allows to feed the lexer more data if needed; this is only used
    # in tests.
    #
    # Note that this action is not embedded into e_eof like e_heredoc_nl and e_bs
    # below. This is due to the fact that scanner state at EOF is observed
    # by tests, and encapsulating it in a rule would break the introspection.
    p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 301 then
# line 1731 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = @ts - 1; 	begin
		 @cs = 563
		_goto_level = _again
		next
	end
  end
		end
	when 295 then
# line 1733 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 299 then
# line 1739 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 563
		_goto_level = _again
		next
	end
  end
		end
	when 294 then
# line 1 "NONE"
		begin
	case  @act
	when 93 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS)
            @cs = 563; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 94 then
	begin begin p = (( @te))-1; end
 p = @ts - 1; 	begin
		 @cs = 563
		_goto_level = _again
		next
	end
 end
end 
			end
	when 57 then
# line 1754 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        emit(:tUNARY_NUM, tok(@ts, @ts + 1), @ts, @ts + 1)
        p = p - 1;  @cs = 810; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 334 then
# line 1771 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        type = delimiter = tok[0].chr
        p = p - 1; 	begin
		 @cs = (push_literal(type, delimiter, @ts))
		_goto_level = _again
		next
	end

       end
		end
	when 326 then
# line 1778 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        type, delimiter = @source_buffer.slice(@ts).chr, tok[-1].chr
        	begin
		 @cs = (push_literal(type, delimiter, @ts))
		_goto_level = _again
		next
	end

       end
		end
	when 55 then
# line 1785 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        type, delimiter = tok[0..-2], tok[-1].chr
        	begin
		 @cs = (push_literal(type, delimiter, @ts))
		_goto_level = _again
		next
	end

       end
		end
	when 347 then
# line 1860 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        p = p - 1; p = p - 1;
        emit(:tSYMBEG, tok(@ts, @ts + 1), @ts, @ts + 1)
        	begin
		 @cs = 352
		_goto_level = _again
		next
	end

       end
		end
	when 335 then
# line 1868 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        type, delimiter = tok, tok[-1].chr
        	begin
		 @cs = (push_literal(type, delimiter, @ts))
		_goto_level = _again
		next
	end

       end
		end
	when 346 then
# line 1876 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        emit(:tSYMBOL, tok(@ts + 1, @ts + 2))
         @cs = 810; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 69 then
# line 1890 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        emit(:tSYMBOL, tok(@ts + 1), @ts)
         @cs = 810; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 357 then
# line 1931 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        escape = { " "  => '\s', "\r" => '\r', "\n" => '\n', "\t" => '\t',
                   "\v" => '\v', "\f" => '\f' }[@source_buffer.slice(@ts + 1)]
        diagnostic :warning, :invalid_escape_use, { :escape => escape }, range

        p = @ts - 1
        	begin
		 @cs = 810
		_goto_level = _again
		next
	end

       end
		end
	when 356 then
# line 1941 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        diagnostic :fatal, :incomplete_escape, nil, range(@ts, @ts + 1)
       end
		end
	when 336 then
# line 2000 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit_table(PUNCTUATION_BEGIN)
           	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 52 then
# line 2021 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        p = p - 1;

        if version?(18)
          ident = tok(@ts, @te - 2)

          emit((@source_buffer.slice(@ts) =~ /[A-Z]/) ? :tCONSTANT : :tIDENTIFIER,
               ident, @ts, @te - 2)
          p = p - 1; # continue as a symbol

          if !@static_env.nil? && @static_env.declared?(ident)
             @cs = 810;
          else
             @cs = (arg_or_cmdarg(cmd_state));
          end
        else
          emit(:tLABEL, tok(@ts, @te - 2), @ts, @te - 1)
           @cs = 795;
        end

        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 49 then
# line 2114 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        emit(:tIDENTIFIER, ident_tok, ident_ts, ident_te)
        p = ident_te - 1

        if !@static_env.nil? && @static_env.declared?(ident_tok) && @version < 25
           @cs = 465;
        else
           @cs = 525;
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 320 then
# line 2133 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        p = @ts - 1
        @cs_before_block_comment = @cs
        	begin
		 @cs = 186
		_goto_level = _again
		next
	end

       end
		end
	when 56 then
# line 2149 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = @ts - 1; 	begin
		 @cs = 810
		_goto_level = _again
		next
	end
  end
		end
	when 304 then
# line 525 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    # Sit at EOF indefinitely. #advance would return $eof each time.
    # This allows to feed the lexer more data if needed; this is only used
    # in tests.
    #
    # Note that this action is not embedded into e_eof like e_heredoc_nl and e_bs
    # below. This is due to the fact that scanner state at EOF is observed
    # by tests, and encapsulating it in a rule would break the introspection.
    p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 330 then
# line 1754 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit(:tUNARY_NUM, tok(@ts, @ts + 1), @ts, @ts + 1)
        p = p - 1;  @cs = 810; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 329 then
# line 1761 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tSTAR, '*'.freeze)
           	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 325 then
# line 1791 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        diagnostic :fatal, :string_eof, nil, range(@ts, @ts + 1)
       end
		end
	when 354 then
# line 1851 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        diagnostic :error, :unterminated_heredoc_id, nil, range(@ts, @ts + 1)
       end
		end
	when 337 then
# line 1890 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit(:tSYMBOL, tok(@ts + 1), @ts)
         @cs = 810; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 350 then
# line 1898 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        if @version >= 27
          diagnostic :error, diag_msg, { name: tok(tm, @te) }, range(tm, @te)
        else
          emit(:tCOLON, tok(@ts, @ts + 1), @ts, @ts + 1)
          p = @ts
        end

         @cs = 810; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 355 then
# line 1941 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        diagnostic :fatal, :incomplete_escape, nil, range(@ts, @ts + 1)
       end
		end
	when 361 then
# line 1947 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        p = @ts - 1
        	begin
		 @cs = 810
		_goto_level = _again
		next
	end

       end
		end
	when 327 then
# line 2000 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit_table(PUNCTUATION_BEGIN)
           	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 331 then
# line 2048 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        if @version >= 27
          emit(:tBDOT2)
        else
          emit(:tDOT2)
        end

         @cs = 563; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 332 then
# line 2059 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        # Here we scan and conditionally emit "\n":
        # + if it's there
        #   + and emitted we do nothing
        #   + and not emitted we return `p` to "\n" to process it on the next scan
        # + if it's not there we do nothing
        followed_by_nl = @te - 1 == @newline_s
        nl_emitted = false
        dots_te = followed_by_nl ? @te - 1 : @te

        if @version >= 30
          if @lambda_stack.any? && @lambda_stack.last + 1 == @paren_nest
            # To reject `->(...)` like `->...`
            emit(:tDOT3, '...'.freeze, @ts, dots_te)
          else
            emit(:tBDOT3, '...'.freeze, @ts, dots_te)

            if @version >= 31 && followed_by_nl && @context.in_argdef
              emit(:tNL, @te - 1, @te)
              nl_emitted = true
            end
          end
        elsif @version >= 27
          emit(:tBDOT3, '...'.freeze, @ts, dots_te)
        else
          emit(:tDOT3, '...'.freeze, @ts, dots_te)
        end

        if followed_by_nl && !nl_emitted
          # return "\n" to process it on the next scan
          p = p - 1;
        end

         @cs = 563; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 307 then
# line 1324 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    emit(:tIDENTIFIER)

    if !@static_env.nil? && @static_env.declared?(tok)
       @cs = 465; 	begin
		p += 1
		_goto_level = _out
		next
	end

    else
       @cs = (arg_or_cmdarg(cmd_state)); 	begin
		p += 1
		_goto_level = _out
		next
	end

    end
   end
		end
	when 317 then
# line 2130 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 319 then
# line 2133 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        p = @ts - 1
        @cs_before_block_comment = @cs
        	begin
		 @cs = 186
		_goto_level = _again
		next
	end

       end
		end
	when 322 then
# line 2149 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = @ts - 1; 	begin
		 @cs = 810
		_goto_level = _again
		next
	end
  end
		end
	when 54 then
# line 1791 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
        diagnostic :fatal, :string_eof, nil, range(@ts, @ts + 1)
       end
		end
	when 73 then
# line 1851 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
        diagnostic :error, :unterminated_heredoc_id, nil, range(@ts, @ts + 1)
       end
		end
	when 74 then
# line 1918 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 810; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 48 then
# line 1324 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
    emit(:tIDENTIFIER)

    if !@static_env.nil? && @static_env.declared?(tok)
       @cs = 465; 	begin
		p += 1
		_goto_level = _out
		next
	end

    else
       @cs = (arg_or_cmdarg(cmd_state)); 	begin
		p += 1
		_goto_level = _out
		next
	end

    end
   end
		end
	when 53 then
# line 2130 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
		end
	when 68 then
# line 2149 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin  p = @ts - 1; 	begin
		 @cs = 810
		_goto_level = _again
		next
	end
  end
		end
	when 51 then
# line 1 "NONE"
		begin
	case  @act
	when 99 then
	begin begin p = (( @te))-1; end

        emit(:tUNARY_NUM, tok(@ts, @ts + 1), @ts, @ts + 1)
        p = p - 1;  @cs = 810; 	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 106 then
	begin begin p = (( @te))-1; end

        diagnostic :error, :unterminated_heredoc_id, nil, range(@ts, @ts + 1)
      end
	when 117 then
	begin begin p = (( @te))-1; end

        if @version >= 27
          emit(:tPIPE, tok(@ts, @ts + 1), @ts, @ts + 1)
          p = p - 1;
           @cs = 563; 	begin
		p += 1
		_goto_level = _out
		next
	end

        else
          p -= 2
          	begin
		 @cs = 810
		_goto_level = _again
		next
	end

        end
      end
	when 121 then
	begin begin p = (( @te))-1; end
 emit_table(PUNCTUATION_BEGIN)
           	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 122 then
	begin begin p = (( @te))-1; end
 emit(:kRESCUE, 'rescue'.freeze, @ts, tm)
           p = tm - 1
            @cs = 539; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 123 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS_BEGIN)
           @command_start = true
            @cs = 802; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 127 then
	begin begin p = (( @te))-1; end
 p = @ts - 1
           	begin
		 @cs = 810
		_goto_level = _again
		next
	end
 end
	when 128 then
	begin begin p = (( @te))-1; end

    emit(:tIDENTIFIER)

    if !@static_env.nil? && @static_env.declared?(tok)
       @cs = 465; 	begin
		p += 1
		_goto_level = _out
		next
	end

    else
       @cs = (arg_or_cmdarg(cmd_state)); 	begin
		p += 1
		_goto_level = _out
		next
	end

    end
  end
	when 132 then
	begin begin p = (( @te))-1; end
 p = @ts - 1; 	begin
		 @cs = 810
		_goto_level = _again
		next
	end
 end
end 
			end
	when 395 then
# line 2169 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = p - 1; 	begin
		 @cs = 563
		_goto_level = _again
		next
	end
  end
		end
	when 396 then
# line 525 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    # Sit at EOF indefinitely. #advance would return $eof each time.
    # This allows to feed the lexer more data if needed; this is only used
    # in tests.
    #
    # Note that this action is not embedded into e_eof like e_heredoc_nl and e_bs
    # below. This is due to the fact that scanner state at EOF is observed
    # by tests, and encapsulating it in a rule would break the introspection.
    p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 397 then
# line 2157 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 401 then
# line 2169 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 563
		_goto_level = _again
		next
	end
  end
		end
	when 77 then
# line 2179 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = @ts - 1
           	begin
		 @cs = 810
		_goto_level = _again
		next
	end
  end
		end
	when 405 then
# line 2184 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        	begin
		 @cs = (push_literal(tok, tok, @ts))
		_goto_level = _again
		next
	end

       end
		end
	when 404 then
# line 2194 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = p - 1; 	begin
		 @cs = 563
		_goto_level = _again
		next
	end
  end
		end
	when 403 then
# line 525 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    # Sit at EOF indefinitely. #advance would return $eof each time.
    # This allows to feed the lexer more data if needed; this is only used
    # in tests.
    #
    # Note that this action is not embedded into e_eof like e_heredoc_nl and e_bs
    # below. This is due to the fact that scanner state at EOF is observed
    # by tests, and encapsulating it in a rule would break the introspection.
    p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 407 then
# line 2188 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 406 then
# line 2194 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 563
		_goto_level = _again
		next
	end
  end
		end
	when 76 then
# line 2194 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin  p = p - 1; 	begin
		 @cs = 563
		_goto_level = _again
		next
	end
  end
		end
	when 440 then
# line 2205 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        emit(:tLAMBDA, '->'.freeze, @ts, @ts + 2)

        @lambda_stack.push @paren_nest
         @cs = 465; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 86 then
# line 2246 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit(:kCLASS, 'class'.freeze, @ts, @ts + 5)
           emit(:tLSHFT, '<<'.freeze,    @te - 2, @te)
            @cs = 802; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 415 then
# line 2382 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        type, delimiter = tok, tok[-1].chr
        	begin
		 @cs = (push_literal(type, delimiter, @ts, nil, false, false, true))
		_goto_level = _again
		next
	end

       end
		end
	when 79 then
# line 2400 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = @ts - 1; 	begin
		 @stack[ @top] =  @cs
		 @top+= 1
		 @cs = 347
		_goto_level = _again
		next
	end
  end
		end
	when 436 then
# line 2407 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit_table(PUNCTUATION)
            @cs = 473; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 489 then
# line 2431 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        emit_table(PUNCTUATION)
         @cs = 802; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 429 then
# line 2440 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        emit_table(PUNCTUATION);
         @cs = 802; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 434 then
# line 2475 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit(:tOP_ASGN, tok(@ts, @te - 1))
            @cs = 563; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 420 then
# line 2479 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit(:tEH, '?'.freeze)
            @cs = 802; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 417 then
# line 2498 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit_table(PUNCTUATION)
            @cs = 563; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 419 then
# line 2511 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit(:tSEMI, ';'.freeze)
           @command_start = true
            @cs = 802; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 494 then
# line 2515 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        diagnostic :error, :bare_backslash, nil, range(@ts, @ts + 1)
        p = p - 1;
       end
		end
	when 414 then
# line 2521 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        diagnostic :fatal, :unexpected, { :character => tok.inspect[1..-2] }
       end
		end
	when 413 then
# line 525 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    # Sit at EOF indefinitely. #advance would return $eof each time.
    # This allows to feed the lexer more data if needed; this is only used
    # in tests.
    #
    # Note that this action is not embedded into e_eof like e_heredoc_nl and e_bs
    # below. This is due to the fact that scanner state at EOF is observed
    # by tests, and encapsulating it in a rule would break the introspection.
    p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 505 then
# line 2242 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit_table(KEYWORDS)
            @cs = 352; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 503 then
# line 2246 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:kCLASS, 'class'.freeze, @ts, @ts + 5)
           emit(:tLSHFT, '<<'.freeze,    @te - 2, @te)
            @cs = 802; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 502 then
# line 2257 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit_table(KEYWORDS)
           @command_start = true
            @cs = 802; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 444 then
# line 2332 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        diagnostic :error, :no_dot_digit_literal
       end
		end
	when 491 then
# line 2392 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tCONSTANT)
            @cs = (arg_or_cmdarg(cmd_state)); 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 433 then
# line 2400 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = @ts - 1; 	begin
		 @stack[ @top] =  @cs
		 @top+= 1
		 @cs = 347
		_goto_level = _again
		next
	end
  end
		end
	when 441 then
# line 2407 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit_table(PUNCTUATION)
            @cs = 473; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 497 then
# line 1324 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    emit(:tIDENTIFIER)

    if !@static_env.nil? && @static_env.declared?(tok)
       @cs = 465; 	begin
		p += 1
		_goto_level = _out
		next
	end

    else
       @cs = (arg_or_cmdarg(cmd_state)); 	begin
		p += 1
		_goto_level = _out
		next
	end

    end
   end
		end
	when 439 then
# line 2431 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit_table(PUNCTUATION)
         @cs = 802; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 435 then
# line 2440 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit_table(PUNCTUATION);
         @cs = 802; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 428 then
# line 2446 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit_table(PUNCTUATION)
            @cs = 563; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 442 then
# line 2498 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit_table(PUNCTUATION)
            @cs = 563; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 426 then
# line 2505 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 432 then
# line 2521 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        diagnostic :fatal, :unexpected, { :character => tok.inspect[1..-2] }
       end
		end
	when 84 then
# line 2305 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 80 then
# line 2332 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
        diagnostic :error, :no_dot_digit_literal
       end
		end
	when 83 then
# line 2364 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
        digits = tok(@ts, @num_suffix_s)

        if version?(18, 19, 20)
          emit(:tFLOAT, Float(digits), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits)
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 78 then
# line 2521 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
        diagnostic :fatal, :unexpected, { :character => tok.inspect[1..-2] }
       end
		end
	when 81 then
# line 1 "NONE"
		begin
	case  @act
	when 145 then
	begin begin p = (( @te))-1; end

        if @lambda_stack.last == @paren_nest
          @lambda_stack.pop

          if tok == '{'.freeze
            emit(:tLAMBEG, '{'.freeze)
          else # 'do'
            emit(:kDO_LAMBDA, 'do'.freeze)
          end
        else
          if tok == '{'.freeze
            emit(:tLCURLY, '{'.freeze)
          else # 'do'
            emit_do
          end
        end
        if tok == '{'.freeze
          @paren_nest += 1
        end
        @command_start = true

         @cs = 802; 	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 146 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS)
            @cs = 352; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 147 then
	begin begin p = (( @te))-1; end
 emit(:kCLASS, 'class'.freeze, @ts, @ts + 5)
           emit(:tLSHFT, '<<'.freeze,    @te - 2, @te)
            @cs = 802; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 148 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS)
            @cs = 563; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 149 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS)
           @command_start = true
            @cs = 802; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 150 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS)
            @cs = 539; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 151 then
	begin begin p = (( @te))-1; end

        emit_table(KEYWORDS)

        if version?(18) && tok == 'not'.freeze
           @cs = 563; 	begin
		p += 1
		_goto_level = _out
		next
	end

        else
           @cs = 494; 	begin
		p += 1
		_goto_level = _out
		next
	end

        end
      end
	when 152 then
	begin begin p = (( @te))-1; end

        if version?(18)
          emit(:tIDENTIFIER)

          unless !@static_env.nil? && @static_env.declared?(tok)
             @cs = (arg_or_cmdarg(cmd_state));
          end
        else
          emit(:k__ENCODING__, '__ENCODING__'.freeze)
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 153 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS)
           	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 154 then
	begin begin p = (( @te))-1; end

        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 156 then
	begin begin p = (( @te))-1; end

        if version?(18, 19, 20)
          diagnostic :error,
                     :trailing_in_number, { :character => tok(@te - 1, @te) },
                     range(@te - 1, @te)
        else
          emit(:tINTEGER, tok(@ts, @te - 1).to_i, @ts, @te - 1)
          p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

        end
      end
	when 157 then
	begin begin p = (( @te))-1; end

        if version?(18, 19, 20)
          diagnostic :error,
                     :trailing_in_number, { :character => tok(@te - 1, @te) },
                     range(@te - 1, @te)
        else
          emit(:tFLOAT, tok(@ts, @te - 1).to_f, @ts, @te - 1)
          p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

        end
      end
	when 158 then
	begin begin p = (( @te))-1; end

        digits = tok(@ts, @num_suffix_s)

        if version?(18, 19, 20)
          emit(:tFLOAT, Float(digits), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits)
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 160 then
	begin begin p = (( @te))-1; end
 emit(:tCONSTANT)
            @cs = (arg_or_cmdarg(cmd_state)); 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 164 then
	begin begin p = (( @te))-1; end

    emit(:tIDENTIFIER)

    if !@static_env.nil? && @static_env.declared?(tok)
       @cs = 465; 	begin
		p += 1
		_goto_level = _out
		next
	end

    else
       @cs = (arg_or_cmdarg(cmd_state)); 	begin
		p += 1
		_goto_level = _out
		next
	end

    end
  end
	when 165 then
	begin begin p = (( @te))-1; end

        if tm == @te
          # Suffix was consumed, e.g. foo!
          emit(:tFID)
        else
          # Suffix was not consumed, e.g. foo!=
          emit(:tIDENTIFIER, tok(@ts, tm), @ts, tm)
          p = tm - 1
        end
         @cs = 494; 	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 167 then
	begin begin p = (( @te))-1; end

        emit_table(PUNCTUATION);
         @cs = 802; 	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 168 then
	begin begin p = (( @te))-1; end
 emit_table(PUNCTUATION)
            @cs = 563; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
end 
			end
	when 516 then
# line 2562 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        emit(:tNL, nil, @newline_s, @newline_s + 1)
        if @version < 27
          p = p - 1;  @cs = 186; 	begin
		p += 1
		_goto_level = _out
		next
	end

        else
          emit(:tBDOT3)
           @cs = 563; 	begin
		p += 1
		_goto_level = _out
		next
	end

        end
       end
		end
	when 95 then
# line 2573 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = tm - 1; 	begin
		 @cs = 810
		_goto_level = _again
		next
	end
  end
		end
	when 510 then
# line 2576 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit(:tNL, nil, @newline_s, @newline_s + 1)
           p = p - 1;  @cs = 186; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 513 then
# line 2537 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        if @version < 27
          # Ruby before 2.7 doesn't support comments before leading dot.
          # If a line after "a" starts with a comment then "a" is a self-contained statement.
          # So in that case we emit a special tNL token and start reading the
          # next line as a separate statement.
          #
          # Note: block comments before leading dot are not supported on any version of Ruby.
          emit(:tNL, nil, @newline_s, @newline_s + 1)
          p = p - 1;  @cs = 186; 	begin
		p += 1
		_goto_level = _out
		next
	end

        end
       end
		end
	when 515 then
# line 2551 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit(:tNL, nil, @newline_s, @newline_s + 1)
        if @version < 27
          p = p - 1;  @cs = 186; 	begin
		p += 1
		_goto_level = _out
		next
	end

        else
          emit(:tBDOT2)
           @cs = 563; 	begin
		p += 1
		_goto_level = _out
		next
	end

        end
       end
		end
	when 514 then
# line 2573 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = tm - 1; 	begin
		 @cs = 810
		_goto_level = _again
		next
	end
  end
		end
	when 512 then
# line 2576 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tNL, nil, @newline_s, @newline_s + 1)
           p = p - 1;  @cs = 186; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 90 then
# line 2537 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
        if @version < 27
          # Ruby before 2.7 doesn't support comments before leading dot.
          # If a line after "a" starts with a comment then "a" is a self-contained statement.
          # So in that case we emit a special tNL token and start reading the
          # next line as a separate statement.
          #
          # Note: block comments before leading dot are not supported on any version of Ruby.
          emit(:tNL, nil, @newline_s, @newline_s + 1)
          p = p - 1;  @cs = 186; 	begin
		p += 1
		_goto_level = _out
		next
	end

        end
       end
		end
	when 87 then
# line 2576 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin  emit(:tNL, nil, @newline_s, @newline_s + 1)
           p = p - 1;  @cs = 186; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 91 then
# line 1 "NONE"
		begin
	case  @act
	when 181 then
	begin begin p = (( @te))-1; end

        if @version < 27
          # Ruby before 2.7 doesn't support comments before leading dot.
          # If a line after "a" starts with a comment then "a" is a self-contained statement.
          # So in that case we emit a special tNL token and start reading the
          # next line as a separate statement.
          #
          # Note: block comments before leading dot are not supported on any version of Ruby.
          emit(:tNL, nil, @newline_s, @newline_s + 1)
          p = p - 1;  @cs = 186; 	begin
		p += 1
		_goto_level = _out
		next
	end

        end
      end
	when 185 then
	begin begin p = (( @te))-1; end
 emit(:tNL, nil, @newline_s, @newline_s + 1)
           p = p - 1;  @cs = 186; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
end 
			end
	when 519 then
# line 2586 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit_comment(@eq_begin_s, @te)
        	begin
		 @cs = (@cs_before_block_comment)
		_goto_level = _again
		next
	end

       end
		end
	when 518 then
# line 2594 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        diagnostic :fatal, :embedded_document, nil,
                   range(@eq_begin_s, @eq_begin_s + '=begin'.length)
       end
		end
	when 106 then
# line 2604 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  @eq_begin_s = @ts
           	begin
		 @cs = 998
		_goto_level = _again
		next
	end
  end
		end
	when 2 then
# line 2608 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = pe - 3  end
		end
	when 98 then
# line 2611 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  cmd_state = true; p = p - 1; 	begin
		 @cs = 802
		_goto_level = _again
		next
	end
  end
		end
	when 99 then
# line 525 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    # Sit at EOF indefinitely. #advance would return $eof each time.
    # This allows to feed the lexer more data if needed; this is only used
    # in tests.
    #
    # Note that this action is not embedded into e_eof like e_heredoc_nl and e_bs
    # below. This is due to the fact that scanner state at EOF is observed
    # by tests, and encapsulating it in a rule would break the introspection.
    p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 100 then
# line 2601 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 105 then
# line 2604 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  @eq_begin_s = @ts
           	begin
		 @cs = 998
		_goto_level = _again
		next
	end
  end
		end
	when 104 then
# line 2611 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  cmd_state = true; p = p - 1; 	begin
		 @cs = 802
		_goto_level = _again
		next
	end
  end
		end
	when 1 then
# line 2611 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin  cmd_state = true; p = p - 1; 	begin
		 @cs = 802
		_goto_level = _again
		next
	end
  end
		end
	when 67 then
# line 498 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 1229 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
	when 110 then
# line 498 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 954 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 143 then
# line 498 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 954 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 174 then
# line 498 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 954 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 180 then
# line 498 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 954 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 186 then
# line 498 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 954 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 193 then
# line 498 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 954 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 196 then
# line 498 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 954 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 204 then
# line 498 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 954 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 275 then
# line 498 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 1549 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        # Unlike expr_beg as invoked in the next rule, do not warn
        p = @ts - 1
        	begin
		 @cs = 810
		_goto_level = _again
		next
	end

       end
		end
	when 266 then
# line 498 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 1612 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = tm - 1; 	begin
		 @cs = 810
		_goto_level = _again
		next
	end
  end
		end
	when 258 then
# line 498 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 1623 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        p = @ts - 1
        	begin
		 @cs = 810
		_goto_level = _again
		next
	end

       end
		end
	when 358 then
# line 498 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 1931 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        escape = { " "  => '\s', "\r" => '\r', "\n" => '\n', "\t" => '\t',
                   "\v" => '\v', "\f" => '\f' }[@source_buffer.slice(@ts + 1)]
        diagnostic :warning, :invalid_escape_use, { :escape => escape }, range

        p = @ts - 1
        	begin
		 @cs = 810
		_goto_level = _again
		next
	end

       end
		end
	when 333 then
# line 498 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 2059 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        # Here we scan and conditionally emit "\n":
        # + if it's there
        #   + and emitted we do nothing
        #   + and not emitted we return `p` to "\n" to process it on the next scan
        # + if it's not there we do nothing
        followed_by_nl = @te - 1 == @newline_s
        nl_emitted = false
        dots_te = followed_by_nl ? @te - 1 : @te

        if @version >= 30
          if @lambda_stack.any? && @lambda_stack.last + 1 == @paren_nest
            # To reject `->(...)` like `->...`
            emit(:tDOT3, '...'.freeze, @ts, dots_te)
          else
            emit(:tBDOT3, '...'.freeze, @ts, dots_te)

            if @version >= 31 && followed_by_nl && @context.in_argdef
              emit(:tNL, @te - 1, @te)
              nl_emitted = true
            end
          end
        elsif @version >= 27
          emit(:tBDOT3, '...'.freeze, @ts, dots_te)
        else
          emit(:tDOT3, '...'.freeze, @ts, dots_te)
        end

        if followed_by_nl && !nl_emitted
          # return "\n" to process it on the next scan
          p = p - 1;
        end

         @cs = 563; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 321 then
# line 498 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 2133 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        p = @ts - 1
        @cs_before_block_comment = @cs
        	begin
		 @cs = 186
		_goto_level = _again
		next
	end

       end
		end
	when 443 then
# line 498 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 2487 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        if @paren_nest == 0
          diagnostic :warning, :triple_dot_at_eol, nil, range(@ts, @te - 1)
        end

        emit(:tDOT3, '...'.freeze, @ts, @te - 1)
        p = p - 1;
         @cs = 563; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 520 then
# line 498 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 2586 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        emit_comment(@eq_begin_s, @te)
        	begin
		 @cs = (@cs_before_block_comment)
		_goto_level = _again
		next
	end

       end
		end
	when 517 then
# line 498 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 2591 "lib/parser/lexer.rl"
		begin
 @te = p+1
		end
	when 107 then
# line 498 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 2604 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  @eq_begin_s = @ts
           	begin
		 @cs = 998
		_goto_level = _again
		next
	end
  end
		end
	when 3 then
# line 498 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 2608 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = pe - 3  end
		end
	when 465 then
# line 633 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tRATIONAL,  Rational(chars)) } 		end
# line 2305 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 463 then
# line 634 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tIMAGINARY, Complex(0, chars)) } 		end
# line 2305 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 468 then
# line 635 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tIMAGINARY, Complex(0, Rational(chars))) } 		end
# line 2305 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 466 then
# line 636 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars, @ts, @te - 2); p -= 2 } 		end
# line 2305 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 464 then
# line 637 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars, @ts, @te - 2); p -= 2 } 		end
# line 2305 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 467 then
# line 638 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars, @ts, @te - 6); p -= 6 } 		end
# line 2305 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 456 then
# line 642 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tIMAGINARY, Complex(0, Float(chars))) } 		end
# line 2364 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@ts, @num_suffix_s)

        if version?(18, 19, 20)
          emit(:tFLOAT, Float(digits), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits)
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 457 then
# line 643 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tFLOAT,     Float(chars), @ts, @te - 2); p -= 2 } 		end
# line 2364 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@ts, @num_suffix_s)

        if version?(18, 19, 20)
          emit(:tFLOAT, Float(digits), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits)
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 458 then
# line 647 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tRATIONAL,  Rational(chars)) } 		end
# line 2364 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@ts, @num_suffix_s)

        if version?(18, 19, 20)
          emit(:tFLOAT, Float(digits), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits)
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 460 then
# line 648 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tIMAGINARY, Complex(0, Rational(chars))) } 		end
# line 2364 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@ts, @num_suffix_s)

        if version?(18, 19, 20)
          emit(:tFLOAT, Float(digits), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits)
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 459 then
# line 649 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tFLOAT,     Float(chars), @ts, @te - 6); p -= 6 } 		end
# line 2364 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@ts, @num_suffix_s)

        if version?(18, 19, 20)
          emit(:tFLOAT, Float(digits), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits)
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 137 then
# line 664 "lib/parser/lexer.rl"
		begin

    @escape = ""

    codepoints  = tok(@escape_s + 2, p - 1)
    codepoint_s = @escape_s + 2

    if @version < 24
      if codepoints.start_with?(" ") || codepoints.start_with?("\t")
        diagnostic :fatal, :invalid_unicode_escape, nil,
          range(@escape_s + 2, @escape_s + 3)
      end

      if spaces_p = codepoints.index(/[ \t]{2}/)
        diagnostic :fatal, :invalid_unicode_escape, nil,
          range(codepoint_s + spaces_p + 1, codepoint_s + spaces_p + 2)
      end

      if codepoints.end_with?(" ") || codepoints.end_with?("\t")
        diagnostic :fatal, :invalid_unicode_escape, nil, range(p - 1, p)
      end
    end

    codepoints.scan(/([0-9a-fA-F]+)|([ \t]+)/).each do |(codepoint_str, spaces)|
      if spaces
        codepoint_s += spaces.length
      else
        codepoint = codepoint_str.to_i(16)

        if codepoint >= 0x110000
          diagnostic :error, :unicode_point_too_large, nil,
                     range(codepoint_s, codepoint_s + codepoint_str.length)
          break
        end

        @escape     += codepoint.chr(Encoding::UTF_8)
        codepoint_s += codepoint_str.length
      end
    end
  		end
# line 895 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 168 then
# line 664 "lib/parser/lexer.rl"
		begin

    @escape = ""

    codepoints  = tok(@escape_s + 2, p - 1)
    codepoint_s = @escape_s + 2

    if @version < 24
      if codepoints.start_with?(" ") || codepoints.start_with?("\t")
        diagnostic :fatal, :invalid_unicode_escape, nil,
          range(@escape_s + 2, @escape_s + 3)
      end

      if spaces_p = codepoints.index(/[ \t]{2}/)
        diagnostic :fatal, :invalid_unicode_escape, nil,
          range(codepoint_s + spaces_p + 1, codepoint_s + spaces_p + 2)
      end

      if codepoints.end_with?(" ") || codepoints.end_with?("\t")
        diagnostic :fatal, :invalid_unicode_escape, nil, range(p - 1, p)
      end
    end

    codepoints.scan(/([0-9a-fA-F]+)|([ \t]+)/).each do |(codepoint_str, spaces)|
      if spaces
        codepoint_s += spaces.length
      else
        codepoint = codepoint_str.to_i(16)

        if codepoint >= 0x110000
          diagnostic :error, :unicode_point_too_large, nil,
                     range(codepoint_s, codepoint_s + codepoint_str.length)
          break
        end

        @escape     += codepoint.chr(Encoding::UTF_8)
        codepoint_s += codepoint_str.length
      end
    end
  		end
# line 895 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 382 then
# line 664 "lib/parser/lexer.rl"
		begin

    @escape = ""

    codepoints  = tok(@escape_s + 2, p - 1)
    codepoint_s = @escape_s + 2

    if @version < 24
      if codepoints.start_with?(" ") || codepoints.start_with?("\t")
        diagnostic :fatal, :invalid_unicode_escape, nil,
          range(@escape_s + 2, @escape_s + 3)
      end

      if spaces_p = codepoints.index(/[ \t]{2}/)
        diagnostic :fatal, :invalid_unicode_escape, nil,
          range(codepoint_s + spaces_p + 1, codepoint_s + spaces_p + 2)
      end

      if codepoints.end_with?(" ") || codepoints.end_with?("\t")
        diagnostic :fatal, :invalid_unicode_escape, nil, range(p - 1, p)
      end
    end

    codepoints.scan(/([0-9a-fA-F]+)|([ \t]+)/).each do |(codepoint_str, spaces)|
      if spaces
        codepoint_s += spaces.length
      else
        codepoint = codepoint_str.to_i(16)

        if codepoint >= 0x110000
          diagnostic :error, :unicode_point_too_large, nil,
                     range(codepoint_s, codepoint_s + codepoint_str.length)
          break
        end

        @escape     += codepoint.chr(Encoding::UTF_8)
        codepoint_s += codepoint_str.length
      end
    end
  		end
# line 1918 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 810; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 118 then
# line 704 "lib/parser/lexer.rl"
		begin

    codepoint = @source_pts[p - 1]

    if @version >= 30 && (codepoint == 117 || codepoint == 85) # 'u' or 'U'
      diagnostic :fatal, :invalid_escape
    end

    if (@escape = ESCAPES[codepoint]).nil?
      @escape = encode_escape(@source_buffer.slice(p - 1))
    end
  		end
# line 895 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 149 then
# line 704 "lib/parser/lexer.rl"
		begin

    codepoint = @source_pts[p - 1]

    if @version >= 30 && (codepoint == 117 || codepoint == 85) # 'u' or 'U'
      diagnostic :fatal, :invalid_escape
    end

    if (@escape = ESCAPES[codepoint]).nil?
      @escape = encode_escape(@source_buffer.slice(p - 1))
    end
  		end
# line 895 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 363 then
# line 704 "lib/parser/lexer.rl"
		begin

    codepoint = @source_pts[p - 1]

    if @version >= 30 && (codepoint == 117 || codepoint == 85) # 'u' or 'U'
      diagnostic :fatal, :invalid_escape
    end

    if (@escape = ESCAPES[codepoint]).nil?
      @escape = encode_escape(@source_buffer.slice(p - 1))
    end
  		end
# line 1918 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 810; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 121 then
# line 716 "lib/parser/lexer.rl"
		begin

    diagnostic :fatal, :invalid_escape
  		end
# line 895 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 152 then
# line 716 "lib/parser/lexer.rl"
		begin

    diagnostic :fatal, :invalid_escape
  		end
# line 895 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 366 then
# line 716 "lib/parser/lexer.rl"
		begin

    diagnostic :fatal, :invalid_escape
  		end
# line 1918 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 810; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 123 then
# line 744 "lib/parser/lexer.rl"
		begin
 @escape = "\x7f" 		end
# line 895 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 154 then
# line 744 "lib/parser/lexer.rl"
		begin
 @escape = "\x7f" 		end
# line 895 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 368 then
# line 744 "lib/parser/lexer.rl"
		begin
 @escape = "\x7f" 		end
# line 1918 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 810; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 120 then
# line 752 "lib/parser/lexer.rl"
		begin
 @escape = encode_escape(tok(@escape_s, p).to_i(8) % 0x100) 		end
# line 895 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 151 then
# line 752 "lib/parser/lexer.rl"
		begin
 @escape = encode_escape(tok(@escape_s, p).to_i(8) % 0x100) 		end
# line 895 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 365 then
# line 752 "lib/parser/lexer.rl"
		begin
 @escape = encode_escape(tok(@escape_s, p).to_i(8) % 0x100) 		end
# line 1918 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 810; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 140 then
# line 756 "lib/parser/lexer.rl"
		begin
 @escape = encode_escape(tok(@escape_s + 1, p).to_i(16)) 		end
# line 895 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 171 then
# line 756 "lib/parser/lexer.rl"
		begin
 @escape = encode_escape(tok(@escape_s + 1, p).to_i(16)) 		end
# line 895 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 385 then
# line 756 "lib/parser/lexer.rl"
		begin
 @escape = encode_escape(tok(@escape_s + 1, p).to_i(16)) 		end
# line 1918 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 810; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 139 then
# line 760 "lib/parser/lexer.rl"
		begin

        diagnostic :fatal, :invalid_hex_escape, nil, range(@escape_s - 1, p + 2)
      		end
# line 895 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 170 then
# line 760 "lib/parser/lexer.rl"
		begin

        diagnostic :fatal, :invalid_hex_escape, nil, range(@escape_s - 1, p + 2)
      		end
# line 895 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 384 then
# line 760 "lib/parser/lexer.rl"
		begin

        diagnostic :fatal, :invalid_hex_escape, nil, range(@escape_s - 1, p + 2)
      		end
# line 1918 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 810; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 134 then
# line 766 "lib/parser/lexer.rl"
		begin
 @escape = tok(@escape_s + 1, p).to_i(16).chr(Encoding::UTF_8) 		end
# line 895 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 165 then
# line 766 "lib/parser/lexer.rl"
		begin
 @escape = tok(@escape_s + 1, p).to_i(16).chr(Encoding::UTF_8) 		end
# line 895 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 379 then
# line 766 "lib/parser/lexer.rl"
		begin
 @escape = tok(@escape_s + 1, p).to_i(16).chr(Encoding::UTF_8) 		end
# line 1918 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 810; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 133 then
# line 770 "lib/parser/lexer.rl"
		begin

        diagnostic :fatal, :invalid_unicode_escape, nil, range(@escape_s - 1, p)
      		end
# line 895 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 164 then
# line 770 "lib/parser/lexer.rl"
		begin

        diagnostic :fatal, :invalid_unicode_escape, nil, range(@escape_s - 1, p)
      		end
# line 895 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 378 then
# line 770 "lib/parser/lexer.rl"
		begin

        diagnostic :fatal, :invalid_unicode_escape, nil, range(@escape_s - 1, p)
      		end
# line 1918 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 810; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 138 then
# line 776 "lib/parser/lexer.rl"
		begin

        diagnostic :fatal, :invalid_unicode_escape, nil, range(@escape_s - 1, p)
      		end
# line 895 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 169 then
# line 776 "lib/parser/lexer.rl"
		begin

        diagnostic :fatal, :invalid_unicode_escape, nil, range(@escape_s - 1, p)
      		end
# line 895 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 383 then
# line 776 "lib/parser/lexer.rl"
		begin

        diagnostic :fatal, :invalid_unicode_escape, nil, range(@escape_s - 1, p)
      		end
# line 1918 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 810; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 135 then
# line 790 "lib/parser/lexer.rl"
		begin

          diagnostic :fatal, :unterminated_unicode, nil, range(p - 1, p)
        		end
# line 895 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 166 then
# line 790 "lib/parser/lexer.rl"
		begin

          diagnostic :fatal, :unterminated_unicode, nil, range(p - 1, p)
        		end
# line 895 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 380 then
# line 790 "lib/parser/lexer.rl"
		begin

          diagnostic :fatal, :unterminated_unicode, nil, range(p - 1, p)
        		end
# line 1918 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 810; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 119 then
# line 816 "lib/parser/lexer.rl"
		begin

      diagnostic :fatal, :escape_eof, nil, range(p - 1, p)
    		end
# line 895 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 150 then
# line 816 "lib/parser/lexer.rl"
		begin

      diagnostic :fatal, :escape_eof, nil, range(p - 1, p)
    		end
# line 895 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 364 then
# line 816 "lib/parser/lexer.rl"
		begin

      diagnostic :fatal, :escape_eof, nil, range(p - 1, p)
    		end
# line 1918 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 810; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 177 then
# line 822 "lib/parser/lexer.rl"
		begin

    @escape_s = p
    @escape   = nil
  		end
# line 895 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 182 then
# line 822 "lib/parser/lexer.rl"
		begin

    @escape_s = p
    @escape   = nil
  		end
# line 895 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 58 then
# line 862 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 498 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
	when 31 then
# line 862 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1563 "lib/parser/lexer.rl"
		begin
 tm = p 		end
	when 33 then
# line 862 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1583 "lib/parser/lexer.rl"
		begin
 tm = p 		end
	when 35 then
# line 862 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1611 "lib/parser/lexer.rl"
		begin
 tm = p 		end
	when 219 then
# line 862 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1424 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 238 then
# line 862 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1454 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 246 then
# line 862 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1486 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 34 then
# line 862 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1623 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        p = @ts - 1
        	begin
		 @cs = 810
		_goto_level = _again
		next
	end

       end
		end
	when 277 then
# line 862 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1628 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 269 then
# line 862 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1634 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 810
		_goto_level = _again
		next
	end
  end
		end
	when 288 then
# line 862 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1712 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 300 then
# line 862 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1733 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 296 then
# line 862 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1736 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 810
		_goto_level = _again
		next
	end
  end
		end
	when 59 then
# line 862 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1754 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        emit(:tUNARY_NUM, tok(@ts, @ts + 1), @ts, @ts + 1)
        p = p - 1;  @cs = 810; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 50 then
# line 862 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 2114 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        emit(:tIDENTIFIER, ident_tok, ident_ts, ident_te)
        p = ident_te - 1

        if !@static_env.nil? && @static_env.declared?(ident_tok) && @version < 25
           @cs = 465;
        else
           @cs = 525;
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 318 then
# line 862 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 2130 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 402 then
# line 862 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 2157 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 398 then
# line 862 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 2160 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
      if @context.in_kwarg
        p = p - 1; 	begin
		 @cs = 810
		_goto_level = _again
		next
	end

      else
        	begin
		 @cs = 186
		_goto_level = _again
		next
	end

      end
     end
		end
	when 411 then
# line 862 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 2188 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 408 then
# line 862 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 2191 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  	begin
		 @cs = 186
		_goto_level = _again
		next
	end
  end
		end
	when 495 then
# line 862 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 2505 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 427 then
# line 862 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 2508 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  	begin
		 @cs = 990
		_goto_level = _again
		next
	end
  end
		end
	when 101 then
# line 862 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 2601 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 268 then
# line 1068 "lib/parser/lexer.rl"
		begin

    @cond.push(false); @cmdarg.push(false)

    current_literal = literal
    if current_literal
      current_literal.start_interp_brace
    end
  		end
# line 1530 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        if @lambda_stack.last == @paren_nest
          @lambda_stack.pop
          emit(:tLAMBEG, '{'.freeze, @te - 1, @te)
        else
          emit(:tLCURLY, '{'.freeze, @te - 1, @te)
        end
        @command_start = true
        @paren_nest += 1
         @cs = 802; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 290 then
# line 1068 "lib/parser/lexer.rl"
		begin

    @cond.push(false); @cmdarg.push(false)

    current_literal = literal
    if current_literal
      current_literal.start_interp_brace
    end
  		end
# line 1696 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        if @lambda_stack.last == @paren_nest
          @lambda_stack.pop
          emit(:tLAMBEG, '{'.freeze)
        else
          emit(:tLBRACE_ARG, '{'.freeze)
        end
        @paren_nest += 1
        @command_start = true
         @cs = 802; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 393 then
# line 1068 "lib/parser/lexer.rl"
		begin

    @cond.push(false); @cmdarg.push(false)

    current_literal = literal
    if current_literal
      current_literal.start_interp_brace
    end
  		end
# line 1976 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        if @lambda_stack.last == @paren_nest
          @lambda_stack.pop
          @command_start = true
          emit(:tLAMBEG, '{'.freeze)
        else
          emit(:tLBRACE, '{'.freeze)
        end
        @paren_nest += 1
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 508 then
# line 1068 "lib/parser/lexer.rl"
		begin

    @cond.push(false); @cmdarg.push(false)

    current_literal = literal
    if current_literal
      current_literal.start_interp_brace
    end
  		end
# line 2213 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        if @lambda_stack.last == @paren_nest
          @lambda_stack.pop

          if tok == '{'.freeze
            emit(:tLAMBEG, '{'.freeze)
          else # 'do'
            emit(:kDO_LAMBDA, 'do'.freeze)
          end
        else
          if tok == '{'.freeze
            emit(:tLCURLY, '{'.freeze)
          else # 'do'
            emit_do
          end
        end
        if tok == '{'.freeze
          @paren_nest += 1
        end
        @command_start = true

         @cs = 802; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 509 then
# line 1077 "lib/parser/lexer.rl"
		begin

    current_literal = literal
    if current_literal
      if current_literal.end_interp_brace_and_try_closing
        if version?(18, 19)
          emit(:tRCURLY, '}'.freeze, p - 1, p)
          @cond.lexpop
          @cmdarg.lexpop
        else
          emit(:tSTRING_DEND, '}'.freeze, p - 1, p)
        end

        if current_literal.saved_herebody_s
          @herebody_s = current_literal.saved_herebody_s
        end


        p = p - 1;
         @cs = (next_state_for_literal(current_literal));
        	begin
		p += 1
		_goto_level = _out
		next
	end

      end
    end

    @paren_nest -= 1
  		end
# line 2450 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit_table(PUNCTUATION)

        if @version < 24
          @cond.lexpop
          @cmdarg.lexpop
        else
          @cond.pop
          @cmdarg.pop
        end

        if tok == '}'.freeze || tok == ']'.freeze
          if @version >= 25
             @cs = 810;
          else
             @cs = 531;
          end
        else # )
          # fnext expr_endfn; ?
        end

        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 61 then
# line 1226 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1229 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
	when 65 then
# line 1229 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 498 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
	when 222 then
# line 1229 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1424 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 237 then
# line 1229 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1454 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 249 then
# line 1229 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1486 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 271 then
# line 1229 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1631 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  	begin
		 @cs = 810
		_goto_level = _again
		next
	end
  end
		end
	when 286 then
# line 1229 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1712 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 298 then
# line 1229 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1733 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 324 then
# line 1229 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 2130 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 400 then
# line 1229 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 2157 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 410 then
# line 1229 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 2188 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 431 then
# line 1229 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 2505 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 103 then
# line 1229 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 2601 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 243 then
# line 1270 "lib/parser/lexer.rl"
		begin
 tm = p 		end
# line 1476 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tFID, tok(@ts, tm), @ts, tm)
            @cs = (arg_or_cmdarg(cmd_state)); p = tm - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 338 then
# line 1270 "lib/parser/lexer.rl"
		begin
 tm = p 		end
# line 1882 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit(:tSYMBOL, tok(@ts + 1, tm), @ts, tm)
        p = tm - 1
         @cs = 810; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 309 then
# line 1270 "lib/parser/lexer.rl"
		begin
 tm = p 		end
# line 2103 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = @ts - 1
           	begin
		 @cs = 810
		_goto_level = _again
		next
	end
  end
		end
	when 424 then
# line 1270 "lib/parser/lexer.rl"
		begin
 tm = p 		end
# line 1 "NONE"
		begin
	case  @act
	when 145 then
	begin begin p = (( @te))-1; end

        if @lambda_stack.last == @paren_nest
          @lambda_stack.pop

          if tok == '{'.freeze
            emit(:tLAMBEG, '{'.freeze)
          else # 'do'
            emit(:kDO_LAMBDA, 'do'.freeze)
          end
        else
          if tok == '{'.freeze
            emit(:tLCURLY, '{'.freeze)
          else # 'do'
            emit_do
          end
        end
        if tok == '{'.freeze
          @paren_nest += 1
        end
        @command_start = true

         @cs = 802; 	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 146 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS)
            @cs = 352; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 147 then
	begin begin p = (( @te))-1; end
 emit(:kCLASS, 'class'.freeze, @ts, @ts + 5)
           emit(:tLSHFT, '<<'.freeze,    @te - 2, @te)
            @cs = 802; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 148 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS)
            @cs = 563; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 149 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS)
           @command_start = true
            @cs = 802; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 150 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS)
            @cs = 539; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 151 then
	begin begin p = (( @te))-1; end

        emit_table(KEYWORDS)

        if version?(18) && tok == 'not'.freeze
           @cs = 563; 	begin
		p += 1
		_goto_level = _out
		next
	end

        else
           @cs = 494; 	begin
		p += 1
		_goto_level = _out
		next
	end

        end
      end
	when 152 then
	begin begin p = (( @te))-1; end

        if version?(18)
          emit(:tIDENTIFIER)

          unless !@static_env.nil? && @static_env.declared?(tok)
             @cs = (arg_or_cmdarg(cmd_state));
          end
        else
          emit(:k__ENCODING__, '__ENCODING__'.freeze)
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 153 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS)
           	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 154 then
	begin begin p = (( @te))-1; end

        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 156 then
	begin begin p = (( @te))-1; end

        if version?(18, 19, 20)
          diagnostic :error,
                     :trailing_in_number, { :character => tok(@te - 1, @te) },
                     range(@te - 1, @te)
        else
          emit(:tINTEGER, tok(@ts, @te - 1).to_i, @ts, @te - 1)
          p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

        end
      end
	when 157 then
	begin begin p = (( @te))-1; end

        if version?(18, 19, 20)
          diagnostic :error,
                     :trailing_in_number, { :character => tok(@te - 1, @te) },
                     range(@te - 1, @te)
        else
          emit(:tFLOAT, tok(@ts, @te - 1).to_f, @ts, @te - 1)
          p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

        end
      end
	when 158 then
	begin begin p = (( @te))-1; end

        digits = tok(@ts, @num_suffix_s)

        if version?(18, 19, 20)
          emit(:tFLOAT, Float(digits), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits)
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 160 then
	begin begin p = (( @te))-1; end
 emit(:tCONSTANT)
            @cs = (arg_or_cmdarg(cmd_state)); 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 164 then
	begin begin p = (( @te))-1; end

    emit(:tIDENTIFIER)

    if !@static_env.nil? && @static_env.declared?(tok)
       @cs = 465; 	begin
		p += 1
		_goto_level = _out
		next
	end

    else
       @cs = (arg_or_cmdarg(cmd_state)); 	begin
		p += 1
		_goto_level = _out
		next
	end

    end
  end
	when 165 then
	begin begin p = (( @te))-1; end

        if tm == @te
          # Suffix was consumed, e.g. foo!
          emit(:tFID)
        else
          # Suffix was not consumed, e.g. foo!=
          emit(:tIDENTIFIER, tok(@ts, tm), @ts, tm)
          p = tm - 1
        end
         @cs = 494; 	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 167 then
	begin begin p = (( @te))-1; end

        emit_table(PUNCTUATION);
         @cs = 802; 	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 168 then
	begin begin p = (( @te))-1; end
 emit_table(PUNCTUATION)
            @cs = 563; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
end 
			end
	when 244 then
# line 1271 "lib/parser/lexer.rl"
		begin
 tm = p - 2 		end
# line 1476 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tFID, tok(@ts, tm), @ts, tm)
            @cs = (arg_or_cmdarg(cmd_state)); p = tm - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 339 then
# line 1271 "lib/parser/lexer.rl"
		begin
 tm = p - 2 		end
# line 1882 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit(:tSYMBOL, tok(@ts + 1, tm), @ts, tm)
        p = tm - 1
         @cs = 810; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 311 then
# line 1271 "lib/parser/lexer.rl"
		begin
 tm = p - 2 		end
# line 2103 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = @ts - 1
           	begin
		 @cs = 810
		_goto_level = _again
		next
	end
  end
		end
	when 425 then
# line 1271 "lib/parser/lexer.rl"
		begin
 tm = p - 2 		end
# line 2414 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        if tm == @te
          # Suffix was consumed, e.g. foo!
          emit(:tFID)
        else
          # Suffix was not consumed, e.g. foo!=
          emit(:tIDENTIFIER, tok(@ts, tm), @ts, tm)
          p = tm - 1
        end
         @cs = 494; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 340 then
# line 1276 "lib/parser/lexer.rl"
		begin
 tm = p 		end
# line 1882 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit(:tSYMBOL, tok(@ts + 1, tm), @ts, tm)
        p = tm - 1
         @cs = 810; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 312 then
# line 1276 "lib/parser/lexer.rl"
		begin
 tm = p 		end
# line 2103 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = @ts - 1
           	begin
		 @cs = 810
		_goto_level = _again
		next
	end
  end
		end
	when 341 then
# line 1277 "lib/parser/lexer.rl"
		begin
 tm = p - 2 		end
# line 1882 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit(:tSYMBOL, tok(@ts + 1, tm), @ts, tm)
        p = tm - 1
         @cs = 810; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 313 then
# line 1277 "lib/parser/lexer.rl"
		begin
 tm = p - 2 		end
# line 2103 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = @ts - 1
           	begin
		 @cs = 810
		_goto_level = _again
		next
	end
  end
		end
	when 345 then
# line 1278 "lib/parser/lexer.rl"
		begin
 tm = p - 2 		end
# line 1882 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit(:tSYMBOL, tok(@ts + 1, tm), @ts, tm)
        p = tm - 1
         @cs = 810; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 316 then
# line 1278 "lib/parser/lexer.rl"
		begin
 tm = p - 2 		end
# line 2103 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = @ts - 1
           	begin
		 @cs = 810
		_goto_level = _again
		next
	end
  end
		end
	when 344 then
# line 1279 "lib/parser/lexer.rl"
		begin
 tm = p - 2 		end
# line 1882 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit(:tSYMBOL, tok(@ts + 1, tm), @ts, tm)
        p = tm - 1
         @cs = 810; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 315 then
# line 1279 "lib/parser/lexer.rl"
		begin
 tm = p - 2 		end
# line 1 "NONE"
		begin
	case  @act
	when 99 then
	begin begin p = (( @te))-1; end

        emit(:tUNARY_NUM, tok(@ts, @ts + 1), @ts, @ts + 1)
        p = p - 1;  @cs = 810; 	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 106 then
	begin begin p = (( @te))-1; end

        diagnostic :error, :unterminated_heredoc_id, nil, range(@ts, @ts + 1)
      end
	when 117 then
	begin begin p = (( @te))-1; end

        if @version >= 27
          emit(:tPIPE, tok(@ts, @ts + 1), @ts, @ts + 1)
          p = p - 1;
           @cs = 563; 	begin
		p += 1
		_goto_level = _out
		next
	end

        else
          p -= 2
          	begin
		 @cs = 810
		_goto_level = _again
		next
	end

        end
      end
	when 121 then
	begin begin p = (( @te))-1; end
 emit_table(PUNCTUATION_BEGIN)
           	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 122 then
	begin begin p = (( @te))-1; end
 emit(:kRESCUE, 'rescue'.freeze, @ts, tm)
           p = tm - 1
            @cs = 539; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 123 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS_BEGIN)
           @command_start = true
            @cs = 802; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 127 then
	begin begin p = (( @te))-1; end
 p = @ts - 1
           	begin
		 @cs = 810
		_goto_level = _again
		next
	end
 end
	when 128 then
	begin begin p = (( @te))-1; end

    emit(:tIDENTIFIER)

    if !@static_env.nil? && @static_env.declared?(tok)
       @cs = 465; 	begin
		p += 1
		_goto_level = _out
		next
	end

    else
       @cs = (arg_or_cmdarg(cmd_state)); 	begin
		p += 1
		_goto_level = _out
		next
	end

    end
  end
	when 132 then
	begin begin p = (( @te))-1; end
 p = @ts - 1; 	begin
		 @cs = 810
		_goto_level = _again
		next
	end
 end
end 
			end
	when 342 then
# line 1280 "lib/parser/lexer.rl"
		begin
 tm = p - 3 		end
# line 1882 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit(:tSYMBOL, tok(@ts + 1, tm), @ts, tm)
        p = tm - 1
         @cs = 810; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 314 then
# line 1280 "lib/parser/lexer.rl"
		begin
 tm = p - 3 		end
# line 2103 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = @ts - 1
           	begin
		 @cs = 810
		_goto_level = _again
		next
	end
  end
		end
	when 343 then
# line 1285 "lib/parser/lexer.rl"
		begin
 tm = p - 2 		end
# line 1882 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit(:tSYMBOL, tok(@ts + 1, tm), @ts, tm)
        p = tm - 1
         @cs = 810; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 490 then
# line 1290 "lib/parser/lexer.rl"
		begin
 tm = p - 2 		end
# line 2396 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tCONSTANT, tok(@ts, tm), @ts, tm)
           p = tm - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 267 then
# line 1296 "lib/parser/lexer.rl"
		begin

    @cond.push(false); @cmdarg.push(false)

    @paren_nest += 1
  		end
# line 1524 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tLBRACK, '['.freeze, @te - 1, @te)
            @cs = 563; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 386 then
# line 1296 "lib/parser/lexer.rl"
		begin

    @cond.push(false); @cmdarg.push(false)

    @paren_nest += 1
  		end
# line 1990 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tLBRACK, '['.freeze)
           	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 493 then
# line 1296 "lib/parser/lexer.rl"
		begin

    @cond.push(false); @cmdarg.push(false)

    @paren_nest += 1
  		end
# line 2483 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tLBRACK2, '['.freeze)
            @cs = 563; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 496 then
# line 1302 "lib/parser/lexer.rl"
		begin

    @paren_nest -= 1
  		end
# line 2450 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit_table(PUNCTUATION)

        if @version < 24
          @cond.lexpop
          @cmdarg.lexpop
        else
          @cond.pop
          @cmdarg.pop
        end

        if tok == '}'.freeze || tok == ']'.freeze
          if @version >= 25
             @cs = 810;
          else
             @cs = 531;
          end
        else # )
          # fnext expr_endfn; ?
        end

        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 259 then
# line 1309 "lib/parser/lexer.rl"
		begin

    @cond.push(false); @cmdarg.push(false)

    @paren_nest += 1

    if version?(18)
      @command_start = true
    end
  		end
# line 1505 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        if version?(18)
          emit(:tLPAREN2, '('.freeze, @te - 1, @te)
           @cs = 802; 	begin
		p += 1
		_goto_level = _out
		next
	end

        else
          emit(:tLPAREN_ARG, '('.freeze, @te - 1, @te)
           @cs = 563; 	begin
		p += 1
		_goto_level = _out
		next
	end

        end
       end
		end
	when 272 then
# line 1309 "lib/parser/lexer.rl"
		begin

    @cond.push(false); @cmdarg.push(false)

    @paren_nest += 1

    if version?(18)
      @command_start = true
    end
  		end
# line 1518 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tLPAREN2, '('.freeze)
            @cs = 563; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 280 then
# line 1309 "lib/parser/lexer.rl"
		begin

    @cond.push(false); @cmdarg.push(false)

    @paren_nest += 1

    if version?(18)
      @command_start = true
    end
  		end
# line 1650 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit(:tLPAREN_ARG, '('.freeze, @te - 1, @te)
        if version?(18)
           @cs = 802; 	begin
		p += 1
		_goto_level = _out
		next
	end

        else
           @cs = 563; 	begin
		p += 1
		_goto_level = _out
		next
	end

        end
       end
		end
	when 328 then
# line 1309 "lib/parser/lexer.rl"
		begin

    @cond.push(false); @cmdarg.push(false)

    @paren_nest += 1

    if version?(18)
      @command_start = true
    end
  		end
# line 1995 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tLPAREN, '('.freeze)
           	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 437 then
# line 1309 "lib/parser/lexer.rl"
		begin

    @cond.push(false); @cmdarg.push(false)

    @paren_nest += 1

    if version?(18)
      @command_start = true
    end
  		end
# line 2446 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit_table(PUNCTUATION)
            @cs = 563; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 438 then
# line 1319 "lib/parser/lexer.rl"
		begin

    @paren_nest -= 1
  		end
# line 2450 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit_table(PUNCTUATION)

        if @version < 24
          @cond.lexpop
          @cmdarg.lexpop
        else
          @cond.pop
          @cmdarg.pop
        end

        if tok == '}'.freeze || tok == ']'.freeze
          if @version >= 25
             @cs = 810;
          else
             @cs = 531;
          end
        else # )
          # fnext expr_endfn; ?
        end

        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 72 then
# line 1803 "lib/parser/lexer.rl"
		begin
 heredoc_e      = p 		end
# line 498 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
	when 353 then
# line 1804 "lib/parser/lexer.rl"
		begin
 new_herebody_s = p 		end
# line 1805 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        tok(@ts, heredoc_e) =~ /^<<(-?)(~?)(["'`]?)(.*)\3$/m

        indent      = !$1.empty? || !$2.empty?
        dedent_body = !$2.empty?
        type        =  $3.empty? ? '<<"'.freeze : ('<<'.freeze + $3)
        delimiter   =  $4

        if @version >= 27
          if delimiter.count("\n") > 0 || delimiter.count("\r") > 0
            diagnostic :error, :unterminated_heredoc_id, nil, range(@ts, @ts + 1)
          end
        elsif @version >= 24
          if delimiter.count("\n") > 0
            if delimiter.end_with?("\n")
              diagnostic :warning, :heredoc_id_ends_with_nl, nil, range(@ts, @ts + 1)
              delimiter = delimiter.rstrip
            else
              diagnostic :fatal, :heredoc_id_has_newline, nil, range(@ts, @ts + 1)
            end
          end
        end

        if dedent_body && version?(18, 19, 20, 21, 22)
          emit(:tLSHFT, '<<'.freeze, @ts, @ts + 2)
          p = @ts + 1
           @cs = 563; 	begin
		p += 1
		_goto_level = _out
		next
	end

        else
           @cs = (push_literal(type, delimiter, @ts, heredoc_e, indent, dedent_body));

          @herebody_s ||= new_herebody_s
          p = @herebody_s - 1
        end
       end
		end
	when 348 then
# line 1895 "lib/parser/lexer.rl"
		begin
 tm = p - 1; diag_msg = :ivar_name 		end
# line 1898 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        if @version >= 27
          diagnostic :error, diag_msg, { name: tok(tm, @te) }, range(tm, @te)
        else
          emit(:tCOLON, tok(@ts, @ts + 1), @ts, @ts + 1)
          p = @ts
        end

         @cs = 810; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 351 then
# line 1896 "lib/parser/lexer.rl"
		begin
 tm = p - 2; diag_msg = :cvar_name 		end
# line 1898 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        if @version >= 27
          diagnostic :error, diag_msg, { name: tok(tm, @te) }, range(tm, @te)
        else
          emit(:tCOLON, tok(@ts, @ts + 1), @ts, @ts + 1)
          p = @ts
        end

         @cs = 810; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 359 then
# line 1916 "lib/parser/lexer.rl"
		begin
 @escape = nil 		end
# line 1918 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 810; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 389 then
# line 2005 "lib/parser/lexer.rl"
		begin
 tm = p 		end
# line 2006 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:kRESCUE, 'rescue'.freeze, @ts, tm)
           p = tm - 1
            @cs = 539; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 480 then
# line 2298 "lib/parser/lexer.rl"
		begin
 @num_base = 16; @num_digits_s = p 		end
# line 2304 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
	when 474 then
# line 2299 "lib/parser/lexer.rl"
		begin
 @num_base = 10; @num_digits_s = p 		end
# line 2304 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
	when 477 then
# line 2300 "lib/parser/lexer.rl"
		begin
 @num_base = 8;  @num_digits_s = p 		end
# line 2304 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
	when 471 then
# line 2301 "lib/parser/lexer.rl"
		begin
 @num_base = 2;  @num_digits_s = p 		end
# line 2304 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
	when 486 then
# line 2302 "lib/parser/lexer.rl"
		begin
 @num_base = 10; @num_digits_s = @ts 		end
# line 2304 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
	when 449 then
# line 2303 "lib/parser/lexer.rl"
		begin
 @num_base = 8;  @num_digits_s = @ts 		end
# line 2304 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
	when 487 then
# line 2304 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 632 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars) } 		end
	when 8 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 498 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
	when 453 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2362 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
	when 228 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1383 "lib/parser/lexer.rl"
		begin
 @act = 43;		end
	when 215 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1387 "lib/parser/lexer.rl"
		begin
 @act = 44;		end
	when 211 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1391 "lib/parser/lexer.rl"
		begin
 @act = 45;		end
	when 27 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1567 "lib/parser/lexer.rl"
		begin
 @act = 72;		end
	when 261 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1584 "lib/parser/lexer.rl"
		begin
 @act = 73;		end
	when 28 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1623 "lib/parser/lexer.rl"
		begin
 @act = 78;		end
	when 254 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1628 "lib/parser/lexer.rl"
		begin
 @act = 79;		end
	when 281 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1660 "lib/parser/lexer.rl"
		begin
 @act = 85;		end
	when 46 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1673 "lib/parser/lexer.rl"
		begin
 @act = 86;		end
	when 302 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1727 "lib/parser/lexer.rl"
		begin
 @act = 93;		end
	when 291 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1731 "lib/parser/lexer.rl"
		begin
 @act = 94;		end
	when 70 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1851 "lib/parser/lexer.rl"
		begin
 @act = 106;		end
	when 394 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1959 "lib/parser/lexer.rl"
		begin
 @act = 117;		end
	when 305 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2000 "lib/parser/lexer.rl"
		begin
 @act = 121;		end
	when 388 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2006 "lib/parser/lexer.rl"
		begin
 @act = 122;		end
	when 387 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2012 "lib/parser/lexer.rl"
		begin
 @act = 123;		end
	when 75 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2103 "lib/parser/lexer.rl"
		begin
 @act = 127;		end
	when 303 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1324 "lib/parser/lexer.rl"
		begin
 @act = 128;		end
	when 306 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2149 "lib/parser/lexer.rl"
		begin
 @act = 132;		end
	when 504 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2213 "lib/parser/lexer.rl"
		begin
 @act = 145;		end
	when 499 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2242 "lib/parser/lexer.rl"
		begin
 @act = 146;		end
	when 507 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2252 "lib/parser/lexer.rl"
		begin
 @act = 148;		end
	when 500 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2257 "lib/parser/lexer.rl"
		begin
 @act = 149;		end
	when 501 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2262 "lib/parser/lexer.rl"
		begin
 @act = 150;		end
	when 506 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2266 "lib/parser/lexer.rl"
		begin
 @act = 151;		end
	when 498 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2277 "lib/parser/lexer.rl"
		begin
 @act = 152;		end
	when 492 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2291 "lib/parser/lexer.rl"
		begin
 @act = 153;		end
	when 418 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2305 "lib/parser/lexer.rl"
		begin
 @act = 154;		end
	when 451 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2349 "lib/parser/lexer.rl"
		begin
 @act = 157;		end
	when 82 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2364 "lib/parser/lexer.rl"
		begin
 @act = 158;		end
	when 421 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2392 "lib/parser/lexer.rl"
		begin
 @act = 160;		end
	when 412 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1324 "lib/parser/lexer.rl"
		begin
 @act = 164;		end
	when 423 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2414 "lib/parser/lexer.rl"
		begin
 @act = 165;		end
	when 416 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2440 "lib/parser/lexer.rl"
		begin
 @act = 167;		end
	when 422 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2446 "lib/parser/lexer.rl"
		begin
 @act = 168;		end
	when 88 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2537 "lib/parser/lexer.rl"
		begin
 @act = 181;		end
	when 511 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2576 "lib/parser/lexer.rl"
		begin
 @act = 185;		end
	when 183 then
# line 498 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 954 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
# line 822 "lib/parser/lexer.rl"
		begin

    @escape_s = p
    @escape   = nil
  		end
	when 124 then
# line 704 "lib/parser/lexer.rl"
		begin

    codepoint = @source_pts[p - 1]

    if @version >= 30 && (codepoint == 117 || codepoint == 85) # 'u' or 'U'
      diagnostic :fatal, :invalid_escape
    end

    if (@escape = ESCAPES[codepoint]).nil?
      @escape = encode_escape(@source_buffer.slice(p - 1))
    end
  		end
# line 728 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 895 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 155 then
# line 704 "lib/parser/lexer.rl"
		begin

    codepoint = @source_pts[p - 1]

    if @version >= 30 && (codepoint == 117 || codepoint == 85) # 'u' or 'U'
      diagnostic :fatal, :invalid_escape
    end

    if (@escape = ESCAPES[codepoint]).nil?
      @escape = encode_escape(@source_buffer.slice(p - 1))
    end
  		end
# line 728 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 895 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 369 then
# line 704 "lib/parser/lexer.rl"
		begin

    codepoint = @source_pts[p - 1]

    if @version >= 30 && (codepoint == 117 || codepoint == 85) # 'u' or 'U'
      diagnostic :fatal, :invalid_escape
    end

    if (@escape = ESCAPES[codepoint]).nil?
      @escape = encode_escape(@source_buffer.slice(p - 1))
    end
  		end
# line 728 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 1918 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 810; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 131 then
# line 704 "lib/parser/lexer.rl"
		begin

    codepoint = @source_pts[p - 1]

    if @version >= 30 && (codepoint == 117 || codepoint == 85) # 'u' or 'U'
      diagnostic :fatal, :invalid_escape
    end

    if (@escape = ESCAPES[codepoint]).nil?
      @escape = encode_escape(@source_buffer.slice(p - 1))
    end
  		end
# line 732 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 895 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 162 then
# line 704 "lib/parser/lexer.rl"
		begin

    codepoint = @source_pts[p - 1]

    if @version >= 30 && (codepoint == 117 || codepoint == 85) # 'u' or 'U'
      diagnostic :fatal, :invalid_escape
    end

    if (@escape = ESCAPES[codepoint]).nil?
      @escape = encode_escape(@source_buffer.slice(p - 1))
    end
  		end
# line 732 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 895 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 376 then
# line 704 "lib/parser/lexer.rl"
		begin

    codepoint = @source_pts[p - 1]

    if @version >= 30 && (codepoint == 117 || codepoint == 85) # 'u' or 'U'
      diagnostic :fatal, :invalid_escape
    end

    if (@escape = ESCAPES[codepoint]).nil?
      @escape = encode_escape(@source_buffer.slice(p - 1))
    end
  		end
# line 732 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 1918 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 810; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 122 then
# line 720 "lib/parser/lexer.rl"
		begin

    @escape = @source_buffer.slice(p - 1).chr

    if @version >= 27 && ((0..8).include?(@escape.ord) || (14..31).include?(@escape.ord))
      diagnostic :fatal, :invalid_escape
    end
  		end
# line 728 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 895 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 153 then
# line 720 "lib/parser/lexer.rl"
		begin

    @escape = @source_buffer.slice(p - 1).chr

    if @version >= 27 && ((0..8).include?(@escape.ord) || (14..31).include?(@escape.ord))
      diagnostic :fatal, :invalid_escape
    end
  		end
# line 728 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 895 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 367 then
# line 720 "lib/parser/lexer.rl"
		begin

    @escape = @source_buffer.slice(p - 1).chr

    if @version >= 27 && ((0..8).include?(@escape.ord) || (14..31).include?(@escape.ord))
      diagnostic :fatal, :invalid_escape
    end
  		end
# line 728 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 1918 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 810; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 130 then
# line 720 "lib/parser/lexer.rl"
		begin

    @escape = @source_buffer.slice(p - 1).chr

    if @version >= 27 && ((0..8).include?(@escape.ord) || (14..31).include?(@escape.ord))
      diagnostic :fatal, :invalid_escape
    end
  		end
# line 732 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 895 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 161 then
# line 720 "lib/parser/lexer.rl"
		begin

    @escape = @source_buffer.slice(p - 1).chr

    if @version >= 27 && ((0..8).include?(@escape.ord) || (14..31).include?(@escape.ord))
      diagnostic :fatal, :invalid_escape
    end
  		end
# line 732 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 895 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 375 then
# line 720 "lib/parser/lexer.rl"
		begin

    @escape = @source_buffer.slice(p - 1).chr

    if @version >= 27 && ((0..8).include?(@escape.ord) || (14..31).include?(@escape.ord))
      diagnostic :fatal, :invalid_escape
    end
  		end
# line 732 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 1918 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 810; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 126 then
# line 744 "lib/parser/lexer.rl"
		begin
 @escape = "\x7f" 		end
# line 732 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 895 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 157 then
# line 744 "lib/parser/lexer.rl"
		begin
 @escape = "\x7f" 		end
# line 732 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 895 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 371 then
# line 744 "lib/parser/lexer.rl"
		begin
 @escape = "\x7f" 		end
# line 732 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 1918 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 810; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 129 then
# line 745 "lib/parser/lexer.rl"
		begin
 @escape = encode_escape(tok(p - 2, p).to_i(16)) 		end
# line 728 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 895 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 160 then
# line 745 "lib/parser/lexer.rl"
		begin
 @escape = encode_escape(tok(p - 2, p).to_i(16)) 		end
# line 728 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 895 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 374 then
# line 745 "lib/parser/lexer.rl"
		begin
 @escape = encode_escape(tok(p - 2, p).to_i(16)) 		end
# line 728 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 1918 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 810; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 136 then
# line 776 "lib/parser/lexer.rl"
		begin

        diagnostic :fatal, :invalid_unicode_escape, nil, range(@escape_s - 1, p)
      		end
# line 790 "lib/parser/lexer.rl"
		begin

          diagnostic :fatal, :unterminated_unicode, nil, range(p - 1, p)
        		end
# line 895 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 167 then
# line 776 "lib/parser/lexer.rl"
		begin

        diagnostic :fatal, :invalid_unicode_escape, nil, range(@escape_s - 1, p)
      		end
# line 790 "lib/parser/lexer.rl"
		begin

          diagnostic :fatal, :unterminated_unicode, nil, range(p - 1, p)
        		end
# line 895 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 381 then
# line 776 "lib/parser/lexer.rl"
		begin

        diagnostic :fatal, :invalid_unicode_escape, nil, range(@escape_s - 1, p)
      		end
# line 790 "lib/parser/lexer.rl"
		begin

          diagnostic :fatal, :unterminated_unicode, nil, range(p - 1, p)
        		end
# line 1918 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 810; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 116 then
# line 822 "lib/parser/lexer.rl"
		begin

    @escape_s = p
    @escape   = nil
  		end
# line 816 "lib/parser/lexer.rl"
		begin

      diagnostic :fatal, :escape_eof, nil, range(p - 1, p)
    		end
# line 895 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 148 then
# line 822 "lib/parser/lexer.rl"
		begin

    @escape_s = p
    @escape   = nil
  		end
# line 816 "lib/parser/lexer.rl"
		begin

      diagnostic :fatal, :escape_eof, nil, range(p - 1, p)
    		end
# line 895 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 362 then
# line 822 "lib/parser/lexer.rl"
		begin

    @escape_s = p
    @escape   = nil
  		end
# line 816 "lib/parser/lexer.rl"
		begin

      diagnostic :fatal, :escape_eof, nil, range(p - 1, p)
    		end
# line 1918 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 810; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 62 then
# line 1226 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1229 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 498 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
	when 221 then
# line 1226 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1229 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1424 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 236 then
# line 1226 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1229 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1454 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 248 then
# line 1226 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1229 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1486 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 270 then
# line 1226 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1229 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1631 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  	begin
		 @cs = 810
		_goto_level = _again
		next
	end
  end
		end
	when 285 then
# line 1226 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1229 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1712 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 297 then
# line 1226 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1229 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1733 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 323 then
# line 1226 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1229 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 2130 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 399 then
# line 1226 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1229 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 2157 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 409 then
# line 1226 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1229 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 2188 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 430 then
# line 1226 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1229 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 2505 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 102 then
# line 1226 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1229 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 2601 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 482 then
# line 2302 "lib/parser/lexer.rl"
		begin
 @num_base = 10; @num_digits_s = @ts 		end
# line 2304 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 632 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars) } 		end
	when 446 then
# line 2303 "lib/parser/lexer.rl"
		begin
 @num_base = 8;  @num_digits_s = @ts 		end
# line 2304 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 632 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars) } 		end
	when 461 then
# line 2304 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 632 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars) } 		end
# line 2305 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 454 then
# line 2361 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 641 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tFLOAT,     Float(chars)) } 		end
# line 2364 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@ts, @num_suffix_s)

        if version?(18, 19, 20)
          emit(:tFLOAT, Float(digits), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits)
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 450 then
# line 2362 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 641 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tFLOAT,     Float(chars)) } 		end
# line 2364 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@ts, @num_suffix_s)

        if version?(18, 19, 20)
          emit(:tFLOAT, Float(digits), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits)
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 276 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 498 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 1628 "lib/parser/lexer.rl"
		begin
 @act = 79;		end
	when 36 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 862 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1623 "lib/parser/lexer.rl"
		begin
 @act = 78;		end
	when 47 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 862 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1673 "lib/parser/lexer.rl"
		begin
 @act = 86;		end
	when 94 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 862 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 2537 "lib/parser/lexer.rl"
		begin
 @act = 181;		end
	when 66 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1229 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1754 "lib/parser/lexer.rl"
		begin
 @act = 99;		end
	when 85 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1229 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 2246 "lib/parser/lexer.rl"
		begin
 @act = 147;		end
	when 93 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1229 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 2537 "lib/parser/lexer.rl"
		begin
 @act = 181;		end
	when 38 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1583 "lib/parser/lexer.rl"
		begin
 tm = p 		end
# line 1584 "lib/parser/lexer.rl"
		begin
 @act = 73;		end
	when 391 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2005 "lib/parser/lexer.rl"
		begin
 tm = p 		end
# line 2103 "lib/parser/lexer.rl"
		begin
 @act = 127;		end
	when 390 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2005 "lib/parser/lexer.rl"
		begin
 tm = p 		end
# line 1324 "lib/parser/lexer.rl"
		begin
 @act = 128;		end
	when 483 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2302 "lib/parser/lexer.rl"
		begin
 @num_base = 10; @num_digits_s = @ts 		end
# line 2305 "lib/parser/lexer.rl"
		begin
 @act = 154;		end
	when 127 then
# line 704 "lib/parser/lexer.rl"
		begin

    codepoint = @source_pts[p - 1]

    if @version >= 30 && (codepoint == 117 || codepoint == 85) # 'u' or 'U'
      diagnostic :fatal, :invalid_escape
    end

    if (@escape = ESCAPES[codepoint]).nil?
      @escape = encode_escape(@source_buffer.slice(p - 1))
    end
  		end
# line 728 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 732 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 895 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 158 then
# line 704 "lib/parser/lexer.rl"
		begin

    codepoint = @source_pts[p - 1]

    if @version >= 30 && (codepoint == 117 || codepoint == 85) # 'u' or 'U'
      diagnostic :fatal, :invalid_escape
    end

    if (@escape = ESCAPES[codepoint]).nil?
      @escape = encode_escape(@source_buffer.slice(p - 1))
    end
  		end
# line 728 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 732 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 895 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 372 then
# line 704 "lib/parser/lexer.rl"
		begin

    codepoint = @source_pts[p - 1]

    if @version >= 30 && (codepoint == 117 || codepoint == 85) # 'u' or 'U'
      diagnostic :fatal, :invalid_escape
    end

    if (@escape = ESCAPES[codepoint]).nil?
      @escape = encode_escape(@source_buffer.slice(p - 1))
    end
  		end
# line 728 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 732 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 1918 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 810; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 125 then
# line 720 "lib/parser/lexer.rl"
		begin

    @escape = @source_buffer.slice(p - 1).chr

    if @version >= 27 && ((0..8).include?(@escape.ord) || (14..31).include?(@escape.ord))
      diagnostic :fatal, :invalid_escape
    end
  		end
# line 728 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 732 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 895 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 156 then
# line 720 "lib/parser/lexer.rl"
		begin

    @escape = @source_buffer.slice(p - 1).chr

    if @version >= 27 && ((0..8).include?(@escape.ord) || (14..31).include?(@escape.ord))
      diagnostic :fatal, :invalid_escape
    end
  		end
# line 728 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 732 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 895 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 370 then
# line 720 "lib/parser/lexer.rl"
		begin

    @escape = @source_buffer.slice(p - 1).chr

    if @version >= 27 && ((0..8).include?(@escape.ord) || (14..31).include?(@escape.ord))
      diagnostic :fatal, :invalid_escape
    end
  		end
# line 728 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 732 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 1918 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 810; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 132 then
# line 738 "lib/parser/lexer.rl"
		begin
 @escape = encode_escape(tok(p - 2, p).to_i(16)) 		end
# line 728 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 732 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 895 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 163 then
# line 738 "lib/parser/lexer.rl"
		begin
 @escape = encode_escape(tok(p - 2, p).to_i(16)) 		end
# line 728 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 732 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 895 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 377 then
# line 738 "lib/parser/lexer.rl"
		begin
 @escape = encode_escape(tok(p - 2, p).to_i(16)) 		end
# line 728 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 732 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 1918 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 810; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 128 then
# line 745 "lib/parser/lexer.rl"
		begin
 @escape = encode_escape(tok(p - 2, p).to_i(16)) 		end
# line 728 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 732 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 895 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 159 then
# line 745 "lib/parser/lexer.rl"
		begin
 @escape = encode_escape(tok(p - 2, p).to_i(16)) 		end
# line 728 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 732 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 895 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.squiggly_heredoc? && escaped_char == "\n".freeze
        # Squiggly heredocs like
        #   <<~-HERE
        #     1\
        #     2
        #   HERE
        # treat '\' as a line continuation, but still dedent the body, so the heredoc above becomes "12\n".
        # This information is emitted as is, without escaping,
        # later this escape sequence (\\\n) gets handled manually in the Lexer::Dedenter
        current_literal.extend_string(tok, @ts, @te)
      elsif current_literal.supports_line_continuation_via_slash? && escaped_char == "\n".freeze
        # Heredocs, regexp and a few other types of literals support line
        # continuation via \\\n sequence. The code like
        #   "a\
        #   b"
        # must be parsed as "ab"
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      elsif current_literal.regexp? && @version >= 31 && %w[c C m M].include?(escaped_char)
        # Ruby >= 3.1 escapes \c- and \m chars, that's the only escape sequence
        # supported by regexes so far, so it needs a separate branch.
        current_literal.extend_string(@escape, @ts, @te)
      elsif current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed (in cases like "\\C-\\\n\\M-x")
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 373 then
# line 745 "lib/parser/lexer.rl"
		begin
 @escape = encode_escape(tok(p - 2, p).to_i(16)) 		end
# line 728 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 732 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 1918 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          emit(:tINTEGER, value.getbyte(0))
        else
          emit(:tCHARACTER, value)
        end

         @cs = 810; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 478 then
# line 2298 "lib/parser/lexer.rl"
		begin
 @num_base = 16; @num_digits_s = p 		end
# line 2304 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 632 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars) } 		end
# line 2305 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 472 then
# line 2299 "lib/parser/lexer.rl"
		begin
 @num_base = 10; @num_digits_s = p 		end
# line 2304 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 632 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars) } 		end
# line 2305 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 475 then
# line 2300 "lib/parser/lexer.rl"
		begin
 @num_base = 8;  @num_digits_s = p 		end
# line 2304 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 632 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars) } 		end
# line 2305 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 469 then
# line 2301 "lib/parser/lexer.rl"
		begin
 @num_base = 2;  @num_digits_s = p 		end
# line 2304 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 632 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars) } 		end
# line 2305 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 481 then
# line 2302 "lib/parser/lexer.rl"
		begin
 @num_base = 10; @num_digits_s = @ts 		end
# line 2304 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 632 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars) } 		end
# line 2305 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 445 then
# line 2303 "lib/parser/lexer.rl"
		begin
 @num_base = 8;  @num_digits_s = @ts 		end
# line 2304 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 632 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars) } 		end
# line 2305 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 32 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 862 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1583 "lib/parser/lexer.rl"
		begin
 tm = p 		end
# line 1584 "lib/parser/lexer.rl"
		begin
 @act = 73;		end
	when 63 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1226 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1229 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1754 "lib/parser/lexer.rl"
		begin
 @act = 99;		end
	when 92 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1226 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1229 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 2537 "lib/parser/lexer.rl"
		begin
 @act = 181;		end
	when 488 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2304 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 632 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars) } 		end
# line 2337 "lib/parser/lexer.rl"
		begin
 @act = 156;		end
	when 484 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2302 "lib/parser/lexer.rl"
		begin
 @num_base = 10; @num_digits_s = @ts 		end
# line 2304 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 632 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars) } 		end
# line 2337 "lib/parser/lexer.rl"
		begin
 @act = 156;		end
	when 448 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2303 "lib/parser/lexer.rl"
		begin
 @num_base = 8;  @num_digits_s = @ts 		end
# line 2304 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 632 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars) } 		end
# line 2337 "lib/parser/lexer.rl"
		begin
 @act = 156;		end
# line 24769 "lib/parser/lexer.rb"
	end
	end
	end
	if _goto_level <= _again
	case _lex_to_state_actions[ @cs] 
	when 96 then
# line 1 "NONE"
		begin
 @ts = nil;		end
# line 24779 "lib/parser/lexer.rb"
	end

	if  @cs == 0
		_goto_level = _out
		next
	end
	p += 1
	if p != pe
		_goto_level = _resume
		next
	end
	end
	if _goto_level <= _test_eof
	if p == eof
	if _lex_eof_trans[ @cs] > 0
		_trans = _lex_eof_trans[ @cs] - 1;
		_goto_level = _eof_trans
		next;
	end
	end

	end
	if _goto_level <= _out
		break
	end
end
	end

# line 283 "lib/parser/lexer.rl"
    # %

    # Ragel creates a local variable called `testEof` but it doesn't use
    # it in any assignment. This dead code is here to swallow the warning.
    # It has no runtime cost because Ruby doesn't produce any instructions from it.
    if false
      testEof
    end

    @p = p

    if @token_queue.any?
      @token_queue.shift
    elsif @cs == klass.lex_error
      [ false, [ '$error'.freeze, range(p - 1, p) ] ]
    else
      eof = @source_pts.size
      [ false, [ '$eof'.freeze,   range(eof, eof) ] ]
    end
  end

  protected

  def eof_codepoint?(point)
    [0x04, 0x1a, 0x00].include? point
  end

  def version?(*versions)
    versions.include?(@version)
  end

  def stack_pop
    @top -= 1
    @stack[@top]
  end

  def encode_escape(ord)
    ord.chr.force_encoding(@source_buffer.source.encoding)
  end

  def tok(s = @ts, e = @te)
    @source_buffer.slice(s...e)
  end

  def range(s = @ts, e = @te)
    Parser::Source::Range.new(@source_buffer, s, e)
  end

  def emit(type, value = tok, s = @ts, e = @te)
    token = [ type, [ value, range(s, e) ] ]

    @token_queue.push(token)

    @tokens.push(token) if @tokens

    token
  end

  def emit_table(table, s = @ts, e = @te)
    value = tok(s, e)

    emit(table[value], value, s, e)
  end

  def emit_do(do_block=false)
    if @cond.active?
      emit(:kDO_COND, 'do'.freeze)
    elsif @cmdarg.active? || do_block
      emit(:kDO_BLOCK, 'do'.freeze)
    else
      emit(:kDO, 'do'.freeze)
    end
  end

  def arg_or_cmdarg(cmd_state)
    if cmd_state
      self.class.lex_en_expr_cmdarg
    else
      self.class.lex_en_expr_arg
    end
  end

  def emit_comment(s = @ts, e = @te)
    if @comments
      @comments.push(Parser::Source::Comment.new(range(s, e)))
    end

    if @tokens
      @tokens.push([ :tCOMMENT, [ tok(s, e), range(s, e) ] ])
    end

    nil
  end

  def diagnostic(type, reason, arguments=nil, location=range, highlights=[])
    @diagnostics.process(
        Parser::Diagnostic.new(type, reason, arguments, location, highlights))
  end

  #
  # === LITERAL STACK ===
  #

  def push_literal(*args)
    new_literal = Literal.new(self, *args)
    @literal_stack.push(new_literal)
    next_state_for_literal(new_literal)
  end

  def next_state_for_literal(literal)
    if literal.words? && literal.backslash_delimited?
      if literal.interpolate?
        self.class.lex_en_interp_backslash_delimited_words
      else
        self.class.lex_en_plain_backslash_delimited_words
      end
    elsif literal.words? && !literal.backslash_delimited?
      if literal.interpolate?
        self.class.lex_en_interp_words
      else
        self.class.lex_en_plain_words
      end
    elsif !literal.words? && literal.backslash_delimited?
      if literal.interpolate?
        self.class.lex_en_interp_backslash_delimited
      else
        self.class.lex_en_plain_backslash_delimited
      end
    else
      if literal.interpolate?
        self.class.lex_en_interp_string
      else
        self.class.lex_en_plain_string
      end
    end
  end

  def literal
    @literal_stack.last
  end

  def pop_literal
    old_literal = @literal_stack.pop

    @dedent_level = old_literal.dedent_level

    if old_literal.type == :tREGEXP_BEG
      # Fetch modifiers.
      self.class.lex_en_regexp_modifiers
    else
      self.class.lex_en_expr_end
    end
  end

  # Mapping of strings to parser tokens.

  PUNCTUATION = {
    '='   => :tEQL,     '&'   => :tAMPER2,  '|'   => :tPIPE,
    '!'   => :tBANG,    '^'   => :tCARET,   '+'   => :tPLUS,
    '-'   => :tMINUS,   '*'   => :tSTAR2,   '/'   => :tDIVIDE,
    '%'   => :tPERCENT, '~'   => :tTILDE,   ','   => :tCOMMA,
    ';'   => :tSEMI,    '.'   => :tDOT,     '..'  => :tDOT2,
    '...' => :tDOT3,    '['   => :tLBRACK2, ']'   => :tRBRACK,
    '('   => :tLPAREN2, ')'   => :tRPAREN,  '?'   => :tEH,
    ':'   => :tCOLON,   '&&'  => :tANDOP,   '||'  => :tOROP,
    '-@'  => :tUMINUS,  '+@'  => :tUPLUS,   '~@'  => :tTILDE,
    '**'  => :tPOW,     '->'  => :tLAMBDA,  '=~'  => :tMATCH,
    '!~'  => :tNMATCH,  '=='  => :tEQ,      '!='  => :tNEQ,
    '>'   => :tGT,      '>>'  => :tRSHFT,   '>='  => :tGEQ,
    '<'   => :tLT,      '<<'  => :tLSHFT,   '<='  => :tLEQ,
    '=>'  => :tASSOC,   '::'  => :tCOLON2,  '===' => :tEQQ,
    '<=>' => :tCMP,     '[]'  => :tAREF,    '[]=' => :tASET,
    '{'   => :tLCURLY,  '}'   => :tRCURLY,  '`'   => :tBACK_REF2,
    '!@'  => :tBANG,    '&.'  => :tANDDOT,
  }

  PUNCTUATION_BEGIN = {
    '&'   => :tAMPER,   '*'   => :tSTAR,    '**'  => :tDSTAR,
    '+'   => :tUPLUS,   '-'   => :tUMINUS,  '::'  => :tCOLON3,
    '('   => :tLPAREN,  '{'   => :tLBRACE,  '['   => :tLBRACK,
  }

  KEYWORDS = {
    'if'     => :kIF_MOD,      'unless'   => :kUNLESS_MOD,
    'while'  => :kWHILE_MOD,   'until'    => :kUNTIL_MOD,
    'rescue' => :kRESCUE_MOD,  'defined?' => :kDEFINED,
    'BEGIN'  => :klBEGIN,      'END'      => :klEND,
  }

  KEYWORDS_BEGIN = {
    'if'     => :kIF,          'unless'   => :kUNLESS,
    'while'  => :kWHILE,       'until'    => :kUNTIL,
    'rescue' => :kRESCUE,      'defined?' => :kDEFINED,
    'BEGIN'  => :klBEGIN,      'END'      => :klEND,
  }

  %w(class module def undef begin end then elsif else ensure case when
     for break next redo retry in do return yield super self nil true
     false and or not alias __FILE__ __LINE__ __ENCODING__).each do |keyword|
    KEYWORDS_BEGIN[keyword] = KEYWORDS[keyword] = :"k#{keyword.upcase}"
  end

  
# line 2616 "lib/parser/lexer.rl"

  # %
end
