/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mail;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.mail.MailException;

public class MailSendException
extends MailException {
    private transient Map failedMessages;
    private Exception[] messageExceptions;

    public MailSendException(String msg) {
        super(msg);
    }

    public MailSendException(String msg, Throwable cause) {
        super(msg, cause);
    }

    public MailSendException(Map failedMessages) {
        super((String)null);
        this.failedMessages = new LinkedHashMap(failedMessages);
        this.messageExceptions = failedMessages.values().toArray(new Exception[failedMessages.size()]);
    }

    public final Map getFailedMessages() {
        return this.failedMessages != null ? this.failedMessages : Collections.EMPTY_MAP;
    }

    public final Exception[] getMessageExceptions() {
        return this.messageExceptions != null ? this.messageExceptions : new Exception[]{};
    }

    public String getMessage() {
        StringBuffer sb = new StringBuffer();
        String superMsg = super.getMessage();
        sb.append(superMsg != null ? superMsg : "Failed messages: ");
        for (int i = 0; i < this.messageExceptions.length; ++i) {
            Exception subEx = this.messageExceptions[i];
            sb.append(subEx.toString());
            if (i >= this.messageExceptions.length - 1) continue;
            sb.append("; ");
        }
        return sb.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName()).append("; nested exceptions (");
        sb.append(this.messageExceptions.length).append(") are:");
        for (int i = 0; i < this.messageExceptions.length; ++i) {
            Exception subEx = this.messageExceptions[i];
            sb.append('\n').append("Failed message ").append(i + 1).append(": ");
            sb.append(subEx);
        }
        return sb.toString();
    }

    public void printStackTrace(PrintStream ps) {
        if (this.messageExceptions.length == 0) {
            super.printStackTrace(ps);
        } else {
            ps.println(this.getClass().getName() + "; nested exception details (" + this.messageExceptions.length + ") are:");
            for (int i = 0; i < this.messageExceptions.length; ++i) {
                Exception subEx = this.messageExceptions[i];
                ps.println("Failed message " + (i + 1) + ":");
                subEx.printStackTrace(ps);
            }
        }
    }

    public void printStackTrace(PrintWriter pw) {
        if (this.messageExceptions.length == 0) {
            super.printStackTrace(pw);
        } else {
            pw.println(this.getClass().getName() + "; nested exception details (" + this.messageExceptions.length + ") are:");
            for (int i = 0; i < this.messageExceptions.length; ++i) {
                Exception subEx = this.messageExceptions[i];
                pw.println("Failed message " + (i + 1) + ":");
                subEx.printStackTrace(pw);
            }
        }
    }
}

