/*
 * Decompiled with CFR 0.152.
 */
package aQute.maven.repo.api;

import aQute.bnd.version.MavenVersion;
import aQute.maven.repo.api.Revision;

public class Archive {
    public final Revision revision;
    public final String classifier;
    public final String extension;
    public final String localPath;
    public final String remotePath;
    public final MavenVersion snapshot;

    Archive(Revision revision, MavenVersion snapshot, String extension, String classifier) {
        this.revision = revision;
        this.extension = extension == null ? "jar" : extension;
        this.classifier = classifier == null ? "" : classifier;
        this.snapshot = snapshot;
        this.localPath = String.valueOf(revision.path) + "/" + this.getName();
        this.remotePath = String.valueOf(revision.path) + "/" + this.getName(snapshot);
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.classifier == null ? 0 : this.classifier.hashCode());
        result = 31 * result + (this.extension == null ? 0 : this.extension.hashCode());
        result = 31 * result + (this.snapshot == null ? 0 : this.snapshot.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Archive other = (Archive)obj;
        if (!this.classifier.equals(other.classifier)) {
            return false;
        }
        if (!this.extension.equals(other.extension)) {
            return false;
        }
        if (!this.revision.equals(other.revision)) {
            return false;
        }
        if (this.snapshot != other.snapshot) {
            if (this.snapshot == null) {
                return false;
            }
            if (!this.snapshot.equals((Object)other.snapshot)) {
                return false;
            }
        }
        return true;
    }

    public Revision getRevision() {
        return this.revision;
    }

    public String getName() {
        return this.getName(this.revision.version);
    }

    public boolean isSnapshot() {
        return this.revision.isSnapshot();
    }

    public String getName(MavenVersion version) {
        return String.valueOf(this.revision.program.artifact) + "-" + (version == null ? this.revision.version : version) + (this.classifier.isEmpty() ? "" : "-" + this.classifier) + "." + this.extension;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.revision.program.group);
        sb.append(":");
        sb.append(this.revision.program.artifact);
        if (!this.extension.isEmpty()) {
            sb.append(":").append(this.extension);
            if (!this.classifier.isEmpty()) {
                sb.append(":").append(this.classifier);
            }
        } else if (!this.classifier.isEmpty()) {
            sb.append(":jar:").append(this.classifier);
        }
        sb.append(":").append(this.revision.version);
        return sb.toString();
    }

    public boolean isResolved() {
        return !this.isSnapshot() || this.snapshot != null;
    }

    public Archive resolveSnapshot(MavenVersion version) {
        if (version.equals((Object)this.snapshot)) {
            return this;
        }
        return new Archive(this.revision, version, this.extension, this.classifier);
    }

    public boolean isPom() {
        return "pom".equals(this.extension);
    }

    public Archive getPomArchive() {
        return this.revision.getPomArchive();
    }
}

