/*
 * Decompiled with CFR 0.152.
 */
package aQute.maven.repo.provider;

import aQute.bnd.version.MavenVersion;
import aQute.lib.io.IO;
import aQute.maven.repo.api.Archive;
import aQute.maven.repo.api.Revision;
import aQute.maven.repo.provider.MavenStorage;
import aQute.maven.repo.provider.MetadataParser;
import aQute.maven.repo.provider.Releaser;
import java.io.File;

public class SnapshotReleaser
extends Releaser {
    private MavenVersion snapshotVersion;
    private long timestamp = System.currentTimeMillis();
    private String build = null;

    public SnapshotReleaser(MavenStorage home, Revision revision) throws Exception {
        super(home, revision);
        this.force();
        assert (revision.isSnapshot());
        this.setBuild(this.timestamp, this.build);
    }

    @Override
    public void setBuild(long timestamp, String build) {
        this.timestamp = timestamp;
        this.build = build;
        this.snapshotVersion = this.revision.version.toSnapshot(timestamp, build);
    }

    @Override
    public void updateMetadata() throws Exception {
        MetadataParser.RevisionMetadata revisionMetadata = this.localOnly ? new MetadataParser.RevisionMetadata() : this.home.snapshot.getMetadata(this.revision);
        revisionMetadata.group = this.revision.group;
        revisionMetadata.artifact = this.revision.artifact;
        revisionMetadata.lastUpdated = this.programMetadata.lastUpdated;
        for (Archive archive : this.upload) {
            MetadataParser.SnapshotVersion snapshotVersion = new MetadataParser.SnapshotVersion();
            snapshotVersion.extension = archive.extension;
            snapshotVersion.classifier = archive.classifier.isEmpty() ? null : archive.classifier;
            snapshotVersion.updated = this.programMetadata.lastUpdated;
            snapshotVersion.value = this.snapshotVersion;
            revisionMetadata.snapshotVersions.add(snapshotVersion);
        }
        File metafile = this.home.toLocalFile(this.revision.metadata(this.home.id));
        metafile.getParentFile().mkdirs();
        IO.store((Object)revisionMetadata.toString(), (File)metafile);
        this.home.release.store(metafile, this.revision.metadata());
        super.updateMetadata();
    }

    @Override
    protected Archive resolve(Archive archive) throws Exception {
        Archive resolved = archive.resolveSnapshot(this.snapshotVersion);
        return resolved;
    }
}

