/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.instruments;

import org.jquantlib.Configuration;
import org.jquantlib.exercise.Exercise;
import org.jquantlib.instruments.NewInstrument;
import org.jquantlib.instruments.Payoff;
import org.jquantlib.pricingengines.PricingEngine;
import org.jquantlib.util.Date;

public abstract class Option
extends NewInstrument {
    protected final Payoff payoff;
    protected final Exercise exercise;
    private final Date evaluationDate;

    public Option(Payoff payoff, Exercise exercise, PricingEngine engine) {
        super(engine);
        this.payoff = payoff;
        this.exercise = exercise;
        this.evaluationDate = Configuration.getSystemConfiguration(null).getGlobalSettings().getEvaluationDate();
        this.evaluationDate.addObserver(this);
    }

    @Override
    public boolean isExpired() {
        return this.exercise.lastDate().le(this.evaluationDate);
    }

    public static enum Type {
        PUT(-1),
        CALL(1);

        private int value;

        private Type(int type) {
            this.value = type;
        }

        public int toInteger() {
            return this.value;
        }
    }
}

