/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.time.calendars;

import org.jquantlib.time.Weekday;
import org.jquantlib.time.WesternCalendar;
import org.jquantlib.time.calendars.DelegateCalendar;
import org.jquantlib.util.Date;
import org.jquantlib.util.Month;

public class Ukraine
extends DelegateCalendar {
    private static final Ukraine USE_CALENDAR = new Ukraine(Market.USE);

    private Ukraine(Market market) {
        UkraineUSECalendar delegate;
        switch (market) {
            case USE: {
                delegate = new UkraineUSECalendar();
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown market");
            }
        }
        this.setDelegate(delegate);
    }

    public static Ukraine getCalendar(Market market) {
        switch (market) {
            case USE: {
                return USE_CALENDAR;
            }
        }
        throw new IllegalArgumentException("unknown market");
    }

    private static final class UkraineUSECalendar
    extends WesternCalendar {
        private UkraineUSECalendar() {
        }

        @Override
        public String getName() {
            return "Ukraine stock-exchange";
        }

        @Override
        public boolean isBusinessDay(Date date) {
            Weekday w = date.getWeekday();
            int d = date.getDayOfMonth();
            int dd = date.getDayOfYear();
            int m = date.getMonth();
            int y = date.getYear();
            int em = this.easterMonday(y);
            return !(this.isWeekend(w) || (d == 1 || (d == 2 || d == 3) && w == Weekday.MONDAY) && m == Month.JANUARY.toInteger() || (d == 7 || (d == 8 || d == 9) && w == Weekday.MONDAY) && m == Month.JANUARY.toInteger() || (d == 8 || (d == 9 || d == 10) && w == Weekday.MONDAY) && m == Month.MARCH.toInteger() || dd == em || dd == em + 49 || (d == 1 || d == 2 || d == 3 && w == Weekday.MONDAY) && m == Month.MAY.toInteger() || (d == 9 || (d == 10 || d == 11) && w == Weekday.MONDAY) && m == Month.MAY.toInteger() || d == 28 && m == Month.JUNE.toInteger()) && (d != 24 || m != Month.AUGUST.toInteger());
        }
    }

    public static enum Market {
        USE;

    }
}

