/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.ds.parser;

import org.eclipse.equinox.ds.model.ComponentDescription;
import org.eclipse.equinox.ds.model.ImplementationDescription;
import org.eclipse.equinox.ds.parser.ComponentElement;
import org.eclipse.equinox.ds.parser.ElementHandler;
import org.eclipse.equinox.ds.parser.ParserHandler;
import org.xml.sax.Attributes;

class ImplementationElement
extends ElementHandler {
    private ComponentElement parent;
    private ImplementationDescription implementation;

    ImplementationElement(ParserHandler root, ComponentElement parent, Attributes attributes) {
        this.root = root;
        this.parent = parent;
        this.implementation = new ImplementationDescription();
        this.processAttributes(attributes);
        if (this.implementation.getClassname() == null) {
            root.logError("implementation class not specified");
        }
    }

    protected void handleAttribute(String name, String value) {
        if (name.equals("class")) {
            this.implementation.setClassname(value);
            return;
        }
        this.root.logError("unrecognized implementation element attribute: " + name);
    }

    public void endElement(String uri, String localName, String qName) {
        ComponentDescription component = this.parent.getComponentDescription();
        if (component.getImplementation() != null) {
            this.root.logError("more than one implementation element");
        }
        component.setImplementation(this.implementation);
        this.root.setHandler(this.parent);
    }

    protected String getElementName() {
        return "implementation";
    }
}

