package aQute.bnd.ant;

import java.io.*;
import java.util.*;

import org.apache.tools.ant.*;

import aQute.lib.osgi.eclipse.*;

public class EclipseTask extends BaseTask {
	String	prefix		= "project.";
	List	prebuild	= new ArrayList();
	File	workspace;

	public void execute() throws BuildException {
		try {
			File project = getProject().getBaseDir();
			EclipseClasspath eclipse = new EclipseClasspath(this, project
					.getParentFile(), project);
			if (report())
				throw new BuildException(
						"Errors during Eclipse Path inspection");

			addProperty(prefix + "classpath",
					join(eclipse.getClasspath(), File.pathSeparator ));
			addProperty(prefix + "bootclasspath",
					join(eclipse.getBootclasspath(), ","));
			addProperty(prefix + "sourcepath", join(eclipse.getSourcepath(),
					 File.pathSeparator ));
			addProperty(prefix + "output", eclipse.getOutput()
					.getAbsolutePath());

			/**
			 * The prebuild is an attribute that is prepended to the dependency
			 * path derived from the Eclipse project
			 */
			List dependents = eclipse.getDependents();
			if (dependents.size() > 0) {
				addProperty(prefix + "buildpath", join(dependents, ","));
			}
		} catch (Exception e) {
			throw new BuildException(
					"Error during parsing Eclipse .classpath files", e);
		}
	}

	protected void addProperty(String n, String v) {
		//System.out.println(" Adding property: " + n + " = " + v);
		if (v != null)
			getProject().setProperty(n, v);
	}

	public void setPrefix(String prefix) {
		this.prefix = prefix;
	}

	public void setPrebuild(String prebuild) {
		StringTokenizer st = new StringTokenizer(prebuild, " ,");
		while (st.hasMoreTokens()) {
			this.prebuild.add(getFile(getProject().getBaseDir(), prebuild));
		}
	}

}
