/*
 * Decompiled with CFR 0.152.
 */
package sun.management;

import com.sun.management.ThreadMXBean;
import java.lang.management.ThreadInfo;
import java.util.Arrays;
import java.util.Objects;
import javax.management.ObjectName;
import sun.management.Util;
import sun.management.VMManagement;
import sun.misc.SharedSecrets;
import sun.misc.WispEngineAccess;

class ThreadImpl
implements ThreadMXBean {
    private static WispEngineAccess WEA = SharedSecrets.getWispEngineAccess();
    private final VMManagement jvm;
    private boolean contentionMonitoringEnabled = false;
    private boolean cpuTimeEnabled;
    private boolean allocatedMemoryEnabled;

    ThreadImpl(VMManagement vMManagement) {
        this.jvm = vMManagement;
        this.cpuTimeEnabled = this.jvm.isThreadCpuTimeEnabled();
        this.allocatedMemoryEnabled = this.jvm.isThreadAllocatedMemoryEnabled();
    }

    @Override
    public int getThreadCount() {
        return this.jvm.getLiveThreadCount();
    }

    @Override
    public int getPeakThreadCount() {
        return this.jvm.getPeakThreadCount();
    }

    @Override
    public long getTotalStartedThreadCount() {
        return this.jvm.getTotalThreadCount();
    }

    @Override
    public int getDaemonThreadCount() {
        return this.jvm.getDaemonThreadCount();
    }

    @Override
    public boolean isThreadContentionMonitoringSupported() {
        return this.jvm.isThreadContentionMonitoringSupported();
    }

    @Override
    public synchronized boolean isThreadContentionMonitoringEnabled() {
        if (!this.isThreadContentionMonitoringSupported()) {
            throw new UnsupportedOperationException("Thread contention monitoring is not supported.");
        }
        return this.contentionMonitoringEnabled;
    }

    @Override
    public boolean isThreadCpuTimeSupported() {
        return this.jvm.isOtherThreadCpuTimeSupported();
    }

    @Override
    public boolean isCurrentThreadCpuTimeSupported() {
        return this.jvm.isCurrentThreadCpuTimeSupported();
    }

    @Override
    public boolean isThreadAllocatedMemorySupported() {
        return this.jvm.isThreadAllocatedMemorySupported();
    }

    @Override
    public boolean isThreadCpuTimeEnabled() {
        if (!this.isThreadCpuTimeSupported() && !this.isCurrentThreadCpuTimeSupported()) {
            throw new UnsupportedOperationException("Thread CPU time measurement is not supported");
        }
        return this.cpuTimeEnabled;
    }

    private void ensureThreadAllocatedMemorySupported() {
        if (!this.isThreadAllocatedMemorySupported()) {
            throw new UnsupportedOperationException("Thread allocated memory measurement is not supported.");
        }
    }

    @Override
    public boolean isThreadAllocatedMemoryEnabled() {
        this.ensureThreadAllocatedMemorySupported();
        return this.allocatedMemoryEnabled;
    }

    @Override
    public long[] getAllThreadIds() {
        Util.checkMonitorAccess();
        Thread[] threadArray = ThreadImpl.getThreads();
        int n = threadArray.length;
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            Thread thread = threadArray[i];
            lArray[i] = thread.getId();
        }
        return lArray;
    }

    @Override
    public ThreadInfo getThreadInfo(long l) {
        long[] lArray = new long[]{l};
        ThreadInfo[] threadInfoArray = this.getThreadInfo(lArray, 0);
        return threadInfoArray[0];
    }

    @Override
    public ThreadInfo getThreadInfo(long l, int n) {
        long[] lArray = new long[]{l};
        ThreadInfo[] threadInfoArray = this.getThreadInfo(lArray, n);
        return threadInfoArray[0];
    }

    @Override
    public ThreadInfo[] getThreadInfo(long[] lArray) {
        return this.getThreadInfo(lArray, 0);
    }

    private void verifyThreadId(long l) {
        if (l <= 0L) {
            throw new IllegalArgumentException("Invalid thread ID parameter: " + l);
        }
    }

    private void verifyThreadIds(long[] lArray) {
        Objects.requireNonNull(lArray);
        for (int i = 0; i < lArray.length; ++i) {
            this.verifyThreadId(lArray[i]);
        }
    }

    @Override
    public ThreadInfo[] getThreadInfo(long[] lArray, int n) {
        this.verifyThreadIds(lArray);
        if (n < 0) {
            throw new IllegalArgumentException("Invalid maxDepth parameter: " + n);
        }
        if (lArray.length == 0) {
            return new ThreadInfo[0];
        }
        Util.checkMonitorAccess();
        ThreadInfo[] threadInfoArray = new ThreadInfo[lArray.length];
        if (n == Integer.MAX_VALUE) {
            ThreadImpl.getThreadInfo1(lArray, -1, threadInfoArray);
        } else {
            ThreadImpl.getThreadInfo1(lArray, n, threadInfoArray);
        }
        return threadInfoArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setThreadContentionMonitoringEnabled(boolean bl) {
        if (!this.isThreadContentionMonitoringSupported()) {
            throw new UnsupportedOperationException("Thread contention monitoring is not supported");
        }
        Util.checkControlAccess();
        ThreadImpl threadImpl = this;
        synchronized (threadImpl) {
            if (this.contentionMonitoringEnabled != bl) {
                if (bl) {
                    ThreadImpl.resetContentionTimes0(0L);
                }
                ThreadImpl.setThreadContentionMonitoringEnabled0(bl);
                this.contentionMonitoringEnabled = bl;
            }
        }
    }

    private boolean verifyCurrentThreadCpuTime() {
        if (!this.isCurrentThreadCpuTimeSupported()) {
            throw new UnsupportedOperationException("Current thread CPU time measurement is not supported.");
        }
        return this.isThreadCpuTimeEnabled();
    }

    @Override
    public long getCurrentThreadCpuTime() {
        if (this.verifyCurrentThreadCpuTime()) {
            if (WEA != null && WEA.isAllThreadAsWisp()) {
                long[] lArray = new long[1];
                WEA.getCpuTime(new long[]{Thread.currentThread().getId()}, lArray);
                return lArray[0];
            }
            return ThreadImpl.getThreadTotalCpuTime0(0L);
        }
        return -1L;
    }

    @Override
    public long getThreadCpuTime(long l) {
        long[] lArray = new long[]{l};
        long[] lArray2 = this.getThreadCpuTime(lArray);
        return lArray2[0];
    }

    private boolean verifyThreadCpuTime(long[] lArray) {
        this.verifyThreadIds(lArray);
        if (!this.isThreadCpuTimeSupported() && !this.isCurrentThreadCpuTimeSupported()) {
            throw new UnsupportedOperationException("Thread CPU time measurement is not supported.");
        }
        if (!this.isThreadCpuTimeSupported()) {
            for (int i = 0; i < lArray.length; ++i) {
                if (lArray[i] == Thread.currentThread().getId()) continue;
                throw new UnsupportedOperationException("Thread CPU time measurement is only supported for the current thread.");
            }
        }
        return this.isThreadCpuTimeEnabled();
    }

    @Override
    public long[] getThreadCpuTime(long[] lArray) {
        boolean bl = this.verifyThreadCpuTime(lArray);
        int n = lArray.length;
        long[] lArray2 = new long[n];
        Arrays.fill(lArray2, -1L);
        if (bl) {
            if (WEA != null && WEA.isAllThreadAsWisp()) {
                WEA.getCpuTime(lArray, lArray2);
            } else if (n == 1) {
                long l = lArray[0];
                if (l == Thread.currentThread().getId()) {
                    l = 0L;
                }
                lArray2[0] = ThreadImpl.getThreadTotalCpuTime0(l);
            } else {
                ThreadImpl.getThreadTotalCpuTime1(lArray, lArray2);
            }
        }
        return lArray2;
    }

    @Override
    public long getCurrentThreadUserTime() {
        boolean bl;
        boolean bl2 = bl = WEA != null && WEA.isAllThreadAsWisp();
        if (!bl && this.verifyCurrentThreadCpuTime()) {
            return ThreadImpl.getThreadUserCpuTime0(0L);
        }
        return -1L;
    }

    @Override
    public long getThreadUserTime(long l) {
        long[] lArray = new long[]{l};
        long[] lArray2 = this.getThreadUserTime(lArray);
        return lArray2[0];
    }

    @Override
    public long[] getThreadUserTime(long[] lArray) {
        boolean bl = WEA != null && WEA.isAllThreadAsWisp();
        boolean bl2 = this.verifyThreadCpuTime(lArray) && !bl;
        int n = lArray.length;
        long[] lArray2 = new long[n];
        Arrays.fill(lArray2, -1L);
        if (bl2) {
            if (n == 1) {
                long l = lArray[0];
                if (l == Thread.currentThread().getId()) {
                    l = 0L;
                }
                lArray2[0] = ThreadImpl.getThreadUserCpuTime0(l);
            } else {
                ThreadImpl.getThreadUserCpuTime1(lArray, lArray2);
            }
        }
        return lArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setThreadCpuTimeEnabled(boolean bl) {
        if (!this.isThreadCpuTimeSupported() && !this.isCurrentThreadCpuTimeSupported()) {
            throw new UnsupportedOperationException("Thread CPU time measurement is not supported");
        }
        Util.checkControlAccess();
        ThreadImpl threadImpl = this;
        synchronized (threadImpl) {
            if (this.cpuTimeEnabled != bl) {
                ThreadImpl.setThreadCpuTimeEnabled0(bl);
                this.cpuTimeEnabled = bl;
            }
        }
    }

    @Override
    public long getCurrentThreadAllocatedBytes() {
        if (this.isThreadAllocatedMemoryEnabled()) {
            return ThreadImpl.getThreadAllocatedMemory0(0L);
        }
        return -1L;
    }

    private boolean verifyThreadAllocatedMemory(long l) {
        this.verifyThreadId(l);
        return this.isThreadAllocatedMemoryEnabled();
    }

    @Override
    public long getThreadAllocatedBytes(long l) {
        boolean bl = this.verifyThreadAllocatedMemory(l);
        if (bl) {
            return ThreadImpl.getThreadAllocatedMemory0(Thread.currentThread().getId() == l ? 0L : l);
        }
        return -1L;
    }

    private boolean verifyThreadAllocatedMemory(long[] lArray) {
        this.verifyThreadIds(lArray);
        return this.isThreadAllocatedMemoryEnabled();
    }

    @Override
    public long[] getThreadAllocatedBytes(long[] lArray) {
        Objects.requireNonNull(lArray);
        if (lArray.length == 1) {
            long l = this.getThreadAllocatedBytes(lArray[0]);
            return new long[]{l};
        }
        boolean bl = this.verifyThreadAllocatedMemory(lArray);
        long[] lArray2 = new long[lArray.length];
        Arrays.fill(lArray2, -1L);
        if (bl) {
            ThreadImpl.getThreadAllocatedMemory1(lArray, lArray2);
        }
        return lArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setThreadAllocatedMemoryEnabled(boolean bl) {
        this.ensureThreadAllocatedMemorySupported();
        Util.checkControlAccess();
        ThreadImpl threadImpl = this;
        synchronized (threadImpl) {
            if (this.allocatedMemoryEnabled != bl) {
                ThreadImpl.setThreadAllocatedMemoryEnabled0(bl);
                this.allocatedMemoryEnabled = bl;
            }
        }
    }

    @Override
    public long[] findMonitorDeadlockedThreads() {
        Util.checkMonitorAccess();
        Thread[] threadArray = ThreadImpl.findMonitorDeadlockedThreads0();
        if (threadArray == null) {
            return null;
        }
        long[] lArray = new long[threadArray.length];
        for (int i = 0; i < threadArray.length; ++i) {
            Thread thread = threadArray[i];
            lArray[i] = thread.getId();
        }
        return lArray;
    }

    @Override
    public long[] findDeadlockedThreads() {
        if (!this.isSynchronizerUsageSupported()) {
            throw new UnsupportedOperationException("Monitoring of Synchronizer Usage is not supported.");
        }
        Util.checkMonitorAccess();
        Thread[] threadArray = ThreadImpl.findDeadlockedThreads0();
        if (threadArray == null) {
            return null;
        }
        long[] lArray = new long[threadArray.length];
        for (int i = 0; i < threadArray.length; ++i) {
            Thread thread = threadArray[i];
            lArray[i] = thread.getId();
        }
        return lArray;
    }

    @Override
    public void resetPeakThreadCount() {
        Util.checkControlAccess();
        ThreadImpl.resetPeakThreadCount0();
    }

    @Override
    public boolean isObjectMonitorUsageSupported() {
        return this.jvm.isObjectMonitorUsageSupported();
    }

    @Override
    public boolean isSynchronizerUsageSupported() {
        return this.jvm.isSynchronizerUsageSupported();
    }

    private void verifyDumpThreads(boolean bl, boolean bl2) {
        if (bl && !this.isObjectMonitorUsageSupported()) {
            throw new UnsupportedOperationException("Monitoring of Object Monitor Usage is not supported.");
        }
        if (bl2 && !this.isSynchronizerUsageSupported()) {
            throw new UnsupportedOperationException("Monitoring of Synchronizer Usage is not supported.");
        }
        Util.checkMonitorAccess();
    }

    @Override
    public ThreadInfo[] getThreadInfo(long[] lArray, boolean bl, boolean bl2) {
        return ThreadImpl.dumpThreads0(lArray, bl, bl2, Integer.MAX_VALUE);
    }

    @Override
    public ThreadInfo[] getThreadInfo(long[] lArray, boolean bl, boolean bl2, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Invalid maxDepth parameter: " + n);
        }
        this.verifyThreadIds(lArray);
        if (lArray.length == 0) {
            return new ThreadInfo[0];
        }
        this.verifyDumpThreads(bl, bl2);
        return ThreadImpl.dumpThreads0(lArray, bl, bl2, n);
    }

    @Override
    public ThreadInfo[] dumpAllThreads(boolean bl, boolean bl2) {
        return this.dumpAllThreads(bl, bl2, Integer.MAX_VALUE);
    }

    @Override
    public ThreadInfo[] dumpAllThreads(boolean bl, boolean bl2, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Invalid maxDepth parameter: " + n);
        }
        this.verifyDumpThreads(bl, bl2);
        return ThreadImpl.dumpThreads0(null, bl, bl2, n);
    }

    private static native Thread[] getThreads();

    private static native void getThreadInfo1(long[] var0, int var1, ThreadInfo[] var2);

    private static native long getThreadTotalCpuTime0(long var0);

    private static native void getThreadTotalCpuTime1(long[] var0, long[] var1);

    private static native long getThreadUserCpuTime0(long var0);

    private static native void getThreadUserCpuTime1(long[] var0, long[] var1);

    private static native long getThreadAllocatedMemory0(long var0);

    private static native void getThreadAllocatedMemory1(long[] var0, long[] var1);

    private static native void setThreadCpuTimeEnabled0(boolean var0);

    private static native void setThreadAllocatedMemoryEnabled0(boolean var0);

    private static native void setThreadContentionMonitoringEnabled0(boolean var0);

    private static native Thread[] findMonitorDeadlockedThreads0();

    private static native Thread[] findDeadlockedThreads0();

    private static native void resetPeakThreadCount0();

    private static native ThreadInfo[] dumpThreads0(long[] var0, boolean var1, boolean var2, int var3);

    private static native void resetContentionTimes0(long var0);

    @Override
    public ObjectName getObjectName() {
        return Util.newObjectName("java.lang:type=Threading");
    }
}

