/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.collect.Iterables;
import com.google.common.truth.Fact;
import java.util.Arrays;

final class Facts {
    private final Iterable<Fact> facts;

    static Facts facts(Fact ... facts) {
        return new Facts(Arrays.asList(facts));
    }

    static Facts facts(Iterable<Fact> facts) {
        return new Facts(facts);
    }

    private Facts(Iterable<Fact> facts) {
        this.facts = facts;
    }

    Iterable<Fact> asIterable() {
        return this.facts;
    }

    Facts and(Facts moreFacts) {
        return new Facts(Iterables.concat(this.facts, moreFacts.asIterable()));
    }

    Facts and(Fact ... moreFacts) {
        return new Facts(Iterables.concat(this.facts, Arrays.asList(moreFacts)));
    }
}

