/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast;

import java.util.ArrayList;
import java.util.List;
import lombok.ast.AbstractNode;
import lombok.ast.AnnotationValue;
import lombok.ast.AstException;
import lombok.ast.AstVisitor;
import lombok.ast.ListAccessor;
import lombok.ast.Node;
import lombok.ast.RawListAccessor;
import lombok.ast.StrictListAccessor;

public class AnnotationValueArray
extends AbstractNode
implements AnnotationValue {
    ListAccessor<AnnotationValue, AnnotationValueArray> values = ListAccessor.of(this, AnnotationValue.class, "AnnotationValueArray");

    public RawListAccessor<AnnotationValue, AnnotationValueArray> rawValues() {
        return this.values.asRaw();
    }

    public StrictListAccessor<AnnotationValue, AnnotationValueArray> astValues() {
        return this.values.asStrict();
    }

    @Override
    public List<Node> getChildren() {
        ArrayList<Node> result = new ArrayList<Node>();
        result.addAll(this.values.backingList());
        return result;
    }

    @Override
    public boolean replaceChild(Node original, Node replacement) throws AstException {
        return this.rawValues().replace(original, replacement);
    }

    @Override
    public boolean detach(Node child) {
        return this.rawValues().remove(child);
    }

    @Override
    public void accept(AstVisitor visitor) {
        if (visitor.visitAnnotationValueArray(this)) {
            return;
        }
        for (AbstractNode child : this.values.asIterable()) {
            child.accept(visitor);
        }
        visitor.afterVisitAnnotationValueArray(this);
        visitor.endVisit(this);
    }

    @Override
    public AnnotationValueArray copy() {
        AnnotationValueArray result = new AnnotationValueArray();
        for (AbstractNode n : this.values.backingList()) {
            result.rawValues().addToEnd(n == null ? null : n.copy());
        }
        return result;
    }
}

