/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.flogger;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.predicates.TypePredicate;
import com.google.errorprone.predicates.TypePredicates;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Type;

@BugPattern(name="FloggerPassedAround", summary="There is no advantage to passing around a logger rather than declaring one in the class that needs it.", linkType=BugPattern.LinkType.CUSTOM, link="https://google.github.io/flogger/best_practice#one-per-class", severity=BugPattern.SeverityLevel.WARNING)
public final class FloggerPassedAround
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    private static final TypePredicate LOGGER_TYPE = TypePredicates.anyOf((TypePredicate[])new TypePredicate[]{TypePredicates.isDescendantOf((String)"com.google.common.flogger.FluentLogger"), TypePredicates.isDescendantOf((String)"com.google.common.flogger.FluentLogger"), TypePredicates.isDescendantOf((String)"com.google.common.flogger.android.AndroidFluentLogger")});

    public Description matchMethod(MethodTree tree, VisitorState state) {
        for (Tree tree2 : tree.getParameters()) {
            Type type = ASTHelpers.getType((Tree)tree2);
            if (type == null || !LOGGER_TYPE.apply(type, state) || this.isSuppressed(tree2)) continue;
            state.reportMatch(this.describeMatch(tree2));
        }
        return Description.NO_MATCH;
    }
}

