/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.inject;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.ChildMultiMatcher;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.InjectMatchers;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;

@BugPattern(name="AssistedInjectAndInjectOnConstructors", summary="@AssistedInject and @Inject should not be used on different constructors in the same class.", severity=BugPattern.SeverityLevel.WARNING)
public class AssistedInjectAndInjectOnConstructors
extends BugChecker
implements BugChecker.ClassTreeMatcher {
    private static final Matcher<ClassTree> HAS_CONSTRUCTORS_WITH_INJECT_AND_ASSISTED_INJECT = Matchers.allOf((Matcher[])new Matcher[]{Matchers.constructor((ChildMultiMatcher.MatchType)ChildMultiMatcher.MatchType.AT_LEAST_ONE, (Matcher)InjectMatchers.hasInjectAnnotation()), Matchers.constructor((ChildMultiMatcher.MatchType)ChildMultiMatcher.MatchType.AT_LEAST_ONE, (Matcher)Matchers.hasAnnotation((String)"com.google.inject.assistedinject.AssistedInject"))});

    public final Description matchClass(ClassTree classTree, VisitorState state) {
        if (HAS_CONSTRUCTORS_WITH_INJECT_AND_ASSISTED_INJECT.matches((Tree)classTree, state)) {
            return this.describeMatch(classTree);
        }
        return Description.NO_MATCH;
    }
}

