# DotNet-Bot GitHub Service Endpoint

## Public project

See the [onboarding documentation](https://github.com/dotnet/arcade/blob/main/Documentation/AzureDevOps/AzureDevOpsOnboarding.md#github-connections)

## Internal project

### Internal VSTS service endpoint

The VSTS service endpoint used for communication with GitHub (handles syncing source, setting up web hooks, etc...) is named `DotNet-Bot GitHub Internal Connection`.  The PAT scopes used for the service endpoint are slightly different than what is used for the Public project.  It should be available for GitHub connections in the [internal project](https://dnceng.visualstudio.com/internal).

Service endpoint name: DotNet-Bot GitHub Internal Connection

### Internal GitHub service account

The `DotNet-Bot GitHub Internal Connection` makes use of the `dotnet-bot` service account.  Repo's using the `DotNet-Bot GitHub Internal Connection` must make `dotnet-bot` a [collaborator](https://help.github.com/articles/permission-levels-for-a-user-account-repository/#collaborator-access-on-a-repository-owned-by-a-user-account) (Admin access) on their GitHub repo.

### Internal personal authentication token

The service endpoint uses a PAT with **`repo`**, `user`, and `admin:repo_hook` permissions generated by the `dotnet-vsts-github-b` account.  You can find the PAT in `EngKeyVault` in the `dotnet-vsts-github-b-user-repo-adminrepohook-pat` secret.
