# Adding a new issue
- If you know which epic the issue is a part of, add the issue to the appropriate epic using the *Epic Issue* field.  This corresponds to the business priority the issue contributes to. **If you don't know which epic the issue belongs to**, do not fill this out&mdash;it will be filed appropriately at triage.
- Don't add it to a *Release* or *Project*.
- Feel free to assign it.  This will be considered a recommend when it's triaged.
- Feel free to assign a milestone if you think you might know.  This will be considered a recommendation when it's triaged.
- If the issue comes from a customer bug report, file it under the **First Responder** label. If the issue is specifically blocking a customer, assign it the **Critical** label as well.

# Security issues
- If the issue has potential security impact, it should *not* be filed on GitHub. Instead, file it under [AzDO (dnceng/internal)](https://dev.azure.com/dnceng/internal/_workitems/) and make sure to triage it against SDL's [Security Bug Bar](https://aka.ms/sdlbugbar).
- Once filed, file a "tracking issue" on GitHub so that we can keep track if it through regular standup work. These issues should be titled something like "AzDO Issue #[Issue Number]" and contain a link to the AzDO issue.
- All discussion of the issue should take place on AzDO or internal email, *not* on GitHub.

# Why we're doing this at all
- We'd like to lower the "pain" of entering and tracking our work.  We've got consistent feedback that GitHub issues are much easier to use than AzDO - although not as feature-rich.  However, we need everyone's participation to make this work...
- There's general consensus that there's better visibility and that things will be generally more accessible.

# Process Notes
- All issues (regardless of type) will be triaged on a regular basis.
- Triage will "fill out" the issue as needed so that it's actionable.
- If triage assigns an issue to a sprint (milestone), this is a recommendation only.  The actual assignments are done during sprint planning.
- During sprint planning, all issues assigned to the sprint being planned will be considered first, and then the backlog considered after that.  This means that if you think something is important, please assign it to the sprint you'd like to see it get done in as a recommend.  (then follow up in person too of course as appropriate)
