// Copyright (c) .NET Foundation. All rights reserved.
// Licensed under the Apache License, Version 2.0. See License.txt in the project root for license information.

using System.Diagnostics.CodeAnalysis;

[assembly: SuppressMessage("Microsoft.Naming", "CA1703:ResourceStringsShouldBeSpelledCorrectly", Scope = "resource", Target = "NuGetConsole.Host.PowerShell.Resources.resources")]
[assembly: SuppressMessage("Microsoft.Design", "CA1020:AvoidNamespacesWithFewTypes", Scope = "namespace", Target = "NuGetConsole.Host")]
[assembly: SuppressMessage("Microsoft.Design", "CA1020:AvoidNamespacesWithFewTypes", Scope = "namespace", Target = "NuGetConsole.Host.PowerShell.Implementation")]
[assembly: SuppressMessage("Microsoft.Usage", "CA1801:ReviewUnusedParameters", MessageId = "isSync", Scope = "member", Target = "NuGetConsole.Host.PowerShell.Implementation.PowerShellHost.#GetPathExpansionsAsyncCore(System.String,System.Boolean,System.Threading.CancellationToken)")]
[assembly: SuppressMessage("Usage", "VSTHRD110:Observe result of async calls", Justification = "https://github.com/NuGet/Home/issues/7674", Scope = "member", Target = "~M:NuGetConsole.Host.PowerShell.Implementation.PowerShellHost.HandleSolutionOpened")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<SimpleExpansion> CommandExpansion.GetExpansionsAsync(string line, int caretIndex, CancellationToken token)', validate parameter 'line' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGetConsole.Host.CommandExpansion.GetExpansionsAsync(System.String,System.Int32,System.Threading.CancellationToken)~System.Threading.Tasks.Task{NuGetConsole.SimpleExpansion}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'object MethodBinder.ChangeType(ParameterInfo parameterInfo, object arg)', validate parameter 'parameterInfo' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGetConsole.Host.MethodBinder.ChangeType(System.Reflection.ParameterInfo,System.Object)~System.Object")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'object MethodBinder.Invoke(MethodInfo method, object target, object[] args)', validate parameter 'method' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGetConsole.Host.MethodBinder.Invoke(System.Reflection.MethodInfo,System.Object,System.Object[])~System.Object")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'bool MethodBinder.TryGetOptionalArg(ParameterInfo paramInfo, out object argValue)', validate parameter 'paramInfo' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGetConsole.Host.MethodBinder.TryGetOptionalArg(System.Reflection.ParameterInfo,System.Object@)~System.Boolean")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'bool MethodBinder.TryInvoke(Type type, string name, object target, object[] args, out object result)', validate parameter 'type' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGetConsole.Host.MethodBinder.TryInvoke(System.Type,System.String,System.Object,System.Object[],System.Object@)~System.Boolean")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'ExecuteInitPs1Async' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGetConsole.Host.PowerShell.Implementation.PowerShellHost.ExecuteInitPs1Async(System.String,NuGet.Packaging.Core.PackageIdentity)~System.Threading.Tasks.Task")]
[assembly: SuppressMessage("Build", "CA1822:Member IsWebSiteAsync does not access instance data and can be marked as static (Shared in VisualBasic)", Justification = "<Pending>", Scope = "member", Target = "~M:NuGetConsole.Host.PowerShell.Implementation.PowerShellHost.IsWebSiteAsync(NuGet.VisualStudio.IVsProjectAdapter)~System.Threading.Tasks.Task{System.Boolean}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'PSObject PSTypeWrapper.CreateInterfaceWrapper(TypeWrapper<PSObject> wrapper, Type interfaceType)', validate parameter 'wrapper' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGetConsole.Host.PowerShell.Implementation.PSTypeWrapper.CreateInterfaceWrapper(NuGetConsole.Host.TypeWrapper{System.Management.Automation.PSObject},System.Type)~System.Management.Automation.PSObject")]
[assembly: SuppressMessage("Build", "CA1822:Member CollectPackagesForPackagesConfigAsync does not access instance data and can be marked as static (Shared in VisualBasic)", Justification = "<Pending>", Scope = "member", Target = "~M:NuGetConsole.Host.PowerShell.InstalledPackageEnumerator.CollectPackagesForPackagesConfigAsync(NuGet.ProjectManagement.NuGetProject,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Tuple{NuGet.Frameworks.NuGetFramework,System.Collections.Generic.IEnumerable{NuGet.Packaging.Core.PackageIdentity}}}")]
[assembly: SuppressMessage("Build", "CA1822:Member OrderPackagesForPackagesConfigAsync does not access instance data and can be marked as static (Shared in VisualBasic)", Justification = "<Pending>", Scope = "member", Target = "~M:NuGetConsole.Host.PowerShell.InstalledPackageEnumerator.OrderPackagesForPackagesConfigAsync(NuGet.PackageManagement.NuGetPackageManager,System.Collections.Generic.IDictionary{NuGet.Frameworks.NuGetFramework,System.Collections.Generic.ISet{NuGet.Packaging.Core.PackageIdentity}},System.Collections.Generic.ISet{NuGet.Packaging.Core.PackageIdentity},System.Collections.Generic.IList{NuGetConsole.Host.PowerShell.InstalledPackageEnumerator.PackageItem},System.Threading.CancellationToken)~System.Threading.Tasks.Task")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'T TypeWrapper<T>.GetInterface(object scriptValue, Type interfaceType, Func<object, TypeWrapper<T>> getTypeWrapper)', validate parameter 'getTypeWrapper' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGetConsole.Host.TypeWrapper`1.GetInterface(System.Object,System.Type,System.Func{System.Object,NuGetConsole.Host.TypeWrapper`1})~`0")]
[assembly: SuppressMessage("Build", "CA1303:Method 'T TypeWrapper<T>.GetInterface(object scriptValue, Type interfaceType, Func<object, TypeWrapper<T>> getTypeWrapper)' passes a literal string as parameter 'message' of a call to 'ArgumentException.ArgumentException(string message, string paramName)'. Retrieve the following string(s) from a resource table instead: \"Invalid argument\".", Justification = "<Pending>", Scope = "member", Target = "~M:NuGetConsole.Host.TypeWrapper`1.GetInterface(System.Object,System.Type,System.Func{System.Object,NuGetConsole.Host.TypeWrapper`1})~`0")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'T TypeWrapper<T>.GetInterface(Type interfaceType)', validate parameter 'interfaceType' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGetConsole.Host.TypeWrapper`1.GetInterface(System.Type)~`0")]
[assembly: SuppressMessage("Usage", "VSTHRD110:Observe result of async calls", Justification = "https://github.com/NuGet/Client.Engineering/issues/1321", Scope = "member", Target = "~M:NuGetConsole.Host.PowerShell.Implementation.PowerShellHost.WriteErrorLine(System.String)")]
[assembly: SuppressMessage("Usage", "VSTHRD110:Observe result of async calls", Justification = "https://github.com/NuGet/Client.Engineering/issues/1321", Scope = "member", Target = "~M:NuGetConsole.Host.PowerShell.Implementation.PowerShellHost.WriteLine(System.String)")]
[assembly: SuppressMessage("Usage", "VSTHRD011:Use AsyncLazy<T>", Justification = "In PMC, this is the only option. It was already working the same way before but it was hidden.", Scope = "member", Target = "~M:NuGetConsole.Host.PowerShell.Implementation.PowerShellHost.#ctor(System.String,NuGet.VisualStudio.IRestoreEvents,NuGetConsole.Host.PowerShell.Implementation.IRunspaceManager)")]
