"""Generated client library for logging version v2."""
# NOTE: This file is autogenerated and should not be edited by hand.
from apitools.base.py import base_api
from googlecloudsdk.third_party.apis.logging.v2 import logging_v2_messages as messages


class LoggingV2(base_api.BaseApiClient):
  """Generated client library for service logging version v2."""

  MESSAGES_MODULE = messages
  BASE_URL = u'https://logging.googleapis.com/'

  _PACKAGE = u'logging'
  _SCOPES = [u'https://www.googleapis.com/auth/cloud-platform', u'https://www.googleapis.com/auth/cloud-platform.read-only', u'https://www.googleapis.com/auth/logging.admin', u'https://www.googleapis.com/auth/logging.read', u'https://www.googleapis.com/auth/logging.write']
  _VERSION = u'v2'
  _CLIENT_ID = '1042881264118.apps.googleusercontent.com'
  _CLIENT_SECRET = 'x_Tw5K8nnjoRAqULM9PFAC2b'
  _USER_AGENT = 'x_Tw5K8nnjoRAqULM9PFAC2b'
  _CLIENT_CLASS_NAME = u'LoggingV2'
  _URL_VERSION = u'v2'
  _API_KEY = None

  def __init__(self, url='', credentials=None,
               get_credentials=True, http=None, model=None,
               log_request=False, log_response=False,
               credentials_args=None, default_global_params=None,
               additional_http_headers=None, response_encoding=None):
    """Create a new logging handle."""
    url = url or self.BASE_URL
    super(LoggingV2, self).__init__(
        url, credentials=credentials,
        get_credentials=get_credentials, http=http, model=model,
        log_request=log_request, log_response=log_response,
        credentials_args=credentials_args,
        default_global_params=default_global_params,
        additional_http_headers=additional_http_headers,
        response_encoding=response_encoding)
    self.billingAccounts_exclusions = self.BillingAccountsExclusionsService(self)
    self.billingAccounts_logs = self.BillingAccountsLogsService(self)
    self.billingAccounts_sinks = self.BillingAccountsSinksService(self)
    self.billingAccounts = self.BillingAccountsService(self)
    self.entries = self.EntriesService(self)
    self.exclusions = self.ExclusionsService(self)
    self.folders_exclusions = self.FoldersExclusionsService(self)
    self.folders_logs = self.FoldersLogsService(self)
    self.folders_sinks = self.FoldersSinksService(self)
    self.folders = self.FoldersService(self)
    self.logs = self.LogsService(self)
    self.monitoredResourceDescriptors = self.MonitoredResourceDescriptorsService(self)
    self.organizations_exclusions = self.OrganizationsExclusionsService(self)
    self.organizations_logs = self.OrganizationsLogsService(self)
    self.organizations_sinks = self.OrganizationsSinksService(self)
    self.organizations = self.OrganizationsService(self)
    self.projects_exclusions = self.ProjectsExclusionsService(self)
    self.projects_logs = self.ProjectsLogsService(self)
    self.projects_metrics = self.ProjectsMetricsService(self)
    self.projects_sinks = self.ProjectsSinksService(self)
    self.projects = self.ProjectsService(self)
    self.sinks = self.SinksService(self)

  class BillingAccountsExclusionsService(base_api.BaseApiService):
    """Service class for the billingAccounts_exclusions resource."""

    _NAME = u'billingAccounts_exclusions'

    def __init__(self, client):
      super(LoggingV2.BillingAccountsExclusionsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new exclusion in a specified parent resource. Only log entries belonging to that resource can be excluded. You can have up to 10 exclusions in a resource.

      Args:
        request: (LoggingBillingAccountsExclusionsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (LogExclusion) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/billingAccounts/{billingAccountsId}/exclusions',
        http_method=u'POST',
        method_id=u'logging.billingAccounts.exclusions.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[],
        relative_path=u'v2/{+parent}/exclusions',
        request_field=u'logExclusion',
        request_type_name=u'LoggingBillingAccountsExclusionsCreateRequest',
        response_type_name=u'LogExclusion',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes an exclusion.

      Args:
        request: (LoggingBillingAccountsExclusionsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/billingAccounts/{billingAccountsId}/exclusions/{exclusionsId}',
        http_method=u'DELETE',
        method_id=u'logging.billingAccounts.exclusions.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v2/{+name}',
        request_field='',
        request_type_name=u'LoggingBillingAccountsExclusionsDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets the description of an exclusion.

      Args:
        request: (LoggingBillingAccountsExclusionsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (LogExclusion) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/billingAccounts/{billingAccountsId}/exclusions/{exclusionsId}',
        http_method=u'GET',
        method_id=u'logging.billingAccounts.exclusions.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v2/{+name}',
        request_field='',
        request_type_name=u'LoggingBillingAccountsExclusionsGetRequest',
        response_type_name=u'LogExclusion',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists all the exclusions in a parent resource.

      Args:
        request: (LoggingBillingAccountsExclusionsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListExclusionsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/billingAccounts/{billingAccountsId}/exclusions',
        http_method=u'GET',
        method_id=u'logging.billingAccounts.exclusions.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'pageSize', u'pageToken'],
        relative_path=u'v2/{+parent}/exclusions',
        request_field='',
        request_type_name=u'LoggingBillingAccountsExclusionsListRequest',
        response_type_name=u'ListExclusionsResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Changes one or more properties of an existing exclusion.

      Args:
        request: (LoggingBillingAccountsExclusionsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (LogExclusion) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/billingAccounts/{billingAccountsId}/exclusions/{exclusionsId}',
        http_method=u'PATCH',
        method_id=u'logging.billingAccounts.exclusions.patch',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'updateMask'],
        relative_path=u'v2/{+name}',
        request_field=u'logExclusion',
        request_type_name=u'LoggingBillingAccountsExclusionsPatchRequest',
        response_type_name=u'LogExclusion',
        supports_download=False,
    )

  class BillingAccountsLogsService(base_api.BaseApiService):
    """Service class for the billingAccounts_logs resource."""

    _NAME = u'billingAccounts_logs'

    def __init__(self, client):
      super(LoggingV2.BillingAccountsLogsService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Deletes all the log entries in a log. The log reappears if it receives new entries. Log entries written shortly before the delete operation might not be deleted.

      Args:
        request: (LoggingBillingAccountsLogsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/billingAccounts/{billingAccountsId}/logs/{logsId}',
        http_method=u'DELETE',
        method_id=u'logging.billingAccounts.logs.delete',
        ordered_params=[u'logName'],
        path_params=[u'logName'],
        query_params=[],
        relative_path=u'v2/{+logName}',
        request_field='',
        request_type_name=u'LoggingBillingAccountsLogsDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists the logs in projects, organizations, folders, or billing accounts. Only logs that have entries are listed.

      Args:
        request: (LoggingBillingAccountsLogsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListLogsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/billingAccounts/{billingAccountsId}/logs',
        http_method=u'GET',
        method_id=u'logging.billingAccounts.logs.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'pageSize', u'pageToken'],
        relative_path=u'v2/{+parent}/logs',
        request_field='',
        request_type_name=u'LoggingBillingAccountsLogsListRequest',
        response_type_name=u'ListLogsResponse',
        supports_download=False,
    )

  class BillingAccountsSinksService(base_api.BaseApiService):
    """Service class for the billingAccounts_sinks resource."""

    _NAME = u'billingAccounts_sinks'

    def __init__(self, client):
      super(LoggingV2.BillingAccountsSinksService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a sink that exports specified log entries to a destination. The export of newly-ingested log entries begins immediately, unless the sink's writer_identity is not permitted to write to the destination. A sink can export log entries only from the resource owning the sink.

      Args:
        request: (LoggingBillingAccountsSinksCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (LogSink) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/billingAccounts/{billingAccountsId}/sinks',
        http_method=u'POST',
        method_id=u'logging.billingAccounts.sinks.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'uniqueWriterIdentity'],
        relative_path=u'v2/{+parent}/sinks',
        request_field=u'logSink',
        request_type_name=u'LoggingBillingAccountsSinksCreateRequest',
        response_type_name=u'LogSink',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a sink. If the sink has a unique writer_identity, then that service account is also deleted.

      Args:
        request: (LoggingBillingAccountsSinksDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/billingAccounts/{billingAccountsId}/sinks/{sinksId}',
        http_method=u'DELETE',
        method_id=u'logging.billingAccounts.sinks.delete',
        ordered_params=[u'sinkName'],
        path_params=[u'sinkName'],
        query_params=[],
        relative_path=u'v2/{+sinkName}',
        request_field='',
        request_type_name=u'LoggingBillingAccountsSinksDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets a sink.

      Args:
        request: (LoggingBillingAccountsSinksGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (LogSink) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/billingAccounts/{billingAccountsId}/sinks/{sinksId}',
        http_method=u'GET',
        method_id=u'logging.billingAccounts.sinks.get',
        ordered_params=[u'sinkName'],
        path_params=[u'sinkName'],
        query_params=[],
        relative_path=u'v2/{+sinkName}',
        request_field='',
        request_type_name=u'LoggingBillingAccountsSinksGetRequest',
        response_type_name=u'LogSink',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists sinks.

      Args:
        request: (LoggingBillingAccountsSinksListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListSinksResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/billingAccounts/{billingAccountsId}/sinks',
        http_method=u'GET',
        method_id=u'logging.billingAccounts.sinks.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'pageSize', u'pageToken'],
        relative_path=u'v2/{+parent}/sinks',
        request_field='',
        request_type_name=u'LoggingBillingAccountsSinksListRequest',
        response_type_name=u'ListSinksResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates a sink. This method replaces the following fields in the existing sink with values from the new sink: destination, and filter. The updated sink might also have a new writer_identity; see the unique_writer_identity field.

      Args:
        request: (LoggingBillingAccountsSinksPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (LogSink) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/billingAccounts/{billingAccountsId}/sinks/{sinksId}',
        http_method=u'PATCH',
        method_id=u'logging.billingAccounts.sinks.patch',
        ordered_params=[u'sinkName'],
        path_params=[u'sinkName'],
        query_params=[u'uniqueWriterIdentity', u'updateMask'],
        relative_path=u'v2/{+sinkName}',
        request_field=u'logSink',
        request_type_name=u'LoggingBillingAccountsSinksPatchRequest',
        response_type_name=u'LogSink',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      r"""Updates a sink. This method replaces the following fields in the existing sink with values from the new sink: destination, and filter. The updated sink might also have a new writer_identity; see the unique_writer_identity field.

      Args:
        request: (LoggingBillingAccountsSinksUpdateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (LogSink) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(
          config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/billingAccounts/{billingAccountsId}/sinks/{sinksId}',
        http_method=u'PUT',
        method_id=u'logging.billingAccounts.sinks.update',
        ordered_params=[u'sinkName'],
        path_params=[u'sinkName'],
        query_params=[u'uniqueWriterIdentity', u'updateMask'],
        relative_path=u'v2/{+sinkName}',
        request_field=u'logSink',
        request_type_name=u'LoggingBillingAccountsSinksUpdateRequest',
        response_type_name=u'LogSink',
        supports_download=False,
    )

  class BillingAccountsService(base_api.BaseApiService):
    """Service class for the billingAccounts resource."""

    _NAME = u'billingAccounts'

    def __init__(self, client):
      super(LoggingV2.BillingAccountsService, self).__init__(client)
      self._upload_configs = {
          }

  class EntriesService(base_api.BaseApiService):
    """Service class for the entries resource."""

    _NAME = u'entries'

    def __init__(self, client):
      super(LoggingV2.EntriesService, self).__init__(client)
      self._upload_configs = {
          }

    def List(self, request, global_params=None):
      r"""Lists log entries. Use this method to retrieve log entries from Stackdriver Logging. For ways to export log entries, see Exporting Logs.

      Args:
        request: (ListLogEntriesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListLogEntriesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'logging.entries.list',
        ordered_params=[],
        path_params=[],
        query_params=[],
        relative_path=u'v2/entries:list',
        request_field='<request>',
        request_type_name=u'ListLogEntriesRequest',
        response_type_name=u'ListLogEntriesResponse',
        supports_download=False,
    )

    def Write(self, request, global_params=None):
      r"""Writes log entries to Stackdriver Logging. This API method is the only way to send log entries to Stackdriver Logging. This method is used, directly or indirectly, by the Stackdriver Logging agent (fluentd) and all logging libraries configured to use Stackdriver Logging. A single request may contain log entries for a maximum of 1000 different resources (projects, organizations, billing accounts or folders).

      Args:
        request: (WriteLogEntriesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (WriteLogEntriesResponse) The response message.
      """
      config = self.GetMethodConfig('Write')
      return self._RunMethod(
          config, request, global_params=global_params)

    Write.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'logging.entries.write',
        ordered_params=[],
        path_params=[],
        query_params=[],
        relative_path=u'v2/entries:write',
        request_field='<request>',
        request_type_name=u'WriteLogEntriesRequest',
        response_type_name=u'WriteLogEntriesResponse',
        supports_download=False,
    )

  class ExclusionsService(base_api.BaseApiService):
    """Service class for the exclusions resource."""

    _NAME = u'exclusions'

    def __init__(self, client):
      super(LoggingV2.ExclusionsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new exclusion in a specified parent resource. Only log entries belonging to that resource can be excluded. You can have up to 10 exclusions in a resource.

      Args:
        request: (LoggingExclusionsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (LogExclusion) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/{v2Id}/{v2Id1}/exclusions',
        http_method=u'POST',
        method_id=u'logging.exclusions.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[],
        relative_path=u'v2/{+parent}/exclusions',
        request_field=u'logExclusion',
        request_type_name=u'LoggingExclusionsCreateRequest',
        response_type_name=u'LogExclusion',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes an exclusion.

      Args:
        request: (LoggingExclusionsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/{v2Id}/{v2Id1}/exclusions/{exclusionsId}',
        http_method=u'DELETE',
        method_id=u'logging.exclusions.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v2/{+name}',
        request_field='',
        request_type_name=u'LoggingExclusionsDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets the description of an exclusion.

      Args:
        request: (LoggingExclusionsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (LogExclusion) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/{v2Id}/{v2Id1}/exclusions/{exclusionsId}',
        http_method=u'GET',
        method_id=u'logging.exclusions.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v2/{+name}',
        request_field='',
        request_type_name=u'LoggingExclusionsGetRequest',
        response_type_name=u'LogExclusion',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists all the exclusions in a parent resource.

      Args:
        request: (LoggingExclusionsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListExclusionsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/{v2Id}/{v2Id1}/exclusions',
        http_method=u'GET',
        method_id=u'logging.exclusions.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'pageSize', u'pageToken'],
        relative_path=u'v2/{+parent}/exclusions',
        request_field='',
        request_type_name=u'LoggingExclusionsListRequest',
        response_type_name=u'ListExclusionsResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Changes one or more properties of an existing exclusion.

      Args:
        request: (LoggingExclusionsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (LogExclusion) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/{v2Id}/{v2Id1}/exclusions/{exclusionsId}',
        http_method=u'PATCH',
        method_id=u'logging.exclusions.patch',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'updateMask'],
        relative_path=u'v2/{+name}',
        request_field=u'logExclusion',
        request_type_name=u'LoggingExclusionsPatchRequest',
        response_type_name=u'LogExclusion',
        supports_download=False,
    )

  class FoldersExclusionsService(base_api.BaseApiService):
    """Service class for the folders_exclusions resource."""

    _NAME = u'folders_exclusions'

    def __init__(self, client):
      super(LoggingV2.FoldersExclusionsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new exclusion in a specified parent resource. Only log entries belonging to that resource can be excluded. You can have up to 10 exclusions in a resource.

      Args:
        request: (LoggingFoldersExclusionsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (LogExclusion) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/folders/{foldersId}/exclusions',
        http_method=u'POST',
        method_id=u'logging.folders.exclusions.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[],
        relative_path=u'v2/{+parent}/exclusions',
        request_field=u'logExclusion',
        request_type_name=u'LoggingFoldersExclusionsCreateRequest',
        response_type_name=u'LogExclusion',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes an exclusion.

      Args:
        request: (LoggingFoldersExclusionsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/folders/{foldersId}/exclusions/{exclusionsId}',
        http_method=u'DELETE',
        method_id=u'logging.folders.exclusions.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v2/{+name}',
        request_field='',
        request_type_name=u'LoggingFoldersExclusionsDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets the description of an exclusion.

      Args:
        request: (LoggingFoldersExclusionsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (LogExclusion) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/folders/{foldersId}/exclusions/{exclusionsId}',
        http_method=u'GET',
        method_id=u'logging.folders.exclusions.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v2/{+name}',
        request_field='',
        request_type_name=u'LoggingFoldersExclusionsGetRequest',
        response_type_name=u'LogExclusion',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists all the exclusions in a parent resource.

      Args:
        request: (LoggingFoldersExclusionsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListExclusionsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/folders/{foldersId}/exclusions',
        http_method=u'GET',
        method_id=u'logging.folders.exclusions.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'pageSize', u'pageToken'],
        relative_path=u'v2/{+parent}/exclusions',
        request_field='',
        request_type_name=u'LoggingFoldersExclusionsListRequest',
        response_type_name=u'ListExclusionsResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Changes one or more properties of an existing exclusion.

      Args:
        request: (LoggingFoldersExclusionsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (LogExclusion) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/folders/{foldersId}/exclusions/{exclusionsId}',
        http_method=u'PATCH',
        method_id=u'logging.folders.exclusions.patch',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'updateMask'],
        relative_path=u'v2/{+name}',
        request_field=u'logExclusion',
        request_type_name=u'LoggingFoldersExclusionsPatchRequest',
        response_type_name=u'LogExclusion',
        supports_download=False,
    )

  class FoldersLogsService(base_api.BaseApiService):
    """Service class for the folders_logs resource."""

    _NAME = u'folders_logs'

    def __init__(self, client):
      super(LoggingV2.FoldersLogsService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Deletes all the log entries in a log. The log reappears if it receives new entries. Log entries written shortly before the delete operation might not be deleted.

      Args:
        request: (LoggingFoldersLogsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/folders/{foldersId}/logs/{logsId}',
        http_method=u'DELETE',
        method_id=u'logging.folders.logs.delete',
        ordered_params=[u'logName'],
        path_params=[u'logName'],
        query_params=[],
        relative_path=u'v2/{+logName}',
        request_field='',
        request_type_name=u'LoggingFoldersLogsDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists the logs in projects, organizations, folders, or billing accounts. Only logs that have entries are listed.

      Args:
        request: (LoggingFoldersLogsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListLogsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/folders/{foldersId}/logs',
        http_method=u'GET',
        method_id=u'logging.folders.logs.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'pageSize', u'pageToken'],
        relative_path=u'v2/{+parent}/logs',
        request_field='',
        request_type_name=u'LoggingFoldersLogsListRequest',
        response_type_name=u'ListLogsResponse',
        supports_download=False,
    )

  class FoldersSinksService(base_api.BaseApiService):
    """Service class for the folders_sinks resource."""

    _NAME = u'folders_sinks'

    def __init__(self, client):
      super(LoggingV2.FoldersSinksService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a sink that exports specified log entries to a destination. The export of newly-ingested log entries begins immediately, unless the sink's writer_identity is not permitted to write to the destination. A sink can export log entries only from the resource owning the sink.

      Args:
        request: (LoggingFoldersSinksCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (LogSink) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/folders/{foldersId}/sinks',
        http_method=u'POST',
        method_id=u'logging.folders.sinks.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'uniqueWriterIdentity'],
        relative_path=u'v2/{+parent}/sinks',
        request_field=u'logSink',
        request_type_name=u'LoggingFoldersSinksCreateRequest',
        response_type_name=u'LogSink',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a sink. If the sink has a unique writer_identity, then that service account is also deleted.

      Args:
        request: (LoggingFoldersSinksDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/folders/{foldersId}/sinks/{sinksId}',
        http_method=u'DELETE',
        method_id=u'logging.folders.sinks.delete',
        ordered_params=[u'sinkName'],
        path_params=[u'sinkName'],
        query_params=[],
        relative_path=u'v2/{+sinkName}',
        request_field='',
        request_type_name=u'LoggingFoldersSinksDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets a sink.

      Args:
        request: (LoggingFoldersSinksGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (LogSink) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/folders/{foldersId}/sinks/{sinksId}',
        http_method=u'GET',
        method_id=u'logging.folders.sinks.get',
        ordered_params=[u'sinkName'],
        path_params=[u'sinkName'],
        query_params=[],
        relative_path=u'v2/{+sinkName}',
        request_field='',
        request_type_name=u'LoggingFoldersSinksGetRequest',
        response_type_name=u'LogSink',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists sinks.

      Args:
        request: (LoggingFoldersSinksListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListSinksResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/folders/{foldersId}/sinks',
        http_method=u'GET',
        method_id=u'logging.folders.sinks.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'pageSize', u'pageToken'],
        relative_path=u'v2/{+parent}/sinks',
        request_field='',
        request_type_name=u'LoggingFoldersSinksListRequest',
        response_type_name=u'ListSinksResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates a sink. This method replaces the following fields in the existing sink with values from the new sink: destination, and filter. The updated sink might also have a new writer_identity; see the unique_writer_identity field.

      Args:
        request: (LoggingFoldersSinksPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (LogSink) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/folders/{foldersId}/sinks/{sinksId}',
        http_method=u'PATCH',
        method_id=u'logging.folders.sinks.patch',
        ordered_params=[u'sinkName'],
        path_params=[u'sinkName'],
        query_params=[u'uniqueWriterIdentity', u'updateMask'],
        relative_path=u'v2/{+sinkName}',
        request_field=u'logSink',
        request_type_name=u'LoggingFoldersSinksPatchRequest',
        response_type_name=u'LogSink',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      r"""Updates a sink. This method replaces the following fields in the existing sink with values from the new sink: destination, and filter. The updated sink might also have a new writer_identity; see the unique_writer_identity field.

      Args:
        request: (LoggingFoldersSinksUpdateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (LogSink) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(
          config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/folders/{foldersId}/sinks/{sinksId}',
        http_method=u'PUT',
        method_id=u'logging.folders.sinks.update',
        ordered_params=[u'sinkName'],
        path_params=[u'sinkName'],
        query_params=[u'uniqueWriterIdentity', u'updateMask'],
        relative_path=u'v2/{+sinkName}',
        request_field=u'logSink',
        request_type_name=u'LoggingFoldersSinksUpdateRequest',
        response_type_name=u'LogSink',
        supports_download=False,
    )

  class FoldersService(base_api.BaseApiService):
    """Service class for the folders resource."""

    _NAME = u'folders'

    def __init__(self, client):
      super(LoggingV2.FoldersService, self).__init__(client)
      self._upload_configs = {
          }

  class LogsService(base_api.BaseApiService):
    """Service class for the logs resource."""

    _NAME = u'logs'

    def __init__(self, client):
      super(LoggingV2.LogsService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Deletes all the log entries in a log. The log reappears if it receives new entries. Log entries written shortly before the delete operation might not be deleted.

      Args:
        request: (LoggingLogsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/{v2Id}/{v2Id1}/logs/{logsId}',
        http_method=u'DELETE',
        method_id=u'logging.logs.delete',
        ordered_params=[u'logName'],
        path_params=[u'logName'],
        query_params=[],
        relative_path=u'v2/{+logName}',
        request_field='',
        request_type_name=u'LoggingLogsDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists the logs in projects, organizations, folders, or billing accounts. Only logs that have entries are listed.

      Args:
        request: (LoggingLogsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListLogsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/{v2Id}/{v2Id1}/logs',
        http_method=u'GET',
        method_id=u'logging.logs.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'pageSize', u'pageToken'],
        relative_path=u'v2/{+parent}/logs',
        request_field='',
        request_type_name=u'LoggingLogsListRequest',
        response_type_name=u'ListLogsResponse',
        supports_download=False,
    )

  class MonitoredResourceDescriptorsService(base_api.BaseApiService):
    """Service class for the monitoredResourceDescriptors resource."""

    _NAME = u'monitoredResourceDescriptors'

    def __init__(self, client):
      super(LoggingV2.MonitoredResourceDescriptorsService, self).__init__(client)
      self._upload_configs = {
          }

    def List(self, request, global_params=None):
      r"""Lists the descriptors for monitored resource types used by Stackdriver Logging.

      Args:
        request: (LoggingMonitoredResourceDescriptorsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListMonitoredResourceDescriptorsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'logging.monitoredResourceDescriptors.list',
        ordered_params=[],
        path_params=[],
        query_params=[u'pageSize', u'pageToken'],
        relative_path=u'v2/monitoredResourceDescriptors',
        request_field='',
        request_type_name=u'LoggingMonitoredResourceDescriptorsListRequest',
        response_type_name=u'ListMonitoredResourceDescriptorsResponse',
        supports_download=False,
    )

  class OrganizationsExclusionsService(base_api.BaseApiService):
    """Service class for the organizations_exclusions resource."""

    _NAME = u'organizations_exclusions'

    def __init__(self, client):
      super(LoggingV2.OrganizationsExclusionsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new exclusion in a specified parent resource. Only log entries belonging to that resource can be excluded. You can have up to 10 exclusions in a resource.

      Args:
        request: (LoggingOrganizationsExclusionsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (LogExclusion) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/organizations/{organizationsId}/exclusions',
        http_method=u'POST',
        method_id=u'logging.organizations.exclusions.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[],
        relative_path=u'v2/{+parent}/exclusions',
        request_field=u'logExclusion',
        request_type_name=u'LoggingOrganizationsExclusionsCreateRequest',
        response_type_name=u'LogExclusion',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes an exclusion.

      Args:
        request: (LoggingOrganizationsExclusionsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/organizations/{organizationsId}/exclusions/{exclusionsId}',
        http_method=u'DELETE',
        method_id=u'logging.organizations.exclusions.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v2/{+name}',
        request_field='',
        request_type_name=u'LoggingOrganizationsExclusionsDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets the description of an exclusion.

      Args:
        request: (LoggingOrganizationsExclusionsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (LogExclusion) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/organizations/{organizationsId}/exclusions/{exclusionsId}',
        http_method=u'GET',
        method_id=u'logging.organizations.exclusions.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v2/{+name}',
        request_field='',
        request_type_name=u'LoggingOrganizationsExclusionsGetRequest',
        response_type_name=u'LogExclusion',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists all the exclusions in a parent resource.

      Args:
        request: (LoggingOrganizationsExclusionsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListExclusionsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/organizations/{organizationsId}/exclusions',
        http_method=u'GET',
        method_id=u'logging.organizations.exclusions.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'pageSize', u'pageToken'],
        relative_path=u'v2/{+parent}/exclusions',
        request_field='',
        request_type_name=u'LoggingOrganizationsExclusionsListRequest',
        response_type_name=u'ListExclusionsResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Changes one or more properties of an existing exclusion.

      Args:
        request: (LoggingOrganizationsExclusionsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (LogExclusion) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/organizations/{organizationsId}/exclusions/{exclusionsId}',
        http_method=u'PATCH',
        method_id=u'logging.organizations.exclusions.patch',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'updateMask'],
        relative_path=u'v2/{+name}',
        request_field=u'logExclusion',
        request_type_name=u'LoggingOrganizationsExclusionsPatchRequest',
        response_type_name=u'LogExclusion',
        supports_download=False,
    )

  class OrganizationsLogsService(base_api.BaseApiService):
    """Service class for the organizations_logs resource."""

    _NAME = u'organizations_logs'

    def __init__(self, client):
      super(LoggingV2.OrganizationsLogsService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Deletes all the log entries in a log. The log reappears if it receives new entries. Log entries written shortly before the delete operation might not be deleted.

      Args:
        request: (LoggingOrganizationsLogsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/organizations/{organizationsId}/logs/{logsId}',
        http_method=u'DELETE',
        method_id=u'logging.organizations.logs.delete',
        ordered_params=[u'logName'],
        path_params=[u'logName'],
        query_params=[],
        relative_path=u'v2/{+logName}',
        request_field='',
        request_type_name=u'LoggingOrganizationsLogsDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists the logs in projects, organizations, folders, or billing accounts. Only logs that have entries are listed.

      Args:
        request: (LoggingOrganizationsLogsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListLogsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/organizations/{organizationsId}/logs',
        http_method=u'GET',
        method_id=u'logging.organizations.logs.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'pageSize', u'pageToken'],
        relative_path=u'v2/{+parent}/logs',
        request_field='',
        request_type_name=u'LoggingOrganizationsLogsListRequest',
        response_type_name=u'ListLogsResponse',
        supports_download=False,
    )

  class OrganizationsSinksService(base_api.BaseApiService):
    """Service class for the organizations_sinks resource."""

    _NAME = u'organizations_sinks'

    def __init__(self, client):
      super(LoggingV2.OrganizationsSinksService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a sink that exports specified log entries to a destination. The export of newly-ingested log entries begins immediately, unless the sink's writer_identity is not permitted to write to the destination. A sink can export log entries only from the resource owning the sink.

      Args:
        request: (LoggingOrganizationsSinksCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (LogSink) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/organizations/{organizationsId}/sinks',
        http_method=u'POST',
        method_id=u'logging.organizations.sinks.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'uniqueWriterIdentity'],
        relative_path=u'v2/{+parent}/sinks',
        request_field=u'logSink',
        request_type_name=u'LoggingOrganizationsSinksCreateRequest',
        response_type_name=u'LogSink',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a sink. If the sink has a unique writer_identity, then that service account is also deleted.

      Args:
        request: (LoggingOrganizationsSinksDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/organizations/{organizationsId}/sinks/{sinksId}',
        http_method=u'DELETE',
        method_id=u'logging.organizations.sinks.delete',
        ordered_params=[u'sinkName'],
        path_params=[u'sinkName'],
        query_params=[],
        relative_path=u'v2/{+sinkName}',
        request_field='',
        request_type_name=u'LoggingOrganizationsSinksDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets a sink.

      Args:
        request: (LoggingOrganizationsSinksGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (LogSink) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/organizations/{organizationsId}/sinks/{sinksId}',
        http_method=u'GET',
        method_id=u'logging.organizations.sinks.get',
        ordered_params=[u'sinkName'],
        path_params=[u'sinkName'],
        query_params=[],
        relative_path=u'v2/{+sinkName}',
        request_field='',
        request_type_name=u'LoggingOrganizationsSinksGetRequest',
        response_type_name=u'LogSink',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists sinks.

      Args:
        request: (LoggingOrganizationsSinksListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListSinksResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/organizations/{organizationsId}/sinks',
        http_method=u'GET',
        method_id=u'logging.organizations.sinks.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'pageSize', u'pageToken'],
        relative_path=u'v2/{+parent}/sinks',
        request_field='',
        request_type_name=u'LoggingOrganizationsSinksListRequest',
        response_type_name=u'ListSinksResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates a sink. This method replaces the following fields in the existing sink with values from the new sink: destination, and filter. The updated sink might also have a new writer_identity; see the unique_writer_identity field.

      Args:
        request: (LoggingOrganizationsSinksPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (LogSink) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/organizations/{organizationsId}/sinks/{sinksId}',
        http_method=u'PATCH',
        method_id=u'logging.organizations.sinks.patch',
        ordered_params=[u'sinkName'],
        path_params=[u'sinkName'],
        query_params=[u'uniqueWriterIdentity', u'updateMask'],
        relative_path=u'v2/{+sinkName}',
        request_field=u'logSink',
        request_type_name=u'LoggingOrganizationsSinksPatchRequest',
        response_type_name=u'LogSink',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      r"""Updates a sink. This method replaces the following fields in the existing sink with values from the new sink: destination, and filter. The updated sink might also have a new writer_identity; see the unique_writer_identity field.

      Args:
        request: (LoggingOrganizationsSinksUpdateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (LogSink) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(
          config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/organizations/{organizationsId}/sinks/{sinksId}',
        http_method=u'PUT',
        method_id=u'logging.organizations.sinks.update',
        ordered_params=[u'sinkName'],
        path_params=[u'sinkName'],
        query_params=[u'uniqueWriterIdentity', u'updateMask'],
        relative_path=u'v2/{+sinkName}',
        request_field=u'logSink',
        request_type_name=u'LoggingOrganizationsSinksUpdateRequest',
        response_type_name=u'LogSink',
        supports_download=False,
    )

  class OrganizationsService(base_api.BaseApiService):
    """Service class for the organizations resource."""

    _NAME = u'organizations'

    def __init__(self, client):
      super(LoggingV2.OrganizationsService, self).__init__(client)
      self._upload_configs = {
          }

  class ProjectsExclusionsService(base_api.BaseApiService):
    """Service class for the projects_exclusions resource."""

    _NAME = u'projects_exclusions'

    def __init__(self, client):
      super(LoggingV2.ProjectsExclusionsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new exclusion in a specified parent resource. Only log entries belonging to that resource can be excluded. You can have up to 10 exclusions in a resource.

      Args:
        request: (LoggingProjectsExclusionsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (LogExclusion) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/exclusions',
        http_method=u'POST',
        method_id=u'logging.projects.exclusions.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[],
        relative_path=u'v2/{+parent}/exclusions',
        request_field=u'logExclusion',
        request_type_name=u'LoggingProjectsExclusionsCreateRequest',
        response_type_name=u'LogExclusion',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes an exclusion.

      Args:
        request: (LoggingProjectsExclusionsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/exclusions/{exclusionsId}',
        http_method=u'DELETE',
        method_id=u'logging.projects.exclusions.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v2/{+name}',
        request_field='',
        request_type_name=u'LoggingProjectsExclusionsDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets the description of an exclusion.

      Args:
        request: (LoggingProjectsExclusionsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (LogExclusion) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/exclusions/{exclusionsId}',
        http_method=u'GET',
        method_id=u'logging.projects.exclusions.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v2/{+name}',
        request_field='',
        request_type_name=u'LoggingProjectsExclusionsGetRequest',
        response_type_name=u'LogExclusion',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists all the exclusions in a parent resource.

      Args:
        request: (LoggingProjectsExclusionsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListExclusionsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/exclusions',
        http_method=u'GET',
        method_id=u'logging.projects.exclusions.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'pageSize', u'pageToken'],
        relative_path=u'v2/{+parent}/exclusions',
        request_field='',
        request_type_name=u'LoggingProjectsExclusionsListRequest',
        response_type_name=u'ListExclusionsResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Changes one or more properties of an existing exclusion.

      Args:
        request: (LoggingProjectsExclusionsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (LogExclusion) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/exclusions/{exclusionsId}',
        http_method=u'PATCH',
        method_id=u'logging.projects.exclusions.patch',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'updateMask'],
        relative_path=u'v2/{+name}',
        request_field=u'logExclusion',
        request_type_name=u'LoggingProjectsExclusionsPatchRequest',
        response_type_name=u'LogExclusion',
        supports_download=False,
    )

  class ProjectsLogsService(base_api.BaseApiService):
    """Service class for the projects_logs resource."""

    _NAME = u'projects_logs'

    def __init__(self, client):
      super(LoggingV2.ProjectsLogsService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Deletes all the log entries in a log. The log reappears if it receives new entries. Log entries written shortly before the delete operation might not be deleted.

      Args:
        request: (LoggingProjectsLogsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/logs/{logsId}',
        http_method=u'DELETE',
        method_id=u'logging.projects.logs.delete',
        ordered_params=[u'logName'],
        path_params=[u'logName'],
        query_params=[],
        relative_path=u'v2/{+logName}',
        request_field='',
        request_type_name=u'LoggingProjectsLogsDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists the logs in projects, organizations, folders, or billing accounts. Only logs that have entries are listed.

      Args:
        request: (LoggingProjectsLogsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListLogsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/logs',
        http_method=u'GET',
        method_id=u'logging.projects.logs.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'pageSize', u'pageToken'],
        relative_path=u'v2/{+parent}/logs',
        request_field='',
        request_type_name=u'LoggingProjectsLogsListRequest',
        response_type_name=u'ListLogsResponse',
        supports_download=False,
    )

  class ProjectsMetricsService(base_api.BaseApiService):
    """Service class for the projects_metrics resource."""

    _NAME = u'projects_metrics'

    def __init__(self, client):
      super(LoggingV2.ProjectsMetricsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a logs-based metric.

      Args:
        request: (LoggingProjectsMetricsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (LogMetric) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/metrics',
        http_method=u'POST',
        method_id=u'logging.projects.metrics.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[],
        relative_path=u'v2/{+parent}/metrics',
        request_field=u'logMetric',
        request_type_name=u'LoggingProjectsMetricsCreateRequest',
        response_type_name=u'LogMetric',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a logs-based metric.

      Args:
        request: (LoggingProjectsMetricsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/metrics/{metricsId}',
        http_method=u'DELETE',
        method_id=u'logging.projects.metrics.delete',
        ordered_params=[u'metricName'],
        path_params=[u'metricName'],
        query_params=[],
        relative_path=u'v2/{+metricName}',
        request_field='',
        request_type_name=u'LoggingProjectsMetricsDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets a logs-based metric.

      Args:
        request: (LoggingProjectsMetricsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (LogMetric) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/metrics/{metricsId}',
        http_method=u'GET',
        method_id=u'logging.projects.metrics.get',
        ordered_params=[u'metricName'],
        path_params=[u'metricName'],
        query_params=[],
        relative_path=u'v2/{+metricName}',
        request_field='',
        request_type_name=u'LoggingProjectsMetricsGetRequest',
        response_type_name=u'LogMetric',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists logs-based metrics.

      Args:
        request: (LoggingProjectsMetricsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListLogMetricsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/metrics',
        http_method=u'GET',
        method_id=u'logging.projects.metrics.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'pageSize', u'pageToken'],
        relative_path=u'v2/{+parent}/metrics',
        request_field='',
        request_type_name=u'LoggingProjectsMetricsListRequest',
        response_type_name=u'ListLogMetricsResponse',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      r"""Creates or updates a logs-based metric.

      Args:
        request: (LoggingProjectsMetricsUpdateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (LogMetric) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(
          config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/metrics/{metricsId}',
        http_method=u'PUT',
        method_id=u'logging.projects.metrics.update',
        ordered_params=[u'metricName'],
        path_params=[u'metricName'],
        query_params=[],
        relative_path=u'v2/{+metricName}',
        request_field=u'logMetric',
        request_type_name=u'LoggingProjectsMetricsUpdateRequest',
        response_type_name=u'LogMetric',
        supports_download=False,
    )

  class ProjectsSinksService(base_api.BaseApiService):
    """Service class for the projects_sinks resource."""

    _NAME = u'projects_sinks'

    def __init__(self, client):
      super(LoggingV2.ProjectsSinksService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a sink that exports specified log entries to a destination. The export of newly-ingested log entries begins immediately, unless the sink's writer_identity is not permitted to write to the destination. A sink can export log entries only from the resource owning the sink.

      Args:
        request: (LoggingProjectsSinksCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (LogSink) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/sinks',
        http_method=u'POST',
        method_id=u'logging.projects.sinks.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'uniqueWriterIdentity'],
        relative_path=u'v2/{+parent}/sinks',
        request_field=u'logSink',
        request_type_name=u'LoggingProjectsSinksCreateRequest',
        response_type_name=u'LogSink',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a sink. If the sink has a unique writer_identity, then that service account is also deleted.

      Args:
        request: (LoggingProjectsSinksDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/sinks/{sinksId}',
        http_method=u'DELETE',
        method_id=u'logging.projects.sinks.delete',
        ordered_params=[u'sinkName'],
        path_params=[u'sinkName'],
        query_params=[],
        relative_path=u'v2/{+sinkName}',
        request_field='',
        request_type_name=u'LoggingProjectsSinksDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets a sink.

      Args:
        request: (LoggingProjectsSinksGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (LogSink) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/sinks/{sinksId}',
        http_method=u'GET',
        method_id=u'logging.projects.sinks.get',
        ordered_params=[u'sinkName'],
        path_params=[u'sinkName'],
        query_params=[],
        relative_path=u'v2/{+sinkName}',
        request_field='',
        request_type_name=u'LoggingProjectsSinksGetRequest',
        response_type_name=u'LogSink',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists sinks.

      Args:
        request: (LoggingProjectsSinksListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListSinksResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/sinks',
        http_method=u'GET',
        method_id=u'logging.projects.sinks.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'pageSize', u'pageToken'],
        relative_path=u'v2/{+parent}/sinks',
        request_field='',
        request_type_name=u'LoggingProjectsSinksListRequest',
        response_type_name=u'ListSinksResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates a sink. This method replaces the following fields in the existing sink with values from the new sink: destination, and filter. The updated sink might also have a new writer_identity; see the unique_writer_identity field.

      Args:
        request: (LoggingProjectsSinksPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (LogSink) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/sinks/{sinksId}',
        http_method=u'PATCH',
        method_id=u'logging.projects.sinks.patch',
        ordered_params=[u'sinkName'],
        path_params=[u'sinkName'],
        query_params=[u'uniqueWriterIdentity', u'updateMask'],
        relative_path=u'v2/{+sinkName}',
        request_field=u'logSink',
        request_type_name=u'LoggingProjectsSinksPatchRequest',
        response_type_name=u'LogSink',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      r"""Updates a sink. This method replaces the following fields in the existing sink with values from the new sink: destination, and filter. The updated sink might also have a new writer_identity; see the unique_writer_identity field.

      Args:
        request: (LoggingProjectsSinksUpdateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (LogSink) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(
          config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/sinks/{sinksId}',
        http_method=u'PUT',
        method_id=u'logging.projects.sinks.update',
        ordered_params=[u'sinkName'],
        path_params=[u'sinkName'],
        query_params=[u'uniqueWriterIdentity', u'updateMask'],
        relative_path=u'v2/{+sinkName}',
        request_field=u'logSink',
        request_type_name=u'LoggingProjectsSinksUpdateRequest',
        response_type_name=u'LogSink',
        supports_download=False,
    )

  class ProjectsService(base_api.BaseApiService):
    """Service class for the projects resource."""

    _NAME = u'projects'

    def __init__(self, client):
      super(LoggingV2.ProjectsService, self).__init__(client)
      self._upload_configs = {
          }

  class SinksService(base_api.BaseApiService):
    """Service class for the sinks resource."""

    _NAME = u'sinks'

    def __init__(self, client):
      super(LoggingV2.SinksService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a sink that exports specified log entries to a destination. The export of newly-ingested log entries begins immediately, unless the sink's writer_identity is not permitted to write to the destination. A sink can export log entries only from the resource owning the sink.

      Args:
        request: (LoggingSinksCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (LogSink) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/{v2Id}/{v2Id1}/sinks',
        http_method=u'POST',
        method_id=u'logging.sinks.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'uniqueWriterIdentity'],
        relative_path=u'v2/{+parent}/sinks',
        request_field=u'logSink',
        request_type_name=u'LoggingSinksCreateRequest',
        response_type_name=u'LogSink',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a sink. If the sink has a unique writer_identity, then that service account is also deleted.

      Args:
        request: (LoggingSinksDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/{v2Id}/{v2Id1}/sinks/{sinksId}',
        http_method=u'DELETE',
        method_id=u'logging.sinks.delete',
        ordered_params=[u'sinkName'],
        path_params=[u'sinkName'],
        query_params=[],
        relative_path=u'v2/{+sinkName}',
        request_field='',
        request_type_name=u'LoggingSinksDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets a sink.

      Args:
        request: (LoggingSinksGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (LogSink) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/{v2Id}/{v2Id1}/sinks/{sinksId}',
        http_method=u'GET',
        method_id=u'logging.sinks.get',
        ordered_params=[u'sinkName'],
        path_params=[u'sinkName'],
        query_params=[],
        relative_path=u'v2/{+sinkName}',
        request_field='',
        request_type_name=u'LoggingSinksGetRequest',
        response_type_name=u'LogSink',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists sinks.

      Args:
        request: (LoggingSinksListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListSinksResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/{v2Id}/{v2Id1}/sinks',
        http_method=u'GET',
        method_id=u'logging.sinks.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'pageSize', u'pageToken'],
        relative_path=u'v2/{+parent}/sinks',
        request_field='',
        request_type_name=u'LoggingSinksListRequest',
        response_type_name=u'ListSinksResponse',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      r"""Updates a sink. This method replaces the following fields in the existing sink with values from the new sink: destination, and filter. The updated sink might also have a new writer_identity; see the unique_writer_identity field.

      Args:
        request: (LoggingSinksUpdateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (LogSink) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(
          config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/{v2Id}/{v2Id1}/sinks/{sinksId}',
        http_method=u'PUT',
        method_id=u'logging.sinks.update',
        ordered_params=[u'sinkName'],
        path_params=[u'sinkName'],
        query_params=[u'uniqueWriterIdentity', u'updateMask'],
        relative_path=u'v2/{+sinkName}',
        request_field=u'logSink',
        request_type_name=u'LoggingSinksUpdateRequest',
        response_type_name=u'LogSink',
        supports_download=False,
    )
