---
name: '@grafana/ui component request'
about: Suggest a component for the @grafana/ui package
labels: 'area/grafana/ui'
---

<!-- 
By using this template you will make it easier for us to make sure that documentation and implementation stays up to date for every component in @grafana/ui

Thank you!
-->

**Why is this component needed**:
<!-- Explain your use case -->
___
 - [ ] Is/could it be used in more than one place in Grafana?

**Where is/could it be used?**:

___
- [ ] Post screenshots possible.
- [ ] It has a single use case.
- [ ] It is/could be used in multiple places.

**Implementation** (Checklist meant for the person implementing the component)

- [ ] Component has a story in Storybook.
- [ ] Props and naming follows [our style guide](https://github.com/grafana/grafana/blob/main/contribute/style-guides/frontend.md).
- [ ] It is extendable (rest props are spread, styles with className work, and so on).
- [ ] Uses [theme for spacing, colors, and so on](https://github.com/grafana/grafana/blob/main/contribute/style-guides/themes.md).
- [ ] Works with both light and dark theme.

**Documentation**

- [ ] Properties are documented.
- [ ] Use cases are described.
- [ ] Code examples for the different use cases.
- [ ] Dos and don'ts.
- [ ] Styling guidelines, specific color usage (if applicable).
