import { initializeGlobalAgent } from './agent';
import { initializeAPI } from './api';
import { initializeInstrumentations } from './instrumentations';
import { initializeMetas } from './metas';
import { initializeTransports } from './transports';
import { globalObject } from './utils';
export function initializeAgent(config) {
  var metas = initializeMetas(config);
  var transports = initializeTransports(config);
  var api = initializeAPI(transports, metas);
  var agent = initializeGlobalAgent({
    config: config,
    metas: metas,
    transports: transports,
    api: api,
  });
  if (!agent.config.preventGlobalExposure) {
    Object.defineProperty(globalObject, agent.config.globalObjectKey, {
      value: agent,
    });
  }
  initializeInstrumentations(agent.config);
  return agent;
}
//# sourceMappingURL=initialize.js.map
