"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFloat16 = getFloat16;
exports.setFloat16 = setFloat16;

var _converter = require("./_converter.cjs");

var _is = require("./_util/is.cjs");

/**
 * returns an unsigned 16-bit float at the specified byte offset from the start of the DataView.
 *
 * @param {DataView} dataView
 * @param {number} byteOffset
 * @param {[boolean]} opts
 * @returns {number}
 */
function getFloat16(dataView, byteOffset, ...opts) {
  if (!(0, _is.isDataView)(dataView)) {
    throw new TypeError("First argument to getFloat16 must be a DataView");
  }

  return (0, _converter.convertToNumber)(dataView.getUint16(byteOffset, ...opts));
}
/**
 * stores an unsigned 16-bit float value at the specified byte offset from the start of the DataView.
 *
 * @param {DataView} dataView
 * @param {number} byteOffset
 * @param {number} value
 * @param {[boolean]} opts
 */


function setFloat16(dataView, byteOffset, value, ...opts) {
  if (!(0, _is.isDataView)(dataView)) {
    throw new TypeError("First argument to setFloat16 must be a DataView");
  }

  dataView.setUint16(byteOffset, (0, _converter.roundToFloat16Bits)(value), ...opts);
}