/*
Copyright (c) Daybrush
name: react-simple-compat
license: MIT
author: Daybrush
repository: git+https://github.com/daybrush/react-simple-compat.git
version: 1.2.3
*/
import { diff } from '@egjs/list-differ';
import { isArray, isString, isNumber, isUndefined, decamelize } from '@daybrush/utils';

/*! *****************************************************************************
Copyright (c) Microsoft Corporation. All rights reserved.
Licensed under the Apache License, Version 2.0 (the "License"); you may not use
this file except in compliance with the License. You may obtain a copy of the
License at http://www.apache.org/licenses/LICENSE-2.0

THIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED
WARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,
MERCHANTABLITY OR NON-INFRINGEMENT.

See the Apache Version 2.0 License for specific language governing permissions
and limitations under the License.
***************************************************************************** */

/* global Reflect, Promise */
var extendStatics = function (d, b) {
  extendStatics = Object.setPrototypeOf || {
    __proto__: []
  } instanceof Array && function (d, b) {
    d.__proto__ = b;
  } || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
  };

  return extendStatics(d, b);
};

function __extends(d, b) {
  extendStatics(d, b);

  function __() {
    this.constructor = d;
  }

  d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
}
var __assign = function () {
  __assign = Object.assign || function __assign(t) {
    for (var s, i = 1, n = arguments.length; i < n; i++) {
      s = arguments[i];

      for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p)) t[p] = s[p];
    }

    return t;
  };

  return __assign.apply(this, arguments);
};
function __rest(s, e) {
  var t = {};

  for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0) t[p] = s[p];

  if (s != null && typeof Object.getOwnPropertySymbols === "function") for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
    if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i])) t[p[i]] = s[p[i]];
  }
  return t;
}
function __spreadArrays() {
  for (var s = 0, i = 0, il = arguments.length; i < il; i++) s += arguments[i].length;

  for (var r = Array(s), k = 0, i = 0; i < il; i++) for (var a = arguments[i], j = 0, jl = a.length; j < jl; j++, k++) r[k] = a[j];

  return r;
}

function isDiff(a, b) {
  if (a === b) {
    return false;
  }

  for (var i in a) {
    if (!(i in b)) {
      return true;
    }
  }

  for (var i in b) {
    if (a[i] !== b[i]) {
      return true;
    }
  }

  return false;
}

function diffObject(a, b) {
  var keys1 = Object.keys(a);
  var keys2 = Object.keys(b);
  var result = diff(keys1, keys2, function (key) {
    return key;
  });
  var added = {};
  var removed = {};
  var changed = {};
  result.added.forEach(function (index) {
    var name = keys2[index];
    added[name] = b[name];
  });
  result.removed.forEach(function (index) {
    var name = keys1[index];
    removed[name] = a[name];
  });
  result.maintained.forEach(function (_a) {
    var index = _a[0];
    var name = keys1[index];
    var values = [a[name], b[name]];

    if (a[name] !== b[name]) {
      changed[name] = values;
    }
  });
  return {
    added: added,
    removed: removed,
    changed: changed
  };
}

function executeHooks(hooks) {
  hooks.forEach(function (hook) {
    hook();
  });
}

function fillKeys(keys) {
  var index = 0;
  return keys.map(function (key) {
    return key == null ? "$compat" + ++index : "" + key;
  });
}

function createProvider(el, key, index, container) {
  if (isString(el) || isNumber(el)) {
    return new TextProvider("text_" + el, key, index, container, null, {});
  }

  var providerClass = typeof el.type === "string" ? ElementProvider : el.type.prototype.render ? ComponentProvider : FunctionProvider;
  return new providerClass(el.type, key, index, container, el.ref, el.props);
}

function flat(arr) {
  var arr2 = [];
  arr.forEach(function (el) {
    arr2 = arr2.concat(isArray(el) ? flat(el) : el);
  });
  return arr2;
}

function getAttributes(props) {
  var className = props.className,
      otherProps = __rest(props, ["className"]);

  if (className != null) {
    otherProps.class = className;
  }

  delete otherProps.style;
  delete otherProps.children;
  return otherProps;
}

function fillProps(props, defaultProps) {
  if (!defaultProps) {
    return props;
  }

  for (var name in defaultProps) {
    if (isUndefined(props[name])) {
      props[name] = defaultProps[name];
    }
  }

  return props;
}

function createElement(type, props) {
  var children = [];

  for (var _i = 2; _i < arguments.length; _i++) {
    children[_i - 2] = arguments[_i];
  }

  var _a = props || {},
      key = _a.key,
      ref = _a.ref,
      otherProps = __rest(_a, ["key", "ref"]);

  return {
    type: type,
    key: key,
    ref: ref,
    props: __assign(__assign({}, otherProps), {
      children: flat(children).filter(function (child) {
        return child != null && child !== false;
      })
    })
  };
}

var Provider =
/*#__PURE__*/
function () {
  function Provider(type, key, index, container, ref, props) {
    if (props === void 0) {
      props = {};
    }

    this.type = type;
    this.key = key;
    this.index = index;
    this.container = container;
    this.ref = ref;
    this.props = props;
    this._providers = [];
  }

  var __proto = Provider.prototype;

  __proto._should = function (nextProps, nextState) {
    return true;
  };

  __proto._update = function (hooks, nextElement, nextState, isForceUpdate) {
    if (this.base && !isString(nextElement) && !isForceUpdate && !this._should(nextElement.props, nextState)) {
      return false;
    }

    this.original = nextElement;

    this._setState(nextState); // render


    var prevProps = this.props;

    if (!isString(nextElement)) {
      this.props = nextElement.props;
      this.ref = nextElement.ref;
    }

    this._render(hooks, this.base ? prevProps : {}, nextState);

    return true;
  };

  __proto._mounted = function () {
    var ref = this.ref;
    ref && ref(this.base);
  };

  __proto._setState = function (nextstate) {
    return;
  };

  __proto._updated = function () {
    var ref = this.ref;
    ref && ref(this.base);
  };

  __proto._destroy = function () {
    var ref = this.ref;
    ref && ref(null);
  };

  return Provider;
}();

function diffAttributes(attrs1, attrs2, el) {
  var _a = diffObject(attrs1, attrs2),
      added = _a.added,
      removed = _a.removed,
      changed = _a.changed;

  for (var name in added) {
    el.setAttribute(name, added[name]);
  }

  for (var name in changed) {
    el.setAttribute(name, changed[name][1]);
  }

  for (var name in removed) {
    el.removeAttribute(name);
  }
}

function diffEvents(events1, events2, provier) {
  var _a = diffObject(events1, events2),
      added = _a.added,
      removed = _a.removed,
      changed = _a.changed;

  for (var name in removed) {
    provier.removeEventListener(name);
  }

  for (var name in added) {
    provier.addEventListener(name, added[name]);
  }

  for (var name in changed) {
    provier.removeEventListener(name);
    provier.addEventListener(name, changed[name][1]);
  }

  for (var name in removed) {
    provier.removeEventListener(name);
  }
}

function diffStyle(style1, style2, el) {
  var style = el.style;

  var _a = diffObject(style1, style2),
      added = _a.added,
      removed = _a.removed,
      changed = _a.changed;

  for (var beforeName in added) {
    var name = decamelize(beforeName, "-");

    if (style.setProperty) {
      style.setProperty(name, added[beforeName]);
    } else {
      style[name] = added[beforeName];
    }
  }

  for (var beforeName in changed) {
    var name = decamelize(beforeName, "-");

    if (style.setProperty) {
      style.setProperty(name, changed[beforeName][1]);
    } else {
      style[name] = changed[beforeName][1];
    }
  }

  for (var beforeName in removed) {
    var name = decamelize(beforeName, "-");

    if (style.removeProperty) {
      style.removeProperty(name);
    } else {
      style[name] = "";
    }
  }
}

function splitProps(props) {
  var attributes = {};
  var events = {};

  for (var name in props) {
    if (name.indexOf("on") === 0) {
      events[name.replace("on", "").toLowerCase()] = props[name];
    } else {
      attributes[name] = props[name];
    }
  }

  return {
    attributes: attributes,
    events: events
  };
}

var TextProvider =
/*#__PURE__*/
function (_super) {
  __extends(TextProvider, _super);

  function TextProvider() {
    return _super !== null && _super.apply(this, arguments) || this;
  }

  var __proto = TextProvider.prototype;

  __proto._render = function (hooks) {
    var _this = this;

    var isMount = !this.base;

    if (isMount) {
      this.base = document.createTextNode(this.type.replace("text_", ""));
    }

    hooks.push(function () {
      if (isMount) {
        _this._mounted();
      } else {
        _this._updated();
      }
    });
    return true;
  };

  __proto._unmount = function () {
    this.base.parentNode.removeChild(this.base);
  };

  return TextProvider;
}(Provider);

var ElementProvider =
/*#__PURE__*/
function (_super) {
  __extends(ElementProvider, _super);

  function ElementProvider() {
    var _this = _super !== null && _super.apply(this, arguments) || this;

    _this.events = {};
    _this._isSVG = false;
    return _this;
  }

  var __proto = ElementProvider.prototype;

  __proto.addEventListener = function (name, callback) {
    var events = this.events;

    events[name] = function (e) {
      e.nativeEvent = e;
      callback(e);
    };

    this.base.addEventListener(name, events[name]);
  };

  __proto.removeEventListener = function (name) {
    var events = this.events;
    this.base.removeEventListener(name, events[name]);
    delete events[name];
  };

  __proto._should = function (nextProps) {
    return isDiff(this.props, nextProps);
  };

  __proto._render = function (hooks, prevProps) {
    var _this = this;

    var isMount = !this.base;

    if (isMount) {
      var isSVG = this._hasSVG();

      this._isSVG = isSVG;
      var element = this.props.portalContainer;

      if (!element) {
        var type = this.type;

        if (isSVG) {
          element = document.createElementNS("http://www.w3.org/2000/svg", type);
        } else {
          element = document.createElement(type);
        }
      }

      this.base = element;
    }

    renderProviders(this, this._providers, this.props.children, hooks, null);
    var base = this.base;

    var _a = splitProps(prevProps),
        prevAttributes = _a.attributes,
        prevEvents = _a.events;

    var _b = splitProps(this.props),
        nextAttributes = _b.attributes,
        nextEvents = _b.events;

    diffAttributes(getAttributes(prevAttributes), getAttributes(nextAttributes), base);
    diffEvents(prevEvents, nextEvents, this);
    diffStyle(prevProps.style || {}, this.props.style || {}, base);
    hooks.push(function () {
      if (isMount) {
        _this._mounted();
      } else {
        _this._updated();
      }
    });
    return true;
  };

  __proto._unmount = function () {
    var events = this.events;
    var base = this.base;

    for (var name in events) {
      base.removeEventListener(name, events[name]);
    }

    this._providers.forEach(function (provider) {
      provider._unmount();
    });

    this.events = {};

    if (!this.props.portalContainer) {
      base.parentNode.removeChild(base);
    }
  };

  __proto._hasSVG = function () {
    if (this._isSVG || this.type === "svg") {
      return true;
    }

    var containerNode = findContainerNode(this.container);
    return containerNode && "ownerSVGElement" in containerNode;
  };

  return ElementProvider;
}(Provider);

function findContainerNode(provider) {
  if (!provider) {
    return null;
  }

  var base = provider.base;

  if (base instanceof Node) {
    return base;
  }

  return findContainerNode(provider.container);
}

function findDOMNode(comp) {
  if (!comp) {
    return null;
  }

  if (comp instanceof Node) {
    return comp;
  }

  var providers = comp.$_provider._providers;

  if (!providers.length) {
    return null;
  }

  return findDOMNode(providers[0].base);
}

var FunctionProvider =
/*#__PURE__*/
function (_super) {
  __extends(FunctionProvider, _super);

  function FunctionProvider() {
    return _super !== null && _super.apply(this, arguments) || this;
  }

  var __proto = FunctionProvider.prototype;

  __proto._render = function (hooks) {
    var template = this.type(this.props);
    renderProviders(this, this._providers, template ? [template] : [], hooks);
    return true;
  };

  __proto._unmount = function () {
    this._providers.forEach(function (provider) {
      provider._unmount();
    });
  };

  return FunctionProvider;
}(Provider);

var ContainerProvider =
/*#__PURE__*/
function (_super) {
  __extends(ContainerProvider, _super);

  function ContainerProvider(base) {
    var _this = _super.call(this, "container", "container", 0, null) || this;

    _this.base = base;
    return _this;
  }

  var __proto = ContainerProvider.prototype;

  __proto._render = function () {
    return true;
  };

  __proto._unmount = function () {
    return;
  };

  return ContainerProvider;
}(Provider);

var ComponentProvider =
/*#__PURE__*/
function (_super) {
  __extends(ComponentProvider, _super);

  function ComponentProvider(type, key, index, container, ref, props) {
    if (props === void 0) {
      props = {};
    }

    return _super.call(this, type, key, index, container, ref, fillProps(props, type.defaultProps)) || this;
  }

  var __proto = ComponentProvider.prototype;

  __proto._should = function (nextProps, nextState) {
    return this.base.shouldComponentUpdate(fillProps(nextProps, this.type.defaultProps), nextState || this.base.state);
  };

  __proto._render = function (hooks, prevProps) {
    var _this = this;

    this.props = fillProps(this.props, this.type.defaultProps);
    var isMount = !this.base;

    if (isMount) {
      this.base = new this.type(this.props);
      this.base.$_provider = this;
    } else {
      this.base.props = this.props;
    }

    var base = this.base;
    var prevState = base.state;
    var template = base.render();

    if (template && template.props && !template.props.children.length) {
      template.props.children = this.props.children;
    }

    renderProviders(this, this._providers, template ? [template] : [], hooks);
    hooks.push(function () {
      if (isMount) {
        _this._mounted();

        base.componentDidMount();
      } else {
        _this._updated();

        base.componentDidUpdate(prevProps, prevState);
      }
    });
  };

  __proto._setState = function (nextState) {
    var base = this.base;

    if (!base || !nextState) {
      return;
    }

    base.state = nextState;
  };

  __proto._unmount = function () {
    this._providers.forEach(function (provider) {
      provider._unmount();
    });

    clearTimeout(this.base.$_timer);
    this.base.componentWillUnmount();
  };

  return ComponentProvider;
}(Provider);

var Component =
/*#__PURE__*/
function () {
  function Component(props) {
    if (props === void 0) {
      props = {};
    }

    this.props = props;
    this.state = {};
    this.$_timer = 0;
    this.$_state = {};
  }

  var __proto = Component.prototype;

  __proto.shouldComponentUpdate = function (props, state) {
    return true;
  };

  __proto.render = function () {
    return null;
  };

  __proto.setState = function (state, callback, isForceUpdate) {
    var _this = this;

    if (!this.$_timer) {
      this.$_state = {};
    }

    clearTimeout(this.$_timer);
    this.$_timer = 0;
    this.$_state = __assign(__assign({}, this.$_state), state);

    if (!isForceUpdate) {
      this.$_timer = setTimeout(function () {
        _this.$_timer = 0;

        _this.$_setState(callback, isForceUpdate);
      });
    } else {
      this.$_setState(callback, isForceUpdate);
    }

    return;
  };

  __proto.forceUpdate = function (callback) {
    this.setState({}, callback, true);
  };

  __proto.componentDidMount = function () {};

  __proto.componentDidUpdate = function (prevProps, prevState) {};

  __proto.componentWillUnmount = function () {};

  __proto.$_setState = function (callback, isForceUpdate) {
    var hooks = [];
    var provider = this.$_provider;
    var isUpdate = renderProviders(provider.container, [provider], [provider.original], hooks, __assign(__assign({}, this.state), this.$_state), isForceUpdate);

    if (isUpdate) {
      if (callback) {
        hooks.push(callback);
      }

      executeHooks(hooks);
    }
  };

  return Component;
}();

var PureComponent =
/*#__PURE__*/
function (_super) {
  __extends(PureComponent, _super);

  function PureComponent() {
    return _super !== null && _super.apply(this, arguments) || this;
  }

  var __proto = PureComponent.prototype;

  __proto.shouldComponentUpdate = function (props, state) {
    return isDiff(this.props, props) || isDiff(this.state, state);
  };

  return PureComponent;
}(Component);

var _Portal =
/*#__PURE__*/
function (_super) {
  __extends(_Portal, _super);

  function _Portal() {
    return _super !== null && _super.apply(this, arguments) || this;
  }

  var __proto = _Portal.prototype;

  __proto.componentDidMount = function () {
    var _a = this.props,
        element = _a.element,
        container = _a.container;
    this._portalProvider = new ContainerProvider(container);
    renderProvider(element, container, this._portalProvider);
  };

  __proto.componentDidUpdate = function () {
    var _a = this.props,
        element = _a.element,
        container = _a.container;
    renderProvider(element, container, this._portalProvider);
  };

  __proto.componentWillUnmount = function () {
    var container = this.props.container;
    renderProvider(null, container, this._portalProvider);
    this._portalProvider = null;
  };

  return _Portal;
}(PureComponent);

function updateProvider(provider, children, nextState) {
  var hooks = [];
  renderProviders(provider, provider._providers, children, hooks, nextState);
  executeHooks(hooks);
}

function getNextSibiling(provider, childProvider) {
  var childProviders = provider._providers;
  var length = childProviders.length;

  for (var i = childProvider.index + 1; i < length; ++i) {
    var el = findDOMNode(childProviders[i].base);

    if (el) {
      return el;
    }
  }

  return null;
}

function diffProviders(containerProvider, providers, children) {
  var childrenKeys = children.map(function (p) {
    return isString(p) ? null : p.key;
  });
  var keys1 = fillKeys(providers.map(function (p) {
    return p.key;
  }));
  var keys2 = fillKeys(childrenKeys);
  var result = diff(keys1, keys2, function (key) {
    return key;
  });
  result.removed.forEach(function (index) {
    providers.splice(index, 1)[0]._unmount();
  });
  result.ordered.forEach(function (_a) {
    var from = _a[0],
        to = _a[1];
    var childrenProvider = providers.splice(from, 1)[0];
    providers.splice(to, 0, childrenProvider);
    var el = findDOMNode(childrenProvider.base);
    var next = findDOMNode(providers[to + 1] && providers[to + 1].base);

    if (el) {
      el.parentNode.insertBefore(el, next);
    }
  });
  result.added.forEach(function (index) {
    providers.splice(index, 0, createProvider(children[index], childrenKeys[index], index, containerProvider));
  });
  var changed = result.maintained.filter(function (_a) {
    var _ = _a[0],
        to = _a[1];
    var el = children[to];
    var childProvider = providers[to];
    var type = isString(el) ? "text_" + el : el.type;

    if (type !== childProvider.type) {
      childProvider._unmount();

      providers.splice(to, 1, createProvider(el, childrenKeys[to], to, containerProvider));
      return true;
    }

    childProvider.index = to;
    return false;
  });
  return __spreadArrays(result.added, changed.map(function (_a) {
    var _ = _a[0],
        to = _a[1];
    return to;
  }));
}

function renderProviders(containerProvider, providers, children, updatedHooks, nextState, isForceUpdate) {
  var result = diffProviders(containerProvider, providers, children);
  var updated = providers.filter(function (childProvider, i) {
    return childProvider._update(updatedHooks, children[i], nextState, isForceUpdate);
  });
  var containerNode = findContainerNode(containerProvider);

  if (containerNode) {
    result.reverse().forEach(function (index) {
      var childProvider = providers[index];
      var el = findDOMNode(childProvider.base);

      if (!el) {
        return;
      }

      if (containerNode !== el && !el.parentNode) {
        var nextElement = getNextSibiling(containerProvider, childProvider);
        containerNode.insertBefore(el, nextElement);
      }
    });
  }

  return updated.length > 0;
}

function renderProvider(element, container, provider) {
  if (provider === void 0) {
    provider = container.__REACT_COMPAT__;
  }

  var isProvider = !!provider;

  if (!provider) {
    provider = new ContainerProvider(container);
  }

  updateProvider(provider, element ? [element] : []);

  if (!isProvider) {
    container.__REACT_COMPAT__ = provider;
  }

  return provider;
}

function render(element, container, callback) {
  var provider = container.__REACT_COMPAT__;

  if (element && !provider) {
    container.innerHTML = "";
  }

  renderProvider(element, container, provider);
  callback && callback();
}
function createPortal(el, container) {
  return createElement(_Portal, {
    element: el,
    container: container
  });
}
var version = "simple-1.1.0";

export { Component, PureComponent, createElement, createPortal, findDOMNode, render, version };
//# sourceMappingURL=compat.esm.js.map
