"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.upgradeESM = void 0;
const tsquery_1 = require("@phenomnomnominal/tsquery");
const typescript_1 = require("typescript");
const utils_1 = require("./utils");
// export const foo
const EXPORT_TEST_QUERY = 'VariableStatement:has(ExportKeyword) VariableDeclaration';
// export default {}
const EXPORT_TESTS_QUERY = 'ExportAssignment:has(PropertyAssignment)';
function upgradeESM(originalSourceFile, configPath) {
    let upgraded = (0, utils_1.reparse)(tsquery_1.tsquery.map(originalSourceFile, EXPORT_TESTS_QUERY, (configExports) => {
        const { expression, decorators, modifiers, isExportEquals } = configExports;
        if ((0, typescript_1.isObjectLiteralExpression)(expression)) {
            return typescript_1.factory.createExportAssignment(decorators, modifiers, isExportEquals, (0, utils_1.wrapTests)(expression));
        }
        return configExports;
    }), configPath);
    upgraded = (0, utils_1.reparse)(tsquery_1.tsquery.map(upgraded, EXPORT_TEST_QUERY, (configExportConst) => {
        const { name, exclamationToken, type, initializer } = configExportConst;
        const wrapped = !!initializer && (0, utils_1.wrapTest)(initializer);
        if (!wrapped) {
            return configExportConst;
        }
        return typescript_1.factory.createVariableDeclaration(name, exclamationToken, type, wrapped);
    }), configPath);
    return upgraded;
}
exports.upgradeESM = upgradeESM;
//# sourceMappingURL=upgrade-esm.js.map