/**
 * @welldone-software/why-did-you-render 7.0.1
 * MIT Licensed
 * Generated by Vitali Zaidman <vzaidman@gmail.com> (https://github.com/vzaidman)
 * Generated at 2022-04-04
 */

(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory(require('react'), require('lodash')) :
  typeof define === 'function' && define.amd ? define(['react', 'lodash'], factory) :
  (global = typeof globalThis !== 'undefined' ? globalThis : global || self, global.whyDidYouRender = factory(global.react, global.lodash));
})(this, (function (React, lodash) { 'use strict';

  function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

  function _interopNamespace(e) {
    if (e && e.__esModule) return e;
    var n = Object.create(null);
    if (e) {
      Object.keys(e).forEach(function (k) {
        if (k !== 'default') {
          var d = Object.getOwnPropertyDescriptor(e, k);
          Object.defineProperty(n, k, d.get ? d : {
            enumerable: true,
            get: function () { return e[k]; }
          });
        }
      });
    }
    n["default"] = e;
    return Object.freeze(n);
  }

  var React__default = /*#__PURE__*/_interopDefaultLegacy(React);
  var React__namespace = /*#__PURE__*/_interopNamespace(React);

  var wdyrStore = {
    /* The React object we patch */
    React: undefined,

    /* Processed user options for WDYR */
    options: undefined,

    /* The original React.createElement function */
    origCreateElement: undefined,

    /* The original React.createFactory function */
    origCreateFactory: undefined,

    /* The original React.cloneElement function */
    origCloneElement: undefined,

    /* A weak map of all React elements to their WDYR patched react elements */
    componentsMap: new WeakMap(),

    /* A weak map of props to the owner element that passed them */
    ownerDataMap: new WeakMap(),

    /* An array of hooks tracked during one render */
    hooksPerRender: []
  };

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);

    if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);
      enumerableOnly && (symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      })), keys.push.apply(keys, symbols);
    }

    return keys;
  }

  function _objectSpread2(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = null != arguments[i] ? arguments[i] : {};
      i % 2 ? ownKeys(Object(source), !0).forEach(function (key) {
        _defineProperty(target, key, source[key]);
      }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) {
        Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
      });
    }

    return target;
  }

  function _typeof(obj) {
    "@babel/helpers - typeof";

    return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) {
      return typeof obj;
    } : function (obj) {
      return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
    }, _typeof(obj);
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];
      descriptor.enumerable = descriptor.enumerable || false;
      descriptor.configurable = true;
      if ("value" in descriptor) descriptor.writable = true;
      Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);
    if (staticProps) _defineProperties(Constructor, staticProps);
    Object.defineProperty(Constructor, "prototype", {
      writable: false
    });
    return Constructor;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, {
        value: value,
        enumerable: true,
        configurable: true,
        writable: true
      });
    } else {
      obj[key] = value;
    }

    return obj;
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }

    subClass.prototype = Object.create(superClass && superClass.prototype, {
      constructor: {
        value: subClass,
        writable: true,
        configurable: true
      }
    });
    Object.defineProperty(subClass, "prototype", {
      writable: false
    });
    if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };
    return _getPrototypeOf(o);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;
      return o;
    };

    return _setPrototypeOf(o, p);
  }

  function _isNativeReflectConstruct() {
    if (typeof Reflect === "undefined" || !Reflect.construct) return false;
    if (Reflect.construct.sham) return false;
    if (typeof Proxy === "function") return true;

    try {
      Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {}));
      return true;
    } catch (e) {
      return false;
    }
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }

    return self;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (typeof call === "object" || typeof call === "function")) {
      return call;
    } else if (call !== void 0) {
      throw new TypeError("Derived constructors may only return object or undefined");
    }

    return _assertThisInitialized(self);
  }

  function _createSuper(Derived) {
    var hasNativeReflectConstruct = _isNativeReflectConstruct();

    return function _createSuperInternal() {
      var Super = _getPrototypeOf(Derived),
          result;

      if (hasNativeReflectConstruct) {
        var NewTarget = _getPrototypeOf(this).constructor;

        result = Reflect.construct(Super, arguments, NewTarget);
      } else {
        result = Super.apply(this, arguments);
      }

      return _possibleConstructorReturn(this, result);
    };
  }

  function _superPropBase(object, property) {
    while (!Object.prototype.hasOwnProperty.call(object, property)) {
      object = _getPrototypeOf(object);
      if (object === null) break;
    }

    return object;
  }

  function _get() {
    if (typeof Reflect !== "undefined" && Reflect.get) {
      _get = Reflect.get;
    } else {
      _get = function _get(target, property, receiver) {
        var base = _superPropBase(target, property);

        if (!base) return;
        var desc = Object.getOwnPropertyDescriptor(base, property);

        if (desc.get) {
          return desc.get.call(arguments.length < 3 ? target : receiver);
        }

        return desc.value;
      };
    }

    return _get.apply(this, arguments);
  }

  function _slicedToArray(arr, i) {
    return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest();
  }

  function _toConsumableArray(arr) {
    return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread();
  }

  function _arrayWithoutHoles(arr) {
    if (Array.isArray(arr)) return _arrayLikeToArray(arr);
  }

  function _arrayWithHoles(arr) {
    if (Array.isArray(arr)) return arr;
  }

  function _iterableToArray(iter) {
    if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter);
  }

  function _iterableToArrayLimit(arr, i) {
    var _i = arr == null ? null : typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"];

    if (_i == null) return;
    var _arr = [];
    var _n = true;
    var _d = false;

    var _s, _e;

    try {
      for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) {
        _arr.push(_s.value);

        if (i && _arr.length === i) break;
      }
    } catch (err) {
      _d = true;
      _e = err;
    } finally {
      try {
        if (!_n && _i["return"] != null) _i["return"]();
      } finally {
        if (_d) throw _e;
      }
    }

    return _arr;
  }

  function _unsupportedIterableToArray(o, minLen) {
    if (!o) return;
    if (typeof o === "string") return _arrayLikeToArray(o, minLen);
    var n = Object.prototype.toString.call(o).slice(8, -1);
    if (n === "Object" && o.constructor) n = o.constructor.name;
    if (n === "Map" || n === "Set") return Array.from(o);
    if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen);
  }

  function _arrayLikeToArray(arr, len) {
    if (len == null || len > arr.length) len = arr.length;

    for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i];

    return arr2;
  }

  function _nonIterableSpread() {
    throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
  }

  function _nonIterableRest() {
    throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
  }

  function _createForOfIteratorHelper(o, allowArrayLike) {
    var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"];

    if (!it) {
      if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") {
        if (it) o = it;
        var i = 0;

        var F = function () {};

        return {
          s: F,
          n: function () {
            if (i >= o.length) return {
              done: true
            };
            return {
              done: false,
              value: o[i++]
            };
          },
          e: function (e) {
            throw e;
          },
          f: F
        };
      }

      throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
    }

    var normalCompletion = true,
        didErr = false,
        err;
    return {
      s: function () {
        it = it.call(o);
      },
      n: function () {
        var step = it.next();
        normalCompletion = step.done;
        return step;
      },
      e: function (e) {
        didErr = true;
        err = e;
      },
      f: function () {
        try {
          if (!normalCompletion && it.return != null) it.return();
        } finally {
          if (didErr) throw err;
        }
      }
    };
  }

  var _diffTypesDescription;
  var diffTypes = {
    'different': 'different',
    'deepEquals': 'deepEquals',
    'date': 'date',
    'regex': 'regex',
    'reactElement': 'reactElement',
    'function': 'function',
    'same': 'same'
  };
  var diffTypesDescriptions = (_diffTypesDescription = {}, _defineProperty(_diffTypesDescription, diffTypes.different, 'different objects'), _defineProperty(_diffTypesDescription, diffTypes.deepEquals, 'different objects that are equal by value'), _defineProperty(_diffTypesDescription, diffTypes.date, 'different date objects with the same value'), _defineProperty(_diffTypesDescription, diffTypes.regex, 'different regular expressions with the same value'), _defineProperty(_diffTypesDescription, diffTypes.reactElement, 'different React elements (remember that the <jsx/> syntax always produces a *NEW* immutable React element so a component that receives <jsx/> as props always re-renders)'), _defineProperty(_diffTypesDescription, diffTypes["function"], 'different functions with the same name'), _defineProperty(_diffTypesDescription, diffTypes.same, 'same objects by ref (===)'), _diffTypesDescription); // copied from packages/shared/ReactSymbols.js in https://github.com/facebook/react

  var hasSymbol$1 = typeof Symbol === 'function' && Symbol["for"];
  var REACT_MEMO_TYPE = hasSymbol$1 ? Symbol["for"]('react.memo') : 0xead3;
  var REACT_FORWARD_REF_TYPE = hasSymbol$1 ? Symbol["for"]('react.forward_ref') : 0xead0;
  var REACT_VERSION = Number(React__default["default"].version.split('.')[0]) || 0;
  var REACT_STRICT_MODE = REACT_VERSION >= 18 ? 8 : 1;

  var hasElementType = typeof Element !== 'undefined'; // copied from https://github.com/facebook/react/packages/shared/ReactSymbols.js

  var hasSymbol = typeof Symbol === 'function' && Symbol["for"];
  var REACT_ELEMENT_TYPE = hasSymbol ? Symbol["for"]('react.element') : 0xeac7;

  var isReactElement = function isReactElement(object) {
    return object.$$typeof === REACT_ELEMENT_TYPE;
  }; // end


  function trackDiff(a, b, diffsAccumulator, pathString, diffType) {
    diffsAccumulator.push({
      diffType: diffType,
      pathString: pathString,
      prevValue: a,
      nextValue: b
    });
    return diffType !== diffTypes.different;
  }

  function isGetter(obj, prop) {
    return !!Object.getOwnPropertyDescriptor(obj, prop)['get'];
  }

  var dependenciesMap = new WeakMap();

  function accumulateDeepEqualDiffs(a, b, diffsAccumulator) {
    var pathString = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : '';

    var _ref = arguments.length > 4 ? arguments[4] : undefined,
        detailed = _ref.detailed;

    if (a === b) {
      if (detailed) {
        trackDiff(a, b, diffsAccumulator, pathString, diffTypes.same);
      }

      return true;
    }

    if (!a || !b) {
      return trackDiff(a, b, diffsAccumulator, pathString, diffTypes.different);
    }

    if (lodash.isArray(a) && lodash.isArray(b)) {
      var arrayLength = a.length;

      if (arrayLength !== b.length) {
        return trackDiff(_toConsumableArray(a), _toConsumableArray(b), diffsAccumulator, pathString, diffTypes.different);
      }

      var arrayItemDiffs = [];
      var numberOfDeepEqualsItems = 0;

      for (var i = arrayLength; i--; i > 0) {
        var diffEquals = accumulateDeepEqualDiffs(a[i], b[i], arrayItemDiffs, "".concat(pathString, "[").concat(i, "]"), {
          detailed: detailed
        });

        if (diffEquals) {
          numberOfDeepEqualsItems++;
        }
      }

      if (detailed || numberOfDeepEqualsItems !== arrayLength) {
        diffsAccumulator.push.apply(diffsAccumulator, arrayItemDiffs);
      }

      if (numberOfDeepEqualsItems === arrayLength) {
        return trackDiff(_toConsumableArray(a), _toConsumableArray(b), diffsAccumulator, pathString, diffTypes.deepEquals);
      }

      return trackDiff(_toConsumableArray(a), _toConsumableArray(b), diffsAccumulator, pathString, diffTypes.different);
    }

    if (lodash.isSet(a) && lodash.isSet(b)) {
      if (a.size !== b.size) {
        return trackDiff(new Set(a), new Set(b), diffsAccumulator, pathString, diffTypes.different);
      }

      var _iterator = _createForOfIteratorHelper(a),
          _step;

      try {
        for (_iterator.s(); !(_step = _iterator.n()).done;) {
          var valA = _step.value;

          if (!b.has(valA)) {
            return trackDiff(new Set(a), new Set(b), diffsAccumulator, pathString, diffTypes.different);
          }
        }
      } catch (err) {
        _iterator.e(err);
      } finally {
        _iterator.f();
      }

      return trackDiff(new Set(a), new Set(b), diffsAccumulator, pathString, diffTypes.deepEquals);
    }

    if (lodash.isDate(a) && lodash.isDate(b)) {
      return a.getTime() === b.getTime() ? trackDiff(new Date(a), new Date(b), diffsAccumulator, pathString, diffTypes.date) : trackDiff(new Date(a), new Date(b), diffsAccumulator, pathString, diffTypes.different);
    }

    if (lodash.isRegExp(a) && lodash.isRegExp(b)) {
      return a.toString() === b.toString() ? trackDiff(a, b, diffsAccumulator, pathString, diffTypes.regex) : trackDiff(a, b, diffsAccumulator, pathString, diffTypes.different);
    }

    if (hasElementType && a instanceof Element && b instanceof Element) {
      return trackDiff(a, b, diffsAccumulator, pathString, diffTypes.different);
    }

    if (isReactElement(a) && isReactElement(b)) {
      if (a.type !== b.type) {
        return trackDiff(a, b, diffsAccumulator, pathString, diffTypes.different);
      }

      var reactElementPropsAreDeepEqual = accumulateDeepEqualDiffs(a.props, b.props, [], "".concat(pathString, ".props"), {
        detailed: detailed
      });
      return reactElementPropsAreDeepEqual ? trackDiff(a, b, diffsAccumulator, pathString, diffTypes.reactElement) : trackDiff(a, b, diffsAccumulator, pathString, diffTypes.different);
    }

    if (lodash.isFunction(a) && lodash.isFunction(b)) {
      if (a.name !== b.name) {
        return trackDiff(a, b, diffsAccumulator, pathString, diffTypes.different);
      }

      var aDependenciesObj = dependenciesMap.get(a);
      var bDependenciesObj = dependenciesMap.get(b);

      if (aDependenciesObj && bDependenciesObj) {
        var dependenciesAreDeepEqual = accumulateDeepEqualDiffs(aDependenciesObj.deps, bDependenciesObj.deps, diffsAccumulator, "".concat(pathString, ":parent-hook-").concat(aDependenciesObj.hookName, "-deps"), {
          detailed: detailed
        });
        return dependenciesAreDeepEqual ? trackDiff(a, b, diffsAccumulator, pathString, diffTypes["function"]) : trackDiff(a, b, diffsAccumulator, pathString, diffTypes.different);
      }

      return trackDiff(a, b, diffsAccumulator, pathString, diffTypes["function"]);
    }

    if (_typeof(a) === 'object' && _typeof(b) === 'object' && Object.getPrototypeOf(a) === Object.getPrototypeOf(b)) {
      var aKeys = Object.getOwnPropertyNames(a);
      var bKeys = Object.getOwnPropertyNames(b);
      var allKeys = lodash.uniq([].concat(_toConsumableArray(aKeys), _toConsumableArray(bKeys)));
      var clonedA = lodash.isPlainObject(a) ? _objectSpread2({}, a) : a;
      var clonedB = lodash.isPlainObject(b) ? _objectSpread2({}, b) : b;

      if (allKeys.length !== aKeys.length || allKeys.length !== bKeys.length) {
        return trackDiff(clonedA, clonedB, diffsAccumulator, pathString, diffTypes.different);
      }

      var relevantKeys = allKeys.filter(function (key) {
        // do not compare the stack as it differ even though the errors are identical.
        if (key === 'stack' && lodash.isError(a)) {
          return false;
        } // getters checking is causing too much problems because of how it's used in js.
        // not only getters can throw errors, they also cause side effects in many cases.


        if (isGetter(a, key)) {
          return false;
        }

        return true;
      });
      var keysLength = relevantKeys.length;

      for (var _i = keysLength; _i--; _i > 0) {
        if (!lodash.has(b, relevantKeys[_i])) {
          return trackDiff(clonedA, clonedB, diffsAccumulator, pathString, diffTypes.different);
        }
      }

      var objectValuesDiffs = [];
      var numberOfDeepEqualsObjectValues = 0;

      for (var _i2 = keysLength; _i2--; _i2 > 0) {
        var key = relevantKeys[_i2];
        var deepEquals = accumulateDeepEqualDiffs(a[key], b[key], objectValuesDiffs, "".concat(pathString, ".").concat(key), {
          detailed: detailed
        });

        if (deepEquals) {
          numberOfDeepEqualsObjectValues++;
        }
      }

      if (detailed || numberOfDeepEqualsObjectValues !== keysLength) {
        diffsAccumulator.push.apply(diffsAccumulator, objectValuesDiffs);
      }

      if (numberOfDeepEqualsObjectValues === keysLength) {
        return trackDiff(clonedA, clonedB, diffsAccumulator, pathString, diffTypes.deepEquals);
      }

      return trackDiff(clonedA, clonedB, diffsAccumulator, pathString, diffTypes.different);
    }

    return trackDiff(a, b, diffsAccumulator, pathString, diffTypes.different);
  }

  function calculateDeepEqualDiffs(a, b, initialPathString) {
    var _ref2 = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : {},
        _ref2$detailed = _ref2.detailed,
        detailed = _ref2$detailed === void 0 ? false : _ref2$detailed;

    try {
      var diffs = [];
      accumulateDeepEqualDiffs(a, b, diffs, initialPathString, {
        detailed: detailed
      });
      return diffs;
    } catch (error) {
      if (error.message && error.message.match(/stack|recursion/i) || error.number === -2146828260) {
        // warn on circular references, don't crash.
        // browsers throw different errors name and messages:
        // chrome/safari: "RangeError", "Maximum call stack size exceeded"
        // firefox: "InternalError", too much recursion"
        // edge: "Error", "Out of stack space"
        // eslint-disable-next-line no-console
        console.warn('Warning: why-did-you-render couldn\'t handle circular references in props.', error.name, error.message);
        return false;
      }

      throw error;
    }
  }

  function printDiff(value1, value2, _ref) {
    var pathString = _ref.pathString,
        consoleLog = _ref.consoleLog;
    var diffs = calculateDeepEqualDiffs(value1, value2, pathString, {
      detailed: true
    });
    var keysLength = Math.max.apply(Math, _toConsumableArray(diffs.map(function (diff) {
      return diff.pathString.length;
    }))) + 2;
    Object.entries(lodash.groupBy(lodash.sortBy(diffs, 'pathString'), 'diffType')).forEach(function (_ref2) {
      var _ref3 = _slicedToArray(_ref2, 2),
          diffType = _ref3[0],
          diffs = _ref3[1];

      consoleLog("%c".concat(diffTypesDescriptions[diffType], ":"), 'text-decoration: underline; color: blue;');
      diffs.forEach(function (diff) {
        consoleLog("".concat(diff.pathString, ":").padEnd(keysLength, ' '), diff.prevValue);
      });
    });
  }

  var moreInfoUrl = 'http://bit.ly/wdyr02';
  var moreInfoHooksUrl = 'http://bit.ly/wdyr3';
  var inHotReload = false;

  function shouldLog(reason, Component) {
    if (inHotReload) {
      return false;
    }

    if (wdyrStore.options.logOnDifferentValues) {
      return true;
    }

    if (Component.whyDidYouRender && Component.whyDidYouRender.logOnDifferentValues) {
      return true;
    }

    var hasDifferentValues = reason.propsDifferences && reason.propsDifferences.some(function (diff) {
      return diff.diffType === diffTypes.different;
    }) || reason.stateDifferences && reason.stateDifferences.some(function (diff) {
      return diff.diffType === diffTypes.different;
    }) || reason.hookDifferences && reason.hookDifferences.some(function (diff) {
      return diff.diffType === diffTypes.different;
    });
    return !hasDifferentValues;
  }

  function logDifference(_ref) {
    var Component = _ref.Component,
        displayName = _ref.displayName,
        hookName = _ref.hookName,
        prefixMessage = _ref.prefixMessage,
        diffObjType = _ref.diffObjType,
        differences = _ref.differences,
        values = _ref.values;

    if (differences && differences.length > 0) {
      wdyrStore.options.consoleLog(_defineProperty({}, displayName, Component), "".concat(prefixMessage, " of ").concat(diffObjType, " changes:"));
      differences.forEach(function (_ref2) {
        var pathString = _ref2.pathString,
            diffType = _ref2.diffType,
            prevValue = _ref2.prevValue,
            nextValue = _ref2.nextValue;

        function diffFn() {
          printDiff(prevValue, nextValue, {
            pathString: pathString,
            consoleLog: wdyrStore.options.consoleLog
          });
        }

        wdyrStore.options.consoleGroup("%c".concat(diffObjType === 'hook' ? "[hook ".concat(hookName, " result]") : "".concat(diffObjType, "."), "%c").concat(pathString, "%c"), "color:".concat(wdyrStore.options.diffNameColor, ";"), "color:".concat(wdyrStore.options.diffPathColor, ";"), 'color:default;');
        wdyrStore.options.consoleLog("".concat(diffTypesDescriptions[diffType], ". (more info at ").concat(hookName ? moreInfoHooksUrl : moreInfoUrl, ")"));
        wdyrStore.options.consoleLog(_defineProperty({}, "prev ".concat(pathString), prevValue), '!==', _defineProperty({}, "next ".concat(pathString), nextValue));

        if (diffType === diffTypes.deepEquals) {
          wdyrStore.options.consoleLog({
            'For detailed diff, right click the following fn, save as global, and run: ': diffFn
          });
        }

        wdyrStore.options.consoleGroupEnd();
      });
    } else if (differences) {
      wdyrStore.options.consoleLog(_defineProperty({}, displayName, Component), "".concat(prefixMessage, " the ").concat(diffObjType, " object itself changed but its values are all equal."), diffObjType === 'props' ? 'This could have been avoided by making the component pure, or by preventing its father from re-rendering.' : 'This usually means this component called setState when no changes in its state actually occurred.', "More info at ".concat(moreInfoUrl));
      wdyrStore.options.consoleLog("prev ".concat(diffObjType, ":"), values.prev, ' !== ', values.next, ":next ".concat(diffObjType));
    }
  }

  function defaultNotifier(updateInfo) {
    var Component = updateInfo.Component,
        displayName = updateInfo.displayName,
        hookName = updateInfo.hookName,
        prevProps = updateInfo.prevProps,
        prevState = updateInfo.prevState,
        prevHook = updateInfo.prevHook,
        nextProps = updateInfo.nextProps,
        nextState = updateInfo.nextState,
        nextHook = updateInfo.nextHook,
        reason = updateInfo.reason;

    if (!shouldLog(reason, Component, wdyrStore.options)) {
      return;
    }

    wdyrStore.options.consoleGroup("%c".concat(displayName), "color: ".concat(wdyrStore.options.titleColor, ";"));
    var prefixMessage = 'Re-rendered because';

    if (reason.propsDifferences) {
      logDifference({
        Component: Component,
        displayName: displayName,
        prefixMessage: prefixMessage,
        diffObjType: 'props',
        differences: reason.propsDifferences,
        values: {
          prev: prevProps,
          next: nextProps
        }
      });
      prefixMessage = 'And because';
    }

    if (reason.stateDifferences) {
      logDifference({
        Component: Component,
        displayName: displayName,
        prefixMessage: prefixMessage,
        diffObjType: 'state',
        differences: reason.stateDifferences,
        values: {
          prev: prevState,
          next: nextState
        }
      });
    }

    if (reason.hookDifferences) {
      logDifference({
        Component: Component,
        displayName: displayName,
        prefixMessage: prefixMessage,
        diffObjType: 'hook',
        differences: reason.hookDifferences,
        values: {
          prev: prevHook,
          next: nextHook
        },
        hookName: hookName
      });
    }

    if (reason.propsDifferences && reason.ownerDifferences) {
      var prevOwnerData = wdyrStore.ownerDataMap.get(prevProps);
      var nextOwnerData = wdyrStore.ownerDataMap.get(nextProps);
      wdyrStore.options.consoleGroup("Rendered by ".concat(nextOwnerData.displayName));
      var _prefixMessage = 'Re-rendered because';

      if (reason.ownerDifferences.propsDifferences) {
        logDifference({
          Component: nextOwnerData.Component,
          displayName: nextOwnerData.displayName,
          prefixMessage: _prefixMessage,
          diffObjType: 'props',
          differences: reason.ownerDifferences.propsDifferences,
          values: {
            prev: prevOwnerData.props,
            next: nextOwnerData.props
          }
        });
        _prefixMessage = 'And because';
      }

      if (reason.ownerDifferences.stateDifferences) {
        logDifference({
          Component: nextOwnerData.Component,
          displayName: nextOwnerData.displayName,
          prefixMessage: _prefixMessage,
          diffObjType: 'state',
          differences: reason.ownerDifferences.stateDifferences,
          values: {
            prev: prevOwnerData.state,
            next: nextOwnerData.state
          }
        });
      }

      if (reason.ownerDifferences.hookDifferences) {
        reason.ownerDifferences.hookDifferences.forEach(function (_ref3, i) {
          var hookName = _ref3.hookName,
              differences = _ref3.differences;
          return logDifference({
            Component: nextOwnerData.Component,
            displayName: nextOwnerData.displayName,
            prefixMessage: _prefixMessage,
            diffObjType: 'hook',
            differences: differences,
            values: {
              prev: prevOwnerData.hooks[i].result,
              next: nextOwnerData.hooks[i].result
            },
            hookName: hookName
          });
        });
      }

      wdyrStore.options.consoleGroupEnd();
    }

    if (!reason.propsDifferences && !reason.stateDifferences && !reason.hookDifferences) {
      wdyrStore.options.consoleLog(_defineProperty({}, displayName, Component), 'Re-rendered although props and state objects are the same.', 'This usually means there was a call to this.forceUpdate() inside the component.', "more info at ".concat(moreInfoUrl));
    }

    wdyrStore.options.consoleGroupEnd();
  }
  function createDefaultNotifier(hotReloadBufferMs) {
    if (hotReloadBufferMs) {
      if (typeof module !== 'undefined' && module.hot && module.hot.addStatusHandler) {
        module.hot.addStatusHandler(function (status) {
          if (status === 'idle') {
            inHotReload = true;
            setTimeout(function () {
              inHotReload = false;
            }, hotReloadBufferMs);
          }
        });
      }
    }

    return defaultNotifier;
  }

  var emptyFn = function emptyFn() {};

  function normalizeOptions() {
    var userOptions = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    var consoleGroup = console.group;
    var consoleGroupEnd = console.groupEnd;

    if (userOptions.collapseGroups) {
      consoleGroup = console.groupCollapsed;
    } else if (userOptions.onlyLogs) {
      consoleGroup = console.log;
      consoleGroupEnd = emptyFn;
    }

    var notifier = userOptions.notifier || createDefaultNotifier('hotReloadBufferMs' in userOptions ? userOptions.hotReloadBufferMs : 500);
    return _objectSpread2({
      include: null,
      exclude: null,
      notifier: notifier,
      onlyLogs: false,
      consoleLog: console.log,
      consoleGroup: consoleGroup,
      consoleGroupEnd: consoleGroupEnd,
      logOnDifferentValues: false,
      logOwnerReasons: true,
      trackHooks: true,
      titleColor: '#058',
      diffNameColor: 'blue',
      diffPathColor: 'red',
      trackExtraHooks: [],
      trackAllPureComponents: false
    }, userOptions);
  }

  function getDisplayName(type) {
    return type.displayName || type.name || type.type && getDisplayName(type.type) || type.render && getDisplayName(type.render) || (lodash.isString(type) ? type : 'Unknown');
  }

  function getDefaultProps(type) {
    return type.defaultProps || type.type && getDefaultProps(type.type) || type.render && getDefaultProps(type.render) || {};
  }

  var emptyObject = {};
  function findObjectsDifferences(userPrevObj, userNextObj) {
    var _ref = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {},
        _ref$shallow = _ref.shallow,
        shallow = _ref$shallow === void 0 ? true : _ref$shallow;

    if (userPrevObj === userNextObj) {
      return false;
    }

    if (!shallow) {
      return calculateDeepEqualDiffs(userPrevObj, userNextObj);
    }

    var prevObj = userPrevObj || emptyObject;
    var nextObj = userNextObj || emptyObject;
    var keysOfBothObjects = Object.keys(_objectSpread2(_objectSpread2({}, prevObj), nextObj));
    return lodash.reduce(keysOfBothObjects, function (result, key) {
      var deepEqualDiffs = calculateDeepEqualDiffs(prevObj[key], nextObj[key], key);

      if (deepEqualDiffs) {
        result = [].concat(_toConsumableArray(result), _toConsumableArray(deepEqualDiffs));
      }

      return result;
    }, []);
  }

  function getOwnerDifferences(_ref) {
    var prevOwnerData = _ref.prevOwnerData,
        nextOwnerData = _ref.nextOwnerData;

    if (!prevOwnerData || !nextOwnerData) {
      return false;
    } // in strict mode prevOwnerData might be twice as lengthy because of double renders


    var prevOwnerDataHooks = prevOwnerData.hooks.length === nextOwnerData.hooks.length * 2 ? prevOwnerData.hooks.slice(prevOwnerData.hooks.length / 2) : prevOwnerData.hooks;
    var hookDifferences = prevOwnerDataHooks.map(function (_ref2, i) {
      var hookName = _ref2.hookName,
          result = _ref2.result;
      return {
        hookName: hookName,
        differences: findObjectsDifferences(result, nextOwnerData.hooks[i].result, {
          shallow: false
        })
      };
    });
    return {
      propsDifferences: findObjectsDifferences(prevOwnerData.props, nextOwnerData.props),
      stateDifferences: findObjectsDifferences(prevOwnerData.state, nextOwnerData.state),
      hookDifferences: hookDifferences.length > 0 ? hookDifferences : false
    };
  }

  function getUpdateReason(prevProps, prevState, prevHook, nextProps, nextState, nextHook) {
    var prevOwnerData = wdyrStore.ownerDataMap.get(prevProps);
    var nextOwnerData = wdyrStore.ownerDataMap.get(nextProps);
    return {
      propsDifferences: findObjectsDifferences(prevProps, nextProps),
      stateDifferences: findObjectsDifferences(prevState, nextState),
      hookDifferences: findObjectsDifferences(prevHook, nextHook, {
        shallow: false
      }),
      ownerDifferences: getOwnerDifferences({
        prevOwnerData: prevOwnerData,
        nextOwnerData: nextOwnerData
      })
    };
  }

  function getUpdateInfo(_ref3) {
    var Component = _ref3.Component,
        displayName = _ref3.displayName,
        hookName = _ref3.hookName,
        prevProps = _ref3.prevProps,
        prevState = _ref3.prevState,
        prevHook = _ref3.prevHook,
        nextProps = _ref3.nextProps,
        nextState = _ref3.nextState,
        nextHook = _ref3.nextHook;
    return {
      Component: Component,
      displayName: displayName,
      hookName: hookName,
      prevProps: prevProps,
      prevState: prevState,
      prevHook: prevHook,
      nextProps: nextProps,
      nextState: nextState,
      nextHook: nextHook,
      reason: getUpdateReason(prevProps, prevState, prevHook, nextProps, nextState, nextHook)
    };
  }

  // copied from https://github.com/facebook/react/blob/master/packages/react-reconciler/src/ReactTypeOfMode.js
  // notice: this is only used for class components. functional components doesn't render twice inside strict mode

  function checkIfInsideAStrictModeTree(reactComponentInstance) {
    var reactInternalFiber = reactComponentInstance && (reactComponentInstance._reactInternalFiber || reactComponentInstance._reactInternals);

    while (reactInternalFiber) {
      if (reactInternalFiber.mode & REACT_STRICT_MODE) {
        return true;
      }

      reactInternalFiber = reactInternalFiber["return"];
    }

    return false;
  }
  function isReactClassComponent(Component) {
    return Component.prototype && !!Component.prototype.isReactComponent;
  }
  function isMemoComponent(Component) {
    return Component.$$typeof === REACT_MEMO_TYPE;
  }
  function isForwardRefComponent(Component) {
    return Component.$$typeof === REACT_FORWARD_REF_TYPE;
  }

  function shouldInclude(displayName) {
    return wdyrStore.options.include && wdyrStore.options.include.length > 0 && wdyrStore.options.include.some(function (regex) {
      return regex.test(displayName);
    });
  }

  function shouldExclude(displayName) {
    return wdyrStore.options.exclude && wdyrStore.options.exclude.length > 0 && wdyrStore.options.exclude.some(function (regex) {
      return regex.test(displayName);
    });
  }

  function shouldTrack(Component, _ref) {
    var isHookChange = _ref.isHookChange;
    var displayName = getDisplayName(Component);

    if (shouldExclude(displayName)) {
      return false;
    }

    if (Component.whyDidYouRender === false) {
      return false;
    }

    if (isHookChange && Component.whyDidYouRender && Component.whyDidYouRender.trackHooks === false) {
      return false;
    }

    return !!(Component.whyDidYouRender || wdyrStore.options.trackAllPureComponents && (Component && Component.prototype instanceof wdyrStore.React.PureComponent || isMemoComponent(Component)) || shouldInclude(displayName));
  }

  function patchClassComponent(ClassComponent, _ref) {
    var displayName = _ref.displayName,
        defaultProps = _ref.defaultProps;

    var WDYRPatchedClassComponent = /*#__PURE__*/function (_ClassComponent) {
      _inherits(WDYRPatchedClassComponent, _ClassComponent);

      var _super = _createSuper(WDYRPatchedClassComponent);

      function WDYRPatchedClassComponent(props, context) {
        var _thisSuper, _this;

        _classCallCheck(this, WDYRPatchedClassComponent);

        _this = _super.call(this, props, context);
        _this._WDYR = {
          renderNumber: 0
        };

        var origRender = _get((_thisSuper = _assertThisInitialized(_this), _getPrototypeOf(WDYRPatchedClassComponent.prototype)), "render", _thisSuper) || _this.render; // this probably means that render is an arrow function or this.render.bind(this) was called on the original class


        var renderIsABindedFunction = origRender !== ClassComponent.prototype.render;

        if (renderIsABindedFunction) {
          _this.render = function () {
            WDYRPatchedClassComponent.prototype.render.apply(_assertThisInitialized(_this));
            return origRender();
          };
        }

        return _this;
      }

      _createClass(WDYRPatchedClassComponent, [{
        key: "render",
        value: function render() {
          this._WDYR.renderNumber++;

          if (!('isStrictMode' in this._WDYR)) {
            this._WDYR.isStrictMode = checkIfInsideAStrictModeTree(this);
          } // in strict mode- ignore every other render


          if (!(this._WDYR.isStrictMode && this._WDYR.renderNumber % 2 === 1)) {
            if (this._WDYR.prevProps) {
              var updateInfo = getUpdateInfo({
                Component: ClassComponent,
                displayName: displayName,
                prevProps: this._WDYR.prevProps,
                prevState: this._WDYR.prevState,
                nextProps: this.props,
                nextState: this.state
              });
              wdyrStore.options.notifier(updateInfo);
            }

            this._WDYR.prevProps = this.props;
            this._WDYR.prevState = this.state;
          }

          return _get(_getPrototypeOf(WDYRPatchedClassComponent.prototype), "render", this) ? _get(_getPrototypeOf(WDYRPatchedClassComponent.prototype), "render", this).call(this) : null;
        }
      }]);

      return WDYRPatchedClassComponent;
    }(ClassComponent);

    try {
      WDYRPatchedClassComponent.displayName = displayName;
    } catch (e) {// not crucial if displayName couldn't be set
    }

    WDYRPatchedClassComponent.defaultProps = defaultProps;
    lodash.defaults(WDYRPatchedClassComponent, ClassComponent);
    return WDYRPatchedClassComponent;
  }

  var getFunctionalComponentFromStringComponent = function getFunctionalComponentFromStringComponent(componentTypeStr) {
    return function (props) {
      return wdyrStore.React.createElement(componentTypeStr, props);
    };
  };

  function patchFunctionalOrStrComponent(FunctionalOrStringComponent, _ref) {
    var isPure = _ref.isPure,
        displayName = _ref.displayName,
        defaultProps = _ref.defaultProps;
    var FunctionalComponent = typeof FunctionalOrStringComponent === 'string' ? getFunctionalComponentFromStringComponent(FunctionalOrStringComponent) : FunctionalOrStringComponent;

    function WDYRFunctionalComponent() {
      var nextProps = arguments[0];
      var ref = wdyrStore.React.useRef();
      var prevProps = ref.current;
      ref.current = nextProps;

      if (prevProps) {
        var updateInfo = getUpdateInfo({
          Component: FunctionalComponent,
          displayName: displayName,
          prevProps: prevProps,
          nextProps: nextProps
        });
        var notifiedByHooks = !updateInfo.reason.propsDifferences || isPure && updateInfo.reason.propsDifferences.length === 0;

        if (!notifiedByHooks) {
          wdyrStore.options.notifier(updateInfo);
        }
      }

      return FunctionalComponent.apply(void 0, arguments);
    }

    try {
      WDYRFunctionalComponent.displayName = displayName;
    } catch (e) {// not crucial if displayName couldn't be set
    }

    WDYRFunctionalComponent.defaultProps = defaultProps;
    WDYRFunctionalComponent.ComponentForHooksTracking = FunctionalComponent;
    lodash.defaults(WDYRFunctionalComponent, FunctionalComponent);
    return WDYRFunctionalComponent;
  }

  function patchMemoComponent(MemoComponent, _ref) {
    var displayName = _ref.displayName,
        defaultProps = _ref.defaultProps;
    var InnerMemoComponent = MemoComponent.type;
    var isInnerMemoComponentAClassComponent = isReactClassComponent(InnerMemoComponent);
    var isInnerMemoComponentForwardRefs = isForwardRefComponent(InnerMemoComponent);
    var isInnerMemoComponentAnotherMemoComponent = isMemoComponent(InnerMemoComponent);
    var WrappedFunctionalComponent = isInnerMemoComponentForwardRefs ? InnerMemoComponent.render : InnerMemoComponent;
    var PatchedInnerComponent = isInnerMemoComponentAClassComponent ? patchClassComponent(WrappedFunctionalComponent, {
      displayName: displayName,
      defaultProps: defaultProps
    }) : isInnerMemoComponentAnotherMemoComponent ? patchMemoComponent(WrappedFunctionalComponent, {
      displayName: displayName,
      defaultProps: defaultProps
    }) : patchFunctionalOrStrComponent(WrappedFunctionalComponent, {
      displayName: displayName,
      isPure: true
    });

    try {
      PatchedInnerComponent.displayName = getDisplayName(WrappedFunctionalComponent);
    } catch (e) {// not crucial if displayName couldn't be set
    }

    PatchedInnerComponent.ComponentForHooksTracking = MemoComponent;
    lodash.defaults(PatchedInnerComponent, WrappedFunctionalComponent);
    var WDYRMemoizedFunctionalComponent = wdyrStore.React.memo(isInnerMemoComponentForwardRefs ? wdyrStore.React.forwardRef(PatchedInnerComponent) : PatchedInnerComponent, MemoComponent.compare);

    try {
      WDYRMemoizedFunctionalComponent.displayName = displayName;
    } catch (e) {// not crucial if displayName couldn't be set
    }

    WDYRMemoizedFunctionalComponent.defaultProps = defaultProps;
    lodash.defaults(WDYRMemoizedFunctionalComponent, MemoComponent);
    return WDYRMemoizedFunctionalComponent;
  }

  function patchForwardRefComponent(ForwardRefComponent, _ref) {
    var displayName = _ref.displayName,
        defaultProps = _ref.defaultProps;
    var InnerForwardRefComponent = ForwardRefComponent.render;
    var isInnerComponentMemoized = isMemoComponent(InnerForwardRefComponent);
    var WrappedFunctionalComponent = isInnerComponentMemoized ? InnerForwardRefComponent.type : InnerForwardRefComponent;
    var WDYRWrappedByReactForwardRefFunctionalComponent = patchFunctionalOrStrComponent(WrappedFunctionalComponent, {
      isPure: isInnerComponentMemoized,
      displayName: displayName
    });
    WDYRWrappedByReactForwardRefFunctionalComponent.displayName = getDisplayName(WrappedFunctionalComponent);
    WDYRWrappedByReactForwardRefFunctionalComponent.ComponentForHooksTracking = WrappedFunctionalComponent;
    lodash.defaults(WDYRWrappedByReactForwardRefFunctionalComponent, WrappedFunctionalComponent);
    var WDYRForwardRefFunctionalComponent = wdyrStore.React.forwardRef(isInnerComponentMemoized ? wdyrStore.React.memo(WDYRWrappedByReactForwardRefFunctionalComponent, InnerForwardRefComponent.compare) : WDYRWrappedByReactForwardRefFunctionalComponent);

    try {
      WDYRForwardRefFunctionalComponent.displayName = displayName;
    } catch (e) {// not crucial if displayName couldn't be set
    }

    WDYRForwardRefFunctionalComponent.defaultProps = defaultProps;
    lodash.defaults(WDYRForwardRefFunctionalComponent, ForwardRefComponent);
    return WDYRForwardRefFunctionalComponent;
  }

  var initialHookValue = Symbol('initial-hook-value');

  function trackHookChanges(hookName, _ref, hookResult) {
    var hookPath = _ref.path;
    var nextHook = hookPath ? lodash.get(hookResult, hookPath) : hookResult;
    var renderNumberForTheHook = wdyrStore.React.useRef(true); // TODO: improve

    var isSecondCycleOfRenders = wdyrStore.hooksPerRender[0] && wdyrStore.hooksPerRender[0].renderNumberForTheHook !== renderNumberForTheHook.current;

    if (isSecondCycleOfRenders) {
      wdyrStore.hooksPerRender = [];
    }

    wdyrStore.hooksPerRender.push({
      hookName: hookName,
      result: nextHook,
      renderNumberForTheHook: renderNumberForTheHook.current
    });
    renderNumberForTheHook.current++;
    var ComponentHookDispatchedFromInstance = wdyrStore.React.__SECRET_INTERNALS_DO_NOT_USE_OR_YOU_WILL_BE_FIRED && wdyrStore.React.__SECRET_INTERNALS_DO_NOT_USE_OR_YOU_WILL_BE_FIRED.ReactCurrentOwner.current;
    var prevHookRef = wdyrStore.React.useRef(initialHookValue);

    if (!ComponentHookDispatchedFromInstance) {
      return hookResult;
    }

    var Component = ComponentHookDispatchedFromInstance.type.ComponentForHooksTracking || ComponentHookDispatchedFromInstance.type;
    var displayName = getDisplayName(Component);
    var isShouldTrack = shouldTrack(Component, {
      isHookChange: true
    });

    if (!isShouldTrack) {
      return hookResult;
    }

    var newPrevHookRef = prevHookRef.current;
    prevHookRef.current = hookResult;

    if (newPrevHookRef !== initialHookValue) {
      var notification = getUpdateInfo({
        Component: Component,
        displayName: displayName,
        hookName: hookName,
        prevHook: hookPath ? lodash.get(newPrevHookRef, hookPath) : newPrevHookRef,
        nextHook: nextHook
      });

      if (notification.reason.hookDifferences) {
        wdyrStore.options.notifier(notification);
      }
    }

    return hookResult;
  }

  function createPatchedComponent(Component, _ref2) {
    var displayName = _ref2.displayName,
        defaultProps = _ref2.defaultProps;

    if (isMemoComponent(Component)) {
      return patchMemoComponent(Component, {
        displayName: displayName,
        defaultProps: defaultProps
      });
    }

    if (isForwardRefComponent(Component)) {
      return patchForwardRefComponent(Component, {
        displayName: displayName,
        defaultProps: defaultProps
      });
    }

    if (isReactClassComponent(Component)) {
      return patchClassComponent(Component, {
        displayName: displayName,
        defaultProps: defaultProps
      });
    }

    return patchFunctionalOrStrComponent(Component, {
      displayName: displayName,
      defaultProps: defaultProps,
      isPure: false
    });
  }

  function getPatchedComponent(Component, _ref3) {
    var displayName = _ref3.displayName,
        defaultProps = _ref3.defaultProps;

    if (wdyrStore.componentsMap.has(Component)) {
      return wdyrStore.componentsMap.get(Component);
    }

    var WDYRPatchedComponent = createPatchedComponent(Component, {
      displayName: displayName,
      defaultProps: defaultProps
    });
    wdyrStore.componentsMap.set(Component, WDYRPatchedComponent);
    return WDYRPatchedComponent;
  }

  function getIsSupportedComponentType(Comp) {
    if (!Comp) {
      return false;
    }

    if (isMemoComponent(Comp)) {
      return getIsSupportedComponentType(Comp.type);
    }

    if (isForwardRefComponent(Comp)) {
      return getIsSupportedComponentType(Comp.render);
    }

    if (typeof Comp === 'function') {
      return true;
    }
  }

  var hooksConfig = {
    useState: {
      path: '0'
    },
    useReducer: {
      path: '0'
    },
    useContext: undefined,
    useMemo: {
      dependenciesPath: '1',
      dontReport: true
    },
    useCallback: {
      dependenciesPath: '1',
      dontReport: true
    }
  };
  function storeOwnerData(element) {
    var OwnerInstance = wdyrStore.React.__SECRET_INTERNALS_DO_NOT_USE_OR_YOU_WILL_BE_FIRED.ReactCurrentOwner.current;

    if (OwnerInstance) {
      var Component = OwnerInstance.type.ComponentForHooksTracking || OwnerInstance.type;
      var displayName = getDisplayName(Component);
      var additionalOwnerData = {};

      if (wdyrStore.options.getAdditionalOwnerData) {
        additionalOwnerData = wdyrStore.options.getAdditionalOwnerData(element);
      }

      wdyrStore.ownerDataMap.set(element.props, {
        Component: Component,
        displayName: displayName,
        props: OwnerInstance.pendingProps,
        state: OwnerInstance.stateNode ? OwnerInstance.stateNode.state : null,
        hooks: wdyrStore.hooksPerRender,
        additionalOwnerData: additionalOwnerData
      });
    }
  }

  function resetHooksPerRenderIfNeeded() {
    // Intercept assignments to ReactCurrentOwner.current to reset hooksPerRender
    var currentOwner = null;

    if (wdyrStore.React.__SECRET_INTERNALS_DO_NOT_USE_OR_YOU_WILL_BE_FIRED) {
      Object.defineProperty(wdyrStore.React.__SECRET_INTERNALS_DO_NOT_USE_OR_YOU_WILL_BE_FIRED.ReactCurrentOwner, 'current', {
        get: function get() {
          return currentOwner;
        },
        set: function set(value) {
          currentOwner = value;
          wdyrStore.hooksPerRender = [];
        }
      });
    }
  }

  function trackHooksIfNeeded() {
    var hooksSupported = !!wdyrStore.React.useState;

    if (wdyrStore.options.trackHooks && hooksSupported) {
      var nativeHooks = Object.entries(hooksConfig).map(function (_ref4) {
        var _ref5 = _slicedToArray(_ref4, 2),
            hookName = _ref5[0],
            hookTrackingConfig = _ref5[1];

        return [wdyrStore.React, hookName, hookTrackingConfig];
      });
      var hooksToTrack = [].concat(_toConsumableArray(nativeHooks), _toConsumableArray(wdyrStore.options.trackExtraHooks));
      hooksToTrack.forEach(function (_ref6) {
        var _ref7 = _slicedToArray(_ref6, 3),
            hookParent = _ref7[0],
            hookName = _ref7[1],
            _ref7$ = _ref7[2],
            hookTrackingConfig = _ref7$ === void 0 ? {} : _ref7$;

        var originalHook = hookParent[hookName];
        var newHookName = hookName[0].toUpperCase() + hookName.slice(1);

        var newHook = function newHook() {
          for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
            args[_key] = arguments[_key];
          }

          var hookResult = originalHook.call.apply(originalHook, [this].concat(args));
          var dependenciesPath = hookTrackingConfig.dependenciesPath,
              dontReport = hookTrackingConfig.dontReport;

          if (dependenciesPath && lodash.isFunction(hookResult)) {
            dependenciesMap.set(hookResult, {
              hookName: hookName,
              deps: lodash.get(args, dependenciesPath)
            });
          }

          if (!dontReport) {
            trackHookChanges(hookName, hookTrackingConfig, hookResult);
          }

          return hookResult;
        };

        Object.defineProperty(newHook, 'name', {
          value: newHookName,
          writable: false
        });
        Object.assign(newHook, {
          originalHook: originalHook
        });
        hookParent[hookName] = newHook;
      });
    }
  }

  function getWDYRType(origType) {
    var isShouldTrack = getIsSupportedComponentType(origType) && shouldTrack(origType, {
      isHookChange: false
    });

    if (!isShouldTrack) {
      return null;
    }

    var displayName = origType && origType.whyDidYouRender && origType.whyDidYouRender.customName || getDisplayName(origType);
    var defaultProps = getDefaultProps(origType);
    var WDYRPatchedComponent = getPatchedComponent(origType, {
      displayName: displayName,
      defaultProps: defaultProps
    });
    return WDYRPatchedComponent;
  }
  function whyDidYouRender(React, userOptions) {
    if (React.isWDYR) {
      return;
    }

    Object.assign(wdyrStore, {
      React: React,
      options: normalizeOptions(userOptions),
      origCreateElement: React.createElement,
      origCreateFactory: React.createFactory,
      origCloneElement: React.cloneElement,
      componentsMap: new WeakMap()
    });
    resetHooksPerRenderIfNeeded();

    React.createElement = function (origType) {
      var WDYRType = getWDYRType(origType);

      for (var _len2 = arguments.length, rest = new Array(_len2 > 1 ? _len2 - 1 : 0), _key2 = 1; _key2 < _len2; _key2++) {
        rest[_key2 - 1] = arguments[_key2];
      }

      if (WDYRType) {
        try {
          var element = wdyrStore.origCreateElement.apply(React, [WDYRType].concat(rest));

          if (wdyrStore.options.logOwnerReasons) {
            storeOwnerData(element);
          }

          return element;
        } catch (e) {
          wdyrStore.options.consoleLog('whyDidYouRender error. Please file a bug at https://github.com/welldone-software/why-did-you-render/issues.', {
            errorInfo: {
              error: e,
              componentNameOrComponent: origType,
              rest: rest,
              options: wdyrStore.options
            }
          });
        }
      }

      return wdyrStore.origCreateElement.apply(React, [origType].concat(rest));
    };

    Object.assign(React.createElement, wdyrStore.origCreateElement);

    React.createFactory = function (type) {
      var factory = React.createElement.bind(null, type);
      factory.type = type;
      return factory;
    };

    Object.assign(React.createFactory, wdyrStore.origCreateFactory);

    React.cloneElement = function () {
      for (var _len3 = arguments.length, args = new Array(_len3), _key3 = 0; _key3 < _len3; _key3++) {
        args[_key3] = arguments[_key3];
      }

      var element = wdyrStore.origCloneElement.apply(React, args);

      if (wdyrStore.options.logOwnerReasons) {
        storeOwnerData(element);
      }

      return element;
    };

    Object.assign(React.cloneElement, wdyrStore.origCloneElement);
    trackHooksIfNeeded();
    React.isWDYR = true;

    React.__REVERT_WHY_DID_YOU_RENDER__ = function () {
      Object.assign(React, {
        createElement: wdyrStore.origCreateElement,
        createFactory: wdyrStore.origCreateFactory,
        cloneElement: wdyrStore.origCloneElement
      });
      wdyrStore.componentsMap = null;
      var hooksToRevert = [].concat(_toConsumableArray(Object.keys(hooksConfig).map(function (hookName) {
        return [React, hookName];
      })), _toConsumableArray(wdyrStore.options.trackExtraHooks));
      hooksToRevert.forEach(function (_ref8) {
        var _ref9 = _slicedToArray(_ref8, 2),
            hookParent = _ref9[0],
            hookName = _ref9[1];

        if (hookParent[hookName].originalHook) {
          hookParent[hookName] = hookParent[hookName].originalHook;
        }
      });
      delete React.__REVERT_WHY_DID_YOU_RENDER__;
      delete React.isWDYR;
    };

    return React;
  }

  whyDidYouRender.defaultNotifier = defaultNotifier;
  whyDidYouRender.wdyrStore = wdyrStore;
  whyDidYouRender.storeOwnerData = storeOwnerData;
  whyDidYouRender.getWDYRType = getWDYRType;
  Object.assign(whyDidYouRender, React__namespace);

  return whyDidYouRender;

}));
//# sourceMappingURL=whyDidYouRender.js.map
