'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();

var _lodash = require('lodash');

var _lodash2 = _interopRequireDefault(_lodash);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var PunctuationOpeners = '"\'(<\\[{༺༼᚛⁅⁽₍〈❨' + '❪❬❮❰❲❴⟅⟦⟨⟪' + '⟬⟮⦃⦅⦇⦉⦋⦍⦏⦑' + '⦓⦕⦗⧘⧚⧼⸢⸤⸦⸨' + '〈《「『【〔〖〘〚〝' + '〝﴾︗︵︷︹︻︽︿﹁' + '﹃﹇﹙﹛﹝（［｛｟｢' + '«‘“‹⸂⸄⸉⸌⸜⸠' + '‚„»’”›⸃⸅⸊⸍' + '⸝⸡‛‟';

var PunctuationClosers = '"\')>\\]}༻༽᚜⁆⁾₎〉❩' + '❫❭❯❱❳❵⟆⟧⟩⟫' + '⟭⟯⦄⦆⦈⦊⦌⦎⦐⦒' + '⦔⦖⦘⧙⧛⧽⸣⸥⸧⸩' + '〉》」』】〕〗〙〛〞' + '〟﴿︘︶︸︺︼︾﹀﹂' + '﹄﹈﹚﹜﹞）］｝｠｣' + '»’”›⸃⸅⸊⸍⸝⸡' + '‛‟«‘“‹⸂⸄⸉⸌' + '⸜⸠‚„';

var PunctuationOpenerToCloser = {};
var PunctuationCloserToOpener = {};

for (var i = 0; i < PunctuationOpeners.length; i++) {
  var opener = PunctuationOpeners[i];
  var closer = PunctuationClosers[i];
  PunctuationOpenerToCloser[opener] = closer;
  PunctuationOpenerToCloser[closer] = opener;
}

var PunctuationDelimiters = '\\-/:֊¡·¿;·՚-՟։' + '־׀׃׆׳״؉؊،' + '؍؛؞؟٪-٭۔܀-܍' + '߷-߹࠰-࠾।॥॰෴๏' + '๚๛༄-༒྅࿐-࿔၊-၏' + '჻፡-፨᐀᙭᙮᛫-᛭᜵' + '᜶។-៖៘-៚᠀-᠊᥄᥅' + '᧞᧟᨞᨟᪠-᪦᪨-᪭᭚-' + '᭠᰻-᰿᱾᱿᳓‐-‗†-' + '‧‰-‸※-‾⁁-⁃⁇-' + '⁑⁓⁕-⁞⳹-⳼⳾⳿⸀' + '⸁⸆-⸈⸋⸎-⸛⸞⸟⸪-' + '⸮⸰⸱、-〃〜〰〽゠' + '・꓾꓿꘍-꘏꙳꙾꛲-꛷' + '꡴-꡷꣎꣏꣸-꣺꤮꤯꥟' + '꧁-꧍꧞꧟꩜-꩟꫞꫟꯫' + '︐-︖︙︰-︲﹅﹆﹉-﹌' + '﹐-﹒﹔-﹘﹟-﹡﹣﹨﹪' + '﹫！-＃％-＇＊，-／：' + '；？＠＼｡､･';

var PunctuationDelimiterSet = {};
for (var _i = 0; _i < PunctuationOpeners.length; _i++) {
  PunctuationDelimiterSet[PunctuationDelimiters[_i]] = true;
}

var PunctuationClosingDelimiters = '\\\\.,;!?';

var PunctuationQuotePairs = {
  '\xbb': '\xbb',
  '‘': '‚',
  '’': '’',
  '‚': '‘’',
  '“': '„',
  '„': '“”',
  '”': '”',
  '›': '›'
};

var PunctuationStartStringPrefix = new RegExp('\\s|[' + PunctuationOpeners + PunctuationDelimiters + ']');

var PunctuationEndStringSuffix = new RegExp('\\s|[' + PunctuationClosingDelimiters + ('' + PunctuationDelimiters + PunctuationClosers + ']'));

var ParserUtil = {
  calcIndentSize: function calcIndentSize(str) {
    var tabStop = 8;
    return _lodash2.default.reduce(str, function (total, c) {
      if (c === '\t') {
        return total + tabStop - (total + tabStop) % tabStop;
      }
      return total + 1;
    }, 0);
  },
  isPunctuationOpener: function isPunctuationOpener(c) {
    return c in PunctuationOpenerToCloser;
  },
  isPunctuationCloser: function isPunctuationCloser(c) {
    return c in PunctuationCloserToOpener;
  },
  isPunctuationDelimiter: function isPunctuationDelimiter(c) {
    return c in PunctuationDelimiterSet;
  },
  isMatchPunctuations: function isMatchPunctuations(c1, c2) {
    return PunctuationOpenerToCloser[c1] === c2 || c1 in PunctuationQuotePairs && PunctuationQuotePairs[c1].indexOf(c2) !== -1;
  },
  isInlineMarkupPrefix: function isInlineMarkupPrefix(c) {
    return PunctuationStartStringPrefix.test(c);
  },
  isInlineMarkupSuffix: function isInlineMarkupSuffix(c) {
    return PunctuationEndStringSuffix.test(c);
  },
  isUpperRomanNumber: function isUpperRomanNumber(s) {
    return (/^M{0,3}(CM|CD|D?C{0,3})(XC|XL|L?X{0,3})(IX|IV|V?I{0,3})$/.test(s)
    );
  },
  isLowerRomanNumber: function isLowerRomanNumber(s) {
    return (/^m{0,3}(cm|cd|d?c{0,3})(xc|xl|l?x{0,3})(ix|iv|v?i{0,3})$/.test(s)
    );
  },
  romanToNumber: function romanToNumber(s) {
    var values = [['M', 1000], ['CM', 900], ['D', 500], ['CD', 400], ['C', 100], ['XC', 90], ['L', 50], ['XL', 40], ['X', 10], ['IX', 9], ['V', 5], ['IV', 4], ['I', 1]];
    var result = 0;
    var str = s;

    for (var _i2 = 0; _i2 < values.length; _i2++) {
      var _values$_i = _slicedToArray(values[_i2], 2);

      var key = _values$_i[0];
      var value = _values$_i[1];

      var regex = new RegExp('^' + key);
      while (str.match(regex)) {
        result += value;
        str = str.replace(regex, '');
      }
    }
    return result;
  },
  numberToRoman: function numberToRoman(d) {
    var values = [['M', 1000], ['CM', 900], ['D', 500], ['CD', 400], ['C', 100], ['XC', 90], ['L', 50], ['XL', 40], ['X', 10], ['IX', 9], ['V', 5], ['IV', 4], ['I', 1]];
    var rest = d;
    var result = '';
    for (var _i3 = 0; _i3 < values.length; _i3++) {
      var _values$_i2 = _slicedToArray(values[_i3], 2);

      var key = _values$_i2[0];
      var value = _values$_i2[1];

      while (rest >= value) {
        result += key;
        rest -= value;
      }
    }
    return result;
  }
};

exports.default = ParserUtil;
//# sourceMappingURL=data:application/json;base64,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