import { BettererFileGlobs, BettererFilePaths, BettererFilePatterns, BettererFileResolver, BettererVersionControlWorker } from './types';
export declare class BettererFileResolverΩ implements BettererFileResolver {
    private _baseDirectory;
    private _versionControl;
    private _excluded;
    private _included;
    private _includedResolved;
    private _validatedFilePaths;
    private _validatedFilePathsMap;
    constructor(_baseDirectory?: string | null, _versionControl?: BettererVersionControlWorker | null);
    get baseDirectory(): string;
    get versionControl(): BettererVersionControlWorker;
    init(directory: string, versionControl: BettererVersionControlWorker | null): void;
    validate(filePaths: BettererFilePaths): Promise<BettererFilePaths>;
    resolve(...pathSegments: Array<string>): string;
    include(...includePatterns: BettererFileGlobs): this;
    exclude(...excludePatterns: BettererFilePatterns): this;
    files(): Promise<BettererFilePaths>;
    private _update;
    private _isIncluded;
    private _isExcluded;
}
//# sourceMappingURL=file-resolver.d.ts.map