"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.printer = void 0;
function printer(serialised) {
    let printed = '{\n';
    Object.keys(serialised)
        .sort()
        .forEach((filePath, index) => {
        const file = `    "${filePath}": [\n`;
        printed += prependNewline(index, file);
        serialised[filePath].forEach((issue, index) => {
            const [line, column, length, message, hash] = issue;
            const printedIssue = `      [${line}, ${column}, ${length}, ${JSON.stringify(message)}, ${JSON.stringify(hash)}]`;
            printed += prependNewline(index, printedIssue);
        });
        printed += `\n    ]`;
    });
    printed += '\n  }';
    return printed;
}
exports.printer = printer;
function prependNewline(index, str) {
    return `${index === 0 ? '' : ',\n'}${str}`;
}
//# sourceMappingURL=printer.js.map