/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.netscape.security.x509;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ANY;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.BIT_STRING;
import org.mozilla.jss.asn1.EXPLICIT;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.netscape.security.util.BitArray;
import org.mozilla.jss.netscape.security.util.DerOutputStream;
import org.mozilla.jss.netscape.security.util.DerValue;
import org.mozilla.jss.netscape.security.x509.GeneralNames;
import org.mozilla.jss.netscape.security.x509.GeneralNamesException;
import org.mozilla.jss.netscape.security.x509.RDN;
import org.mozilla.jss.netscape.security.x509.URIName;
import org.mozilla.jss.netscape.security.x509.X500Name;

public class CRLDistributionPoint
implements ASN1Value {
    private GeneralNames fullName;
    private RDN relativeName;
    private ANY fullNameEncoding;
    private BitArray reasons;
    private GeneralNames CRLIssuer;
    private ANY CRLIssuerEncoding;
    private static final Tag TAG = SEQUENCE.TAG;
    private static Template templateInstance = new Template();

    public GeneralNames getFullName() {
        return this.fullName;
    }

    public RDN getRelativeName() {
        return this.relativeName;
    }

    public void setFullName(GeneralNames fullName) throws GeneralNamesException, IOException {
        this.fullName = fullName;
        if (fullName != null) {
            DerOutputStream derOut = new DerOutputStream();
            fullName.encode(derOut);
            try {
                ANY raw = new ANY(derOut.toByteArray());
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                raw.encodeWithAlternateTag(Tag.get(0L), bos);
                this.fullNameEncoding = new ANY(bos.toByteArray());
            }
            catch (InvalidBERException e) {
                throw new GeneralNamesException(e.toString());
            }
            this.relativeName = null;
        }
    }

    public void setRelativeName(RDN relativeName) {
        this.relativeName = relativeName;
        if (relativeName != null) {
            this.fullName = null;
        }
    }

    public BitArray getReasons() {
        return this.reasons;
    }

    public void setReasons(BitArray reasons) {
        this.reasons = reasons;
    }

    public GeneralNames getCRLIssuer() {
        return this.CRLIssuer;
    }

    public void setCRLIssuer(GeneralNames CRLIssuer) throws GeneralNamesException, IOException {
        this.CRLIssuer = CRLIssuer;
        if (CRLIssuer != null) {
            DerOutputStream derOut = new DerOutputStream();
            CRLIssuer.encode(derOut);
            try {
                ANY raw = new ANY(derOut.toByteArray());
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                raw.encodeWithAlternateTag(Tag.get(2L), bos);
                this.CRLIssuerEncoding = new ANY(bos.toByteArray());
            }
            catch (InvalidBERException e) {
                throw new GeneralNamesException(e.toString());
            }
        }
    }

    @Override
    public Tag getTag() {
        return TAG;
    }

    @Override
    public void encode(OutputStream ostream) throws IOException {
        this.encode(TAG, ostream);
    }

    @Override
    public void encode(Tag implicitTag, OutputStream ostream) throws IOException {
        SEQUENCE seq = new SEQUENCE();
        try {
            DerOutputStream derOut;
            if (this.fullName != null) {
                EXPLICIT distPoint = new EXPLICIT(Tag.get(0L), this.fullNameEncoding);
                seq.addElement(distPoint);
            } else if (this.relativeName != null) {
                derOut = new DerOutputStream();
                this.relativeName.encode(derOut);
                ANY rn = new ANY(derOut.toByteArray());
                EXPLICIT raw = new EXPLICIT(Tag.get(1L), rn);
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                raw.encode(bos);
                ANY distPointName = new ANY(bos.toByteArray());
                EXPLICIT distPoint = new EXPLICIT(Tag.get(0L), distPointName);
                seq.addElement(distPoint);
            }
            if (this.reasons != null) {
                derOut = new DerOutputStream();
                derOut.putUnalignedBitString(this.reasons);
                ANY raw = new ANY(derOut.toByteArray());
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                raw.encodeWithAlternateTag(Tag.get(1L), bos);
                ANY reasonEncoding = new ANY(bos.toByteArray());
                seq.addElement(Tag.get(1L), reasonEncoding);
            }
            if (this.CRLIssuer != null) {
                seq.addElement(Tag.get(2L), this.CRLIssuerEncoding);
            }
            seq.encode(implicitTag, ostream);
        }
        catch (InvalidBERException e) {
            throw new IOException(e.toString());
        }
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static void main(String[] args) throws GeneralNamesException, IOException, InvalidBERException {
        try (FileOutputStream fos = new FileOutputStream(args[0]);
             ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            if (args.length != 1) {
                System.out.println("Usage: CRLDistributionPoint <outfile>");
                System.exit(-1);
            }
            SEQUENCE cdps = new SEQUENCE();
            CRLDistributionPoint cdp = new CRLDistributionPoint();
            URIName uri = new URIName("http://www.mycrl.com/go/here");
            GeneralNames generalNames = new GeneralNames();
            generalNames.addElement(uri);
            cdp.setFullName(generalNames);
            cdps.addElement(cdp);
            cdp = new CRLDistributionPoint();
            X500Name dn = new X500Name("CN=Otis Smith,E=otis@fedoraproject.org,OU=Certificate Server,O=Fedora,C=US");
            generalNames = new GeneralNames();
            generalNames.addElement(dn);
            cdp.setFullName(generalNames);
            cdps.addElement(cdp);
            BitArray ba = new BitArray(5, new byte[]{40});
            cdp = new CRLDistributionPoint();
            cdp.setFullName(generalNames);
            cdp.setReasons(ba);
            cdps.addElement(cdp);
            cdp = new CRLDistributionPoint();
            RDN rdn = new RDN("OU=foobar dept");
            cdp.setRelativeName(rdn);
            cdp.setReasons(ba);
            cdp.setCRLIssuer(generalNames);
            cdps.addElement(cdp);
            cdps.encode(bos);
            byte[] encoded = bos.toByteArray();
            fos.write(encoded);
            SEQUENCE.OF_Template seqt = new SEQUENCE.OF_Template(CRLDistributionPoint.getTemplate());
            cdps = (SEQUENCE)ASN1Util.decode(seqt, encoded);
            int size = cdps.size();
            System.out.println("Total number of CDPs: " + size);
            for (int i = 0; i < size; ++i) {
                System.out.println("\nCDP " + i);
                cdp = (CRLDistributionPoint)cdps.elementAt(i);
                GeneralNames gn = cdp.getFullName();
                if (gn == null) {
                    System.out.println("No full name");
                } else {
                    System.out.println(gn);
                }
                rdn = cdp.getRelativeName();
                if (rdn == null) {
                    System.out.println("No relative name");
                } else {
                    System.out.println(rdn);
                }
                if (cdp.getReasons() == null) {
                    System.out.println("No reasons");
                } else {
                    System.out.println(cdp.getReasons());
                }
                gn = cdp.getCRLIssuer();
                if (gn == null) {
                    System.out.println("No cRLIssuer");
                    continue;
                }
                System.out.println(gn);
            }
            System.out.println("Done");
        }
    }

    public static class Template
    implements ASN1Template {
        @Override
        public boolean tagMatch(Tag tag) {
            return TAG.equals(tag);
        }

        @Override
        public ASN1Value decode(InputStream istream) throws IOException, InvalidBERException {
            return this.decode(TAG, istream);
        }

        @Override
        public ASN1Value decode(Tag implicitTag, InputStream istream) throws IOException, InvalidBERException {
            CRLDistributionPoint cdp = new CRLDistributionPoint();
            SEQUENCE.Template seqt = SEQUENCE.getTemplate();
            seqt.addOptionalElement(new EXPLICIT.Template(Tag.get(0L), ANY.getTemplate()));
            seqt.addOptionalElement(Tag.get(1L), BIT_STRING.getTemplate());
            seqt.addOptionalElement(ANY.getTemplate());
            SEQUENCE top = (SEQUENCE)seqt.decode(implicitTag, istream);
            if (top.elementAt(0) != null) {
                EXPLICIT exp = (EXPLICIT)top.elementAt(0);
                ANY distPoint = (ANY)exp.getContent();
                if (distPoint.getTag().equals(Tag.get(0L))) {
                    try {
                        DerValue dv = new DerValue(distPoint.getEncoded());
                        dv.resetTag((byte)48);
                        cdp.setFullName(new GeneralNames(dv));
                    }
                    catch (GeneralNamesException e) {
                        throw new InvalidBERException("fullName: " + e.toString());
                    }
                    catch (IOException e) {
                        throw new InvalidBERException("fullName: " + e.toString());
                    }
                } else if (distPoint.getTag().equals(Tag.get(1L))) {
                    try {
                        DerValue dv = new DerValue(distPoint.getEncoded());
                        dv = dv.data.getDerValue();
                        dv.resetTag((byte)49);
                        cdp.setRelativeName(new RDN(dv));
                    }
                    catch (IOException e) {
                        throw new InvalidBERException("relativeName " + e.toString());
                    }
                } else {
                    throw new InvalidBERException("Unknown tag " + distPoint.getTag() + " in distributionPoint");
                }
            }
            if (top.elementAt(1) != null) {
                BIT_STRING bs = (BIT_STRING)top.elementAt(1);
                byte[] bits = bs.getBits();
                cdp.setReasons(new BitArray(bits.length * 8 - bs.getPadCount(), bits));
            }
            if (top.elementAt(2) != null) {
                ANY issuer = (ANY)top.elementAt(2);
                if (!issuer.getTag().equals(Tag.get(2L))) {
                    throw new InvalidBERException("Invalid tag " + issuer.getTag());
                }
                try {
                    DerValue dv = new DerValue(issuer.getEncoded());
                    dv.resetTag((byte)48);
                    cdp.setCRLIssuer(new GeneralNames(dv));
                }
                catch (GeneralNamesException e) {
                    throw new InvalidBERException("cRLIssuer " + e.toString());
                }
                catch (IOException e) {
                    throw new InvalidBERException("cRLIssuer " + e.toString());
                }
            }
            return cdp;
        }
    }
}

