// SPDX-License-Identifier: GPL-2.0
#include <linux/fs.h>
#include <linux/init.h>
#include <linux/proc_fs.h>
#include <linux/seq_file.h>
#include <linux/kernel_stat.h>

static int cg_flip_proc_show(struct seq_file *m, void *v)
{
	int i;
	u64 nr_cg_flips = 0, nr_switches = 0;
	u64 sum_cg_flips = 0, sum_switches = 0;

	for_each_online_cpu(i) {
		nr_cg_flips = nr_cg_flips_cpu(i);
		nr_switches = nr_switches_cpu(i);
		sum_cg_flips += nr_cg_flips;
		sum_switches += nr_switches;

		seq_printf(m, "cpu%d", i);
		seq_printf(m, " %llu", nr_cg_flips);
		seq_printf(m, " %llu", nr_switches);
		seq_putc(m, '\n');
	}

	seq_puts(m, "sum");
	seq_printf(m, " %llu", sum_cg_flips);
	seq_printf(m, " %llu", sum_switches);
	seq_putc(m, '\n');
	return 0;
}

static int __init proc_cg_flip_init(void)
{
	proc_create_single("cg_flip", 0, NULL, cg_flip_proc_show);
	return 0;
}
fs_initcall(proc_cg_flip_init);
