// SPDX-License-Identifier: GPL-2.0
#ifndef __TESTMGR_H
#define __TESTMGR_H
#include <stdbool.h>
#include <stdlib.h>
#include <stdio.h>

#define ARRAY_SIZE(arr) (sizeof(arr) / sizeof((arr)[0]))

#define TEST_ASSERT(exp, name)				\
({							\
	int __ret = 0;					\
	if (!(exp)) {					\
		printf("Test failed %s\n\n", #name);	\
		__ret = 1;				\
	} else {					\
		printf("Test passed %s\n\n", #name);	\
	}						\
	__ret;						\
})

struct kpp_testvec {
	const char *name;
	const char *secret;
	const char *ep;
	const char *es;
	const char *pp;
};

struct skcipher_testvec {
	const char *name;
	const char *key;
	const char *iv;
	const char *iv_out;
	const char *ptext;
	const char *ctext;
	unsigned int key_len; /* length of key */
	unsigned int len; /* length of ptext or ctext*/
};

struct aead_testvec {
	const char *name;
	const char *key;
	const char *iv;
	const char *ass;
	const char *ptext;
	const char *ctext;
	unsigned int key_len;
	unsigned int ass_len;
	unsigned int p_len;
	unsigned int c_len;
};

struct akcipher_testvec {
	const char *name;
	const char *key;
	const char *priv;
	const char *msg;
	const char *sig;
	unsigned int key_len;
	unsigned int priv_len;
	unsigned int msg_len;
	unsigned int sig_len;
	bool public_key_vec;
};

static const struct skcipher_testvec skcipher_tv[] = {
	{
	.name = "ske-unit",
	.key = "\x06\xa9\x21\x40\x36\xb8\xa1\x5b"
	       "\x51\x2e\x03\xd5\x34\x12\x00\x06",
	.key_len = 16,
	.iv = "\x3d\xaf\xba\x42\x9d\x9e\xb4\x30"
	      "\xb4\x22\xda\x80\x2c\x9f\xac\x41",
	.ptext = "Single block msg",
	.ctext = "\xe3\x53\x77\x9c\x10\x79\xae\xb8"
		 "\x27\x08\x94\x2d\xbe\x77\x18\x1a",
	.len = 16,
	},
};

static const struct aead_testvec aead_tv[] = {
	{
	.name = "ccm",
	.key = "\x58\x5d\xa0\x96\x65\x1a\x04\xd7"
	       "\x96\xe5\xc5\x68\xaa\x95\x35\xe0"
	       "\x29\xa0\xba\x9e\x48\x78\xd1\xba"
	       "\x0d\x1a\x53\x3b\xb5\xe3\xf8\x8b",
	.key_len = 32,
	.iv = "\x03\xcf\x76\x3f\xd9\x95\x75\x8f"
	      "\x44\x89\x40\x7b\x00\x00\x00\x00",
	.ass = "\x8f\x86\x6c\x4d\x1d\xc5\x39\x88"
	       "\xc8\xf3\x5c\x52\x10\x63\x6f\x2b"
	       "\x8a\x2a\xc5\x6f\x30\x23\x58\x7b"
	       "\xfb\x36\x03\x11\xb4\xd9\xf2\xfe",
	.ass_len = 32,
	.ptext = "\xc2\x54\xc8\xde\x78\x87\x77\x40"
		 "\x49\x71\xe4\xb7\xe7\xcb\x76\x61"
		 "\x0a\x41\xb9\xe9\xc0\x76\x54\xab"
		 "\x04\x49\x3b\x19\x93\x57\x25\x5d",
	.p_len = 32,
	.ctext = "\x48\x58\xd6\xf3\xad\x63\x58\xbf"
		 "\xae\xc7\x5e\xae\x83\x8f\x7b\xe4"
		 "\x78\x5c\x4c\x67\x71\x89\x94\xbf"
		 "\x47\xf1\x63\x7e\x1c\x59\xbd\xc5"
		 "\x7f\x44\x0a\x0c\x01\x18\x07\x92"
		 "\xe1\xd3\x51\xce\x32\x6d\x0c\x5b",
	.c_len = 48,
	}, {
	.name = "at",
	.key = "\xfe\xff\xe9\x92\x86\x65\x73\x1c"
	       "\x6d\x6a\x8f\x94\x67\x30\x83\x08"
	       "\xfe\xff\xe9\x92\x86\x65\x73\x1c",
	.key_len = 24,
	.iv = "\xca\xfe\xba\xbe\xfa\xce\xdb\xad"
	      "\xde\xca\xf8\x88",
	.ptext = "\xd9\x31\x32\x25\xf8\x84\x06\xe5"
		 "\xa5\x59\x09\xc5\xaf\xf5\x26\x9a"
		 "\x86\xa7\xa9\x53\x15\x34\xf7\xda"
		 "\x2e\x4c\x30\x3d\x8a\x31\x8a\x72"
		 "\x1c\x3c\x0c\x95\x95\x68\x09\x53"
		 "\x2f\xcf\x0e\x24\x49\xa6\xb5\x25"
		 "\xb1\x6a\xed\xf5\xaa\x0d\xe6\x57"
		 "\xba\x63\x7b\x39",
	.p_len = 60,
	.ass = "\xfe\xed\xfa\xce\xde\xad\xbe\xef"
		 "\xfe\xed\xfa\xce\xde\xad\xbe\xef"
		 "\xab\xad\xda\xd2",
	.ass_len = 20,
	.ctext = "\x39\x80\xca\x0b\x3c\x00\xe8\x41"
		 "\xeb\x06\xfa\xc4\x87\x2a\x27\x57"
		 "\x85\x9e\x1c\xea\xa6\xef\xd9\x84"
		 "\x62\x85\x93\xb4\x0c\xa1\xe1\x9c"
		 "\x7d\x77\x3d\x00\xc1\x44\xc5\x25"
		 "\xac\x61\x9d\x18\xc8\x4a\x3f\x47"
		 "\x18\xe2\x44\x8b\x2f\xe3\x24\xd9"
		 "\xcc\xda\x27\x10"
		 "\x25\x19\x49\x8e\x80\xf1\x47\x8f"
		 "\x37\xba\x55\xbd\x6d\x27\x61\x8c",
	.c_len = 76,
	},
};

static const struct akcipher_testvec akcipher_tv[] = {
	{
	.name = "ecdsa-nist-p521",
	.key = "\x01\xc6\x23\x4e\x52\x43\x13\x24"
	       "\x6c\x4b\x86\xac\xeb\xc8\xf7\xa5"
	       "\xa0\xff\x25\x76\x73\x9d\xcc\x16"
	       "\x96\x99\xfe\x03\x13\x52\xd4\xc7"
	       "\xd8\xc0\x98\x6a\xf1\xc5\xd1\x40"
	       "\xd5\xb1\x17\xb9\x73\xb7\x72\x62"
	       "\xd3\xe3\xd2\xaf\x43\x31\xc3\x55"
	       "\x41\x38\x76\x67\x90\xc4\x2d\x81"
	       "\xe6\xf5\x01\x9d\xa2\x23\x6b\x45"
	       "\xb5\xda\x57\x81\x83\x7d\xf2\x37"
	       "\xa5\xf2\x00\xf1\x72\x00\xe5\x34"
	       "\x2c\x14\xc4\x49\x3f\x1b\xfb\x37"
	       "\x38\x7c\x94\x1b\x4b\x93\x8e\xb4"
	       "\xec\x7c\x68\x61\x4d\x70\xf1\x99"
	       "\xc5\xff\xac\xc5\xad\x3d\xad\x7f"
	       "\x8b\xf8\xcf\xe9\x88\x61\x7f\x07"
	       "\x83\xad\x22\xcc",
	.key_len = 132,
	.msg = "\xd2\x6c\x40\x12\x21\xfb\x2e\xac"
	       "\x1a\x85\x4c\xdc\x38\x3c\x3a\xe1"
	       "\xe5\x71\x6e\xe5\x13\x42\x1e\x76"
	       "\xc9\x07\x6b\xf3\xa4\x9f\xbd\xd3",
	.msg_len = 32,
	.sig = "\x00\xe8\x91\x3a\x67\x62\x70\x09"
	       "\x2a\xde\x3f\xaa\x0a\xbb\x00\x5f"
	       "\x72\x2a\x59\x5d\xdb\x10\x7f\xfd"
	       "\x4b\xfd\x92\x83\x4a\xb9\x06\xe7"
	       "\x1e\xeb\xde\xdf\xcc\x1f\xb3\x93"
	       "\x72\x3a\xc5\xfc\xfd\xf9\xea\x50"
	       "\x97\x38\x79\x74\xca\x7b\x4a\x1d"
	       "\xee\x71\xbe\x15\xd2\x71\xcb\xc5"
	       "\x12\xf5\x00\xd9\x05\xee\x79\x51"
	       "\xd0\x09\x52\x67\x2f\x02\x69\x69"
	       "\xa2\x9f\xad\x1d\x75\xf8\x06\xc5"
	       "\x9e\x0b\x22\x77\x5d\xc1\xe5\xc1"
	       "\x67\x3d\xeb\x50\x77\xa1\x5e\xf4"
	       "\x48\x14\x32\xde\x70\x53\x64\x3e"
	       "\x21\x19\x4f\xee\xb4\xcb\x10\xd7"
	       "\x41\x4f\x28\xd7\xa5\x14\xeb\xef"
	       "\x5d\xe1\xa4\x04",
	.sig_len = 132,
	}, {
	.name = "ecdsa-nist-p256",
	.key = "\xbf\x30\xd5\x26\xac\xa2\xb8\xec"
	       "\xbb\x4b\x28\xef\x13\xfe\xe4\xfd"
	       "\xc7\x9d\x3c\xda\xe5\x1a\xd8\xc4"
	       "\x15\xfc\xc3\x65\xce\xdd\x8a\xa8"
	       "\x9e\x24\x54\xe7\x6c\x52\x21\xe7"
	       "\x7c\x49\xdd\xab\x13\x0d\xa3\xb8"
	       "\x4c\xf4\x5b\x1f\xc1\xd8\x52\x99"
	       "\x2e\xf3\xce\xa3\x79\xb8\x77\x4d",
	.key_len = 64,
	.msg = "\xcd\xb9\xd2\x1c\xb7\x6f\xcd\x44"
	       "\xb3\xfd\x63\xea\xa3\x66\x7f\xae"
	       "\x63\x85\xe7\x82",
	.msg_len = 20,
	.priv = "\x89\x83\xde\xf5\xca\xd5\x0e\x21"
		"\xe6\x88\xb2\x7b\x0d\x93\x2e\x72"
		"\x5e\x1d\xc2\x41\xf7\x48\x0f\x46"
		"\x1a\x24\xe1\xb8\x98\x29\x7a\x69",
	.priv_len = 32,
	}, {
	.name = "rsa-crt",
	.msg = "\x54\x85\x9b\x34\x2c\x49\xea\x2a",
	.msg_len = 8,
	}, {
	.name = "rsa-pkcs",
	.msg = "\x54\x85\x9b\x34\x2c\x49\xea\x2a",
	.msg_len = 8,
	.sig = "\x9e\xa7\xdf\x1e\xb4\xa1\x25\xdf"
	       "\x6b\xa5\xec\xa5\xc8\x4f\x30\x94"
	       "\xb2\x91\xea\x3d\x0e\x75\x39\xc7"
	       "\x5e\x8b\x0c\x3e\x7e\x76\x54\x47"
	       "\xa8\x27\x62\xc6\x25\xa7\x33\x29"
	       "\xa8\x9b\x94\xa3\xe6\xfa\x8b\x7c"
	       "\x37\x37\x43\x20\xaf\xe1\x71\x6a"
	       "\x32\xfb\x0a\x60\x47\xb9\x30\xec"
	       "\xc1\xa8\xa5\x95\x82\x03\xee\x3d"
	       "\x05\xc8\xb3\x7d\x10\xae\x4b\xcf"
	       "\x66\x07\x29\x6c\xec\x5d\x09\x4c"
	       "\xb3\xd7\xc8\xff\x9a\x8d\x73\xe7"
	       "\x82\x16\xfa\x9d\x0b\xd0\xe9\x7c"
	       "\xba\x2a\x1c\x5b\xb2\xba\x88\xef"
	       "\xd8\x99\x4b\xbd\x7d\x35\xa4\x20"
	       "\xee\x5a\x81\x99\xb5\x1a\xa2\x51",
	.sig_len = 128,
	}, {
	.name = "rsa-pke-unit",
	.key = "\x30\x82\x02\x1F" /* sequence of 543 bytes */
	       "\x02\x01\x01" /* version - integer of 1 byte */
	       "\x02\x82\x01\x00" /* modulus - integer of 256 bytes */
	       "\xDB\x10\x1A\xC2\xA3\xF1\xDC\xFF\x13\x6B\xED\x44\xDF\xF0\x02\x6D"
	       "\x13\xC7\x88\xDA\x70\x6B\x54\xF1\xE8\x27\xDC\xC3\x0F\x99\x6A\xFA"
	       "\xC6\x67\xFF\x1D\x1E\x3C\x1D\xC1\xB5\x5F\x6C\xC0\xB2\x07\x3A\x6D"
	       "\x41\xE4\x25\x99\xAC\xFC\xD2\x0F\x02\xD3\xD1\x54\x06\x1A\x51\x77"
	       "\xBD\xB6\xBF\xEA\xA7\x5C\x06\xA9\x5D\x69\x84\x45\xD7\xF5\x05\xBA"
	       "\x47\xF0\x1B\xD7\x2B\x24\xEC\xCB\x9B\x1B\x10\x8D\x81\xA0\xBE\xB1"
	       "\x8C\x33\xE4\x36\xB8\x43\xEB\x19\x2A\x81\x8D\xDE\x81\x0A\x99\x48"
	       "\xB6\xF6\xBC\xCD\x49\x34\x3A\x8F\x26\x94\xE3\x28\x82\x1A\x7C\x8F"
	       "\x59\x9F\x45\xE8\x5D\x1A\x45\x76\x04\x56\x05\xA1\xD0\x1B\x8C\x77"
	       "\x6D\xAF\x53\xFA\x71\xE2\x67\xE0\x9A\xFE\x03\xA9\x85\xD2\xC9\xAA"
	       "\xBA\x2A\xBC\xF4\xA0\x08\xF5\x13\x98\x13\x5D\xF0\xD9\x33\x34\x2A"
	       "\x61\xC3\x89\x55\xF0\xAE\x1A\x9C\x22\xEE\x19\x05\x8D\x32\xFE\xEC"
	       "\x9C\x84\xBA\xB7\xF9\x6C\x3A\x4F\x07\xFC\x45\xEB\x12\xE5\x7B\xFD"
	       "\x55\xE6\x29\x69\xD1\xC2\xE8\xB9\x78\x59\xF6\x79\x10\xC6\x4E\xEB"
	       "\x6A\x5E\xB9\x9A\xC7\xC4\x5B\x63\xDA\xA3\x3F\x5E\x92\x7A\x81\x5E"
	       "\xD6\xB0\xE2\x62\x8F\x74\x26\xC2\x0C\xD3\x9A\x17\x47\xE6\x8E\xAB"
	       "\x02\x03\x01\x00\x01" /* public key - integer of 3 bytes */
	       "\x02\x82\x01\x00" /* private key - integer of 256 bytes */
	       "\x52\x41\xF4\xDA\x7B\xB7\x59\x55\xCA\xD4\x2F\x0F\x3A\xCB\xA4\x0D"
	       "\x93\x6C\xCC\x9D\xC1\xB2\xFB\xFD\xAE\x40\x31\xAC\x69\x52\x21\x92"
	       "\xB3\x27\xDF\xEA\xEE\x2C\x82\xBB\xF7\x40\x32\xD5\x14\xC4\x94\x12"
	       "\xEC\xB8\x1F\xCA\x59\xE3\xC1\x78\xF3\x85\xD8\x47\xA5\xD7\x02\x1A"
	       "\x65\x79\x97\x0D\x24\xF4\xF0\x67\x6E\x75\x2D\xBF\x10\x3D\xA8\x7D"
	       "\xEF\x7F\x60\xE4\xE6\x05\x82\x89\x5D\xDF\xC6\xD2\x6C\x07\x91\x33"
	       "\x98\x42\xF0\x02\x00\x25\x38\xC5\x85\x69\x8A\x7D\x2F\x95\x6C\x43"
	       "\x9A\xB8\x81\xE2\xD0\x07\x35\xAA\x05\x41\xC9\x1E\xAF\xE4\x04\x3B"
	       "\x19\xB8\x73\xA2\xAC\x4B\x1E\x66\x48\xD8\x72\x1F\xAC\xF6\xCB\xBC"
	       "\x90\x09\xCA\xEC\x0C\xDC\xF9\x2C\xD7\xEB\xAE\xA3\xA4\x47\xD7\x33"
	       "\x2F\x8A\xCA\xBC\x5E\xF0\x77\xE4\x97\x98\x97\xC7\x10\x91\x7D\x2A"
	       "\xA6\xFF\x46\x83\x97\xDE\xE9\xE2\x17\x03\x06\x14\xE2\xD7\xB1\x1D"
	       "\x77\xAF\x51\x27\x5B\x5E\x69\xB8\x81\xE6\x11\xC5\x43\x23\x81\x04"
	       "\x62\xFF\xE9\x46\xB8\xD8\x44\xDB\xA5\xCC\x31\x54\x34\xCE\x3E\x82"
	       "\xD6\xBF\x7A\x0B\x64\x21\x6D\x88\x7E\x5B\x45\x12\x1E\x63\x8D\x49"
	       "\xA7\x1D\xD9\x1E\x06\xCD\xE8\xBA\x2C\x8C\x69\x32\xEA\xBE\x60\x71"
	       "\x02\x01\x00" /* prime1 - integer of 1 byte */
	       "\x02\x01\x00" /* prime2 - integer of 1 byte */
	       "\x02\x01\x00" /* exponent1 - integer of 1 byte */
	       "\x02\x01\x00" /* exponent2 - integer of 1 byte */
	       "\x02\x01\x00", /* coefficient - integer of 1 byte */
	.key_len = 547,
	.msg = "\x54\x85\x9b\x34\x2c\x49\xea\x2a",
	.sig = "\xb2\x97\x76\xb4\xae\x3e\x38\x3c\x7e\x64\x1f\xcc\xa2\x7f\xf6\xbe"
	       "\xcf\x49\xbc\x48\xd3\x6c\x8f\x0a\x0e\xc1\x73\xbd\x7b\x55\x79\x36"
	       "\x0e\xa1\x87\x88\xb9\x2c\x90\xa6\x53\x5e\xe9\xef\xc4\xe2\x4d\xdd"
	       "\xf7\xa6\x69\x82\x3f\x56\xa4\x7b\xfb\x62\xe0\xae\xb8\xd3\x04\xb3"
	       "\xac\x5a\x15\x2a\xe3\x19\x9b\x03\x9a\x0b\x41\xda\x64\xec\x0a\x69"
	       "\xfc\xf2\x10\x92\xf3\xc1\xbf\x84\x7f\xfd\x2c\xae\xc8\xb5\xf6\x41"
	       "\x70\xc5\x47\x03\x8a\xf8\xff\x6f\x3f\xd2\x6f\x09\xb4\x22\xf3\x30"
	       "\xbe\xa9\x85\xcb\x9c\x8d\xf9\x8f\xeb\x32\x91\xa2\x25\x84\x8f\xf5"
	       "\xdc\xc7\x06\x9c\x2d\xe5\x11\x2c\x09\x09\x87\x09\xa9\xf6\x33\x73"
	       "\x90\xf1\x60\xf2\x65\xdd\x30\xa5\x66\xce\x62\x7b\xd0\xf8\x2d\x3d"
	       "\x19\x82\x77\xe3\x0a\x5f\x75\x2f\x8e\xb1\xe5\xe8\x91\x35\x1b\x3b"
	       "\x33\xb7\x66\x92\xd1\xf2\x8e\x6f\xe5\x75\x0c\xad\x36\xfb\x4e\xd0"
	       "\x66\x61\xbd\x49\xfe\xf4\x1a\xa2\x2b\x49\xfe\x03\x4c\x74\x47\x8d"
	       "\x9a\x66\xb2\x49\x46\x4d\x77\xea\x33\x4d\x6b\x3c\xb4\x49\x4a\xc6"
	       "\x7d\x3d\xb5\xb9\x56\x41\x15\x67\x0f\x94\x3c\x93\x65\x27\xe0\x21"
	       "\x5d\x59\xc3\x62\xd5\xa6\xda\x38\x26\x22\x5e\x34\x1c\x94\xaf\x98",
	.msg_len = 8,
	.sig_len = 256,
	}, {
	.name = "rsa-sign",
	.msg = "\x54\x85\x9b\x34\x2c\x49\xea\x2a",
	.msg_len = 8,
	}
};

static const struct kpp_testvec kpp_tv[] = {
	{
	.name = "ecdh-nist-p256",
	.secret = "\x24\xd1\x21\xeb\xe5\xcf\x2d\x83"
		  "\xf6\x62\x1b\x6e\x43\x84\x3a\xa3"
		  "\x8b\xe0\x86\xc3\x20\x19\xda\x92"
		  "\x50\x53\x03\xe1\xc0\xea\xb8\x82",
	.ep = "\x1a\x7f\xeb\x52\x00\xbd\x3c\x31"
	      "\x7d\xb6\x70\xc1\x86\xa6\xc7\xc4"
	      "\x3b\xc5\x5f\x6c\x6f\x58\x3c\xf5"
	      "\xb6\x63\x82\x77\x33\x24\xa1\x5f"
	      "\x6a\xca\x43\x6f\xf7\x7e\xff\x02"
	      "\x37\x08\xcc\x40\x5e\x7a\xfd\x6a"
	      "\x6a\x02\x6e\x41\x87\x68\x38\x77"
	      "\xfa\xa9\x44\x43\x2d\xef\x09\xdf",
	.es = "\xea\x17\x6f\x7e\x6e\x57\x26\x38"
	      "\x8b\xfb\x41\xeb\xba\xc8\x6d\xa5"
	      "\xa8\x72\xd1\xff\xc9\x47\x3d\xaa"
	      "\x58\x43\x9f\x34\x0f\x8c\xf3\xc9",
	.pp = "\xcc\xb4\xda\x74\xb1\x47\x3f\xea"
	      "\x6c\x70\x9e\x38\x2d\xc7\xaa\xb7"
	      "\x29\xb2\x47\x03\x19\xab\xdd\x34"
	      "\xbd\xa8\x2c\x93\xe1\xa4\x74\xd9"
	      "\x64\x63\xf7\x70\x20\x2f\xa4\xe6"
	      "\x9f\x4a\x38\xcc\xc0\x2c\x49\x2f"
	      "\xb1\x32\xbb\xaf\x22\x61\xda\xcb"
	      "\x6f\xdb\xa9\xaa\xfc\x77\x81\xf3",
	},
};

#endif
