/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.server.ca.rest;

import com.netscape.certsrv.base.BadRequestException;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.PKIException;
import com.netscape.certsrv.system.KRAConnectorInfo;
import com.netscape.certsrv.system.KRAConnectorResource;
import com.netscape.cms.servlet.admin.KRAConnectorProcessor;
import com.netscape.cms.servlet.base.PKIService;
import javax.ws.rs.core.Response;
import org.dogtagpki.server.ca.CAEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KRAConnectorService
extends PKIService
implements KRAConnectorResource {
    public static Logger logger = LoggerFactory.getLogger(KRAConnectorService.class);

    public Response addConnector(KRAConnectorInfo info) {
        if (info == null) {
            throw new BadRequestException("Missing KRA connector info.");
        }
        CAEngine engine = (CAEngine)this.getCMSEngine();
        try {
            KRAConnectorProcessor processor = new KRAConnectorProcessor(this.getLocale(this.headers));
            processor.setCMSEngine(engine);
            processor.init();
            processor.addConnector(info);
            return this.createNoContentResponse();
        }
        catch (EBaseException e) {
            String message = "Unable to add KRA connector: " + e.getMessage();
            logger.error(message, (Throwable)e);
            throw new PKIException(message, (Throwable)e);
        }
    }

    public Response addHost(String host, String port) {
        CAEngine engine = (CAEngine)this.getCMSEngine();
        try {
            KRAConnectorProcessor processor = new KRAConnectorProcessor(this.getLocale(this.headers));
            processor.setCMSEngine(engine);
            processor.init();
            processor.addHost(host, port);
            return this.createNoContentResponse();
        }
        catch (EBaseException e) {
            String message = "Unable to add KRA connector: " + e.getMessage();
            logger.error(message, (Throwable)e);
            throw new PKIException(message, (Throwable)e);
        }
    }

    public Response removeConnector(String host, String port) {
        if (host == null) {
            throw new BadRequestException("Missing KRA connector host.");
        }
        if (port == null) {
            throw new BadRequestException("Missing KRA connector port.");
        }
        CAEngine engine = (CAEngine)this.getCMSEngine();
        try {
            KRAConnectorProcessor processor = new KRAConnectorProcessor(this.getLocale(this.headers));
            processor.setCMSEngine(engine);
            processor.init();
            processor.removeConnector(host, port);
            return this.createNoContentResponse();
        }
        catch (EBaseException e) {
            String message = "Unable to remove KRA connector: " + e.getMessage();
            logger.error(message, (Throwable)e);
            throw new PKIException(message, (Throwable)e);
        }
    }

    public Response getConnectorInfo() {
        CAEngine engine = (CAEngine)this.getCMSEngine();
        try {
            KRAConnectorProcessor processor = new KRAConnectorProcessor(this.getLocale(this.headers));
            processor.setCMSEngine(engine);
            processor.init();
            return this.createOKResponse(processor.getConnectorInfo());
        }
        catch (EBaseException e) {
            String message = "Unable to get KRA connector: " + e.getMessage();
            logger.error(message, (Throwable)e);
            throw new PKIException(message, (Throwable)e);
        }
    }
}

