/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.kra;

import com.netscape.certsrv.dbs.keydb.KeyId;
import com.netscape.certsrv.key.KeyClient;
import com.netscape.certsrv.key.KeyRecoveryRequest;
import com.netscape.certsrv.key.KeyRequestResponse;
import com.netscape.certsrv.util.JSONSerializer;
import com.netscape.cmstools.cli.MainCLI;
import com.netscape.cmstools.kra.KRAKeyCLI;
import java.nio.file.Files;
import java.nio.file.Path;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.cli.CommandCLI;
import org.mozilla.jss.netscape.security.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KRAKeyRecoverCLI
extends CommandCLI {
    public static Logger logger = LoggerFactory.getLogger(KRAKeyRecoverCLI.class);
    public KRAKeyCLI keyCLI;

    public KRAKeyRecoverCLI(KRAKeyCLI keyCLI) {
        super("recover", "Create a key recovery request", (CLI)keyCLI);
        this.keyCLI = keyCLI;
    }

    public void printHelp() {
        formatter.printHelp(this.getFullName() + " [OPTIONS...]", this.options);
    }

    public void createOptions() {
        Option option = new Option(null, "keyID", true, "Key Identifier for the secret to be recovered.");
        option.setArgName("Key Identifier");
        this.options.addOption(option);
        option = new Option(null, "input", true, "Location of the request file.");
        option.setArgName("Input file path");
        this.options.addOption(option);
    }

    public void execute(CommandLine cmd) throws Exception {
        String[] cmdArgs = cmd.getArgs();
        if (cmdArgs.length != 0) {
            throw new Exception("Too many arguments specified.");
        }
        String requestFile = cmd.getOptionValue("input");
        String keyID = cmd.getOptionValue("keyID");
        MainCLI mainCLI = (MainCLI)this.getRoot();
        mainCLI.init();
        KeyRequestResponse response = null;
        KeyClient keyClient = this.keyCLI.getKeyClient();
        if (requestFile != null) {
            String json = Files.readString(Path.of(requestFile, new String[0]));
            KeyRecoveryRequest req = (KeyRecoveryRequest)JSONSerializer.fromJSON((String)json, KeyRecoveryRequest.class);
            response = keyClient.recoverKey(req.getKeyId(), Utils.base64decode((String)req.getSessionWrappedPassphrase()), Utils.base64decode((String)req.getTransWrappedSessionKey()), Utils.base64decode((String)req.getNonceData()), req.getCertificate());
        } else if (keyID != null) {
            String keyId = cmd.getOptionValue("keyID");
            response = keyClient.recoverKey(new KeyId(keyId), null, null, null, null);
        } else {
            throw new Exception("Neither a key ID nor a request file's path is specified.");
        }
        MainCLI.printMessage("Key Recovery Request Information");
        KRAKeyCLI.printKeyRequestInfo(response.getRequestInfo());
    }
}

