/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.kra;

import com.netscape.certsrv.key.KeyClient;
import com.netscape.certsrv.key.KeyRequestInfo;
import com.netscape.certsrv.key.KeyRequestInfoCollection;
import com.netscape.certsrv.request.RequestId;
import com.netscape.cmstools.cli.MainCLI;
import com.netscape.cmstools.kra.KRAKeyCLI;
import java.util.Collection;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.cli.CommandCLI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KRAKeyRequestFindCLI
extends CommandCLI {
    public static Logger logger = LoggerFactory.getLogger(KRAKeyRequestFindCLI.class);
    public KRAKeyCLI keyCLI;

    public KRAKeyRequestFindCLI(KRAKeyCLI keyCLI) {
        super("request-find", "Find key requests", (CLI)keyCLI);
        this.keyCLI = keyCLI;
    }

    public void printHelp() {
        formatter.printHelp(this.getFullName() + " [OPTIONS...]", this.options);
    }

    public void createOptions() {
        Option option = new Option(null, "status", true, "Request status");
        option.setArgName("status");
        this.options.addOption(option);
        option = new Option(null, "type", true, "Request type");
        option.setArgName("type");
        this.options.addOption(option);
        option = new Option(null, "client", true, "Client ID");
        option.setArgName("client ID");
        this.options.addOption(option);
        option = new Option(null, "maxResults", true, "Maximum results");
        option.setArgName("max results");
        this.options.addOption(option);
        option = new Option(null, "maxTime", true, "Maximum time");
        option.setArgName("max time");
        this.options.addOption(option);
        option = new Option(null, "start", true, "Page to start");
        option.setArgName("starting page");
        this.options.addOption(option);
        option = new Option(null, "pageSize", true, "Page size");
        option.setArgName("page size");
        this.options.addOption(option);
        option = new Option(null, "realm", true, "Authorization Realm");
        option.setArgName("realm");
        this.options.addOption(option);
    }

    public void execute(CommandLine cmd) throws Exception {
        String[] cmdArgs = cmd.getArgs();
        if (cmdArgs.length != 0) {
            throw new Exception("Too many arguments specified.");
        }
        String status = cmd.getOptionValue("status");
        String type = cmd.getOptionValue("type");
        String clientKeyID = cmd.getOptionValue("client");
        String realm = cmd.getOptionValue("realm");
        String s = cmd.getOptionValue("start");
        RequestId start = s == null ? null : new RequestId(s);
        s = cmd.getOptionValue("pageSize");
        Integer pageSize = s == null ? null : Integer.valueOf(s);
        s = cmd.getOptionValue("maxResults");
        Integer maxResults = s == null ? null : Integer.valueOf(s);
        s = cmd.getOptionValue("maxTime");
        Integer maxTime = s == null ? null : Integer.valueOf(s);
        MainCLI mainCLI = (MainCLI)this.getRoot();
        mainCLI.init();
        KeyClient keyClient = this.keyCLI.getKeyClient();
        KeyRequestInfoCollection keys = keyClient.listRequests(status, type, clientKeyID, start, pageSize, maxResults, maxTime, realm);
        MainCLI.printMessage(keys.getTotal() + " entries matched");
        if (keys.getTotal() == 0) {
            return;
        }
        Collection entries = keys.getEntries();
        boolean first = true;
        for (KeyRequestInfo info : entries) {
            if (first) {
                first = false;
            } else {
                System.out.println();
            }
            KRAKeyCLI.printKeyRequestInfo(info);
        }
        MainCLI.printMessage("Number of entries returned " + entries.size());
    }
}

