/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.tps.connector;

import com.netscape.certsrv.tps.connector.ConnectorClient;
import com.netscape.certsrv.tps.connector.ConnectorData;
import com.netscape.certsrv.util.JSONSerializer;
import com.netscape.cmstools.cli.MainCLI;
import com.netscape.cmstools.tps.connector.ConnectorCLI;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.cli.CommandCLI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectorModifyCLI
extends CommandCLI {
    public static Logger logger = LoggerFactory.getLogger(ConnectorModifyCLI.class);
    public ConnectorCLI connectorCLI;

    public ConnectorModifyCLI(ConnectorCLI connectorCLI) {
        super("mod", "Modify connector", (CLI)connectorCLI);
        this.connectorCLI = connectorCLI;
    }

    public void printHelp() {
        formatter.printHelp(this.getFullName() + " <Connector ID> [OPTIONS...]", this.options);
    }

    public void createOptions() {
        Option option = new Option(null, "action", true, "Action: update (default), approve, reject, enable, disable.");
        option.setArgName("action");
        this.options.addOption(option);
        option = new Option(null, "input", true, "Input file containing connector properties.");
        option.setArgName("file");
        this.options.addOption(option);
    }

    public void execute(CommandLine cmd) throws Exception {
        ConnectorData connectorData;
        String[] cmdArgs = cmd.getArgs();
        if (cmdArgs.length != 1) {
            throw new Exception("No Connector ID specified.");
        }
        String connectorID = cmdArgs[0];
        String action = cmd.getOptionValue("action", "update");
        String input = cmd.getOptionValue("input");
        MainCLI mainCLI = (MainCLI)this.getRoot();
        mainCLI.init();
        ConnectorClient connectorClient = this.connectorCLI.getConnectorClient();
        if (action.equals("update")) {
            if (input == null) {
                throw new Exception("Missing input file");
            }
            try (BufferedReader in = new BufferedReader(new FileReader(input));
                 StringWriter sw = new StringWriter();
                 PrintWriter out = new PrintWriter((Writer)sw, true);){
                String line;
                while ((line = in.readLine()) != null) {
                    out.println(line);
                }
                connectorData = (ConnectorData)JSONSerializer.fromJSON((String)sw.toString(), ConnectorData.class);
            }
            connectorData = connectorClient.updateConnector(connectorID, connectorData);
        } else {
            connectorData = connectorClient.changeConnectorStatus(connectorID, action);
        }
        MainCLI.printMessage("Modified connector \"" + connectorID + "\"");
        ConnectorCLI.printConnectorData(connectorData, true);
    }
}

