/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.authentication;

import com.netscape.certsrv.authentication.EAuthException;
import com.netscape.cms.authentication.AVAPattern;
import com.netscape.cmscore.apps.CMS;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.StringReader;
import java.util.Vector;
import netscape.ldap.LDAPEntry;

class RDNPattern {
    private String[] mLdapAttrs = null;
    protected AVAPattern[] mAVAPatterns = null;
    protected String mPatternString = null;
    protected String mTestDN = null;

    public RDNPattern(String pattern) throws EAuthException {
        if (pattern == null || pattern.equals("")) {
            this.mLdapAttrs = new String[]{"dn"};
        } else {
            this.mPatternString = pattern;
            PushbackReader in = new PushbackReader(new StringReader(pattern));
            this.parse(in);
        }
    }

    public RDNPattern(PushbackReader in) throws EAuthException {
        this.parse(in);
    }

    private void parse(PushbackReader in) throws EAuthException {
        int lastChar;
        Vector<AVAPattern> avaPatterns = new Vector<AVAPattern>();
        AVAPattern avaPattern = null;
        do {
            avaPattern = new AVAPattern(in);
            avaPatterns.addElement(avaPattern);
            try {
                lastChar = in.read();
            }
            catch (IOException e) {
                throw new EAuthException(CMS.getUserMessage("CMS_AUTHENTICATION_INTERNAL_ERROR", e.toString()));
            }
        } while (lastChar == 43);
        if (lastChar != -1) {
            try {
                in.unread(lastChar);
            }
            catch (IOException e) {
                throw new EAuthException(CMS.getUserMessage("CMS_AUTHENTICATION_INTERNAL_ERROR", e.toString()));
            }
        }
        this.mAVAPatterns = new AVAPattern[avaPatterns.size()];
        avaPatterns.copyInto(this.mAVAPatterns);
        Vector<String> ldapAttrs = new Vector<String>();
        for (int i = 0; i < this.mAVAPatterns.length; ++i) {
            String avaAttr = this.mAVAPatterns[i].getLdapAttr();
            if (avaAttr == null || avaAttr.length() == 0) continue;
            ldapAttrs.addElement(avaAttr);
        }
        this.mLdapAttrs = new String[ldapAttrs.size()];
        ldapAttrs.copyInto(this.mLdapAttrs);
    }

    public String formRDN(LDAPEntry entry) throws EAuthException {
        StringBuffer formedRDN = new StringBuffer();
        for (int i = 0; i < this.mAVAPatterns.length; ++i) {
            String ava;
            if (this.mTestDN != null) {
                this.mAVAPatterns[i].mTestDN = this.mTestDN;
            }
            if ((ava = this.mAVAPatterns[i].formAVA(entry)) == null || ava.length() <= 0) continue;
            if (formedRDN.length() != 0) {
                formedRDN.append("+");
            }
            formedRDN.append(ava);
        }
        return formedRDN.toString();
    }

    public String[] getLdapAttrs() {
        return (String[])this.mLdapAttrs.clone();
    }
}

