/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.cert;

import com.netscape.certsrv.cert.CertSearchRequest;
import com.netscape.cmsutil.ldap.LDAPUtil;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.StringTokenizer;

public class FilterBuilder {
    private List<String> filters = new ArrayList<String>();
    private CertSearchRequest request;

    public FilterBuilder(CertSearchRequest request) {
        this.request = request;
    }

    public String buildFilter() {
        this.buildIssuerDNFilter();
        this.buildSerialNumberRangeFilter();
        this.buildSubjectFilter();
        this.buildStatusFilter();
        this.buildRevokedByFilter();
        this.buildRevokedOnFilter();
        this.buildRevocationReasonFilter();
        this.buildIssuedByFilter();
        this.buildIssuedOnFilter();
        this.buildValidNotBeforeFilter();
        this.buildValidNotAfterFilter();
        this.buildValidityLengthFilter();
        this.buildCertTypeFilter();
        if (this.filters.size() == 0) {
            return "(certstatus=*)";
        }
        if (this.filters.size() == 1) {
            return this.filters.get(0);
        }
        StringBuilder sb = new StringBuilder();
        for (String filter : this.filters) {
            sb.append(filter);
        }
        return "(&" + sb + ")";
    }

    private void buildIssuerDNFilter() {
        String issuerDN = this.request.getIssuerDN();
        if (issuerDN != null && !issuerDN.isEmpty()) {
            this.filters.add("(x509cert.issuer=" + LDAPUtil.escapeFilter((Object)issuerDN) + ")");
        }
    }

    private void buildSerialNumberRangeFilter() {
        String serialTo;
        String serialFrom = this.request.getSerialFrom();
        if (serialFrom != null && !serialFrom.equals("")) {
            this.filters.add("(certRecordId>=" + LDAPUtil.escapeFilter((Object)serialFrom) + ")");
        }
        if ((serialTo = this.request.getSerialTo()) != null && !serialTo.equals("")) {
            this.filters.add("(certRecordId<=" + LDAPUtil.escapeFilter((Object)serialTo) + ")");
        }
    }

    private void buildSubjectFilter() {
        if (!this.request.getSubjectInUse()) {
            return;
        }
        StringBuffer lf = new StringBuffer();
        boolean match = this.request.getMatchExactly();
        this.buildAVAFilter(this.request.getEmail(), "E", lf, match);
        this.buildAVAFilter(this.request.getCommonName(), "CN", lf, match);
        this.buildAVAFilter(this.request.getUserID(), "UID", lf, match);
        this.buildAVAFilter(this.request.getOrgUnit(), "OU", lf, match);
        this.buildAVAFilter(this.request.getOrg(), "O", lf, match);
        this.buildAVAFilter(this.request.getLocality(), "L", lf, match);
        this.buildAVAFilter(this.request.getState(), "ST", lf, match);
        this.buildAVAFilter(this.request.getCountry(), "C", lf, match);
        if (lf.length() == 0) {
            this.filters.add("(x509cert.subject=*)");
        } else if (match) {
            this.filters.add("(&" + lf + ")");
        } else {
            this.filters.add("(|" + lf + ")");
        }
    }

    private void buildStatusFilter() {
        String status = this.request.getStatus();
        if (status == null || status.equals("")) {
            return;
        }
        this.filters.add("(certStatus=" + LDAPUtil.escapeFilter((Object)status) + ")");
    }

    private void buildRevokedByFilter() {
        if (!this.request.getRevokedByInUse()) {
            return;
        }
        String revokedBy = this.request.getRevokedBy();
        if (revokedBy == null || revokedBy.equals("")) {
            this.filters.add("(certRevokedBy=*)");
        } else {
            this.filters.add("(certRevokedBy=" + LDAPUtil.escapeFilter((Object)revokedBy) + ")");
        }
    }

    private void buildDateFilter(String prefix, String outStr, long adjustment) {
        if (prefix == null || prefix.length() == 0) {
            return;
        }
        long epoch = Long.parseLong(prefix);
        Calendar from = Calendar.getInstance();
        from.setTimeInMillis(epoch);
        StringBuilder filter = new StringBuilder();
        filter.append("(");
        filter.append(LDAPUtil.escapeFilter((Object)outStr));
        filter.append(Long.toString(from.getTimeInMillis() + adjustment));
        filter.append(")");
        this.filters.add(filter.toString());
    }

    private void buildRevokedOnFilter() {
        if (!this.request.getRevokedOnInUse()) {
            return;
        }
        this.buildDateFilter(this.request.getRevokedOnFrom(), "certRevokedOn>=", 0L);
        this.buildDateFilter(this.request.getRevokedOnTo(), "certRevokedOn<=", 86399999L);
    }

    private void buildRevocationReasonFilter() {
        if (!this.request.getRevocationReasonInUse()) {
            return;
        }
        String reasons = this.request.getRevocationReason();
        if (reasons == null) {
            return;
        }
        StringBuilder filter = new StringBuilder();
        StringTokenizer st = new StringTokenizer(reasons, ",");
        int count = st.countTokens();
        if (st.hasMoreTokens()) {
            if (count >= 2) {
                filter.append("(|");
            }
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                filter.append("(x509cert.certRevoInfo=");
                filter.append(LDAPUtil.escapeFilter((Object)token));
                filter.append(")");
            }
            if (count >= 2) {
                filter.append(")");
            }
        }
        this.filters.add(filter.toString());
    }

    private void buildIssuedByFilter() {
        if (!this.request.getIssuedByInUse()) {
            return;
        }
        String issuedBy = this.request.getIssuedBy();
        if (issuedBy == null || issuedBy.equals("")) {
            this.filters.add("(certIssuedBy=*)");
        } else {
            this.filters.add("(certIssuedBy=" + LDAPUtil.escapeFilter((Object)issuedBy) + ")");
        }
    }

    private void buildIssuedOnFilter() {
        if (!this.request.getIssuedOnInUse()) {
            return;
        }
        this.buildDateFilter(this.request.getIssuedOnFrom(), "certCreateTime>=", 0L);
        this.buildDateFilter(this.request.getIssuedOnTo(), "certCreateTime<=", 86399999L);
    }

    private void buildValidNotBeforeFilter() {
        if (!this.request.getValidNotBeforeInUse()) {
            return;
        }
        this.buildDateFilter(this.request.getValidNotBeforeFrom(), "x509cert.notBefore>=", 0L);
        this.buildDateFilter(this.request.getValidNotBeforeTo(), "x509cert.notBefore<=", 86399999L);
    }

    private void buildValidNotAfterFilter() {
        if (!this.request.getValidNotAfterInUse()) {
            return;
        }
        this.buildDateFilter(this.request.getValidNotAfterFrom(), "x509cert.notAfter>=", 0L);
        this.buildDateFilter(this.request.getValidNotAfterTo(), "x509cert.notAfter<=", 86399999L);
    }

    private void buildValidityLengthFilter() {
        if (!this.request.getValidityLengthInUse()) {
            return;
        }
        String op = this.request.getValidityOperation();
        Integer count = this.request.getValidityCount();
        Long unit = this.request.getValidityUnit();
        StringBuilder filter = new StringBuilder();
        filter.append("(");
        filter.append("x509cert.duration");
        filter.append(LDAPUtil.escapeFilter((Object)op));
        filter.append((long)count.intValue() * unit);
        filter.append(")");
        this.filters.add(filter.toString());
    }

    private void buildCertTypeFilter() {
        if (!this.request.getCertTypeInUse()) {
            return;
        }
        if (this.isOn(this.request.getCertTypeSSLClient())) {
            this.filters.add("(x509cert.nsExtension.SSLClient=on)");
        } else if (this.isOff(this.request.getCertTypeSSLClient())) {
            this.filters.add("(x509cert.nsExtension.SSLClient=off)");
        }
        if (this.isOn(this.request.getCertTypeSSLServer())) {
            this.filters.add("(x509cert.nsExtension.SSLServer=on)");
        } else if (this.isOff(this.request.getCertTypeSSLServer())) {
            this.filters.add("(x509cert.nsExtension.SSLServer=off)");
        }
        if (this.isOn(this.request.getCertTypeSecureEmail())) {
            this.filters.add("(x509cert.nsExtension.SecureEmail=on)");
        } else if (this.isOff(this.request.getCertTypeSecureEmail())) {
            this.filters.add("(x509cert.nsExtension.SecureEmail=off)");
        }
        if (this.isOn(this.request.getCertTypeSubSSLCA())) {
            this.filters.add("(x509cert.nsExtension.SubordinateSSLCA=on)");
        } else if (this.isOff(this.request.getCertTypeSubSSLCA())) {
            this.filters.add("(x509cert.nsExtension.SubordinateSSLCA=off)");
        }
        if (this.isOn(this.request.getCertTypeSubEmailCA())) {
            this.filters.add("(x509cert.nsExtension.SubordinateEmailCA=on)");
        } else if (this.isOff(this.request.getCertTypeSubEmailCA())) {
            this.filters.add("(x509cert.nsExtension.SubordinateEmailCA=off)");
        }
    }

    private boolean isOn(String value) {
        return value != null && value.equals("on");
    }

    private boolean isOff(String value) {
        return value != null && value.equals("off");
    }

    private void buildAVAFilter(String param, String avaName, StringBuffer lf, boolean match) {
        if (param != null && !param.equals("")) {
            if (match) {
                lf.append("(|");
                lf.append("(x509cert.subject=*");
                lf.append(avaName);
                lf.append("=");
                lf.append(LDAPUtil.escapeFilter((Object)LDAPUtil.escapeRDNValue((Object)param)));
                lf.append(",*)");
                lf.append("(x509cert.subject=*");
                lf.append(avaName);
                lf.append("=");
                lf.append(LDAPUtil.escapeFilter((Object)LDAPUtil.escapeRDNValue((Object)param)));
                lf.append(")");
                lf.append(")");
            } else {
                lf.append("(x509cert.subject=*");
                lf.append(avaName);
                lf.append("=");
                lf.append("*");
                lf.append(LDAPUtil.escapeFilter((Object)LDAPUtil.escapeRDNValue((Object)param)));
                lf.append("*)");
            }
        }
    }
}

