/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.util;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.cmscore.apps.CMS;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.cert.X509Certificate;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.BMPString;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.SET;
import org.mozilla.jss.crypto.KeyGenerator;
import org.mozilla.jss.crypto.PBEAlgorithm;
import org.mozilla.jss.pkcs12.AuthenticatedSafes;
import org.mozilla.jss.pkcs12.CertBag;
import org.mozilla.jss.pkcs12.PFX;
import org.mozilla.jss.pkcs12.PasswordConverter;
import org.mozilla.jss.pkcs12.SafeBag;
import org.mozilla.jss.pkix.primitive.EncryptedPrivateKeyInfo;
import org.mozilla.jss.pkix.primitive.PrivateKeyInfo;
import org.mozilla.jss.util.Password;

public class PFXUtils {
    public static byte[] createPFX(String pwd, X509Certificate x509cert, byte[] privateKeyInfo) throws EBaseException {
        Password pass = new Password(pwd.toCharArray());
        try {
            SEQUENCE encSafeContents = new SEQUENCE();
            OCTET_STRING cert = new OCTET_STRING(x509cert.getEncoded());
            byte[] localKeyId = PFXUtils.createLocalKeyId(x509cert);
            SET certAttrs = PFXUtils.createBagAttrs(x509cert.getSubjectDN().toString(), localKeyId);
            SafeBag certBag = new SafeBag(SafeBag.CERT_BAG, (ASN1Value)new CertBag(CertBag.X509_CERT_TYPE, (ASN1Value)cert), certAttrs);
            encSafeContents.addElement((ASN1Value)certBag);
            SEQUENCE safeContents = new SEQUENCE();
            PasswordConverter passConverter = new PasswordConverter();
            byte[] salt = new byte[]{1, 1, 1, 1};
            PrivateKeyInfo pki = (PrivateKeyInfo)ASN1Util.decode((ASN1Template)PrivateKeyInfo.getTemplate(), (byte[])privateKeyInfo);
            EncryptedPrivateKeyInfo key = EncryptedPrivateKeyInfo.createPBE((PBEAlgorithm)PBEAlgorithm.PBE_SHA1_DES3_CBC, (Password)pass, (byte[])salt, (int)1, (KeyGenerator.CharToByteConverter)passConverter, (PrivateKeyInfo)pki);
            SET keyAttrs = PFXUtils.createBagAttrs(x509cert.getSubjectDN().toString(), localKeyId);
            SafeBag keyBag = new SafeBag(SafeBag.PKCS8_SHROUDED_KEY_BAG, (ASN1Value)key, keyAttrs);
            safeContents.addElement((ASN1Value)keyBag);
            AuthenticatedSafes authSafes = new AuthenticatedSafes();
            authSafes.addSafeContents(safeContents);
            authSafes.addSafeContents(encSafeContents);
            PFX pfx = new PFX(authSafes);
            pfx.computeMacData(pass, null, 5);
            ByteArrayOutputStream fos = new ByteArrayOutputStream();
            pfx.encode((OutputStream)fos);
            byte[] byArray = fos.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_INTERNAL_ERROR", "Failed to create PKCS12 - " + e.toString()));
        }
        finally {
            pass.clear();
        }
    }

    public static byte[] createLocalKeyId(X509Certificate cert) throws EBaseException {
        try {
            byte[] certDer = cert.getEncoded();
            MessageDigest md = MessageDigest.getInstance("SHA");
            md.update(certDer);
            return md.digest();
        }
        catch (Exception e) {
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_INTERNAL_ERROR", "Failed to create Key ID - " + e.toString()));
        }
    }

    public static SET createBagAttrs(String nickName, byte[] localKeyId) throws EBaseException {
        try {
            SET attrs = new SET();
            SEQUENCE nickNameAttr = new SEQUENCE();
            nickNameAttr.addElement((ASN1Value)SafeBag.FRIENDLY_NAME);
            SET nickNameSet = new SET();
            nickNameSet.addElement((ASN1Value)new BMPString(nickName));
            nickNameAttr.addElement((ASN1Value)nickNameSet);
            attrs.addElement((ASN1Value)nickNameAttr);
            SEQUENCE localKeyAttr = new SEQUENCE();
            localKeyAttr.addElement((ASN1Value)SafeBag.LOCAL_KEY_ID);
            SET localKeySet = new SET();
            localKeySet.addElement((ASN1Value)new OCTET_STRING(localKeyId));
            localKeyAttr.addElement((ASN1Value)localKeySet);
            attrs.addElement((ASN1Value)localKeyAttr);
            return attrs;
        }
        catch (Exception e) {
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_INTERNAL_ERROR", "Failed to create Key Bag - " + e.toString()));
        }
    }
}

