/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.certsrv.client;

import com.netscape.certsrv.client.PKIClient;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;

public class Client {
    public PKIClient client;
    public String subsystem;
    public String prefix;
    public String name;
    public LinkedHashMap<String, Client> clients = new LinkedHashMap();

    public Client(PKIClient client, String subsystem, String name) {
        this(client, subsystem, "rest", name);
    }

    public Client(PKIClient client, String subsystem, String prefix, String name) {
        this.client = client;
        this.subsystem = subsystem;
        this.prefix = prefix;
        this.name = name;
    }

    public String getSubsystem() {
        return this.subsystem;
    }

    public String getName() {
        return this.name;
    }

    public void addClient(Client client) {
        this.clients.put(client.getName(), client);
    }

    public Client getClient(String name) {
        return this.clients.get(name);
    }

    public void removeClient(String name) {
        this.clients.remove(name);
    }

    public String getTargetPath(String suffix) {
        StringBuilder sb = new StringBuilder(this.subsystem);
        if (this.prefix != null) {
            sb.append("/").append(this.prefix);
        }
        if (this.name != null) {
            sb.append("/").append(this.name);
        }
        if (suffix != null) {
            sb.append("/").append(suffix);
        }
        return sb.toString();
    }

    public WebTarget target(String suffix, Map<String, Object> params) {
        String path = this.getTargetPath(suffix);
        return this.client.target(path, params);
    }

    public <T> T get(Class<T> responseType) throws Exception {
        return this.get(null, responseType);
    }

    public <T> T get(String suffix, Class<T> responseType) throws Exception {
        return this.get(suffix, null, responseType);
    }

    public <T> T get(String suffix, Map<String, Object> params, Class<T> responseType) throws Exception {
        String path = this.getTargetPath(suffix);
        return this.client.get(path, params, responseType);
    }

    public <T> T get(String suffix, Map<String, Object> params, GenericType<T> responseType) throws Exception {
        String path = this.getTargetPath(suffix);
        return this.client.get(path, params, responseType);
    }

    public <T> T post(Class<T> responseType) throws Exception {
        return this.post(null, responseType);
    }

    public <T> T post(String suffix, Class<T> responseType) throws Exception {
        return this.post(suffix, null, responseType);
    }

    public <T> T post(String suffix, Map<String, Object> params, Class<T> responseType) throws Exception {
        return this.post(suffix, params, null, responseType);
    }

    public <T> T post(String suffix, Map<String, Object> params, Entity<?> entity, Class<T> responseType) throws Exception {
        String path = this.getTargetPath(suffix);
        return this.client.post(path, params, entity, responseType);
    }

    public <T> T put(String suffix, Map<String, Object> params, Entity<?> entity, Class<T> responseType) throws Exception {
        String path = this.getTargetPath(suffix);
        return this.client.put(path, params, entity, responseType);
    }

    public <T> T patch(String suffix, Map<String, Object> params, Entity<?> entity, Class<T> responseType) throws Exception {
        String path = this.getTargetPath(suffix);
        return this.client.patch(path, params, entity, responseType);
    }

    public <T> T delete(String suffix, Class<T> responseType) throws Exception {
        String path = this.getTargetPath(suffix);
        return this.client.delete(path, responseType);
    }

    public <T> T delete(String suffix, Map<String, Object> params, Class<T> responseType) throws Exception {
        String path = this.getTargetPath(suffix);
        return this.client.delete(path, params, responseType);
    }
}

