/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.tps.msg;

import java.util.Map;
import org.dogtagpki.tps.msg.TPSMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeginOpMsg
extends TPSMessage {
    public static Logger logger = LoggerFactory.getLogger(BeginOpMsg.class);
    private Map<String, String> extensions;

    public BeginOpMsg(TPSMessage.OpType theOp, Map<String, String> theExtensions) {
        logger.debug("BeingOp op: " + theOp + " extensions: " + theExtensions);
        this.put("operation", this.opTypeToInt(theOp));
        this.put("msg_type", this.msgTypeToInt(TPSMessage.MsgType.MSG_BEGIN_OP));
        this.extensions = theExtensions;
    }

    @Override
    public TPSMessage.OpType getOpType() {
        int opTypeInt = this.getInt("operation");
        return this.intToOpType(opTypeInt);
    }

    public Map<String, String> getExtensions() {
        return this.extensions;
    }

    public String getExtension(String extName) {
        String result = null;
        if (extName == null) {
            return result;
        }
        if (this.extensions != null) {
            result = this.extensions.get(extName);
        }
        return result;
    }
}

