/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.kra;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.dbs.keydb.KeyId;
import com.netscape.certsrv.kra.EKRAException;
import com.netscape.certsrv.logging.LogEvent;
import com.netscape.certsrv.logging.event.SecurityDataArchivalProcessedEvent;
import com.netscape.certsrv.request.RequestId;
import com.netscape.certsrv.security.IStorageKeyUnit;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.dbs.KeyRecord;
import com.netscape.cmscore.dbs.KeyRepository;
import com.netscape.cmscore.logging.Auditor;
import com.netscape.cmscore.request.Request;
import com.netscape.cmscore.security.JssSubsystem;
import com.netscape.cmsutil.crypto.CryptoUtil;
import com.netscape.kra.ArchiveOptions;
import com.netscape.kra.KeyRecoveryAuthority;
import com.netscape.kra.TransportKeyUnit;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import java.util.Hashtable;
import javax.crypto.spec.RC2ParameterSpec;
import org.dogtagpki.server.kra.KRAEngine;
import org.dogtagpki.server.kra.KRAEngineConfig;
import org.dogtagpki.server.kra.rest.KeyRequestService;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.EncryptionAlgorithm;
import org.mozilla.jss.crypto.IVParameterSpec;
import org.mozilla.jss.crypto.KeyGenAlgorithm;
import org.mozilla.jss.crypto.KeyGenerator;
import org.mozilla.jss.crypto.KeyWrapAlgorithm;
import org.mozilla.jss.crypto.PBEAlgorithm;
import org.mozilla.jss.crypto.PBEKeyGenParams;
import org.mozilla.jss.crypto.PrivateKey;
import org.mozilla.jss.crypto.SymmetricKey;
import org.mozilla.jss.netscape.security.util.DerValue;
import org.mozilla.jss.netscape.security.util.Utils;
import org.mozilla.jss.netscape.security.util.WrappingParams;
import org.mozilla.jss.netscape.security.x509.X509Key;
import org.mozilla.jss.pkcs12.PasswordConverter;
import org.mozilla.jss.pkcs7.ContentInfo;
import org.mozilla.jss.pkcs7.EncryptedContentInfo;
import org.mozilla.jss.pkix.primitive.AlgorithmIdentifier;
import org.mozilla.jss.pkix.primitive.PBEParameter;
import org.mozilla.jss.util.Password;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityDataProcessor {
    public static Logger logger = LoggerFactory.getLogger(SecurityDataProcessor.class);
    public static final String ATTR_KEY_RECORD = "keyRecord";
    public static final String ATTR_SERIALNO = "serialNumber";
    private static final String STATUS_ACTIVE = "active";
    private KeyRecoveryAuthority kra;
    private TransportKeyUnit transportUnit;
    private IStorageKeyUnit storageUnit = null;
    private KeyRepository keyRepository = null;
    private boolean useOAEPKeyWrap = false;
    private static boolean allowEncDecrypt_archival = false;
    private static boolean allowEncDecrypt_recovery = false;

    public SecurityDataProcessor(KeyRecoveryAuthority kra) {
        this.kra = kra;
        this.transportUnit = kra.getTransportKeyUnit();
        this.storageUnit = kra.getStorageKeyUnit();
        this.keyRepository = kra.getKeyRepository();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean archive(Request request) throws EBaseException {
        boolean doEncrypt;
        byte[] privateSecurityData;
        byte[] publicKey;
        WrappingParams params;
        byte[] unwrapped;
        String keyType;
        byte[] securityData;
        String auditSubjectID;
        Auditor auditor;
        String owner;
        JssSubsystem jssSubsystem;
        String realm;
        int strength;
        String algorithm;
        String dataType;
        String clientKeyId;
        RequestId requestId;
        block33: {
            SymmetricKey securitySymKey;
            block35: {
                byte[] sparams;
                byte[] secdata;
                byte[] wrappedSessionKey;
                String algStr;
                block34: {
                    requestId = request.getRequestId();
                    clientKeyId = request.getExtDataInString("clientKeyID");
                    String pkiArchiveOptions = request.getExtDataInString("req_archive_options");
                    String transWrappedSessionKey = request.getExtDataInString("req_session_key");
                    String wrappedSecurityData = request.getExtDataInString("req_security_data");
                    String algParams = request.getExtDataInString("req_algorithm_params");
                    algStr = request.getExtDataInString("req_algorithm_oid");
                    dataType = request.getExtDataInString("dataType");
                    algorithm = request.getExtDataInString("algorithm");
                    strength = request.getExtDataInInteger("strength");
                    realm = request.getRealm();
                    logger.debug("SecurityDataProcessor.archive. Request id: " + requestId);
                    logger.debug("SecurityDataProcessor.archive wrappedSecurityData: " + wrappedSecurityData);
                    KRAEngine engine = KRAEngine.getInstance();
                    jssSubsystem = engine.getJSSSubsystem();
                    KRAEngineConfig config = null;
                    try {
                        config = engine.getConfig();
                        allowEncDecrypt_archival = config.getBoolean("kra.allowEncDecrypt.archival", false);
                        this.useOAEPKeyWrap = config.getUseOAEPKeyWrap();
                    }
                    catch (Exception e) {
                        throw new EBaseException(CMS.getUserMessage((String)"CMS_BASE_CERT_ERROR", (String[])new String[]{e.toString()}));
                    }
                    owner = request.getExtDataInString("requestOwner");
                    auditor = engine.getAuditor();
                    auditSubjectID = owner;
                    if (clientKeyId == null || dataType == null) {
                        auditor.log((LogEvent)SecurityDataArchivalProcessedEvent.createFailureEvent((String)auditSubjectID, null, (RequestId)requestId, (String)clientKeyId, null, (String)"Bad data in request", null));
                        throw new EBaseException("Bad data in SecurityDataService.serviceRequest");
                    }
                    if (wrappedSecurityData != null) {
                        if (transWrappedSessionKey == null || algStr == null || algParams == null) {
                            throw new EBaseException("Bad data in SecurityDataService.serviceRequest, no session key");
                        }
                    } else if (pkiArchiveOptions == null) {
                        throw new EBaseException("No data to archive in SecurityDataService.serviceRequest");
                    }
                    wrappedSessionKey = null;
                    secdata = null;
                    sparams = null;
                    if (wrappedSecurityData == null) {
                        byte[] encoded = Utils.base64decode((String)pkiArchiveOptions);
                        ArchiveOptions options = ArchiveOptions.toArchiveOptions(encoded);
                        algStr = options.getSymmAlgOID();
                        wrappedSessionKey = options.getEncSymmKey();
                        secdata = options.getEncValue();
                        sparams = options.getSymmAlgParams();
                    } else {
                        wrappedSessionKey = Utils.base64decode((String)transWrappedSessionKey);
                        secdata = Utils.base64decode((String)wrappedSecurityData);
                        sparams = Utils.base64decode((String)algParams);
                    }
                    securitySymKey = null;
                    securityData = null;
                    keyType = null;
                    byte[] tmp_unwrapped = null;
                    unwrapped = null;
                    if (!dataType.equals("symmetricKey")) break block34;
                    keyType = "symmetricKey";
                    if (allowEncDecrypt_archival) {
                        try {
                            tmp_unwrapped = this.transportUnit.decryptExternalPrivate(wrappedSessionKey, algStr, sparams, secdata, null);
                        }
                        catch (Exception e) {
                            throw new EBaseException("Unable to decrypt symmetric key with kra.allowEncDecrypt.archival=true: " + e.getMessage(), (Throwable)e);
                        }
                        int first = 0;
                        for (int j = 0; j < tmp_unwrapped.length && tmp_unwrapped[j] == 0; ++first, ++j) {
                        }
                        unwrapped = Arrays.copyOfRange(tmp_unwrapped, first, tmp_unwrapped.length);
                        jssSubsystem.obscureBytes(tmp_unwrapped);
                        break block35;
                    } else {
                        try {
                            securitySymKey = this.transportUnit.unwrap_symmetric(wrappedSessionKey, algStr, sparams, secdata, KeyRequestService.SYMKEY_TYPES.get(algorithm), strength);
                        }
                        catch (Exception e) {
                            throw new EBaseException("Unable to decrypt symmetric key: " + e.getMessage(), (Throwable)e);
                        }
                    }
                }
                if (dataType.equals("passPhrase")) {
                    keyType = "passPhrase";
                    try {
                        securityData = this.transportUnit.decryptExternalPrivate(wrappedSessionKey, algStr, sparams, secdata, null);
                    }
                    catch (Exception e) {
                        throw new EBaseException("Unable to decrypt passphrase: " + e.getMessage(), (Throwable)e);
                    }
                }
            }
            params = null;
            publicKey = null;
            privateSecurityData = null;
            doEncrypt = false;
            try {
                params = this.storageUnit.getWrappingParams(allowEncDecrypt_archival);
                if (securitySymKey != null && unwrapped == null) {
                    privateSecurityData = this.storageUnit.wrap(securitySymKey, params);
                    break block33;
                }
                if (unwrapped != null && allowEncDecrypt_archival) {
                    privateSecurityData = this.storageUnit.encryptInternalPrivate(unwrapped, params);
                    doEncrypt = true;
                    logger.debug("allowEncDecrypt_archival of symmetric key.");
                } else {
                    if (securityData == null) {
                        auditor.log((LogEvent)SecurityDataArchivalProcessedEvent.createFailureEvent((String)auditSubjectID, null, (RequestId)requestId, (String)clientKeyId, null, (String)"Failed to create security data to archive", null));
                        throw new EBaseException("Failed to create security data to archive!");
                    }
                    privateSecurityData = this.storageUnit.encryptInternalPrivate(securityData, params);
                    doEncrypt = true;
                }
            }
            catch (Exception e) {
                try {
                    logger.error("Failed to create security data to archive: " + e.getMessage(), (Throwable)e);
                    auditor.log((LogEvent)SecurityDataArchivalProcessedEvent.createFailureEvent((String)auditSubjectID, null, (RequestId)requestId, (String)clientKeyId, null, (String)CMS.getUserMessage((String)"CMS_KRA_INVALID_PRIVATE_KEY", (String[])new String[0]), null));
                    throw new EBaseException(CMS.getUserMessage((String)"CMS_KRA_INVALID_PRIVATE_KEY", (String[])new String[0]));
                }
                catch (Throwable throwable) {
                    jssSubsystem.obscureBytes(securityData);
                    jssSubsystem.obscureBytes(unwrapped);
                    throw throwable;
                }
            }
        }
        jssSubsystem.obscureBytes(securityData);
        jssSubsystem.obscureBytes(unwrapped);
        KeyRecord rec = new KeyRecord(null, publicKey, privateSecurityData, owner, null, owner);
        rec.set("clientId", (Object)clientKeyId);
        if (rec.getSerialNumber() != null) {
            auditor.log((LogEvent)SecurityDataArchivalProcessedEvent.createFailureEvent((String)auditSubjectID, null, (RequestId)requestId, (String)clientKeyId, null, (String)CMS.getUserMessage((String)"CMS_KRA_INVALID_STATE", (String[])new String[0]), null));
            throw new EBaseException(CMS.getUserMessage((String)"CMS_KRA_INVALID_STATE", (String[])new String[0]));
        }
        BigInteger serialNo = this.keyRepository.getNextSerialNumber();
        if (serialNo == null) {
            logger.error(CMS.getLogMessage((String)"CMSCORE_KRA_GET_NEXT_SERIAL", (Object[])new Object[0]));
            auditor.log((LogEvent)SecurityDataArchivalProcessedEvent.createFailureEvent((String)auditSubjectID, null, (RequestId)requestId, (String)clientKeyId, null, (String)"Failed to get  next Key ID", null));
            throw new EBaseException(CMS.getUserMessage((String)"CMS_KRA_INVALID_STATE", (String[])new String[0]));
        }
        rec.set("keySerialNumber", (Object)serialNo);
        rec.set("dataType", (Object)keyType);
        rec.set("status", (Object)STATUS_ACTIVE);
        if (dataType.equals("symmetricKey")) {
            rec.set("algorithm", (Object)algorithm);
            rec.set("keySize", (Object)strength);
        }
        if (realm != null) {
            rec.set("realm", (Object)realm);
        }
        try {
            rec.setWrappingParams(params, doEncrypt);
        }
        catch (Exception e) {
            logger.error("Unable to store wrapping parameters: " + e.getMessage(), (Throwable)e);
            auditor.log((LogEvent)SecurityDataArchivalProcessedEvent.createFailureEvent((String)auditSubjectID, null, (RequestId)requestId, (String)clientKeyId, null, (String)"Failed to store wrapping parameters", null));
            throw new EBaseException(CMS.getUserMessage((String)"CMS_KRA_INVALID_STATE", (String[])new String[0]), (Throwable)e);
        }
        logger.debug("KRA adding Security Data key record " + serialNo);
        this.keyRepository.addKeyRecord(rec);
        auditor.log((LogEvent)SecurityDataArchivalProcessedEvent.createSuccessEvent((String)auditSubjectID, null, (RequestId)requestId, (String)clientKeyId, (KeyId)new KeyId(serialNo), null));
        request.setExtData(ATTR_KEY_RECORD, serialNo);
        request.setExtData("Result", Request.RES_SUCCESS);
        return true;
    }

    public boolean recover(Request request) throws EBaseException {
        WrappingParams wrapParams;
        String ivStr_wrap;
        String ivStr;
        Boolean encrypted;
        byte[] unwrappedSecData;
        String dataType;
        Hashtable<String, Object> params;
        JssSubsystem jssSubsystem;
        block63: {
            byte[] key_data;
            CryptoToken ct;
            PrivateKey privateKey;
            SymmetricKey symKey;
            SymmetricKey unwrappedSess;
            byte[] wrappedSessKey;
            block62: {
                byte[] unwrappedPass;
                block61: {
                    logger.debug("SecurityDataService.recover(): start");
                    KRAEngine engine = KRAEngine.getInstance();
                    jssSubsystem = engine.getJSSSubsystem();
                    KRAEngineConfig config = null;
                    try {
                        config = engine.getConfig();
                        allowEncDecrypt_recovery = config.getBoolean("kra.allowEncDecrypt.recovery", false);
                        this.useOAEPKeyWrap = config.getUseOAEPKeyWrap();
                    }
                    catch (Exception e) {
                        throw new EBaseException(CMS.getUserMessage((String)"CMS_BASE_CERT_ERROR", (String[])new String[]{e.toString()}));
                    }
                    params = this.kra.getVolatileRequest(request.getRequestId());
                    KeyId keyId = new KeyId(request.getExtDataInBigInteger(ATTR_SERIALNO));
                    request.setExtData(ATTR_KEY_RECORD, keyId.toBigInteger());
                    if (params == null) {
                        logger.error("SecurityDataProcessor.recover(): Can't get volatile params.");
                        throw new EBaseException("Can't obtain volatile params!");
                    }
                    String transWrappedSessKeyStr = (String)params.get("transWrappedSessionKey");
                    wrappedSessKey = null;
                    if (transWrappedSessKeyStr != null) {
                        wrappedSessKey = Utils.base64decode((String)transWrappedSessKeyStr);
                    }
                    String sessWrappedPassPhraseStr = (String)params.get("sessionWrappedPassphrase");
                    byte[] wrappedPassPhrase = null;
                    if (sessWrappedPassPhraseStr != null) {
                        wrappedPassPhrase = Utils.base64decode((String)sessWrappedPassPhraseStr);
                    }
                    if (transWrappedSessKeyStr == null && sessWrappedPassPhraseStr == null) {
                        logger.warn("SecurityDataProcessor.recover(): No params provided.");
                        return false;
                    }
                    KeyRecord keyRecord = this.keyRepository.readKeyRecord(keyId.toBigInteger());
                    dataType = (String)keyRecord.get("dataType");
                    if (dataType == null) {
                        dataType = "asymmetricKey";
                    }
                    unwrappedSess = null;
                    symKey = null;
                    unwrappedSecData = null;
                    privateKey = null;
                    encrypted = keyRecord.isEncrypted();
                    if (encrypted == null) {
                        encrypted = allowEncDecrypt_recovery;
                    }
                    if (dataType.equals("symmetricKey")) {
                        if (encrypted.booleanValue()) {
                            logger.debug("Recover symmetric key by decrypting as per allowEncDecrypt_recovery: true.");
                            unwrappedSecData = this.recoverSecurityData(keyRecord);
                        } else {
                            symKey = this.recoverSymKey(keyRecord);
                        }
                    } else if (dataType.equals("passPhrase")) {
                        unwrappedSecData = this.recoverSecurityData(keyRecord);
                    } else if (dataType.equals("asymmetricKey")) {
                        try {
                            if (encrypted.booleanValue()) {
                                logger.debug("Recover asymmetric key by decrypting as per allowEncDecrypt_recovery: true.");
                                unwrappedSecData = this.recoverSecurityData(keyRecord);
                            }
                            byte[] publicKeyData = keyRecord.getPublicKeyData();
                            byte[] privateKeyData = keyRecord.getPrivateKeyData();
                            PublicKey publicKey = X509Key.parsePublicKey((DerValue)new DerValue(publicKeyData));
                            privateKey = this.storageUnit.unwrap(privateKeyData, publicKey, true, keyRecord.getWrappingParams(this.storageUnit.getOldWrappingParams()));
                        }
                        catch (Exception e) {
                            throw new EBaseException("Cannot fetch the private key from the database.", (Throwable)e);
                        }
                    } else {
                        throw new EBaseException("Invalid data type stored in the database.");
                    }
                    ct = this.transportUnit.getToken();
                    String payloadEncryptOID = (String)params.get("payloadEncryptionOID");
                    String payloadWrapName = (String)params.get("payloadWrappingName");
                    String transportKeyAlgo = this.transportUnit.getCertificate().getPublicKey().getAlgorithm();
                    if (allowEncDecrypt_recovery) {
                        if (payloadWrapName == null) {
                            payloadWrapName = "DES3/CBC/Pad";
                        } else if (payloadWrapName.equals("AES KeyWrap/Padding") || payloadWrapName.equals("AES KeyWrap")) {
                            payloadWrapName = "AES/CBC/PKCS5Padding";
                        }
                    }
                    byte[] iv = null;
                    byte[] iv_wrap = null;
                    try {
                        iv = this.generate_iv(payloadEncryptOID, this.transportUnit.getOldWrappingParams().getPayloadEncryptionAlgorithm());
                        iv_wrap = this.generate_wrap_iv(payloadWrapName, this.transportUnit.getOldWrappingParams().getPayloadWrapAlgorithm());
                    }
                    catch (Exception e1) {
                        jssSubsystem.obscureBytes(unwrappedSecData);
                        throw new EBaseException("Failed to generate IV when wrapping secret", (Throwable)e1);
                    }
                    ivStr = iv != null ? Utils.base64encode((byte[])iv, (boolean)false) : null;
                    ivStr_wrap = iv_wrap != null ? Utils.base64encode((byte[])iv_wrap, (boolean)false) : null;
                    wrapParams = null;
                    if (payloadEncryptOID == null) {
                        wrapParams = this.transportUnit.getOldWrappingParams();
                        wrapParams.setPayloadEncryptionIV(new IVParameterSpec(iv));
                        wrapParams.setPayloadWrappingIV(new IVParameterSpec(iv_wrap));
                    } else {
                        try {
                            wrapParams = new WrappingParams(payloadEncryptOID, payloadWrapName, transportKeyAlgo, iv != null ? new IVParameterSpec(iv) : null, iv_wrap != null ? new IVParameterSpec(iv_wrap) : null);
                        }
                        catch (Exception e) {
                            jssSubsystem.obscureBytes(unwrappedSecData);
                            throw new EBaseException("Cannot generate wrapping params: " + e, (Throwable)e);
                        }
                    }
                    logger.debug("keyWrap.useOAEP=" + this.useOAEPKeyWrap);
                    logger.debug("wrapParams.getSkWrapAlgorithm()=" + wrapParams.getSkWrapAlgorithm());
                    if (this.useOAEPKeyWrap && wrapParams.getSkWrapAlgorithm() == KeyWrapAlgorithm.RSA) {
                        logger.debug("Upgrading RSA SkWrapAlgorithm to RSA_OAEP: keyWrap.useOAEP=true");
                        wrapParams.setSkWrapAlgorithm(KeyWrapAlgorithm.RSA_OAEP);
                    }
                    key_data = null;
                    String pbeWrappedData = null;
                    if (sessWrappedPassPhraseStr == null) break block62;
                    logger.debug("SecurityDataProcessor.recover(): secure retrieved data with tranport passphrase");
                    unwrappedPass = null;
                    Password pass = null;
                    try {
                        unwrappedSess = this.transportUnit.unwrap_session_key(ct, wrappedSessKey, SymmetricKey.Usage.DECRYPT, wrapParams);
                        unwrappedPass = CryptoUtil.decryptUsingSymmetricKey((CryptoToken)ct, (IVParameterSpec)wrapParams.getPayloadEncryptionIV(), (byte[])wrappedPassPhrase, (SymmetricKey)unwrappedSess, (EncryptionAlgorithm)wrapParams.getPayloadEncryptionAlgorithm());
                        char[] passChars = CryptoUtil.bytesToChars((byte[])unwrappedPass);
                        pass = new Password(passChars);
                        jssSubsystem.obscureChars(passChars);
                        if (dataType.equals("symmetricKey")) {
                            logger.debug("SecurityDataProcessor.recover(): wrap or encrypt stored symmetric key with transport passphrase");
                            if (encrypted.booleanValue()) {
                                logger.debug("SecurityDataProcessor.recover(): allowEncDecyypt_recovery: true, symmetric key:  create blob with unwrapped key.");
                                pbeWrappedData = SecurityDataProcessor.createEncryptedContentInfo(ct, null, unwrappedSecData, null, pass);
                            } else {
                                pbeWrappedData = SecurityDataProcessor.createEncryptedContentInfo(ct, symKey, null, null, pass);
                            }
                        } else if (dataType.equals("passPhrase")) {
                            logger.debug("SecurityDataProcessor.recover(): encrypt stored passphrase with transport passphrase");
                            pbeWrappedData = SecurityDataProcessor.createEncryptedContentInfo(ct, null, unwrappedSecData, null, pass);
                        } else if (dataType.equals("asymmetricKey")) {
                            if (encrypted.booleanValue()) {
                                logger.debug("SecurityDataProcessor.recover(): allowEncDecyypt_recovery: true, asymmetric key:  create blob with unwrapped key.");
                                pbeWrappedData = SecurityDataProcessor.createEncryptedContentInfo(ct, null, unwrappedSecData, null, pass);
                            } else {
                                logger.debug("SecurityDataProcessor.recover(): wrap stored private key with transport passphrase");
                                pbeWrappedData = SecurityDataProcessor.createEncryptedContentInfo(ct, null, null, privateKey, pass);
                            }
                        }
                        params.put("passPhraseWrappedData", pbeWrappedData);
                        if (pass == null) break block61;
                    }
                    catch (Exception e) {
                        try {
                            throw new EBaseException("Cannot unwrap passphrase: " + e, (Throwable)e);
                        }
                        catch (Throwable throwable) {
                            if (pass != null) {
                                pass.clear();
                            }
                            jssSubsystem.obscureBytes(unwrappedPass);
                            throw throwable;
                        }
                    }
                    pass.clear();
                }
                jssSubsystem.obscureBytes(unwrappedPass);
                break block63;
            }
            logger.debug("SecurityDataProcessor.recover(): secure retrieved data with session key");
            if (dataType.equals("symmetricKey")) {
                logger.debug("SecurityDataProcessor.recover(): wrap or encrypt stored symmetric key with session key");
                try {
                    if (encrypted.booleanValue()) {
                        logger.debug("SecurityDataProcessor.recover(): encrypt symmetric key with session key as per allowEncDecrypt_recovery: true.");
                        unwrappedSess = this.transportUnit.unwrap_session_key(ct, wrappedSessKey, SymmetricKey.Usage.ENCRYPT, wrapParams);
                        key_data = CryptoUtil.encryptUsingSymmetricKey((CryptoToken)ct, (SymmetricKey)unwrappedSess, (byte[])unwrappedSecData, (EncryptionAlgorithm)wrapParams.getPayloadEncryptionAlgorithm(), (IVParameterSpec)wrapParams.getPayloadEncryptionIV());
                    }
                    unwrappedSess = this.transportUnit.unwrap_session_key(ct, wrappedSessKey, SymmetricKey.Usage.WRAP, wrapParams);
                    key_data = CryptoUtil.wrapUsingSymmetricKey((CryptoToken)ct, (SymmetricKey)unwrappedSess, (SymmetricKey)symKey, (IVParameterSpec)wrapParams.getPayloadWrappingIV(), (KeyWrapAlgorithm)wrapParams.getPayloadWrapAlgorithm());
                }
                catch (Exception e) {
                    jssSubsystem.obscureBytes(unwrappedSecData);
                    throw new EBaseException("Cannot wrap symmetric key: " + e, (Throwable)e);
                }
            } else {
                if (dataType.equals("passPhrase")) {
                    logger.debug("SecurityDataProcessor.recover(): encrypt stored passphrase with session key");
                    try {
                        unwrappedSess = this.transportUnit.unwrap_session_key(ct, wrappedSessKey, SymmetricKey.Usage.ENCRYPT, wrapParams);
                        key_data = CryptoUtil.encryptUsingSymmetricKey((CryptoToken)ct, (SymmetricKey)unwrappedSess, (byte[])unwrappedSecData, (EncryptionAlgorithm)wrapParams.getPayloadEncryptionAlgorithm(), (IVParameterSpec)wrapParams.getPayloadEncryptionIV());
                    }
                    catch (Exception e) {
                        jssSubsystem.obscureBytes(unwrappedSecData);
                        throw new EBaseException("Cannot encrypt passphrase: " + e, (Throwable)e);
                    }
                }
                if (dataType.equals("asymmetricKey")) {
                    logger.debug("SecurityDataProcessor.recover(): wrap or encrypt stored private key with session key");
                    try {
                        if (encrypted.booleanValue()) {
                            logger.debug("SecurityDataProcessor.recover(): encrypt symmetric key.");
                            unwrappedSess = this.transportUnit.unwrap_session_key(ct, wrappedSessKey, SymmetricKey.Usage.ENCRYPT, wrapParams);
                            key_data = CryptoUtil.encryptUsingSymmetricKey((CryptoToken)ct, (SymmetricKey)unwrappedSess, (byte[])unwrappedSecData, (EncryptionAlgorithm)wrapParams.getPayloadEncryptionAlgorithm(), (IVParameterSpec)wrapParams.getPayloadEncryptionIV());
                        } else {
                            unwrappedSess = this.transportUnit.unwrap_session_key(ct, wrappedSessKey, SymmetricKey.Usage.WRAP, wrapParams);
                            key_data = CryptoUtil.wrapUsingSymmetricKey((CryptoToken)ct, (SymmetricKey)unwrappedSess, (PrivateKey)privateKey, (IVParameterSpec)wrapParams.getPayloadWrappingIV(), (KeyWrapAlgorithm)wrapParams.getPayloadWrapAlgorithm());
                        }
                    }
                    catch (Exception e) {
                        jssSubsystem.obscureBytes(unwrappedSecData);
                        throw new EBaseException("Cannot wrap private key: " + e, (Throwable)e);
                    }
                }
            }
            String wrappedKeyData = Utils.base64encode(key_data, (boolean)false);
            params.put("sessWrappedSecData", wrappedKeyData);
        }
        params.put("payloadEncryptionOID", wrapParams.getPayloadEncryptionAlgorithmName());
        params.put("payloadWrappingName", wrapParams.getPayloadWrapAlgorithm().toString());
        if (encrypted.booleanValue() || dataType.equals("passPhrase")) {
            params.put("payloadWrapped", Boolean.toString(false));
            if (wrapParams.getPayloadEncryptionIV() != null) {
                params.put("iv_out", ivStr);
            }
        } else {
            params.put("payloadWrapped", Boolean.toString(true));
            if (wrapParams.getPayloadWrappingIV() != null) {
                params.put("iv_out", ivStr_wrap);
            }
        }
        jssSubsystem.obscureBytes(unwrappedSecData);
        params.put("dataType", dataType);
        request.setExtData("Result", Request.RES_SUCCESS);
        return false;
    }

    private byte[] generate_iv(String oid, EncryptionAlgorithm defaultAlg) throws Exception {
        EncryptionAlgorithm alg;
        EncryptionAlgorithm encryptionAlgorithm = alg = oid != null ? EncryptionAlgorithm.fromOID((OBJECT_IDENTIFIER)new OBJECT_IDENTIFIER(oid)) : defaultAlg;
        if (alg == null) {
            throw new EBaseException("Cannot determine encryption algorithm to generate IV");
        }
        if (alg.getParameterClasses() == null) {
            return null;
        }
        int numBytes = alg.getIVLength();
        byte[] bytes = new byte[numBytes];
        KRAEngine engine = KRAEngine.getInstance();
        JssSubsystem jssSubsystem = engine.getJSSSubsystem();
        SecureRandom random = jssSubsystem.getRandomNumberGenerator();
        random.nextBytes(bytes);
        return bytes;
    }

    private byte[] generate_wrap_iv(String wrapName, KeyWrapAlgorithm defaultAlg) throws Exception {
        KeyWrapAlgorithm alg;
        KeyWrapAlgorithm keyWrapAlgorithm = alg = wrapName != null ? KeyWrapAlgorithm.fromString((String)wrapName) : defaultAlg;
        if (alg == null) {
            throw new EBaseException("Cannot determine keywrap algorithm to generate IV");
        }
        if (alg.getParameterClasses() == null) {
            return null;
        }
        int numBytes = alg.getBlockSize();
        byte[] bytes = new byte[numBytes];
        KRAEngine engine = KRAEngine.getInstance();
        JssSubsystem jssSubsystem = engine.getJSSSubsystem();
        SecureRandom random = jssSubsystem.getRandomNumberGenerator();
        random.nextBytes(bytes);
        return bytes;
    }

    public SymmetricKey recoverSymKey(KeyRecord keyRecord) throws EBaseException {
        try {
            SymmetricKey symKey = this.storageUnit.unwrap(keyRecord.getPrivateKeyData(), KeyRequestService.SYMKEY_TYPES.get(keyRecord.getAlgorithm()), keyRecord.getKeySize().intValue(), keyRecord.getWrappingParams(this.storageUnit.getOldWrappingParams()));
            return symKey;
        }
        catch (Exception e) {
            throw new EKRAException(CMS.getUserMessage((String)"CMS_KRA_RECOVERY_FAILED_1", (String[])new String[]{"recoverSymKey() " + e.toString()}));
        }
    }

    public byte[] recoverSecurityData(KeyRecord keyRecord) throws EBaseException {
        try {
            return this.storageUnit.decryptInternalPrivate(keyRecord.getPrivateKeyData(), keyRecord.getWrappingParams(this.storageUnit.getOldWrappingParams()));
        }
        catch (Exception e) {
            logger.error("Failed to recover security data: " + e.getMessage(), (Throwable)e);
            throw new EKRAException(CMS.getUserMessage((String)"CMS_KRA_RECOVERY_FAILED_1", (String[])new String[]{"recoverSecurityData() " + e.toString()}));
        }
    }

    private static EncryptedContentInfo createEncryptedContentInfoPBEOfKey(PBEAlgorithm keyGenAlg, Password password, byte[] salt, int iterationCount, KeyGenerator.CharToByteConverter charToByteConverter, SymmetricKey symKey, PrivateKey privateKey, CryptoToken token) throws Exception {
        if (keyGenAlg == null) {
            throw new NoSuchAlgorithmException("Key generation algorithm  is NULL");
        }
        PBEAlgorithm pbeAlg = keyGenAlg;
        KeyGenerator kg = token.getKeyGenerator((KeyGenAlgorithm)keyGenAlg);
        PBEKeyGenParams pbekgParams = new PBEKeyGenParams(password, salt, iterationCount);
        if (charToByteConverter != null) {
            kg.setCharToByteConverter(charToByteConverter);
        }
        kg.initialize((AlgorithmParameterSpec)pbekgParams);
        SymmetricKey key = kg.generate();
        EncryptionAlgorithm encAlg = pbeAlg.getEncryptionAlg();
        Object params = null;
        if (encAlg.getParameterClass().equals(IVParameterSpec.class)) {
            params = new IVParameterSpec(kg.generatePBE_IV());
        } else if (encAlg.getParameterClass().equals(RC2ParameterSpec.class)) {
            params = new RC2ParameterSpec(key.getStrength(), kg.generatePBE_IV());
        }
        byte[] encrypted = null;
        if (symKey != null) {
            encrypted = CryptoUtil.wrapUsingSymmetricKey((CryptoToken)token, (SymmetricKey)key, (SymmetricKey)symKey, (IVParameterSpec)params, (KeyWrapAlgorithm)KeyWrapAlgorithm.DES3_CBC_PAD);
        } else if (privateKey != null) {
            encrypted = CryptoUtil.wrapUsingSymmetricKey((CryptoToken)token, (SymmetricKey)key, (PrivateKey)privateKey, (IVParameterSpec)params, (KeyWrapAlgorithm)KeyWrapAlgorithm.DES3_CBC_PAD);
        }
        if (encrypted == null) {
            // empty if block
        }
        PBEParameter pbeParam = new PBEParameter(salt, iterationCount);
        AlgorithmIdentifier encAlgID = new AlgorithmIdentifier(keyGenAlg.toOID(), (ASN1Value)pbeParam);
        EncryptedContentInfo encCI = new EncryptedContentInfo(ContentInfo.DATA, encAlgID, new OCTET_STRING(encrypted));
        return encCI;
    }

    private static String createEncryptedContentInfo(CryptoToken ct, SymmetricKey symKey, byte[] securityData, PrivateKey privateKey, Password password) throws EBaseException {
        EncryptedContentInfo cInfo = null;
        String retData = null;
        PBEAlgorithm keyGenAlg = PBEAlgorithm.PBE_SHA1_DES3_CBC;
        byte[] encoded = null;
        try {
            PasswordConverter passConverter = new PasswordConverter();
            byte[] salt = new byte[]{1, 1, 1, 1};
            if (symKey != null) {
                cInfo = SecurityDataProcessor.createEncryptedContentInfoPBEOfKey(keyGenAlg, password, salt, 1, (KeyGenerator.CharToByteConverter)passConverter, symKey, null, ct);
            } else if (securityData != null) {
                cInfo = EncryptedContentInfo.createPBE((PBEAlgorithm)keyGenAlg, (Password)password, (byte[])salt, (int)1, (KeyGenerator.CharToByteConverter)passConverter, (byte[])securityData);
            } else if (privateKey != null) {
                cInfo = SecurityDataProcessor.createEncryptedContentInfoPBEOfKey(keyGenAlg, password, salt, 1, (KeyGenerator.CharToByteConverter)passConverter, null, privateKey, ct);
            }
            if (cInfo == null) {
                throw new EBaseException("Can't create a PBE wrapped EncryptedContentInfo!");
            }
            ByteArrayOutputStream oStream = new ByteArrayOutputStream();
            cInfo.encode((OutputStream)oStream);
            encoded = oStream.toByteArray();
            retData = Utils.base64encode((byte[])encoded, (boolean)false);
        }
        catch (Exception e) {
            throw new EBaseException("Can't create a PBE wrapped EncryptedContentInfo! " + e.toString());
        }
        return retData;
    }
}

