/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.util;

import com.google.protobuf.Descriptors;
import com.google.protobuf.MapEntry;
import com.google.protobuf.Message;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.sonar.api.utils.text.JsonWriter;

public class ProtobufJsonFormat {
    private ProtobufJsonFormat() {
    }

    public static void write(Message message, JsonWriter writer) {
        writer.setSerializeNulls(false).setSerializeEmptys(true);
        writer.beginObject();
        ProtobufJsonFormat.writeMessage(message, writer);
        writer.endObject();
    }

    public static String toJson(Message message) {
        StringWriter json = new StringWriter();
        try (JsonWriter jsonWriter = JsonWriter.of((Writer)json);){
            ProtobufJsonFormat.write(message, jsonWriter);
        }
        return json.toString();
    }

    private static void writeMessage(Message message, JsonWriter writer) {
        MessageType type = MessageType.of(message);
        for (Descriptors.FieldDescriptor fieldDescriptor : type.fieldDescriptors) {
            if (fieldDescriptor.isRepeated()) {
                writer.name(fieldDescriptor.getName());
                if (fieldDescriptor.isMapField()) {
                    ProtobufJsonFormat.writeMap((Collection)message.getField(fieldDescriptor), writer);
                    continue;
                }
                ProtobufJsonFormat.writeArray(writer, fieldDescriptor, (Collection)message.getField(fieldDescriptor));
                continue;
            }
            if (!message.hasField(fieldDescriptor)) continue;
            writer.name(fieldDescriptor.getName());
            Object fieldValue = message.getField(fieldDescriptor);
            ProtobufJsonFormat.writeFieldValue(fieldDescriptor, fieldValue, writer);
        }
    }

    private static void writeArray(JsonWriter writer, Descriptors.FieldDescriptor fieldDescriptor, Collection array) {
        writer.beginArray();
        for (Object o : array) {
            ProtobufJsonFormat.writeFieldValue(fieldDescriptor, o, writer);
        }
        writer.endArray();
    }

    private static void writeMap(Collection<MapEntry> mapEntries, JsonWriter writer) {
        writer.beginObject();
        for (MapEntry mapEntry : mapEntries) {
            writer.name(mapEntry.getKey().toString());
            Descriptors.FieldDescriptor valueDescriptor = mapEntry.getDescriptorForType().findFieldByName("value");
            ProtobufJsonFormat.writeFieldValue(valueDescriptor, mapEntry.getValue(), writer);
        }
        writer.endObject();
    }

    private static void writeFieldValue(Descriptors.FieldDescriptor fieldDescriptor, Object value, JsonWriter writer) {
        switch (fieldDescriptor.getJavaType()) {
            case INT: {
                writer.value((Number)((Integer)value));
                break;
            }
            case LONG: {
                writer.value((Number)((Long)value));
                break;
            }
            case DOUBLE: {
                writer.value((Number)((Double)value));
                break;
            }
            case BOOLEAN: {
                writer.value(((Boolean)value).booleanValue());
                break;
            }
            case STRING: {
                writer.value((String)value);
                break;
            }
            case ENUM: {
                writer.value(((Descriptors.EnumValueDescriptor)value).getName());
                break;
            }
            case MESSAGE: {
                ProtobufJsonFormat.writeMessageValue((Message)value, writer);
                break;
            }
            default: {
                throw new IllegalStateException(String.format("JSON format does not support type '%s' of field '%s'", fieldDescriptor.getJavaType(), fieldDescriptor.getName()));
            }
        }
    }

    private static void writeMessageValue(Message message, JsonWriter writer) {
        MessageType messageType = MessageType.of(message);
        if (messageType.doesWrapRepeated) {
            Descriptors.FieldDescriptor repeatedDescriptor = messageType.fieldDescriptors[0];
            if (repeatedDescriptor.isMapField()) {
                ProtobufJsonFormat.writeMap((Collection)message.getField(repeatedDescriptor), writer);
            } else {
                ProtobufJsonFormat.writeArray(writer, repeatedDescriptor, (Collection)message.getField(repeatedDescriptor));
            }
        } else {
            writer.beginObject();
            ProtobufJsonFormat.writeMessage(message, writer);
            writer.endObject();
        }
    }

    static class MessageType {
        private static final Map<Class<? extends Message>, MessageType> TYPES_BY_CLASS = new HashMap<Class<? extends Message>, MessageType>();
        private final Descriptors.FieldDescriptor[] fieldDescriptors;
        private final boolean doesWrapRepeated;

        private MessageType(Descriptors.Descriptor descriptor) {
            this.fieldDescriptors = descriptor.getFields().toArray(new Descriptors.FieldDescriptor[descriptor.getFields().size()]);
            this.doesWrapRepeated = this.fieldDescriptors.length == 1 && this.fieldDescriptors[0].isRepeated() && descriptor.getName().equalsIgnoreCase(this.fieldDescriptors[0].getName());
        }

        static MessageType of(Message message) {
            MessageType type = TYPES_BY_CLASS.get(message.getClass());
            if (type == null) {
                type = new MessageType(message.getDescriptorForType());
                TYPES_BY_CLASS.put(message.getClass(), type);
            }
            return type;
        }
    }
}

