/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.exceptions;

import java.lang.reflect.Member;
import org.jruby.NativeException;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyString;
import org.jruby.exceptions.JumpException;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.RubyEvent;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.backtrace.RubyStackTraceElement;
import org.jruby.runtime.backtrace.TraceType;
import org.jruby.runtime.builtin.IRubyObject;

public class RaiseException
extends JumpException {
    private static final long serialVersionUID = -7612079169559973951L;
    private RubyException exception;
    private String providedMessage;

    protected RaiseException(String message2, RubyException exception2) {
        super(message2);
        this.setException(exception2);
        this.preRaise(exception2.getRuntime().getCurrentContext());
    }

    @Deprecated
    public static RaiseException from(RubyException exception2, IRubyObject backtrace2) {
        return new RaiseException(exception2, backtrace2);
    }

    public static RaiseException from(Ruby runtime2, RubyClass excptnClass, String msg) {
        return RubyException.newException(runtime2, excptnClass, msg).toThrowable();
    }

    public static RaiseException from(Ruby runtime2, RubyClass excptnClass, String msg, IRubyObject backtrace2) {
        return RubyException.newException(runtime2, excptnClass, msg).toThrowable();
    }

    @Override
    public String getMessage() {
        if (this.providedMessage == null) {
            this.providedMessage = '(' + this.exception.getMetaClass().getBaseName() + ") " + this.exception.message(this.exception.getRuntime().getCurrentContext()).asJavaString();
        }
        return this.providedMessage;
    }

    public final RubyException getException() {
        return this.exception;
    }

    private void preRaise(ThreadContext context) {
        this.preRaise(context, (IRubyObject)null);
    }

    private void preRaise(ThreadContext context, StackTraceElement[] javaTrace) {
        context.runtime.incrementExceptionCount();
        this.doSetLastError(context);
        RaiseException.doCallEventHook(context);
        if (RubyInstanceConfig.LOG_EXCEPTIONS) {
            TraceType.logException(this.exception);
        }
        if (this.requiresBacktrace(context)) {
            this.exception.prepareIntegratedBacktrace(context, javaTrace);
        }
    }

    private boolean requiresBacktrace(ThreadContext context) {
        IRubyObject debugMode;
        return context.exceptionRequiresBacktrace || (debugMode = context.runtime.getGlobalVariables().get("$DEBUG")) != null && debugMode.isTrue() || !context.runtime.getStandardError().isInstance(this.exception);
    }

    private void preRaise(ThreadContext context, IRubyObject backtrace2) {
        context.runtime.incrementExceptionCount();
        this.doSetLastError(context);
        RaiseException.doCallEventHook(context);
        if (RubyInstanceConfig.LOG_EXCEPTIONS) {
            TraceType.logException(this.exception);
        }
        if (this.requiresBacktrace(context)) {
            if (backtrace2 == null) {
                this.exception.prepareBacktrace(context);
            } else {
                this.exception.forceBacktrace(backtrace2);
                if (backtrace2.isNil()) {
                    return;
                }
            }
            this.setStackTrace(RaiseException.javaTraceFromRubyTrace(this.exception.getBacktraceElements()));
        }
    }

    private static void doCallEventHook(ThreadContext context) {
        if (context.runtime.hasEventHooks()) {
            context.runtime.callEventHooks(context, RubyEvent.RAISE, context.getFile(), context.getLine(), context.getFrameName(), context.getFrameKlazz());
        }
    }

    private void doSetLastError(ThreadContext context) {
        context.runtime.getGlobalVariables().set("$!", this.exception);
    }

    protected final void setException(RubyException newException) {
        this.exception = newException;
    }

    public static StackTraceElement[] javaTraceFromRubyTrace(RubyStackTraceElement[] trace2) {
        StackTraceElement[] newTrace = new StackTraceElement[trace2.length];
        for (int i2 = 0; i2 < newTrace.length; ++i2) {
            newTrace[i2] = trace2[i2].asStackTraceElement();
        }
        return newTrace;
    }

    @Deprecated
    public static RaiseException createNativeRaiseException(Ruby runtime2, Throwable cause2) {
        return RaiseException.createNativeRaiseException(runtime2, cause2, null);
    }

    @Deprecated
    public static RaiseException createNativeRaiseException(Ruby runtime2, Throwable cause2, Member target) {
        NativeException nativeException = new NativeException(runtime2, runtime2.getNativeException(), cause2);
        return new RaiseException(cause2, nativeException);
    }

    @Deprecated
    public RaiseException(Throwable cause2, NativeException nativeException) {
        super(nativeException.getMessageAsJavaString(), cause2);
        this.providedMessage = super.getMessage();
        this.setException(nativeException);
        this.preRaise(nativeException.getRuntime().getCurrentContext(), nativeException.getCause().getStackTrace());
        this.setStackTrace(RaiseException.javaTraceFromRubyTrace(this.exception.getBacktraceElements()));
    }

    @Deprecated
    public RaiseException(RubyException exception2) {
        this(exception2.getMessageAsJavaString(), exception2);
    }

    @Deprecated
    public RaiseException(RubyException exception2, boolean unused) {
        this(exception2.getMessageAsJavaString(), exception2);
    }

    @Deprecated
    public RaiseException(RubyException exception2, IRubyObject backtrace2) {
        this(exception2.getMessageAsJavaString(), exception2);
        this.preRaise(exception2.getRuntime().getCurrentContext(), backtrace2);
    }

    @Deprecated
    public RaiseException(Ruby runtime2, RubyClass excptnClass, String msg) {
        this(runtime2, excptnClass, msg, null);
    }

    @Deprecated
    public RaiseException(Ruby runtime2, RubyClass excptnClass, String msg, boolean unused) {
        this(runtime2, excptnClass, msg, null);
    }

    @Deprecated
    public RaiseException(Ruby runtime2, RubyClass excptnClass, String msg, IRubyObject backtrace2) {
        super(msg == null ? (msg = "No message available") : msg);
        this.providedMessage = '(' + excptnClass.getName() + ") " + msg;
        ThreadContext context = runtime2.getCurrentContext();
        this.setException((RubyException)Helpers.invoke(context, (IRubyObject)excptnClass, "new", (IRubyObject)RubyString.newUnicodeString(runtime2, msg)));
        this.preRaise(context, backtrace2);
    }

    @Deprecated
    public RaiseException(Ruby runtime2, RubyClass excptnClass, String msg, IRubyObject backtrace2, boolean unused) {
        this(runtime2, excptnClass, msg, backtrace2);
    }

    @Deprecated
    protected final void setException(RubyException newException, boolean unused) {
        this.exception = newException;
    }
}

