/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.slang.checks;

import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonarsource.slang.api.FunctionDeclarationTree;
import org.sonarsource.slang.checks.api.InitContext;
import org.sonarsource.slang.checks.api.SlangCheck;

@Rule(key="S138")
public class TooLongFunctionCheck
implements SlangCheck {
    private static final int DEFAULT_MAX = 100;
    @RuleProperty(key="max", description="Maximum authorized lines of code in a function", defaultValue="100")
    public int max = 100;

    @Override
    public void initialize(InitContext init) {
        init.register(FunctionDeclarationTree.class, (ctx, tree) -> {
            int numberOfLinesOfCode = tree.metaData().linesOfCode().size();
            if (numberOfLinesOfCode > this.max) {
                String message2 = String.format("This function has %s lines of code, which is greater than the %s authorized. Split it into smaller functions.", numberOfLinesOfCode, this.max);
                ctx.reportIssue(tree.rangeToHighlight(), message2);
            }
        });
    }
}

